/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.jreleaser.util.StringUtils;

public final class ObjectUtils {
    private static final String MESSAGE = "message";

    private ObjectUtils() {
    }

    public static void requireState(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    public static void requireState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static byte[] requireNonEmpty(byte[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static byte[] requireNonEmpty(byte[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static short[] requireNonEmpty(short[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static short[] requireNonEmpty(short[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static int[] requireNonEmpty(int[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static int[] requireNonEmpty(int[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static long[] requireNonEmpty(long[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static long[] requireNonEmpty(long[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static float[] requireNonEmpty(float[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static float[] requireNonEmpty(float[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static double[] requireNonEmpty(double[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static double[] requireNonEmpty(double[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static char[] requireNonEmpty(char[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static char[] requireNonEmpty(char[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static boolean[] requireNonEmpty(boolean[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static boolean[] requireNonEmpty(boolean[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static <E> E[] requireNonEmpty(E[] array) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0);
        return array;
    }

    public static <E> E[] requireNonEmpty(E[] array, String message) {
        Objects.requireNonNull(array);
        ObjectUtils.requireState(array.length != 0, StringUtils.requireNonBlank(message, MESSAGE));
        return array;
    }

    public static Collection<?> requireNonEmpty(Collection<?> collection) {
        Objects.requireNonNull(collection);
        ObjectUtils.requireState(!collection.isEmpty());
        return collection;
    }

    public static Collection<?> requireNonEmpty(Collection<?> collection, String message) {
        Objects.requireNonNull(collection);
        ObjectUtils.requireState(!collection.isEmpty(), StringUtils.requireNonBlank(message, MESSAGE));
        return collection;
    }

    public static Map<?, ?> requireNonEmpty(Map<?, ?> map) {
        Objects.requireNonNull(map);
        ObjectUtils.requireState(!map.isEmpty());
        return map;
    }

    public static Map<?, ?> requireNonEmpty(Map<?, ?> map, String message) {
        Objects.requireNonNull(map);
        ObjectUtils.requireState(!map.isEmpty(), StringUtils.requireNonBlank(message, MESSAGE));
        return map;
    }
}

