_This file is auto-generated. To update, make the changes in the pkg/i18n directory and then run `go generate ./...` from the project root._

# Lazygit キーバインディング

_凡例：`＜c-b＞` はctrl+b、`＜a-b＞` はalt+b、`B` はshift+bを意味します_

## グローバルキーバインド

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-r> `` | 最近のリポジトリをチェックアウト |  |
| `` <pgup> (fn+up/shift+k) `` | メインウィンドウを上にスクロール |  |
| `` <pgdown> (fn+down/shift+j) `` | メインウィンドウを下にスクロール |  |
| `` @ `` | コマンドログオプションを表示 | コマンドログのオプションを表示します（例：コマンドログの表示/非表示、コマンドログへのフォーカスなど）。 |
| `` P `` | プッシュ | 現在のブランチを対応するアップストリームブランチにプッシュします。アップストリームが設定されていない場合、アップストリームブランチの設定を求められます。 |
| `` p `` | プル | 現在のブランチのリモートから変更をプルします。アップストリームが設定されていない場合、アップストリームブランチの設定を求められます。 |
| `` ) `` | リネーム検出の類似度しきい値を上げる | Increase the similarity threshold for a deletion and addition pair to be treated as a rename.<br><br>The default can be changed in the config file with the key 'git.renameSimilarityThreshold'. |
| `` ( `` | リネーム検出の類似度しきい値を下げる | Decrease the similarity threshold for a deletion and addition pair to be treated as a rename.<br><br>The default can be changed in the config file with the key 'git.renameSimilarityThreshold'. |
| `` } `` | 差分コンテキストサイズを増やす | Increase the amount of the context shown around changes in the diff view.<br><br>The default can be changed in the config file with the key 'git.diffContextSize'. |
| `` { `` | 差分コンテキストサイズを減らす | Decrease the amount of the context shown around changes in the diff view.<br><br>The default can be changed in the config file with the key 'git.diffContextSize'. |
| `` : `` | シェルコマンドを実行 | 実行するシェルコマンドを入力するプロンプトを表示します。 |
| `` <c-p> `` | カスタムパッチオプションを表示 |  |
| `` m `` | マージ/リベースオプションを表示 | 現在のマージ/リベースを中止/継続/スキップするオプションを表示します。 |
| `` R `` | 更新 | Gitの状態を更新します（`git status`、`git branch`などをバックグラウンドで実行してパネルの内容を更新します）。これは`git fetch`を実行しません。 |
| `` + `` | 次の画面モード（通常/半分/全画面） |  |
| `` _ `` | 前の画面モード |  |
| `` <esc> `` | キャンセル |  |
| `` ? `` | キーバインディングメニューを開く |  |
| `` <c-s> `` | フィルターオプションを表示 | コミットログのフィルタリングオプションを表示し、フィルタに一致するコミットのみを表示します。 |
| `` W `` | 差分オプションを表示 | ２つのrefの差分に関連するオプションを表示します（例：選択したrefとの差分表示、差分を取るrefの入力、差分方向の反転など）。 |
| `` <c-e> `` | 差分オプションを表示 | ２つのrefの差分に関連するオプションを表示します（例：選択したrefとの差分表示、差分を取るrefの入力、差分方向の反転など）。 |
| `` q `` | 終了 |  |
| `` <c-z> `` | Suspend the application |  |
| `` <c-w> `` | 空白表示の切り替え | Toggle whether or not whitespace changes are shown in the diff view.<br><br>The default can be changed in the config file with the key 'git.ignoreWhitespaceInDiffView'. |
| `` z `` | 元に戻す | 最後のgitコマンドを元に戻すために実行するgitコマンドを決定するためにreflogが使用されます。これにはワーキングツリーへの変更は含まれません。コミットのみが考慮されます。 |
| `` Z `` | やり直す | 最後のgitコマンドをやり直すために実行するgitコマンドを決定するためにreflogが使用されます。これにはワーキングツリーへの変更は含まれません。コミットのみが考慮されます。 |

## リストパネルのナビゲーション

| Key | Action | Info |
|-----|--------|-------------|
| `` , `` | 前のページ |  |
| `` . `` | 次のページ |  |
| `` < (<home>) `` | 先頭にスクロール |  |
| `` > (<end>) `` | 末尾にスクロール |  |
| `` v `` | 範囲選択を切り替え |  |
| `` <s-down> `` | 範囲選択を下に |  |
| `` <s-up> `` | 範囲選択を上に |  |
| `` / `` | 現在のビューをテキストで検索 |  |
| `` H `` | 左にスクロール |  |
| `` L `` | 右にスクロール |  |
| `` ] `` | 次のタブ |  |
| `` [ `` | 前のタブ |  |

## Input prompt

| Key | Action | Info |
|-----|--------|-------------|
| `` <enter> `` | 確認 |  |
| `` <esc> `` | 閉じる/キャンセル |  |

## コミット

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | コミットハッシュをクリップボードにコピー |  |
| `` <c-r> `` | コピーされた（チェリーピックされた）コミットの選択をリセット |  |
| `` b `` | bisectオプションを表示 |  |
| `` s `` | スカッシュ | 選択したコミットをその下のコミットにスカッシュします。スカッシュとは複数のコミットを1つにまとめる操作です。選択したコミットのメッセージが下のコミットに追加されます。 |
| `` f `` | フィックスアップ | 選択したコミットをその下のコミットにマージします。フィックスアップはスカッシュと似ていますが、選択したコミットのメッセージは破棄され、下のコミットのメッセージのみが保持されます。 |
| `` r `` | メッセージ変更 | 選択したコミットのメッセージを変更します。 |
| `` R `` | エディタでメッセージ変更 |  |
| `` d `` | 削除 | 選択したコミットを削除します。これはリベースを通じてブランチからコミットを削除します。コミットが後続のコミットが依存する変更を行っている場合、マージコンフリクトを解決する必要があるかもしれません。 |
| `` e `` | 編集（対話型リベースを開始） | 選択したコミットを編集します。これを使用して、選択したコミットから対話型リベースを開始します。すでにリベース中の場合、これは選択したコミットを編集用にマークし、リベースを続行すると、リベースは選択したコミットで一時停止して変更を行えるようにします。 |
| `` i `` | 対話的リベースを開始 | ブランチ上のコミットの対話的リベースを開始します。これには、HEADコミットから最初のマージコミットまたはメインブランチのコミットまでのすべてのコミットが含まれます。<br>選択したコミットから対話的リベースを開始したい場合は、代わりに `e` を押してください。 |
| `` p `` | ピック | 選択したコミットをピックするようにマークします（リベース中）。これは、リベースを続行すると、コミットが保持されることを意味します。 |
| `` F `` | fixupコミットを作成 | 選択したコミットに対する「fixup!」コミットを作成します。fixupコミットは、選択したコミットの修正用コミットです。後で、同じコミットで `S` を押すと、上記のすべてのfixupコミットが適用されます。 |
| `` S `` | fixupコミットを適用 | すべての「fixup!」コミットを、選択したコミットの上部または現在のブランチ内のすべてをスカッシュします（autosquash）。 |
| `` <c-j> `` | コミットを1つ下に移動 |  |
| `` <c-k> `` | コミットを1つ上に移動 |  |
| `` V `` | ペースト（チェリーピック） |  |
| `` B `` | リベース用のベースコミットとしてマーク | 次のリベース用のベースコミットを選択します。ブランチにリベースするとき、ベースコミットより上のコミットのみが持ち込まれます。これは `git rebase --onto` コマンドを使用します。 |
| `` A `` | 修正 | ステージされた変更でコミットを修正します。選択したコミットがHEADコミットの場合、これは `git commit --amend` を実行します。それ以外の場合、コミットはリベースを通じて修正されます。 |
| `` a `` | コミット属性を修正 | コミット作者の設定/リセットまたは共同作者の設定を行います。 |
| `` t `` | リバート | 選択したコミットの変更を逆に適用する、リバートコミットを作成します。 |
| `` T `` | コミットにタグを付ける | 選択したコミットを指すタグを新規作成します。タグ名とオプションの説明を入力するよう促されます。 |
| `` <c-l> `` | ログオプションを表示 | コミットログのオプションを表示します（例：並び順の変更、Gitグラフの非表示、Gitグラフ全体の表示）。 |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択したコミットをデタッチドヘッド（特定のブランチに属さない状態）としてチェックアウトします。 |
| `` y `` | コミット属性をクリップボードにコピー | コミット属性をクリップボードにコピーします（例：ハッシュ、URL、差分、メッセージ、作者）。 |
| `` o `` | ブラウザでコミットを開く |  |
| `` n `` | コミットから新しいブランチを作成 |  |
| `` N `` | コミットを新しいブランチに移動 | Create a new branch and move the unpushed commits of the current branch to it. Useful if you meant to start new work and forgot to create a new branch first.<br><br>Note that this disregards the selection, the new branch is always created either from the main branch or stacked on top of the current branch (you get to choose which). |
| `` g `` | リセット | 選択した項目へのリセットオプション（ソフト/ミックス/ハード）を表示します。各リセットタイプの詳細は次の通りです：<br>- ソフトリセット：変更を保持し、ステージされた状態にします<br>- ミックスリセット：変更を保持し、ステージされていない状態にします<br>- ハードリセット：すべての変更を破棄します |
| `` C `` | コピー（チェリーピック） | コミットをコピーとしてマークします。ローカルコミットビューで `V` を押すと、コピーしたコミットをチェックアウトしたブランチにペースト（チェリーピック）できます。いつでも `<esc>` を押して選択をキャンセルできます。 |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` * `` | 現在のブランチのコミットを選択 |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | ファイルを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## コミットファイル

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | パスをクリップボードにコピー |  |
| `` y `` | クリップボードにコピー |  |
| `` c `` | チェックアウト（ブランチの切り替え） | ファイルをチェックアウトします。これにより、作業ツリー内のファイルが選択したコミットのバージョンに置き換えられます。 |
| `` d `` | 削除 | このコミットのこのファイルへの変更を破棄します。これはバックグラウンドで対話的なリベースを実行するため、後のコミットでもこのファイルが変更されている場合、マージコンフリクトが発生する可能性があります。 |
| `` o `` | ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` e `` | 編集 | 外部エディタでファイルを開きます。 |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` <space> `` | パッチに含めるファイルを切り替え | ファイルがカスタムパッチに含まれるかどうかを切り替えます。https://github.com/jesseduffield/lazygit#rebase-magic-custom-patchesを参照してください。 |
| `` a `` | すべてのファイルを切り替え | コミットのすべてのファイルをカスタムパッチに追加/削除します。https://github.com/jesseduffield/lazygit#rebase-magic-custom-patchesを参照してください。 |
| `` <enter> `` | ファイルに入る / ディレクトリの折りたたみを切り替える | ファイルが選択されている場合、そのファイルに入ってカスタムパッチに個々の行を追加/削除できます。ディレクトリが選択されている場合、ディレクトリを切り替えます。 |
| `` ` `` | ファイルツリービューを切り替え | Toggle file view between flat and tree layout. Flat layout shows all file paths in a single list, tree layout groups files by directory.<br><br>The default can be changed in the config file with the key 'gui.showFileTree'. |
| `` - `` | すべてのファイルを折りたたむ | ファイルツリー内のすべてのディレクトリを折りたたみます |
| `` = `` | すべてのファイルを展開 | ファイルツリー内のすべてのディレクトリを展開します |
| `` 0 `` | メインビューにフォーカス |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## コミット概要

| Key | Action | Info |
|-----|--------|-------------|
| `` <enter> `` | 確認 |  |
| `` <esc> `` | 閉じる |  |

## サブコミット

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | コミットハッシュをクリップボードにコピー |  |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択したコミットをデタッチドヘッド（特定のブランチに属さない状態）としてチェックアウトします。 |
| `` y `` | コミット属性をクリップボードにコピー | コミット属性をクリップボードにコピーします（例：ハッシュ、URL、差分、メッセージ、作者）。 |
| `` o `` | ブラウザでコミットを開く |  |
| `` n `` | コミットから新しいブランチを作成 |  |
| `` N `` | コミットを新しいブランチに移動 | Create a new branch and move the unpushed commits of the current branch to it. Useful if you meant to start new work and forgot to create a new branch first.<br><br>Note that this disregards the selection, the new branch is always created either from the main branch or stacked on top of the current branch (you get to choose which). |
| `` g `` | リセット | 選択した項目へのリセットオプション（ソフト/ミックス/ハード）を表示します。各リセットタイプの詳細は次の通りです：<br>- ソフトリセット：変更を保持し、ステージされた状態にします<br>- ミックスリセット：変更を保持し、ステージされていない状態にします<br>- ハードリセット：すべての変更を破棄します |
| `` C `` | コピー（チェリーピック） | コミットをコピーとしてマークします。ローカルコミットビューで `V` を押すと、コピーしたコミットをチェックアウトしたブランチにペースト（チェリーピック）できます。いつでも `<esc>` を押して選択をキャンセルできます。 |
| `` <c-r> `` | コピーされた（チェリーピックされた）コミットの選択をリセット |  |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` * `` | 現在のブランチのコミットを選択 |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | ファイルを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## サブモジュール

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | サブモジュール名をクリップボードにコピー |  |
| `` <enter> `` | 入る | サブモジュールに入ります。サブモジュールに入った後、`<esc>`を押して親リポジトリに戻ることができます。 |
| `` d `` | 削除 | 選択したサブモジュールとそれに対応するディレクトリを削除します。 |
| `` u `` | 更新 | 選択したサブモジュールを更新します。 |
| `` n `` | 新しいサブモジュール |  |
| `` e `` | サブモジュールURLを更新 |  |
| `` i `` | 初期化 | 選択したサブモジュールを初期化してフェッチの準備をします。おそらく、続いて「更新」アクションを呼び出してサブモジュールをフェッチしたいでしょう。 |
| `` b `` | 一括サブモジュールオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## スタッシュ

| Key | Action | Info |
|-----|--------|-------------|
| `` <space> `` | 適用 | スタッシュエントリをワーキングディレクトリに適用します。 |
| `` g `` | ポップ | スタッシュエントリをワーキングディレクトリに適用し、スタッシュエントリを削除します。 |
| `` d `` | 削除 | スタッシュリストからスタッシュエントリを削除します。 |
| `` n `` | 新しいブランチ | 選択したスタッシュエントリから新しいブランチを作成します。これは、スタッシュエントリが作成されたコミットをgitがチェックアウトし、そのコミットから新しいブランチを作成した後、スタッシュエントリを追加のコミットとして新しいブランチに適用することで機能します。 |
| `` r `` | スタッシュの名前を変更 |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | ファイルを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## ステータス

| Key | Action | Info |
|-----|--------|-------------|
| `` o `` | 設定ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` e `` | 設定ファイルを編集 | 外部エディタでファイルを開きます。 |
| `` u `` | 更新を確認 |  |
| `` <enter> `` | 最近のリポジトリをチェックアウト |  |
| `` a `` | ブランチログの表示モードを順に切り替え |  |
| `` 0 `` | メインビューにフォーカス |  |

## セカンダリ

| Key | Action | Info |
|-----|--------|-------------|
| `` <tab> `` | ビューを切り替え | 他のビュー（ステージされた変更/ステージされていない変更）に切り替えます。 |
| `` <esc> `` | サイドパネルに戻る |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## タグ

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | タグをクリップボードにコピー |  |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択したタグをデタッチドHEADとしてチェックアウトします。 |
| `` n `` | 新しいタグを作成 | 現在のコミットから新しいタグを作成します。タグ名とオプションの説明を入力するよう促されます。 |
| `` d `` | 削除 | ローカル/リモートタグの削除オプションを表示します。 |
| `` P `` | タグをプッシュ | 選択したタグをリモートにプッシュします。リモートを選択するよう促されます。 |
| `` g `` | リセット | 選択した項目へのリセットオプション（ソフト/ミックス/ハード）を表示します。各リセットタイプの詳細は次の通りです：<br>- ソフトリセット：変更を保持し、ステージされた状態にします<br>- ミックスリセット：変更を保持し、ステージされていない状態にします<br>- ハードリセット：すべての変更を破棄します |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | コミットを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## ファイル

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | パスをクリップボードにコピー |  |
| `` <space> `` | ステージ | 選択したファイルのステージ状態を切り替えます。 |
| `` <c-b> `` | ステータスでファイルをフィルタリング |  |
| `` y `` | クリップボードにコピー |  |
| `` c `` | コミット | ステージされた変更をコミットします。 |
| `` w `` | pre-commitフックなしで変更をコミット |  |
| `` A `` | 直前のコミットを修正 |  |
| `` C `` | Gitエディタを使用して変更をコミット |  |
| `` <c-f> `` | フィックスアップのベースコミットを検索 | 現在の変更が基づいているコミットを見つけて、コミットの修正/フィックスアップを行います。これにより、ブランチのコミットを一つずつ確認して、どのコミットを修正/フィックスアップすべきかを調べる手間が省けます。詳細はドキュメントを参照: <https://github.com/jesseduffield/lazygit/tree/master/docs/Fixup_Commits.md> |
| `` e `` | 編集 | 外部エディタでファイルを開きます。 |
| `` o `` | ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` i `` | ファイルを無視または除外 |  |
| `` r `` | ファイルを更新 |  |
| `` s `` | スタッシュ | すべての変更をスタッシュします。スタッシュの他のバリエーションについては、スタッシュオプションを表示するキーバインディングを使用してください。 |
| `` S `` | スタッシュオプションを表示 | スタッシュオプション（すべてをスタッシュ、ステージされた変更をスタッシュ、ステージされていない変更をスタッシュなど）を表示します。 |
| `` a `` | すべてステージ | ワーキングツリー内のすべてのファイルのステージ/アンステージを切り替えます。 |
| `` <enter> `` | 行をステージ / ディレクトリを折りたたむ | 選択された項目がファイルの場合、個々のハンク/行をステージできるようにステージングビューにフォーカスします。選択された項目がディレクトリの場合、ディレクトリを折りたたむ/展開します。 |
| `` d `` | 破棄 | 選択したファイルの変更を破棄するオプションを表示します。 |
| `` g `` | アップストリームへのリセットオプションを表示 |  |
| `` D `` | リセット | 作業ツリーのリセットオプション（例：作業ツリーの完全破棄）を表示します。 |
| `` ` `` | ファイルツリービューを切り替え | Toggle file view between flat and tree layout. Flat layout shows all file paths in a single list, tree layout groups files by directory.<br><br>The default can be changed in the config file with the key 'gui.showFileTree'. |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` M `` | 外部マージツールを開く | `git mergetool`を実行します。 |
| `` f `` | フェッチ | リモートから変更をフェッチします。 |
| `` - `` | すべてのファイルを折りたたむ | ファイルツリー内のすべてのディレクトリを折りたたみます |
| `` = `` | すべてのファイルを展開 | ファイルツリー内のすべてのディレクトリを展開します |
| `` 0 `` | メインビューにフォーカス |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## メインパネル（ステージング）

| Key | Action | Info |
|-----|--------|-------------|
| `` <left> `` | 前のハンクに移動 |  |
| `` <right> `` | 次のハンクに移動 |  |
| `` v `` | 範囲選択を切り替え |  |
| `` a `` | ハンクの選択を切り替える | Toggle line-by-line vs. hunk selection mode. |
| `` <c-o> `` | 選択したテキストをクリップボードにコピー |  |
| `` <space> `` | ステージ | 選択された部分のステージ / アンステージを切り替えます。 |
| `` d `` | 破棄 | ステージされていない変更が選択されている場合、`git reset`を使用して変更を破棄します。ステージされた変更が選択されている場合、変更をアンステージします。 |
| `` o `` | ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` e `` | ファイルを編集 | 外部エディタでファイルを開きます。 |
| `` <esc> `` | ファイルパネルに戻る |  |
| `` <tab> `` | ビューを切り替え | 他のビュー（ステージされた変更/ステージされていない変更）に切り替えます。 |
| `` E `` | ハンクを編集 | 選択したハンクを外部エディタで編集します。 |
| `` c `` | コミット | ステージされた変更をコミットします。 |
| `` w `` | pre-commitフックなしで変更をコミット |  |
| `` C `` | Gitエディタを使用して変更をコミット |  |
| `` <c-f> `` | フィックスアップのベースコミットを検索 | 現在の変更が基づいているコミットを見つけて、コミットの修正/フィックスアップを行います。これにより、ブランチのコミットを一つずつ確認して、どのコミットを修正/フィックスアップすべきかを調べる手間が省けます。詳細はドキュメントを参照: <https://github.com/jesseduffield/lazygit/tree/master/docs/Fixup_Commits.md> |
| `` / `` | 現在のビューをテキストで検索 |  |

## メインパネル（パッチ作成）

| Key | Action | Info |
|-----|--------|-------------|
| `` <left> `` | 前のハンクに移動 |  |
| `` <right> `` | 次のハンクに移動 |  |
| `` v `` | 範囲選択を切り替え |  |
| `` a `` | ハンクの選択を切り替える | Toggle line-by-line vs. hunk selection mode. |
| `` <c-o> `` | 選択したテキストをクリップボードにコピー |  |
| `` o `` | ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` e `` | ファイルを編集 | 外部エディタでファイルを開きます。 |
| `` <space> `` | パッチ内の行を切り替え |  |
| `` <esc> `` | カスタムパッチビルダーを終了 |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## メインパネル（マージ中）

| Key | Action | Info |
|-----|--------|-------------|
| `` <space> `` | ハンクを選択 |  |
| `` b `` | すべてのハンクを選択 |  |
| `` <up> `` | 前のハンク |  |
| `` <down> `` | 次のハンク |  |
| `` <left> `` | 前のコンフリクト |  |
| `` <right> `` | 次のコンフリクト |  |
| `` z `` | 元に戻す | 最後のマージコンフリクト解決を元に戻します。 |
| `` e `` | ファイルを編集 | 外部エディタでファイルを開きます。 |
| `` o `` | ファイルを開く | デフォルトのアプリケーションでファイルを開きます。 |
| `` M `` | 外部マージツールを開く | `git mergetool`を実行します。 |
| `` <esc> `` | ファイルパネルに戻る |  |

## メインパネル（通常）

| Key | Action | Info |
|-----|--------|-------------|
| `` mouse wheel down (fn+up) `` | 下にスクロール |  |
| `` mouse wheel up (fn+down) `` | 上にスクロール |  |
| `` <tab> `` | ビューを切り替え | 他のビュー（ステージされた変更/ステージされていない変更）に切り替えます。 |
| `` <esc> `` | サイドパネルに戻る |  |
| `` / `` | 現在のビューをテキストで検索 |  |

## メニュー

| Key | Action | Info |
|-----|--------|-------------|
| `` <enter> `` | 実行 |  |
| `` <esc> `` | 閉じる/キャンセル |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## リフログ

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | コミットハッシュをクリップボードにコピー |  |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択したコミットをデタッチドヘッド（特定のブランチに属さない状態）としてチェックアウトします。 |
| `` y `` | コミット属性をクリップボードにコピー | コミット属性をクリップボードにコピーします（例：ハッシュ、URL、差分、メッセージ、作者）。 |
| `` o `` | ブラウザでコミットを開く |  |
| `` n `` | コミットから新しいブランチを作成 |  |
| `` N `` | コミットを新しいブランチに移動 | Create a new branch and move the unpushed commits of the current branch to it. Useful if you meant to start new work and forgot to create a new branch first.<br><br>Note that this disregards the selection, the new branch is always created either from the main branch or stacked on top of the current branch (you get to choose which). |
| `` g `` | リセット | 選択した項目へのリセットオプション（ソフト/ミックス/ハード）を表示します。各リセットタイプの詳細は次の通りです：<br>- ソフトリセット：変更を保持し、ステージされた状態にします<br>- ミックスリセット：変更を保持し、ステージされていない状態にします<br>- ハードリセット：すべての変更を破棄します |
| `` C `` | コピー（チェリーピック） | コミットをコピーとしてマークします。ローカルコミットビューで `V` を押すと、コピーしたコミットをチェックアウトしたブランチにペースト（チェリーピック）できます。いつでも `<esc>` を押して選択をキャンセルできます。 |
| `` <c-r> `` | コピーされた（チェリーピックされた）コミットの選択をリセット |  |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` * `` | 現在のブランチのコミットを選択 |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | コミットを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## リモート

| Key | Action | Info |
|-----|--------|-------------|
| `` <enter> `` | ブランチを表示 |  |
| `` n `` | 新しいリモート |  |
| `` d `` | 削除 | 選択したリモートを削除します。そのリモートからのリモートブランチを追跡しているローカルブランチは影響を受けません。 |
| `` e `` | 編集 | 選択したリモートの名前またはURLを編集します。 |
| `` f `` | フェッチ | リモートリポジトリから更新をフェッチします。これにより、ローカルブランチにマージせずに新しいコミットとブランチを取得します。 |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## リモートブランチ

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | ブランチ名をクリップボードにコピー |  |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択したリモートブランチに基づいて新しいローカルブランチをチェックアウトするか、リモートブランチをデタッチドヘッドとしてチェックアウトします。 |
| `` n `` | 新しいブランチ |  |
| `` M `` | マージ | 選択した項目を現在のブランチにマージするためのオプションを表示します（通常のマージ、スカッシュマージ） |
| `` r `` | リベース | チェックアウトしたブランチを選択したブランチ上にリベースします。 |
| `` d `` | 削除 | リモートからリモートブランチを削除します。 |
| `` u `` | アップストリームとして設定 | 選択したリモートブランチをチェックアウトされたブランチのアップストリームとして設定します。 |
| `` s `` | 並び順 |  |
| `` g `` | リセット | 選択した項目へのリセットオプション（ソフト/ミックス/ハード）を表示します。各リセットタイプの詳細は次の通りです：<br>- ソフトリセット：変更を保持し、ステージされた状態にします<br>- ミックスリセット：変更を保持し、ステージされていない状態にします<br>- ハードリセット：すべての変更を破棄します |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | コミットを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## ローカルブランチ

| Key | Action | Info |
|-----|--------|-------------|
| `` <c-o> `` | ブランチ名をクリップボードにコピー |  |
| `` i `` | git-flowオプションを表示 |  |
| `` <space> `` | チェックアウト（ブランチの切り替え） | 選択した項目をチェックアウトします。 |
| `` n `` | 新しいブランチ |  |
| `` N `` | コミットを新しいブランチに移動 | Create a new branch and move the unpushed commits of the current branch to it. Useful if you meant to start new work and forgot to create a new branch first.<br><br>Note that this disregards the selection, the new branch is always created either from the main branch or stacked on top of the current branch (you get to choose which). |
| `` o `` | プルリクエストを作成 |  |
| `` O `` | プルリクエスト作成オプションを表示 |  |
| `` <c-y> `` | プルリクエストURLをクリップボードにコピー |  |
| `` c `` | 名前でチェックアウト | 名前でチェックアウトします。入力ボックスに「-」を入力すると、最後のブランチをチェックアウトすることができます。 |
| `` - `` | 直前のブランチにチェックアウト |  |
| `` F `` | 強制チェックアウト | 選択したブランチを強制的にチェックアウトします。これにより、選択したブランチをチェックアウトする前にワーキングディレクトリ内のすべてのローカル変更が破棄されます。 |
| `` d `` | 削除 | ローカル/リモートブランチの削除オプションを表示します。 |
| `` r `` | リベース | チェックアウトしたブランチを選択したブランチ上にリベースします。 |
| `` M `` | マージ | 選択した項目を現在のブランチにマージするためのオプションを表示します（通常のマージ、スカッシュマージ） |
| `` f `` | ブランチを最新化（fast-forward） | 選択したブランチを対応するアップストリームの最新状態に追いつかせます（fast-forward）。 |
| `` T `` | 新しいタグを作成 |  |
| `` s `` | 並び順 |  |
| `` g `` | リセット |  |
| `` R `` | ブランチ名を変更 |  |
| `` u `` | アップストリームオプションを表示 | ブランチのアップストリームに関連するオプションを表示します（例：アップストリームの設定/解除やアップストリームへのリセット）。 |
| `` <c-t> `` | 外部差分ツールを開く（git difftool） |  |
| `` 0 `` | メインビューにフォーカス |  |
| `` <enter> `` | コミットを表示 |  |
| `` w `` | ワークツリーオプションを表示 |  |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## ワークツリー

| Key | Action | Info |
|-----|--------|-------------|
| `` n `` | 新しいワークツリー |  |
| `` <space> `` | チェックアウト（切り替え） | 選択したワークツリーをチェックアウト（切り替え）します。 |
| `` o `` | エディタで開く |  |
| `` d `` | 削除 | 選択したワークツリーを削除します。これはワークツリーのディレクトリとワークツリーに関するメタデータの両方を.gitディレクトリから削除します。 |
| `` / `` | 現在のビューをテキストでフィルタリング |  |

## 確認パネル

| Key | Action | Info |
|-----|--------|-------------|
| `` <enter> `` | 確認 |  |
| `` <esc> `` | 閉じる/キャンセル |  |
| `` <c-o> `` | クリップボードにコピー |  |
