/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_23_H
#define LEXBOR_UNICODE_TABLES_23_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D15E = {.cps = (lxb_codepoint_t[]) {0x1D157, 0x1D165}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D15F = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D160 = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165, 0x1D16E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D161 = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165, 0x1D16F}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D162 = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165, 0x1D170}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D163 = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165, 0x1D171}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D164 = {.cps = (lxb_codepoint_t[]) {0x1D158, 0x1D165, 0x1D172}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1BB = {.cps = (lxb_codepoint_t[]) {0x1D1B9, 0x1D165}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1BC = {.cps = (lxb_codepoint_t[]) {0x1D1BA, 0x1D165}, .length = 2};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1BD = {.cps = (lxb_codepoint_t[]) {0x1D1B9, 0x1D165, 0x1D16E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1BE = {.cps = (lxb_codepoint_t[]) {0x1D1BA, 0x1D165, 0x1D16E}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1BF = {.cps = (lxb_codepoint_t[]) {0x1D1B9, 0x1D165, 0x1D16F}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D1C0 = {.cps = (lxb_codepoint_t[]) {0x1D1BA, 0x1D165, 0x1D16F}, .length = 3};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D400 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D401 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D402 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D403 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D404 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D405 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D406 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D407 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D408 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D409 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40A = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40B = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40C = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40D = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40E = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D40F = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D410 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D411 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D412 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D413 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D414 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D415 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D416 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D417 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D418 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D419 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41A = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41B = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41C = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41D = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41E = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D41F = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D420 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D421 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D422 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D423 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D424 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D425 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D426 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D427 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D428 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D429 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42A = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42B = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42C = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42D = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42E = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D42F = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D430 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D431 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D432 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D433 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D434 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D435 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D436 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D437 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D438 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D439 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43A = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43B = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43C = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43D = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43E = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D43F = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D440 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D441 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D442 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D443 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D444 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D445 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D446 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D447 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D448 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D449 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44A = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44B = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44C = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44D = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44E = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D44F = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D450 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D451 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D452 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D453 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D454 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D456 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D457 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D458 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D459 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45A = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45B = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45C = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45D = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45E = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D45F = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D460 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D461 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D462 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D463 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D464 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D465 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D466 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D467 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D468 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D469 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46A = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46B = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46C = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46D = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46E = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D46F = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D470 = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D471 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D472 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D473 = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D474 = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D475 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D476 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D477 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D478 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D479 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47A = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47B = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47C = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47D = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47E = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D47F = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D480 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D481 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D482 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D483 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D484 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D485 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D486 = {.cps = (lxb_codepoint_t[]) {0x0065}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D487 = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D488 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D489 = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48A = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48B = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48C = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48D = {.cps = (lxb_codepoint_t[]) {0x006C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48E = {.cps = (lxb_codepoint_t[]) {0x006D}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D48F = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D490 = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D491 = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D492 = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D493 = {.cps = (lxb_codepoint_t[]) {0x0072}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D494 = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D495 = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D496 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D497 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D498 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D499 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49A = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49B = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49C = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49E = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D49F = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4A2 = {.cps = (lxb_codepoint_t[]) {0x0067}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4A5 = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4A6 = {.cps = (lxb_codepoint_t[]) {0x006B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4A9 = {.cps = (lxb_codepoint_t[]) {0x006E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4AA = {.cps = (lxb_codepoint_t[]) {0x006F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4AB = {.cps = (lxb_codepoint_t[]) {0x0070}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4AC = {.cps = (lxb_codepoint_t[]) {0x0071}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4AE = {.cps = (lxb_codepoint_t[]) {0x0073}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4AF = {.cps = (lxb_codepoint_t[]) {0x0074}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B0 = {.cps = (lxb_codepoint_t[]) {0x0075}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B1 = {.cps = (lxb_codepoint_t[]) {0x0076}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B2 = {.cps = (lxb_codepoint_t[]) {0x0077}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B3 = {.cps = (lxb_codepoint_t[]) {0x0078}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B4 = {.cps = (lxb_codepoint_t[]) {0x0079}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B5 = {.cps = (lxb_codepoint_t[]) {0x007A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B6 = {.cps = (lxb_codepoint_t[]) {0x0061}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B7 = {.cps = (lxb_codepoint_t[]) {0x0062}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B8 = {.cps = (lxb_codepoint_t[]) {0x0063}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4B9 = {.cps = (lxb_codepoint_t[]) {0x0064}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4BB = {.cps = (lxb_codepoint_t[]) {0x0066}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4BD = {.cps = (lxb_codepoint_t[]) {0x0068}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4BE = {.cps = (lxb_codepoint_t[]) {0x0069}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_1D4BF = {.cps = (lxb_codepoint_t[]) {0x006A}, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D15E[2] = {0x1D157, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D15E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D15E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D15E[2] = {0x1D157, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D15E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D15E, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D15E[2] = {0x1D157, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D15E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D15E, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D15E = {.cp = 0x1D15E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D15E, .cde = &lxb_unicode_decomposition_c_1D15E, .kde = &lxb_unicode_decomposition_k_1D15E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D15F[2] = {0x1D158, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D15F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D15F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D15F[2] = {0x1D158, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D15F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D15F, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D15F[2] = {0x1D158, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D15F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D15F, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D15F = {.cp = 0x1D15F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D15F, .cde = &lxb_unicode_decomposition_c_1D15F, .kde = &lxb_unicode_decomposition_k_1D15F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D160[3] = {0x1D158, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D160, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D160[3] = {0x1D158, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D160, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D160[2] = {0x1D15F, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D160 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D160, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D160 = {.cp = 0x1D160, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D160, .cde = &lxb_unicode_decomposition_c_1D160, .kde = &lxb_unicode_decomposition_k_1D160};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D161[3] = {0x1D158, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D161, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D161[3] = {0x1D158, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D161, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D161[2] = {0x1D15F, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D161 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D161, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D161 = {.cp = 0x1D161, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D161, .cde = &lxb_unicode_decomposition_c_1D161, .kde = &lxb_unicode_decomposition_k_1D161};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D162[3] = {0x1D158, 0x1D165, 0x1D170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D162, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D162[3] = {0x1D158, 0x1D165, 0x1D170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D162, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D162[2] = {0x1D15F, 0x1D170};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D162 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D162, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D162 = {.cp = 0x1D162, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D162, .cde = &lxb_unicode_decomposition_c_1D162, .kde = &lxb_unicode_decomposition_k_1D162};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D163[3] = {0x1D158, 0x1D165, 0x1D171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D163, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D163[3] = {0x1D158, 0x1D165, 0x1D171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D163, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D163[2] = {0x1D15F, 0x1D171};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D163 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D163, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D163 = {.cp = 0x1D163, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D163, .cde = &lxb_unicode_decomposition_c_1D163, .kde = &lxb_unicode_decomposition_k_1D163};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D164[3] = {0x1D158, 0x1D165, 0x1D172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D164, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D164[3] = {0x1D158, 0x1D165, 0x1D172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D164, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D164[2] = {0x1D15F, 0x1D172};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D164 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D164, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D164 = {.cp = 0x1D164, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D164, .cde = &lxb_unicode_decomposition_c_1D164, .kde = &lxb_unicode_decomposition_k_1D164};

static const lxb_unicode_entry_t lxb_unicode_entry_1D165 = {.cp = 0x1D165, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D166 = {.cp = 0x1D166, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D167 = {.cp = 0x1D167, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D168 = {.cp = 0x1D168, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D169 = {.cp = 0x1D169, .ccc = 1, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D16D = {.cp = 0x1D16D, .ccc = 226, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D16E = {.cp = 0x1D16E, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D16F = {.cp = 0x1D16F, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D170 = {.cp = 0x1D170, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D171 = {.cp = 0x1D171, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D172 = {.cp = 0x1D172, .ccc = 216, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D17B = {.cp = 0x1D17B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D17C = {.cp = 0x1D17C, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D17D = {.cp = 0x1D17D, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D17E = {.cp = 0x1D17E, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D17F = {.cp = 0x1D17F, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D180 = {.cp = 0x1D180, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D181 = {.cp = 0x1D181, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D182 = {.cp = 0x1D182, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D185 = {.cp = 0x1D185, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D186 = {.cp = 0x1D186, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D187 = {.cp = 0x1D187, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D188 = {.cp = 0x1D188, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D189 = {.cp = 0x1D189, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D18A = {.cp = 0x1D18A, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D18B = {.cp = 0x1D18B, .ccc = 220, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D1AA = {.cp = 0x1D1AA, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D1AB = {.cp = 0x1D1AB, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D1AC = {.cp = 0x1D1AC, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D1AD = {.cp = 0x1D1AD, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1BB[2] = {0x1D1B9, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1BB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1BB[2] = {0x1D1B9, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1BB, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1BB[2] = {0x1D1B9, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1BB, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1BB = {.cp = 0x1D1BB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1BB, .cde = &lxb_unicode_decomposition_c_1D1BB, .kde = &lxb_unicode_decomposition_k_1D1BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1BC[2] = {0x1D1BA, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1BC[2] = {0x1D1BA, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1BC, .length = 2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1BC[2] = {0x1D1BA, 0x1D165};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1BC, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1BC = {.cp = 0x1D1BC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1BC, .cde = &lxb_unicode_decomposition_c_1D1BC, .kde = &lxb_unicode_decomposition_k_1D1BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1BD[3] = {0x1D1B9, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1BD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1BD[3] = {0x1D1B9, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1BD, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1BD[2] = {0x1D1BB, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1BD, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1BD = {.cp = 0x1D1BD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1BD, .cde = &lxb_unicode_decomposition_c_1D1BD, .kde = &lxb_unicode_decomposition_k_1D1BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1BE[3] = {0x1D1BA, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1BE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1BE[3] = {0x1D1BA, 0x1D165, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1BE, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1BE[2] = {0x1D1BC, 0x1D16E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1BE, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1BE = {.cp = 0x1D1BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1BE, .cde = &lxb_unicode_decomposition_c_1D1BE, .kde = &lxb_unicode_decomposition_k_1D1BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1BF[3] = {0x1D1B9, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1BF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1BF[3] = {0x1D1B9, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1BF, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1BF[2] = {0x1D1BB, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1BF, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1BF = {.cp = 0x1D1BF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1BF, .cde = &lxb_unicode_decomposition_c_1D1BF, .kde = &lxb_unicode_decomposition_k_1D1BF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D1C0[3] = {0x1D1BA, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D1C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_1D1C0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D1C0[3] = {0x1D1BA, 0x1D165, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D1C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_1D1C0, .length = 3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D1C0[2] = {0x1D1BC, 0x1D16F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D1C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__1D1C0, .length = 2};
static const lxb_unicode_entry_t lxb_unicode_entry_1D1C0 = {.cp = 0x1D1C0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D1C0, .cde = &lxb_unicode_decomposition_c_1D1C0, .kde = &lxb_unicode_decomposition_k_1D1C0};

static const lxb_unicode_entry_t lxb_unicode_entry_1D242 = {.cp = 0x1D242, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D243 = {.cp = 0x1D243, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};

static const lxb_unicode_entry_t lxb_unicode_entry_1D244 = {.cp = 0x1D244, .ccc = 230, .quick = LXB_UNICODE_QUICK_UNDEF, .de = NULL, .cde = NULL, .kde = NULL};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D400[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D400, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D400[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D400, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D400[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D400 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D400, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D400 = {.cp = 0x1D400, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D400, .cde = &lxb_unicode_decomposition_c_1D400, .kde = &lxb_unicode_decomposition_k_1D400};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D401[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D401, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D401[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D401, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D401[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D401 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D401, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D401 = {.cp = 0x1D401, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D401, .cde = &lxb_unicode_decomposition_c_1D401, .kde = &lxb_unicode_decomposition_k_1D401};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D402[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D402 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D402, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D402[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D402 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D402, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D402[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D402 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D402, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D402 = {.cp = 0x1D402, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D402, .cde = &lxb_unicode_decomposition_c_1D402, .kde = &lxb_unicode_decomposition_k_1D402};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D403[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D403, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D403[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D403, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D403[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D403 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D403, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D403 = {.cp = 0x1D403, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D403, .cde = &lxb_unicode_decomposition_c_1D403, .kde = &lxb_unicode_decomposition_k_1D403};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D404[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D404 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D404, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D404[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D404 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D404, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D404[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D404 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D404, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D404 = {.cp = 0x1D404, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D404, .cde = &lxb_unicode_decomposition_c_1D404, .kde = &lxb_unicode_decomposition_k_1D404};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D405[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D405 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D405, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D405[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D405 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D405, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D405[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D405 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D405, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D405 = {.cp = 0x1D405, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D405, .cde = &lxb_unicode_decomposition_c_1D405, .kde = &lxb_unicode_decomposition_k_1D405};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D406[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D406 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D406, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D406[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D406 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D406, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D406[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D406 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D406, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D406 = {.cp = 0x1D406, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D406, .cde = &lxb_unicode_decomposition_c_1D406, .kde = &lxb_unicode_decomposition_k_1D406};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D407[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D407, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D407[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D407, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D407[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D407 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D407, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D407 = {.cp = 0x1D407, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D407, .cde = &lxb_unicode_decomposition_c_1D407, .kde = &lxb_unicode_decomposition_k_1D407};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D408[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D408 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D408, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D408[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D408 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D408, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D408[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D408 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D408, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D408 = {.cp = 0x1D408, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D408, .cde = &lxb_unicode_decomposition_c_1D408, .kde = &lxb_unicode_decomposition_k_1D408};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D409[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D409 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D409, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D409[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D409 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D409, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D409[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D409 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D409, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D409 = {.cp = 0x1D409, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D409, .cde = &lxb_unicode_decomposition_c_1D409, .kde = &lxb_unicode_decomposition_k_1D409};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40A[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40A = {.cp = 0x1D40A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40A, .cde = &lxb_unicode_decomposition_c_1D40A, .kde = &lxb_unicode_decomposition_k_1D40A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40B[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40B[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40B[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40B = {.cp = 0x1D40B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40B, .cde = &lxb_unicode_decomposition_c_1D40B, .kde = &lxb_unicode_decomposition_k_1D40B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40C[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40C[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40C[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40C = {.cp = 0x1D40C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40C, .cde = &lxb_unicode_decomposition_c_1D40C, .kde = &lxb_unicode_decomposition_k_1D40C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40D[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40D[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40D[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40D = {.cp = 0x1D40D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40D, .cde = &lxb_unicode_decomposition_c_1D40D, .kde = &lxb_unicode_decomposition_k_1D40D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40E[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40E[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40E[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40E = {.cp = 0x1D40E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40E, .cde = &lxb_unicode_decomposition_c_1D40E, .kde = &lxb_unicode_decomposition_k_1D40E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D40F[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D40F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D40F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D40F[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D40F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D40F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D40F[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D40F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D40F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D40F = {.cp = 0x1D40F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D40F, .cde = &lxb_unicode_decomposition_c_1D40F, .kde = &lxb_unicode_decomposition_k_1D40F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D410[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D410 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D410, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D410[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D410 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D410, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D410[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D410 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D410, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D410 = {.cp = 0x1D410, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D410, .cde = &lxb_unicode_decomposition_c_1D410, .kde = &lxb_unicode_decomposition_k_1D410};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D411[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D411 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D411, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D411[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D411 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D411, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D411[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D411 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D411, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D411 = {.cp = 0x1D411, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D411, .cde = &lxb_unicode_decomposition_c_1D411, .kde = &lxb_unicode_decomposition_k_1D411};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D412[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D412 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D412, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D412[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D412 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D412, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D412[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D412 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D412, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D412 = {.cp = 0x1D412, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D412, .cde = &lxb_unicode_decomposition_c_1D412, .kde = &lxb_unicode_decomposition_k_1D412};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D413[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D413 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D413, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D413[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D413 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D413, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D413[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D413 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D413, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D413 = {.cp = 0x1D413, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D413, .cde = &lxb_unicode_decomposition_c_1D413, .kde = &lxb_unicode_decomposition_k_1D413};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D414[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D414 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D414, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D414[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D414 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D414, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D414[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D414 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D414, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D414 = {.cp = 0x1D414, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D414, .cde = &lxb_unicode_decomposition_c_1D414, .kde = &lxb_unicode_decomposition_k_1D414};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D415[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D415 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D415, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D415[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D415 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D415, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D415[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D415 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D415, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D415 = {.cp = 0x1D415, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D415, .cde = &lxb_unicode_decomposition_c_1D415, .kde = &lxb_unicode_decomposition_k_1D415};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D416[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D416 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D416, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D416[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D416 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D416, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D416[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D416 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D416, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D416 = {.cp = 0x1D416, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D416, .cde = &lxb_unicode_decomposition_c_1D416, .kde = &lxb_unicode_decomposition_k_1D416};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D417[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D417 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D417, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D417[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D417 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D417, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D417[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D417 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D417, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D417 = {.cp = 0x1D417, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D417, .cde = &lxb_unicode_decomposition_c_1D417, .kde = &lxb_unicode_decomposition_k_1D417};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D418[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D418 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D418, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D418[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D418 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D418, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D418[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D418 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D418, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D418 = {.cp = 0x1D418, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D418, .cde = &lxb_unicode_decomposition_c_1D418, .kde = &lxb_unicode_decomposition_k_1D418};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D419[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D419, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D419[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D419, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D419[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D419 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D419, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D419 = {.cp = 0x1D419, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D419, .cde = &lxb_unicode_decomposition_c_1D419, .kde = &lxb_unicode_decomposition_k_1D419};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41A[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41A[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41A[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41A = {.cp = 0x1D41A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41A, .cde = &lxb_unicode_decomposition_c_1D41A, .kde = &lxb_unicode_decomposition_k_1D41A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41B[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41B[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41B[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41B = {.cp = 0x1D41B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41B, .cde = &lxb_unicode_decomposition_c_1D41B, .kde = &lxb_unicode_decomposition_k_1D41B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41C[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41C = {.cp = 0x1D41C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41C, .cde = &lxb_unicode_decomposition_c_1D41C, .kde = &lxb_unicode_decomposition_k_1D41C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41D[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41D[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41D[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41D = {.cp = 0x1D41D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41D, .cde = &lxb_unicode_decomposition_c_1D41D, .kde = &lxb_unicode_decomposition_k_1D41D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41E[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41E[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41E[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41E = {.cp = 0x1D41E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41E, .cde = &lxb_unicode_decomposition_c_1D41E, .kde = &lxb_unicode_decomposition_k_1D41E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D41F[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D41F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D41F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D41F[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D41F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D41F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D41F[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D41F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D41F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D41F = {.cp = 0x1D41F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D41F, .cde = &lxb_unicode_decomposition_c_1D41F, .kde = &lxb_unicode_decomposition_k_1D41F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D420[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D420 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D420, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D420[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D420 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D420, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D420[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D420 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D420, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D420 = {.cp = 0x1D420, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D420, .cde = &lxb_unicode_decomposition_c_1D420, .kde = &lxb_unicode_decomposition_k_1D420};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D421[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D421 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D421, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D421[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D421 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D421, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D421[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D421 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D421, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D421 = {.cp = 0x1D421, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D421, .cde = &lxb_unicode_decomposition_c_1D421, .kde = &lxb_unicode_decomposition_k_1D421};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D422[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D422 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D422, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D422[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D422 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D422, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D422[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D422 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D422, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D422 = {.cp = 0x1D422, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D422, .cde = &lxb_unicode_decomposition_c_1D422, .kde = &lxb_unicode_decomposition_k_1D422};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D423[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D423 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D423, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D423[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D423 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D423, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D423[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D423 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D423, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D423 = {.cp = 0x1D423, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D423, .cde = &lxb_unicode_decomposition_c_1D423, .kde = &lxb_unicode_decomposition_k_1D423};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D424[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D424 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D424, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D424[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D424 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D424, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D424[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D424 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D424, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D424 = {.cp = 0x1D424, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D424, .cde = &lxb_unicode_decomposition_c_1D424, .kde = &lxb_unicode_decomposition_k_1D424};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D425[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D425 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D425, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D425[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D425 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D425, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D425[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D425 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D425, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D425 = {.cp = 0x1D425, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D425, .cde = &lxb_unicode_decomposition_c_1D425, .kde = &lxb_unicode_decomposition_k_1D425};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D426[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D426 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D426, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D426[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D426 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D426, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D426[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D426 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D426, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D426 = {.cp = 0x1D426, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D426, .cde = &lxb_unicode_decomposition_c_1D426, .kde = &lxb_unicode_decomposition_k_1D426};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D427[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D427 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D427, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D427[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D427 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D427, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D427[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D427 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D427, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D427 = {.cp = 0x1D427, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D427, .cde = &lxb_unicode_decomposition_c_1D427, .kde = &lxb_unicode_decomposition_k_1D427};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D428[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D428 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D428, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D428[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D428 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D428, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D428[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D428 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D428, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D428 = {.cp = 0x1D428, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D428, .cde = &lxb_unicode_decomposition_c_1D428, .kde = &lxb_unicode_decomposition_k_1D428};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D429[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D429 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D429, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D429[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D429 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D429, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D429[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D429 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D429, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D429 = {.cp = 0x1D429, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D429, .cde = &lxb_unicode_decomposition_c_1D429, .kde = &lxb_unicode_decomposition_k_1D429};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42A[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42A[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42A[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42A = {.cp = 0x1D42A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42A, .cde = &lxb_unicode_decomposition_c_1D42A, .kde = &lxb_unicode_decomposition_k_1D42A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42B[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42B[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42B[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42B = {.cp = 0x1D42B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42B, .cde = &lxb_unicode_decomposition_c_1D42B, .kde = &lxb_unicode_decomposition_k_1D42B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42C[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42C[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42C[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42C = {.cp = 0x1D42C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42C, .cde = &lxb_unicode_decomposition_c_1D42C, .kde = &lxb_unicode_decomposition_k_1D42C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42D[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42D[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42D[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42D = {.cp = 0x1D42D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42D, .cde = &lxb_unicode_decomposition_c_1D42D, .kde = &lxb_unicode_decomposition_k_1D42D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42E[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42E[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42E[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42E = {.cp = 0x1D42E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42E, .cde = &lxb_unicode_decomposition_c_1D42E, .kde = &lxb_unicode_decomposition_k_1D42E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D42F[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D42F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D42F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D42F[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D42F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D42F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D42F[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D42F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D42F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D42F = {.cp = 0x1D42F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D42F, .cde = &lxb_unicode_decomposition_c_1D42F, .kde = &lxb_unicode_decomposition_k_1D42F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D430[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D430 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D430, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D430[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D430 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D430, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D430[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D430 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D430, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D430 = {.cp = 0x1D430, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D430, .cde = &lxb_unicode_decomposition_c_1D430, .kde = &lxb_unicode_decomposition_k_1D430};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D431[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D431 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D431, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D431[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D431 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D431, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D431[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D431 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D431, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D431 = {.cp = 0x1D431, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D431, .cde = &lxb_unicode_decomposition_c_1D431, .kde = &lxb_unicode_decomposition_k_1D431};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D432[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D432 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D432, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D432[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D432 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D432, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D432[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D432 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D432, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D432 = {.cp = 0x1D432, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D432, .cde = &lxb_unicode_decomposition_c_1D432, .kde = &lxb_unicode_decomposition_k_1D432};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D433[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D433 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D433, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D433[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D433 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D433, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D433[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D433 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D433, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D433 = {.cp = 0x1D433, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D433, .cde = &lxb_unicode_decomposition_c_1D433, .kde = &lxb_unicode_decomposition_k_1D433};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D434[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D434 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D434, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D434[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D434 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D434, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D434[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D434 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D434, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D434 = {.cp = 0x1D434, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D434, .cde = &lxb_unicode_decomposition_c_1D434, .kde = &lxb_unicode_decomposition_k_1D434};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D435[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D435 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D435, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D435[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D435 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D435, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D435[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D435 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D435, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D435 = {.cp = 0x1D435, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D435, .cde = &lxb_unicode_decomposition_c_1D435, .kde = &lxb_unicode_decomposition_k_1D435};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D436[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D436 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D436, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D436[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D436 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D436, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D436[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D436 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D436, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D436 = {.cp = 0x1D436, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D436, .cde = &lxb_unicode_decomposition_c_1D436, .kde = &lxb_unicode_decomposition_k_1D436};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D437[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D437 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D437, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D437[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D437 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D437, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D437[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D437 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D437, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D437 = {.cp = 0x1D437, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D437, .cde = &lxb_unicode_decomposition_c_1D437, .kde = &lxb_unicode_decomposition_k_1D437};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D438[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D438 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D438, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D438[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D438 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D438, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D438[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D438 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D438, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D438 = {.cp = 0x1D438, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D438, .cde = &lxb_unicode_decomposition_c_1D438, .kde = &lxb_unicode_decomposition_k_1D438};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D439[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D439, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D439[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D439, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D439[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D439 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D439, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D439 = {.cp = 0x1D439, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D439, .cde = &lxb_unicode_decomposition_c_1D439, .kde = &lxb_unicode_decomposition_k_1D439};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43A[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43A[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43A[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43A = {.cp = 0x1D43A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43A, .cde = &lxb_unicode_decomposition_c_1D43A, .kde = &lxb_unicode_decomposition_k_1D43A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43B[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43B = {.cp = 0x1D43B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43B, .cde = &lxb_unicode_decomposition_c_1D43B, .kde = &lxb_unicode_decomposition_k_1D43B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43C[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43C[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43C[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43C = {.cp = 0x1D43C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43C, .cde = &lxb_unicode_decomposition_c_1D43C, .kde = &lxb_unicode_decomposition_k_1D43C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43D[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43D[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43D[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43D = {.cp = 0x1D43D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43D, .cde = &lxb_unicode_decomposition_c_1D43D, .kde = &lxb_unicode_decomposition_k_1D43D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43E[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43E[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43E[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43E = {.cp = 0x1D43E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43E, .cde = &lxb_unicode_decomposition_c_1D43E, .kde = &lxb_unicode_decomposition_k_1D43E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D43F[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D43F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D43F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D43F[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D43F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D43F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D43F[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D43F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D43F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D43F = {.cp = 0x1D43F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D43F, .cde = &lxb_unicode_decomposition_c_1D43F, .kde = &lxb_unicode_decomposition_k_1D43F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D440[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D440 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D440, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D440[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D440 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D440, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D440[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D440 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D440, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D440 = {.cp = 0x1D440, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D440, .cde = &lxb_unicode_decomposition_c_1D440, .kde = &lxb_unicode_decomposition_k_1D440};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D441[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D441 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D441, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D441[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D441 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D441, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D441[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D441 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D441, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D441 = {.cp = 0x1D441, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D441, .cde = &lxb_unicode_decomposition_c_1D441, .kde = &lxb_unicode_decomposition_k_1D441};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D442[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D442 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D442, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D442[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D442 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D442, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D442[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D442 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D442, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D442 = {.cp = 0x1D442, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D442, .cde = &lxb_unicode_decomposition_c_1D442, .kde = &lxb_unicode_decomposition_k_1D442};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D443[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D443 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D443, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D443[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D443 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D443, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D443[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D443 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D443, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D443 = {.cp = 0x1D443, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D443, .cde = &lxb_unicode_decomposition_c_1D443, .kde = &lxb_unicode_decomposition_k_1D443};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D444[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D444 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D444, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D444[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D444 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D444, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D444[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D444 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D444, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D444 = {.cp = 0x1D444, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D444, .cde = &lxb_unicode_decomposition_c_1D444, .kde = &lxb_unicode_decomposition_k_1D444};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D445[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D445 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D445, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D445[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D445 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D445, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D445[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D445 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D445, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D445 = {.cp = 0x1D445, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D445, .cde = &lxb_unicode_decomposition_c_1D445, .kde = &lxb_unicode_decomposition_k_1D445};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D446[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D446 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D446, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D446[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D446 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D446, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D446[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D446 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D446, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D446 = {.cp = 0x1D446, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D446, .cde = &lxb_unicode_decomposition_c_1D446, .kde = &lxb_unicode_decomposition_k_1D446};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D447[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D447 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D447, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D447[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D447 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D447, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D447[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D447 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D447, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D447 = {.cp = 0x1D447, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D447, .cde = &lxb_unicode_decomposition_c_1D447, .kde = &lxb_unicode_decomposition_k_1D447};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D448[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D448 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D448, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D448[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D448 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D448, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D448[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D448 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D448, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D448 = {.cp = 0x1D448, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D448, .cde = &lxb_unicode_decomposition_c_1D448, .kde = &lxb_unicode_decomposition_k_1D448};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D449[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D449 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D449, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D449[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D449 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D449, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D449[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D449 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D449, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D449 = {.cp = 0x1D449, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D449, .cde = &lxb_unicode_decomposition_c_1D449, .kde = &lxb_unicode_decomposition_k_1D449};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44A[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44A[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44A[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44A = {.cp = 0x1D44A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44A, .cde = &lxb_unicode_decomposition_c_1D44A, .kde = &lxb_unicode_decomposition_k_1D44A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44B[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44B[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44B[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44B = {.cp = 0x1D44B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44B, .cde = &lxb_unicode_decomposition_c_1D44B, .kde = &lxb_unicode_decomposition_k_1D44B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44C[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44C[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44C[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44C = {.cp = 0x1D44C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44C, .cde = &lxb_unicode_decomposition_c_1D44C, .kde = &lxb_unicode_decomposition_k_1D44C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44D[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44D[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44D[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44D = {.cp = 0x1D44D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44D, .cde = &lxb_unicode_decomposition_c_1D44D, .kde = &lxb_unicode_decomposition_k_1D44D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44E[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44E[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44E[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44E = {.cp = 0x1D44E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44E, .cde = &lxb_unicode_decomposition_c_1D44E, .kde = &lxb_unicode_decomposition_k_1D44E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D44F[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D44F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D44F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D44F[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D44F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D44F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D44F[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D44F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D44F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D44F = {.cp = 0x1D44F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D44F, .cde = &lxb_unicode_decomposition_c_1D44F, .kde = &lxb_unicode_decomposition_k_1D44F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D450[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D450, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D450[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D450, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D450[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D450 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D450, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D450 = {.cp = 0x1D450, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D450, .cde = &lxb_unicode_decomposition_c_1D450, .kde = &lxb_unicode_decomposition_k_1D450};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D451[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D451, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D451[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D451, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D451[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D451 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D451, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D451 = {.cp = 0x1D451, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D451, .cde = &lxb_unicode_decomposition_c_1D451, .kde = &lxb_unicode_decomposition_k_1D451};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D452[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D452 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D452, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D452[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D452 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D452, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D452[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D452 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D452, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D452 = {.cp = 0x1D452, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D452, .cde = &lxb_unicode_decomposition_c_1D452, .kde = &lxb_unicode_decomposition_k_1D452};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D453[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D453, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D453[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D453, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D453[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D453 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D453, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D453 = {.cp = 0x1D453, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D453, .cde = &lxb_unicode_decomposition_c_1D453, .kde = &lxb_unicode_decomposition_k_1D453};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D454[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D454 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D454, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D454[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D454 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D454, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D454[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D454 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D454, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D454 = {.cp = 0x1D454, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D454, .cde = &lxb_unicode_decomposition_c_1D454, .kde = &lxb_unicode_decomposition_k_1D454};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D456[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D456 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D456, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D456[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D456 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D456, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D456[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D456 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D456, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D456 = {.cp = 0x1D456, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D456, .cde = &lxb_unicode_decomposition_c_1D456, .kde = &lxb_unicode_decomposition_k_1D456};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D457[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D457, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D457[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D457, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D457[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D457 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D457, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D457 = {.cp = 0x1D457, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D457, .cde = &lxb_unicode_decomposition_c_1D457, .kde = &lxb_unicode_decomposition_k_1D457};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D458[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D458 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D458, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D458[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D458 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D458, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D458[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D458 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D458, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D458 = {.cp = 0x1D458, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D458, .cde = &lxb_unicode_decomposition_c_1D458, .kde = &lxb_unicode_decomposition_k_1D458};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D459[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D459 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D459, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D459[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D459 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D459, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D459[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D459 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D459, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D459 = {.cp = 0x1D459, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D459, .cde = &lxb_unicode_decomposition_c_1D459, .kde = &lxb_unicode_decomposition_k_1D459};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45A[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45A[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45A[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45A = {.cp = 0x1D45A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45A, .cde = &lxb_unicode_decomposition_c_1D45A, .kde = &lxb_unicode_decomposition_k_1D45A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45B[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45B[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45B[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45B = {.cp = 0x1D45B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45B, .cde = &lxb_unicode_decomposition_c_1D45B, .kde = &lxb_unicode_decomposition_k_1D45B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45C[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45C[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45C[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45C = {.cp = 0x1D45C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45C, .cde = &lxb_unicode_decomposition_c_1D45C, .kde = &lxb_unicode_decomposition_k_1D45C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45D[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45D[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45D[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45D = {.cp = 0x1D45D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45D, .cde = &lxb_unicode_decomposition_c_1D45D, .kde = &lxb_unicode_decomposition_k_1D45D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45E[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45E[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45E[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45E = {.cp = 0x1D45E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45E, .cde = &lxb_unicode_decomposition_c_1D45E, .kde = &lxb_unicode_decomposition_k_1D45E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D45F[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D45F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D45F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D45F[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D45F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D45F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D45F[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D45F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D45F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D45F = {.cp = 0x1D45F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D45F, .cde = &lxb_unicode_decomposition_c_1D45F, .kde = &lxb_unicode_decomposition_k_1D45F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D460[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D460 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D460, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D460[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D460 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D460, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D460[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D460 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D460, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D460 = {.cp = 0x1D460, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D460, .cde = &lxb_unicode_decomposition_c_1D460, .kde = &lxb_unicode_decomposition_k_1D460};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D461[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D461 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D461, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D461[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D461 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D461, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D461[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D461 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D461, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D461 = {.cp = 0x1D461, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D461, .cde = &lxb_unicode_decomposition_c_1D461, .kde = &lxb_unicode_decomposition_k_1D461};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D462[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D462 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D462, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D462[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D462 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D462, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D462[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D462 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D462, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D462 = {.cp = 0x1D462, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D462, .cde = &lxb_unicode_decomposition_c_1D462, .kde = &lxb_unicode_decomposition_k_1D462};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D463[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D463 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D463, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D463[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D463 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D463, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D463[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D463 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D463, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D463 = {.cp = 0x1D463, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D463, .cde = &lxb_unicode_decomposition_c_1D463, .kde = &lxb_unicode_decomposition_k_1D463};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D464[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D464 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D464, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D464[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D464 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D464, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D464[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D464 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D464, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D464 = {.cp = 0x1D464, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D464, .cde = &lxb_unicode_decomposition_c_1D464, .kde = &lxb_unicode_decomposition_k_1D464};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D465[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D465 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D465, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D465[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D465 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D465, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D465[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D465 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D465, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D465 = {.cp = 0x1D465, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D465, .cde = &lxb_unicode_decomposition_c_1D465, .kde = &lxb_unicode_decomposition_k_1D465};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D466[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D466 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D466, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D466[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D466 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D466, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D466[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D466 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D466, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D466 = {.cp = 0x1D466, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D466, .cde = &lxb_unicode_decomposition_c_1D466, .kde = &lxb_unicode_decomposition_k_1D466};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D467[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D467 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D467, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D467[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D467 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D467, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D467[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D467 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D467, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D467 = {.cp = 0x1D467, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D467, .cde = &lxb_unicode_decomposition_c_1D467, .kde = &lxb_unicode_decomposition_k_1D467};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D468[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D468 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D468, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D468[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D468 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D468, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D468[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D468 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D468, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D468 = {.cp = 0x1D468, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D468, .cde = &lxb_unicode_decomposition_c_1D468, .kde = &lxb_unicode_decomposition_k_1D468};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D469[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D469 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D469, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D469[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D469 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D469, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D469[1] = {0x0042};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D469 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D469, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D469 = {.cp = 0x1D469, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D469, .cde = &lxb_unicode_decomposition_c_1D469, .kde = &lxb_unicode_decomposition_k_1D469};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46A[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46A[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46A[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46A = {.cp = 0x1D46A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46A, .cde = &lxb_unicode_decomposition_c_1D46A, .kde = &lxb_unicode_decomposition_k_1D46A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46B[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46B[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46B[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46B = {.cp = 0x1D46B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46B, .cde = &lxb_unicode_decomposition_c_1D46B, .kde = &lxb_unicode_decomposition_k_1D46B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46C[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46C[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46C[1] = {0x0045};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46C = {.cp = 0x1D46C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46C, .cde = &lxb_unicode_decomposition_c_1D46C, .kde = &lxb_unicode_decomposition_k_1D46C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46D[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46D[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46D[1] = {0x0046};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46D = {.cp = 0x1D46D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46D, .cde = &lxb_unicode_decomposition_c_1D46D, .kde = &lxb_unicode_decomposition_k_1D46D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46E[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46E[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46E[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46E = {.cp = 0x1D46E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46E, .cde = &lxb_unicode_decomposition_c_1D46E, .kde = &lxb_unicode_decomposition_k_1D46E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D46F[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D46F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D46F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D46F[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D46F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D46F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D46F[1] = {0x0048};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D46F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D46F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D46F = {.cp = 0x1D46F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D46F, .cde = &lxb_unicode_decomposition_c_1D46F, .kde = &lxb_unicode_decomposition_k_1D46F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D470[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D470 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D470, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D470[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D470 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D470, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D470[1] = {0x0049};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D470 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D470, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D470 = {.cp = 0x1D470, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D470, .cde = &lxb_unicode_decomposition_c_1D470, .kde = &lxb_unicode_decomposition_k_1D470};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D471[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D471 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D471, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D471[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D471 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D471, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D471[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D471 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D471, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D471 = {.cp = 0x1D471, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D471, .cde = &lxb_unicode_decomposition_c_1D471, .kde = &lxb_unicode_decomposition_k_1D471};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D472[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D472 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D472, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D472[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D472 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D472, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D472[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D472 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D472, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D472 = {.cp = 0x1D472, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D472, .cde = &lxb_unicode_decomposition_c_1D472, .kde = &lxb_unicode_decomposition_k_1D472};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D473[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D473 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D473, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D473[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D473 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D473, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D473[1] = {0x004C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D473 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D473, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D473 = {.cp = 0x1D473, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D473, .cde = &lxb_unicode_decomposition_c_1D473, .kde = &lxb_unicode_decomposition_k_1D473};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D474[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D474 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D474, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D474[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D474 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D474, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D474[1] = {0x004D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D474 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D474, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D474 = {.cp = 0x1D474, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D474, .cde = &lxb_unicode_decomposition_c_1D474, .kde = &lxb_unicode_decomposition_k_1D474};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D475[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D475 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D475, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D475[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D475 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D475, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D475[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D475 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D475, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D475 = {.cp = 0x1D475, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D475, .cde = &lxb_unicode_decomposition_c_1D475, .kde = &lxb_unicode_decomposition_k_1D475};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D476[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D476, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D476[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D476, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D476[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D476 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D476, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D476 = {.cp = 0x1D476, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D476, .cde = &lxb_unicode_decomposition_c_1D476, .kde = &lxb_unicode_decomposition_k_1D476};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D477[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D477, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D477[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D477, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D477[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D477 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D477, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D477 = {.cp = 0x1D477, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D477, .cde = &lxb_unicode_decomposition_c_1D477, .kde = &lxb_unicode_decomposition_k_1D477};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D478[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D478 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D478, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D478[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D478 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D478, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D478[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D478 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D478, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D478 = {.cp = 0x1D478, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D478, .cde = &lxb_unicode_decomposition_c_1D478, .kde = &lxb_unicode_decomposition_k_1D478};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D479[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D479 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D479, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D479[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D479 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D479, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D479[1] = {0x0052};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D479 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D479, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D479 = {.cp = 0x1D479, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D479, .cde = &lxb_unicode_decomposition_c_1D479, .kde = &lxb_unicode_decomposition_k_1D479};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47A[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47A[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47A[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47A = {.cp = 0x1D47A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47A, .cde = &lxb_unicode_decomposition_c_1D47A, .kde = &lxb_unicode_decomposition_k_1D47A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47B[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47B[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47B[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47B = {.cp = 0x1D47B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47B, .cde = &lxb_unicode_decomposition_c_1D47B, .kde = &lxb_unicode_decomposition_k_1D47B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47C[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47C[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47C[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47C = {.cp = 0x1D47C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47C, .cde = &lxb_unicode_decomposition_c_1D47C, .kde = &lxb_unicode_decomposition_k_1D47C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47D[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47D = {.cp = 0x1D47D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47D, .cde = &lxb_unicode_decomposition_c_1D47D, .kde = &lxb_unicode_decomposition_k_1D47D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47E[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47E[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47E[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47E = {.cp = 0x1D47E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47E, .cde = &lxb_unicode_decomposition_c_1D47E, .kde = &lxb_unicode_decomposition_k_1D47E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D47F[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D47F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D47F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D47F[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D47F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D47F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D47F[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D47F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D47F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D47F = {.cp = 0x1D47F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D47F, .cde = &lxb_unicode_decomposition_c_1D47F, .kde = &lxb_unicode_decomposition_k_1D47F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D480[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D480 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D480, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D480[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D480 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D480, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D480[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D480 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D480, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D480 = {.cp = 0x1D480, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D480, .cde = &lxb_unicode_decomposition_c_1D480, .kde = &lxb_unicode_decomposition_k_1D480};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D481[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D481 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D481, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D481[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D481 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D481, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D481[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D481 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D481, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D481 = {.cp = 0x1D481, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D481, .cde = &lxb_unicode_decomposition_c_1D481, .kde = &lxb_unicode_decomposition_k_1D481};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D482[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D482 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D482, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D482[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D482 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D482, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D482[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D482 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D482, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D482 = {.cp = 0x1D482, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D482, .cde = &lxb_unicode_decomposition_c_1D482, .kde = &lxb_unicode_decomposition_k_1D482};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D483[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D483 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D483, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D483[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D483 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D483, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D483[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D483 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D483, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D483 = {.cp = 0x1D483, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D483, .cde = &lxb_unicode_decomposition_c_1D483, .kde = &lxb_unicode_decomposition_k_1D483};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D484[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D484 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D484, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D484[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D484 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D484, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D484[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D484 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D484, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D484 = {.cp = 0x1D484, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D484, .cde = &lxb_unicode_decomposition_c_1D484, .kde = &lxb_unicode_decomposition_k_1D484};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D485[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D485 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D485, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D485[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D485 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D485, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D485[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D485 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D485, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D485 = {.cp = 0x1D485, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D485, .cde = &lxb_unicode_decomposition_c_1D485, .kde = &lxb_unicode_decomposition_k_1D485};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D486[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D486 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D486, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D486[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D486 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D486, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D486[1] = {0x0065};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D486 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D486, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D486 = {.cp = 0x1D486, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D486, .cde = &lxb_unicode_decomposition_c_1D486, .kde = &lxb_unicode_decomposition_k_1D486};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D487[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D487 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D487, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D487[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D487 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D487, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D487[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D487 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D487, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D487 = {.cp = 0x1D487, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D487, .cde = &lxb_unicode_decomposition_c_1D487, .kde = &lxb_unicode_decomposition_k_1D487};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D488[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D488 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D488, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D488[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D488 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D488, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D488[1] = {0x0067};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D488 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D488, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D488 = {.cp = 0x1D488, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D488, .cde = &lxb_unicode_decomposition_c_1D488, .kde = &lxb_unicode_decomposition_k_1D488};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D489[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D489 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D489, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D489[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D489 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D489, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D489[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D489 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D489, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D489 = {.cp = 0x1D489, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D489, .cde = &lxb_unicode_decomposition_c_1D489, .kde = &lxb_unicode_decomposition_k_1D489};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48A[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48A[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48A[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48A = {.cp = 0x1D48A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48A, .cde = &lxb_unicode_decomposition_c_1D48A, .kde = &lxb_unicode_decomposition_k_1D48A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48B[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48B[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48B[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48B = {.cp = 0x1D48B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48B, .cde = &lxb_unicode_decomposition_c_1D48B, .kde = &lxb_unicode_decomposition_k_1D48B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48C[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48C[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48C[1] = {0x006B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48C = {.cp = 0x1D48C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48C, .cde = &lxb_unicode_decomposition_c_1D48C, .kde = &lxb_unicode_decomposition_k_1D48C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48D[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48D[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48D[1] = {0x006C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48D = {.cp = 0x1D48D, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48D, .cde = &lxb_unicode_decomposition_c_1D48D, .kde = &lxb_unicode_decomposition_k_1D48D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48E[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48E[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48E[1] = {0x006D};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48E = {.cp = 0x1D48E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48E, .cde = &lxb_unicode_decomposition_c_1D48E, .kde = &lxb_unicode_decomposition_k_1D48E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D48F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D48F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D48F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D48F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D48F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D48F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D48F[1] = {0x006E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D48F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D48F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D48F = {.cp = 0x1D48F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D48F, .cde = &lxb_unicode_decomposition_c_1D48F, .kde = &lxb_unicode_decomposition_k_1D48F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D490[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D490 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D490, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D490[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D490 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D490, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D490[1] = {0x006F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D490 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D490, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D490 = {.cp = 0x1D490, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D490, .cde = &lxb_unicode_decomposition_c_1D490, .kde = &lxb_unicode_decomposition_k_1D490};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D491[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D491 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D491, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D491[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D491 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D491, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D491[1] = {0x0070};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D491 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D491, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D491 = {.cp = 0x1D491, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D491, .cde = &lxb_unicode_decomposition_c_1D491, .kde = &lxb_unicode_decomposition_k_1D491};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D492[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D492 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D492, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D492[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D492 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D492, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D492[1] = {0x0071};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D492 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D492, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D492 = {.cp = 0x1D492, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D492, .cde = &lxb_unicode_decomposition_c_1D492, .kde = &lxb_unicode_decomposition_k_1D492};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D493[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D493 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D493, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D493[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D493 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D493, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D493[1] = {0x0072};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D493 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D493, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D493 = {.cp = 0x1D493, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D493, .cde = &lxb_unicode_decomposition_c_1D493, .kde = &lxb_unicode_decomposition_k_1D493};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D494[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D494 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D494, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D494[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D494 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D494, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D494[1] = {0x0073};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D494 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D494, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D494 = {.cp = 0x1D494, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D494, .cde = &lxb_unicode_decomposition_c_1D494, .kde = &lxb_unicode_decomposition_k_1D494};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D495[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D495 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D495, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D495[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D495 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D495, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D495[1] = {0x0074};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D495 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D495, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D495 = {.cp = 0x1D495, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D495, .cde = &lxb_unicode_decomposition_c_1D495, .kde = &lxb_unicode_decomposition_k_1D495};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D496[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D496 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D496, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D496[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D496 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D496, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D496[1] = {0x0075};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D496 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D496, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D496 = {.cp = 0x1D496, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D496, .cde = &lxb_unicode_decomposition_c_1D496, .kde = &lxb_unicode_decomposition_k_1D496};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D497[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D497 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D497, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D497[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D497 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D497, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D497[1] = {0x0076};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D497 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D497, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D497 = {.cp = 0x1D497, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D497, .cde = &lxb_unicode_decomposition_c_1D497, .kde = &lxb_unicode_decomposition_k_1D497};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D498[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D498 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D498, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D498[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D498 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D498, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D498[1] = {0x0077};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D498 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D498, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D498 = {.cp = 0x1D498, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D498, .cde = &lxb_unicode_decomposition_c_1D498, .kde = &lxb_unicode_decomposition_k_1D498};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D499[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D499 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D499, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D499[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D499 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D499, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D499[1] = {0x0078};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D499 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D499, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D499 = {.cp = 0x1D499, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D499, .cde = &lxb_unicode_decomposition_c_1D499, .kde = &lxb_unicode_decomposition_k_1D499};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49A[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D49A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49A[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D49A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49A[1] = {0x0079};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D49A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49A = {.cp = 0x1D49A, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49A, .cde = &lxb_unicode_decomposition_c_1D49A, .kde = &lxb_unicode_decomposition_k_1D49A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49B[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D49B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49B[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D49B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49B[1] = {0x007A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D49B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49B = {.cp = 0x1D49B, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49B, .cde = &lxb_unicode_decomposition_c_1D49B, .kde = &lxb_unicode_decomposition_k_1D49B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D49C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D49C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49C[1] = {0x0041};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D49C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49C = {.cp = 0x1D49C, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49C, .cde = &lxb_unicode_decomposition_c_1D49C, .kde = &lxb_unicode_decomposition_k_1D49C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49E[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D49E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49E[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D49E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49E[1] = {0x0043};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D49E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49E = {.cp = 0x1D49E, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49E, .cde = &lxb_unicode_decomposition_c_1D49E, .kde = &lxb_unicode_decomposition_k_1D49E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D49F[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D49F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D49F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D49F[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D49F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D49F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D49F[1] = {0x0044};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D49F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D49F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D49F = {.cp = 0x1D49F, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D49F, .cde = &lxb_unicode_decomposition_c_1D49F, .kde = &lxb_unicode_decomposition_k_1D49F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4A2[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4A2[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4A2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4A2[1] = {0x0047};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4A2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4A2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4A2 = {.cp = 0x1D4A2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4A2, .cde = &lxb_unicode_decomposition_c_1D4A2, .kde = &lxb_unicode_decomposition_k_1D4A2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4A5[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4A5[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4A5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4A5[1] = {0x004A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4A5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4A5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4A5 = {.cp = 0x1D4A5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4A5, .cde = &lxb_unicode_decomposition_c_1D4A5, .kde = &lxb_unicode_decomposition_k_1D4A5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4A6[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4A6[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4A6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4A6[1] = {0x004B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4A6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4A6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4A6 = {.cp = 0x1D4A6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4A6, .cde = &lxb_unicode_decomposition_c_1D4A6, .kde = &lxb_unicode_decomposition_k_1D4A6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4A9[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4A9[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4A9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4A9[1] = {0x004E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4A9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4A9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4A9 = {.cp = 0x1D4A9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4A9, .cde = &lxb_unicode_decomposition_c_1D4A9, .kde = &lxb_unicode_decomposition_k_1D4A9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4AA[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4AA[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4AA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4AA[1] = {0x004F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4AA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4AA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4AA = {.cp = 0x1D4AA, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4AA, .cde = &lxb_unicode_decomposition_c_1D4AA, .kde = &lxb_unicode_decomposition_k_1D4AA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4AB[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4AB[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4AB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4AB[1] = {0x0050};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4AB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4AB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4AB = {.cp = 0x1D4AB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4AB, .cde = &lxb_unicode_decomposition_c_1D4AB, .kde = &lxb_unicode_decomposition_k_1D4AB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4AC[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4AC[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4AC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4AC[1] = {0x0051};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4AC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4AC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4AC = {.cp = 0x1D4AC, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4AC, .cde = &lxb_unicode_decomposition_c_1D4AC, .kde = &lxb_unicode_decomposition_k_1D4AC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4AE[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4AE[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4AE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4AE[1] = {0x0053};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4AE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4AE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4AE = {.cp = 0x1D4AE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4AE, .cde = &lxb_unicode_decomposition_c_1D4AE, .kde = &lxb_unicode_decomposition_k_1D4AE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4AF[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4AF[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4AF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4AF[1] = {0x0054};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4AF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4AF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4AF = {.cp = 0x1D4AF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4AF, .cde = &lxb_unicode_decomposition_c_1D4AF, .kde = &lxb_unicode_decomposition_k_1D4AF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B0[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B0[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B0[1] = {0x0055};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B0 = {.cp = 0x1D4B0, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B0, .cde = &lxb_unicode_decomposition_c_1D4B0, .kde = &lxb_unicode_decomposition_k_1D4B0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B1[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B1[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B1[1] = {0x0056};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B1 = {.cp = 0x1D4B1, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B1, .cde = &lxb_unicode_decomposition_c_1D4B1, .kde = &lxb_unicode_decomposition_k_1D4B1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B2[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B2[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B2[1] = {0x0057};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B2 = {.cp = 0x1D4B2, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B2, .cde = &lxb_unicode_decomposition_c_1D4B2, .kde = &lxb_unicode_decomposition_k_1D4B2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B3[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B3[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B3[1] = {0x0058};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B3 = {.cp = 0x1D4B3, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B3, .cde = &lxb_unicode_decomposition_c_1D4B3, .kde = &lxb_unicode_decomposition_k_1D4B3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B4[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B4[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B4[1] = {0x0059};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B4 = {.cp = 0x1D4B4, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B4, .cde = &lxb_unicode_decomposition_c_1D4B4, .kde = &lxb_unicode_decomposition_k_1D4B4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B5[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B5[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B5[1] = {0x005A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B5 = {.cp = 0x1D4B5, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B5, .cde = &lxb_unicode_decomposition_c_1D4B5, .kde = &lxb_unicode_decomposition_k_1D4B5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B6[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B6[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B6[1] = {0x0061};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B6 = {.cp = 0x1D4B6, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B6, .cde = &lxb_unicode_decomposition_c_1D4B6, .kde = &lxb_unicode_decomposition_k_1D4B6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B7[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B7[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B7[1] = {0x0062};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B7 = {.cp = 0x1D4B7, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B7, .cde = &lxb_unicode_decomposition_c_1D4B7, .kde = &lxb_unicode_decomposition_k_1D4B7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B8[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B8[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B8[1] = {0x0063};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B8 = {.cp = 0x1D4B8, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B8, .cde = &lxb_unicode_decomposition_c_1D4B8, .kde = &lxb_unicode_decomposition_k_1D4B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4B9[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4B9[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4B9[1] = {0x0064};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4B9 = {.cp = 0x1D4B9, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4B9, .cde = &lxb_unicode_decomposition_c_1D4B9, .kde = &lxb_unicode_decomposition_k_1D4B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4BB[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4BB[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4BB[1] = {0x0066};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4BB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4BB = {.cp = 0x1D4BB, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4BB, .cde = &lxb_unicode_decomposition_c_1D4BB, .kde = &lxb_unicode_decomposition_k_1D4BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4BD[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4BD[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4BD[1] = {0x0068};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4BD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4BD = {.cp = 0x1D4BD, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4BD, .cde = &lxb_unicode_decomposition_c_1D4BD, .kde = &lxb_unicode_decomposition_k_1D4BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4BE[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4BE[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4BE[1] = {0x0069};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4BE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4BE = {.cp = 0x1D4BE, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4BE, .cde = &lxb_unicode_decomposition_c_1D4BE, .kde = &lxb_unicode_decomposition_k_1D4BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_1D4BF[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_1D4BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_c_1D4BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_1D4BF[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_1D4BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp_k_1D4BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__1D4BF[1] = {0x006A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__1D4BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE_FONT, .mapping = lxb_unicode_decomposition_cp__1D4BF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_1D4BF = {.cp = 0x1D4BF, .ccc = 0, .quick = LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__1D4BF, .cde = &lxb_unicode_decomposition_c_1D4BF, .kde = &lxb_unicode_decomposition_k_1D4BF};
static const lxb_unicode_data_t lxb_unicode_data_1D15E = {&lxb_unicode_entry_1D15E, &lxb_unicode_idna_map_1D15E};
static const lxb_unicode_data_t lxb_unicode_data_1D15F = {&lxb_unicode_entry_1D15F, &lxb_unicode_idna_map_1D15F};
static const lxb_unicode_data_t lxb_unicode_data_1D160 = {&lxb_unicode_entry_1D160, &lxb_unicode_idna_map_1D160};
static const lxb_unicode_data_t lxb_unicode_data_1D161 = {&lxb_unicode_entry_1D161, &lxb_unicode_idna_map_1D161};
static const lxb_unicode_data_t lxb_unicode_data_1D162 = {&lxb_unicode_entry_1D162, &lxb_unicode_idna_map_1D162};
static const lxb_unicode_data_t lxb_unicode_data_1D163 = {&lxb_unicode_entry_1D163, &lxb_unicode_idna_map_1D163};
static const lxb_unicode_data_t lxb_unicode_data_1D164 = {&lxb_unicode_entry_1D164, &lxb_unicode_idna_map_1D164};
static const lxb_unicode_data_t lxb_unicode_data_1D165 = {&lxb_unicode_entry_1D165, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D166 = {&lxb_unicode_entry_1D166, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D167 = {&lxb_unicode_entry_1D167, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D168 = {&lxb_unicode_entry_1D168, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D169 = {&lxb_unicode_entry_1D169, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D16D = {&lxb_unicode_entry_1D16D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D16E = {&lxb_unicode_entry_1D16E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D16F = {&lxb_unicode_entry_1D16F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D170 = {&lxb_unicode_entry_1D170, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D171 = {&lxb_unicode_entry_1D171, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D172 = {&lxb_unicode_entry_1D172, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D17B = {&lxb_unicode_entry_1D17B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D17C = {&lxb_unicode_entry_1D17C, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D17D = {&lxb_unicode_entry_1D17D, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D17E = {&lxb_unicode_entry_1D17E, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D17F = {&lxb_unicode_entry_1D17F, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D180 = {&lxb_unicode_entry_1D180, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D181 = {&lxb_unicode_entry_1D181, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D182 = {&lxb_unicode_entry_1D182, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D185 = {&lxb_unicode_entry_1D185, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D186 = {&lxb_unicode_entry_1D186, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D187 = {&lxb_unicode_entry_1D187, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D188 = {&lxb_unicode_entry_1D188, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D189 = {&lxb_unicode_entry_1D189, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D18A = {&lxb_unicode_entry_1D18A, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D18B = {&lxb_unicode_entry_1D18B, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D1AA = {&lxb_unicode_entry_1D1AA, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D1AB = {&lxb_unicode_entry_1D1AB, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D1AC = {&lxb_unicode_entry_1D1AC, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D1AD = {&lxb_unicode_entry_1D1AD, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D1BB = {&lxb_unicode_entry_1D1BB, &lxb_unicode_idna_map_1D1BB};
static const lxb_unicode_data_t lxb_unicode_data_1D1BC = {&lxb_unicode_entry_1D1BC, &lxb_unicode_idna_map_1D1BC};
static const lxb_unicode_data_t lxb_unicode_data_1D1BD = {&lxb_unicode_entry_1D1BD, &lxb_unicode_idna_map_1D1BD};
static const lxb_unicode_data_t lxb_unicode_data_1D1BE = {&lxb_unicode_entry_1D1BE, &lxb_unicode_idna_map_1D1BE};
static const lxb_unicode_data_t lxb_unicode_data_1D1BF = {&lxb_unicode_entry_1D1BF, &lxb_unicode_idna_map_1D1BF};
static const lxb_unicode_data_t lxb_unicode_data_1D1C0 = {&lxb_unicode_entry_1D1C0, &lxb_unicode_idna_map_1D1C0};
static const lxb_unicode_data_t lxb_unicode_data_1D242 = {&lxb_unicode_entry_1D242, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D243 = {&lxb_unicode_entry_1D243, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D244 = {&lxb_unicode_entry_1D244, NULL};
static const lxb_unicode_data_t lxb_unicode_data_1D400 = {&lxb_unicode_entry_1D400, &lxb_unicode_idna_map_1D400};
static const lxb_unicode_data_t lxb_unicode_data_1D401 = {&lxb_unicode_entry_1D401, &lxb_unicode_idna_map_1D401};
static const lxb_unicode_data_t lxb_unicode_data_1D402 = {&lxb_unicode_entry_1D402, &lxb_unicode_idna_map_1D402};
static const lxb_unicode_data_t lxb_unicode_data_1D403 = {&lxb_unicode_entry_1D403, &lxb_unicode_idna_map_1D403};
static const lxb_unicode_data_t lxb_unicode_data_1D404 = {&lxb_unicode_entry_1D404, &lxb_unicode_idna_map_1D404};
static const lxb_unicode_data_t lxb_unicode_data_1D405 = {&lxb_unicode_entry_1D405, &lxb_unicode_idna_map_1D405};
static const lxb_unicode_data_t lxb_unicode_data_1D406 = {&lxb_unicode_entry_1D406, &lxb_unicode_idna_map_1D406};
static const lxb_unicode_data_t lxb_unicode_data_1D407 = {&lxb_unicode_entry_1D407, &lxb_unicode_idna_map_1D407};
static const lxb_unicode_data_t lxb_unicode_data_1D408 = {&lxb_unicode_entry_1D408, &lxb_unicode_idna_map_1D408};
static const lxb_unicode_data_t lxb_unicode_data_1D409 = {&lxb_unicode_entry_1D409, &lxb_unicode_idna_map_1D409};
static const lxb_unicode_data_t lxb_unicode_data_1D40A = {&lxb_unicode_entry_1D40A, &lxb_unicode_idna_map_1D40A};
static const lxb_unicode_data_t lxb_unicode_data_1D40B = {&lxb_unicode_entry_1D40B, &lxb_unicode_idna_map_1D40B};
static const lxb_unicode_data_t lxb_unicode_data_1D40C = {&lxb_unicode_entry_1D40C, &lxb_unicode_idna_map_1D40C};
static const lxb_unicode_data_t lxb_unicode_data_1D40D = {&lxb_unicode_entry_1D40D, &lxb_unicode_idna_map_1D40D};
static const lxb_unicode_data_t lxb_unicode_data_1D40E = {&lxb_unicode_entry_1D40E, &lxb_unicode_idna_map_1D40E};
static const lxb_unicode_data_t lxb_unicode_data_1D40F = {&lxb_unicode_entry_1D40F, &lxb_unicode_idna_map_1D40F};
static const lxb_unicode_data_t lxb_unicode_data_1D410 = {&lxb_unicode_entry_1D410, &lxb_unicode_idna_map_1D410};
static const lxb_unicode_data_t lxb_unicode_data_1D411 = {&lxb_unicode_entry_1D411, &lxb_unicode_idna_map_1D411};
static const lxb_unicode_data_t lxb_unicode_data_1D412 = {&lxb_unicode_entry_1D412, &lxb_unicode_idna_map_1D412};
static const lxb_unicode_data_t lxb_unicode_data_1D413 = {&lxb_unicode_entry_1D413, &lxb_unicode_idna_map_1D413};
static const lxb_unicode_data_t lxb_unicode_data_1D414 = {&lxb_unicode_entry_1D414, &lxb_unicode_idna_map_1D414};
static const lxb_unicode_data_t lxb_unicode_data_1D415 = {&lxb_unicode_entry_1D415, &lxb_unicode_idna_map_1D415};
static const lxb_unicode_data_t lxb_unicode_data_1D416 = {&lxb_unicode_entry_1D416, &lxb_unicode_idna_map_1D416};
static const lxb_unicode_data_t lxb_unicode_data_1D417 = {&lxb_unicode_entry_1D417, &lxb_unicode_idna_map_1D417};
static const lxb_unicode_data_t lxb_unicode_data_1D418 = {&lxb_unicode_entry_1D418, &lxb_unicode_idna_map_1D418};
static const lxb_unicode_data_t lxb_unicode_data_1D419 = {&lxb_unicode_entry_1D419, &lxb_unicode_idna_map_1D419};
static const lxb_unicode_data_t lxb_unicode_data_1D41A = {&lxb_unicode_entry_1D41A, &lxb_unicode_idna_map_1D41A};
static const lxb_unicode_data_t lxb_unicode_data_1D41B = {&lxb_unicode_entry_1D41B, &lxb_unicode_idna_map_1D41B};
static const lxb_unicode_data_t lxb_unicode_data_1D41C = {&lxb_unicode_entry_1D41C, &lxb_unicode_idna_map_1D41C};
static const lxb_unicode_data_t lxb_unicode_data_1D41D = {&lxb_unicode_entry_1D41D, &lxb_unicode_idna_map_1D41D};
static const lxb_unicode_data_t lxb_unicode_data_1D41E = {&lxb_unicode_entry_1D41E, &lxb_unicode_idna_map_1D41E};
static const lxb_unicode_data_t lxb_unicode_data_1D41F = {&lxb_unicode_entry_1D41F, &lxb_unicode_idna_map_1D41F};
static const lxb_unicode_data_t lxb_unicode_data_1D420 = {&lxb_unicode_entry_1D420, &lxb_unicode_idna_map_1D420};
static const lxb_unicode_data_t lxb_unicode_data_1D421 = {&lxb_unicode_entry_1D421, &lxb_unicode_idna_map_1D421};
static const lxb_unicode_data_t lxb_unicode_data_1D422 = {&lxb_unicode_entry_1D422, &lxb_unicode_idna_map_1D422};
static const lxb_unicode_data_t lxb_unicode_data_1D423 = {&lxb_unicode_entry_1D423, &lxb_unicode_idna_map_1D423};
static const lxb_unicode_data_t lxb_unicode_data_1D424 = {&lxb_unicode_entry_1D424, &lxb_unicode_idna_map_1D424};
static const lxb_unicode_data_t lxb_unicode_data_1D425 = {&lxb_unicode_entry_1D425, &lxb_unicode_idna_map_1D425};
static const lxb_unicode_data_t lxb_unicode_data_1D426 = {&lxb_unicode_entry_1D426, &lxb_unicode_idna_map_1D426};
static const lxb_unicode_data_t lxb_unicode_data_1D427 = {&lxb_unicode_entry_1D427, &lxb_unicode_idna_map_1D427};
static const lxb_unicode_data_t lxb_unicode_data_1D428 = {&lxb_unicode_entry_1D428, &lxb_unicode_idna_map_1D428};
static const lxb_unicode_data_t lxb_unicode_data_1D429 = {&lxb_unicode_entry_1D429, &lxb_unicode_idna_map_1D429};
static const lxb_unicode_data_t lxb_unicode_data_1D42A = {&lxb_unicode_entry_1D42A, &lxb_unicode_idna_map_1D42A};
static const lxb_unicode_data_t lxb_unicode_data_1D42B = {&lxb_unicode_entry_1D42B, &lxb_unicode_idna_map_1D42B};
static const lxb_unicode_data_t lxb_unicode_data_1D42C = {&lxb_unicode_entry_1D42C, &lxb_unicode_idna_map_1D42C};
static const lxb_unicode_data_t lxb_unicode_data_1D42D = {&lxb_unicode_entry_1D42D, &lxb_unicode_idna_map_1D42D};
static const lxb_unicode_data_t lxb_unicode_data_1D42E = {&lxb_unicode_entry_1D42E, &lxb_unicode_idna_map_1D42E};
static const lxb_unicode_data_t lxb_unicode_data_1D42F = {&lxb_unicode_entry_1D42F, &lxb_unicode_idna_map_1D42F};
static const lxb_unicode_data_t lxb_unicode_data_1D430 = {&lxb_unicode_entry_1D430, &lxb_unicode_idna_map_1D430};
static const lxb_unicode_data_t lxb_unicode_data_1D431 = {&lxb_unicode_entry_1D431, &lxb_unicode_idna_map_1D431};
static const lxb_unicode_data_t lxb_unicode_data_1D432 = {&lxb_unicode_entry_1D432, &lxb_unicode_idna_map_1D432};
static const lxb_unicode_data_t lxb_unicode_data_1D433 = {&lxb_unicode_entry_1D433, &lxb_unicode_idna_map_1D433};
static const lxb_unicode_data_t lxb_unicode_data_1D434 = {&lxb_unicode_entry_1D434, &lxb_unicode_idna_map_1D434};
static const lxb_unicode_data_t lxb_unicode_data_1D435 = {&lxb_unicode_entry_1D435, &lxb_unicode_idna_map_1D435};
static const lxb_unicode_data_t lxb_unicode_data_1D436 = {&lxb_unicode_entry_1D436, &lxb_unicode_idna_map_1D436};
static const lxb_unicode_data_t lxb_unicode_data_1D437 = {&lxb_unicode_entry_1D437, &lxb_unicode_idna_map_1D437};
static const lxb_unicode_data_t lxb_unicode_data_1D438 = {&lxb_unicode_entry_1D438, &lxb_unicode_idna_map_1D438};
static const lxb_unicode_data_t lxb_unicode_data_1D439 = {&lxb_unicode_entry_1D439, &lxb_unicode_idna_map_1D439};
static const lxb_unicode_data_t lxb_unicode_data_1D43A = {&lxb_unicode_entry_1D43A, &lxb_unicode_idna_map_1D43A};
static const lxb_unicode_data_t lxb_unicode_data_1D43B = {&lxb_unicode_entry_1D43B, &lxb_unicode_idna_map_1D43B};
static const lxb_unicode_data_t lxb_unicode_data_1D43C = {&lxb_unicode_entry_1D43C, &lxb_unicode_idna_map_1D43C};
static const lxb_unicode_data_t lxb_unicode_data_1D43D = {&lxb_unicode_entry_1D43D, &lxb_unicode_idna_map_1D43D};
static const lxb_unicode_data_t lxb_unicode_data_1D43E = {&lxb_unicode_entry_1D43E, &lxb_unicode_idna_map_1D43E};
static const lxb_unicode_data_t lxb_unicode_data_1D43F = {&lxb_unicode_entry_1D43F, &lxb_unicode_idna_map_1D43F};
static const lxb_unicode_data_t lxb_unicode_data_1D440 = {&lxb_unicode_entry_1D440, &lxb_unicode_idna_map_1D440};
static const lxb_unicode_data_t lxb_unicode_data_1D441 = {&lxb_unicode_entry_1D441, &lxb_unicode_idna_map_1D441};
static const lxb_unicode_data_t lxb_unicode_data_1D442 = {&lxb_unicode_entry_1D442, &lxb_unicode_idna_map_1D442};
static const lxb_unicode_data_t lxb_unicode_data_1D443 = {&lxb_unicode_entry_1D443, &lxb_unicode_idna_map_1D443};
static const lxb_unicode_data_t lxb_unicode_data_1D444 = {&lxb_unicode_entry_1D444, &lxb_unicode_idna_map_1D444};
static const lxb_unicode_data_t lxb_unicode_data_1D445 = {&lxb_unicode_entry_1D445, &lxb_unicode_idna_map_1D445};
static const lxb_unicode_data_t lxb_unicode_data_1D446 = {&lxb_unicode_entry_1D446, &lxb_unicode_idna_map_1D446};
static const lxb_unicode_data_t lxb_unicode_data_1D447 = {&lxb_unicode_entry_1D447, &lxb_unicode_idna_map_1D447};
static const lxb_unicode_data_t lxb_unicode_data_1D448 = {&lxb_unicode_entry_1D448, &lxb_unicode_idna_map_1D448};
static const lxb_unicode_data_t lxb_unicode_data_1D449 = {&lxb_unicode_entry_1D449, &lxb_unicode_idna_map_1D449};
static const lxb_unicode_data_t lxb_unicode_data_1D44A = {&lxb_unicode_entry_1D44A, &lxb_unicode_idna_map_1D44A};
static const lxb_unicode_data_t lxb_unicode_data_1D44B = {&lxb_unicode_entry_1D44B, &lxb_unicode_idna_map_1D44B};
static const lxb_unicode_data_t lxb_unicode_data_1D44C = {&lxb_unicode_entry_1D44C, &lxb_unicode_idna_map_1D44C};
static const lxb_unicode_data_t lxb_unicode_data_1D44D = {&lxb_unicode_entry_1D44D, &lxb_unicode_idna_map_1D44D};
static const lxb_unicode_data_t lxb_unicode_data_1D44E = {&lxb_unicode_entry_1D44E, &lxb_unicode_idna_map_1D44E};
static const lxb_unicode_data_t lxb_unicode_data_1D44F = {&lxb_unicode_entry_1D44F, &lxb_unicode_idna_map_1D44F};
static const lxb_unicode_data_t lxb_unicode_data_1D450 = {&lxb_unicode_entry_1D450, &lxb_unicode_idna_map_1D450};
static const lxb_unicode_data_t lxb_unicode_data_1D451 = {&lxb_unicode_entry_1D451, &lxb_unicode_idna_map_1D451};
static const lxb_unicode_data_t lxb_unicode_data_1D452 = {&lxb_unicode_entry_1D452, &lxb_unicode_idna_map_1D452};
static const lxb_unicode_data_t lxb_unicode_data_1D453 = {&lxb_unicode_entry_1D453, &lxb_unicode_idna_map_1D453};
static const lxb_unicode_data_t lxb_unicode_data_1D454 = {&lxb_unicode_entry_1D454, &lxb_unicode_idna_map_1D454};
static const lxb_unicode_data_t lxb_unicode_data_1D456 = {&lxb_unicode_entry_1D456, &lxb_unicode_idna_map_1D456};
static const lxb_unicode_data_t lxb_unicode_data_1D457 = {&lxb_unicode_entry_1D457, &lxb_unicode_idna_map_1D457};
static const lxb_unicode_data_t lxb_unicode_data_1D458 = {&lxb_unicode_entry_1D458, &lxb_unicode_idna_map_1D458};
static const lxb_unicode_data_t lxb_unicode_data_1D459 = {&lxb_unicode_entry_1D459, &lxb_unicode_idna_map_1D459};
static const lxb_unicode_data_t lxb_unicode_data_1D45A = {&lxb_unicode_entry_1D45A, &lxb_unicode_idna_map_1D45A};
static const lxb_unicode_data_t lxb_unicode_data_1D45B = {&lxb_unicode_entry_1D45B, &lxb_unicode_idna_map_1D45B};
static const lxb_unicode_data_t lxb_unicode_data_1D45C = {&lxb_unicode_entry_1D45C, &lxb_unicode_idna_map_1D45C};
static const lxb_unicode_data_t lxb_unicode_data_1D45D = {&lxb_unicode_entry_1D45D, &lxb_unicode_idna_map_1D45D};
static const lxb_unicode_data_t lxb_unicode_data_1D45E = {&lxb_unicode_entry_1D45E, &lxb_unicode_idna_map_1D45E};
static const lxb_unicode_data_t lxb_unicode_data_1D45F = {&lxb_unicode_entry_1D45F, &lxb_unicode_idna_map_1D45F};
static const lxb_unicode_data_t lxb_unicode_data_1D460 = {&lxb_unicode_entry_1D460, &lxb_unicode_idna_map_1D460};
static const lxb_unicode_data_t lxb_unicode_data_1D461 = {&lxb_unicode_entry_1D461, &lxb_unicode_idna_map_1D461};
static const lxb_unicode_data_t lxb_unicode_data_1D462 = {&lxb_unicode_entry_1D462, &lxb_unicode_idna_map_1D462};
static const lxb_unicode_data_t lxb_unicode_data_1D463 = {&lxb_unicode_entry_1D463, &lxb_unicode_idna_map_1D463};
static const lxb_unicode_data_t lxb_unicode_data_1D464 = {&lxb_unicode_entry_1D464, &lxb_unicode_idna_map_1D464};
static const lxb_unicode_data_t lxb_unicode_data_1D465 = {&lxb_unicode_entry_1D465, &lxb_unicode_idna_map_1D465};
static const lxb_unicode_data_t lxb_unicode_data_1D466 = {&lxb_unicode_entry_1D466, &lxb_unicode_idna_map_1D466};
static const lxb_unicode_data_t lxb_unicode_data_1D467 = {&lxb_unicode_entry_1D467, &lxb_unicode_idna_map_1D467};
static const lxb_unicode_data_t lxb_unicode_data_1D468 = {&lxb_unicode_entry_1D468, &lxb_unicode_idna_map_1D468};
static const lxb_unicode_data_t lxb_unicode_data_1D469 = {&lxb_unicode_entry_1D469, &lxb_unicode_idna_map_1D469};
static const lxb_unicode_data_t lxb_unicode_data_1D46A = {&lxb_unicode_entry_1D46A, &lxb_unicode_idna_map_1D46A};
static const lxb_unicode_data_t lxb_unicode_data_1D46B = {&lxb_unicode_entry_1D46B, &lxb_unicode_idna_map_1D46B};
static const lxb_unicode_data_t lxb_unicode_data_1D46C = {&lxb_unicode_entry_1D46C, &lxb_unicode_idna_map_1D46C};
static const lxb_unicode_data_t lxb_unicode_data_1D46D = {&lxb_unicode_entry_1D46D, &lxb_unicode_idna_map_1D46D};
static const lxb_unicode_data_t lxb_unicode_data_1D46E = {&lxb_unicode_entry_1D46E, &lxb_unicode_idna_map_1D46E};
static const lxb_unicode_data_t lxb_unicode_data_1D46F = {&lxb_unicode_entry_1D46F, &lxb_unicode_idna_map_1D46F};
static const lxb_unicode_data_t lxb_unicode_data_1D470 = {&lxb_unicode_entry_1D470, &lxb_unicode_idna_map_1D470};
static const lxb_unicode_data_t lxb_unicode_data_1D471 = {&lxb_unicode_entry_1D471, &lxb_unicode_idna_map_1D471};
static const lxb_unicode_data_t lxb_unicode_data_1D472 = {&lxb_unicode_entry_1D472, &lxb_unicode_idna_map_1D472};
static const lxb_unicode_data_t lxb_unicode_data_1D473 = {&lxb_unicode_entry_1D473, &lxb_unicode_idna_map_1D473};
static const lxb_unicode_data_t lxb_unicode_data_1D474 = {&lxb_unicode_entry_1D474, &lxb_unicode_idna_map_1D474};
static const lxb_unicode_data_t lxb_unicode_data_1D475 = {&lxb_unicode_entry_1D475, &lxb_unicode_idna_map_1D475};
static const lxb_unicode_data_t lxb_unicode_data_1D476 = {&lxb_unicode_entry_1D476, &lxb_unicode_idna_map_1D476};
static const lxb_unicode_data_t lxb_unicode_data_1D477 = {&lxb_unicode_entry_1D477, &lxb_unicode_idna_map_1D477};
static const lxb_unicode_data_t lxb_unicode_data_1D478 = {&lxb_unicode_entry_1D478, &lxb_unicode_idna_map_1D478};
static const lxb_unicode_data_t lxb_unicode_data_1D479 = {&lxb_unicode_entry_1D479, &lxb_unicode_idna_map_1D479};
static const lxb_unicode_data_t lxb_unicode_data_1D47A = {&lxb_unicode_entry_1D47A, &lxb_unicode_idna_map_1D47A};
static const lxb_unicode_data_t lxb_unicode_data_1D47B = {&lxb_unicode_entry_1D47B, &lxb_unicode_idna_map_1D47B};
static const lxb_unicode_data_t lxb_unicode_data_1D47C = {&lxb_unicode_entry_1D47C, &lxb_unicode_idna_map_1D47C};
static const lxb_unicode_data_t lxb_unicode_data_1D47D = {&lxb_unicode_entry_1D47D, &lxb_unicode_idna_map_1D47D};
static const lxb_unicode_data_t lxb_unicode_data_1D47E = {&lxb_unicode_entry_1D47E, &lxb_unicode_idna_map_1D47E};
static const lxb_unicode_data_t lxb_unicode_data_1D47F = {&lxb_unicode_entry_1D47F, &lxb_unicode_idna_map_1D47F};
static const lxb_unicode_data_t lxb_unicode_data_1D480 = {&lxb_unicode_entry_1D480, &lxb_unicode_idna_map_1D480};
static const lxb_unicode_data_t lxb_unicode_data_1D481 = {&lxb_unicode_entry_1D481, &lxb_unicode_idna_map_1D481};
static const lxb_unicode_data_t lxb_unicode_data_1D482 = {&lxb_unicode_entry_1D482, &lxb_unicode_idna_map_1D482};
static const lxb_unicode_data_t lxb_unicode_data_1D483 = {&lxb_unicode_entry_1D483, &lxb_unicode_idna_map_1D483};
static const lxb_unicode_data_t lxb_unicode_data_1D484 = {&lxb_unicode_entry_1D484, &lxb_unicode_idna_map_1D484};
static const lxb_unicode_data_t lxb_unicode_data_1D485 = {&lxb_unicode_entry_1D485, &lxb_unicode_idna_map_1D485};
static const lxb_unicode_data_t lxb_unicode_data_1D486 = {&lxb_unicode_entry_1D486, &lxb_unicode_idna_map_1D486};
static const lxb_unicode_data_t lxb_unicode_data_1D487 = {&lxb_unicode_entry_1D487, &lxb_unicode_idna_map_1D487};
static const lxb_unicode_data_t lxb_unicode_data_1D488 = {&lxb_unicode_entry_1D488, &lxb_unicode_idna_map_1D488};
static const lxb_unicode_data_t lxb_unicode_data_1D489 = {&lxb_unicode_entry_1D489, &lxb_unicode_idna_map_1D489};
static const lxb_unicode_data_t lxb_unicode_data_1D48A = {&lxb_unicode_entry_1D48A, &lxb_unicode_idna_map_1D48A};
static const lxb_unicode_data_t lxb_unicode_data_1D48B = {&lxb_unicode_entry_1D48B, &lxb_unicode_idna_map_1D48B};
static const lxb_unicode_data_t lxb_unicode_data_1D48C = {&lxb_unicode_entry_1D48C, &lxb_unicode_idna_map_1D48C};
static const lxb_unicode_data_t lxb_unicode_data_1D48D = {&lxb_unicode_entry_1D48D, &lxb_unicode_idna_map_1D48D};
static const lxb_unicode_data_t lxb_unicode_data_1D48E = {&lxb_unicode_entry_1D48E, &lxb_unicode_idna_map_1D48E};
static const lxb_unicode_data_t lxb_unicode_data_1D48F = {&lxb_unicode_entry_1D48F, &lxb_unicode_idna_map_1D48F};
static const lxb_unicode_data_t lxb_unicode_data_1D490 = {&lxb_unicode_entry_1D490, &lxb_unicode_idna_map_1D490};
static const lxb_unicode_data_t lxb_unicode_data_1D491 = {&lxb_unicode_entry_1D491, &lxb_unicode_idna_map_1D491};
static const lxb_unicode_data_t lxb_unicode_data_1D492 = {&lxb_unicode_entry_1D492, &lxb_unicode_idna_map_1D492};
static const lxb_unicode_data_t lxb_unicode_data_1D493 = {&lxb_unicode_entry_1D493, &lxb_unicode_idna_map_1D493};
static const lxb_unicode_data_t lxb_unicode_data_1D494 = {&lxb_unicode_entry_1D494, &lxb_unicode_idna_map_1D494};
static const lxb_unicode_data_t lxb_unicode_data_1D495 = {&lxb_unicode_entry_1D495, &lxb_unicode_idna_map_1D495};
static const lxb_unicode_data_t lxb_unicode_data_1D496 = {&lxb_unicode_entry_1D496, &lxb_unicode_idna_map_1D496};
static const lxb_unicode_data_t lxb_unicode_data_1D497 = {&lxb_unicode_entry_1D497, &lxb_unicode_idna_map_1D497};
static const lxb_unicode_data_t lxb_unicode_data_1D498 = {&lxb_unicode_entry_1D498, &lxb_unicode_idna_map_1D498};
static const lxb_unicode_data_t lxb_unicode_data_1D499 = {&lxb_unicode_entry_1D499, &lxb_unicode_idna_map_1D499};
static const lxb_unicode_data_t lxb_unicode_data_1D49A = {&lxb_unicode_entry_1D49A, &lxb_unicode_idna_map_1D49A};
static const lxb_unicode_data_t lxb_unicode_data_1D49B = {&lxb_unicode_entry_1D49B, &lxb_unicode_idna_map_1D49B};
static const lxb_unicode_data_t lxb_unicode_data_1D49C = {&lxb_unicode_entry_1D49C, &lxb_unicode_idna_map_1D49C};
static const lxb_unicode_data_t lxb_unicode_data_1D49E = {&lxb_unicode_entry_1D49E, &lxb_unicode_idna_map_1D49E};
static const lxb_unicode_data_t lxb_unicode_data_1D49F = {&lxb_unicode_entry_1D49F, &lxb_unicode_idna_map_1D49F};
static const lxb_unicode_data_t lxb_unicode_data_1D4A2 = {&lxb_unicode_entry_1D4A2, &lxb_unicode_idna_map_1D4A2};
static const lxb_unicode_data_t lxb_unicode_data_1D4A5 = {&lxb_unicode_entry_1D4A5, &lxb_unicode_idna_map_1D4A5};
static const lxb_unicode_data_t lxb_unicode_data_1D4A6 = {&lxb_unicode_entry_1D4A6, &lxb_unicode_idna_map_1D4A6};
static const lxb_unicode_data_t lxb_unicode_data_1D4A9 = {&lxb_unicode_entry_1D4A9, &lxb_unicode_idna_map_1D4A9};
static const lxb_unicode_data_t lxb_unicode_data_1D4AA = {&lxb_unicode_entry_1D4AA, &lxb_unicode_idna_map_1D4AA};
static const lxb_unicode_data_t lxb_unicode_data_1D4AB = {&lxb_unicode_entry_1D4AB, &lxb_unicode_idna_map_1D4AB};
static const lxb_unicode_data_t lxb_unicode_data_1D4AC = {&lxb_unicode_entry_1D4AC, &lxb_unicode_idna_map_1D4AC};
static const lxb_unicode_data_t lxb_unicode_data_1D4AE = {&lxb_unicode_entry_1D4AE, &lxb_unicode_idna_map_1D4AE};
static const lxb_unicode_data_t lxb_unicode_data_1D4AF = {&lxb_unicode_entry_1D4AF, &lxb_unicode_idna_map_1D4AF};
static const lxb_unicode_data_t lxb_unicode_data_1D4B0 = {&lxb_unicode_entry_1D4B0, &lxb_unicode_idna_map_1D4B0};
static const lxb_unicode_data_t lxb_unicode_data_1D4B1 = {&lxb_unicode_entry_1D4B1, &lxb_unicode_idna_map_1D4B1};
static const lxb_unicode_data_t lxb_unicode_data_1D4B2 = {&lxb_unicode_entry_1D4B2, &lxb_unicode_idna_map_1D4B2};
static const lxb_unicode_data_t lxb_unicode_data_1D4B3 = {&lxb_unicode_entry_1D4B3, &lxb_unicode_idna_map_1D4B3};
static const lxb_unicode_data_t lxb_unicode_data_1D4B4 = {&lxb_unicode_entry_1D4B4, &lxb_unicode_idna_map_1D4B4};
static const lxb_unicode_data_t lxb_unicode_data_1D4B5 = {&lxb_unicode_entry_1D4B5, &lxb_unicode_idna_map_1D4B5};
static const lxb_unicode_data_t lxb_unicode_data_1D4B6 = {&lxb_unicode_entry_1D4B6, &lxb_unicode_idna_map_1D4B6};
static const lxb_unicode_data_t lxb_unicode_data_1D4B7 = {&lxb_unicode_entry_1D4B7, &lxb_unicode_idna_map_1D4B7};
static const lxb_unicode_data_t lxb_unicode_data_1D4B8 = {&lxb_unicode_entry_1D4B8, &lxb_unicode_idna_map_1D4B8};
static const lxb_unicode_data_t lxb_unicode_data_1D4B9 = {&lxb_unicode_entry_1D4B9, &lxb_unicode_idna_map_1D4B9};
static const lxb_unicode_data_t lxb_unicode_data_1D4BB = {&lxb_unicode_entry_1D4BB, &lxb_unicode_idna_map_1D4BB};
static const lxb_unicode_data_t lxb_unicode_data_1D4BD = {&lxb_unicode_entry_1D4BD, &lxb_unicode_idna_map_1D4BD};
static const lxb_unicode_data_t lxb_unicode_data_1D4BE = {&lxb_unicode_entry_1D4BE, &lxb_unicode_idna_map_1D4BE};
static const lxb_unicode_data_t lxb_unicode_data_1D4BF = {&lxb_unicode_entry_1D4BF, &lxb_unicode_idna_map_1D4BF};
static const lxb_unicode_data_t *lxb_unicode_table_23[5000] = {
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D15E,
    &lxb_unicode_data_1D15F,
    &lxb_unicode_data_1D160,
    &lxb_unicode_data_1D161,
    &lxb_unicode_data_1D162,
    &lxb_unicode_data_1D163,
    &lxb_unicode_data_1D164,
    &lxb_unicode_data_1D165,
    &lxb_unicode_data_1D166,
    &lxb_unicode_data_1D167,
    &lxb_unicode_data_1D168,
    &lxb_unicode_data_1D169,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D16D,
    &lxb_unicode_data_1D16E,
    &lxb_unicode_data_1D16F,
    &lxb_unicode_data_1D170,
    &lxb_unicode_data_1D171,
    &lxb_unicode_data_1D172,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D17B,
    &lxb_unicode_data_1D17C,
    &lxb_unicode_data_1D17D,
    &lxb_unicode_data_1D17E,
    &lxb_unicode_data_1D17F,
    &lxb_unicode_data_1D180,
    &lxb_unicode_data_1D181,
    &lxb_unicode_data_1D182,
    NULL,
    NULL,
    &lxb_unicode_data_1D185,
    &lxb_unicode_data_1D186,
    &lxb_unicode_data_1D187,
    &lxb_unicode_data_1D188,
    &lxb_unicode_data_1D189,
    &lxb_unicode_data_1D18A,
    &lxb_unicode_data_1D18B,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D1AA,
    &lxb_unicode_data_1D1AB,
    &lxb_unicode_data_1D1AC,
    &lxb_unicode_data_1D1AD,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D1BB,
    &lxb_unicode_data_1D1BC,
    &lxb_unicode_data_1D1BD,
    &lxb_unicode_data_1D1BE,
    &lxb_unicode_data_1D1BF,
    &lxb_unicode_data_1D1C0,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D242,
    &lxb_unicode_data_1D243,
    &lxb_unicode_data_1D244,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    NULL,
    &lxb_unicode_data_1D400,
    &lxb_unicode_data_1D401,
    &lxb_unicode_data_1D402,
    &lxb_unicode_data_1D403,
    &lxb_unicode_data_1D404,
    &lxb_unicode_data_1D405,
    &lxb_unicode_data_1D406,
    &lxb_unicode_data_1D407,
    &lxb_unicode_data_1D408,
    &lxb_unicode_data_1D409,
    &lxb_unicode_data_1D40A,
    &lxb_unicode_data_1D40B,
    &lxb_unicode_data_1D40C,
    &lxb_unicode_data_1D40D,
    &lxb_unicode_data_1D40E,
    &lxb_unicode_data_1D40F,
    &lxb_unicode_data_1D410,
    &lxb_unicode_data_1D411,
    &lxb_unicode_data_1D412,
    &lxb_unicode_data_1D413,
    &lxb_unicode_data_1D414,
    &lxb_unicode_data_1D415,
    &lxb_unicode_data_1D416,
    &lxb_unicode_data_1D417,
    &lxb_unicode_data_1D418,
    &lxb_unicode_data_1D419,
    &lxb_unicode_data_1D41A,
    &lxb_unicode_data_1D41B,
    &lxb_unicode_data_1D41C,
    &lxb_unicode_data_1D41D,
    &lxb_unicode_data_1D41E,
    &lxb_unicode_data_1D41F,
    &lxb_unicode_data_1D420,
    &lxb_unicode_data_1D421,
    &lxb_unicode_data_1D422,
    &lxb_unicode_data_1D423,
    &lxb_unicode_data_1D424,
    &lxb_unicode_data_1D425,
    &lxb_unicode_data_1D426,
    &lxb_unicode_data_1D427,
    &lxb_unicode_data_1D428,
    &lxb_unicode_data_1D429,
    &lxb_unicode_data_1D42A,
    &lxb_unicode_data_1D42B,
    &lxb_unicode_data_1D42C,
    &lxb_unicode_data_1D42D,
    &lxb_unicode_data_1D42E,
    &lxb_unicode_data_1D42F,
    &lxb_unicode_data_1D430,
    &lxb_unicode_data_1D431,
    &lxb_unicode_data_1D432,
    &lxb_unicode_data_1D433,
    &lxb_unicode_data_1D434,
    &lxb_unicode_data_1D435,
    &lxb_unicode_data_1D436,
    &lxb_unicode_data_1D437,
    &lxb_unicode_data_1D438,
    &lxb_unicode_data_1D439,
    &lxb_unicode_data_1D43A,
    &lxb_unicode_data_1D43B,
    &lxb_unicode_data_1D43C,
    &lxb_unicode_data_1D43D,
    &lxb_unicode_data_1D43E,
    &lxb_unicode_data_1D43F,
    &lxb_unicode_data_1D440,
    &lxb_unicode_data_1D441,
    &lxb_unicode_data_1D442,
    &lxb_unicode_data_1D443,
    &lxb_unicode_data_1D444,
    &lxb_unicode_data_1D445,
    &lxb_unicode_data_1D446,
    &lxb_unicode_data_1D447,
    &lxb_unicode_data_1D448,
    &lxb_unicode_data_1D449,
    &lxb_unicode_data_1D44A,
    &lxb_unicode_data_1D44B,
    &lxb_unicode_data_1D44C,
    &lxb_unicode_data_1D44D,
    &lxb_unicode_data_1D44E,
    &lxb_unicode_data_1D44F,
    &lxb_unicode_data_1D450,
    &lxb_unicode_data_1D451,
    &lxb_unicode_data_1D452,
    &lxb_unicode_data_1D453,
    &lxb_unicode_data_1D454,
    NULL,
    &lxb_unicode_data_1D456,
    &lxb_unicode_data_1D457,
    &lxb_unicode_data_1D458,
    &lxb_unicode_data_1D459,
    &lxb_unicode_data_1D45A,
    &lxb_unicode_data_1D45B,
    &lxb_unicode_data_1D45C,
    &lxb_unicode_data_1D45D,
    &lxb_unicode_data_1D45E,
    &lxb_unicode_data_1D45F,
    &lxb_unicode_data_1D460,
    &lxb_unicode_data_1D461,
    &lxb_unicode_data_1D462,
    &lxb_unicode_data_1D463,
    &lxb_unicode_data_1D464,
    &lxb_unicode_data_1D465,
    &lxb_unicode_data_1D466,
    &lxb_unicode_data_1D467,
    &lxb_unicode_data_1D468,
    &lxb_unicode_data_1D469,
    &lxb_unicode_data_1D46A,
    &lxb_unicode_data_1D46B,
    &lxb_unicode_data_1D46C,
    &lxb_unicode_data_1D46D,
    &lxb_unicode_data_1D46E,
    &lxb_unicode_data_1D46F,
    &lxb_unicode_data_1D470,
    &lxb_unicode_data_1D471,
    &lxb_unicode_data_1D472,
    &lxb_unicode_data_1D473,
    &lxb_unicode_data_1D474,
    &lxb_unicode_data_1D475,
    &lxb_unicode_data_1D476,
    &lxb_unicode_data_1D477,
    &lxb_unicode_data_1D478,
    &lxb_unicode_data_1D479,
    &lxb_unicode_data_1D47A,
    &lxb_unicode_data_1D47B,
    &lxb_unicode_data_1D47C,
    &lxb_unicode_data_1D47D,
    &lxb_unicode_data_1D47E,
    &lxb_unicode_data_1D47F,
    &lxb_unicode_data_1D480,
    &lxb_unicode_data_1D481,
    &lxb_unicode_data_1D482,
    &lxb_unicode_data_1D483,
    &lxb_unicode_data_1D484,
    &lxb_unicode_data_1D485,
    &lxb_unicode_data_1D486,
    &lxb_unicode_data_1D487,
    &lxb_unicode_data_1D488,
    &lxb_unicode_data_1D489,
    &lxb_unicode_data_1D48A,
    &lxb_unicode_data_1D48B,
    &lxb_unicode_data_1D48C,
    &lxb_unicode_data_1D48D,
    &lxb_unicode_data_1D48E,
    &lxb_unicode_data_1D48F,
    &lxb_unicode_data_1D490,
    &lxb_unicode_data_1D491,
    &lxb_unicode_data_1D492,
    &lxb_unicode_data_1D493,
    &lxb_unicode_data_1D494,
    &lxb_unicode_data_1D495,
    &lxb_unicode_data_1D496,
    &lxb_unicode_data_1D497,
    &lxb_unicode_data_1D498,
    &lxb_unicode_data_1D499,
    &lxb_unicode_data_1D49A,
    &lxb_unicode_data_1D49B,
    &lxb_unicode_data_1D49C,
    NULL,
    &lxb_unicode_data_1D49E,
    &lxb_unicode_data_1D49F,
    NULL,
    NULL,
    &lxb_unicode_data_1D4A2,
    NULL,
    NULL,
    &lxb_unicode_data_1D4A5,
    &lxb_unicode_data_1D4A6,
    NULL,
    NULL,
    &lxb_unicode_data_1D4A9,
    &lxb_unicode_data_1D4AA,
    &lxb_unicode_data_1D4AB,
    &lxb_unicode_data_1D4AC,
    NULL,
    &lxb_unicode_data_1D4AE,
    &lxb_unicode_data_1D4AF,
    &lxb_unicode_data_1D4B0,
    &lxb_unicode_data_1D4B1,
    &lxb_unicode_data_1D4B2,
    &lxb_unicode_data_1D4B3,
    &lxb_unicode_data_1D4B4,
    &lxb_unicode_data_1D4B5,
    &lxb_unicode_data_1D4B6,
    &lxb_unicode_data_1D4B7,
    &lxb_unicode_data_1D4B8,
    &lxb_unicode_data_1D4B9,
    NULL,
    &lxb_unicode_data_1D4BB,
    NULL,
    &lxb_unicode_data_1D4BD,
    &lxb_unicode_data_1D4BE,
    &lxb_unicode_data_1D4BF
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_23_H */
