/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_TABLES_39_H
#define LEXBOR_UNICODE_TABLES_39_H

#ifdef __cplusplus
extern "C" {
#endif


static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B8 = {.cps = (lxb_codepoint_t[]) {0x8688}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9B9 = {.cps = (lxb_codepoint_t[]) {0x870E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9BA = {.cps = (lxb_codepoint_t[]) {0x86E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9BB = {.cps = (lxb_codepoint_t[]) {0x8779}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9BC = {.cps = (lxb_codepoint_t[]) {0x8728}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9BD = {.cps = (lxb_codepoint_t[]) {0x876B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9BE = {.cps = (lxb_codepoint_t[]) {0x8786}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C0 = {.cps = (lxb_codepoint_t[]) {0x87E1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C1 = {.cps = (lxb_codepoint_t[]) {0x8801}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C2 = {.cps = (lxb_codepoint_t[]) {0x45F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C3 = {.cps = (lxb_codepoint_t[]) {0x8860}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C4 = {.cps = (lxb_codepoint_t[]) {0x8863}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C5 = {.cps = (lxb_codepoint_t[]) {0x27667}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C6 = {.cps = (lxb_codepoint_t[]) {0x88D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C7 = {.cps = (lxb_codepoint_t[]) {0x88DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C8 = {.cps = (lxb_codepoint_t[]) {0x4635}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9C9 = {.cps = (lxb_codepoint_t[]) {0x88FA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CA = {.cps = (lxb_codepoint_t[]) {0x34BB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CB = {.cps = (lxb_codepoint_t[]) {0x278AE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CC = {.cps = (lxb_codepoint_t[]) {0x27966}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CD = {.cps = (lxb_codepoint_t[]) {0x46BE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CE = {.cps = (lxb_codepoint_t[]) {0x46C7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9CF = {.cps = (lxb_codepoint_t[]) {0x8AA0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D0 = {.cps = (lxb_codepoint_t[]) {0x8AED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D1 = {.cps = (lxb_codepoint_t[]) {0x8B8A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D2 = {.cps = (lxb_codepoint_t[]) {0x8C55}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D3 = {.cps = (lxb_codepoint_t[]) {0x27CA8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D4 = {.cps = (lxb_codepoint_t[]) {0x8CAB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D5 = {.cps = (lxb_codepoint_t[]) {0x8CC1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D6 = {.cps = (lxb_codepoint_t[]) {0x8D1B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D7 = {.cps = (lxb_codepoint_t[]) {0x8D77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D8 = {.cps = (lxb_codepoint_t[]) {0x27F2F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9D9 = {.cps = (lxb_codepoint_t[]) {0x20804}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DA = {.cps = (lxb_codepoint_t[]) {0x8DCB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DB = {.cps = (lxb_codepoint_t[]) {0x8DBC}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DC = {.cps = (lxb_codepoint_t[]) {0x8DF0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DD = {.cps = (lxb_codepoint_t[]) {0x208DE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DE = {.cps = (lxb_codepoint_t[]) {0x8ED4}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9DF = {.cps = (lxb_codepoint_t[]) {0x8F38}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E0 = {.cps = (lxb_codepoint_t[]) {0x285D2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E1 = {.cps = (lxb_codepoint_t[]) {0x285ED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E2 = {.cps = (lxb_codepoint_t[]) {0x9094}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E3 = {.cps = (lxb_codepoint_t[]) {0x90F1}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E4 = {.cps = (lxb_codepoint_t[]) {0x9111}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E5 = {.cps = (lxb_codepoint_t[]) {0x2872E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E6 = {.cps = (lxb_codepoint_t[]) {0x911B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E7 = {.cps = (lxb_codepoint_t[]) {0x9238}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E8 = {.cps = (lxb_codepoint_t[]) {0x92D7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9E9 = {.cps = (lxb_codepoint_t[]) {0x92D8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9EA = {.cps = (lxb_codepoint_t[]) {0x927C}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9EB = {.cps = (lxb_codepoint_t[]) {0x93F9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9EC = {.cps = (lxb_codepoint_t[]) {0x9415}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9ED = {.cps = (lxb_codepoint_t[]) {0x28BFA}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9EE = {.cps = (lxb_codepoint_t[]) {0x958B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9EF = {.cps = (lxb_codepoint_t[]) {0x4995}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F0 = {.cps = (lxb_codepoint_t[]) {0x95B7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F1 = {.cps = (lxb_codepoint_t[]) {0x28D77}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F2 = {.cps = (lxb_codepoint_t[]) {0x49E6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F3 = {.cps = (lxb_codepoint_t[]) {0x96C3}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F4 = {.cps = (lxb_codepoint_t[]) {0x5DB2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F5 = {.cps = (lxb_codepoint_t[]) {0x9723}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F6 = {.cps = (lxb_codepoint_t[]) {0x29145}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F7 = {.cps = (lxb_codepoint_t[]) {0x2921A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F8 = {.cps = (lxb_codepoint_t[]) {0x4A6E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9F9 = {.cps = (lxb_codepoint_t[]) {0x4A76}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FA = {.cps = (lxb_codepoint_t[]) {0x97E0}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FB = {.cps = (lxb_codepoint_t[]) {0x2940A}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FC = {.cps = (lxb_codepoint_t[]) {0x4AB2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FD = {.cps = (lxb_codepoint_t[]) {0x29496}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FE = {.cps = (lxb_codepoint_t[]) {0x980B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2F9FF = {.cps = (lxb_codepoint_t[]) {0x980B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA00 = {.cps = (lxb_codepoint_t[]) {0x9829}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA01 = {.cps = (lxb_codepoint_t[]) {0x295B6}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA02 = {.cps = (lxb_codepoint_t[]) {0x98E2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA03 = {.cps = (lxb_codepoint_t[]) {0x4B33}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA04 = {.cps = (lxb_codepoint_t[]) {0x9929}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA05 = {.cps = (lxb_codepoint_t[]) {0x99A7}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA06 = {.cps = (lxb_codepoint_t[]) {0x99C2}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA07 = {.cps = (lxb_codepoint_t[]) {0x99FE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA08 = {.cps = (lxb_codepoint_t[]) {0x4BCE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA09 = {.cps = (lxb_codepoint_t[]) {0x29B30}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0A = {.cps = (lxb_codepoint_t[]) {0x9B12}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0B = {.cps = (lxb_codepoint_t[]) {0x9C40}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0C = {.cps = (lxb_codepoint_t[]) {0x9CFD}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0D = {.cps = (lxb_codepoint_t[]) {0x4CCE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0E = {.cps = (lxb_codepoint_t[]) {0x4CED}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA0F = {.cps = (lxb_codepoint_t[]) {0x9D67}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA10 = {.cps = (lxb_codepoint_t[]) {0x2A0CE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA11 = {.cps = (lxb_codepoint_t[]) {0x4CF8}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA12 = {.cps = (lxb_codepoint_t[]) {0x2A105}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA13 = {.cps = (lxb_codepoint_t[]) {0x2A20E}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA14 = {.cps = (lxb_codepoint_t[]) {0x2A291}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA15 = {.cps = (lxb_codepoint_t[]) {0x9EBB}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA16 = {.cps = (lxb_codepoint_t[]) {0x4D56}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA17 = {.cps = (lxb_codepoint_t[]) {0x9EF9}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA18 = {.cps = (lxb_codepoint_t[]) {0x9EFE}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA19 = {.cps = (lxb_codepoint_t[]) {0x9F05}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA1A = {.cps = (lxb_codepoint_t[]) {0x9F0F}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA1B = {.cps = (lxb_codepoint_t[]) {0x9F16}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA1C = {.cps = (lxb_codepoint_t[]) {0x9F3B}, .length = 1};
static const lxb_unicode_idna_map_t lxb_unicode_idna_map_2FA1D = {.cps = (lxb_codepoint_t[]) {0x2A600}, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B8[1] = {0x8688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B8[1] = {0x8688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B8[1] = {0x8688};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B8 = {.cp = 0x2F9B8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B8, .cde = &lxb_unicode_decomposition_c_2F9B8, .kde = &lxb_unicode_decomposition_k_2F9B8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9B9[1] = {0x870E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9B9[1] = {0x870E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9B9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9B9[1] = {0x870E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9B9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9B9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9B9 = {.cp = 0x2F9B9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9B9, .cde = &lxb_unicode_decomposition_c_2F9B9, .kde = &lxb_unicode_decomposition_k_2F9B9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BA[1] = {0x86E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BA[1] = {0x86E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BA[1] = {0x86E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BA = {.cp = 0x2F9BA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BA, .cde = &lxb_unicode_decomposition_c_2F9BA, .kde = &lxb_unicode_decomposition_k_2F9BA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BB[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BB[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BB[1] = {0x8779};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BB = {.cp = 0x2F9BB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BB, .cde = &lxb_unicode_decomposition_c_2F9BB, .kde = &lxb_unicode_decomposition_k_2F9BB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BC[1] = {0x8728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BC[1] = {0x8728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BC[1] = {0x8728};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BC = {.cp = 0x2F9BC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BC, .cde = &lxb_unicode_decomposition_c_2F9BC, .kde = &lxb_unicode_decomposition_k_2F9BC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BD[1] = {0x876B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BD[1] = {0x876B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BD[1] = {0x876B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BD = {.cp = 0x2F9BD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BD, .cde = &lxb_unicode_decomposition_c_2F9BD, .kde = &lxb_unicode_decomposition_k_2F9BD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BE[1] = {0x8786};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BE[1] = {0x8786};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BE[1] = {0x8786};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BE = {.cp = 0x2F9BE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BE, .cde = &lxb_unicode_decomposition_c_2F9BE, .kde = &lxb_unicode_decomposition_k_2F9BE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9BF[1] = {0x45D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9BF[1] = {0x45D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9BF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9BF[1] = {0x45D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9BF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9BF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9BF = {.cp = 0x2F9BF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9BF, .cde = &lxb_unicode_decomposition_c_2F9BF, .kde = &lxb_unicode_decomposition_k_2F9BF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C0[1] = {0x87E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C0[1] = {0x87E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C0[1] = {0x87E1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C0 = {.cp = 0x2F9C0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C0, .cde = &lxb_unicode_decomposition_c_2F9C0, .kde = &lxb_unicode_decomposition_k_2F9C0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C1[1] = {0x8801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C1[1] = {0x8801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C1[1] = {0x8801};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C1 = {.cp = 0x2F9C1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C1, .cde = &lxb_unicode_decomposition_c_2F9C1, .kde = &lxb_unicode_decomposition_k_2F9C1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C2[1] = {0x45F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C2[1] = {0x45F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C2[1] = {0x45F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C2 = {.cp = 0x2F9C2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C2, .cde = &lxb_unicode_decomposition_c_2F9C2, .kde = &lxb_unicode_decomposition_k_2F9C2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C3[1] = {0x8860};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C3[1] = {0x8860};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C3[1] = {0x8860};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C3 = {.cp = 0x2F9C3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C3, .cde = &lxb_unicode_decomposition_c_2F9C3, .kde = &lxb_unicode_decomposition_k_2F9C3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C4[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C4[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C4[1] = {0x8863};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C4 = {.cp = 0x2F9C4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C4, .cde = &lxb_unicode_decomposition_c_2F9C4, .kde = &lxb_unicode_decomposition_k_2F9C4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C5[1] = {0x27667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C5[1] = {0x27667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C5[1] = {0x27667};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C5 = {.cp = 0x2F9C5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C5, .cde = &lxb_unicode_decomposition_c_2F9C5, .kde = &lxb_unicode_decomposition_k_2F9C5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C6[1] = {0x88D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C6[1] = {0x88D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C6[1] = {0x88D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C6 = {.cp = 0x2F9C6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C6, .cde = &lxb_unicode_decomposition_c_2F9C6, .kde = &lxb_unicode_decomposition_k_2F9C6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C7[1] = {0x88DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C7[1] = {0x88DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C7[1] = {0x88DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C7 = {.cp = 0x2F9C7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C7, .cde = &lxb_unicode_decomposition_c_2F9C7, .kde = &lxb_unicode_decomposition_k_2F9C7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C8[1] = {0x4635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C8[1] = {0x4635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C8[1] = {0x4635};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C8 = {.cp = 0x2F9C8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C8, .cde = &lxb_unicode_decomposition_c_2F9C8, .kde = &lxb_unicode_decomposition_k_2F9C8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9C9[1] = {0x88FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9C9[1] = {0x88FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9C9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9C9[1] = {0x88FA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9C9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9C9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9C9 = {.cp = 0x2F9C9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9C9, .cde = &lxb_unicode_decomposition_c_2F9C9, .kde = &lxb_unicode_decomposition_k_2F9C9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CA[1] = {0x34BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CA[1] = {0x34BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CA[1] = {0x34BB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CA = {.cp = 0x2F9CA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CA, .cde = &lxb_unicode_decomposition_c_2F9CA, .kde = &lxb_unicode_decomposition_k_2F9CA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CB[1] = {0x278AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CB[1] = {0x278AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CB[1] = {0x278AE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CB = {.cp = 0x2F9CB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CB, .cde = &lxb_unicode_decomposition_c_2F9CB, .kde = &lxb_unicode_decomposition_k_2F9CB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CC[1] = {0x27966};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CC[1] = {0x27966};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CC[1] = {0x27966};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CC = {.cp = 0x2F9CC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CC, .cde = &lxb_unicode_decomposition_c_2F9CC, .kde = &lxb_unicode_decomposition_k_2F9CC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CD[1] = {0x46BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CD[1] = {0x46BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CD[1] = {0x46BE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CD = {.cp = 0x2F9CD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CD, .cde = &lxb_unicode_decomposition_c_2F9CD, .kde = &lxb_unicode_decomposition_k_2F9CD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CE[1] = {0x46C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CE[1] = {0x46C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CE[1] = {0x46C7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CE = {.cp = 0x2F9CE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CE, .cde = &lxb_unicode_decomposition_c_2F9CE, .kde = &lxb_unicode_decomposition_k_2F9CE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9CF[1] = {0x8AA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9CF[1] = {0x8AA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9CF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9CF[1] = {0x8AA0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9CF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9CF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9CF = {.cp = 0x2F9CF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9CF, .cde = &lxb_unicode_decomposition_c_2F9CF, .kde = &lxb_unicode_decomposition_k_2F9CF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D0[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D0[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D0[1] = {0x8AED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D0 = {.cp = 0x2F9D0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D0, .cde = &lxb_unicode_decomposition_c_2F9D0, .kde = &lxb_unicode_decomposition_k_2F9D0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D1[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D1[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D1[1] = {0x8B8A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D1 = {.cp = 0x2F9D1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D1, .cde = &lxb_unicode_decomposition_c_2F9D1, .kde = &lxb_unicode_decomposition_k_2F9D1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D2[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D2[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D2[1] = {0x8C55};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D2 = {.cp = 0x2F9D2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D2, .cde = &lxb_unicode_decomposition_c_2F9D2, .kde = &lxb_unicode_decomposition_k_2F9D2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D3[1] = {0x27CA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D3[1] = {0x27CA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D3[1] = {0x27CA8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D3 = {.cp = 0x2F9D3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D3, .cde = &lxb_unicode_decomposition_c_2F9D3, .kde = &lxb_unicode_decomposition_k_2F9D3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D4[1] = {0x8CAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D4[1] = {0x8CAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D4[1] = {0x8CAB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D4 = {.cp = 0x2F9D4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D4, .cde = &lxb_unicode_decomposition_c_2F9D4, .kde = &lxb_unicode_decomposition_k_2F9D4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D5[1] = {0x8CC1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D5[1] = {0x8CC1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D5[1] = {0x8CC1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D5 = {.cp = 0x2F9D5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D5, .cde = &lxb_unicode_decomposition_c_2F9D5, .kde = &lxb_unicode_decomposition_k_2F9D5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D6[1] = {0x8D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D6[1] = {0x8D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D6[1] = {0x8D1B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D6 = {.cp = 0x2F9D6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D6, .cde = &lxb_unicode_decomposition_c_2F9D6, .kde = &lxb_unicode_decomposition_k_2F9D6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D7[1] = {0x8D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D7[1] = {0x8D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D7[1] = {0x8D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D7 = {.cp = 0x2F9D7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D7, .cde = &lxb_unicode_decomposition_c_2F9D7, .kde = &lxb_unicode_decomposition_k_2F9D7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D8[1] = {0x27F2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D8[1] = {0x27F2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D8[1] = {0x27F2F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D8 = {.cp = 0x2F9D8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D8, .cde = &lxb_unicode_decomposition_c_2F9D8, .kde = &lxb_unicode_decomposition_k_2F9D8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9D9[1] = {0x20804};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9D9[1] = {0x20804};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9D9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9D9[1] = {0x20804};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9D9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9D9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9D9 = {.cp = 0x2F9D9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9D9, .cde = &lxb_unicode_decomposition_c_2F9D9, .kde = &lxb_unicode_decomposition_k_2F9D9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DA[1] = {0x8DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DA[1] = {0x8DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DA[1] = {0x8DCB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DA = {.cp = 0x2F9DA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DA, .cde = &lxb_unicode_decomposition_c_2F9DA, .kde = &lxb_unicode_decomposition_k_2F9DA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DB[1] = {0x8DBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DB[1] = {0x8DBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DB[1] = {0x8DBC};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DB = {.cp = 0x2F9DB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DB, .cde = &lxb_unicode_decomposition_c_2F9DB, .kde = &lxb_unicode_decomposition_k_2F9DB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DC[1] = {0x8DF0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DC[1] = {0x8DF0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DC[1] = {0x8DF0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DC = {.cp = 0x2F9DC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DC, .cde = &lxb_unicode_decomposition_c_2F9DC, .kde = &lxb_unicode_decomposition_k_2F9DC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DD[1] = {0x208DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DD[1] = {0x208DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DD[1] = {0x208DE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DD = {.cp = 0x2F9DD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DD, .cde = &lxb_unicode_decomposition_c_2F9DD, .kde = &lxb_unicode_decomposition_k_2F9DD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DE[1] = {0x8ED4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DE[1] = {0x8ED4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DE[1] = {0x8ED4};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DE = {.cp = 0x2F9DE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DE, .cde = &lxb_unicode_decomposition_c_2F9DE, .kde = &lxb_unicode_decomposition_k_2F9DE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9DF[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9DF[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9DF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9DF[1] = {0x8F38};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9DF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9DF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9DF = {.cp = 0x2F9DF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9DF, .cde = &lxb_unicode_decomposition_c_2F9DF, .kde = &lxb_unicode_decomposition_k_2F9DF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E0[1] = {0x285D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E0[1] = {0x285D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E0[1] = {0x285D2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E0 = {.cp = 0x2F9E0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E0, .cde = &lxb_unicode_decomposition_c_2F9E0, .kde = &lxb_unicode_decomposition_k_2F9E0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E1[1] = {0x285ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E1[1] = {0x285ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E1[1] = {0x285ED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E1 = {.cp = 0x2F9E1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E1, .cde = &lxb_unicode_decomposition_c_2F9E1, .kde = &lxb_unicode_decomposition_k_2F9E1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E2[1] = {0x9094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E2[1] = {0x9094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E2[1] = {0x9094};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E2 = {.cp = 0x2F9E2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E2, .cde = &lxb_unicode_decomposition_c_2F9E2, .kde = &lxb_unicode_decomposition_k_2F9E2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E3[1] = {0x90F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E3[1] = {0x90F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E3[1] = {0x90F1};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E3 = {.cp = 0x2F9E3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E3, .cde = &lxb_unicode_decomposition_c_2F9E3, .kde = &lxb_unicode_decomposition_k_2F9E3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E4[1] = {0x9111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E4[1] = {0x9111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E4[1] = {0x9111};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E4 = {.cp = 0x2F9E4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E4, .cde = &lxb_unicode_decomposition_c_2F9E4, .kde = &lxb_unicode_decomposition_k_2F9E4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E5[1] = {0x2872E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E5[1] = {0x2872E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E5[1] = {0x2872E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E5 = {.cp = 0x2F9E5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E5, .cde = &lxb_unicode_decomposition_c_2F9E5, .kde = &lxb_unicode_decomposition_k_2F9E5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E6[1] = {0x911B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E6[1] = {0x911B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E6[1] = {0x911B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E6 = {.cp = 0x2F9E6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E6, .cde = &lxb_unicode_decomposition_c_2F9E6, .kde = &lxb_unicode_decomposition_k_2F9E6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E7[1] = {0x9238};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E7[1] = {0x9238};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E7[1] = {0x9238};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E7 = {.cp = 0x2F9E7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E7, .cde = &lxb_unicode_decomposition_c_2F9E7, .kde = &lxb_unicode_decomposition_k_2F9E7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E8[1] = {0x92D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E8[1] = {0x92D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E8[1] = {0x92D7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E8 = {.cp = 0x2F9E8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E8, .cde = &lxb_unicode_decomposition_c_2F9E8, .kde = &lxb_unicode_decomposition_k_2F9E8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9E9[1] = {0x92D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9E9[1] = {0x92D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9E9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9E9[1] = {0x92D8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9E9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9E9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9E9 = {.cp = 0x2F9E9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9E9, .cde = &lxb_unicode_decomposition_c_2F9E9, .kde = &lxb_unicode_decomposition_k_2F9E9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9EA[1] = {0x927C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9EA[1] = {0x927C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9EA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9EA[1] = {0x927C};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9EA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9EA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9EA = {.cp = 0x2F9EA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9EA, .cde = &lxb_unicode_decomposition_c_2F9EA, .kde = &lxb_unicode_decomposition_k_2F9EA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9EB[1] = {0x93F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9EB[1] = {0x93F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9EB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9EB[1] = {0x93F9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9EB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9EB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9EB = {.cp = 0x2F9EB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9EB, .cde = &lxb_unicode_decomposition_c_2F9EB, .kde = &lxb_unicode_decomposition_k_2F9EB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9EC[1] = {0x9415};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9EC[1] = {0x9415};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9EC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9EC[1] = {0x9415};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9EC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9EC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9EC = {.cp = 0x2F9EC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9EC, .cde = &lxb_unicode_decomposition_c_2F9EC, .kde = &lxb_unicode_decomposition_k_2F9EC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9ED[1] = {0x28BFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9ED[1] = {0x28BFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9ED, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9ED[1] = {0x28BFA};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9ED = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9ED, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9ED = {.cp = 0x2F9ED, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9ED, .cde = &lxb_unicode_decomposition_c_2F9ED, .kde = &lxb_unicode_decomposition_k_2F9ED};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9EE[1] = {0x958B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9EE[1] = {0x958B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9EE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9EE[1] = {0x958B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9EE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9EE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9EE = {.cp = 0x2F9EE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9EE, .cde = &lxb_unicode_decomposition_c_2F9EE, .kde = &lxb_unicode_decomposition_k_2F9EE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9EF[1] = {0x4995};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9EF[1] = {0x4995};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9EF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9EF[1] = {0x4995};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9EF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9EF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9EF = {.cp = 0x2F9EF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9EF, .cde = &lxb_unicode_decomposition_c_2F9EF, .kde = &lxb_unicode_decomposition_k_2F9EF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F0[1] = {0x95B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F0[1] = {0x95B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F0, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F0[1] = {0x95B7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F0 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F0, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F0 = {.cp = 0x2F9F0, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F0, .cde = &lxb_unicode_decomposition_c_2F9F0, .kde = &lxb_unicode_decomposition_k_2F9F0};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F1[1] = {0x28D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F1[1] = {0x28D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F1, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F1[1] = {0x28D77};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F1 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F1, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F1 = {.cp = 0x2F9F1, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F1, .cde = &lxb_unicode_decomposition_c_2F9F1, .kde = &lxb_unicode_decomposition_k_2F9F1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F2[1] = {0x49E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F2[1] = {0x49E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F2, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F2[1] = {0x49E6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F2 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F2, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F2 = {.cp = 0x2F9F2, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F2, .cde = &lxb_unicode_decomposition_c_2F9F2, .kde = &lxb_unicode_decomposition_k_2F9F2};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F3[1] = {0x96C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F3[1] = {0x96C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F3, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F3[1] = {0x96C3};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F3 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F3, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F3 = {.cp = 0x2F9F3, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F3, .cde = &lxb_unicode_decomposition_c_2F9F3, .kde = &lxb_unicode_decomposition_k_2F9F3};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F4[1] = {0x5DB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F4[1] = {0x5DB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F4, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F4[1] = {0x5DB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F4 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F4, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F4 = {.cp = 0x2F9F4, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F4, .cde = &lxb_unicode_decomposition_c_2F9F4, .kde = &lxb_unicode_decomposition_k_2F9F4};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F5[1] = {0x9723};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F5[1] = {0x9723};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F5, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F5[1] = {0x9723};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F5 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F5, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F5 = {.cp = 0x2F9F5, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F5, .cde = &lxb_unicode_decomposition_c_2F9F5, .kde = &lxb_unicode_decomposition_k_2F9F5};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F6[1] = {0x29145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F6[1] = {0x29145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F6, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F6[1] = {0x29145};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F6 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F6, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F6 = {.cp = 0x2F9F6, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F6, .cde = &lxb_unicode_decomposition_c_2F9F6, .kde = &lxb_unicode_decomposition_k_2F9F6};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F7[1] = {0x2921A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F7[1] = {0x2921A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F7, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F7[1] = {0x2921A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F7 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F7, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F7 = {.cp = 0x2F9F7, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F7, .cde = &lxb_unicode_decomposition_c_2F9F7, .kde = &lxb_unicode_decomposition_k_2F9F7};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F8[1] = {0x4A6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F8[1] = {0x4A6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F8, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F8[1] = {0x4A6E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F8 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F8, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F8 = {.cp = 0x2F9F8, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F8, .cde = &lxb_unicode_decomposition_c_2F9F8, .kde = &lxb_unicode_decomposition_k_2F9F8};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9F9[1] = {0x4A76};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9F9[1] = {0x4A76};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9F9, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9F9[1] = {0x4A76};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9F9 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9F9, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9F9 = {.cp = 0x2F9F9, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9F9, .cde = &lxb_unicode_decomposition_c_2F9F9, .kde = &lxb_unicode_decomposition_k_2F9F9};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FA[1] = {0x97E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FA[1] = {0x97E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FA, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FA[1] = {0x97E0};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FA = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FA, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FA = {.cp = 0x2F9FA, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FA, .cde = &lxb_unicode_decomposition_c_2F9FA, .kde = &lxb_unicode_decomposition_k_2F9FA};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FB[1] = {0x2940A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FB[1] = {0x2940A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FB, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FB[1] = {0x2940A};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FB = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FB, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FB = {.cp = 0x2F9FB, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FB, .cde = &lxb_unicode_decomposition_c_2F9FB, .kde = &lxb_unicode_decomposition_k_2F9FB};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FC[1] = {0x4AB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FC[1] = {0x4AB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FC, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FC[1] = {0x4AB2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FC = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FC, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FC = {.cp = 0x2F9FC, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FC, .cde = &lxb_unicode_decomposition_c_2F9FC, .kde = &lxb_unicode_decomposition_k_2F9FC};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FD[1] = {0x29496};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FD[1] = {0x29496};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FD, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FD[1] = {0x29496};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FD = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FD, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FD = {.cp = 0x2F9FD, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FD, .cde = &lxb_unicode_decomposition_c_2F9FD, .kde = &lxb_unicode_decomposition_k_2F9FD};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FE[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FE[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FE, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FE[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FE = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FE, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FE = {.cp = 0x2F9FE, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FE, .cde = &lxb_unicode_decomposition_c_2F9FE, .kde = &lxb_unicode_decomposition_k_2F9FE};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2F9FF[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2F9FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2F9FF[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2F9FF, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2F9FF[1] = {0x980B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2F9FF = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2F9FF, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2F9FF = {.cp = 0x2F9FF, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2F9FF, .cde = &lxb_unicode_decomposition_c_2F9FF, .kde = &lxb_unicode_decomposition_k_2F9FF};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA00[1] = {0x9829};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA00[1] = {0x9829};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA00, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA00[1] = {0x9829};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA00 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA00, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA00 = {.cp = 0x2FA00, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA00, .cde = &lxb_unicode_decomposition_c_2FA00, .kde = &lxb_unicode_decomposition_k_2FA00};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA01[1] = {0x295B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA01[1] = {0x295B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA01, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA01[1] = {0x295B6};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA01 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA01, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA01 = {.cp = 0x2FA01, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA01, .cde = &lxb_unicode_decomposition_c_2FA01, .kde = &lxb_unicode_decomposition_k_2FA01};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA02[1] = {0x98E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA02[1] = {0x98E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA02, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA02[1] = {0x98E2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA02 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA02, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA02 = {.cp = 0x2FA02, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA02, .cde = &lxb_unicode_decomposition_c_2FA02, .kde = &lxb_unicode_decomposition_k_2FA02};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA03[1] = {0x4B33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA03[1] = {0x4B33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA03, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA03[1] = {0x4B33};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA03 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA03, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA03 = {.cp = 0x2FA03, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA03, .cde = &lxb_unicode_decomposition_c_2FA03, .kde = &lxb_unicode_decomposition_k_2FA03};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA04[1] = {0x9929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA04[1] = {0x9929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA04, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA04[1] = {0x9929};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA04 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA04, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA04 = {.cp = 0x2FA04, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA04, .cde = &lxb_unicode_decomposition_c_2FA04, .kde = &lxb_unicode_decomposition_k_2FA04};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA05[1] = {0x99A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA05[1] = {0x99A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA05, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA05[1] = {0x99A7};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA05 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA05, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA05 = {.cp = 0x2FA05, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA05, .cde = &lxb_unicode_decomposition_c_2FA05, .kde = &lxb_unicode_decomposition_k_2FA05};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA06[1] = {0x99C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA06[1] = {0x99C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA06, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA06[1] = {0x99C2};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA06 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA06, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA06 = {.cp = 0x2FA06, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA06, .cde = &lxb_unicode_decomposition_c_2FA06, .kde = &lxb_unicode_decomposition_k_2FA06};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA07[1] = {0x99FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA07[1] = {0x99FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA07, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA07[1] = {0x99FE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA07 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA07, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA07 = {.cp = 0x2FA07, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA07, .cde = &lxb_unicode_decomposition_c_2FA07, .kde = &lxb_unicode_decomposition_k_2FA07};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA08[1] = {0x4BCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA08[1] = {0x4BCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA08, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA08[1] = {0x4BCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA08 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA08, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA08 = {.cp = 0x2FA08, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA08, .cde = &lxb_unicode_decomposition_c_2FA08, .kde = &lxb_unicode_decomposition_k_2FA08};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA09[1] = {0x29B30};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA09[1] = {0x29B30};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA09, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA09[1] = {0x29B30};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA09 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA09, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA09 = {.cp = 0x2FA09, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA09, .cde = &lxb_unicode_decomposition_c_2FA09, .kde = &lxb_unicode_decomposition_k_2FA09};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0A[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0A[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0A[1] = {0x9B12};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0A = {.cp = 0x2FA0A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0A, .cde = &lxb_unicode_decomposition_c_2FA0A, .kde = &lxb_unicode_decomposition_k_2FA0A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0B[1] = {0x9C40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0B[1] = {0x9C40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0B[1] = {0x9C40};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0B = {.cp = 0x2FA0B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0B, .cde = &lxb_unicode_decomposition_c_2FA0B, .kde = &lxb_unicode_decomposition_k_2FA0B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0C[1] = {0x9CFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0C[1] = {0x9CFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0C[1] = {0x9CFD};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0C = {.cp = 0x2FA0C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0C, .cde = &lxb_unicode_decomposition_c_2FA0C, .kde = &lxb_unicode_decomposition_k_2FA0C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0D[1] = {0x4CCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0D[1] = {0x4CCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0D[1] = {0x4CCE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0D = {.cp = 0x2FA0D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0D, .cde = &lxb_unicode_decomposition_c_2FA0D, .kde = &lxb_unicode_decomposition_k_2FA0D};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0E[1] = {0x4CED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0E[1] = {0x4CED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0E, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0E[1] = {0x4CED};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0E = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0E, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0E = {.cp = 0x2FA0E, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0E, .cde = &lxb_unicode_decomposition_c_2FA0E, .kde = &lxb_unicode_decomposition_k_2FA0E};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA0F[1] = {0x9D67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA0F[1] = {0x9D67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA0F, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA0F[1] = {0x9D67};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA0F = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA0F, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA0F = {.cp = 0x2FA0F, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA0F, .cde = &lxb_unicode_decomposition_c_2FA0F, .kde = &lxb_unicode_decomposition_k_2FA0F};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA10[1] = {0x2A0CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA10[1] = {0x2A0CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA10, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA10[1] = {0x2A0CE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA10 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA10, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA10 = {.cp = 0x2FA10, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA10, .cde = &lxb_unicode_decomposition_c_2FA10, .kde = &lxb_unicode_decomposition_k_2FA10};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA11[1] = {0x4CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA11[1] = {0x4CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA11, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA11[1] = {0x4CF8};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA11 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA11, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA11 = {.cp = 0x2FA11, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA11, .cde = &lxb_unicode_decomposition_c_2FA11, .kde = &lxb_unicode_decomposition_k_2FA11};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA12[1] = {0x2A105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA12[1] = {0x2A105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA12, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA12[1] = {0x2A105};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA12 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA12, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA12 = {.cp = 0x2FA12, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA12, .cde = &lxb_unicode_decomposition_c_2FA12, .kde = &lxb_unicode_decomposition_k_2FA12};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA13[1] = {0x2A20E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA13[1] = {0x2A20E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA13, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA13[1] = {0x2A20E};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA13 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA13, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA13 = {.cp = 0x2FA13, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA13, .cde = &lxb_unicode_decomposition_c_2FA13, .kde = &lxb_unicode_decomposition_k_2FA13};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA14[1] = {0x2A291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA14[1] = {0x2A291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA14, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA14[1] = {0x2A291};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA14 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA14, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA14 = {.cp = 0x2FA14, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA14, .cde = &lxb_unicode_decomposition_c_2FA14, .kde = &lxb_unicode_decomposition_k_2FA14};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA15[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA15[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA15, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA15[1] = {0x9EBB};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA15 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA15, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA15 = {.cp = 0x2FA15, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA15, .cde = &lxb_unicode_decomposition_c_2FA15, .kde = &lxb_unicode_decomposition_k_2FA15};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA16[1] = {0x4D56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA16[1] = {0x4D56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA16, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA16[1] = {0x4D56};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA16 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA16, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA16 = {.cp = 0x2FA16, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA16, .cde = &lxb_unicode_decomposition_c_2FA16, .kde = &lxb_unicode_decomposition_k_2FA16};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA17[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA17[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA17, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA17[1] = {0x9EF9};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA17 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA17, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA17 = {.cp = 0x2FA17, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA17, .cde = &lxb_unicode_decomposition_c_2FA17, .kde = &lxb_unicode_decomposition_k_2FA17};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA18[1] = {0x9EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA18[1] = {0x9EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA18, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA18[1] = {0x9EFE};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA18 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA18, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA18 = {.cp = 0x2FA18, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA18, .cde = &lxb_unicode_decomposition_c_2FA18, .kde = &lxb_unicode_decomposition_k_2FA18};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA19[1] = {0x9F05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA19[1] = {0x9F05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA19, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA19[1] = {0x9F05};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA19 = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA19, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA19 = {.cp = 0x2FA19, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA19, .cde = &lxb_unicode_decomposition_c_2FA19, .kde = &lxb_unicode_decomposition_k_2FA19};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA1A[1] = {0x9F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA1A[1] = {0x9F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA1A, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA1A[1] = {0x9F0F};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA1A = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA1A, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA1A = {.cp = 0x2FA1A, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA1A, .cde = &lxb_unicode_decomposition_c_2FA1A, .kde = &lxb_unicode_decomposition_k_2FA1A};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA1B[1] = {0x9F16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA1B[1] = {0x9F16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA1B, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA1B[1] = {0x9F16};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA1B = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA1B, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA1B = {.cp = 0x2FA1B, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA1B, .cde = &lxb_unicode_decomposition_c_2FA1B, .kde = &lxb_unicode_decomposition_k_2FA1B};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA1C[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA1C[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA1C, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA1C[1] = {0x9F3B};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA1C = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA1C, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA1C = {.cp = 0x2FA1C, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA1C, .cde = &lxb_unicode_decomposition_c_2FA1C, .kde = &lxb_unicode_decomposition_k_2FA1C};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_c_2FA1D[1] = {0x2A600};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_c_2FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_c_2FA1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp_k_2FA1D[1] = {0x2A600};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition_k_2FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp_k_2FA1D, .length = 1};
static const lxb_codepoint_t lxb_unicode_decomposition_cp__2FA1D[1] = {0x2A600};
static const lxb_unicode_decomposition_t lxb_unicode_decomposition__2FA1D = {.type = LXB_UNICODE_DECOMPOSITION_TYPE__UNDEF, .mapping = lxb_unicode_decomposition_cp__2FA1D, .length = 1};
static const lxb_unicode_entry_t lxb_unicode_entry_2FA1D = {.cp = 0x2FA1D, .ccc = 0, .quick = LXB_UNICODE_NFC_QUICK_NO|LXB_UNICODE_NFD_QUICK_NO|LXB_UNICODE_NFKC_QUICK_NO|LXB_UNICODE_NFKD_QUICK_NO, .de = &lxb_unicode_decomposition__2FA1D, .cde = &lxb_unicode_decomposition_c_2FA1D, .kde = &lxb_unicode_decomposition_k_2FA1D};
static const lxb_unicode_data_t lxb_unicode_data_2F9B8 = {&lxb_unicode_entry_2F9B8, &lxb_unicode_idna_map_2F9B8};
static const lxb_unicode_data_t lxb_unicode_data_2F9B9 = {&lxb_unicode_entry_2F9B9, &lxb_unicode_idna_map_2F9B9};
static const lxb_unicode_data_t lxb_unicode_data_2F9BA = {&lxb_unicode_entry_2F9BA, &lxb_unicode_idna_map_2F9BA};
static const lxb_unicode_data_t lxb_unicode_data_2F9BB = {&lxb_unicode_entry_2F9BB, &lxb_unicode_idna_map_2F9BB};
static const lxb_unicode_data_t lxb_unicode_data_2F9BC = {&lxb_unicode_entry_2F9BC, &lxb_unicode_idna_map_2F9BC};
static const lxb_unicode_data_t lxb_unicode_data_2F9BD = {&lxb_unicode_entry_2F9BD, &lxb_unicode_idna_map_2F9BD};
static const lxb_unicode_data_t lxb_unicode_data_2F9BE = {&lxb_unicode_entry_2F9BE, &lxb_unicode_idna_map_2F9BE};
static const lxb_unicode_data_t lxb_unicode_data_2F9BF = {&lxb_unicode_entry_2F9BF, NULL};
static const lxb_unicode_data_t lxb_unicode_data_2F9C0 = {&lxb_unicode_entry_2F9C0, &lxb_unicode_idna_map_2F9C0};
static const lxb_unicode_data_t lxb_unicode_data_2F9C1 = {&lxb_unicode_entry_2F9C1, &lxb_unicode_idna_map_2F9C1};
static const lxb_unicode_data_t lxb_unicode_data_2F9C2 = {&lxb_unicode_entry_2F9C2, &lxb_unicode_idna_map_2F9C2};
static const lxb_unicode_data_t lxb_unicode_data_2F9C3 = {&lxb_unicode_entry_2F9C3, &lxb_unicode_idna_map_2F9C3};
static const lxb_unicode_data_t lxb_unicode_data_2F9C4 = {&lxb_unicode_entry_2F9C4, &lxb_unicode_idna_map_2F9C4};
static const lxb_unicode_data_t lxb_unicode_data_2F9C5 = {&lxb_unicode_entry_2F9C5, &lxb_unicode_idna_map_2F9C5};
static const lxb_unicode_data_t lxb_unicode_data_2F9C6 = {&lxb_unicode_entry_2F9C6, &lxb_unicode_idna_map_2F9C6};
static const lxb_unicode_data_t lxb_unicode_data_2F9C7 = {&lxb_unicode_entry_2F9C7, &lxb_unicode_idna_map_2F9C7};
static const lxb_unicode_data_t lxb_unicode_data_2F9C8 = {&lxb_unicode_entry_2F9C8, &lxb_unicode_idna_map_2F9C8};
static const lxb_unicode_data_t lxb_unicode_data_2F9C9 = {&lxb_unicode_entry_2F9C9, &lxb_unicode_idna_map_2F9C9};
static const lxb_unicode_data_t lxb_unicode_data_2F9CA = {&lxb_unicode_entry_2F9CA, &lxb_unicode_idna_map_2F9CA};
static const lxb_unicode_data_t lxb_unicode_data_2F9CB = {&lxb_unicode_entry_2F9CB, &lxb_unicode_idna_map_2F9CB};
static const lxb_unicode_data_t lxb_unicode_data_2F9CC = {&lxb_unicode_entry_2F9CC, &lxb_unicode_idna_map_2F9CC};
static const lxb_unicode_data_t lxb_unicode_data_2F9CD = {&lxb_unicode_entry_2F9CD, &lxb_unicode_idna_map_2F9CD};
static const lxb_unicode_data_t lxb_unicode_data_2F9CE = {&lxb_unicode_entry_2F9CE, &lxb_unicode_idna_map_2F9CE};
static const lxb_unicode_data_t lxb_unicode_data_2F9CF = {&lxb_unicode_entry_2F9CF, &lxb_unicode_idna_map_2F9CF};
static const lxb_unicode_data_t lxb_unicode_data_2F9D0 = {&lxb_unicode_entry_2F9D0, &lxb_unicode_idna_map_2F9D0};
static const lxb_unicode_data_t lxb_unicode_data_2F9D1 = {&lxb_unicode_entry_2F9D1, &lxb_unicode_idna_map_2F9D1};
static const lxb_unicode_data_t lxb_unicode_data_2F9D2 = {&lxb_unicode_entry_2F9D2, &lxb_unicode_idna_map_2F9D2};
static const lxb_unicode_data_t lxb_unicode_data_2F9D3 = {&lxb_unicode_entry_2F9D3, &lxb_unicode_idna_map_2F9D3};
static const lxb_unicode_data_t lxb_unicode_data_2F9D4 = {&lxb_unicode_entry_2F9D4, &lxb_unicode_idna_map_2F9D4};
static const lxb_unicode_data_t lxb_unicode_data_2F9D5 = {&lxb_unicode_entry_2F9D5, &lxb_unicode_idna_map_2F9D5};
static const lxb_unicode_data_t lxb_unicode_data_2F9D6 = {&lxb_unicode_entry_2F9D6, &lxb_unicode_idna_map_2F9D6};
static const lxb_unicode_data_t lxb_unicode_data_2F9D7 = {&lxb_unicode_entry_2F9D7, &lxb_unicode_idna_map_2F9D7};
static const lxb_unicode_data_t lxb_unicode_data_2F9D8 = {&lxb_unicode_entry_2F9D8, &lxb_unicode_idna_map_2F9D8};
static const lxb_unicode_data_t lxb_unicode_data_2F9D9 = {&lxb_unicode_entry_2F9D9, &lxb_unicode_idna_map_2F9D9};
static const lxb_unicode_data_t lxb_unicode_data_2F9DA = {&lxb_unicode_entry_2F9DA, &lxb_unicode_idna_map_2F9DA};
static const lxb_unicode_data_t lxb_unicode_data_2F9DB = {&lxb_unicode_entry_2F9DB, &lxb_unicode_idna_map_2F9DB};
static const lxb_unicode_data_t lxb_unicode_data_2F9DC = {&lxb_unicode_entry_2F9DC, &lxb_unicode_idna_map_2F9DC};
static const lxb_unicode_data_t lxb_unicode_data_2F9DD = {&lxb_unicode_entry_2F9DD, &lxb_unicode_idna_map_2F9DD};
static const lxb_unicode_data_t lxb_unicode_data_2F9DE = {&lxb_unicode_entry_2F9DE, &lxb_unicode_idna_map_2F9DE};
static const lxb_unicode_data_t lxb_unicode_data_2F9DF = {&lxb_unicode_entry_2F9DF, &lxb_unicode_idna_map_2F9DF};
static const lxb_unicode_data_t lxb_unicode_data_2F9E0 = {&lxb_unicode_entry_2F9E0, &lxb_unicode_idna_map_2F9E0};
static const lxb_unicode_data_t lxb_unicode_data_2F9E1 = {&lxb_unicode_entry_2F9E1, &lxb_unicode_idna_map_2F9E1};
static const lxb_unicode_data_t lxb_unicode_data_2F9E2 = {&lxb_unicode_entry_2F9E2, &lxb_unicode_idna_map_2F9E2};
static const lxb_unicode_data_t lxb_unicode_data_2F9E3 = {&lxb_unicode_entry_2F9E3, &lxb_unicode_idna_map_2F9E3};
static const lxb_unicode_data_t lxb_unicode_data_2F9E4 = {&lxb_unicode_entry_2F9E4, &lxb_unicode_idna_map_2F9E4};
static const lxb_unicode_data_t lxb_unicode_data_2F9E5 = {&lxb_unicode_entry_2F9E5, &lxb_unicode_idna_map_2F9E5};
static const lxb_unicode_data_t lxb_unicode_data_2F9E6 = {&lxb_unicode_entry_2F9E6, &lxb_unicode_idna_map_2F9E6};
static const lxb_unicode_data_t lxb_unicode_data_2F9E7 = {&lxb_unicode_entry_2F9E7, &lxb_unicode_idna_map_2F9E7};
static const lxb_unicode_data_t lxb_unicode_data_2F9E8 = {&lxb_unicode_entry_2F9E8, &lxb_unicode_idna_map_2F9E8};
static const lxb_unicode_data_t lxb_unicode_data_2F9E9 = {&lxb_unicode_entry_2F9E9, &lxb_unicode_idna_map_2F9E9};
static const lxb_unicode_data_t lxb_unicode_data_2F9EA = {&lxb_unicode_entry_2F9EA, &lxb_unicode_idna_map_2F9EA};
static const lxb_unicode_data_t lxb_unicode_data_2F9EB = {&lxb_unicode_entry_2F9EB, &lxb_unicode_idna_map_2F9EB};
static const lxb_unicode_data_t lxb_unicode_data_2F9EC = {&lxb_unicode_entry_2F9EC, &lxb_unicode_idna_map_2F9EC};
static const lxb_unicode_data_t lxb_unicode_data_2F9ED = {&lxb_unicode_entry_2F9ED, &lxb_unicode_idna_map_2F9ED};
static const lxb_unicode_data_t lxb_unicode_data_2F9EE = {&lxb_unicode_entry_2F9EE, &lxb_unicode_idna_map_2F9EE};
static const lxb_unicode_data_t lxb_unicode_data_2F9EF = {&lxb_unicode_entry_2F9EF, &lxb_unicode_idna_map_2F9EF};
static const lxb_unicode_data_t lxb_unicode_data_2F9F0 = {&lxb_unicode_entry_2F9F0, &lxb_unicode_idna_map_2F9F0};
static const lxb_unicode_data_t lxb_unicode_data_2F9F1 = {&lxb_unicode_entry_2F9F1, &lxb_unicode_idna_map_2F9F1};
static const lxb_unicode_data_t lxb_unicode_data_2F9F2 = {&lxb_unicode_entry_2F9F2, &lxb_unicode_idna_map_2F9F2};
static const lxb_unicode_data_t lxb_unicode_data_2F9F3 = {&lxb_unicode_entry_2F9F3, &lxb_unicode_idna_map_2F9F3};
static const lxb_unicode_data_t lxb_unicode_data_2F9F4 = {&lxb_unicode_entry_2F9F4, &lxb_unicode_idna_map_2F9F4};
static const lxb_unicode_data_t lxb_unicode_data_2F9F5 = {&lxb_unicode_entry_2F9F5, &lxb_unicode_idna_map_2F9F5};
static const lxb_unicode_data_t lxb_unicode_data_2F9F6 = {&lxb_unicode_entry_2F9F6, &lxb_unicode_idna_map_2F9F6};
static const lxb_unicode_data_t lxb_unicode_data_2F9F7 = {&lxb_unicode_entry_2F9F7, &lxb_unicode_idna_map_2F9F7};
static const lxb_unicode_data_t lxb_unicode_data_2F9F8 = {&lxb_unicode_entry_2F9F8, &lxb_unicode_idna_map_2F9F8};
static const lxb_unicode_data_t lxb_unicode_data_2F9F9 = {&lxb_unicode_entry_2F9F9, &lxb_unicode_idna_map_2F9F9};
static const lxb_unicode_data_t lxb_unicode_data_2F9FA = {&lxb_unicode_entry_2F9FA, &lxb_unicode_idna_map_2F9FA};
static const lxb_unicode_data_t lxb_unicode_data_2F9FB = {&lxb_unicode_entry_2F9FB, &lxb_unicode_idna_map_2F9FB};
static const lxb_unicode_data_t lxb_unicode_data_2F9FC = {&lxb_unicode_entry_2F9FC, &lxb_unicode_idna_map_2F9FC};
static const lxb_unicode_data_t lxb_unicode_data_2F9FD = {&lxb_unicode_entry_2F9FD, &lxb_unicode_idna_map_2F9FD};
static const lxb_unicode_data_t lxb_unicode_data_2F9FE = {&lxb_unicode_entry_2F9FE, &lxb_unicode_idna_map_2F9FE};
static const lxb_unicode_data_t lxb_unicode_data_2F9FF = {&lxb_unicode_entry_2F9FF, &lxb_unicode_idna_map_2F9FF};
static const lxb_unicode_data_t lxb_unicode_data_2FA00 = {&lxb_unicode_entry_2FA00, &lxb_unicode_idna_map_2FA00};
static const lxb_unicode_data_t lxb_unicode_data_2FA01 = {&lxb_unicode_entry_2FA01, &lxb_unicode_idna_map_2FA01};
static const lxb_unicode_data_t lxb_unicode_data_2FA02 = {&lxb_unicode_entry_2FA02, &lxb_unicode_idna_map_2FA02};
static const lxb_unicode_data_t lxb_unicode_data_2FA03 = {&lxb_unicode_entry_2FA03, &lxb_unicode_idna_map_2FA03};
static const lxb_unicode_data_t lxb_unicode_data_2FA04 = {&lxb_unicode_entry_2FA04, &lxb_unicode_idna_map_2FA04};
static const lxb_unicode_data_t lxb_unicode_data_2FA05 = {&lxb_unicode_entry_2FA05, &lxb_unicode_idna_map_2FA05};
static const lxb_unicode_data_t lxb_unicode_data_2FA06 = {&lxb_unicode_entry_2FA06, &lxb_unicode_idna_map_2FA06};
static const lxb_unicode_data_t lxb_unicode_data_2FA07 = {&lxb_unicode_entry_2FA07, &lxb_unicode_idna_map_2FA07};
static const lxb_unicode_data_t lxb_unicode_data_2FA08 = {&lxb_unicode_entry_2FA08, &lxb_unicode_idna_map_2FA08};
static const lxb_unicode_data_t lxb_unicode_data_2FA09 = {&lxb_unicode_entry_2FA09, &lxb_unicode_idna_map_2FA09};
static const lxb_unicode_data_t lxb_unicode_data_2FA0A = {&lxb_unicode_entry_2FA0A, &lxb_unicode_idna_map_2FA0A};
static const lxb_unicode_data_t lxb_unicode_data_2FA0B = {&lxb_unicode_entry_2FA0B, &lxb_unicode_idna_map_2FA0B};
static const lxb_unicode_data_t lxb_unicode_data_2FA0C = {&lxb_unicode_entry_2FA0C, &lxb_unicode_idna_map_2FA0C};
static const lxb_unicode_data_t lxb_unicode_data_2FA0D = {&lxb_unicode_entry_2FA0D, &lxb_unicode_idna_map_2FA0D};
static const lxb_unicode_data_t lxb_unicode_data_2FA0E = {&lxb_unicode_entry_2FA0E, &lxb_unicode_idna_map_2FA0E};
static const lxb_unicode_data_t lxb_unicode_data_2FA0F = {&lxb_unicode_entry_2FA0F, &lxb_unicode_idna_map_2FA0F};
static const lxb_unicode_data_t lxb_unicode_data_2FA10 = {&lxb_unicode_entry_2FA10, &lxb_unicode_idna_map_2FA10};
static const lxb_unicode_data_t lxb_unicode_data_2FA11 = {&lxb_unicode_entry_2FA11, &lxb_unicode_idna_map_2FA11};
static const lxb_unicode_data_t lxb_unicode_data_2FA12 = {&lxb_unicode_entry_2FA12, &lxb_unicode_idna_map_2FA12};
static const lxb_unicode_data_t lxb_unicode_data_2FA13 = {&lxb_unicode_entry_2FA13, &lxb_unicode_idna_map_2FA13};
static const lxb_unicode_data_t lxb_unicode_data_2FA14 = {&lxb_unicode_entry_2FA14, &lxb_unicode_idna_map_2FA14};
static const lxb_unicode_data_t lxb_unicode_data_2FA15 = {&lxb_unicode_entry_2FA15, &lxb_unicode_idna_map_2FA15};
static const lxb_unicode_data_t lxb_unicode_data_2FA16 = {&lxb_unicode_entry_2FA16, &lxb_unicode_idna_map_2FA16};
static const lxb_unicode_data_t lxb_unicode_data_2FA17 = {&lxb_unicode_entry_2FA17, &lxb_unicode_idna_map_2FA17};
static const lxb_unicode_data_t lxb_unicode_data_2FA18 = {&lxb_unicode_entry_2FA18, &lxb_unicode_idna_map_2FA18};
static const lxb_unicode_data_t lxb_unicode_data_2FA19 = {&lxb_unicode_entry_2FA19, &lxb_unicode_idna_map_2FA19};
static const lxb_unicode_data_t lxb_unicode_data_2FA1A = {&lxb_unicode_entry_2FA1A, &lxb_unicode_idna_map_2FA1A};
static const lxb_unicode_data_t lxb_unicode_data_2FA1B = {&lxb_unicode_entry_2FA1B, &lxb_unicode_idna_map_2FA1B};
static const lxb_unicode_data_t lxb_unicode_data_2FA1C = {&lxb_unicode_entry_2FA1C, &lxb_unicode_idna_map_2FA1C};
static const lxb_unicode_data_t lxb_unicode_data_2FA1D = {&lxb_unicode_entry_2FA1D, &lxb_unicode_idna_map_2FA1D};
static const lxb_unicode_data_t *lxb_unicode_table_39[102] = {
    &lxb_unicode_data_2F9B8,
    &lxb_unicode_data_2F9B9,
    &lxb_unicode_data_2F9BA,
    &lxb_unicode_data_2F9BB,
    &lxb_unicode_data_2F9BC,
    &lxb_unicode_data_2F9BD,
    &lxb_unicode_data_2F9BE,
    &lxb_unicode_data_2F9BF,
    &lxb_unicode_data_2F9C0,
    &lxb_unicode_data_2F9C1,
    &lxb_unicode_data_2F9C2,
    &lxb_unicode_data_2F9C3,
    &lxb_unicode_data_2F9C4,
    &lxb_unicode_data_2F9C5,
    &lxb_unicode_data_2F9C6,
    &lxb_unicode_data_2F9C7,
    &lxb_unicode_data_2F9C8,
    &lxb_unicode_data_2F9C9,
    &lxb_unicode_data_2F9CA,
    &lxb_unicode_data_2F9CB,
    &lxb_unicode_data_2F9CC,
    &lxb_unicode_data_2F9CD,
    &lxb_unicode_data_2F9CE,
    &lxb_unicode_data_2F9CF,
    &lxb_unicode_data_2F9D0,
    &lxb_unicode_data_2F9D1,
    &lxb_unicode_data_2F9D2,
    &lxb_unicode_data_2F9D3,
    &lxb_unicode_data_2F9D4,
    &lxb_unicode_data_2F9D5,
    &lxb_unicode_data_2F9D6,
    &lxb_unicode_data_2F9D7,
    &lxb_unicode_data_2F9D8,
    &lxb_unicode_data_2F9D9,
    &lxb_unicode_data_2F9DA,
    &lxb_unicode_data_2F9DB,
    &lxb_unicode_data_2F9DC,
    &lxb_unicode_data_2F9DD,
    &lxb_unicode_data_2F9DE,
    &lxb_unicode_data_2F9DF,
    &lxb_unicode_data_2F9E0,
    &lxb_unicode_data_2F9E1,
    &lxb_unicode_data_2F9E2,
    &lxb_unicode_data_2F9E3,
    &lxb_unicode_data_2F9E4,
    &lxb_unicode_data_2F9E5,
    &lxb_unicode_data_2F9E6,
    &lxb_unicode_data_2F9E7,
    &lxb_unicode_data_2F9E8,
    &lxb_unicode_data_2F9E9,
    &lxb_unicode_data_2F9EA,
    &lxb_unicode_data_2F9EB,
    &lxb_unicode_data_2F9EC,
    &lxb_unicode_data_2F9ED,
    &lxb_unicode_data_2F9EE,
    &lxb_unicode_data_2F9EF,
    &lxb_unicode_data_2F9F0,
    &lxb_unicode_data_2F9F1,
    &lxb_unicode_data_2F9F2,
    &lxb_unicode_data_2F9F3,
    &lxb_unicode_data_2F9F4,
    &lxb_unicode_data_2F9F5,
    &lxb_unicode_data_2F9F6,
    &lxb_unicode_data_2F9F7,
    &lxb_unicode_data_2F9F8,
    &lxb_unicode_data_2F9F9,
    &lxb_unicode_data_2F9FA,
    &lxb_unicode_data_2F9FB,
    &lxb_unicode_data_2F9FC,
    &lxb_unicode_data_2F9FD,
    &lxb_unicode_data_2F9FE,
    &lxb_unicode_data_2F9FF,
    &lxb_unicode_data_2FA00,
    &lxb_unicode_data_2FA01,
    &lxb_unicode_data_2FA02,
    &lxb_unicode_data_2FA03,
    &lxb_unicode_data_2FA04,
    &lxb_unicode_data_2FA05,
    &lxb_unicode_data_2FA06,
    &lxb_unicode_data_2FA07,
    &lxb_unicode_data_2FA08,
    &lxb_unicode_data_2FA09,
    &lxb_unicode_data_2FA0A,
    &lxb_unicode_data_2FA0B,
    &lxb_unicode_data_2FA0C,
    &lxb_unicode_data_2FA0D,
    &lxb_unicode_data_2FA0E,
    &lxb_unicode_data_2FA0F,
    &lxb_unicode_data_2FA10,
    &lxb_unicode_data_2FA11,
    &lxb_unicode_data_2FA12,
    &lxb_unicode_data_2FA13,
    &lxb_unicode_data_2FA14,
    &lxb_unicode_data_2FA15,
    &lxb_unicode_data_2FA16,
    &lxb_unicode_data_2FA17,
    &lxb_unicode_data_2FA18,
    &lxb_unicode_data_2FA19,
    &lxb_unicode_data_2FA1A,
    &lxb_unicode_data_2FA1B,
    &lxb_unicode_data_2FA1C,
    &lxb_unicode_data_2FA1D
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_TABLES_39_H */
