/*
 * Copyright (C) 1995-2011 University of Karlsruhe.  All right reserved.
 *
 * This file is part of libFirm.
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * Licensees holding valid libFirm Professional Edition licenses may use
 * this file in accordance with the libFirm Commercial License.
 * Agreement provided with the Software.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

/**
 * @file
 * @brief   Removal of unreachable methods.
 * @author  Hubert Schmid
 * @date    09.06.2002
 * @brief
 *  Removal of unreachable methods. The set of unreachable methods is computed
 *  by the callgraph.
 */
#ifndef FIRM_IR_ICGOPT_H
#define FIRM_IR_ICGOPT_H

#include <stddef.h>

#include "firm_types.h"
#include "begin.h"

/**
 * Removes all methods which are not reachable from "keep_arr".
 *
 * Frees all interprocedural loop information.
 */
FIRM_API void gc_irgs(size_t n_keep, ir_entity *keep_arr[]);

/**
 * Creates an ir_prog pass for gc_irgs().
 *
 * @param name     the name of this pass or NULL
 * @return  the newly created ir_graph pass
 */
FIRM_API ir_prog_pass_t *gc_irgs_pass(const char *name);

#include "end.h"

#endif
