/* Warning: automatically generated code */
#ifndef FIRM_IR_NODEOPS_H
#define FIRM_IR_NODEOPS_H

#include "firm_types.h"

#include "begin.h"

/**
 * @addtogroup ir_node
 * @{
 */

/**
 * @defgroup ASM ASM node
 *
 * executes assembler fragments of the target machine.

The node contains a template for an assembler snippet. The compiler will
replace occurences of %0 to %9 with input/output registers,
%% with a single % char. Some backends allow additional specifiers (for
example %w3, %l3, %h3 on x86 to get a 16bit, 8hit low, 8bit high part
of a register).
After the replacements the text is emitted into the final assembly.

The clobber list contains names of registers which have an undefined value
after the assembler instruction is executed; it may also contain 'memory'
or 'cc' if global state/memory changes or the condition code registers
(some backends implicitely set cc, memory clobbers on all ASM statements).

Example (an i386 instruction)::

        ASM(text="btsl %1, %0",
                input_constraints = ["=m", "r"],
                clobbers = ["cc"])

As there are no output, the %0 references the first input which is just an
address which the asm operation writes to. %1 references to an input which
is passed as a register. The condition code register has an unknown value
after the instruction.

(This format is inspired by the gcc extended asm syntax)
 * @{
 */

/**
 * Input numbers for ASM node
 */
typedef enum {
	n_ASM_mem,
	n_ASM_max = n_ASM_mem
} n_ASM;


/**
 * Test if node is a ASM
 * @returns 1 if the node is a ASM node, 0 otherwise
 */
FIRM_API int is_ASM(const ir_node *node);

/** Returns mem input of an ASM node. */
FIRM_API ir_node *get_ASM_mem(const ir_node *node);
/** Sets mem input of an ASM node. */
FIRM_API void set_ASM_mem(ir_node *node, ir_node *mem);
/** Returns input_constraints attribute of an ASM node. */
FIRM_API ir_asm_constraint* get_ASM_input_constraints(const ir_node *node);
/** Sets input_constraints attribute of an ASM node. */
FIRM_API void set_ASM_input_constraints(ir_node *node, ir_asm_constraint* input_constraints);
/** Returns output_constraints attribute of an ASM node. */
FIRM_API ir_asm_constraint* get_ASM_output_constraints(const ir_node *node);
/** Sets output_constraints attribute of an ASM node. */
FIRM_API void set_ASM_output_constraints(ir_node *node, ir_asm_constraint* output_constraints);
/** Returns clobbers attribute of an ASM node. */
FIRM_API ident** get_ASM_clobbers(const ir_node *node);
/** Sets clobbers attribute of an ASM node. */
FIRM_API void set_ASM_clobbers(ir_node *node, ident** clobbers);
/** Returns text attribute of an ASM node. */
FIRM_API ident* get_ASM_text(const ir_node *node);
/** Sets text attribute of an ASM node. */
FIRM_API void set_ASM_text(ir_node *node, ident* text);
/** @} */

/**
 * @defgroup Add Add node
 *
 * returns the sum of its operands
 * @{
 */

/**
 * Input numbers for Add node
 */
typedef enum {
	n_Add_left,
	n_Add_right,
	n_Add_max = n_Add_right
} n_Add;


/**
 * Construct an Add node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Add(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Add node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Add(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Add node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Add(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Add node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Add(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Add
 * @returns 1 if the node is a Add node, 0 otherwise
 */
FIRM_API int is_Add(const ir_node *node);

/** Returns left input of an Add node. */
FIRM_API ir_node *get_Add_left(const ir_node *node);
/** Sets left input of an Add node. */
FIRM_API void set_Add_left(ir_node *node, ir_node *left);
/** Returns right input of an Add node. */
FIRM_API ir_node *get_Add_right(const ir_node *node);
/** Sets right input of an Add node. */
FIRM_API void set_Add_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Alloc Alloc node
 *
 * allocates a block of memory.
It can be specified whether the memory should be allocated to the stack
or to the heap.
Allocates memory for one or more objects (depending on value on count input).
 * @{
 */

/**
 * Input numbers for Alloc node
 */
typedef enum {
	n_Alloc_mem,
	n_Alloc_count,
	n_Alloc_max = n_Alloc_count
} n_Alloc;


/**
 * Projection numbers for result of Alloc node (use for Proj nodes)
 */
typedef enum {
	pn_Alloc_M, /**< memory result */
	pn_Alloc_res, /**< pointer to newly allocated memory */
	pn_Alloc_X_regular, /**< control flow when no exception occurs */
	pn_Alloc_X_except, /**< control flow when exception occured */
	pn_Alloc_max = pn_Alloc_X_except
} pn_Alloc;

/**
 * Construct an Alloc node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_count number of objects to allocate
 * @param type      type of the objects to allocate
 * @param where     whether to allocate the variable on the stack or heap
*/
FIRM_API ir_node *new_rd_Alloc(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct an Alloc node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_count number of objects to allocate
 * @param type      type of the objects to allocate
 * @param where     whether to allocate the variable on the stack or heap
*/
FIRM_API ir_node *new_r_Alloc(ir_node *block, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct an Alloc node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_count number of objects to allocate
 * @param type      type of the objects to allocate
 * @param where     whether to allocate the variable on the stack or heap
*/
FIRM_API ir_node *new_d_Alloc(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct an Alloc node.
 *
 * @param irn_mem   memory dependency
 * @param irn_count number of objects to allocate
 * @param type      type of the objects to allocate
 * @param where     whether to allocate the variable on the stack or heap
*/
FIRM_API ir_node *new_Alloc(ir_node * irn_mem, ir_node * irn_count, ir_type* type, ir_where_alloc where);
/**
 * Test if node is a Alloc
 * @returns 1 if the node is a Alloc node, 0 otherwise
 */
FIRM_API int is_Alloc(const ir_node *node);

/** Returns mem input of an Alloc node. */
FIRM_API ir_node *get_Alloc_mem(const ir_node *node);
/** Sets mem input of an Alloc node. */
FIRM_API void set_Alloc_mem(ir_node *node, ir_node *mem);
/** Returns count input of an Alloc node. */
FIRM_API ir_node *get_Alloc_count(const ir_node *node);
/** Sets count input of an Alloc node. */
FIRM_API void set_Alloc_count(ir_node *node, ir_node *count);
/** Returns type attribute of an Alloc node. */
FIRM_API ir_type* get_Alloc_type(const ir_node *node);
/** Sets type attribute of an Alloc node. */
FIRM_API void set_Alloc_type(ir_node *node, ir_type* type);
/** Returns where attribute of an Alloc node. */
FIRM_API ir_where_alloc get_Alloc_where(const ir_node *node);
/** Sets where attribute of an Alloc node. */
FIRM_API void set_Alloc_where(ir_node *node, ir_where_alloc where);
/** @} */

/**
 * @defgroup Anchor Anchor node
 *
 * utiliy node used to "hold" nodes in a graph that might possibly not be
reachable by other means or which should be reachable immediately without
searching through the graph.
Each firm-graph contains exactly one anchor node whose address is always
known. All other well-known graph-nodes like Start, End, NoMem, Bad, ...
are found by looking at the respective Anchor operand.
 * @{
 */


/**
 * Test if node is a Anchor
 * @returns 1 if the node is a Anchor node, 0 otherwise
 */
FIRM_API int is_Anchor(const ir_node *node);

/** @} */

/**
 * @defgroup And And node
 *
 * returns the result of a bitwise and operation of its operands
 * @{
 */

/**
 * Input numbers for And node
 */
typedef enum {
	n_And_left,
	n_And_right,
	n_And_max = n_And_right
} n_And;


/**
 * Construct an And node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_And(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an And node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_And(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an And node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_And(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an And node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_And(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a And
 * @returns 1 if the node is a And node, 0 otherwise
 */
FIRM_API int is_And(const ir_node *node);

/** Returns left input of an And node. */
FIRM_API ir_node *get_And_left(const ir_node *node);
/** Sets left input of an And node. */
FIRM_API void set_And_left(ir_node *node, ir_node *left);
/** Returns right input of an And node. */
FIRM_API ir_node *get_And_right(const ir_node *node);
/** Sets right input of an And node. */
FIRM_API void set_And_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Bad Bad node
 *
 * Bad nodes indicate invalid input, which is values which should never be
computed.

The typical use case for the Bad node is removing unreachable code.
Frontends should set the current_block to Bad when it is clear that
following code must be unreachable (ie. after a goto or return statement).
Optimisations also set block predecessors to Bad when it becomes clear,
that a control flow edge can never be executed.

The gigo optimisations ensures that nodes with Bad as their block, get
replaced by Bad themselves. Nodes with at least 1 Bad input get exchanged
with Bad too. Exception to this rule are Block, Phi, Tuple and End node;
This is because removing inputs from a Block is hairy operation (requiring,
Phis to be shortened too for example). So instead of removing block inputs
they are set to Bad, and the actual removal is left to the control flow
optimisation phase. Block, Phi, Tuple with only Bad inputs however are
replaced by Bad right away.
 * @{
 */


/**
 * Construct a Bad node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Bad(dbg_info *dbgi, ir_graph *irg, ir_mode * mode);

/**
 * Construct a Bad node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Bad(ir_graph *irg, ir_mode * mode);

/**
 * Construct a Bad node.
 *
 * @param dbgi      A pointer to debug information.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Bad(dbg_info *dbgi, ir_mode * mode);

/**
 * Construct a Bad node.
 *
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Bad(ir_mode * mode);
/**
 * Test if node is a Bad
 * @returns 1 if the node is a Bad node, 0 otherwise
 */
FIRM_API int is_Bad(const ir_node *node);

/** @} */

/**
 * @defgroup Block Block node
 *
 * A basic block
 * @{
 */


/**
 * Construct a Block node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_rd_Block(dbg_info *dbgi, ir_graph *irg, int arity, ir_node *const * in);

/**
 * Construct a Block node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_r_Block(ir_graph *irg, int arity, ir_node *const * in);

/**
 * Construct a Block node.
 *
 * @param dbgi      A pointer to debug information.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_d_Block(dbg_info *dbgi, int arity, ir_node *const * in);

/**
 * Construct a Block node.
 *
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_Block(int arity, ir_node *const * in);
/**
 * Test if node is a Block
 * @returns 1 if the node is a Block node, 0 otherwise
 */
FIRM_API int is_Block(const ir_node *node);

/** Returns entity attribute of a Block node. */
FIRM_API ir_entity* get_Block_entity(const ir_node *node);
/** Sets entity attribute of a Block node. */
FIRM_API void set_Block_entity(ir_node *node, ir_entity* entity);
/** @} */

/**
 * @defgroup Borrow Borrow node
 *
 * Returns the borrow bit from and implied subtractions of its 2 operands
 * @{
 */

/**
 * Input numbers for Borrow node
 */
typedef enum {
	n_Borrow_left,
	n_Borrow_right,
	n_Borrow_max = n_Borrow_right
} n_Borrow;


/**
 * Construct a Borrow node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Borrow(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Borrow node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Borrow(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Borrow node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Borrow(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Borrow node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Borrow(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Borrow
 * @returns 1 if the node is a Borrow node, 0 otherwise
 */
FIRM_API int is_Borrow(const ir_node *node);

/** Returns left input of a Borrow node. */
FIRM_API ir_node *get_Borrow_left(const ir_node *node);
/** Sets left input of a Borrow node. */
FIRM_API void set_Borrow_left(ir_node *node, ir_node *left);
/** Returns right input of a Borrow node. */
FIRM_API ir_node *get_Borrow_right(const ir_node *node);
/** Sets right input of a Borrow node. */
FIRM_API void set_Borrow_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Bound Bound node
 *
 * Performs a bounds-check: if lower <= index < upper then return index,
otherwise throw an exception.
 * @{
 */

/**
 * Input numbers for Bound node
 */
typedef enum {
	n_Bound_mem,
	n_Bound_index,
	n_Bound_lower,
	n_Bound_upper,
	n_Bound_max = n_Bound_upper
} n_Bound;


/**
 * Projection numbers for result of Bound node (use for Proj nodes)
 */
typedef enum {
	pn_Bound_M, /**< memory result */
	pn_Bound_res, /**< the checked index */
	pn_Bound_X_regular, /**< control flow when no exception occurs */
	pn_Bound_X_except, /**< control flow when exception occured */
	pn_Bound_max = pn_Bound_X_except
} pn_Bound;

/**
 * Construct a Bound node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_index value to test
 * @param irn_lower lower bound (inclusive)
 * @param irn_upper upper bound (exclusive)
*/
FIRM_API ir_node *new_rd_Bound(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper);

/**
 * Construct a Bound node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_index value to test
 * @param irn_lower lower bound (inclusive)
 * @param irn_upper upper bound (exclusive)
*/
FIRM_API ir_node *new_r_Bound(ir_node *block, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper);

/**
 * Construct a Bound node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_index value to test
 * @param irn_lower lower bound (inclusive)
 * @param irn_upper upper bound (exclusive)
*/
FIRM_API ir_node *new_d_Bound(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper);

/**
 * Construct a Bound node.
 *
 * @param irn_mem   memory dependency
 * @param irn_index value to test
 * @param irn_lower lower bound (inclusive)
 * @param irn_upper upper bound (exclusive)
*/
FIRM_API ir_node *new_Bound(ir_node * irn_mem, ir_node * irn_index, ir_node * irn_lower, ir_node * irn_upper);
/**
 * Test if node is a Bound
 * @returns 1 if the node is a Bound node, 0 otherwise
 */
FIRM_API int is_Bound(const ir_node *node);

/** Returns mem input of a Bound node. */
FIRM_API ir_node *get_Bound_mem(const ir_node *node);
/** Sets mem input of a Bound node. */
FIRM_API void set_Bound_mem(ir_node *node, ir_node *mem);
/** Returns index input of a Bound node. */
FIRM_API ir_node *get_Bound_index(const ir_node *node);
/** Sets index input of a Bound node. */
FIRM_API void set_Bound_index(ir_node *node, ir_node *index);
/** Returns lower input of a Bound node. */
FIRM_API ir_node *get_Bound_lower(const ir_node *node);
/** Sets lower input of a Bound node. */
FIRM_API void set_Bound_lower(ir_node *node, ir_node *lower);
/** Returns upper input of a Bound node. */
FIRM_API ir_node *get_Bound_upper(const ir_node *node);
/** Sets upper input of a Bound node. */
FIRM_API void set_Bound_upper(ir_node *node, ir_node *upper);
/** @} */

/**
 * @defgroup Builtin Builtin node
 *
 * performs a backend-specific builtin.
 * @{
 */

/**
 * Input numbers for Builtin node
 */
typedef enum {
	n_Builtin_mem,
	n_Builtin_max = n_Builtin_mem
} n_Builtin;


/**
 * Projection numbers for result of Builtin node (use for Proj nodes)
 */
typedef enum {
	pn_Builtin_M, /**< memory result */
	pn_Builtin_max = pn_Builtin_M
} pn_Builtin;

/**
 * Construct a Builtin node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param kind      kind of builtin
 * @param type      method type for the builtin call
*/
FIRM_API ir_node *new_rd_Builtin(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type);

/**
 * Construct a Builtin node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param kind      kind of builtin
 * @param type      method type for the builtin call
*/
FIRM_API ir_node *new_r_Builtin(ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type);

/**
 * Construct a Builtin node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param kind      kind of builtin
 * @param type      method type for the builtin call
*/
FIRM_API ir_node *new_d_Builtin(dbg_info *dbgi, ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type);

/**
 * Construct a Builtin node.
 *
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param kind      kind of builtin
 * @param type      method type for the builtin call
*/
FIRM_API ir_node *new_Builtin(ir_node * irn_mem, int arity, ir_node *const * in, ir_builtin_kind kind, ir_type* type);
/**
 * Test if node is a Builtin
 * @returns 1 if the node is a Builtin node, 0 otherwise
 */
FIRM_API int is_Builtin(const ir_node *node);

/** Returns mem input of a Builtin node. */
FIRM_API ir_node *get_Builtin_mem(const ir_node *node);
/** Sets mem input of a Builtin node. */
FIRM_API void set_Builtin_mem(ir_node *node, ir_node *mem);
/** Returns kind attribute of a Builtin node. */
FIRM_API ir_builtin_kind get_Builtin_kind(const ir_node *node);
/** Sets kind attribute of a Builtin node. */
FIRM_API void set_Builtin_kind(ir_node *node, ir_builtin_kind kind);
/** Returns type attribute of a Builtin node. */
FIRM_API ir_type* get_Builtin_type(const ir_node *node);
/** Sets type attribute of a Builtin node. */
FIRM_API void set_Builtin_type(ir_node *node, ir_type* type);
/** @} */

/**
 * @defgroup Call Call node
 *
 * Calls other code. Control flow is transfered to ptr, additional
operands are passed to the called code. Called code usually performs a
return operation. The operands of this return operation are the result
of the Call node.
 * @{
 */

/**
 * Input numbers for Call node
 */
typedef enum {
	n_Call_mem,
	n_Call_ptr,
	n_Call_max = n_Call_ptr
} n_Call;


/**
 * Projection numbers for result of Call node (use for Proj nodes)
 */
typedef enum {
	pn_Call_M, /**< memory result */
	pn_Call_T_result, /**< tuple containing all results */
	pn_Call_X_regular, /**< control flow when no exception occurs */
	pn_Call_X_except, /**< control flow when exception occured */
	pn_Call_max = pn_Call_X_except
} pn_Call;

/**
 * Construct a Call node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to called code
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param type      type of the call (usually type of the called procedure)
*/
FIRM_API ir_node *new_rd_Call(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type);

/**
 * Construct a Call node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to called code
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param type      type of the call (usually type of the called procedure)
*/
FIRM_API ir_node *new_r_Call(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type);

/**
 * Construct a Call node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to called code
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param type      type of the call (usually type of the called procedure)
*/
FIRM_API ir_node *new_d_Call(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type);

/**
 * Construct a Call node.
 *
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to called code
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param type      type of the call (usually type of the called procedure)
*/
FIRM_API ir_node *new_Call(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_type* type);
/**
 * Test if node is a Call
 * @returns 1 if the node is a Call node, 0 otherwise
 */
FIRM_API int is_Call(const ir_node *node);

/** Returns mem input of a Call node. */
FIRM_API ir_node *get_Call_mem(const ir_node *node);
/** Sets mem input of a Call node. */
FIRM_API void set_Call_mem(ir_node *node, ir_node *mem);
/** Returns ptr input of a Call node. */
FIRM_API ir_node *get_Call_ptr(const ir_node *node);
/** Sets ptr input of a Call node. */
FIRM_API void set_Call_ptr(ir_node *node, ir_node *ptr);
/** Returns type attribute of a Call node. */
FIRM_API ir_type* get_Call_type(const ir_node *node);
/** Sets type attribute of a Call node. */
FIRM_API void set_Call_type(ir_node *node, ir_type* type);
/** @} */

/**
 * @defgroup Carry Carry node
 *
 * Computes the value of the carry-bit that would result when adding the 2
operands
 * @{
 */

/**
 * Input numbers for Carry node
 */
typedef enum {
	n_Carry_left,
	n_Carry_right,
	n_Carry_max = n_Carry_right
} n_Carry;


/**
 * Construct a Carry node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Carry(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Carry node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Carry(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Carry node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Carry(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Carry node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Carry(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Carry
 * @returns 1 if the node is a Carry node, 0 otherwise
 */
FIRM_API int is_Carry(const ir_node *node);

/** Returns left input of a Carry node. */
FIRM_API ir_node *get_Carry_left(const ir_node *node);
/** Sets left input of a Carry node. */
FIRM_API void set_Carry_left(ir_node *node, ir_node *left);
/** Returns right input of a Carry node. */
FIRM_API ir_node *get_Carry_right(const ir_node *node);
/** Sets right input of a Carry node. */
FIRM_API void set_Carry_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Cast Cast node
 *
 * perform a high-level type cast
 * @{
 */

/**
 * Input numbers for Cast node
 */
typedef enum {
	n_Cast_op,
	n_Cast_max = n_Cast_op
} n_Cast;


/**
 * Construct a Cast node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param type      target type of the case
*/
FIRM_API ir_node *new_rd_Cast(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_type* type);

/**
 * Construct a Cast node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param type      target type of the case
*/
FIRM_API ir_node *new_r_Cast(ir_node *block, ir_node * irn_op, ir_type* type);

/**
 * Construct a Cast node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_op    operand
 * @param type      target type of the case
*/
FIRM_API ir_node *new_d_Cast(dbg_info *dbgi, ir_node * irn_op, ir_type* type);

/**
 * Construct a Cast node.
 *
 * @param irn_op    operand
 * @param type      target type of the case
*/
FIRM_API ir_node *new_Cast(ir_node * irn_op, ir_type* type);
/**
 * Test if node is a Cast
 * @returns 1 if the node is a Cast node, 0 otherwise
 */
FIRM_API int is_Cast(const ir_node *node);

/** Returns op input of a Cast node. */
FIRM_API ir_node *get_Cast_op(const ir_node *node);
/** Sets op input of a Cast node. */
FIRM_API void set_Cast_op(ir_node *node, ir_node *op);
/** Returns type attribute of a Cast node. */
FIRM_API ir_type* get_Cast_type(const ir_node *node);
/** Sets type attribute of a Cast node. */
FIRM_API void set_Cast_type(ir_node *node, ir_type* type);
/** @} */

/**
 * @defgroup Cmp Cmp node
 *
 * Compares its two operands and checks whether a specified
relation (like less or equal) is fulfilled.
 * @{
 */

/**
 * Input numbers for Cmp node
 */
typedef enum {
	n_Cmp_left,
	n_Cmp_right,
	n_Cmp_max = n_Cmp_right
} n_Cmp;


/**
 * Construct a Cmp node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param relation  Comparison relation
*/
FIRM_API ir_node *new_rd_Cmp(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_relation relation);

/**
 * Construct a Cmp node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param relation  Comparison relation
*/
FIRM_API ir_node *new_r_Cmp(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_relation relation);

/**
 * Construct a Cmp node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param relation  Comparison relation
*/
FIRM_API ir_node *new_d_Cmp(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_relation relation);

/**
 * Construct a Cmp node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param relation  Comparison relation
*/
FIRM_API ir_node *new_Cmp(ir_node * irn_left, ir_node * irn_right, ir_relation relation);
/**
 * Test if node is a Cmp
 * @returns 1 if the node is a Cmp node, 0 otherwise
 */
FIRM_API int is_Cmp(const ir_node *node);

/** Returns left input of a Cmp node. */
FIRM_API ir_node *get_Cmp_left(const ir_node *node);
/** Sets left input of a Cmp node. */
FIRM_API void set_Cmp_left(ir_node *node, ir_node *left);
/** Returns right input of a Cmp node. */
FIRM_API ir_node *get_Cmp_right(const ir_node *node);
/** Sets right input of a Cmp node. */
FIRM_API void set_Cmp_right(ir_node *node, ir_node *right);
/** Returns relation attribute of a Cmp node. */
FIRM_API ir_relation get_Cmp_relation(const ir_node *node);
/** Sets relation attribute of a Cmp node. */
FIRM_API void set_Cmp_relation(ir_node *node, ir_relation relation);
/** @} */

/**
 * @defgroup Cond Cond node
 *
 * Conditionally change control flow.
 * @{
 */

/**
 * Input numbers for Cond node
 */
typedef enum {
	n_Cond_selector,
	n_Cond_max = n_Cond_selector
} n_Cond;


/**
 * Projection numbers for result of Cond node (use for Proj nodes)
 */
typedef enum {
	pn_Cond_false, /**< control flow if operand is "false" */
	pn_Cond_true, /**< control flow if operand is "true" */
	pn_Cond_max = pn_Cond_true
} pn_Cond;

/**
 * Construct a Cond node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_selector condition parameter
*/
FIRM_API ir_node *new_rd_Cond(dbg_info *dbgi, ir_node *block, ir_node * irn_selector);

/**
 * Construct a Cond node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_selector condition parameter
*/
FIRM_API ir_node *new_r_Cond(ir_node *block, ir_node * irn_selector);

/**
 * Construct a Cond node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_selector condition parameter
*/
FIRM_API ir_node *new_d_Cond(dbg_info *dbgi, ir_node * irn_selector);

/**
 * Construct a Cond node.
 *
 * @param irn_selector condition parameter
*/
FIRM_API ir_node *new_Cond(ir_node * irn_selector);
/**
 * Test if node is a Cond
 * @returns 1 if the node is a Cond node, 0 otherwise
 */
FIRM_API int is_Cond(const ir_node *node);

/** Returns selector input of a Cond node. */
FIRM_API ir_node *get_Cond_selector(const ir_node *node);
/** Sets selector input of a Cond node. */
FIRM_API void set_Cond_selector(ir_node *node, ir_node *selector);
/** Returns jmp_pred attribute of a Cond node. */
FIRM_API cond_jmp_predicate get_Cond_jmp_pred(const ir_node *node);
/** Sets jmp_pred attribute of a Cond node. */
FIRM_API void set_Cond_jmp_pred(ir_node *node, cond_jmp_predicate jmp_pred);
/** @} */

/**
 * @defgroup Confirm Confirm node
 *
 * Specifies constraints for a value. This allows explicit representation
of path-sensitive properties. (Example: This value is always >= 0 on 1
if-branch then all users within that branch are rerouted to a confirm-node
specifying this property).

A constraint is specified for the relation between value and bound.
value is always returned.
Note that this node does NOT check or assert the constraint, it merely
specifies it.
 * @{
 */

/**
 * Input numbers for Confirm node
 */
typedef enum {
	n_Confirm_value,
	n_Confirm_bound,
	n_Confirm_max = n_Confirm_bound
} n_Confirm;


/**
 * Construct a Confirm node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_value value to express a constraint for
 * @param irn_bound value to compare against
 * @param relation  relation of value to bound
*/
FIRM_API ir_node *new_rd_Confirm(dbg_info *dbgi, ir_node *block, ir_node * irn_value, ir_node * irn_bound, ir_relation relation);

/**
 * Construct a Confirm node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_value value to express a constraint for
 * @param irn_bound value to compare against
 * @param relation  relation of value to bound
*/
FIRM_API ir_node *new_r_Confirm(ir_node *block, ir_node * irn_value, ir_node * irn_bound, ir_relation relation);

/**
 * Construct a Confirm node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_value value to express a constraint for
 * @param irn_bound value to compare against
 * @param relation  relation of value to bound
*/
FIRM_API ir_node *new_d_Confirm(dbg_info *dbgi, ir_node * irn_value, ir_node * irn_bound, ir_relation relation);

/**
 * Construct a Confirm node.
 *
 * @param irn_value value to express a constraint for
 * @param irn_bound value to compare against
 * @param relation  relation of value to bound
*/
FIRM_API ir_node *new_Confirm(ir_node * irn_value, ir_node * irn_bound, ir_relation relation);
/**
 * Test if node is a Confirm
 * @returns 1 if the node is a Confirm node, 0 otherwise
 */
FIRM_API int is_Confirm(const ir_node *node);

/** Returns value input of a Confirm node. */
FIRM_API ir_node *get_Confirm_value(const ir_node *node);
/** Sets value input of a Confirm node. */
FIRM_API void set_Confirm_value(ir_node *node, ir_node *value);
/** Returns bound input of a Confirm node. */
FIRM_API ir_node *get_Confirm_bound(const ir_node *node);
/** Sets bound input of a Confirm node. */
FIRM_API void set_Confirm_bound(ir_node *node, ir_node *bound);
/** Returns relation attribute of a Confirm node. */
FIRM_API ir_relation get_Confirm_relation(const ir_node *node);
/** Sets relation attribute of a Confirm node. */
FIRM_API void set_Confirm_relation(ir_node *node, ir_relation relation);
/** @} */

/**
 * @defgroup Const Const node
 *
 * Returns a constant value.
 * @{
 */


/**
 * Construct a Const node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param tarval    constant value (a tarval object)
*/
FIRM_API ir_node *new_rd_Const(dbg_info *dbgi, ir_graph *irg, ir_tarval* tarval);

/**
 * Construct a Const node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param tarval    constant value (a tarval object)
*/
FIRM_API ir_node *new_r_Const(ir_graph *irg, ir_tarval* tarval);

/**
 * Construct a Const node.
 *
 * @param dbgi      A pointer to debug information.
 * @param tarval    constant value (a tarval object)
*/
FIRM_API ir_node *new_d_Const(dbg_info *dbgi, ir_tarval* tarval);

/**
 * Construct a Const node.
 *
 * @param tarval    constant value (a tarval object)
*/
FIRM_API ir_node *new_Const(ir_tarval* tarval);
/**
 * Test if node is a Const
 * @returns 1 if the node is a Const node, 0 otherwise
 */
FIRM_API int is_Const(const ir_node *node);

/** Returns tarval attribute of a Const node. */
FIRM_API ir_tarval* get_Const_tarval(const ir_node *node);
/** Sets tarval attribute of a Const node. */
FIRM_API void set_Const_tarval(ir_node *node, ir_tarval* tarval);
/** @} */

/**
 * @defgroup Conv Conv node
 *
 * Converts values between modes
 * @{
 */

/**
 * Input numbers for Conv node
 */
typedef enum {
	n_Conv_op,
	n_Conv_max = n_Conv_op
} n_Conv;


/**
 * Construct a Conv node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Conv(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Conv node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Conv(ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Conv node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Conv(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Conv node.
 *
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Conv(ir_node * irn_op, ir_mode * mode);
/**
 * Test if node is a Conv
 * @returns 1 if the node is a Conv node, 0 otherwise
 */
FIRM_API int is_Conv(const ir_node *node);

/** Returns op input of a Conv node. */
FIRM_API ir_node *get_Conv_op(const ir_node *node);
/** Sets op input of a Conv node. */
FIRM_API void set_Conv_op(ir_node *node, ir_node *op);
/** @} */

/**
 * @defgroup CopyB CopyB node
 *
 * Copies a block of memory with statically known size/type.
 * @{
 */

/**
 * Input numbers for CopyB node
 */
typedef enum {
	n_CopyB_mem,
	n_CopyB_dst,
	n_CopyB_src,
	n_CopyB_max = n_CopyB_src
} n_CopyB;


/**
 * Projection numbers for result of CopyB node (use for Proj nodes)
 */
typedef enum {
	pn_CopyB_M, /**< memory result */
	pn_CopyB_X_regular, /**< control flow when no exception occurs */
	pn_CopyB_X_except, /**< control flow when exception occured */
	pn_CopyB_max = pn_CopyB_X_except
} pn_CopyB;

/**
 * Construct a CopyB node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_dst   destination address
 * @param irn_src   source address
 * @param type      type of copied data
*/
FIRM_API ir_node *new_rd_CopyB(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type);

/**
 * Construct a CopyB node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_dst   destination address
 * @param irn_src   source address
 * @param type      type of copied data
*/
FIRM_API ir_node *new_r_CopyB(ir_node *block, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type);

/**
 * Construct a CopyB node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_dst   destination address
 * @param irn_src   source address
 * @param type      type of copied data
*/
FIRM_API ir_node *new_d_CopyB(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type);

/**
 * Construct a CopyB node.
 *
 * @param irn_mem   memory dependency
 * @param irn_dst   destination address
 * @param irn_src   source address
 * @param type      type of copied data
*/
FIRM_API ir_node *new_CopyB(ir_node * irn_mem, ir_node * irn_dst, ir_node * irn_src, ir_type* type);
/**
 * Test if node is a CopyB
 * @returns 1 if the node is a CopyB node, 0 otherwise
 */
FIRM_API int is_CopyB(const ir_node *node);

/** Returns mem input of a CopyB node. */
FIRM_API ir_node *get_CopyB_mem(const ir_node *node);
/** Sets mem input of a CopyB node. */
FIRM_API void set_CopyB_mem(ir_node *node, ir_node *mem);
/** Returns dst input of a CopyB node. */
FIRM_API ir_node *get_CopyB_dst(const ir_node *node);
/** Sets dst input of a CopyB node. */
FIRM_API void set_CopyB_dst(ir_node *node, ir_node *dst);
/** Returns src input of a CopyB node. */
FIRM_API ir_node *get_CopyB_src(const ir_node *node);
/** Sets src input of a CopyB node. */
FIRM_API void set_CopyB_src(ir_node *node, ir_node *src);
/** Returns type attribute of a CopyB node. */
FIRM_API ir_type* get_CopyB_type(const ir_node *node);
/** Sets type attribute of a CopyB node. */
FIRM_API void set_CopyB_type(ir_node *node, ir_type* type);
/** @} */

/**
 * @defgroup Deleted Deleted node
 *
 * Internal node which is temporary set to nodes which are already removed
from the graph.
 * @{
 */


/**
 * Test if node is a Deleted
 * @returns 1 if the node is a Deleted node, 0 otherwise
 */
FIRM_API int is_Deleted(const ir_node *node);

/** @} */

/**
 * @defgroup Div Div node
 *
 * returns the quotient of its 2 operands
 * @{
 */

/**
 * Input numbers for Div node
 */
typedef enum {
	n_Div_mem,
	n_Div_left,
	n_Div_right,
	n_Div_max = n_Div_right
} n_Div;


/**
 * Projection numbers for result of Div node (use for Proj nodes)
 */
typedef enum {
	pn_Div_M, /**< memory result */
	pn_Div_res, /**< result of computation */
	pn_Div_X_regular, /**< control flow when no exception occurs */
	pn_Div_X_except, /**< control flow when exception occured */
	pn_Div_max = pn_Div_X_except
} pn_Div;

/**
 * Construct a Div node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result value
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_rd_Div(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Div node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result value
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_r_Div(ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Div node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result value
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_d_Div(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Div node.
 *
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result value
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_Div(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);
/**
 * Test if node is a Div
 * @returns 1 if the node is a Div node, 0 otherwise
 */
FIRM_API int is_Div(const ir_node *node);

/** Returns mem input of a Div node. */
FIRM_API ir_node *get_Div_mem(const ir_node *node);
/** Sets mem input of a Div node. */
FIRM_API void set_Div_mem(ir_node *node, ir_node *mem);
/** Returns left input of a Div node. */
FIRM_API ir_node *get_Div_left(const ir_node *node);
/** Sets left input of a Div node. */
FIRM_API void set_Div_left(ir_node *node, ir_node *left);
/** Returns right input of a Div node. */
FIRM_API ir_node *get_Div_right(const ir_node *node);
/** Sets right input of a Div node. */
FIRM_API void set_Div_right(ir_node *node, ir_node *right);
/** Returns resmode attribute of a Div node. */
FIRM_API ir_mode* get_Div_resmode(const ir_node *node);
/** Sets resmode attribute of a Div node. */
FIRM_API void set_Div_resmode(ir_node *node, ir_mode* resmode);
/** Returns no_remainder attribute of a Div node. */
FIRM_API int get_Div_no_remainder(const ir_node *node);
/** Sets no_remainder attribute of a Div node. */
FIRM_API void set_Div_no_remainder(ir_node *node, int no_remainder);
/** @} */

/**
 * @defgroup Dummy Dummy node
 *
 * A placeholder value. This is used when constructing cyclic graphs where
you have cases where not all predecessors of a phi-node are known. Dummy
nodes are used for the unknown predecessors and replaced later.
 * @{
 */


/**
 * Construct a Dummy node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Dummy(dbg_info *dbgi, ir_graph *irg, ir_mode * mode);

/**
 * Construct a Dummy node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Dummy(ir_graph *irg, ir_mode * mode);

/**
 * Construct a Dummy node.
 *
 * @param dbgi      A pointer to debug information.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Dummy(dbg_info *dbgi, ir_mode * mode);

/**
 * Construct a Dummy node.
 *
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Dummy(ir_mode * mode);
/**
 * Test if node is a Dummy
 * @returns 1 if the node is a Dummy node, 0 otherwise
 */
FIRM_API int is_Dummy(const ir_node *node);

/** @} */

/**
 * @defgroup End End node
 *
 * Last node of a graph. It references nodes in endless loops (so called
keepalive edges)
 * @{
 */


/**
 * Construct an End node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_rd_End(dbg_info *dbgi, ir_graph *irg, int arity, ir_node *const * in);

/**
 * Construct an End node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_r_End(ir_graph *irg, int arity, ir_node *const * in);

/**
 * Construct an End node.
 *
 * @param dbgi      A pointer to debug information.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_d_End(dbg_info *dbgi, int arity, ir_node *const * in);

/**
 * Construct an End node.
 *
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_End(int arity, ir_node *const * in);
/**
 * Test if node is a End
 * @returns 1 if the node is a End node, 0 otherwise
 */
FIRM_API int is_End(const ir_node *node);

/** @} */

/**
 * @defgroup Eor Eor node
 *
 * returns the result of a bitwise exclusive or operation of its operands.

This is also known as the Xor operation.
 * @{
 */

/**
 * Input numbers for Eor node
 */
typedef enum {
	n_Eor_left,
	n_Eor_right,
	n_Eor_max = n_Eor_right
} n_Eor;


/**
 * Construct an Eor node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Eor(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Eor node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Eor(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Eor node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Eor(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Eor node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Eor(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Eor
 * @returns 1 if the node is a Eor node, 0 otherwise
 */
FIRM_API int is_Eor(const ir_node *node);

/** Returns left input of an Eor node. */
FIRM_API ir_node *get_Eor_left(const ir_node *node);
/** Sets left input of an Eor node. */
FIRM_API void set_Eor_left(ir_node *node, ir_node *left);
/** Returns right input of an Eor node. */
FIRM_API ir_node *get_Eor_right(const ir_node *node);
/** Sets right input of an Eor node. */
FIRM_API void set_Eor_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Free Free node
 *
 * Frees a block of memory previously allocated by an Alloc node
 * @{
 */

/**
 * Input numbers for Free node
 */
typedef enum {
	n_Free_mem,
	n_Free_ptr,
	n_Free_count,
	n_Free_max = n_Free_count
} n_Free;


/**
 * Construct a Free node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to the object to free
 * @param irn_count number of objects to allocate
 * @param type      type of the allocated variable
 * @param where     whether allocation was on the stack or heap
*/
FIRM_API ir_node *new_rd_Free(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct a Free node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to the object to free
 * @param irn_count number of objects to allocate
 * @param type      type of the allocated variable
 * @param where     whether allocation was on the stack or heap
*/
FIRM_API ir_node *new_r_Free(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct a Free node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to the object to free
 * @param irn_count number of objects to allocate
 * @param type      type of the allocated variable
 * @param where     whether allocation was on the stack or heap
*/
FIRM_API ir_node *new_d_Free(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where);

/**
 * Construct a Free node.
 *
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to the object to free
 * @param irn_count number of objects to allocate
 * @param type      type of the allocated variable
 * @param where     whether allocation was on the stack or heap
*/
FIRM_API ir_node *new_Free(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_count, ir_type* type, ir_where_alloc where);
/**
 * Test if node is a Free
 * @returns 1 if the node is a Free node, 0 otherwise
 */
FIRM_API int is_Free(const ir_node *node);

/** Returns mem input of a Free node. */
FIRM_API ir_node *get_Free_mem(const ir_node *node);
/** Sets mem input of a Free node. */
FIRM_API void set_Free_mem(ir_node *node, ir_node *mem);
/** Returns ptr input of a Free node. */
FIRM_API ir_node *get_Free_ptr(const ir_node *node);
/** Sets ptr input of a Free node. */
FIRM_API void set_Free_ptr(ir_node *node, ir_node *ptr);
/** Returns count input of a Free node. */
FIRM_API ir_node *get_Free_count(const ir_node *node);
/** Sets count input of a Free node. */
FIRM_API void set_Free_count(ir_node *node, ir_node *count);
/** Returns type attribute of a Free node. */
FIRM_API ir_type* get_Free_type(const ir_node *node);
/** Sets type attribute of a Free node. */
FIRM_API void set_Free_type(ir_node *node, ir_type* type);
/** Returns where attribute of a Free node. */
FIRM_API ir_where_alloc get_Free_where(const ir_node *node);
/** Sets where attribute of a Free node. */
FIRM_API void set_Free_where(ir_node *node, ir_where_alloc where);
/** @} */

/**
 * @defgroup IJmp IJmp node
 *
 * Jumps to the code in its argument. The code has to be in the same
function and the the destination must be one of the blocks reachable
by the tuple results
 * @{
 */

/**
 * Input numbers for IJmp node
 */
typedef enum {
	n_IJmp_target,
	n_IJmp_max = n_IJmp_target
} n_IJmp;


/**
 * Construct an IJmp node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_target target address of the jump
*/
FIRM_API ir_node *new_rd_IJmp(dbg_info *dbgi, ir_node *block, ir_node * irn_target);

/**
 * Construct an IJmp node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_target target address of the jump
*/
FIRM_API ir_node *new_r_IJmp(ir_node *block, ir_node * irn_target);

/**
 * Construct an IJmp node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_target target address of the jump
*/
FIRM_API ir_node *new_d_IJmp(dbg_info *dbgi, ir_node * irn_target);

/**
 * Construct an IJmp node.
 *
 * @param irn_target target address of the jump
*/
FIRM_API ir_node *new_IJmp(ir_node * irn_target);
/**
 * Test if node is a IJmp
 * @returns 1 if the node is a IJmp node, 0 otherwise
 */
FIRM_API int is_IJmp(const ir_node *node);

/** Returns target input of an IJmp node. */
FIRM_API ir_node *get_IJmp_target(const ir_node *node);
/** Sets target input of an IJmp node. */
FIRM_API void set_IJmp_target(ir_node *node, ir_node *target);
/** @} */

/**
 * @defgroup Id Id node
 *
 * Returns its operand unchanged.

This is mainly used when exchanging nodes. Usually you shouldn't see Id
nodes since the getters/setters for node inputs skip them automatically.
 * @{
 */

/**
 * Input numbers for Id node
 */
typedef enum {
	n_Id_pred,
	n_Id_max = n_Id_pred
} n_Id;


/**
 * Construct an Id node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_pred  the value which is returned unchanged
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Id(dbg_info *dbgi, ir_node *block, ir_node * irn_pred, ir_mode * mode);

/**
 * Construct an Id node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_pred  the value which is returned unchanged
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Id(ir_node *block, ir_node * irn_pred, ir_mode * mode);

/**
 * Construct an Id node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_pred  the value which is returned unchanged
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Id(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode);

/**
 * Construct an Id node.
 *
 * @param irn_pred  the value which is returned unchanged
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Id(ir_node * irn_pred, ir_mode * mode);
/**
 * Test if node is a Id
 * @returns 1 if the node is a Id node, 0 otherwise
 */
FIRM_API int is_Id(const ir_node *node);

/** Returns pred input of an Id node. */
FIRM_API ir_node *get_Id_pred(const ir_node *node);
/** Sets pred input of an Id node. */
FIRM_API void set_Id_pred(ir_node *node, ir_node *pred);
/** @} */

/**
 * @defgroup InstOf InstOf node
 *
 * Tests whether an object is an instance of a class-type
 * @{
 */

/**
 * Input numbers for InstOf node
 */
typedef enum {
	n_InstOf_store,
	n_InstOf_obj,
	n_InstOf_max = n_InstOf_obj
} n_InstOf;


/**
 * Projection numbers for result of InstOf node (use for Proj nodes)
 */
typedef enum {
	pn_InstOf_M, /**< memory result */
	pn_InstOf_res, /**< checked object pointer */
	pn_InstOf_X_regular, /**< control flow when no exception occurs */
	pn_InstOf_X_except, /**< control flow when exception occured */
	pn_InstOf_max = pn_InstOf_X_except
} pn_InstOf;

/**
 * Construct an InstOf node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_store memory dependency
 * @param irn_obj   pointer to object being queried
 * @param type      type to check ptr for
*/
FIRM_API ir_node *new_rd_InstOf(dbg_info *dbgi, ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type);

/**
 * Construct an InstOf node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_store memory dependency
 * @param irn_obj   pointer to object being queried
 * @param type      type to check ptr for
*/
FIRM_API ir_node *new_r_InstOf(ir_node *block, ir_node * irn_store, ir_node * irn_obj, ir_type* type);

/**
 * Construct an InstOf node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_store memory dependency
 * @param irn_obj   pointer to object being queried
 * @param type      type to check ptr for
*/
FIRM_API ir_node *new_d_InstOf(dbg_info *dbgi, ir_node * irn_store, ir_node * irn_obj, ir_type* type);

/**
 * Construct an InstOf node.
 *
 * @param irn_store memory dependency
 * @param irn_obj   pointer to object being queried
 * @param type      type to check ptr for
*/
FIRM_API ir_node *new_InstOf(ir_node * irn_store, ir_node * irn_obj, ir_type* type);
/**
 * Test if node is a InstOf
 * @returns 1 if the node is a InstOf node, 0 otherwise
 */
FIRM_API int is_InstOf(const ir_node *node);

/** Returns store input of an InstOf node. */
FIRM_API ir_node *get_InstOf_store(const ir_node *node);
/** Sets store input of an InstOf node. */
FIRM_API void set_InstOf_store(ir_node *node, ir_node *store);
/** Returns obj input of an InstOf node. */
FIRM_API ir_node *get_InstOf_obj(const ir_node *node);
/** Sets obj input of an InstOf node. */
FIRM_API void set_InstOf_obj(ir_node *node, ir_node *obj);
/** Returns type attribute of an InstOf node. */
FIRM_API ir_type* get_InstOf_type(const ir_node *node);
/** Sets type attribute of an InstOf node. */
FIRM_API void set_InstOf_type(ir_node *node, ir_type* type);
/** @} */

/**
 * @defgroup Jmp Jmp node
 *
 * Jumps to the block connected through the out-value
 * @{
 */


/**
 * Construct a Jmp node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
*/
FIRM_API ir_node *new_rd_Jmp(dbg_info *dbgi, ir_node *block);

/**
 * Construct a Jmp node.
 *
 * @param block     The IR block the node belongs to.
*/
FIRM_API ir_node *new_r_Jmp(ir_node *block);

/**
 * Construct a Jmp node.
 *
 * @param dbgi      A pointer to debug information.
*/
FIRM_API ir_node *new_d_Jmp(dbg_info *dbgi);

/**
 * Construct a Jmp node.
 *
*/
FIRM_API ir_node *new_Jmp(void);
/**
 * Test if node is a Jmp
 * @returns 1 if the node is a Jmp node, 0 otherwise
 */
FIRM_API int is_Jmp(const ir_node *node);

/** @} */

/**
 * @defgroup Load Load node
 *
 * Loads a value from memory (heap or stack).
 * @{
 */

/**
 * Input numbers for Load node
 */
typedef enum {
	n_Load_mem,
	n_Load_ptr,
	n_Load_max = n_Load_ptr
} n_Load;


/**
 * Projection numbers for result of Load node (use for Proj nodes)
 */
typedef enum {
	pn_Load_M, /**< memory result */
	pn_Load_res, /**< result of load operation */
	pn_Load_X_regular, /**< control flow when no exception occurs */
	pn_Load_X_except, /**< control flow when exception occured */
	pn_Load_max = pn_Load_X_except
} pn_Load;

/**
 * Construct a Load node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to load from
 * @param mode      mode of the value to be loaded
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_rd_Load(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags);

/**
 * Construct a Load node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to load from
 * @param mode      mode of the value to be loaded
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_r_Load(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags);

/**
 * Construct a Load node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to load from
 * @param mode      mode of the value to be loaded
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_d_Load(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags);

/**
 * Construct a Load node.
 *
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to load from
 * @param mode      mode of the value to be loaded
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_Load(ir_node * irn_mem, ir_node * irn_ptr, ir_mode* mode, ir_cons_flags flags);
/**
 * Test if node is a Load
 * @returns 1 if the node is a Load node, 0 otherwise
 */
FIRM_API int is_Load(const ir_node *node);

/** Returns mem input of a Load node. */
FIRM_API ir_node *get_Load_mem(const ir_node *node);
/** Sets mem input of a Load node. */
FIRM_API void set_Load_mem(ir_node *node, ir_node *mem);
/** Returns ptr input of a Load node. */
FIRM_API ir_node *get_Load_ptr(const ir_node *node);
/** Sets ptr input of a Load node. */
FIRM_API void set_Load_ptr(ir_node *node, ir_node *ptr);
/** Returns mode attribute of a Load node. */
FIRM_API ir_mode* get_Load_mode(const ir_node *node);
/** Sets mode attribute of a Load node. */
FIRM_API void set_Load_mode(ir_node *node, ir_mode* mode);
/** Returns volatility attribute of a Load node. */
FIRM_API ir_volatility get_Load_volatility(const ir_node *node);
/** Sets volatility attribute of a Load node. */
FIRM_API void set_Load_volatility(ir_node *node, ir_volatility volatility);
/** Returns unaligned attribute of a Load node. */
FIRM_API ir_align get_Load_unaligned(const ir_node *node);
/** Sets unaligned attribute of a Load node. */
FIRM_API void set_Load_unaligned(ir_node *node, ir_align unaligned);
/** @} */

/**
 * @defgroup Minus Minus node
 *
 * returns the additive inverse of its operand
 * @{
 */

/**
 * Input numbers for Minus node
 */
typedef enum {
	n_Minus_op,
	n_Minus_max = n_Minus_op
} n_Minus;


/**
 * Construct a Minus node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Minus(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Minus node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Minus(ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Minus node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Minus(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Minus node.
 *
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Minus(ir_node * irn_op, ir_mode * mode);
/**
 * Test if node is a Minus
 * @returns 1 if the node is a Minus node, 0 otherwise
 */
FIRM_API int is_Minus(const ir_node *node);

/** Returns op input of a Minus node. */
FIRM_API ir_node *get_Minus_op(const ir_node *node);
/** Sets op input of a Minus node. */
FIRM_API void set_Minus_op(ir_node *node, ir_node *op);
/** @} */

/**
 * @defgroup Mod Mod node
 *
 * returns the remainder of its operands from an implied division.

Examples:

* mod(5,3)   produces 2
* mod(5,-3)  produces 2
* mod(-5,3)  produces -2
* mod(-5,-3) produces -2
 * @{
 */

/**
 * Input numbers for Mod node
 */
typedef enum {
	n_Mod_mem,
	n_Mod_left,
	n_Mod_right,
	n_Mod_max = n_Mod_right
} n_Mod;


/**
 * Projection numbers for result of Mod node (use for Proj nodes)
 */
typedef enum {
	pn_Mod_M, /**< memory result */
	pn_Mod_res, /**< result of computation */
	pn_Mod_X_regular, /**< control flow when no exception occurs */
	pn_Mod_X_except, /**< control flow when exception occured */
	pn_Mod_max = pn_Mod_X_except
} pn_Mod;

/**
 * Construct a Mod node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_rd_Mod(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Mod node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_r_Mod(ir_node *block, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Mod node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_d_Mod(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);

/**
 * Construct a Mod node.
 *
 * @param irn_mem   memory dependency
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param resmode   mode of the result
 * @param pin_state pinned state
*/
FIRM_API ir_node *new_Mod(ir_node * irn_mem, ir_node * irn_left, ir_node * irn_right, ir_mode* resmode, op_pin_state pin_state);
/**
 * Test if node is a Mod
 * @returns 1 if the node is a Mod node, 0 otherwise
 */
FIRM_API int is_Mod(const ir_node *node);

/** Returns mem input of a Mod node. */
FIRM_API ir_node *get_Mod_mem(const ir_node *node);
/** Sets mem input of a Mod node. */
FIRM_API void set_Mod_mem(ir_node *node, ir_node *mem);
/** Returns left input of a Mod node. */
FIRM_API ir_node *get_Mod_left(const ir_node *node);
/** Sets left input of a Mod node. */
FIRM_API void set_Mod_left(ir_node *node, ir_node *left);
/** Returns right input of a Mod node. */
FIRM_API ir_node *get_Mod_right(const ir_node *node);
/** Sets right input of a Mod node. */
FIRM_API void set_Mod_right(ir_node *node, ir_node *right);
/** Returns resmode attribute of a Mod node. */
FIRM_API ir_mode* get_Mod_resmode(const ir_node *node);
/** Sets resmode attribute of a Mod node. */
FIRM_API void set_Mod_resmode(ir_node *node, ir_mode* resmode);
/** @} */

/**
 * @defgroup Mul Mul node
 *
 * returns the product of its operands
 * @{
 */

/**
 * Input numbers for Mul node
 */
typedef enum {
	n_Mul_left,
	n_Mul_right,
	n_Mul_max = n_Mul_right
} n_Mul;


/**
 * Construct a Mul node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Mul(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mul node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Mul(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mul node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Mul(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mul node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Mul(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Mul
 * @returns 1 if the node is a Mul node, 0 otherwise
 */
FIRM_API int is_Mul(const ir_node *node);

/** Returns left input of a Mul node. */
FIRM_API ir_node *get_Mul_left(const ir_node *node);
/** Sets left input of a Mul node. */
FIRM_API void set_Mul_left(ir_node *node, ir_node *left);
/** Returns right input of a Mul node. */
FIRM_API ir_node *get_Mul_right(const ir_node *node);
/** Sets right input of a Mul node. */
FIRM_API void set_Mul_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Mulh Mulh node
 *
 * returns the upper word of the product of its operands (the part which
would not fit into the result mode of a normal Mul anymore)
 * @{
 */

/**
 * Input numbers for Mulh node
 */
typedef enum {
	n_Mulh_left,
	n_Mulh_right,
	n_Mulh_max = n_Mulh_right
} n_Mulh;


/**
 * Construct a Mulh node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Mulh(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mulh node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Mulh(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mulh node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Mulh(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Mulh node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Mulh(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Mulh
 * @returns 1 if the node is a Mulh node, 0 otherwise
 */
FIRM_API int is_Mulh(const ir_node *node);

/** Returns left input of a Mulh node. */
FIRM_API ir_node *get_Mulh_left(const ir_node *node);
/** Sets left input of a Mulh node. */
FIRM_API void set_Mulh_left(ir_node *node, ir_node *left);
/** Returns right input of a Mulh node. */
FIRM_API ir_node *get_Mulh_right(const ir_node *node);
/** Sets right input of a Mulh node. */
FIRM_API void set_Mulh_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Mux Mux node
 *
 * returns the false or true operand depending on the value of the sel
operand
 * @{
 */

/**
 * Input numbers for Mux node
 */
typedef enum {
	n_Mux_sel,
	n_Mux_false,
	n_Mux_true,
	n_Mux_max = n_Mux_true
} n_Mux;


/**
 * Construct a Mux node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_sel   value making the output selection
 * @param irn_false selected if sel input is false
 * @param irn_true  selected if sel input is true
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Mux(dbg_info *dbgi, ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode);

/**
 * Construct a Mux node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_sel   value making the output selection
 * @param irn_false selected if sel input is false
 * @param irn_true  selected if sel input is true
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Mux(ir_node *block, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode);

/**
 * Construct a Mux node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_sel   value making the output selection
 * @param irn_false selected if sel input is false
 * @param irn_true  selected if sel input is true
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Mux(dbg_info *dbgi, ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode);

/**
 * Construct a Mux node.
 *
 * @param irn_sel   value making the output selection
 * @param irn_false selected if sel input is false
 * @param irn_true  selected if sel input is true
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Mux(ir_node * irn_sel, ir_node * irn_false, ir_node * irn_true, ir_mode * mode);
/**
 * Test if node is a Mux
 * @returns 1 if the node is a Mux node, 0 otherwise
 */
FIRM_API int is_Mux(const ir_node *node);

/** Returns sel input of a Mux node. */
FIRM_API ir_node *get_Mux_sel(const ir_node *node);
/** Sets sel input of a Mux node. */
FIRM_API void set_Mux_sel(ir_node *node, ir_node *sel);
/** Returns false input of a Mux node. */
FIRM_API ir_node *get_Mux_false(const ir_node *node);
/** Sets false input of a Mux node. */
FIRM_API void set_Mux_false(ir_node *node, ir_node *false_);
/** Returns true input of a Mux node. */
FIRM_API ir_node *get_Mux_true(const ir_node *node);
/** Sets true input of a Mux node. */
FIRM_API void set_Mux_true(ir_node *node, ir_node *true_);
/** @} */

/**
 * @defgroup NoMem NoMem node
 *
 * Placeholder node for cases where you don't need any memory input
 * @{
 */


/**
 * Construct a NoMem node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
*/
FIRM_API ir_node *new_rd_NoMem(dbg_info *dbgi, ir_graph *irg);

/**
 * Construct a NoMem node.
 *
 * @param irg       The IR graph the node belongs to.
*/
FIRM_API ir_node *new_r_NoMem(ir_graph *irg);

/**
 * Construct a NoMem node.
 *
 * @param dbgi      A pointer to debug information.
*/
FIRM_API ir_node *new_d_NoMem(dbg_info *dbgi);

/**
 * Construct a NoMem node.
 *
*/
FIRM_API ir_node *new_NoMem(void);
/**
 * Test if node is a NoMem
 * @returns 1 if the node is a NoMem node, 0 otherwise
 */
FIRM_API int is_NoMem(const ir_node *node);

/** @} */

/**
 * @defgroup Not Not node
 *
 * returns the bitwise complement of a value. Works for boolean values, too.
 * @{
 */

/**
 * Input numbers for Not node
 */
typedef enum {
	n_Not_op,
	n_Not_max = n_Not_op
} n_Not;


/**
 * Construct a Not node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Not(dbg_info *dbgi, ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Not node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Not(ir_node *block, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Not node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Not(dbg_info *dbgi, ir_node * irn_op, ir_mode * mode);

/**
 * Construct a Not node.
 *
 * @param irn_op    operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Not(ir_node * irn_op, ir_mode * mode);
/**
 * Test if node is a Not
 * @returns 1 if the node is a Not node, 0 otherwise
 */
FIRM_API int is_Not(const ir_node *node);

/** Returns op input of a Not node. */
FIRM_API ir_node *get_Not_op(const ir_node *node);
/** Sets op input of a Not node. */
FIRM_API void set_Not_op(ir_node *node, ir_node *op);
/** @} */

/**
 * @defgroup Or Or node
 *
 * returns the result of a bitwise or operation of its operands
 * @{
 */

/**
 * Input numbers for Or node
 */
typedef enum {
	n_Or_left,
	n_Or_right,
	n_Or_max = n_Or_right
} n_Or;


/**
 * Construct an Or node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Or(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Or node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Or(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Or node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Or(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct an Or node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Or(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Or
 * @returns 1 if the node is a Or node, 0 otherwise
 */
FIRM_API int is_Or(const ir_node *node);

/** Returns left input of an Or node. */
FIRM_API ir_node *get_Or_left(const ir_node *node);
/** Sets left input of an Or node. */
FIRM_API void set_Or_left(ir_node *node, ir_node *left);
/** Returns right input of an Or node. */
FIRM_API ir_node *get_Or_right(const ir_node *node);
/** Sets right input of an Or node. */
FIRM_API void set_Or_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Phi Phi node
 *
 * Choose a value based on control flow. A phi node has 1 input for each
predecessor of its block. If a block is entered from its nth predecessor
all phi nodes produce their nth input as result.
 * @{
 */


/**
 * Construct a Phi node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Phi(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in, ir_mode * mode);

/**
 * Construct a Phi node.
 *
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Phi(ir_node *block, int arity, ir_node *const * in, ir_mode * mode);

/**
 * Construct a Phi node.
 *
 * @param dbgi      A pointer to debug information.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Phi(dbg_info *dbgi, int arity, ir_node *const * in, ir_mode * mode);

/**
 * Construct a Phi node.
 *
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Phi(int arity, ir_node *const * in, ir_mode * mode);
/**
 * Test if node is a Phi
 * @returns 1 if the node is a Phi node, 0 otherwise
 */
FIRM_API int is_Phi(const ir_node *node);

/** @} */

/**
 * @defgroup Pin Pin node
 *
 * Pin the value of the node node in the current block. No users of the Pin
node can float above the Block of the Pin. The node cannot float behind
this block. Often used to Pin the NoMem node.
 * @{
 */

/**
 * Input numbers for Pin node
 */
typedef enum {
	n_Pin_op,
	n_Pin_max = n_Pin_op
} n_Pin;


/**
 * Construct a Pin node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_op    value which is pinned
*/
FIRM_API ir_node *new_rd_Pin(dbg_info *dbgi, ir_node *block, ir_node * irn_op);

/**
 * Construct a Pin node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_op    value which is pinned
*/
FIRM_API ir_node *new_r_Pin(ir_node *block, ir_node * irn_op);

/**
 * Construct a Pin node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_op    value which is pinned
*/
FIRM_API ir_node *new_d_Pin(dbg_info *dbgi, ir_node * irn_op);

/**
 * Construct a Pin node.
 *
 * @param irn_op    value which is pinned
*/
FIRM_API ir_node *new_Pin(ir_node * irn_op);
/**
 * Test if node is a Pin
 * @returns 1 if the node is a Pin node, 0 otherwise
 */
FIRM_API int is_Pin(const ir_node *node);

/** Returns op input of a Pin node. */
FIRM_API ir_node *get_Pin_op(const ir_node *node);
/** Sets op input of a Pin node. */
FIRM_API void set_Pin_op(ir_node *node, ir_node *op);
/** @} */

/**
 * @defgroup Proj Proj node
 *
 * returns an entry of a tuple value
 * @{
 */

/**
 * Input numbers for Proj node
 */
typedef enum {
	n_Proj_pred,
	n_Proj_max = n_Proj_pred
} n_Proj;


/**
 * Construct a Proj node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_pred  the tuple value from which a part is extracted
 * @param mode      mode of the operations result
 * @param proj      number of tuple component to be extracted
*/
FIRM_API ir_node *new_rd_Proj(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode, long proj);

/**
 * Construct a Proj node.
 *
 * @param irn_pred  the tuple value from which a part is extracted
 * @param mode      mode of the operations result
 * @param proj      number of tuple component to be extracted
*/
FIRM_API ir_node *new_r_Proj(ir_node * irn_pred, ir_mode * mode, long proj);

/**
 * Construct a Proj node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_pred  the tuple value from which a part is extracted
 * @param mode      mode of the operations result
 * @param proj      number of tuple component to be extracted
*/
FIRM_API ir_node *new_d_Proj(dbg_info *dbgi, ir_node * irn_pred, ir_mode * mode, long proj);

/**
 * Construct a Proj node.
 *
 * @param irn_pred  the tuple value from which a part is extracted
 * @param mode      mode of the operations result
 * @param proj      number of tuple component to be extracted
*/
FIRM_API ir_node *new_Proj(ir_node * irn_pred, ir_mode * mode, long proj);
/**
 * Test if node is a Proj
 * @returns 1 if the node is a Proj node, 0 otherwise
 */
FIRM_API int is_Proj(const ir_node *node);

/** Returns pred input of a Proj node. */
FIRM_API ir_node *get_Proj_pred(const ir_node *node);
/** Sets pred input of a Proj node. */
FIRM_API void set_Proj_pred(ir_node *node, ir_node *pred);
/** Returns proj attribute of a Proj node. */
FIRM_API long get_Proj_proj(const ir_node *node);
/** Sets proj attribute of a Proj node. */
FIRM_API void set_Proj_proj(ir_node *node, long proj);
/** @} */

/**
 * @defgroup Raise Raise node
 *
 * Raises an exception. Unconditional change of control flow. Writes an
explicit Except variable to memory to pass it to the exception handler.
Must be lowered to a Call to a runtime check function.
 * @{
 */

/**
 * Input numbers for Raise node
 */
typedef enum {
	n_Raise_mem,
	n_Raise_exo_ptr,
	n_Raise_max = n_Raise_exo_ptr
} n_Raise;


/**
 * Projection numbers for result of Raise node (use for Proj nodes)
 */
typedef enum {
	pn_Raise_M, /**< memory result */
	pn_Raise_X, /**< control flow to exception handler */
	pn_Raise_max = pn_Raise_X
} pn_Raise;

/**
 * Construct a Raise node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_exo_ptr pointer to exception object to be thrown
*/
FIRM_API ir_node *new_rd_Raise(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr);

/**
 * Construct a Raise node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_exo_ptr pointer to exception object to be thrown
*/
FIRM_API ir_node *new_r_Raise(ir_node *block, ir_node * irn_mem, ir_node * irn_exo_ptr);

/**
 * Construct a Raise node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_exo_ptr pointer to exception object to be thrown
*/
FIRM_API ir_node *new_d_Raise(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_exo_ptr);

/**
 * Construct a Raise node.
 *
 * @param irn_mem   memory dependency
 * @param irn_exo_ptr pointer to exception object to be thrown
*/
FIRM_API ir_node *new_Raise(ir_node * irn_mem, ir_node * irn_exo_ptr);
/**
 * Test if node is a Raise
 * @returns 1 if the node is a Raise node, 0 otherwise
 */
FIRM_API int is_Raise(const ir_node *node);

/** Returns mem input of a Raise node. */
FIRM_API ir_node *get_Raise_mem(const ir_node *node);
/** Sets mem input of a Raise node. */
FIRM_API void set_Raise_mem(ir_node *node, ir_node *mem);
/** Returns exo_ptr input of a Raise node. */
FIRM_API ir_node *get_Raise_exo_ptr(const ir_node *node);
/** Sets exo_ptr input of a Raise node. */
FIRM_API void set_Raise_exo_ptr(ir_node *node, ir_node *exo_ptr);
/** @} */

/**
 * @defgroup Return Return node
 *
 * Returns from the current function. Takes memory and return values as
operands.
 * @{
 */

/**
 * Input numbers for Return node
 */
typedef enum {
	n_Return_mem,
	n_Return_max = n_Return_mem
} n_Return;


/**
 * Construct a Return node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_rd_Return(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in);

/**
 * Construct a Return node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_r_Return(ir_node *block, ir_node * irn_mem, int arity, ir_node *const * in);

/**
 * Construct a Return node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_d_Return(dbg_info *dbgi, ir_node * irn_mem, int arity, ir_node *const * in);

/**
 * Construct a Return node.
 *
 * @param irn_mem   memory dependency
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_Return(ir_node * irn_mem, int arity, ir_node *const * in);
/**
 * Test if node is a Return
 * @returns 1 if the node is a Return node, 0 otherwise
 */
FIRM_API int is_Return(const ir_node *node);

/** Returns mem input of a Return node. */
FIRM_API ir_node *get_Return_mem(const ir_node *node);
/** Sets mem input of a Return node. */
FIRM_API void set_Return_mem(ir_node *node, ir_node *mem);
/** @} */

/**
 * @defgroup Rotl Rotl node
 *
 * Returns its first operand bits rotated left by the amount in the 2nd
operand
 * @{
 */

/**
 * Input numbers for Rotl node
 */
typedef enum {
	n_Rotl_left,
	n_Rotl_right,
	n_Rotl_max = n_Rotl_right
} n_Rotl;


/**
 * Construct a Rotl node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Rotl(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Rotl node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Rotl(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Rotl node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Rotl(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Rotl node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Rotl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Rotl
 * @returns 1 if the node is a Rotl node, 0 otherwise
 */
FIRM_API int is_Rotl(const ir_node *node);

/** Returns left input of a Rotl node. */
FIRM_API ir_node *get_Rotl_left(const ir_node *node);
/** Sets left input of a Rotl node. */
FIRM_API void set_Rotl_left(ir_node *node, ir_node *left);
/** Returns right input of a Rotl node. */
FIRM_API ir_node *get_Rotl_right(const ir_node *node);
/** Sets right input of a Rotl node. */
FIRM_API void set_Rotl_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Sel Sel node
 *
 * Computes the address of a entity of a compound type given the base
address of an instance of the compound type.

Optimisations assume that a Sel node can only produce a NULL pointer if the
ptr input was NULL.
 * @{
 */

/**
 * Input numbers for Sel node
 */
typedef enum {
	n_Sel_mem,
	n_Sel_ptr,
	n_Sel_max = n_Sel_ptr
} n_Sel;


/**
 * Construct a Sel node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to object to select from
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param entity    entity which is selected
*/
FIRM_API ir_node *new_rd_Sel(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity);

/**
 * Construct a Sel node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to object to select from
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param entity    entity which is selected
*/
FIRM_API ir_node *new_r_Sel(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity);

/**
 * Construct a Sel node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to object to select from
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param entity    entity which is selected
*/
FIRM_API ir_node *new_d_Sel(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity);

/**
 * Construct a Sel node.
 *
 * @param irn_mem   memory dependency
 * @param irn_ptr   pointer to object to select from
 * @param arity     size of additional inputs array
 * @param in        additional inputs
 * @param entity    entity which is selected
*/
FIRM_API ir_node *new_Sel(ir_node * irn_mem, ir_node * irn_ptr, int arity, ir_node *const * in, ir_entity* entity);
/**
 * Test if node is a Sel
 * @returns 1 if the node is a Sel node, 0 otherwise
 */
FIRM_API int is_Sel(const ir_node *node);

/** Returns mem input of a Sel node. */
FIRM_API ir_node *get_Sel_mem(const ir_node *node);
/** Sets mem input of a Sel node. */
FIRM_API void set_Sel_mem(ir_node *node, ir_node *mem);
/** Returns ptr input of a Sel node. */
FIRM_API ir_node *get_Sel_ptr(const ir_node *node);
/** Sets ptr input of a Sel node. */
FIRM_API void set_Sel_ptr(ir_node *node, ir_node *ptr);
/** Returns entity attribute of a Sel node. */
FIRM_API ir_entity* get_Sel_entity(const ir_node *node);
/** Sets entity attribute of a Sel node. */
FIRM_API void set_Sel_entity(ir_node *node, ir_entity* entity);
/** @} */

/**
 * @defgroup Shl Shl node
 *
 * Returns its first operands bits shifted left by the amount of the 2nd
operand.
The right input (shift amount) must be an unsigned integer value.
If the result mode has modulo_shift!=0, then the effective shift amount is
the right input modulo this modulo_shift amount.
 * @{
 */

/**
 * Input numbers for Shl node
 */
typedef enum {
	n_Shl_left,
	n_Shl_right,
	n_Shl_max = n_Shl_right
} n_Shl;


/**
 * Construct a Shl node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Shl(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shl node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Shl(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shl node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Shl(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shl node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Shl(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Shl
 * @returns 1 if the node is a Shl node, 0 otherwise
 */
FIRM_API int is_Shl(const ir_node *node);

/** Returns left input of a Shl node. */
FIRM_API ir_node *get_Shl_left(const ir_node *node);
/** Sets left input of a Shl node. */
FIRM_API void set_Shl_left(ir_node *node, ir_node *left);
/** Returns right input of a Shl node. */
FIRM_API ir_node *get_Shl_right(const ir_node *node);
/** Sets right input of a Shl node. */
FIRM_API void set_Shl_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Shr Shr node
 *
 * Returns its first operands bits shifted right by the amount of the 2nd
operand. No special handling for the sign bit is performed (zero extension).
The right input (shift amount) must be an unsigned integer value.
If the result mode has modulo_shift!=0, then the effective shift amount is
the right input modulo this modulo_shift amount.
 * @{
 */

/**
 * Input numbers for Shr node
 */
typedef enum {
	n_Shr_left,
	n_Shr_right,
	n_Shr_max = n_Shr_right
} n_Shr;


/**
 * Construct a Shr node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Shr(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shr node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Shr(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shr node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Shr(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shr node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Shr(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Shr
 * @returns 1 if the node is a Shr node, 0 otherwise
 */
FIRM_API int is_Shr(const ir_node *node);

/** Returns left input of a Shr node. */
FIRM_API ir_node *get_Shr_left(const ir_node *node);
/** Sets left input of a Shr node. */
FIRM_API void set_Shr_left(ir_node *node, ir_node *left);
/** Returns right input of a Shr node. */
FIRM_API ir_node *get_Shr_right(const ir_node *node);
/** Sets right input of a Shr node. */
FIRM_API void set_Shr_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Shrs Shrs node
 *
 * Returns its first operands bits shifted right by the amount of the 2nd
operand. The leftmost bit (usually the sign bit) stays the same
(sign extension).
The right input (shift amount) must be an unsigned integer value.
If the result mode has modulo_shift!=0, then the effective shift amount is
the right input modulo this modulo_shift amount.
 * @{
 */

/**
 * Input numbers for Shrs node
 */
typedef enum {
	n_Shrs_left,
	n_Shrs_right,
	n_Shrs_max = n_Shrs_right
} n_Shrs;


/**
 * Construct a Shrs node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Shrs(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shrs node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Shrs(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shrs node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Shrs(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Shrs node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Shrs(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Shrs
 * @returns 1 if the node is a Shrs node, 0 otherwise
 */
FIRM_API int is_Shrs(const ir_node *node);

/** Returns left input of a Shrs node. */
FIRM_API ir_node *get_Shrs_left(const ir_node *node);
/** Sets left input of a Shrs node. */
FIRM_API void set_Shrs_left(ir_node *node, ir_node *left);
/** Returns right input of a Shrs node. */
FIRM_API ir_node *get_Shrs_right(const ir_node *node);
/** Sets right input of a Shrs node. */
FIRM_API void set_Shrs_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Start Start node
 *
 * The first node of a graph. Execution starts with this node.
 * @{
 */


/**
 * Projection numbers for result of Start node (use for Proj nodes)
 */
typedef enum {
	pn_Start_X_initial_exec, /**< control flow */
	pn_Start_M, /**< initial memory */
	pn_Start_P_frame_base, /**< frame base pointer */
	pn_Start_T_args, /**< function arguments */
	pn_Start_max = pn_Start_T_args
} pn_Start;

/**
 * Construct a Start node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
*/
FIRM_API ir_node *new_rd_Start(dbg_info *dbgi, ir_graph *irg);

/**
 * Construct a Start node.
 *
 * @param irg       The IR graph the node belongs to.
*/
FIRM_API ir_node *new_r_Start(ir_graph *irg);

/**
 * Construct a Start node.
 *
 * @param dbgi      A pointer to debug information.
*/
FIRM_API ir_node *new_d_Start(dbg_info *dbgi);

/**
 * Construct a Start node.
 *
*/
FIRM_API ir_node *new_Start(void);
/**
 * Test if node is a Start
 * @returns 1 if the node is a Start node, 0 otherwise
 */
FIRM_API int is_Start(const ir_node *node);

/** @} */

/**
 * @defgroup Store Store node
 *
 * Stores a value into memory (heap or stack).
 * @{
 */

/**
 * Input numbers for Store node
 */
typedef enum {
	n_Store_mem,
	n_Store_ptr,
	n_Store_value,
	n_Store_max = n_Store_value
} n_Store;


/**
 * Projection numbers for result of Store node (use for Proj nodes)
 */
typedef enum {
	pn_Store_M, /**< memory result */
	pn_Store_X_regular, /**< control flow when no exception occurs */
	pn_Store_X_except, /**< control flow when exception occured */
	pn_Store_max = pn_Store_X_except
} pn_Store;

/**
 * Construct a Store node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to store to
 * @param irn_value value to store
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_rd_Store(dbg_info *dbgi, ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags);

/**
 * Construct a Store node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to store to
 * @param irn_value value to store
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_r_Store(ir_node *block, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags);

/**
 * Construct a Store node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to store to
 * @param irn_value value to store
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_d_Store(dbg_info *dbgi, ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags);

/**
 * Construct a Store node.
 *
 * @param irn_mem   memory dependency
 * @param irn_ptr   address to store to
 * @param irn_value value to store
 * @param flags     specifies alignment, volatility and pin state
*/
FIRM_API ir_node *new_Store(ir_node * irn_mem, ir_node * irn_ptr, ir_node * irn_value, ir_cons_flags flags);
/**
 * Test if node is a Store
 * @returns 1 if the node is a Store node, 0 otherwise
 */
FIRM_API int is_Store(const ir_node *node);

/** Returns mem input of a Store node. */
FIRM_API ir_node *get_Store_mem(const ir_node *node);
/** Sets mem input of a Store node. */
FIRM_API void set_Store_mem(ir_node *node, ir_node *mem);
/** Returns ptr input of a Store node. */
FIRM_API ir_node *get_Store_ptr(const ir_node *node);
/** Sets ptr input of a Store node. */
FIRM_API void set_Store_ptr(ir_node *node, ir_node *ptr);
/** Returns value input of a Store node. */
FIRM_API ir_node *get_Store_value(const ir_node *node);
/** Sets value input of a Store node. */
FIRM_API void set_Store_value(ir_node *node, ir_node *value);
/** Returns volatility attribute of a Store node. */
FIRM_API ir_volatility get_Store_volatility(const ir_node *node);
/** Sets volatility attribute of a Store node. */
FIRM_API void set_Store_volatility(ir_node *node, ir_volatility volatility);
/** Returns unaligned attribute of a Store node. */
FIRM_API ir_align get_Store_unaligned(const ir_node *node);
/** Sets unaligned attribute of a Store node. */
FIRM_API void set_Store_unaligned(ir_node *node, ir_align unaligned);
/** @} */

/**
 * @defgroup Sub Sub node
 *
 * returns the difference of its operands
 * @{
 */

/**
 * Input numbers for Sub node
 */
typedef enum {
	n_Sub_left,
	n_Sub_right,
	n_Sub_max = n_Sub_right
} n_Sub;


/**
 * Construct a Sub node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Sub(dbg_info *dbgi, ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Sub node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Sub(ir_node *block, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Sub node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Sub(dbg_info *dbgi, ir_node * irn_left, ir_node * irn_right, ir_mode * mode);

/**
 * Construct a Sub node.
 *
 * @param irn_left  first operand
 * @param irn_right second operand
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Sub(ir_node * irn_left, ir_node * irn_right, ir_mode * mode);
/**
 * Test if node is a Sub
 * @returns 1 if the node is a Sub node, 0 otherwise
 */
FIRM_API int is_Sub(const ir_node *node);

/** Returns left input of a Sub node. */
FIRM_API ir_node *get_Sub_left(const ir_node *node);
/** Sets left input of a Sub node. */
FIRM_API void set_Sub_left(ir_node *node, ir_node *left);
/** Returns right input of a Sub node. */
FIRM_API ir_node *get_Sub_right(const ir_node *node);
/** Sets right input of a Sub node. */
FIRM_API void set_Sub_right(ir_node *node, ir_node *right);
/** @} */

/**
 * @defgroup Switch Switch node
 *
 * Change control flow. The destination is choosen based on an integer input value which is looked up in a table.

Backends can implement this efficiently using a jump table.
 * @{
 */

/**
 * Input numbers for Switch node
 */
typedef enum {
	n_Switch_selector,
	n_Switch_max = n_Switch_selector
} n_Switch;


/**
 * Projection numbers for result of Switch node (use for Proj nodes)
 */
typedef enum {
	pn_Switch_default, /**< control flow if no other case matches */
	pn_Switch_max = pn_Switch_default
} pn_Switch;

/**
 * Construct a Switch node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param irn_selector input selector
 * @param n_outs    number of outputs (including pn_Switch_default)
 * @param table     table describing mapping from input values to Proj numbers
*/
FIRM_API ir_node *new_rd_Switch(dbg_info *dbgi, ir_node *block, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table);

/**
 * Construct a Switch node.
 *
 * @param block     The IR block the node belongs to.
 * @param irn_selector input selector
 * @param n_outs    number of outputs (including pn_Switch_default)
 * @param table     table describing mapping from input values to Proj numbers
*/
FIRM_API ir_node *new_r_Switch(ir_node *block, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table);

/**
 * Construct a Switch node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irn_selector input selector
 * @param n_outs    number of outputs (including pn_Switch_default)
 * @param table     table describing mapping from input values to Proj numbers
*/
FIRM_API ir_node *new_d_Switch(dbg_info *dbgi, ir_node * irn_selector, unsigned n_outs, ir_switch_table* table);

/**
 * Construct a Switch node.
 *
 * @param irn_selector input selector
 * @param n_outs    number of outputs (including pn_Switch_default)
 * @param table     table describing mapping from input values to Proj numbers
*/
FIRM_API ir_node *new_Switch(ir_node * irn_selector, unsigned n_outs, ir_switch_table* table);
/**
 * Test if node is a Switch
 * @returns 1 if the node is a Switch node, 0 otherwise
 */
FIRM_API int is_Switch(const ir_node *node);

/** Returns selector input of a Switch node. */
FIRM_API ir_node *get_Switch_selector(const ir_node *node);
/** Sets selector input of a Switch node. */
FIRM_API void set_Switch_selector(ir_node *node, ir_node *selector);
/** Returns n_outs attribute of a Switch node. */
FIRM_API unsigned get_Switch_n_outs(const ir_node *node);
/** Sets n_outs attribute of a Switch node. */
FIRM_API void set_Switch_n_outs(ir_node *node, unsigned n_outs);
/** Returns table attribute of a Switch node. */
FIRM_API ir_switch_table* get_Switch_table(const ir_node *node);
/** Sets table attribute of a Switch node. */
FIRM_API void set_Switch_table(ir_node *node, ir_switch_table* table);
/** @} */

/**
 * @defgroup SymConst SymConst node
 *
 * A symbolic constant.

- *symconst_type_size* The symbolic constant represents the size of a type.
                       The type of which the constant represents the size
                       is given explicitly.
- *symconst_type_align* The symbolic constant represents the alignment of a
                       type.  The type of which the constant represents the
                       size is given explicitly.
- *symconst_addr_ent*  The symbolic constant represents the address of an
                       entity (variable or method).  The variable is given
                       explicitly by a firm entity.
- *symconst_ofs_ent*   The symbolic constant represents the offset of an
                       entity in its owner type.
- *symconst_enum_const* The symbolic constant is a enumeration constant of
                       an enumeration type.
 * @{
 */


/**
 * Test if node is a SymConst
 * @returns 1 if the node is a SymConst node, 0 otherwise
 */
FIRM_API int is_SymConst(const ir_node *node);

/** @} */

/**
 * @defgroup Sync Sync node
 *
 * The Sync operation unifies several partial memory blocks. These blocks
have to be pairwise disjunct or the values in common locations have to
be identical.  This operation allows to specify all operations that
eventually need several partial memory blocks as input with a single
entrance by unifying the memories with a preceding Sync operation.
 * @{
 */


/**
 * Construct a Sync node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_rd_Sync(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in);

/**
 * Construct a Sync node.
 *
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_r_Sync(ir_node *block, int arity, ir_node *const * in);

/**
 * Construct a Sync node.
 *
 * @param dbgi      A pointer to debug information.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_d_Sync(dbg_info *dbgi, int arity, ir_node *const * in);

/**
 * Construct a Sync node.
 *
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_Sync(int arity, ir_node *const * in);
/**
 * Test if node is a Sync
 * @returns 1 if the node is a Sync node, 0 otherwise
 */
FIRM_API int is_Sync(const ir_node *node);

/** @} */

/**
 * @defgroup Tuple Tuple node
 *
 * Builds a Tuple from single values.

This is needed to implement optimizations that remove a node that produced
a tuple.  The node can be replaced by the Tuple operation so that the
following Proj nodes have not to be changed. (They are hard to find due to
the implementation with pointers in only one direction.) The Tuple node is
smaller than any other node, so that a node can be changed into a Tuple by
just changing its opcode and giving it a new in array.
 * @{
 */


/**
 * Construct a Tuple node.
 *
 * @param dbgi      A pointer to debug information.
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_rd_Tuple(dbg_info *dbgi, ir_node *block, int arity, ir_node *const * in);

/**
 * Construct a Tuple node.
 *
 * @param block     The IR block the node belongs to.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_r_Tuple(ir_node *block, int arity, ir_node *const * in);

/**
 * Construct a Tuple node.
 *
 * @param dbgi      A pointer to debug information.
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_d_Tuple(dbg_info *dbgi, int arity, ir_node *const * in);

/**
 * Construct a Tuple node.
 *
 * @param arity     size of additional inputs array
 * @param in        additional inputs
*/
FIRM_API ir_node *new_Tuple(int arity, ir_node *const * in);
/**
 * Test if node is a Tuple
 * @returns 1 if the node is a Tuple node, 0 otherwise
 */
FIRM_API int is_Tuple(const ir_node *node);

/** @} */

/**
 * @defgroup Unknown Unknown node
 *
 * Returns an unknown (at compile- and runtime) value. It is a valid
optimisation to replace an Unknown by any other constant value.
 * @{
 */


/**
 * Construct an Unknown node.
 *
 * @param dbgi      A pointer to debug information.
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_rd_Unknown(dbg_info *dbgi, ir_graph *irg, ir_mode * mode);

/**
 * Construct an Unknown node.
 *
 * @param irg       The IR graph the node belongs to.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_r_Unknown(ir_graph *irg, ir_mode * mode);

/**
 * Construct an Unknown node.
 *
 * @param dbgi      A pointer to debug information.
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_d_Unknown(dbg_info *dbgi, ir_mode * mode);

/**
 * Construct an Unknown node.
 *
 * @param mode      mode of the operations result
*/
FIRM_API ir_node *new_Unknown(ir_mode * mode);
/**
 * Test if node is a Unknown
 * @returns 1 if the node is a Unknown node, 0 otherwise
 */
FIRM_API int is_Unknown(const ir_node *node);

/** @} */

/** @} */

#include "end.h"

#endif
