/*
 * This file is subject to the terms and conditions defined in
 * file 'LICENSE.txt', which is part of this source code package.
 */

"use strict";(self.webpackChunk=self.webpackChunk||[]).push([["69"],{8660:function(e){e.exports="---\ntitle: MongoDB\nredirect_from:\n  - /docs/latest/administration-guide/databases/mongodb\n---\n\n# MongoDB\n\nTo add a database connection, click on the **gear** icon in the top right, and navigate to **Admin settings** > **Databases** > **Add a database**.\n\n## Supported versions\n\nMetabase supports the oldest supported version of MongoDB through the latest stable version. See [MongoDB Software Lifecycle Schedules](https://www.mongodb.com/legal/support-policy/lifecycles).\n\n## Connecting to MongoDB\n\nThere are two ways to connect to MongoDB:\n\n1. Using the [Metabase fields to input your connection details](#using-metabase-fields).\n2. Pasting your [connection string](#using-a-connection-string).\n\n### Using Metabase fields\n\nThe default way to connect to MongoDB is to fill out your connection details in the fields Metabase provides:\n\n- Host\n- Database name\n- Port\n- Username\n- Password\n- Authentication Database (optional)\n- Additional connection string options (optional)\n\nYou'll also have the option to **Use a secure connection (SSL)**. Enable SSL and paste the contents of the server's SSL certificate chain in the input text box. This option is available for this method of connection only (i.e. you cannot include a certificate when connecting with a connection string).\n\n### Advanced settings for direct connection\n\n- **Use DNS SRV when connecting** Using this option requires that provided host is a FQDN. If connecting to an Atlas cluster, you might need to enable this option. If you don't know what this means, leave this disabled.\n\n### Using a connection string\n\nIf you'd prefer to connect to MongoDB using a [connection string](https://docs.mongodb.com/manual/reference/connection-string/), click on **Paste a connection string**. The Metabase user interface will update with a field to paste your connection string.\n\nMetabase currently does NOT support the following connection string parameters:\n\n- `tlsCertificateKeyFile`\n- `tlsCertificateKeyFilePassword`\n- `tlsCAFile`\n\nIf you need to use a certificate, connect via the [default method](#using-metabase-fields) and enable **Use a secure connection(SSL)**.\n\n### Settings common to both connection options\n\n- **Use an SSH tunnel**: Some database installations can only be accessed by connecting through an SSH bastion host. This option also provides an extra layer of security when a VPN is not available. Enabling this is usually slower than a direct connection.\n- **Rerun queries for simple exploration**: When this is on, Metabase will automatically run queries when users do simple explorations with the Summarize and Filter buttons when viewing a table or chart. You can turn this off if querying this database is slow. This setting doesn't affect drill-throughs or SQL queries.\n- **Choose when syncs and scans happen**: See [syncs and scans](../sync-scan.md#choose-when-syncs-and-scans-happen).\n- **Periodically refingerprint tables**: This setting — disabled by default — enables Metabase to scan for additional field values during syncs allowing smarter behavior, like improved auto-binning on your bar charts.\n\n## Connecting to a MongoDB Atlas cluster\n\n### Whitelist IP addresses\n\nIf you are using Metabase Cloud, you'll need to whitelist [Metabase Cloud IP addresses](../../cloud/ip-addresses-to-whitelist.md) in your Atlas cluster. If you are using self-hosted Metabase, you'll need to whitelist the IP of your Metabase instance.\n\n1. Log into your [Atlas cluster](https://cloud.mongodb.com)\n2. Go to **Network Access**\n3. Add the IP addresses that your Metabase uses to connect.\n\n### Connect Metabase to your Atlas cluster\n\n> The connection string provided in Atlas \"Connect\" interface does not include the database. Metabase requires you to provide a database name when connecting, so you'll need to edit the connection string to add the database name.\n\n1. Log into your [Atlas account](https://cloud.mongodb.com)\n\n2. Select the cluster you want to connect to, and click **Connect**.\n\n   ![Your cluster screengrab](../images/atlas-connect.png)\n\n3. Select **Drivers**.\n\n4. Copy the connection string from **Add your connection string into your application code** section.\n\n   ![Connect screengrab](../images/connection-string.png)\n\n5. In Metabase, go to Admin -> Databases, and click the **Add database** button.\n6. Select MongoDB from the dropdown, and enter a **Display name** for this database.\n7. Click on **\"Paste the connection string\"** and paste your connection string.\n8. Edit the connection string to include the name of the database after `/`:\n\n   ```\n   mongodb+srv://metabot:metapass@my-test-cluster.a5ej7.mongodb.net/DATABASE_NAME?retryWrites=true&w=majority&appName=my-test-cluster\n   ```\n\nIf you're using Metabase fields to input connection information for your Atlas cluster instead of using the connection string, you might need to turn on **Use DNS SRV when connecting**.\n\nSee more information about [Advanced options](#settings-common-to-both-connection-options).\n\n## Configuring SSL via the command line\n\nYou can enter a self-signed certificate via the Metabase UI (though not when using a connection string), or you can use the command line to add a self-signed certificate.\n\n```\ncp /usr/lib/jvm/default-jvm/jre/lib/security/cacerts ./cacerts.jks\nkeytool -import -alias cacert -storepass changeit -keystore cacerts.jks -file my-cert.pem\n```\n\nThen, start Metabase using the store:\n\n```\njava -Djavax.net.ssl.trustStore=cacerts.jks -Djavax.net.ssl.trustStorePassword=changeit -jar metabase.jar\n```\n\nLearn more about [configuring SSL with MongoDB](https://mongodb.github.io/mongo-java-driver/3.0/driver/reference/connecting/ssl/).\n\n## How Metabase syncs data in MongoDB\n\nBecause MongoDB contains unstructured data, Metabase takes a different approach to syncing your database's metadata. To get a sense of the schema, Metabase will query the first and last 500 documents (most of the calculation is done in MongoDB). This sampling helps Metabase do things like differentiate datetime fields from string fields, and provide people with pre-populated filters. Metabase also syncs 1,000 leaf fields (fields at the deepest nesting level) per MongoDB collection. The reason Metabase only scans a sample of the documents is because scanning every document in every collection on every sync would put too much strain on your database. And while the sampling does a pretty good job keeping Metabase up to date, it can also mean that new fields can sometimes fall through the cracks, leading to visualization issues, or even fields failing to appear in your results. For more info, check out our [troubleshooting guide](../../troubleshooting-guide/db-connection.md).\n\n## General connectivity concerns\n\n- **Connect using `DNS SRV`**, which is the recommended method for newer Atlas clusters.\n- **Have you checked your cluster host whitelist?** When testing a connection but seeing failure, have you tried setting the IP whitelist to `0.0.0.0/0`? Whitelisting this address allows connections from any IP addresses. If you know the IP address(es) or CIDR block of clients, use that instead.\n- **Connect to the secondary server**. When connecting to a cluster, always use the `?readPreference=secondary` argument in the connection string, which allows Metabase to read from a secondary server instead of consuming resources from the primary server.\n\n## I added fields to my database but don't see them in Metabase\n\nMetabase may not sync all of your fields. Since any document in a MongoDB collection can contain any number of fields, the only way to get 100% coverage of all fields would be to scan every single document in every single collection. The reason Metabase doesn't do a full scan is because it would put too much strain on your database.\n\nInstead, Metabase gets a sample of the fields in a collection by scanning a sample of 1000 documents in each collection (the first 500 documents and the last 500 documents in each collection).\n\nIf you're not seeing all of the fields show up for a collection in Metabase, one workaround is to include all possible keys in the first document of the collection, and give those keys null values. That way, Metabase will be able to recognize the correct schema for the entire collection.\n\n## Database routing\n\nWith database routing, an admin can build a question once using one database, and the question will run its query against a different database with the same schema depending on who is viewing the question.\n\nSee [Database routing](../../permissions/database-routing.md).\n\n## Danger zone\n\nSee [Danger zone](../danger-zone.md).\n\n## Further reading\n\nSee our troubleshooting guide for [troubleshooting your connection](../../troubleshooting-guide/db-connection.md).\n"}}]);