/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::acc::AttachOp,
::mlir::acc::CopyinOp,
::mlir::acc::CopyoutOp,
::mlir::acc::CreateOp,
::mlir::acc::DataBoundsOp,
::mlir::acc::DataOp,
::mlir::acc::DeclareDeviceResidentOp,
::mlir::acc::DeclareEnterOp,
::mlir::acc::DeclareExitOp,
::mlir::acc::DeclareLinkOp,
::mlir::acc::DeleteOp,
::mlir::acc::DetachOp,
::mlir::acc::DevicePtrOp,
::mlir::acc::EnterDataOp,
::mlir::acc::ExitDataOp,
::mlir::acc::FirstprivateOp,
::mlir::acc::FirstprivateRecipeOp,
::mlir::acc::GetDevicePtrOp,
::mlir::acc::GlobalConstructorOp,
::mlir::acc::GlobalDestructorOp,
::mlir::acc::HostDataOp,
::mlir::acc::InitOp,
::mlir::acc::KernelsOp,
::mlir::acc::LoopOp,
::mlir::acc::NoCreateOp,
::mlir::acc::ParallelOp,
::mlir::acc::PresentOp,
::mlir::acc::PrivateOp,
::mlir::acc::PrivateRecipeOp,
::mlir::acc::ReductionOp,
::mlir::acc::ReductionRecipeOp,
::mlir::acc::SerialOp,
::mlir::acc::ShutdownOp,
::mlir::acc::TerminatorOp,
::mlir::acc::UpdateDeviceOp,
::mlir::acc::UpdateHostOp,
::mlir::acc::UpdateOp,
::mlir::acc::UseDeviceOp,
::mlir::acc::WaitOp,
::mlir::acc::YieldOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace acc {

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps0(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::acc::PointerLikeType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be PointerLikeType instance, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::acc::DataBoundsType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be Type for representing acc data clause bounds information, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::llvm::isa<::mlir::IntegerType>(type))) || ((::llvm::isa<::mlir::IndexType>(type))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be integer or index, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((type.isSignlessInteger(1)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 1-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::IntegerType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be integer, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_type_constraint_OpenACCOps5(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((true))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be any type, but got " << type;
  }
  return ::mlir::success();
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps0(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::acc::DataClauseAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: data clauses supported by OpenACC";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps0(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps0(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::BoolAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: bool attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::StringAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: string attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps4(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::acc::ClauseDefaultValueAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: DefaultValue Clause";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps4(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps4(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps5(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !(((::llvm::isa<::mlir::TypeAttr>(attr))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(attr).getValue()))) && ((true))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: any type attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps5(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps5(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps6(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(64)))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: 64-bit signless integer attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps6(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps6(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps7(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !(((::llvm::isa<::mlir::ArrayAttr>(attr))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(attr), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: symbol ref array attribute";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps7(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps7(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps8(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
  if (attr && !((::llvm::isa<::mlir::acc::ReductionOperatorAttr>(attr))))
    return getDiag() << "attribute '" << attrName
        << "' failed to satisfy constraint: built-in reduction operations supported by OpenACC";
  return ::mlir::success();
}
static ::mlir::LogicalResult __mlir_ods_local_attr_constraint_OpenACCOps8(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_OpenACCOps8(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::mlir::LogicalResult __mlir_ods_local_region_constraint_OpenACCOps0(
    ::mlir::Operation *op, ::mlir::Region &region, ::llvm::StringRef regionName,
    unsigned regionIndex) {
  if (!((true))) {
    return op->emitOpError("region #") << regionIndex
        << (regionName.empty() ? " " : " ('" + regionName + "') ")
        << "failed to verify constraint: any region";
  }
  return ::mlir::success();
}
} // namespace acc
} // namespace mlir
namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::AttachOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
AttachOpGenericAdaptorBase::AttachOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.attach", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> AttachOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr AttachOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr AttachOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause AttachOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr AttachOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool AttachOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr AttachOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool AttachOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr AttachOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > AttachOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
AttachOpAdaptor::AttachOpAdaptor(AttachOp op) : AttachOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult AttachOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.attach' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.attach' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.attach' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.attach' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> AttachOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range AttachOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> AttachOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> AttachOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range AttachOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange AttachOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AttachOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange AttachOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> AttachOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range AttachOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> AttachOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult AttachOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute AttachOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code AttachOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> AttachOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void AttachOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void AttachOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult AttachOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult AttachOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void AttachOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr AttachOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause AttachOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr AttachOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool AttachOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr AttachOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool AttachOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr AttachOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > AttachOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void AttachOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void AttachOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void AttachOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void AttachOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void AttachOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void AttachOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void AttachOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void AttachOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute AttachOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void AttachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void AttachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AttachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void AttachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void AttachOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void AttachOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_attach);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult AttachOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult AttachOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult AttachOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<AttachOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void AttachOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_attach)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::AttachOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CopyinOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CopyinOpGenericAdaptorBase::CopyinOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.copyin", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> CopyinOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr CopyinOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr CopyinOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause CopyinOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyinOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool CopyinOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyinOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool CopyinOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CopyinOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > CopyinOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
CopyinOpAdaptor::CopyinOpAdaptor(CopyinOp op) : CopyinOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult CopyinOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.copyin' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.copyin' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.copyin' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.copyin' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CopyinOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range CopyinOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CopyinOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CopyinOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range CopyinOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange CopyinOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CopyinOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CopyinOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> CopyinOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CopyinOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CopyinOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult CopyinOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute CopyinOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CopyinOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> CopyinOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void CopyinOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void CopyinOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult CopyinOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CopyinOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void CopyinOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr CopyinOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause CopyinOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyinOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool CopyinOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyinOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool CopyinOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CopyinOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > CopyinOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void CopyinOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void CopyinOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void CopyinOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void CopyinOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CopyinOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void CopyinOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CopyinOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void CopyinOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute CopyinOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void CopyinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void CopyinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopyinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void CopyinOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopyinOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CopyinOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_copyin);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult CopyinOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CopyinOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CopyinOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<CopyinOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CopyinOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_copyin)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::CopyinOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CopyoutOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CopyoutOpGenericAdaptorBase::CopyoutOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.copyout", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> CopyoutOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr CopyoutOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr CopyoutOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause CopyoutOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyoutOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool CopyoutOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyoutOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool CopyoutOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CopyoutOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > CopyoutOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
CopyoutOpAdaptor::CopyoutOpAdaptor(CopyoutOp op) : CopyoutOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult CopyoutOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.copyout' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.copyout' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.copyout' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.copyout' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CopyoutOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range CopyoutOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CopyoutOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CopyoutOp::getVarPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range CopyoutOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange CopyoutOp::getAccPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CopyoutOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CopyoutOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> CopyoutOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CopyoutOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult CopyoutOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute CopyoutOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CopyoutOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> CopyoutOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void CopyoutOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void CopyoutOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult CopyoutOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CopyoutOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void CopyoutOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr CopyoutOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause CopyoutOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyoutOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool CopyoutOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CopyoutOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool CopyoutOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CopyoutOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > CopyoutOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void CopyoutOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void CopyoutOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void CopyoutOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void CopyoutOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CopyoutOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void CopyoutOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CopyoutOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void CopyoutOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute CopyoutOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void CopyoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void CopyoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopyoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void CopyoutOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CopyoutOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CopyoutOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_copyout);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult CopyoutOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CopyoutOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CopyoutOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand accPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> accPtrOperands(accPtrRawOperands);  ::llvm::SMLoc accPtrOperandsLoc;
  (void)accPtrOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrOperands;
  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrTypes;
  if (parser.parseKeyword("accPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  accPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(accPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool boundsClause = false;
  bool toClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("to"))) {

  if (toClause) {
    return parser.emitError(parser.getNameLoc())
          << "`to` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  toClause = true;
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<CopyoutOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  if (parser.resolveOperands(accPtrOperands, accPtrTypes, accPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CopyoutOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "accPtr";
  _odsPrinter << "(";
  _odsPrinter << getAccPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  if (false || getVarPtr()) {
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_copyout)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::CopyoutOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::CreateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CreateOpGenericAdaptorBase::CreateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.create", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> CreateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr CreateOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr CreateOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause CreateOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CreateOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool CreateOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CreateOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool CreateOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CreateOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > CreateOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
CreateOpAdaptor::CreateOpAdaptor(CreateOp op) : CreateOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult CreateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.create' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.create' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.create' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.create' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> CreateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range CreateOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CreateOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CreateOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range CreateOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange CreateOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CreateOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange CreateOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> CreateOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range CreateOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> CreateOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult CreateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute CreateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CreateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> CreateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void CreateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void CreateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult CreateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult CreateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void CreateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr CreateOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause CreateOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr CreateOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool CreateOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr CreateOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool CreateOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr CreateOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > CreateOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void CreateOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void CreateOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void CreateOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void CreateOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CreateOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void CreateOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void CreateOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void CreateOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute CreateOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void CreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void CreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void CreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void CreateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void CreateOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_create);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult CreateOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult CreateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CreateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<CreateOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CreateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_create)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::CreateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DataBoundsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DataBoundsOpGenericAdaptorBase::DataBoundsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.bounds", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DataBoundsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DataBoundsOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::BoolAttr DataBoundsOpGenericAdaptorBase::getStrideInBytesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().strideInBytes);
  return attr;
}

bool DataBoundsOpGenericAdaptorBase::getStrideInBytes() {
  auto attr = getStrideInBytesAttr();
  return attr.getValue();
}

} // namespace detail
DataBoundsOpAdaptor::DataBoundsOpAdaptor(DataBoundsOp op) : DataBoundsOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DataBoundsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_strideInBytes = getProperties().strideInBytes; (void)tblgen_strideInBytes;

  if (tblgen_strideInBytes && !((::llvm::isa<::mlir::BoolAttr>(tblgen_strideInBytes))))
    return emitError(loc, "'acc.bounds' op ""attribute 'strideInBytes' failed to satisfy constraint: bool attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DataBoundsOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DataBoundsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value DataBoundsOp::getLowerbound() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value DataBoundsOp::getUpperbound() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value DataBoundsOp::getExtent() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value DataBoundsOp::getStride() {
  auto operands = getODSOperands(3);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value DataBoundsOp::getStartIdx() {
  auto operands = getODSOperands(4);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::MutableOperandRange DataBoundsOp::getLowerboundMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataBoundsOp::getUpperboundMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataBoundsOp::getExtentMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataBoundsOp::getStrideMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataBoundsOp::getStartIdxMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DataBoundsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DataBoundsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::DataBoundsType> DataBoundsOp::getResult() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::DataBoundsType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult DataBoundsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.strideInBytes;
       auto attr = dict.get("strideInBytes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for strideInBytes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `strideInBytes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DataBoundsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.strideInBytes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("strideInBytes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DataBoundsOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.strideInBytes.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DataBoundsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "strideInBytes")
      return prop.strideInBytes;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DataBoundsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "strideInBytes") {
       prop.strideInBytes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.strideInBytes)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DataBoundsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.strideInBytes) attrs.append("strideInBytes", prop.strideInBytes);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DataBoundsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getStrideInBytesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "strideInBytes", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DataBoundsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.strideInBytes)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DataBoundsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.strideInBytes);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::BoolAttr DataBoundsOp::getStrideInBytesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().strideInBytes);
}

bool DataBoundsOp::getStrideInBytes() {
  auto attr = getStrideInBytesAttr();
  return attr.getValue();
}

void DataBoundsOp::setStrideInBytesAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStrideInBytesAttrName(), attr);
}

void DataBoundsOp::setStrideInBytes(bool attrValue) {
  (*this)->setAttr(getStrideInBytesAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DataBoundsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx) {
  if (lowerbound)
    odsState.addOperands(lowerbound);
  if (upperbound)
    odsState.addOperands(upperbound);
  if (extent)
    odsState.addOperands(extent);
  if (stride)
    odsState.addOperands(stride);
  if (startIdx)
    odsState.addOperands(startIdx);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(lowerbound ? 1 : 0), (upperbound ? 1 : 0), (extent ? 1 : 0), (stride ? 1 : 0), (startIdx ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (strideInBytes) {
    odsState.getOrAddProperties<Properties>().strideInBytes = strideInBytes;
  }
  odsState.addTypes(result);
}

void DataBoundsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, ::mlir::BoolAttr strideInBytes, /*optional*/::mlir::Value startIdx) {
  if (lowerbound)
    odsState.addOperands(lowerbound);
  if (upperbound)
    odsState.addOperands(upperbound);
  if (extent)
    odsState.addOperands(extent);
  if (stride)
    odsState.addOperands(stride);
  if (startIdx)
    odsState.addOperands(startIdx);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(lowerbound ? 1 : 0), (upperbound ? 1 : 0), (extent ? 1 : 0), (stride ? 1 : 0), (startIdx ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (strideInBytes) {
    odsState.getOrAddProperties<Properties>().strideInBytes = strideInBytes;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DataBoundsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx) {
  if (lowerbound)
    odsState.addOperands(lowerbound);
  if (upperbound)
    odsState.addOperands(upperbound);
  if (extent)
    odsState.addOperands(extent);
  if (stride)
    odsState.addOperands(stride);
  if (startIdx)
    odsState.addOperands(startIdx);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(lowerbound ? 1 : 0), (upperbound ? 1 : 0), (extent ? 1 : 0), (stride ? 1 : 0), (startIdx ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().strideInBytes = odsBuilder.getBoolAttr(strideInBytes);
  odsState.addTypes(result);
}

void DataBoundsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value lowerbound, /*optional*/::mlir::Value upperbound, /*optional*/::mlir::Value extent, /*optional*/::mlir::Value stride, bool strideInBytes, /*optional*/::mlir::Value startIdx) {
  if (lowerbound)
    odsState.addOperands(lowerbound);
  if (upperbound)
    odsState.addOperands(upperbound);
  if (extent)
    odsState.addOperands(extent);
  if (stride)
    odsState.addOperands(stride);
  if (startIdx)
    odsState.addOperands(startIdx);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(lowerbound ? 1 : 0), (upperbound ? 1 : 0), (extent ? 1 : 0), (stride ? 1 : 0), (startIdx ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().strideInBytes = odsBuilder.getBoolAttr(strideInBytes);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DataBoundsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DataBoundsOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.strideInBytes)
    properties.strideInBytes = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DataBoundsOp::verifyInvariantsImpl() {
  auto tblgen_strideInBytes = getProperties().strideInBytes; (void)tblgen_strideInBytes;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_strideInBytes, "strideInBytes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DataBoundsOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DataBoundsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> lowerboundOperands;
  ::llvm::SMLoc lowerboundOperandsLoc;
  (void)lowerboundOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> lowerboundTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> upperboundOperands;
  ::llvm::SMLoc upperboundOperandsLoc;
  (void)upperboundOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> upperboundTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> extentOperands;
  ::llvm::SMLoc extentOperandsLoc;
  (void)extentOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> extentTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> strideOperands;
  ::llvm::SMLoc strideOperandsLoc;
  (void)strideOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> strideTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> startIdxOperands;
  ::llvm::SMLoc startIdxOperandsLoc;
  (void)startIdxOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> startIdxTypes;
  bool lowerboundClause = false;
  bool upperboundClause = false;
  bool extentClause = false;
  bool strideClause = false;
  bool startIdxClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("lowerbound"))) {

  if (lowerboundClause) {
    return parser.emitError(parser.getNameLoc())
          << "`lowerbound` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  lowerboundClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    lowerboundOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      lowerboundOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      lowerboundTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("upperbound"))) {

  if (upperboundClause) {
    return parser.emitError(parser.getNameLoc())
          << "`upperbound` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  upperboundClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    upperboundOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      upperboundOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      upperboundTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("extent"))) {

  if (extentClause) {
    return parser.emitError(parser.getNameLoc())
          << "`extent` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  extentClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    extentOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      extentOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      extentTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("stride"))) {

  if (strideClause) {
    return parser.emitError(parser.getNameLoc())
          << "`stride` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  strideClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    strideOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      strideOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      strideTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("startIdx"))) {

  if (startIdxClause) {
    return parser.emitError(parser.getNameLoc())
          << "`startIdx` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  startIdxClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    startIdxOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      startIdxOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      startIdxTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(lowerboundOperands.size()), static_cast<int32_t>(upperboundOperands.size()), static_cast<int32_t>(extentOperands.size()), static_cast<int32_t>(strideOperands.size()), static_cast<int32_t>(startIdxOperands.size())}), result.getOrAddProperties<DataBoundsOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(odsBuildableType0);
  if (parser.resolveOperands(lowerboundOperands, lowerboundTypes, lowerboundOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(upperboundOperands, upperboundTypes, upperboundOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(extentOperands, extentTypes, extentOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(strideOperands, strideTypes, strideOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(startIdxOperands, startIdxTypes, startIdxOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DataBoundsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getLowerbound()) {
  _odsPrinter << ' ' << "lowerbound";
  _odsPrinter << "(";
  if (::mlir::Value value = getLowerbound())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getLowerbound() ? ::llvm::ArrayRef<::mlir::Type>(getLowerbound().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getUpperbound()) {
  _odsPrinter << ' ' << "upperbound";
  _odsPrinter << "(";
  if (::mlir::Value value = getUpperbound())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getUpperbound() ? ::llvm::ArrayRef<::mlir::Type>(getUpperbound().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getExtent()) {
  _odsPrinter << ' ' << "extent";
  _odsPrinter << "(";
  if (::mlir::Value value = getExtent())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getExtent() ? ::llvm::ArrayRef<::mlir::Type>(getExtent().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getStride()) {
  _odsPrinter << ' ' << "stride";
  _odsPrinter << "(";
  if (::mlir::Value value = getStride())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getStride() ? ::llvm::ArrayRef<::mlir::Type>(getStride().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getStartIdx()) {
  _odsPrinter << ' ' << "startIdx";
  _odsPrinter << "(";
  if (::mlir::Value value = getStartIdx())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getStartIdx() ? ::llvm::ArrayRef<::mlir::Type>(getStartIdx().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStrideInBytesAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("strideInBytes");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

void DataBoundsOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DataBoundsOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DataOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DataOpGenericAdaptorBase::DataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.data", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DataOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DataOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr DataOpGenericAdaptorBase::getAsyncAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool DataOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr DataOpGenericAdaptorBase::getWaitAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool DataOpGenericAdaptorBase::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::acc::ClauseDefaultValueAttr DataOpGenericAdaptorBase::getDefaultAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  return attr;
}

::std::optional<::mlir::acc::ClauseDefaultValue> DataOpGenericAdaptorBase::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

::mlir::Region &DataOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange DataOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
DataOpAdaptor::DataOpAdaptor(DataOp op) : DataOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DataOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (tblgen_asyncAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_asyncAttr))))
    return emitError(loc, "'acc.data' op ""attribute 'asyncAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_waitAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_waitAttr))))
    return emitError(loc, "'acc.data' op ""attribute 'waitAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_defaultAttr && !((::llvm::isa<::mlir::acc::ClauseDefaultValueAttr>(tblgen_defaultAttr))))
    return emitError(loc, "'acc.data' op ""attribute 'defaultAttr' failed to satisfy constraint: DefaultValue Clause");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DataOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DataOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> DataOp::getIfCond() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Value DataOp::getAsync() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value DataOp::getWaitDevnum() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range DataOp::getWaitOperands() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range DataOp::getDataClauseOperands() {
  return getODSOperands(4);
}

::mlir::MutableOperandRange DataOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataOp::getAsyncMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataOp::getWaitDevnumMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DataOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DataOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DataOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &DataOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult DataOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.asyncAttr;
       auto attr = dict.get("asyncAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for asyncAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `asyncAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.defaultAttr;
       auto attr = dict.get("defaultAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for defaultAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `defaultAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.waitAttr;
       auto attr = dict.get("waitAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for waitAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `waitAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DataOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.asyncAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("asyncAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.defaultAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("defaultAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.waitAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("waitAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DataOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.asyncAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.defaultAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.waitAttr.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DataOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "asyncAttr")
      return prop.asyncAttr;

    if (name == "defaultAttr")
      return prop.defaultAttr;

    if (name == "waitAttr")
      return prop.waitAttr;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DataOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "asyncAttr") {
       prop.asyncAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.asyncAttr)>>(value);
       return;
    }

    if (name == "defaultAttr") {
       prop.defaultAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.defaultAttr)>>(value);
       return;
    }

    if (name == "waitAttr") {
       prop.waitAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.waitAttr)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DataOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.asyncAttr) attrs.append("asyncAttr", prop.asyncAttr);

    if (prop.defaultAttr) attrs.append("defaultAttr", prop.defaultAttr);

    if (prop.waitAttr) attrs.append("waitAttr", prop.waitAttr);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DataOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "asyncAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getDefaultAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(attr, "defaultAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "waitAttr", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DataOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.asyncAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.defaultAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.waitAttr)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DataOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.asyncAttr);

  writer.writeOptionalAttribute(prop.defaultAttr);

  writer.writeOptionalAttribute(prop.waitAttr);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr DataOp::getAsyncAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
}

bool DataOp::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr DataOp::getWaitAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
}

bool DataOp::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::acc::ClauseDefaultValueAttr DataOp::getDefaultAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
}

::std::optional<::mlir::acc::ClauseDefaultValue> DataOp::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

void DataOp::setAsyncAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrAttrName(), attr);
}

void DataOp::setAsyncAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrAttrName());
}

void DataOp::setWaitAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrAttrName(), attr);
}

void DataOp::setWaitAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrAttrName());
}

void DataOp::setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
  (*this)->setAttr(getDefaultAttrAttrName(), attr);
}

void DataOp::setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getDefaultAttrAttrName(), ::mlir::acc::ClauseDefaultValueAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue));
    (*this)->removeAttr(getDefaultAttrAttrName());
}

::mlir::Attribute DataOp::removeAsyncAttrAttr() {
    auto &attr = getProperties().asyncAttr;
    attr = {};
    return attr;
}

::mlir::Attribute DataOp::removeWaitAttrAttr() {
    auto &attr = getProperties().waitAttr;
    attr = {};
    return attr;
}

::mlir::Attribute DataOp::removeDefaultAttrAttr() {
    auto &attr = getProperties().defaultAttr;
    attr = {};
    return attr;
}

void DataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (async)
    odsState.addOperands(async);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (async ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void DataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (async)
    odsState.addOperands(async);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (async ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (async)
    odsState.addOperands(async);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (async ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void DataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (async)
    odsState.addOperands(async);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (async ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DataOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DataOp::verifyInvariantsImpl() {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_asyncAttr, "asyncAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_waitAttr, "waitAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(*this, tblgen_defaultAttr, "defaultAttr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult DataOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DataOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> asyncOperands;
  ::llvm::SMLoc asyncOperandsLoc;
  (void)asyncOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> asyncTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitDevnumOperands;
  ::llvm::SMLoc waitDevnumOperandsLoc;
  (void)waitDevnumOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitDevnumTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitOperandsOperands;
  ::llvm::SMLoc waitOperandsOperandsLoc;
  (void)waitOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitOperandsTypes;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  bool ifClause = false;
  bool asyncClause = false;
  bool dataOperandsClause = false;
  bool wait_devnumClause = false;
  bool waitClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("async"))) {

  if (asyncClause) {
    return parser.emitError(parser.getNameLoc())
          << "`async` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  asyncClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    asyncOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait_devnum"))) {

  if (wait_devnumClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait_devnum` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  wait_devnumClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    waitDevnumOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait"))) {

  if (waitClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  waitClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  waitOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(waitOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(waitOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(asyncOperands.size()), static_cast<int32_t>(waitDevnumOperands.size()), static_cast<int32_t>(waitOperandsOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<DataOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(asyncOperands, asyncTypes, asyncOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitDevnumOperands, waitDevnumTypes, waitDevnumOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitOperandsOperands, waitOperandsTypes, waitOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DataOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getAsync()) {
  _odsPrinter << ' ' << "async";
  _odsPrinter << "(";
  if (::mlir::Value value = getAsync())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getAsync() ? ::llvm::ArrayRef<::mlir::Type>(getAsync().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getWaitDevnum()) {
  _odsPrinter << ' ' << "wait_devnum";
  _odsPrinter << "(";
  if (::mlir::Value value = getWaitDevnum())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getWaitDevnum() ? ::llvm::ArrayRef<::mlir::Type>(getWaitDevnum().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitOperands().size()) {
  _odsPrinter << ' ' << "wait";
  _odsPrinter << "(";
  _odsPrinter << getWaitOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getWaitOperands().getTypes();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAsyncAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("asyncAttr");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getWaitAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("waitAttr");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareDeviceResidentOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeclareDeviceResidentOpGenericAdaptorBase::DeclareDeviceResidentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.declare_device_resident", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DeclareDeviceResidentOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DeclareDeviceResidentOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr DeclareDeviceResidentOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause DeclareDeviceResidentOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareDeviceResidentOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool DeclareDeviceResidentOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareDeviceResidentOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool DeclareDeviceResidentOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeclareDeviceResidentOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > DeclareDeviceResidentOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
DeclareDeviceResidentOpAdaptor::DeclareDeviceResidentOpAdaptor(DeclareDeviceResidentOp op) : DeclareDeviceResidentOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DeclareDeviceResidentOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.declare_device_resident' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.declare_device_resident' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.declare_device_resident' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.declare_device_resident' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeclareDeviceResidentOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DeclareDeviceResidentOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareDeviceResidentOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareDeviceResidentOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range DeclareDeviceResidentOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange DeclareDeviceResidentOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeclareDeviceResidentOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeclareDeviceResidentOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DeclareDeviceResidentOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DeclareDeviceResidentOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareDeviceResidentOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult DeclareDeviceResidentOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DeclareDeviceResidentOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DeclareDeviceResidentOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DeclareDeviceResidentOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DeclareDeviceResidentOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DeclareDeviceResidentOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DeclareDeviceResidentOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DeclareDeviceResidentOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DeclareDeviceResidentOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr DeclareDeviceResidentOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause DeclareDeviceResidentOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareDeviceResidentOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool DeclareDeviceResidentOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareDeviceResidentOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool DeclareDeviceResidentOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeclareDeviceResidentOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > DeclareDeviceResidentOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void DeclareDeviceResidentOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void DeclareDeviceResidentOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void DeclareDeviceResidentOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void DeclareDeviceResidentOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeclareDeviceResidentOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void DeclareDeviceResidentOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeclareDeviceResidentOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void DeclareDeviceResidentOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute DeclareDeviceResidentOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void DeclareDeviceResidentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DeclareDeviceResidentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeclareDeviceResidentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DeclareDeviceResidentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeclareDeviceResidentOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DeclareDeviceResidentOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_declare_device_resident);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DeclareDeviceResidentOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DeclareDeviceResidentOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeclareDeviceResidentOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<DeclareDeviceResidentOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeclareDeviceResidentOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_declare_device_resident)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareDeviceResidentOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareEnterOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeclareEnterOpGenericAdaptorBase::DeclareEnterOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.declare_enter", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DeclareEnterOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr DeclareEnterOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
DeclareEnterOpAdaptor::DeclareEnterOpAdaptor(DeclareEnterOp op) : DeclareEnterOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DeclareEnterOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeclareEnterOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range DeclareEnterOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range DeclareEnterOp::getDataClauseOperands() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange DeclareEnterOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> DeclareEnterOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DeclareEnterOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void DeclareEnterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange dataClauseOperands) {
  odsState.addOperands(dataClauseOperands);
}

void DeclareEnterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DeclareEnterOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DeclareEnterOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeclareEnterOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  bool dataOperandsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeclareEnterOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareEnterOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareExitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeclareExitOpGenericAdaptorBase::DeclareExitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const ::mlir::EmptyProperties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.declare_exit", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DeclareExitOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (odsOperandsSize - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::DictionaryAttr DeclareExitOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
DeclareExitOpAdaptor::DeclareExitOpAdaptor(DeclareExitOp op) : DeclareExitOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DeclareExitOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeclareExitOp::getODSOperandIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumOperands() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::operand_range DeclareExitOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range DeclareExitOp::getDataClauseOperands() {
  return getODSOperands(0);
}

::mlir::MutableOperandRange DeclareExitOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second);
  return mutableRange;
}

std::pair<unsigned, unsigned> DeclareExitOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DeclareExitOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

void DeclareExitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange dataClauseOperands) {
  odsState.addOperands(dataClauseOperands);
}

void DeclareExitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult DeclareExitOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DeclareExitOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeclareExitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  bool dataOperandsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
  }
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeclareExitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareExitOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeclareLinkOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeclareLinkOpGenericAdaptorBase::DeclareLinkOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.declare_link", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DeclareLinkOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DeclareLinkOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr DeclareLinkOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause DeclareLinkOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareLinkOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool DeclareLinkOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareLinkOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool DeclareLinkOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeclareLinkOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > DeclareLinkOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
DeclareLinkOpAdaptor::DeclareLinkOpAdaptor(DeclareLinkOp op) : DeclareLinkOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DeclareLinkOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.declare_link' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.declare_link' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.declare_link' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.declare_link' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeclareLinkOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DeclareLinkOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareLinkOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareLinkOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range DeclareLinkOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange DeclareLinkOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeclareLinkOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeclareLinkOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DeclareLinkOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DeclareLinkOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeclareLinkOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult DeclareLinkOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DeclareLinkOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DeclareLinkOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DeclareLinkOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DeclareLinkOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DeclareLinkOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DeclareLinkOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DeclareLinkOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DeclareLinkOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr DeclareLinkOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause DeclareLinkOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareLinkOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool DeclareLinkOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeclareLinkOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool DeclareLinkOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeclareLinkOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > DeclareLinkOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void DeclareLinkOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void DeclareLinkOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void DeclareLinkOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void DeclareLinkOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeclareLinkOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void DeclareLinkOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeclareLinkOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void DeclareLinkOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute DeclareLinkOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void DeclareLinkOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DeclareLinkOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeclareLinkOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DeclareLinkOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeclareLinkOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DeclareLinkOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_declare_link);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DeclareLinkOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DeclareLinkOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeclareLinkOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<DeclareLinkOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeclareLinkOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_declare_link)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DeclareLinkOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DeleteOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DeleteOpGenericAdaptorBase::DeleteOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.delete", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DeleteOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DeleteOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr DeleteOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause DeleteOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeleteOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool DeleteOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeleteOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool DeleteOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeleteOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > DeleteOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
DeleteOpAdaptor::DeleteOpAdaptor(DeleteOp op) : DeleteOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DeleteOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.delete' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.delete' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.delete' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.delete' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DeleteOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DeleteOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeleteOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DeleteOp::getVarPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range DeleteOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange DeleteOp::getAccPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeleteOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DeleteOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DeleteOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DeleteOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult DeleteOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DeleteOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DeleteOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DeleteOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DeleteOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DeleteOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DeleteOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DeleteOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DeleteOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr DeleteOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause DeleteOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeleteOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool DeleteOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DeleteOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool DeleteOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DeleteOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > DeleteOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void DeleteOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void DeleteOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void DeleteOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void DeleteOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeleteOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void DeleteOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DeleteOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void DeleteOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute DeleteOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void DeleteOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void DeleteOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeleteOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void DeleteOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DeleteOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DeleteOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_delete);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DeleteOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DeleteOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DeleteOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand accPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> accPtrOperands(accPtrRawOperands);  ::llvm::SMLoc accPtrOperandsLoc;
  (void)accPtrOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrOperands;
  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrTypes;
  if (parser.parseKeyword("accPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  accPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(accPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool boundsClause = false;
  bool toClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("to"))) {

  if (toClause) {
    return parser.emitError(parser.getNameLoc())
          << "`to` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  toClause = true;
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<DeleteOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  if (parser.resolveOperands(accPtrOperands, accPtrTypes, accPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DeleteOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "accPtr";
  _odsPrinter << "(";
  _odsPrinter << getAccPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  if (false || getVarPtr()) {
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_delete)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DeleteOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DetachOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DetachOpGenericAdaptorBase::DetachOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.detach", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DetachOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DetachOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr DetachOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause DetachOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DetachOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool DetachOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DetachOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool DetachOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DetachOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > DetachOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
DetachOpAdaptor::DetachOpAdaptor(DetachOp op) : DetachOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DetachOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.detach' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.detach' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.detach' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.detach' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DetachOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DetachOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DetachOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DetachOp::getVarPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range DetachOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange DetachOp::getAccPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DetachOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DetachOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DetachOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DetachOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult DetachOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DetachOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DetachOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DetachOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DetachOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DetachOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DetachOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DetachOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DetachOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr DetachOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause DetachOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DetachOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool DetachOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DetachOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool DetachOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DetachOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > DetachOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void DetachOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void DetachOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void DetachOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void DetachOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DetachOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void DetachOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DetachOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void DetachOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute DetachOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void DetachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void DetachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DetachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
}

void DetachOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value accPtr, /*optional*/::mlir::Value varPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(accPtr);
  if (varPtr)
    odsState.addOperands(varPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DetachOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DetachOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_detach);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DetachOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DetachOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DetachOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand accPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> accPtrOperands(accPtrRawOperands);  ::llvm::SMLoc accPtrOperandsLoc;
  (void)accPtrOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrOperands;
  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrTypes;
  if (parser.parseKeyword("accPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  accPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(accPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool boundsClause = false;
  bool toClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("to"))) {

  if (toClause) {
    return parser.emitError(parser.getNameLoc())
          << "`to` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  toClause = true;
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<DetachOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  if (parser.resolveOperands(accPtrOperands, accPtrTypes, accPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DetachOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "accPtr";
  _odsPrinter << "(";
  _odsPrinter << getAccPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  if (false || getVarPtr()) {
  _odsPrinter << ' ' << "to";
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_detach)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DetachOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::DevicePtrOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
DevicePtrOpGenericAdaptorBase::DevicePtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.deviceptr", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> DevicePtrOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr DevicePtrOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr DevicePtrOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause DevicePtrOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DevicePtrOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool DevicePtrOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DevicePtrOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool DevicePtrOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DevicePtrOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > DevicePtrOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
DevicePtrOpAdaptor::DevicePtrOpAdaptor(DevicePtrOp op) : DevicePtrOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult DevicePtrOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.deviceptr' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.deviceptr' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.deviceptr' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.deviceptr' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> DevicePtrOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range DevicePtrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DevicePtrOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DevicePtrOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range DevicePtrOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange DevicePtrOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DevicePtrOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange DevicePtrOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> DevicePtrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range DevicePtrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> DevicePtrOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult DevicePtrOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute DevicePtrOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code DevicePtrOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> DevicePtrOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void DevicePtrOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void DevicePtrOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult DevicePtrOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult DevicePtrOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void DevicePtrOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr DevicePtrOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause DevicePtrOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr DevicePtrOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool DevicePtrOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr DevicePtrOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool DevicePtrOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr DevicePtrOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > DevicePtrOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void DevicePtrOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void DevicePtrOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void DevicePtrOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void DevicePtrOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DevicePtrOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void DevicePtrOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void DevicePtrOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void DevicePtrOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute DevicePtrOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void DevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void DevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void DevicePtrOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void DevicePtrOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_deviceptr);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult DevicePtrOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult DevicePtrOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult DevicePtrOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<DevicePtrOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void DevicePtrOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_deviceptr)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::DevicePtrOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::EnterDataOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
EnterDataOpGenericAdaptorBase::EnterDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.enter_data", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> EnterDataOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr EnterDataOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr EnterDataOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool EnterDataOpGenericAdaptorBase::getAsync() {
  auto attr = getAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr EnterDataOpGenericAdaptorBase::getWaitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool EnterDataOpGenericAdaptorBase::getWait() {
  auto attr = getWaitAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
EnterDataOpAdaptor::EnterDataOpAdaptor(EnterDataOp op) : EnterDataOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult EnterDataOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_async = getProperties().async; (void)tblgen_async;
  auto tblgen_wait = getProperties().wait; (void)tblgen_wait;

  if (tblgen_async && !((::llvm::isa<::mlir::UnitAttr>(tblgen_async))))
    return emitError(loc, "'acc.enter_data' op ""attribute 'async' failed to satisfy constraint: unit attribute");

  if (tblgen_wait && !((::llvm::isa<::mlir::UnitAttr>(tblgen_wait))))
    return emitError(loc, "'acc.enter_data' op ""attribute 'wait' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> EnterDataOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range EnterDataOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> EnterDataOp::getIfCond() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Value EnterDataOp::getAsyncOperand() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value EnterDataOp::getWaitDevnum() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range EnterDataOp::getWaitOperands() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range EnterDataOp::getDataClauseOperands() {
  return getODSOperands(4);
}

::mlir::MutableOperandRange EnterDataOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange EnterDataOp::getAsyncOperandMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange EnterDataOp::getWaitDevnumMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange EnterDataOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange EnterDataOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> EnterDataOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range EnterDataOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult EnterDataOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.async;
       auto attr = dict.get("async");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for async in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `async` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.wait;
       auto attr = dict.get("wait");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for wait in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `wait` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute EnterDataOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.async;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("async",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.wait;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("wait",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code EnterDataOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.async.getAsOpaquePointer()), 
    llvm::hash_value(prop.wait.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> EnterDataOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "async")
      return prop.async;

    if (name == "wait")
      return prop.wait;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void EnterDataOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "async") {
       prop.async = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.async)>>(value);
       return;
    }

    if (name == "wait") {
       prop.wait = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.wait)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void EnterDataOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.async) attrs.append("async", prop.async);

    if (prop.wait) attrs.append("wait", prop.wait);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult EnterDataOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "async", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "wait", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult EnterDataOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.async)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.wait)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void EnterDataOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.async);

  writer.writeOptionalAttribute(prop.wait);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr EnterDataOp::getAsyncAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
}

bool EnterDataOp::getAsync() {
  auto attr = getAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr EnterDataOp::getWaitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
}

bool EnterDataOp::getWait() {
  auto attr = getWaitAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void EnterDataOp::setAsyncAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrName(), attr);
}

void EnterDataOp::setAsync(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrName());
}

void EnterDataOp::setWaitAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrName(), attr);
}

void EnterDataOp::setWait(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrName());
}

::mlir::Attribute EnterDataOp::removeAsyncAttr() {
    auto &attr = getProperties().async;
    attr = {};
    return attr;
}

::mlir::Attribute EnterDataOp::removeWaitAttr() {
    auto &attr = getProperties().wait;
    attr = {};
    return attr;
}

void EnterDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = async;
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = wait;
  }
}

void EnterDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = async;
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = wait;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void EnterDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = ((async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = ((wait) ? odsBuilder.getUnitAttr() : nullptr);
  }
}

void EnterDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = ((async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = ((wait) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void EnterDataOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult EnterDataOp::verifyInvariantsImpl() {
  auto tblgen_async = getProperties().async; (void)tblgen_async;
  auto tblgen_wait = getProperties().wait; (void)tblgen_wait;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_async, "async")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_wait, "wait")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult EnterDataOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult EnterDataOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> asyncOperandOperands;
  ::llvm::SMLoc asyncOperandOperandsLoc;
  (void)asyncOperandOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> asyncOperandTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitDevnumOperands;
  ::llvm::SMLoc waitDevnumOperandsLoc;
  (void)waitDevnumOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitDevnumTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitOperandsOperands;
  ::llvm::SMLoc waitOperandsOperandsLoc;
  (void)waitOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  bool ifClause = false;
  bool asyncClause = false;
  bool wait_devnumClause = false;
  bool waitClause = false;
  bool dataOperandsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("async"))) {

  if (asyncClause) {
    return parser.emitError(parser.getNameLoc())
          << "`async` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  asyncClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    asyncOperandOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperandOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperandTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait_devnum"))) {

  if (wait_devnumClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait_devnum` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  wait_devnumClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    waitDevnumOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait"))) {

  if (waitClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  waitClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  waitOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(waitOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(waitOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(asyncOperandOperands.size()), static_cast<int32_t>(waitDevnumOperands.size()), static_cast<int32_t>(waitOperandsOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<EnterDataOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(asyncOperandOperands, asyncOperandTypes, asyncOperandOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitDevnumOperands, waitDevnumTypes, waitDevnumOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitOperandsOperands, waitOperandsTypes, waitOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void EnterDataOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getAsyncOperand()) {
  _odsPrinter << ' ' << "async";
  _odsPrinter << "(";
  if (::mlir::Value value = getAsyncOperand())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getAsyncOperand() ? ::llvm::ArrayRef<::mlir::Type>(getAsyncOperand().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitDevnum()) {
  _odsPrinter << ' ' << "wait_devnum";
  _odsPrinter << "(";
  if (::mlir::Value value = getWaitDevnum())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getWaitDevnum() ? ::llvm::ArrayRef<::mlir::Type>(getWaitDevnum().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitOperands().size()) {
  _odsPrinter << ' ' << "wait";
  _odsPrinter << "(";
  _odsPrinter << getWaitOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getWaitOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAsyncAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("async");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getWaitAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("wait");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::EnterDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ExitDataOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ExitDataOpGenericAdaptorBase::ExitDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.exit_data", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ExitDataOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr ExitDataOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr ExitDataOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ExitDataOpGenericAdaptorBase::getAsync() {
  auto attr = getAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ExitDataOpGenericAdaptorBase::getWaitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ExitDataOpGenericAdaptorBase::getWait() {
  auto attr = getWaitAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ExitDataOpGenericAdaptorBase::getFinalizeAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalize);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ExitDataOpGenericAdaptorBase::getFinalize() {
  auto attr = getFinalizeAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

} // namespace detail
ExitDataOpAdaptor::ExitDataOpAdaptor(ExitDataOp op) : ExitDataOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult ExitDataOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_async = getProperties().async; (void)tblgen_async;
  auto tblgen_finalize = getProperties().finalize; (void)tblgen_finalize;
  auto tblgen_wait = getProperties().wait; (void)tblgen_wait;

  if (tblgen_async && !((::llvm::isa<::mlir::UnitAttr>(tblgen_async))))
    return emitError(loc, "'acc.exit_data' op ""attribute 'async' failed to satisfy constraint: unit attribute");

  if (tblgen_wait && !((::llvm::isa<::mlir::UnitAttr>(tblgen_wait))))
    return emitError(loc, "'acc.exit_data' op ""attribute 'wait' failed to satisfy constraint: unit attribute");

  if (tblgen_finalize && !((::llvm::isa<::mlir::UnitAttr>(tblgen_finalize))))
    return emitError(loc, "'acc.exit_data' op ""attribute 'finalize' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ExitDataOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range ExitDataOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> ExitDataOp::getIfCond() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Value ExitDataOp::getAsyncOperand() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value ExitDataOp::getWaitDevnum() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range ExitDataOp::getWaitOperands() {
  return getODSOperands(3);
}

::mlir::Operation::operand_range ExitDataOp::getDataClauseOperands() {
  return getODSOperands(4);
}

::mlir::MutableOperandRange ExitDataOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ExitDataOp::getAsyncOperandMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ExitDataOp::getWaitDevnumMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ExitDataOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ExitDataOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> ExitDataOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ExitDataOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult ExitDataOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.async;
       auto attr = dict.get("async");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for async in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `async` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.finalize;
       auto attr = dict.get("finalize");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for finalize in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `finalize` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.wait;
       auto attr = dict.get("wait");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for wait in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `wait` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute ExitDataOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.async;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("async",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.finalize;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("finalize",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.wait;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("wait",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ExitDataOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.async.getAsOpaquePointer()), 
    llvm::hash_value(prop.finalize.getAsOpaquePointer()), 
    llvm::hash_value(prop.wait.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> ExitDataOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "async")
      return prop.async;

    if (name == "finalize")
      return prop.finalize;

    if (name == "wait")
      return prop.wait;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void ExitDataOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "async") {
       prop.async = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.async)>>(value);
       return;
    }

    if (name == "finalize") {
       prop.finalize = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.finalize)>>(value);
       return;
    }

    if (name == "wait") {
       prop.wait = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.wait)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void ExitDataOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.async) attrs.append("async", prop.async);

    if (prop.finalize) attrs.append("finalize", prop.finalize);

    if (prop.wait) attrs.append("wait", prop.wait);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult ExitDataOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "async", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getFinalizeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "finalize", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "wait", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ExitDataOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.async)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.finalize)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.wait)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ExitDataOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.async);

  writer.writeOptionalAttribute(prop.finalize);

  writer.writeOptionalAttribute(prop.wait);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr ExitDataOp::getAsyncAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().async);
}

bool ExitDataOp::getAsync() {
  auto attr = getAsyncAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ExitDataOp::getWaitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().wait);
}

bool ExitDataOp::getWait() {
  auto attr = getWaitAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ExitDataOp::getFinalizeAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().finalize);
}

bool ExitDataOp::getFinalize() {
  auto attr = getFinalizeAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void ExitDataOp::setAsyncAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrName(), attr);
}

void ExitDataOp::setAsync(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrName());
}

void ExitDataOp::setWaitAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrName(), attr);
}

void ExitDataOp::setWait(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrName());
}

void ExitDataOp::setFinalizeAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getFinalizeAttrName(), attr);
}

void ExitDataOp::setFinalize(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getFinalizeAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getFinalizeAttrName());
}

::mlir::Attribute ExitDataOp::removeAsyncAttr() {
    auto &attr = getProperties().async;
    attr = {};
    return attr;
}

::mlir::Attribute ExitDataOp::removeWaitAttr() {
    auto &attr = getProperties().wait;
    attr = {};
    return attr;
}

::mlir::Attribute ExitDataOp::removeFinalizeAttr() {
    auto &attr = getProperties().finalize;
    attr = {};
    return attr;
}

void ExitDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = async;
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = wait;
  }
  if (finalize) {
    odsState.getOrAddProperties<Properties>().finalize = finalize;
  }
}

void ExitDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/::mlir::UnitAttr async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr wait, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr finalize) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = async;
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = wait;
  }
  if (finalize) {
    odsState.getOrAddProperties<Properties>().finalize = finalize;
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExitDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = ((async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = ((wait) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (finalize) {
    odsState.getOrAddProperties<Properties>().finalize = ((finalize) ? odsBuilder.getUnitAttr() : nullptr);
  }
}

void ExitDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value asyncOperand, /*optional*/bool async, /*optional*/::mlir::Value waitDevnum, ::mlir::ValueRange waitOperands, /*optional*/bool wait, ::mlir::ValueRange dataClauseOperands, /*optional*/bool finalize) {
  if (ifCond)
    odsState.addOperands(ifCond);
  if (asyncOperand)
    odsState.addOperands(asyncOperand);
  if (waitDevnum)
    odsState.addOperands(waitDevnum);
  odsState.addOperands(waitOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), (asyncOperand ? 1 : 0), (waitDevnum ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (async) {
    odsState.getOrAddProperties<Properties>().async = ((async) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (wait) {
    odsState.getOrAddProperties<Properties>().wait = ((wait) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (finalize) {
    odsState.getOrAddProperties<Properties>().finalize = ((finalize) ? odsBuilder.getUnitAttr() : nullptr);
  }
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ExitDataOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ExitDataOp::verifyInvariantsImpl() {
  auto tblgen_async = getProperties().async; (void)tblgen_async;
  auto tblgen_finalize = getProperties().finalize; (void)tblgen_finalize;
  auto tblgen_wait = getProperties().wait; (void)tblgen_wait;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_async, "async")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_wait, "wait")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_finalize, "finalize")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ExitDataOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ExitDataOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> asyncOperandOperands;
  ::llvm::SMLoc asyncOperandOperandsLoc;
  (void)asyncOperandOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> asyncOperandTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitDevnumOperands;
  ::llvm::SMLoc waitDevnumOperandsLoc;
  (void)waitDevnumOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitDevnumTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitOperandsOperands;
  ::llvm::SMLoc waitOperandsOperandsLoc;
  (void)waitOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  bool ifClause = false;
  bool asyncClause = false;
  bool wait_devnumClause = false;
  bool waitClause = false;
  bool dataOperandsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("async"))) {

  if (asyncClause) {
    return parser.emitError(parser.getNameLoc())
          << "`async` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  asyncClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    asyncOperandOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperandOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperandTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait_devnum"))) {

  if (wait_devnumClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait_devnum` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  wait_devnumClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    waitDevnumOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      waitDevnumTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait"))) {

  if (waitClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  waitClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  waitOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(waitOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(waitOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(asyncOperandOperands.size()), static_cast<int32_t>(waitDevnumOperands.size()), static_cast<int32_t>(waitOperandsOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<ExitDataOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(asyncOperandOperands, asyncOperandTypes, asyncOperandOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitDevnumOperands, waitDevnumTypes, waitDevnumOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitOperandsOperands, waitOperandsTypes, waitOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ExitDataOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getAsyncOperand()) {
  _odsPrinter << ' ' << "async";
  _odsPrinter << "(";
  if (::mlir::Value value = getAsyncOperand())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getAsyncOperand() ? ::llvm::ArrayRef<::mlir::Type>(getAsyncOperand().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitDevnum()) {
  _odsPrinter << ' ' << "wait_devnum";
  _odsPrinter << "(";
  if (::mlir::Value value = getWaitDevnum())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getWaitDevnum() ? ::llvm::ArrayRef<::mlir::Type>(getWaitDevnum().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitOperands().size()) {
  _odsPrinter << ' ' << "wait";
  _odsPrinter << "(";
  _odsPrinter << getWaitOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getWaitOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAsyncAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("async");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getWaitAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("wait");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getFinalizeAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("finalize");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::ExitDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::FirstprivateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FirstprivateOpGenericAdaptorBase::FirstprivateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.firstprivate", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> FirstprivateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr FirstprivateOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr FirstprivateOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause FirstprivateOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr FirstprivateOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool FirstprivateOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr FirstprivateOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool FirstprivateOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr FirstprivateOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > FirstprivateOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
FirstprivateOpAdaptor::FirstprivateOpAdaptor(FirstprivateOp op) : FirstprivateOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult FirstprivateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.firstprivate' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.firstprivate' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.firstprivate' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.firstprivate' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FirstprivateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range FirstprivateOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> FirstprivateOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> FirstprivateOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range FirstprivateOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange FirstprivateOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange FirstprivateOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange FirstprivateOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> FirstprivateOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FirstprivateOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> FirstprivateOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult FirstprivateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute FirstprivateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FirstprivateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> FirstprivateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void FirstprivateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void FirstprivateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult FirstprivateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FirstprivateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void FirstprivateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr FirstprivateOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause FirstprivateOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr FirstprivateOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool FirstprivateOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr FirstprivateOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool FirstprivateOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr FirstprivateOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > FirstprivateOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void FirstprivateOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void FirstprivateOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void FirstprivateOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void FirstprivateOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void FirstprivateOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void FirstprivateOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void FirstprivateOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void FirstprivateOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute FirstprivateOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void FirstprivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void FirstprivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FirstprivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void FirstprivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FirstprivateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void FirstprivateOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_firstprivate);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult FirstprivateOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult FirstprivateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult FirstprivateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<FirstprivateOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FirstprivateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_firstprivate)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::FirstprivateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::FirstprivateRecipeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FirstprivateRecipeOpGenericAdaptorBase::FirstprivateRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.firstprivate.recipe", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> FirstprivateRecipeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr FirstprivateRecipeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr FirstprivateRecipeOpGenericAdaptorBase::getSymNameAttr() {
  auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  return attr;
}

::llvm::StringRef FirstprivateRecipeOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr FirstprivateRecipeOpGenericAdaptorBase::getTypeAttr() {
  auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  return attr;
}

::mlir::Type FirstprivateRecipeOpGenericAdaptorBase::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Region &FirstprivateRecipeOpGenericAdaptorBase::getInitRegion() {
  return *odsRegions[0];
}

::mlir::Region &FirstprivateRecipeOpGenericAdaptorBase::getCopyRegion() {
  return *odsRegions[1];
}

::mlir::Region &FirstprivateRecipeOpGenericAdaptorBase::getDestroyRegion() {
  return *odsRegions[2];
}

::mlir::RegionRange FirstprivateRecipeOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
FirstprivateRecipeOpAdaptor::FirstprivateRecipeOpAdaptor(FirstprivateRecipeOp op) : FirstprivateRecipeOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult FirstprivateRecipeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitError(loc, "'acc.firstprivate.recipe' op ""requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitError(loc, "'acc.firstprivate.recipe' op ""requires attribute 'type'");

  if (tblgen_sym_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_sym_name))))
    return emitError(loc, "'acc.firstprivate.recipe' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");

  if (tblgen_type && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_type))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_type).getValue()))) && ((true))))
    return emitError(loc, "'acc.firstprivate.recipe' op ""attribute 'type' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> FirstprivateRecipeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range FirstprivateRecipeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> FirstprivateRecipeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range FirstprivateRecipeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &FirstprivateRecipeOp::getInitRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &FirstprivateRecipeOp::getCopyRegion() {
  return (*this)->getRegion(1);
}

::mlir::Region &FirstprivateRecipeOp::getDestroyRegion() {
  return (*this)->getRegion(2);
}

::mlir::LogicalResult FirstprivateRecipeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.sym_name;
       auto attr = dict.get("sym_name");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for sym_name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `sym_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.type;
       auto attr = dict.get("type");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for type in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute FirstprivateRecipeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.sym_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("sym_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("type",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FirstprivateRecipeOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.sym_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.type.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> FirstprivateRecipeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "sym_name")
      return prop.sym_name;

    if (name == "type")
      return prop.type;
  return std::nullopt;
}

void FirstprivateRecipeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "sym_name") {
       prop.sym_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.sym_name)>>(value);
       return;
    }

    if (name == "type") {
       prop.type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.type)>>(value);
       return;
    }
}

void FirstprivateRecipeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.sym_name) attrs.append("sym_name", prop.sym_name);

    if (prop.type) attrs.append("type", prop.type);
}

::mlir::LogicalResult FirstprivateRecipeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getSymNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "sym_name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(attr, "type", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult FirstprivateRecipeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.sym_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.type)))
    return ::mlir::failure();
  return ::mlir::success();
}

void FirstprivateRecipeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.sym_name);
  writer.writeAttribute(prop.type);
}

::mlir::StringAttr FirstprivateRecipeOp::getSymNameAttr() {
  return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
}

::llvm::StringRef FirstprivateRecipeOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr FirstprivateRecipeOp::getTypeAttr() {
  return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
}

::mlir::Type FirstprivateRecipeOp::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void FirstprivateRecipeOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void FirstprivateRecipeOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void FirstprivateRecipeOp::setTypeAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTypeAttrName(), attr);
}

void FirstprivateRecipeOp::setType(::mlir::Type attrValue) {
  (*this)->setAttr(getTypeAttrName(), ::mlir::TypeAttr::get(attrValue));
}

void FirstprivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void FirstprivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FirstprivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void FirstprivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void FirstprivateRecipeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 3; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult FirstprivateRecipeOp::verifyInvariantsImpl() {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitOpError("requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitOpError("requires attribute 'type'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(*this, tblgen_type, "type")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "initRegion", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "copyRegion", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(2)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "destroyRegion", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult FirstprivateRecipeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult FirstprivateRecipeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr sym_nameAttr;
  ::mlir::TypeAttr typeAttr;
  std::unique_ptr<::mlir::Region> initRegionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> copyRegionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> destroyRegionRegion = std::make_unique<::mlir::Region>();

  if (parser.parseSymbolName(sym_nameAttr))
    return ::mlir::failure();
  if (sym_nameAttr) result.getOrAddProperties<FirstprivateRecipeOp::Properties>().sym_name = sym_nameAttr;
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(typeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (typeAttr) result.getOrAddProperties<FirstprivateRecipeOp::Properties>().type = typeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseKeyword("init"))
    return ::mlir::failure();

  if (parser.parseRegion(*initRegionRegion))
    return ::mlir::failure();
  if (parser.parseKeyword("copy"))
    return ::mlir::failure();

  if (parser.parseRegion(*copyRegionRegion))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("destroy"))) {

  if (parser.parseRegion(*destroyRegionRegion))
    return ::mlir::failure();
  }
  result.addRegion(std::move(initRegionRegion));
  result.addRegion(std::move(copyRegionRegion));
  result.addRegion(std::move(destroyRegionRegion));
  return ::mlir::success();
}

void FirstprivateRecipeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printSymbolName(getSymNameAttr().getValue());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getTypeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("sym_name");
  elidedAttrs.push_back("type");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "init";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getInitRegion());
  _odsPrinter << ' ' << "copy";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getCopyRegion());
  if (!getDestroyRegion().empty()) {
    _odsPrinter << ' ' << "destroy";
    _odsPrinter << ' ';
    _odsPrinter.printRegion(getDestroyRegion());
  }
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::FirstprivateRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GetDevicePtrOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GetDevicePtrOpGenericAdaptorBase::GetDevicePtrOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.getdeviceptr", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GetDevicePtrOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr GetDevicePtrOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr GetDevicePtrOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause GetDevicePtrOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr GetDevicePtrOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool GetDevicePtrOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr GetDevicePtrOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool GetDevicePtrOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr GetDevicePtrOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > GetDevicePtrOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
GetDevicePtrOpAdaptor::GetDevicePtrOpAdaptor(GetDevicePtrOp op) : GetDevicePtrOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult GetDevicePtrOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.getdeviceptr' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.getdeviceptr' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.getdeviceptr' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.getdeviceptr' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GetDevicePtrOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range GetDevicePtrOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> GetDevicePtrOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> GetDevicePtrOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range GetDevicePtrOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange GetDevicePtrOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange GetDevicePtrOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange GetDevicePtrOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> GetDevicePtrOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GetDevicePtrOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> GetDevicePtrOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult GetDevicePtrOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute GetDevicePtrOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GetDevicePtrOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> GetDevicePtrOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void GetDevicePtrOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void GetDevicePtrOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult GetDevicePtrOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult GetDevicePtrOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void GetDevicePtrOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr GetDevicePtrOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause GetDevicePtrOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr GetDevicePtrOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool GetDevicePtrOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr GetDevicePtrOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool GetDevicePtrOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr GetDevicePtrOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > GetDevicePtrOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void GetDevicePtrOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void GetDevicePtrOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void GetDevicePtrOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void GetDevicePtrOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void GetDevicePtrOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void GetDevicePtrOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void GetDevicePtrOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void GetDevicePtrOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute GetDevicePtrOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void GetDevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void GetDevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetDevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void GetDevicePtrOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GetDevicePtrOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void GetDevicePtrOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_getdeviceptr);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult GetDevicePtrOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult GetDevicePtrOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GetDevicePtrOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<GetDevicePtrOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void GetDevicePtrOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_getdeviceptr)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::GetDevicePtrOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GlobalConstructorOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GlobalConstructorOpGenericAdaptorBase::GlobalConstructorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.global_ctor", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GlobalConstructorOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GlobalConstructorOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr GlobalConstructorOpGenericAdaptorBase::getSymNameAttr() {
  auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  return attr;
}

::llvm::StringRef GlobalConstructorOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::Region &GlobalConstructorOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange GlobalConstructorOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
GlobalConstructorOpAdaptor::GlobalConstructorOpAdaptor(GlobalConstructorOp op) : GlobalConstructorOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult GlobalConstructorOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitError(loc, "'acc.global_ctor' op ""requires attribute 'sym_name'");

  if (tblgen_sym_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_sym_name))))
    return emitError(loc, "'acc.global_ctor' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GlobalConstructorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GlobalConstructorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GlobalConstructorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GlobalConstructorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GlobalConstructorOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult GlobalConstructorOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.sym_name;
       auto attr = dict.get("sym_name");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for sym_name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `sym_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GlobalConstructorOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.sym_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("sym_name",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GlobalConstructorOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.sym_name.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GlobalConstructorOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "sym_name")
      return prop.sym_name;
  return std::nullopt;
}

void GlobalConstructorOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "sym_name") {
       prop.sym_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.sym_name)>>(value);
       return;
    }
}

void GlobalConstructorOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.sym_name) attrs.append("sym_name", prop.sym_name);
}

::mlir::LogicalResult GlobalConstructorOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getSymNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "sym_name", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult GlobalConstructorOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.sym_name)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GlobalConstructorOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.sym_name);
}

::mlir::StringAttr GlobalConstructorOp::getSymNameAttr() {
  return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
}

::llvm::StringRef GlobalConstructorOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

void GlobalConstructorOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void GlobalConstructorOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void GlobalConstructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  (void)odsState.addRegion();
}

void GlobalConstructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalConstructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  (void)odsState.addRegion();
}

void GlobalConstructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalConstructorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GlobalConstructorOp::verifyInvariantsImpl() {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitOpError("requires attribute 'sym_name'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GlobalConstructorOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GlobalConstructorOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr sym_nameAttr;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();

  if (parser.parseSymbolName(sym_nameAttr))
    return ::mlir::failure();
  if (sym_nameAttr) result.getOrAddProperties<GlobalConstructorOp::Properties>().sym_name = sym_nameAttr;

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
  return ::mlir::success();
}

void GlobalConstructorOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printSymbolName(getSymNameAttr().getValue());
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("sym_name");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::GlobalConstructorOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::GlobalDestructorOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GlobalDestructorOpGenericAdaptorBase::GlobalDestructorOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.global_dtor", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> GlobalDestructorOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr GlobalDestructorOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr GlobalDestructorOpGenericAdaptorBase::getSymNameAttr() {
  auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  return attr;
}

::llvm::StringRef GlobalDestructorOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::Region &GlobalDestructorOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange GlobalDestructorOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
GlobalDestructorOpAdaptor::GlobalDestructorOpAdaptor(GlobalDestructorOp op) : GlobalDestructorOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult GlobalDestructorOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitError(loc, "'acc.global_dtor' op ""requires attribute 'sym_name'");

  if (tblgen_sym_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_sym_name))))
    return emitError(loc, "'acc.global_dtor' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> GlobalDestructorOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range GlobalDestructorOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> GlobalDestructorOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range GlobalDestructorOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &GlobalDestructorOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult GlobalDestructorOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.sym_name;
       auto attr = dict.get("sym_name");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for sym_name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `sym_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GlobalDestructorOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.sym_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("sym_name",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GlobalDestructorOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.sym_name.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GlobalDestructorOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "sym_name")
      return prop.sym_name;
  return std::nullopt;
}

void GlobalDestructorOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "sym_name") {
       prop.sym_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.sym_name)>>(value);
       return;
    }
}

void GlobalDestructorOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.sym_name) attrs.append("sym_name", prop.sym_name);
}

::mlir::LogicalResult GlobalDestructorOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getSymNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "sym_name", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult GlobalDestructorOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.sym_name)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GlobalDestructorOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.sym_name);
}

::mlir::StringAttr GlobalDestructorOp::getSymNameAttr() {
  return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
}

::llvm::StringRef GlobalDestructorOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

void GlobalDestructorOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void GlobalDestructorOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void GlobalDestructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  (void)odsState.addRegion();
}

void GlobalDestructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalDestructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  (void)odsState.addRegion();
}

void GlobalDestructorOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void GlobalDestructorOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult GlobalDestructorOp::verifyInvariantsImpl() {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitOpError("requires attribute 'sym_name'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult GlobalDestructorOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GlobalDestructorOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr sym_nameAttr;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();

  if (parser.parseSymbolName(sym_nameAttr))
    return ::mlir::failure();
  if (sym_nameAttr) result.getOrAddProperties<GlobalDestructorOp::Properties>().sym_name = sym_nameAttr;

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
  return ::mlir::success();
}

void GlobalDestructorOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printSymbolName(getSymNameAttr().getValue());
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("sym_name");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::GlobalDestructorOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::HostDataOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
HostDataOpGenericAdaptorBase::HostDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.host_data", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> HostDataOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr HostDataOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr HostDataOpGenericAdaptorBase::getIfPresentAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().ifPresent);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool HostDataOpGenericAdaptorBase::getIfPresent() {
  auto attr = getIfPresentAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::Region &HostDataOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange HostDataOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
HostDataOpAdaptor::HostDataOpAdaptor(HostDataOp op) : HostDataOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult HostDataOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_ifPresent = getProperties().ifPresent; (void)tblgen_ifPresent;

  if (tblgen_ifPresent && !((::llvm::isa<::mlir::UnitAttr>(tblgen_ifPresent))))
    return emitError(loc, "'acc.host_data' op ""attribute 'ifPresent' failed to satisfy constraint: unit attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> HostDataOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range HostDataOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::IntegerType> HostDataOp::getIfCond() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Operation::operand_range HostDataOp::getDataClauseOperands() {
  return getODSOperands(1);
}

::mlir::MutableOperandRange HostDataOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange HostDataOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> HostDataOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range HostDataOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &HostDataOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult HostDataOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.ifPresent;
       auto attr = dict.get("ifPresent");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for ifPresent in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `ifPresent` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute HostDataOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.ifPresent;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("ifPresent",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code HostDataOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.ifPresent.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> HostDataOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "ifPresent")
      return prop.ifPresent;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void HostDataOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "ifPresent") {
       prop.ifPresent = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.ifPresent)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void HostDataOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.ifPresent) attrs.append("ifPresent", prop.ifPresent);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult HostDataOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getIfPresentAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "ifPresent", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult HostDataOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.ifPresent)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void HostDataOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.ifPresent);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr HostDataOp::getIfPresentAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().ifPresent);
}

bool HostDataOp::getIfPresent() {
  auto attr = getIfPresentAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

void HostDataOp::setIfPresentAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getIfPresentAttrName(), attr);
}

void HostDataOp::setIfPresent(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getIfPresentAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getIfPresentAttrName());
}

::mlir::Attribute HostDataOp::removeIfPresentAttr() {
    auto &attr = getProperties().ifPresent;
    attr = {};
    return attr;
}

void HostDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent) {
  if (ifCond)
    odsState.addOperands(ifCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (ifPresent) {
    odsState.getOrAddProperties<Properties>().ifPresent = ifPresent;
  }
  (void)odsState.addRegion();
}

void HostDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::UnitAttr ifPresent) {
  if (ifCond)
    odsState.addOperands(ifCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (ifPresent) {
    odsState.getOrAddProperties<Properties>().ifPresent = ifPresent;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void HostDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent) {
  if (ifCond)
    odsState.addOperands(ifCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (ifPresent) {
    odsState.getOrAddProperties<Properties>().ifPresent = ((ifPresent) ? odsBuilder.getUnitAttr() : nullptr);
  }
  (void)odsState.addRegion();
}

void HostDataOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value ifCond, ::mlir::ValueRange dataClauseOperands, /*optional*/bool ifPresent) {
  if (ifCond)
    odsState.addOperands(ifCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(ifCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (ifPresent) {
    odsState.getOrAddProperties<Properties>().ifPresent = ((ifPresent) ? odsBuilder.getUnitAttr() : nullptr);
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void HostDataOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult HostDataOp::verifyInvariantsImpl() {
  auto tblgen_ifPresent = getProperties().ifPresent; (void)tblgen_ifPresent;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_ifPresent, "ifPresent")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult HostDataOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult HostDataOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  bool ifClause = false;
  bool dataOperandsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<HostDataOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void HostDataOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIfPresentAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("ifPresent");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::HostDataOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::InitOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
InitOpGenericAdaptorBase::InitOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.init", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> InitOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr InitOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

} // namespace detail
InitOpAdaptor::InitOpAdaptor(InitOp op) : InitOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult InitOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

std::pair<unsigned, unsigned> InitOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range InitOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::operand_range InitOp::getDeviceTypeOperands() {
  return getODSOperands(0);
}

::mlir::Value InitOp::getDeviceNumOperand() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> InitOp::getIfCond() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::MutableOperandRange InitOp::getDeviceTypeOperandsMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange InitOp::getDeviceNumOperandMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange InitOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> InitOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range InitOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::LogicalResult InitOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
    ;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute InitOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InitOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> InitOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void InitOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void InitOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult InitOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    return ::mlir::success();
}

::mlir::LogicalResult InitOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void InitOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

void InitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange deviceTypeOperands, /*optional*/::mlir::Value deviceNumOperand, /*optional*/::mlir::Value ifCond) {
  odsState.addOperands(deviceTypeOperands);
  if (deviceNumOperand)
    odsState.addOperands(deviceNumOperand);
  if (ifCond)
    odsState.addOperands(ifCond);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(deviceTypeOperands.size()), (deviceNumOperand ? 1 : 0), (ifCond ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
}

void InitOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange deviceTypeOperands, /*optional*/::mlir::Value deviceNumOperand, /*optional*/::mlir::Value ifCond) {
  odsState.addOperands(deviceTypeOperands);
  if (deviceNumOperand)
    odsState.addOperands(deviceNumOperand);
  if (ifCond)
    odsState.addOperands(ifCond);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(deviceTypeOperands.size()), (deviceNumOperand ? 1 : 0), (ifCond ? 1 : 0)}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void InitOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult InitOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult InitOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult InitOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> deviceTypeOperandsOperands;
  ::llvm::SMLoc deviceTypeOperandsOperandsLoc;
  (void)deviceTypeOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> deviceTypeOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> deviceNumOperandOperands;
  ::llvm::SMLoc deviceNumOperandOperandsLoc;
  (void)deviceNumOperandOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> deviceNumOperandTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  bool device_typeClause = false;
  bool device_numClause = false;
  bool ifClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("device_type"))) {

  if (device_typeClause) {
    return parser.emitError(parser.getNameLoc())
          << "`device_type` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  device_typeClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  deviceTypeOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(deviceTypeOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(deviceTypeOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("device_num"))) {

  if (device_numClause) {
    return parser.emitError(parser.getNameLoc())
          << "`device_num` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  device_numClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    deviceNumOperandOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      deviceNumOperandOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      deviceNumOperandTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(deviceTypeOperandsOperands.size()), static_cast<int32_t>(deviceNumOperandOperands.size()), static_cast<int32_t>(ifCondOperands.size())}), result.getOrAddProperties<InitOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(deviceTypeOperandsOperands, deviceTypeOperandsTypes, deviceTypeOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(deviceNumOperandOperands, deviceNumOperandTypes, deviceNumOperandOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InitOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getDeviceTypeOperands().size()) {
  _odsPrinter << ' ' << "device_type";
  _odsPrinter << "(";
  _odsPrinter << getDeviceTypeOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDeviceTypeOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getDeviceNumOperand()) {
  _odsPrinter << ' ' << "device_num";
  _odsPrinter << "(";
  if (::mlir::Value value = getDeviceNumOperand())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getDeviceNumOperand() ? ::llvm::ArrayRef<::mlir::Type>(getDeviceNumOperand().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::InitOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::KernelsOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
KernelsOpGenericAdaptorBase::KernelsOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.kernels", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> KernelsOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr KernelsOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr KernelsOpGenericAdaptorBase::getAsyncAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool KernelsOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr KernelsOpGenericAdaptorBase::getWaitAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool KernelsOpGenericAdaptorBase::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr KernelsOpGenericAdaptorBase::getSelfAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool KernelsOpGenericAdaptorBase::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::acc::ClauseDefaultValueAttr KernelsOpGenericAdaptorBase::getDefaultAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  return attr;
}

::std::optional<::mlir::acc::ClauseDefaultValue> KernelsOpGenericAdaptorBase::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

::mlir::Region &KernelsOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange KernelsOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
KernelsOpAdaptor::KernelsOpAdaptor(KernelsOp op) : KernelsOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult KernelsOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_selfAttr = getProperties().selfAttr; (void)tblgen_selfAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (tblgen_asyncAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_asyncAttr))))
    return emitError(loc, "'acc.kernels' op ""attribute 'asyncAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_waitAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_waitAttr))))
    return emitError(loc, "'acc.kernels' op ""attribute 'waitAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_selfAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_selfAttr))))
    return emitError(loc, "'acc.kernels' op ""attribute 'selfAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_defaultAttr && !((::llvm::isa<::mlir::acc::ClauseDefaultValueAttr>(tblgen_defaultAttr))))
    return emitError(loc, "'acc.kernels' op ""attribute 'defaultAttr' failed to satisfy constraint: DefaultValue Clause");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> KernelsOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range KernelsOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value KernelsOp::getAsync() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range KernelsOp::getWaitOperands() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range KernelsOp::getNumGangs() {
  return getODSOperands(2);
}

::mlir::Value KernelsOp::getNumWorkers() {
  auto operands = getODSOperands(3);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value KernelsOp::getVectorLength() {
  auto operands = getODSOperands(4);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> KernelsOp::getIfCond() {
  auto operands = getODSOperands(5);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> KernelsOp::getSelfCond() {
  auto operands = getODSOperands(6);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Operation::operand_range KernelsOp::getDataClauseOperands() {
  return getODSOperands(7);
}

::mlir::MutableOperandRange KernelsOp::getAsyncMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getNumGangsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getNumWorkersMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getVectorLengthMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getSelfCondMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange KernelsOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> KernelsOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range KernelsOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &KernelsOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult KernelsOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.asyncAttr;
       auto attr = dict.get("asyncAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for asyncAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `asyncAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.defaultAttr;
       auto attr = dict.get("defaultAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for defaultAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `defaultAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.selfAttr;
       auto attr = dict.get("selfAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for selfAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `selfAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.waitAttr;
       auto attr = dict.get("waitAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for waitAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `waitAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute KernelsOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.asyncAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("asyncAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.defaultAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("defaultAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.selfAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("selfAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.waitAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("waitAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code KernelsOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.asyncAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.defaultAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.selfAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.waitAttr.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> KernelsOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "asyncAttr")
      return prop.asyncAttr;

    if (name == "defaultAttr")
      return prop.defaultAttr;

    if (name == "selfAttr")
      return prop.selfAttr;

    if (name == "waitAttr")
      return prop.waitAttr;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void KernelsOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "asyncAttr") {
       prop.asyncAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.asyncAttr)>>(value);
       return;
    }

    if (name == "defaultAttr") {
       prop.defaultAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.defaultAttr)>>(value);
       return;
    }

    if (name == "selfAttr") {
       prop.selfAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.selfAttr)>>(value);
       return;
    }

    if (name == "waitAttr") {
       prop.waitAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.waitAttr)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void KernelsOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.asyncAttr) attrs.append("asyncAttr", prop.asyncAttr);

    if (prop.defaultAttr) attrs.append("defaultAttr", prop.defaultAttr);

    if (prop.selfAttr) attrs.append("selfAttr", prop.selfAttr);

    if (prop.waitAttr) attrs.append("waitAttr", prop.waitAttr);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult KernelsOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "asyncAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getDefaultAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(attr, "defaultAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSelfAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "selfAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "waitAttr", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult KernelsOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.asyncAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.defaultAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.selfAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.waitAttr)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void KernelsOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.asyncAttr);

  writer.writeOptionalAttribute(prop.defaultAttr);

  writer.writeOptionalAttribute(prop.selfAttr);

  writer.writeOptionalAttribute(prop.waitAttr);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr KernelsOp::getAsyncAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
}

bool KernelsOp::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr KernelsOp::getWaitAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
}

bool KernelsOp::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr KernelsOp::getSelfAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
}

bool KernelsOp::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::acc::ClauseDefaultValueAttr KernelsOp::getDefaultAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
}

::std::optional<::mlir::acc::ClauseDefaultValue> KernelsOp::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

void KernelsOp::setAsyncAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrAttrName(), attr);
}

void KernelsOp::setAsyncAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrAttrName());
}

void KernelsOp::setWaitAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrAttrName(), attr);
}

void KernelsOp::setWaitAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrAttrName());
}

void KernelsOp::setSelfAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getSelfAttrAttrName(), attr);
}

void KernelsOp::setSelfAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getSelfAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getSelfAttrAttrName());
}

void KernelsOp::setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
  (*this)->setAttr(getDefaultAttrAttrName(), attr);
}

void KernelsOp::setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getDefaultAttrAttrName(), ::mlir::acc::ClauseDefaultValueAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue));
    (*this)->removeAttr(getDefaultAttrAttrName());
}

::mlir::Attribute KernelsOp::removeAsyncAttrAttr() {
    auto &attr = getProperties().asyncAttr;
    attr = {};
    return attr;
}

::mlir::Attribute KernelsOp::removeWaitAttrAttr() {
    auto &attr = getProperties().waitAttr;
    attr = {};
    return attr;
}

::mlir::Attribute KernelsOp::removeSelfAttrAttr() {
    auto &attr = getProperties().selfAttr;
    attr = {};
    return attr;
}

::mlir::Attribute KernelsOp::removeDefaultAttrAttr() {
    auto &attr = getProperties().defaultAttr;
    attr = {};
    return attr;
}

void KernelsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = selfAttr;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void KernelsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = selfAttr;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void KernelsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = ((selfAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void KernelsOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = ((selfAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void KernelsOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult KernelsOp::verifyInvariantsImpl() {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_selfAttr = getProperties().selfAttr; (void)tblgen_selfAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_asyncAttr, "asyncAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_waitAttr, "waitAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_selfAttr, "selfAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(*this, tblgen_defaultAttr, "defaultAttr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    if (valueGroup5.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup5.size();
    }

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    if (valueGroup6.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup6.size();
    }

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult KernelsOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult KernelsOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> asyncOperands;
  ::llvm::SMLoc asyncOperandsLoc;
  (void)asyncOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> asyncTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> numGangsOperands;
  ::llvm::SMLoc numGangsOperandsLoc;
  (void)numGangsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> numGangsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> numWorkersOperands;
  ::llvm::SMLoc numWorkersOperandsLoc;
  (void)numWorkersOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> numWorkersTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> vectorLengthOperands;
  ::llvm::SMLoc vectorLengthOperandsLoc;
  (void)vectorLengthOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> vectorLengthTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitOperandsOperands;
  ::llvm::SMLoc waitOperandsOperandsLoc;
  (void)waitOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> selfCondOperands;
  ::llvm::SMLoc selfCondOperandsLoc;
  (void)selfCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  bool dataOperandsClause = false;
  bool asyncClause = false;
  bool num_gangsClause = false;
  bool num_workersClause = false;
  bool vector_lengthClause = false;
  bool waitClause = false;
  bool selfClause = false;
  bool ifClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("async"))) {

  if (asyncClause) {
    return parser.emitError(parser.getNameLoc())
          << "`async` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  asyncClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    asyncOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("num_gangs"))) {

  if (num_gangsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`num_gangs` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  num_gangsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  numGangsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(numGangsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(numGangsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("num_workers"))) {

  if (num_workersClause) {
    return parser.emitError(parser.getNameLoc())
          << "`num_workers` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  num_workersClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    numWorkersOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      numWorkersOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      numWorkersTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("vector_length"))) {

  if (vector_lengthClause) {
    return parser.emitError(parser.getNameLoc())
          << "`vector_length` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  vector_lengthClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    vectorLengthOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      vectorLengthOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      vectorLengthTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait"))) {

  if (waitClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  waitClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  waitOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(waitOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(waitOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("self"))) {

  if (selfClause) {
    return parser.emitError(parser.getNameLoc())
          << "`self` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  selfClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    selfCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      selfCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(asyncOperands.size()), static_cast<int32_t>(waitOperandsOperands.size()), static_cast<int32_t>(numGangsOperands.size()), static_cast<int32_t>(numWorkersOperands.size()), static_cast<int32_t>(vectorLengthOperands.size()), static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(selfCondOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<KernelsOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(asyncOperands, asyncTypes, asyncOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitOperandsOperands, waitOperandsTypes, waitOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(numGangsOperands, numGangsTypes, numGangsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(numWorkersOperands, numWorkersTypes, numWorkersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(vectorLengthOperands, vectorLengthTypes, vectorLengthOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(selfCondOperands, odsBuildableType0, selfCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void KernelsOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getAsync()) {
  _odsPrinter << ' ' << "async";
  _odsPrinter << "(";
  if (::mlir::Value value = getAsync())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getAsync() ? ::llvm::ArrayRef<::mlir::Type>(getAsync().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getNumGangs().size()) {
  _odsPrinter << ' ' << "num_gangs";
  _odsPrinter << "(";
  _odsPrinter << getNumGangs();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getNumGangs().getTypes();
  _odsPrinter << ")";
  }
  if (false || getNumWorkers()) {
  _odsPrinter << ' ' << "num_workers";
  _odsPrinter << "(";
  if (::mlir::Value value = getNumWorkers())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getNumWorkers() ? ::llvm::ArrayRef<::mlir::Type>(getNumWorkers().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getVectorLength()) {
  _odsPrinter << ' ' << "vector_length";
  _odsPrinter << "(";
  if (::mlir::Value value = getVectorLength())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVectorLength() ? ::llvm::ArrayRef<::mlir::Type>(getVectorLength().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitOperands().size()) {
  _odsPrinter << ' ' << "wait";
  _odsPrinter << "(";
  _odsPrinter << getWaitOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getWaitOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getSelfCond()) {
  _odsPrinter << ' ' << "self";
  _odsPrinter << "(";
  if (::mlir::Value value = getSelfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAsyncAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("asyncAttr");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getWaitAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("waitAttr");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getSelfAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("selfAttr");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::KernelsOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::LoopOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
LoopOpGenericAdaptorBase::LoopOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.loop", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> LoopOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr LoopOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::IntegerAttr LoopOpGenericAdaptorBase::getCollapseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().collapse);
  return attr;
}

::std::optional<uint64_t> LoopOpGenericAdaptorBase::getCollapse() {
  auto attr = getCollapseAttr();
  return attr ? ::std::optional<uint64_t>(attr.getValue().getZExtValue()) : (::std::nullopt);
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getSeqAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().seq);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getSeq() {
  auto attr = getSeqAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getIndependentAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().independent);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getIndependent() {
  auto attr = getIndependentAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getAuto_Attr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().auto_);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getAuto_() {
  auto attr = getAuto_Attr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getHasGangAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasGang);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getHasGang() {
  auto attr = getHasGangAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getHasWorkerAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasWorker);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getHasWorker() {
  auto attr = getHasWorkerAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOpGenericAdaptorBase::getHasVectorAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasVector);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool LoopOpGenericAdaptorBase::getHasVector() {
  auto attr = getHasVectorAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr LoopOpGenericAdaptorBase::getPrivatizationsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > LoopOpGenericAdaptorBase::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr LoopOpGenericAdaptorBase::getReductionRecipesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > LoopOpGenericAdaptorBase::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::Region &LoopOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange LoopOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
LoopOpAdaptor::LoopOpAdaptor(LoopOp op) : LoopOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult LoopOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_auto_ = getProperties().auto_; (void)tblgen_auto_;
  auto tblgen_collapse = getProperties().collapse; (void)tblgen_collapse;
  auto tblgen_hasGang = getProperties().hasGang; (void)tblgen_hasGang;
  auto tblgen_hasVector = getProperties().hasVector; (void)tblgen_hasVector;
  auto tblgen_hasWorker = getProperties().hasWorker; (void)tblgen_hasWorker;
  auto tblgen_independent = getProperties().independent; (void)tblgen_independent;
  auto tblgen_privatizations = getProperties().privatizations; (void)tblgen_privatizations;
  auto tblgen_reductionRecipes = getProperties().reductionRecipes; (void)tblgen_reductionRecipes;
  auto tblgen_seq = getProperties().seq; (void)tblgen_seq;

  if (tblgen_collapse && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_collapse))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_collapse).getType().isSignlessInteger(64)))))
    return emitError(loc, "'acc.loop' op ""attribute 'collapse' failed to satisfy constraint: 64-bit signless integer attribute");

  if (tblgen_seq && !((::llvm::isa<::mlir::UnitAttr>(tblgen_seq))))
    return emitError(loc, "'acc.loop' op ""attribute 'seq' failed to satisfy constraint: unit attribute");

  if (tblgen_independent && !((::llvm::isa<::mlir::UnitAttr>(tblgen_independent))))
    return emitError(loc, "'acc.loop' op ""attribute 'independent' failed to satisfy constraint: unit attribute");

  if (tblgen_auto_ && !((::llvm::isa<::mlir::UnitAttr>(tblgen_auto_))))
    return emitError(loc, "'acc.loop' op ""attribute 'auto_' failed to satisfy constraint: unit attribute");

  if (tblgen_hasGang && !((::llvm::isa<::mlir::UnitAttr>(tblgen_hasGang))))
    return emitError(loc, "'acc.loop' op ""attribute 'hasGang' failed to satisfy constraint: unit attribute");

  if (tblgen_hasWorker && !((::llvm::isa<::mlir::UnitAttr>(tblgen_hasWorker))))
    return emitError(loc, "'acc.loop' op ""attribute 'hasWorker' failed to satisfy constraint: unit attribute");

  if (tblgen_hasVector && !((::llvm::isa<::mlir::UnitAttr>(tblgen_hasVector))))
    return emitError(loc, "'acc.loop' op ""attribute 'hasVector' failed to satisfy constraint: unit attribute");

  if (tblgen_privatizations && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_privatizations))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_privatizations), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.loop' op ""attribute 'privatizations' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_reductionRecipes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_reductionRecipes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_reductionRecipes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.loop' op ""attribute 'reductionRecipes' failed to satisfy constraint: symbol ref array attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> LoopOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range LoopOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value LoopOp::getGangNum() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value LoopOp::getGangDim() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value LoopOp::getGangStatic() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value LoopOp::getWorkerNum() {
  auto operands = getODSOperands(3);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value LoopOp::getVectorLength() {
  auto operands = getODSOperands(4);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range LoopOp::getTileOperands() {
  return getODSOperands(5);
}

::mlir::Operation::operand_range LoopOp::getPrivateOperands() {
  return getODSOperands(6);
}

::mlir::Operation::operand_range LoopOp::getReductionOperands() {
  return getODSOperands(7);
}

::mlir::MutableOperandRange LoopOp::getGangNumMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getGangDimMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getGangStaticMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getWorkerNumMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getVectorLengthMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getTileOperandsMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getPrivateOperandsMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange LoopOp::getReductionOperandsMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> LoopOp::getODSResultIndexAndLength(unsigned index) {
  bool isVariadic[] = {true};
  int prevVariadicCount = 0;
  for (unsigned i = 0; i < index; ++i)
    if (isVariadic[i]) ++prevVariadicCount;

  // Calculate how many dynamic values a static variadic operand corresponds to.
  // This assumes all static variadic operands have the same dynamic value count.
  int variadicSize = (getOperation()->getNumResults() - 0) / 1;
  // `index` passed in as the parameter is the static index which counts each
  // operand (variadic or not) as size 1. So here for each previous static variadic
  // operand, we need to offset by (variadicSize - 1) to get where the dynamic
  // value pack for this static operand starts.
  int start = index + (variadicSize - 1) * prevVariadicCount;
  int size = isVariadic[index] ? variadicSize : 1;
  return {start, size};
}

::mlir::Operation::result_range LoopOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Operation::result_range LoopOp::getResults() {
  return getODSResults(0);
}

::mlir::Region &LoopOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult LoopOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.auto_;
       auto attr = dict.get("auto_");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for auto_ in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `auto_` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.collapse;
       auto attr = dict.get("collapse");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for collapse in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `collapse` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hasGang;
       auto attr = dict.get("hasGang");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for hasGang in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `hasGang` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hasVector;
       auto attr = dict.get("hasVector");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for hasVector in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `hasVector` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.hasWorker;
       auto attr = dict.get("hasWorker");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for hasWorker in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `hasWorker` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.independent;
       auto attr = dict.get("independent");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for independent in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `independent` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.privatizations;
       auto attr = dict.get("privatizations");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for privatizations in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `privatizations` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.reductionRecipes;
       auto attr = dict.get("reductionRecipes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for reductionRecipes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `reductionRecipes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.seq;
       auto attr = dict.get("seq");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for seq in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `seq` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute LoopOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.auto_;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("auto_",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.collapse;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("collapse",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hasGang;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hasGang",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hasVector;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hasVector",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.hasWorker;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("hasWorker",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.independent;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("independent",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.privatizations;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("privatizations",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.reductionRecipes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("reductionRecipes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.seq;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("seq",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code LoopOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.auto_.getAsOpaquePointer()), 
    llvm::hash_value(prop.collapse.getAsOpaquePointer()), 
    llvm::hash_value(prop.hasGang.getAsOpaquePointer()), 
    llvm::hash_value(prop.hasVector.getAsOpaquePointer()), 
    llvm::hash_value(prop.hasWorker.getAsOpaquePointer()), 
    llvm::hash_value(prop.independent.getAsOpaquePointer()), 
    llvm::hash_value(prop.privatizations.getAsOpaquePointer()), 
    llvm::hash_value(prop.reductionRecipes.getAsOpaquePointer()), 
    llvm::hash_value(prop.seq.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> LoopOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "auto_")
      return prop.auto_;

    if (name == "collapse")
      return prop.collapse;

    if (name == "hasGang")
      return prop.hasGang;

    if (name == "hasVector")
      return prop.hasVector;

    if (name == "hasWorker")
      return prop.hasWorker;

    if (name == "independent")
      return prop.independent;

    if (name == "privatizations")
      return prop.privatizations;

    if (name == "reductionRecipes")
      return prop.reductionRecipes;

    if (name == "seq")
      return prop.seq;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void LoopOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "auto_") {
       prop.auto_ = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.auto_)>>(value);
       return;
    }

    if (name == "collapse") {
       prop.collapse = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.collapse)>>(value);
       return;
    }

    if (name == "hasGang") {
       prop.hasGang = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hasGang)>>(value);
       return;
    }

    if (name == "hasVector") {
       prop.hasVector = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hasVector)>>(value);
       return;
    }

    if (name == "hasWorker") {
       prop.hasWorker = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.hasWorker)>>(value);
       return;
    }

    if (name == "independent") {
       prop.independent = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.independent)>>(value);
       return;
    }

    if (name == "privatizations") {
       prop.privatizations = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.privatizations)>>(value);
       return;
    }

    if (name == "reductionRecipes") {
       prop.reductionRecipes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.reductionRecipes)>>(value);
       return;
    }

    if (name == "seq") {
       prop.seq = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.seq)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void LoopOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.auto_) attrs.append("auto_", prop.auto_);

    if (prop.collapse) attrs.append("collapse", prop.collapse);

    if (prop.hasGang) attrs.append("hasGang", prop.hasGang);

    if (prop.hasVector) attrs.append("hasVector", prop.hasVector);

    if (prop.hasWorker) attrs.append("hasWorker", prop.hasWorker);

    if (prop.independent) attrs.append("independent", prop.independent);

    if (prop.privatizations) attrs.append("privatizations", prop.privatizations);

    if (prop.reductionRecipes) attrs.append("reductionRecipes", prop.reductionRecipes);

    if (prop.seq) attrs.append("seq", prop.seq);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult LoopOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAuto_AttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "auto_", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getCollapseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps6(attr, "collapse", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHasGangAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "hasGang", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHasVectorAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "hasVector", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getHasWorkerAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "hasWorker", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getIndependentAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "independent", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPrivatizationsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "privatizations", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getReductionRecipesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "reductionRecipes", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSeqAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "seq", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult LoopOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.auto_)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.collapse)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.hasGang)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.hasVector)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.hasWorker)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.independent)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.privatizations)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.reductionRecipes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.seq)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void LoopOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.auto_);

  writer.writeOptionalAttribute(prop.collapse);

  writer.writeOptionalAttribute(prop.hasGang);

  writer.writeOptionalAttribute(prop.hasVector);

  writer.writeOptionalAttribute(prop.hasWorker);

  writer.writeOptionalAttribute(prop.independent);

  writer.writeOptionalAttribute(prop.privatizations);

  writer.writeOptionalAttribute(prop.reductionRecipes);

  writer.writeOptionalAttribute(prop.seq);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::IntegerAttr LoopOp::getCollapseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().collapse);
}

::std::optional<uint64_t> LoopOp::getCollapse() {
  auto attr = getCollapseAttr();
  return attr ? ::std::optional<uint64_t>(attr.getValue().getZExtValue()) : (::std::nullopt);
}

::mlir::UnitAttr LoopOp::getSeqAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().seq);
}

bool LoopOp::getSeq() {
  auto attr = getSeqAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOp::getIndependentAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().independent);
}

bool LoopOp::getIndependent() {
  auto attr = getIndependentAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOp::getAuto_Attr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().auto_);
}

bool LoopOp::getAuto_() {
  auto attr = getAuto_Attr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOp::getHasGangAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasGang);
}

bool LoopOp::getHasGang() {
  auto attr = getHasGangAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOp::getHasWorkerAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasWorker);
}

bool LoopOp::getHasWorker() {
  auto attr = getHasWorkerAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr LoopOp::getHasVectorAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().hasVector);
}

bool LoopOp::getHasVector() {
  auto attr = getHasVectorAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr LoopOp::getPrivatizationsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
}

::std::optional< ::mlir::ArrayAttr > LoopOp::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr LoopOp::getReductionRecipesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
}

::std::optional< ::mlir::ArrayAttr > LoopOp::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

void LoopOp::setCollapseAttr(::mlir::IntegerAttr attr) {
  (*this)->setAttr(getCollapseAttrName(), attr);
}

void LoopOp::setCollapse(::std::optional<uint64_t> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getCollapseAttrName(), ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(64), *attrValue));
    (*this)->removeAttr(getCollapseAttrName());
}

void LoopOp::setSeqAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getSeqAttrName(), attr);
}

void LoopOp::setSeq(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getSeqAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getSeqAttrName());
}

void LoopOp::setIndependentAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getIndependentAttrName(), attr);
}

void LoopOp::setIndependent(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getIndependentAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getIndependentAttrName());
}

void LoopOp::setAuto_Attr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAuto_AttrName(), attr);
}

void LoopOp::setAuto_(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAuto_AttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAuto_AttrName());
}

void LoopOp::setHasGangAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getHasGangAttrName(), attr);
}

void LoopOp::setHasGang(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getHasGangAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getHasGangAttrName());
}

void LoopOp::setHasWorkerAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getHasWorkerAttrName(), attr);
}

void LoopOp::setHasWorker(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getHasWorkerAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getHasWorkerAttrName());
}

void LoopOp::setHasVectorAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getHasVectorAttrName(), attr);
}

void LoopOp::setHasVector(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getHasVectorAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getHasVectorAttrName());
}

void LoopOp::setPrivatizationsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getPrivatizationsAttrName(), attr);
}

void LoopOp::setReductionRecipesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getReductionRecipesAttrName(), attr);
}

::mlir::Attribute LoopOp::removeCollapseAttr() {
    auto &attr = getProperties().collapse;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeSeqAttr() {
    auto &attr = getProperties().seq;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeIndependentAttr() {
    auto &attr = getProperties().independent;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeAuto_Attr() {
    auto &attr = getProperties().auto_;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeHasGangAttr() {
    auto &attr = getProperties().hasGang;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeHasWorkerAttr() {
    auto &attr = getProperties().hasWorker;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeHasVectorAttr() {
    auto &attr = getProperties().hasVector;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removePrivatizationsAttr() {
    auto &attr = getProperties().privatizations;
    attr = {};
    return attr;
}

::mlir::Attribute LoopOp::removeReductionRecipesAttr() {
    auto &attr = getProperties().reductionRecipes;
    attr = {};
    return attr;
}

void LoopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, /*optional*/::mlir::IntegerAttr collapse, /*optional*/::mlir::Value gangNum, /*optional*/::mlir::Value gangDim, /*optional*/::mlir::Value gangStatic, /*optional*/::mlir::Value workerNum, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::UnitAttr seq, /*optional*/::mlir::UnitAttr independent, /*optional*/::mlir::UnitAttr auto_, /*optional*/::mlir::UnitAttr hasGang, /*optional*/::mlir::UnitAttr hasWorker, /*optional*/::mlir::UnitAttr hasVector, ::mlir::ValueRange tileOperands, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes) {
  if (gangNum)
    odsState.addOperands(gangNum);
  if (gangDim)
    odsState.addOperands(gangDim);
  if (gangStatic)
    odsState.addOperands(gangStatic);
  if (workerNum)
    odsState.addOperands(workerNum);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  odsState.addOperands(tileOperands);
  odsState.addOperands(privateOperands);
  odsState.addOperands(reductionOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(gangNum ? 1 : 0), (gangDim ? 1 : 0), (gangStatic ? 1 : 0), (workerNum ? 1 : 0), (vectorLength ? 1 : 0), static_cast<int32_t>(tileOperands.size()), static_cast<int32_t>(privateOperands.size()), static_cast<int32_t>(reductionOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (collapse) {
    odsState.getOrAddProperties<Properties>().collapse = collapse;
  }
  if (seq) {
    odsState.getOrAddProperties<Properties>().seq = seq;
  }
  if (independent) {
    odsState.getOrAddProperties<Properties>().independent = independent;
  }
  if (auto_) {
    odsState.getOrAddProperties<Properties>().auto_ = auto_;
  }
  if (hasGang) {
    odsState.getOrAddProperties<Properties>().hasGang = hasGang;
  }
  if (hasWorker) {
    odsState.getOrAddProperties<Properties>().hasWorker = hasWorker;
  }
  if (hasVector) {
    odsState.getOrAddProperties<Properties>().hasVector = hasVector;
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  (void)odsState.addRegion();
  odsState.addTypes(results);
}

void LoopOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange results, /*optional*/::mlir::IntegerAttr collapse, /*optional*/::mlir::Value gangNum, /*optional*/::mlir::Value gangDim, /*optional*/::mlir::Value gangStatic, /*optional*/::mlir::Value workerNum, /*optional*/::mlir::Value vectorLength, /*optional*/bool seq, /*optional*/bool independent, /*optional*/bool auto_, /*optional*/bool hasGang, /*optional*/bool hasWorker, /*optional*/bool hasVector, ::mlir::ValueRange tileOperands, ::mlir::ValueRange privateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes) {
  if (gangNum)
    odsState.addOperands(gangNum);
  if (gangDim)
    odsState.addOperands(gangDim);
  if (gangStatic)
    odsState.addOperands(gangStatic);
  if (workerNum)
    odsState.addOperands(workerNum);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  odsState.addOperands(tileOperands);
  odsState.addOperands(privateOperands);
  odsState.addOperands(reductionOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(gangNum ? 1 : 0), (gangDim ? 1 : 0), (gangStatic ? 1 : 0), (workerNum ? 1 : 0), (vectorLength ? 1 : 0), static_cast<int32_t>(tileOperands.size()), static_cast<int32_t>(privateOperands.size()), static_cast<int32_t>(reductionOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (collapse) {
    odsState.getOrAddProperties<Properties>().collapse = collapse;
  }
  if (seq) {
    odsState.getOrAddProperties<Properties>().seq = ((seq) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (independent) {
    odsState.getOrAddProperties<Properties>().independent = ((independent) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (auto_) {
    odsState.getOrAddProperties<Properties>().auto_ = ((auto_) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (hasGang) {
    odsState.getOrAddProperties<Properties>().hasGang = ((hasGang) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (hasWorker) {
    odsState.getOrAddProperties<Properties>().hasWorker = ((hasWorker) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (hasVector) {
    odsState.getOrAddProperties<Properties>().hasVector = ((hasVector) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  (void)odsState.addRegion();
  odsState.addTypes(results);
}

void LoopOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult LoopOp::verifyInvariantsImpl() {
  auto tblgen_auto_ = getProperties().auto_; (void)tblgen_auto_;
  auto tblgen_collapse = getProperties().collapse; (void)tblgen_collapse;
  auto tblgen_hasGang = getProperties().hasGang; (void)tblgen_hasGang;
  auto tblgen_hasVector = getProperties().hasVector; (void)tblgen_hasVector;
  auto tblgen_hasWorker = getProperties().hasWorker; (void)tblgen_hasWorker;
  auto tblgen_independent = getProperties().independent; (void)tblgen_independent;
  auto tblgen_privatizations = getProperties().privatizations; (void)tblgen_privatizations;
  auto tblgen_reductionRecipes = getProperties().reductionRecipes; (void)tblgen_reductionRecipes;
  auto tblgen_seq = getProperties().seq; (void)tblgen_seq;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps6(*this, tblgen_collapse, "collapse")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_seq, "seq")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_independent, "independent")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_auto_, "auto_")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_hasGang, "hasGang")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_hasWorker, "hasWorker")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_hasVector, "hasVector")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(*this, tblgen_privatizations, "privatizations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(*this, tblgen_reductionRecipes, "reductionRecipes")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    if (valueGroup2.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup2.size();
    }

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps5(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult LoopOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult LoopOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gangNumOperands;
  ::llvm::SMLoc gangNumOperandsLoc;
  (void)gangNumOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gangNumTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gangDimOperands;
  ::llvm::SMLoc gangDimOperandsLoc;
  (void)gangDimOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gangDimTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gangStaticOperands;
  ::llvm::SMLoc gangStaticOperandsLoc;
  (void)gangStaticOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gangStaticTypes;
  ::mlir::UnitAttr hasGangAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> workerNumOperands;
  ::llvm::SMLoc workerNumOperandsLoc;
  (void)workerNumOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> workerNumTypes;
  ::mlir::UnitAttr hasWorkerAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> vectorLengthOperands;
  ::llvm::SMLoc vectorLengthOperandsLoc;
  (void)vectorLengthOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> vectorLengthTypes;
  ::mlir::UnitAttr hasVectorAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> privateOperandsOperands;
  ::llvm::SMLoc privateOperandsOperandsLoc;
  (void)privateOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> privateOperandsTypes;
  ::mlir::ArrayAttr privatizationsAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> tileOperandsOperands;
  ::llvm::SMLoc tileOperandsOperandsLoc;
  (void)tileOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> tileOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> reductionOperandsOperands;
  ::llvm::SMLoc reductionOperandsOperandsLoc;
  (void)reductionOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> reductionOperandsTypes;
  ::mlir::ArrayAttr reductionRecipesAttr;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  ::llvm::SmallVector<::mlir::Type, 1> resultsTypes;
  bool gangClause = false;
  bool workerClause = false;
  bool vectorClause = false;
  bool privateClause = false;
  bool tileClause = false;
  bool reductionClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("gang"))) {

  if (gangClause) {
    return parser.emitError(parser.getNameLoc())
          << "`gang` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  gangClause = true;
  {
    gangNumOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> gangNumOperand;
    ::mlir::Type gangNumType;
    gangDimOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> gangDimOperand;
    ::mlir::Type gangDimType;
    gangStaticOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> gangStaticOperand;
    ::mlir::Type gangStaticType;
    if (parseGangClause(parser, gangNumOperand, gangNumType, gangDimOperand, gangDimType, gangStaticOperand, gangStaticType, hasGangAttr))
      return ::mlir::failure();
    if (gangNumOperand.has_value())
      gangNumOperands.push_back(*gangNumOperand);
    if (gangNumType)
      gangNumTypes.push_back(gangNumType);
    if (gangDimOperand.has_value())
      gangDimOperands.push_back(*gangDimOperand);
    if (gangDimType)
      gangDimTypes.push_back(gangDimType);
    if (gangStaticOperand.has_value())
      gangStaticOperands.push_back(*gangStaticOperand);
    if (gangStaticType)
      gangStaticTypes.push_back(gangStaticType);
    if (hasGangAttr)
      result.getOrAddProperties<LoopOp::Properties>().hasGang = hasGangAttr;
  }
    } else if (succeeded(parser.parseOptionalKeyword("worker"))) {

  if (workerClause) {
    return parser.emitError(parser.getNameLoc())
          << "`worker` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  workerClause = true;
  {
    workerNumOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> workerNumOperand;
    ::mlir::Type workerNumType;
    if (parseWorkerClause(parser, workerNumOperand, workerNumType, hasWorkerAttr))
      return ::mlir::failure();
    if (workerNumOperand.has_value())
      workerNumOperands.push_back(*workerNumOperand);
    if (workerNumType)
      workerNumTypes.push_back(workerNumType);
    if (hasWorkerAttr)
      result.getOrAddProperties<LoopOp::Properties>().hasWorker = hasWorkerAttr;
  }
    } else if (succeeded(parser.parseOptionalKeyword("vector"))) {

  if (vectorClause) {
    return parser.emitError(parser.getNameLoc())
          << "`vector` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  vectorClause = true;
  {
    vectorLengthOperandsLoc = parser.getCurrentLocation();
    ::std::optional<::mlir::OpAsmParser::UnresolvedOperand> vectorLengthOperand;
    ::mlir::Type vectorLengthType;
    if (parseVectorClause(parser, vectorLengthOperand, vectorLengthType, hasVectorAttr))
      return ::mlir::failure();
    if (vectorLengthOperand.has_value())
      vectorLengthOperands.push_back(*vectorLengthOperand);
    if (vectorLengthType)
      vectorLengthTypes.push_back(vectorLengthType);
    if (hasVectorAttr)
      result.getOrAddProperties<LoopOp::Properties>().hasVector = hasVectorAttr;
  }
    } else if (succeeded(parser.parseOptionalKeyword("private"))) {

  if (privateClause) {
    return parser.emitError(parser.getNameLoc())
          << "`private` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  privateClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();
  {
    privateOperandsOperandsLoc = parser.getCurrentLocation();
    if (parseSymOperandList(parser, privateOperandsOperands, privateOperandsTypes, privatizationsAttr))
      return ::mlir::failure();
    if (privatizationsAttr)
      result.getOrAddProperties<LoopOp::Properties>().privatizations = privatizationsAttr;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("tile"))) {

  if (tileClause) {
    return parser.emitError(parser.getNameLoc())
          << "`tile` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  tileClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  tileOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(tileOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(tileOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("reduction"))) {

  if (reductionClause) {
    return parser.emitError(parser.getNameLoc())
          << "`reduction` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  reductionClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();
  {
    reductionOperandsOperandsLoc = parser.getCurrentLocation();
    if (parseSymOperandList(parser, reductionOperandsOperands, reductionOperandsTypes, reductionRecipesAttr))
      return ::mlir::failure();
    if (reductionRecipesAttr)
      result.getOrAddProperties<LoopOp::Properties>().reductionRecipes = reductionRecipesAttr;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalLParen())) {

  if (parser.parseTypeList(resultsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(gangNumOperands.size()), static_cast<int32_t>(gangDimOperands.size()), static_cast<int32_t>(gangStaticOperands.size()), static_cast<int32_t>(workerNumOperands.size()), static_cast<int32_t>(vectorLengthOperands.size()), static_cast<int32_t>(tileOperandsOperands.size()), static_cast<int32_t>(privateOperandsOperands.size()), static_cast<int32_t>(reductionOperandsOperands.size())}), result.getOrAddProperties<LoopOp::Properties>().operandSegmentSizes.begin());
  result.addTypes(resultsTypes);
  if (parser.resolveOperands(gangNumOperands, gangNumTypes, gangNumOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(gangDimOperands, gangDimTypes, gangDimOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(gangStaticOperands, gangStaticTypes, gangStaticOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(workerNumOperands, workerNumTypes, workerNumOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(vectorLengthOperands, vectorLengthTypes, vectorLengthOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(tileOperandsOperands, tileOperandsTypes, tileOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(privateOperandsOperands, privateOperandsTypes, privateOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(reductionOperandsOperands, reductionOperandsTypes, reductionOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void LoopOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getGangNum() || getGangDim() || getGangStatic() || getHasGangAttr()) {
  _odsPrinter << ' ' << "gang";
  printGangClause(_odsPrinter, *this, getGangNum(), (getGangNum() ? getGangNum().getType() : ::mlir::Type()), getGangDim(), (getGangDim() ? getGangDim().getType() : ::mlir::Type()), getGangStatic(), (getGangStatic() ? getGangStatic().getType() : ::mlir::Type()), getHasGangAttr());
  }
  if (false || getWorkerNum() || getHasWorkerAttr()) {
  _odsPrinter << ' ' << "worker";
  printWorkerClause(_odsPrinter, *this, getWorkerNum(), (getWorkerNum() ? getWorkerNum().getType() : ::mlir::Type()), getHasWorkerAttr());
  }
  if (false || getVectorLength() || getHasVectorAttr()) {
  _odsPrinter << ' ' << "vector";
  printVectorClause(_odsPrinter, *this, getVectorLength(), (getVectorLength() ? getVectorLength().getType() : ::mlir::Type()), getHasVectorAttr());
  }
  if (false || getPrivateOperands().size() || getPrivatizationsAttr()) {
  _odsPrinter << ' ' << "private";
  _odsPrinter << "(";
  printSymOperandList(_odsPrinter, *this, getPrivateOperands(), getPrivateOperands().getTypes(), getPrivatizationsAttr());
  _odsPrinter << ")";
  }
  if (false || getTileOperands().size()) {
  _odsPrinter << ' ' << "tile";
  _odsPrinter << "(";
  _odsPrinter << getTileOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getTileOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getReductionOperands().size() || getReductionRecipesAttr()) {
  _odsPrinter << ' ' << "reduction";
  _odsPrinter << "(";
  printSymOperandList(_odsPrinter, *this, getReductionOperands(), getReductionOperands().getTypes(), getReductionRecipesAttr());
  _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  if (!getResults().empty()) {
    _odsPrinter << "(";
    _odsPrinter << getResults().getTypes();
    _odsPrinter << ")";
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("hasGang");
  elidedAttrs.push_back("hasWorker");
  elidedAttrs.push_back("hasVector");
  elidedAttrs.push_back("privatizations");
  elidedAttrs.push_back("reductionRecipes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getSeqAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("seq");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIndependentAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("independent");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAuto_Attr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("auto_");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getHasGangAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("hasGang");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getHasWorkerAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("hasWorker");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getHasVectorAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("hasVector");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::LoopOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::NoCreateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
NoCreateOpGenericAdaptorBase::NoCreateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.nocreate", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> NoCreateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr NoCreateOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr NoCreateOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause NoCreateOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr NoCreateOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool NoCreateOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr NoCreateOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool NoCreateOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr NoCreateOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > NoCreateOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
NoCreateOpAdaptor::NoCreateOpAdaptor(NoCreateOp op) : NoCreateOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult NoCreateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.nocreate' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.nocreate' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.nocreate' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.nocreate' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> NoCreateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range NoCreateOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> NoCreateOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> NoCreateOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range NoCreateOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange NoCreateOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange NoCreateOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange NoCreateOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> NoCreateOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range NoCreateOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> NoCreateOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult NoCreateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute NoCreateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code NoCreateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> NoCreateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void NoCreateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void NoCreateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult NoCreateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult NoCreateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void NoCreateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr NoCreateOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause NoCreateOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr NoCreateOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool NoCreateOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr NoCreateOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool NoCreateOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr NoCreateOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > NoCreateOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void NoCreateOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void NoCreateOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void NoCreateOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void NoCreateOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void NoCreateOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void NoCreateOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void NoCreateOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void NoCreateOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute NoCreateOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void NoCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void NoCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NoCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void NoCreateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void NoCreateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void NoCreateOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_no_create);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult NoCreateOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult NoCreateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult NoCreateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<NoCreateOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void NoCreateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_no_create)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::NoCreateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ParallelOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ParallelOpGenericAdaptorBase::ParallelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.parallel", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ParallelOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr ParallelOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr ParallelOpGenericAdaptorBase::getAsyncAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ParallelOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ParallelOpGenericAdaptorBase::getWaitAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ParallelOpGenericAdaptorBase::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ParallelOpGenericAdaptorBase::getSelfAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool ParallelOpGenericAdaptorBase::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr ParallelOpGenericAdaptorBase::getReductionRecipesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > ParallelOpGenericAdaptorBase::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr ParallelOpGenericAdaptorBase::getPrivatizationsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > ParallelOpGenericAdaptorBase::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr ParallelOpGenericAdaptorBase::getFirstprivatizationsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizations);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > ParallelOpGenericAdaptorBase::getFirstprivatizations() {
  auto attr = getFirstprivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::acc::ClauseDefaultValueAttr ParallelOpGenericAdaptorBase::getDefaultAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  return attr;
}

::std::optional<::mlir::acc::ClauseDefaultValue> ParallelOpGenericAdaptorBase::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

::mlir::Region &ParallelOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange ParallelOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
ParallelOpAdaptor::ParallelOpAdaptor(ParallelOp op) : ParallelOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult ParallelOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_firstprivatizations = getProperties().firstprivatizations; (void)tblgen_firstprivatizations;
  auto tblgen_privatizations = getProperties().privatizations; (void)tblgen_privatizations;
  auto tblgen_reductionRecipes = getProperties().reductionRecipes; (void)tblgen_reductionRecipes;
  auto tblgen_selfAttr = getProperties().selfAttr; (void)tblgen_selfAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (tblgen_asyncAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_asyncAttr))))
    return emitError(loc, "'acc.parallel' op ""attribute 'asyncAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_waitAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_waitAttr))))
    return emitError(loc, "'acc.parallel' op ""attribute 'waitAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_selfAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_selfAttr))))
    return emitError(loc, "'acc.parallel' op ""attribute 'selfAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_reductionRecipes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_reductionRecipes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_reductionRecipes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.parallel' op ""attribute 'reductionRecipes' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_privatizations && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_privatizations))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_privatizations), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.parallel' op ""attribute 'privatizations' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_firstprivatizations && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_firstprivatizations))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_firstprivatizations), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.parallel' op ""attribute 'firstprivatizations' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_defaultAttr && !((::llvm::isa<::mlir::acc::ClauseDefaultValueAttr>(tblgen_defaultAttr))))
    return emitError(loc, "'acc.parallel' op ""attribute 'defaultAttr' failed to satisfy constraint: DefaultValue Clause");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ParallelOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range ParallelOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value ParallelOp::getAsync() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range ParallelOp::getWaitOperands() {
  return getODSOperands(1);
}

::mlir::Operation::operand_range ParallelOp::getNumGangs() {
  return getODSOperands(2);
}

::mlir::Value ParallelOp::getNumWorkers() {
  auto operands = getODSOperands(3);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Value ParallelOp::getVectorLength() {
  auto operands = getODSOperands(4);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> ParallelOp::getIfCond() {
  auto operands = getODSOperands(5);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> ParallelOp::getSelfCond() {
  auto operands = getODSOperands(6);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Operation::operand_range ParallelOp::getReductionOperands() {
  return getODSOperands(7);
}

::mlir::Operation::operand_range ParallelOp::getGangPrivateOperands() {
  return getODSOperands(8);
}

::mlir::Operation::operand_range ParallelOp::getGangFirstPrivateOperands() {
  return getODSOperands(9);
}

::mlir::Operation::operand_range ParallelOp::getDataClauseOperands() {
  return getODSOperands(10);
}

::mlir::MutableOperandRange ParallelOp::getAsyncMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getNumGangsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getNumWorkersMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getVectorLengthMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getSelfCondMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getReductionOperandsMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getGangPrivateOperandsMutable() {
  auto range = getODSOperandIndexAndLength(8);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(8u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getGangFirstPrivateOperandsMutable() {
  auto range = getODSOperandIndexAndLength(9);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(9u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ParallelOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(10);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(10u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> ParallelOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ParallelOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &ParallelOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult ParallelOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.asyncAttr;
       auto attr = dict.get("asyncAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for asyncAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `asyncAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.defaultAttr;
       auto attr = dict.get("defaultAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for defaultAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `defaultAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.firstprivatizations;
       auto attr = dict.get("firstprivatizations");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for firstprivatizations in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `firstprivatizations` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.privatizations;
       auto attr = dict.get("privatizations");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for privatizations in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `privatizations` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.reductionRecipes;
       auto attr = dict.get("reductionRecipes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for reductionRecipes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `reductionRecipes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.selfAttr;
       auto attr = dict.get("selfAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for selfAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `selfAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.waitAttr;
       auto attr = dict.get("waitAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for waitAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `waitAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute ParallelOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.asyncAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("asyncAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.defaultAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("defaultAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.firstprivatizations;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("firstprivatizations",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.privatizations;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("privatizations",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.reductionRecipes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("reductionRecipes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.selfAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("selfAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.waitAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("waitAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ParallelOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.asyncAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.defaultAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.firstprivatizations.getAsOpaquePointer()), 
    llvm::hash_value(prop.privatizations.getAsOpaquePointer()), 
    llvm::hash_value(prop.reductionRecipes.getAsOpaquePointer()), 
    llvm::hash_value(prop.selfAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.waitAttr.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> ParallelOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "asyncAttr")
      return prop.asyncAttr;

    if (name == "defaultAttr")
      return prop.defaultAttr;

    if (name == "firstprivatizations")
      return prop.firstprivatizations;

    if (name == "privatizations")
      return prop.privatizations;

    if (name == "reductionRecipes")
      return prop.reductionRecipes;

    if (name == "selfAttr")
      return prop.selfAttr;

    if (name == "waitAttr")
      return prop.waitAttr;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void ParallelOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "asyncAttr") {
       prop.asyncAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.asyncAttr)>>(value);
       return;
    }

    if (name == "defaultAttr") {
       prop.defaultAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.defaultAttr)>>(value);
       return;
    }

    if (name == "firstprivatizations") {
       prop.firstprivatizations = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.firstprivatizations)>>(value);
       return;
    }

    if (name == "privatizations") {
       prop.privatizations = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.privatizations)>>(value);
       return;
    }

    if (name == "reductionRecipes") {
       prop.reductionRecipes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.reductionRecipes)>>(value);
       return;
    }

    if (name == "selfAttr") {
       prop.selfAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.selfAttr)>>(value);
       return;
    }

    if (name == "waitAttr") {
       prop.waitAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.waitAttr)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void ParallelOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.asyncAttr) attrs.append("asyncAttr", prop.asyncAttr);

    if (prop.defaultAttr) attrs.append("defaultAttr", prop.defaultAttr);

    if (prop.firstprivatizations) attrs.append("firstprivatizations", prop.firstprivatizations);

    if (prop.privatizations) attrs.append("privatizations", prop.privatizations);

    if (prop.reductionRecipes) attrs.append("reductionRecipes", prop.reductionRecipes);

    if (prop.selfAttr) attrs.append("selfAttr", prop.selfAttr);

    if (prop.waitAttr) attrs.append("waitAttr", prop.waitAttr);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult ParallelOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "asyncAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getDefaultAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(attr, "defaultAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getFirstprivatizationsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "firstprivatizations", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPrivatizationsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "privatizations", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getReductionRecipesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "reductionRecipes", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSelfAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "selfAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "waitAttr", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ParallelOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.asyncAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.defaultAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.firstprivatizations)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.privatizations)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.reductionRecipes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.selfAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.waitAttr)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ParallelOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.asyncAttr);

  writer.writeOptionalAttribute(prop.defaultAttr);

  writer.writeOptionalAttribute(prop.firstprivatizations);

  writer.writeOptionalAttribute(prop.privatizations);

  writer.writeOptionalAttribute(prop.reductionRecipes);

  writer.writeOptionalAttribute(prop.selfAttr);

  writer.writeOptionalAttribute(prop.waitAttr);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr ParallelOp::getAsyncAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
}

bool ParallelOp::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ParallelOp::getWaitAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
}

bool ParallelOp::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr ParallelOp::getSelfAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
}

bool ParallelOp::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr ParallelOp::getReductionRecipesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
}

::std::optional< ::mlir::ArrayAttr > ParallelOp::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr ParallelOp::getPrivatizationsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
}

::std::optional< ::mlir::ArrayAttr > ParallelOp::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr ParallelOp::getFirstprivatizationsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizations);
}

::std::optional< ::mlir::ArrayAttr > ParallelOp::getFirstprivatizations() {
  auto attr = getFirstprivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::acc::ClauseDefaultValueAttr ParallelOp::getDefaultAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
}

::std::optional<::mlir::acc::ClauseDefaultValue> ParallelOp::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

void ParallelOp::setAsyncAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrAttrName(), attr);
}

void ParallelOp::setAsyncAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrAttrName());
}

void ParallelOp::setWaitAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrAttrName(), attr);
}

void ParallelOp::setWaitAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrAttrName());
}

void ParallelOp::setSelfAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getSelfAttrAttrName(), attr);
}

void ParallelOp::setSelfAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getSelfAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getSelfAttrAttrName());
}

void ParallelOp::setReductionRecipesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getReductionRecipesAttrName(), attr);
}

void ParallelOp::setPrivatizationsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getPrivatizationsAttrName(), attr);
}

void ParallelOp::setFirstprivatizationsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getFirstprivatizationsAttrName(), attr);
}

void ParallelOp::setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
  (*this)->setAttr(getDefaultAttrAttrName(), attr);
}

void ParallelOp::setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getDefaultAttrAttrName(), ::mlir::acc::ClauseDefaultValueAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue));
    (*this)->removeAttr(getDefaultAttrAttrName());
}

::mlir::Attribute ParallelOp::removeAsyncAttrAttr() {
    auto &attr = getProperties().asyncAttr;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removeWaitAttrAttr() {
    auto &attr = getProperties().waitAttr;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removeSelfAttrAttr() {
    auto &attr = getProperties().selfAttr;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removeReductionRecipesAttr() {
    auto &attr = getProperties().reductionRecipes;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removePrivatizationsAttr() {
    auto &attr = getProperties().privatizations;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removeFirstprivatizationsAttr() {
    auto &attr = getProperties().firstprivatizations;
    attr = {};
    return attr;
}

::mlir::Attribute ParallelOp::removeDefaultAttrAttr() {
    auto &attr = getProperties().defaultAttr;
    attr = {};
    return attr;
}

void ParallelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange gangPrivateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange gangFirstPrivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizations, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(reductionOperands);
  odsState.addOperands(gangPrivateOperands);
  odsState.addOperands(gangFirstPrivateOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(reductionOperands.size()), static_cast<int32_t>(gangPrivateOperands.size()), static_cast<int32_t>(gangFirstPrivateOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = selfAttr;
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (firstprivatizations) {
    odsState.getOrAddProperties<Properties>().firstprivatizations = firstprivatizations;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void ParallelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value async, /*optional*/::mlir::UnitAttr asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/::mlir::UnitAttr waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/::mlir::UnitAttr selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange gangPrivateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange gangFirstPrivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizations, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(reductionOperands);
  odsState.addOperands(gangPrivateOperands);
  odsState.addOperands(gangFirstPrivateOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(reductionOperands.size()), static_cast<int32_t>(gangPrivateOperands.size()), static_cast<int32_t>(gangFirstPrivateOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = asyncAttr;
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = waitAttr;
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = selfAttr;
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (firstprivatizations) {
    odsState.getOrAddProperties<Properties>().firstprivatizations = firstprivatizations;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ParallelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange gangPrivateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange gangFirstPrivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizations, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(reductionOperands);
  odsState.addOperands(gangPrivateOperands);
  odsState.addOperands(gangFirstPrivateOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(reductionOperands.size()), static_cast<int32_t>(gangPrivateOperands.size()), static_cast<int32_t>(gangFirstPrivateOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = ((selfAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (firstprivatizations) {
    odsState.getOrAddProperties<Properties>().firstprivatizations = firstprivatizations;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
}

void ParallelOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, /*optional*/::mlir::Value async, /*optional*/bool asyncAttr, ::mlir::ValueRange waitOperands, /*optional*/bool waitAttr, ::mlir::ValueRange numGangs, /*optional*/::mlir::Value numWorkers, /*optional*/::mlir::Value vectorLength, /*optional*/::mlir::Value ifCond, /*optional*/::mlir::Value selfCond, /*optional*/bool selfAttr, ::mlir::ValueRange reductionOperands, /*optional*/::mlir::ArrayAttr reductionRecipes, ::mlir::ValueRange gangPrivateOperands, /*optional*/::mlir::ArrayAttr privatizations, ::mlir::ValueRange gangFirstPrivateOperands, /*optional*/::mlir::ArrayAttr firstprivatizations, ::mlir::ValueRange dataClauseOperands, /*optional*/::mlir::acc::ClauseDefaultValueAttr defaultAttr) {
  if (async)
    odsState.addOperands(async);
  odsState.addOperands(waitOperands);
  odsState.addOperands(numGangs);
  if (numWorkers)
    odsState.addOperands(numWorkers);
  if (vectorLength)
    odsState.addOperands(vectorLength);
  if (ifCond)
    odsState.addOperands(ifCond);
  if (selfCond)
    odsState.addOperands(selfCond);
  odsState.addOperands(reductionOperands);
  odsState.addOperands(gangPrivateOperands);
  odsState.addOperands(gangFirstPrivateOperands);
  odsState.addOperands(dataClauseOperands);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({(async ? 1 : 0), static_cast<int32_t>(waitOperands.size()), static_cast<int32_t>(numGangs.size()), (numWorkers ? 1 : 0), (vectorLength ? 1 : 0), (ifCond ? 1 : 0), (selfCond ? 1 : 0), static_cast<int32_t>(reductionOperands.size()), static_cast<int32_t>(gangPrivateOperands.size()), static_cast<int32_t>(gangFirstPrivateOperands.size()), static_cast<int32_t>(dataClauseOperands.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (asyncAttr) {
    odsState.getOrAddProperties<Properties>().asyncAttr = ((asyncAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (waitAttr) {
    odsState.getOrAddProperties<Properties>().waitAttr = ((waitAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (selfAttr) {
    odsState.getOrAddProperties<Properties>().selfAttr = ((selfAttr) ? odsBuilder.getUnitAttr() : nullptr);
  }
  if (reductionRecipes) {
    odsState.getOrAddProperties<Properties>().reductionRecipes = reductionRecipes;
  }
  if (privatizations) {
    odsState.getOrAddProperties<Properties>().privatizations = privatizations;
  }
  if (firstprivatizations) {
    odsState.getOrAddProperties<Properties>().firstprivatizations = firstprivatizations;
  }
  if (defaultAttr) {
    odsState.getOrAddProperties<Properties>().defaultAttr = defaultAttr;
  }
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ParallelOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 1; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ParallelOp::verifyInvariantsImpl() {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_firstprivatizations = getProperties().firstprivatizations; (void)tblgen_firstprivatizations;
  auto tblgen_privatizations = getProperties().privatizations; (void)tblgen_privatizations;
  auto tblgen_reductionRecipes = getProperties().reductionRecipes; (void)tblgen_reductionRecipes;
  auto tblgen_selfAttr = getProperties().selfAttr; (void)tblgen_selfAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_asyncAttr, "asyncAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_waitAttr, "waitAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(*this, tblgen_selfAttr, "selfAttr")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(*this, tblgen_reductionRecipes, "reductionRecipes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(*this, tblgen_privatizations, "privatizations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(*this, tblgen_firstprivatizations, "firstprivatizations")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(*this, tblgen_defaultAttr, "defaultAttr")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    if (valueGroup0.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup0.size();
    }

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup3 = getODSOperands(3);

    if (valueGroup3.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup3.size();
    }

    for (auto v : valueGroup3) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup4 = getODSOperands(4);

    if (valueGroup4.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup4.size();
    }

    for (auto v : valueGroup4) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup5 = getODSOperands(5);

    if (valueGroup5.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup5.size();
    }

    for (auto v : valueGroup5) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup6 = getODSOperands(6);

    if (valueGroup6.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup6.size();
    }

    for (auto v : valueGroup6) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup7 = getODSOperands(7);

    for (auto v : valueGroup7) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps5(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup8 = getODSOperands(8);

    for (auto v : valueGroup8) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup9 = getODSOperands(9);

    for (auto v : valueGroup9) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup10 = getODSOperands(10);

    for (auto v : valueGroup10) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "region", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult ParallelOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ParallelOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> dataClauseOperandsOperands;
  ::llvm::SMLoc dataClauseOperandsOperandsLoc;
  (void)dataClauseOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> dataClauseOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> asyncOperands;
  ::llvm::SMLoc asyncOperandsLoc;
  (void)asyncOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> asyncTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gangFirstPrivateOperandsOperands;
  ::llvm::SMLoc gangFirstPrivateOperandsOperandsLoc;
  (void)gangFirstPrivateOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gangFirstPrivateOperandsTypes;
  ::mlir::ArrayAttr firstprivatizationsAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> numGangsOperands;
  ::llvm::SMLoc numGangsOperandsLoc;
  (void)numGangsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> numGangsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> numWorkersOperands;
  ::llvm::SMLoc numWorkersOperandsLoc;
  (void)numWorkersOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> numWorkersTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> gangPrivateOperandsOperands;
  ::llvm::SMLoc gangPrivateOperandsOperandsLoc;
  (void)gangPrivateOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> gangPrivateOperandsTypes;
  ::mlir::ArrayAttr privatizationsAttr;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> vectorLengthOperands;
  ::llvm::SMLoc vectorLengthOperandsLoc;
  (void)vectorLengthOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> vectorLengthTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> waitOperandsOperands;
  ::llvm::SMLoc waitOperandsOperandsLoc;
  (void)waitOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> waitOperandsTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> selfCondOperands;
  ::llvm::SMLoc selfCondOperandsLoc;
  (void)selfCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> ifCondOperands;
  ::llvm::SMLoc ifCondOperandsLoc;
  (void)ifCondOperandsLoc;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> reductionOperandsOperands;
  ::llvm::SMLoc reductionOperandsOperandsLoc;
  (void)reductionOperandsOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> reductionOperandsTypes;
  ::mlir::ArrayAttr reductionRecipesAttr;
  std::unique_ptr<::mlir::Region> regionRegion = std::make_unique<::mlir::Region>();
  bool dataOperandsClause = false;
  bool asyncClause = false;
  bool firstprivateClause = false;
  bool num_gangsClause = false;
  bool num_workersClause = false;
  bool privateClause = false;
  bool vector_lengthClause = false;
  bool waitClause = false;
  bool selfClause = false;
  bool ifClause = false;
  bool reductionClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("dataOperands"))) {

  if (dataOperandsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`dataOperands` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  dataOperandsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  dataClauseOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(dataClauseOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(dataClauseOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("async"))) {

  if (asyncClause) {
    return parser.emitError(parser.getNameLoc())
          << "`async` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  asyncClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    asyncOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      asyncTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("firstprivate"))) {

  if (firstprivateClause) {
    return parser.emitError(parser.getNameLoc())
          << "`firstprivate` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  firstprivateClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();
  {
    gangFirstPrivateOperandsOperandsLoc = parser.getCurrentLocation();
    if (parseSymOperandList(parser, gangFirstPrivateOperandsOperands, gangFirstPrivateOperandsTypes, firstprivatizationsAttr))
      return ::mlir::failure();
    if (firstprivatizationsAttr)
      result.getOrAddProperties<ParallelOp::Properties>().firstprivatizations = firstprivatizationsAttr;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("num_gangs"))) {

  if (num_gangsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`num_gangs` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  num_gangsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  numGangsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(numGangsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(numGangsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("num_workers"))) {

  if (num_workersClause) {
    return parser.emitError(parser.getNameLoc())
          << "`num_workers` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  num_workersClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    numWorkersOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      numWorkersOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      numWorkersTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("private"))) {

  if (privateClause) {
    return parser.emitError(parser.getNameLoc())
          << "`private` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  privateClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();
  {
    gangPrivateOperandsOperandsLoc = parser.getCurrentLocation();
    if (parseSymOperandList(parser, gangPrivateOperandsOperands, gangPrivateOperandsTypes, privatizationsAttr))
      return ::mlir::failure();
    if (privatizationsAttr)
      result.getOrAddProperties<ParallelOp::Properties>().privatizations = privatizationsAttr;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("vector_length"))) {

  if (vector_lengthClause) {
    return parser.emitError(parser.getNameLoc())
          << "`vector_length` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  vector_lengthClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    vectorLengthOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      vectorLengthOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      vectorLengthTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("wait"))) {

  if (waitClause) {
    return parser.emitError(parser.getNameLoc())
          << "`wait` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  waitClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  waitOperandsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(waitOperandsOperands))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseTypeList(waitOperandsTypes))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("self"))) {

  if (selfClause) {
    return parser.emitError(parser.getNameLoc())
          << "`self` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  selfClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    selfCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      selfCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("if"))) {

  if (ifClause) {
    return parser.emitError(parser.getNameLoc())
          << "`if` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  ifClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    ifCondOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      ifCondOperands.push_back(operand);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("reduction"))) {

  if (reductionClause) {
    return parser.emitError(parser.getNameLoc())
          << "`reduction` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  reductionClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();
  {
    reductionOperandsOperandsLoc = parser.getCurrentLocation();
    if (parseSymOperandList(parser, reductionOperandsOperands, reductionOperandsTypes, reductionRecipesAttr))
      return ::mlir::failure();
    if (reductionRecipesAttr)
      result.getOrAddProperties<ParallelOp::Properties>().reductionRecipes = reductionRecipesAttr;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}

  if (parser.parseRegion(*regionRegion))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  result.addRegion(std::move(regionRegion));
::llvm::copy(::llvm::ArrayRef<int32_t>({static_cast<int32_t>(asyncOperands.size()), static_cast<int32_t>(waitOperandsOperands.size()), static_cast<int32_t>(numGangsOperands.size()), static_cast<int32_t>(numWorkersOperands.size()), static_cast<int32_t>(vectorLengthOperands.size()), static_cast<int32_t>(ifCondOperands.size()), static_cast<int32_t>(selfCondOperands.size()), static_cast<int32_t>(reductionOperandsOperands.size()), static_cast<int32_t>(gangPrivateOperandsOperands.size()), static_cast<int32_t>(gangFirstPrivateOperandsOperands.size()), static_cast<int32_t>(dataClauseOperandsOperands.size())}), result.getOrAddProperties<ParallelOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getIntegerType(1);
  if (parser.resolveOperands(asyncOperands, asyncTypes, asyncOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(waitOperandsOperands, waitOperandsTypes, waitOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(numGangsOperands, numGangsTypes, numGangsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(numWorkersOperands, numWorkersTypes, numWorkersOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(vectorLengthOperands, vectorLengthTypes, vectorLengthOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(ifCondOperands, odsBuildableType0, ifCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(selfCondOperands, odsBuildableType0, selfCondOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(reductionOperandsOperands, reductionOperandsTypes, reductionOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(gangPrivateOperandsOperands, gangPrivateOperandsTypes, gangPrivateOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(gangFirstPrivateOperandsOperands, gangFirstPrivateOperandsTypes, gangFirstPrivateOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(dataClauseOperandsOperands, dataClauseOperandsTypes, dataClauseOperandsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ParallelOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << " ";
  if (false || getDataClauseOperands().size()) {
  _odsPrinter << ' ' << "dataOperands";
  _odsPrinter << "(";
  _odsPrinter << getDataClauseOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getDataClauseOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getAsync()) {
  _odsPrinter << ' ' << "async";
  _odsPrinter << "(";
  if (::mlir::Value value = getAsync())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getAsync() ? ::llvm::ArrayRef<::mlir::Type>(getAsync().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getGangFirstPrivateOperands().size() || getFirstprivatizationsAttr()) {
  _odsPrinter << ' ' << "firstprivate";
  _odsPrinter << "(";
  printSymOperandList(_odsPrinter, *this, getGangFirstPrivateOperands(), getGangFirstPrivateOperands().getTypes(), getFirstprivatizationsAttr());
  _odsPrinter << ")";
  }
  if (false || getNumGangs().size()) {
  _odsPrinter << ' ' << "num_gangs";
  _odsPrinter << "(";
  _odsPrinter << getNumGangs();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getNumGangs().getTypes();
  _odsPrinter << ")";
  }
  if (false || getNumWorkers()) {
  _odsPrinter << ' ' << "num_workers";
  _odsPrinter << "(";
  if (::mlir::Value value = getNumWorkers())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getNumWorkers() ? ::llvm::ArrayRef<::mlir::Type>(getNumWorkers().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getGangPrivateOperands().size() || getPrivatizationsAttr()) {
  _odsPrinter << ' ' << "private";
  _odsPrinter << "(";
  printSymOperandList(_odsPrinter, *this, getGangPrivateOperands(), getGangPrivateOperands().getTypes(), getPrivatizationsAttr());
  _odsPrinter << ")";
  }
  if (false || getVectorLength()) {
  _odsPrinter << ' ' << "vector_length";
  _odsPrinter << "(";
  if (::mlir::Value value = getVectorLength())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVectorLength() ? ::llvm::ArrayRef<::mlir::Type>(getVectorLength().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getWaitOperands().size()) {
  _odsPrinter << ' ' << "wait";
  _odsPrinter << "(";
  _odsPrinter << getWaitOperands();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << getWaitOperands().getTypes();
  _odsPrinter << ")";
  }
  if (false || getSelfCond()) {
  _odsPrinter << ' ' << "self";
  _odsPrinter << "(";
  if (::mlir::Value value = getSelfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getIfCond()) {
  _odsPrinter << ' ' << "if";
  _odsPrinter << "(";
  if (::mlir::Value value = getIfCond())
    _odsPrinter << value;
  _odsPrinter << ")";
  }
  if (false || getReductionOperands().size() || getReductionRecipesAttr()) {
  _odsPrinter << ' ' << "reduction";
  _odsPrinter << "(";
  printSymOperandList(_odsPrinter, *this, getReductionOperands(), getReductionOperands().getTypes(), getReductionRecipesAttr());
  _odsPrinter << ")";
  }
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getRegion());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  elidedAttrs.push_back("firstprivatizations");
  elidedAttrs.push_back("privatizations");
  elidedAttrs.push_back("reductionRecipes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getAsyncAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("asyncAttr");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getWaitAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("waitAttr");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getSelfAttrAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("selfAttr");
  }
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::ParallelOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PresentOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PresentOpGenericAdaptorBase::PresentOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.present", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> PresentOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr PresentOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr PresentOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause PresentOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr PresentOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool PresentOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr PresentOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool PresentOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr PresentOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > PresentOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
PresentOpAdaptor::PresentOpAdaptor(PresentOp op) : PresentOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult PresentOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.present' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.present' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.present' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.present' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PresentOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range PresentOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PresentOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PresentOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range PresentOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange PresentOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange PresentOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange PresentOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> PresentOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PresentOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PresentOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult PresentOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute PresentOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PresentOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> PresentOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void PresentOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void PresentOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult PresentOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult PresentOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void PresentOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr PresentOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause PresentOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr PresentOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool PresentOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr PresentOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool PresentOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr PresentOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > PresentOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void PresentOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void PresentOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void PresentOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void PresentOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void PresentOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void PresentOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void PresentOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void PresentOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute PresentOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void PresentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void PresentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PresentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void PresentOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PresentOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void PresentOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_present);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult PresentOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult PresentOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult PresentOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<PresentOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void PresentOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_present)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::PresentOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PrivateOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrivateOpGenericAdaptorBase::PrivateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.private", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> PrivateOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr PrivateOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr PrivateOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause PrivateOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr PrivateOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool PrivateOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr PrivateOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool PrivateOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr PrivateOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > PrivateOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
PrivateOpAdaptor::PrivateOpAdaptor(PrivateOp op) : PrivateOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult PrivateOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.private' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.private' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.private' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.private' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PrivateOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range PrivateOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PrivateOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PrivateOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range PrivateOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange PrivateOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange PrivateOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange PrivateOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> PrivateOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PrivateOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> PrivateOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult PrivateOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute PrivateOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PrivateOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> PrivateOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void PrivateOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void PrivateOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult PrivateOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult PrivateOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void PrivateOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr PrivateOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause PrivateOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr PrivateOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool PrivateOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr PrivateOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool PrivateOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr PrivateOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > PrivateOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void PrivateOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void PrivateOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void PrivateOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void PrivateOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void PrivateOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void PrivateOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void PrivateOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void PrivateOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute PrivateOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void PrivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void PrivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void PrivateOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrivateOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void PrivateOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_private);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult PrivateOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult PrivateOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult PrivateOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<PrivateOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void PrivateOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_private)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::PrivateOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::PrivateRecipeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
PrivateRecipeOpGenericAdaptorBase::PrivateRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.private.recipe", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> PrivateRecipeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr PrivateRecipeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr PrivateRecipeOpGenericAdaptorBase::getSymNameAttr() {
  auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  return attr;
}

::llvm::StringRef PrivateRecipeOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr PrivateRecipeOpGenericAdaptorBase::getTypeAttr() {
  auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  return attr;
}

::mlir::Type PrivateRecipeOpGenericAdaptorBase::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::Region &PrivateRecipeOpGenericAdaptorBase::getInitRegion() {
  return *odsRegions[0];
}

::mlir::Region &PrivateRecipeOpGenericAdaptorBase::getDestroyRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange PrivateRecipeOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
PrivateRecipeOpAdaptor::PrivateRecipeOpAdaptor(PrivateRecipeOp op) : PrivateRecipeOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult PrivateRecipeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitError(loc, "'acc.private.recipe' op ""requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitError(loc, "'acc.private.recipe' op ""requires attribute 'type'");

  if (tblgen_sym_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_sym_name))))
    return emitError(loc, "'acc.private.recipe' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");

  if (tblgen_type && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_type))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_type).getValue()))) && ((true))))
    return emitError(loc, "'acc.private.recipe' op ""attribute 'type' failed to satisfy constraint: any type attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> PrivateRecipeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range PrivateRecipeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> PrivateRecipeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range PrivateRecipeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &PrivateRecipeOp::getInitRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &PrivateRecipeOp::getDestroyRegion() {
  return (*this)->getRegion(1);
}

::mlir::LogicalResult PrivateRecipeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.sym_name;
       auto attr = dict.get("sym_name");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for sym_name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `sym_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.type;
       auto attr = dict.get("type");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for type in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute PrivateRecipeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.sym_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("sym_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("type",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code PrivateRecipeOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.sym_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.type.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> PrivateRecipeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "sym_name")
      return prop.sym_name;

    if (name == "type")
      return prop.type;
  return std::nullopt;
}

void PrivateRecipeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "sym_name") {
       prop.sym_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.sym_name)>>(value);
       return;
    }

    if (name == "type") {
       prop.type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.type)>>(value);
       return;
    }
}

void PrivateRecipeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.sym_name) attrs.append("sym_name", prop.sym_name);

    if (prop.type) attrs.append("type", prop.type);
}

::mlir::LogicalResult PrivateRecipeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getSymNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "sym_name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(attr, "type", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult PrivateRecipeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.sym_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.type)))
    return ::mlir::failure();
  return ::mlir::success();
}

void PrivateRecipeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.sym_name);
  writer.writeAttribute(prop.type);
}

::mlir::StringAttr PrivateRecipeOp::getSymNameAttr() {
  return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
}

::llvm::StringRef PrivateRecipeOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr PrivateRecipeOp::getTypeAttr() {
  return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
}

::mlir::Type PrivateRecipeOp::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

void PrivateRecipeOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void PrivateRecipeOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void PrivateRecipeOp::setTypeAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTypeAttrName(), attr);
}

void PrivateRecipeOp::setType(::mlir::Type attrValue) {
  (*this)->setAttr(getTypeAttrName(), ::mlir::TypeAttr::get(attrValue));
}

void PrivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void PrivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void PrivateRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void PrivateRecipeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult PrivateRecipeOp::verifyInvariantsImpl() {
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitOpError("requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitOpError("requires attribute 'type'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(*this, tblgen_type, "type")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "initRegion", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "destroyRegion", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult PrivateRecipeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult PrivateRecipeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr sym_nameAttr;
  ::mlir::TypeAttr typeAttr;
  std::unique_ptr<::mlir::Region> initRegionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> destroyRegionRegion = std::make_unique<::mlir::Region>();

  if (parser.parseSymbolName(sym_nameAttr))
    return ::mlir::failure();
  if (sym_nameAttr) result.getOrAddProperties<PrivateRecipeOp::Properties>().sym_name = sym_nameAttr;
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(typeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (typeAttr) result.getOrAddProperties<PrivateRecipeOp::Properties>().type = typeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseKeyword("init"))
    return ::mlir::failure();

  if (parser.parseRegion(*initRegionRegion))
    return ::mlir::failure();
  if (::mlir::succeeded(parser.parseOptionalKeyword("destroy"))) {

  if (parser.parseRegion(*destroyRegionRegion))
    return ::mlir::failure();
  }
  result.addRegion(std::move(initRegionRegion));
  result.addRegion(std::move(destroyRegionRegion));
  return ::mlir::success();
}

void PrivateRecipeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printSymbolName(getSymNameAttr().getValue());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getTypeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("sym_name");
  elidedAttrs.push_back("type");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "init";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getInitRegion());
  if (!getDestroyRegion().empty()) {
    _odsPrinter << ' ' << "destroy";
    _odsPrinter << ' ';
    _odsPrinter.printRegion(getDestroyRegion());
  }
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::PrivateRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ReductionOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReductionOpGenericAdaptorBase::ReductionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.reduction", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ReductionOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr ReductionOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::acc::DataClauseAttr ReductionOpGenericAdaptorBase::getDataClauseAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
  return attr;
}

::mlir::acc::DataClause ReductionOpGenericAdaptorBase::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr ReductionOpGenericAdaptorBase::getStructuredAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
  return attr;
}

bool ReductionOpGenericAdaptorBase::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr ReductionOpGenericAdaptorBase::getImplicitAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
  return attr;
}

bool ReductionOpGenericAdaptorBase::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr ReductionOpGenericAdaptorBase::getNameAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  return attr;
}

::std::optional< ::llvm::StringRef > ReductionOpGenericAdaptorBase::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

} // namespace detail
ReductionOpAdaptor::ReductionOpAdaptor(ReductionOp op) : ReductionOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult ReductionOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (tblgen_dataClause && !((::llvm::isa<::mlir::acc::DataClauseAttr>(tblgen_dataClause))))
    return emitError(loc, "'acc.reduction' op ""attribute 'dataClause' failed to satisfy constraint: data clauses supported by OpenACC");

  if (tblgen_structured && !((::llvm::isa<::mlir::BoolAttr>(tblgen_structured))))
    return emitError(loc, "'acc.reduction' op ""attribute 'structured' failed to satisfy constraint: bool attribute");

  if (tblgen_implicit && !((::llvm::isa<::mlir::BoolAttr>(tblgen_implicit))))
    return emitError(loc, "'acc.reduction' op ""attribute 'implicit' failed to satisfy constraint: bool attribute");

  if (tblgen_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_name))))
    return emitError(loc, "'acc.reduction' op ""attribute 'name' failed to satisfy constraint: string attribute");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ReductionOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range ReductionOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> ReductionOp::getVarPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSOperands(0).begin());
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> ReductionOp::getVarPtrPtr() {
  auto operands = getODSOperands(1);
  return operands.empty() ? ::mlir::TypedValue<::mlir::acc::PointerLikeType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*operands.begin());
}

::mlir::Operation::operand_range ReductionOp::getBounds() {
  return getODSOperands(2);
}

::mlir::MutableOperandRange ReductionOp::getVarPtrMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ReductionOp::getVarPtrPtrMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange ReductionOp::getBoundsMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> ReductionOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ReductionOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::TypedValue<::mlir::acc::PointerLikeType> ReductionOp::getAccPtr() {
  return ::llvm::cast<::mlir::TypedValue<::mlir::acc::PointerLikeType>>(*getODSResults(0).begin());
}

::mlir::LogicalResult ReductionOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.dataClause;
       auto attr = dict.get("dataClause");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for dataClause in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `dataClause` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.implicit;
       auto attr = dict.get("implicit");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for implicit in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `implicit` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.name;
       auto attr = dict.get("name");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.structured;
       auto attr = dict.get("structured");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for structured in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `structured` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute ReductionOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.dataClause;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("dataClause",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.implicit;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("implicit",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.structured;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("structured",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ReductionOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.dataClause.getAsOpaquePointer()), 
    llvm::hash_value(prop.implicit.getAsOpaquePointer()), 
    llvm::hash_value(prop.name.getAsOpaquePointer()), 
    llvm::hash_value(prop.structured.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> ReductionOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "dataClause")
      return prop.dataClause;

    if (name == "implicit")
      return prop.implicit;

    if (name == "name")
      return prop.name;

    if (name == "structured")
      return prop.structured;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void ReductionOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "dataClause") {
       prop.dataClause = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.dataClause)>>(value);
       return;
    }

    if (name == "implicit") {
       prop.implicit = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.implicit)>>(value);
       return;
    }

    if (name == "name") {
       prop.name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.name)>>(value);
       return;
    }

    if (name == "structured") {
       prop.structured = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.structured)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void ReductionOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.dataClause) attrs.append("dataClause", prop.dataClause);

    if (prop.implicit) attrs.append("implicit", prop.implicit);

    if (prop.name) attrs.append("name", prop.name);

    if (prop.structured) attrs.append("structured", prop.structured);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult ReductionOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getDataClauseAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(attr, "dataClause", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getImplicitAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "implicit", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getStructuredAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(attr, "structured", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ReductionOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.dataClause)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.implicit)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.structured)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void ReductionOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.dataClause);

  writer.writeOptionalAttribute(prop.implicit);

  writer.writeOptionalAttribute(prop.name);

  writer.writeOptionalAttribute(prop.structured);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::acc::DataClauseAttr ReductionOp::getDataClauseAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::DataClauseAttr>(getProperties().dataClause);
}

::mlir::acc::DataClause ReductionOp::getDataClause() {
  auto attr = getDataClauseAttr();
  return attr.getValue();
}

::mlir::BoolAttr ReductionOp::getStructuredAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().structured);
}

bool ReductionOp::getStructured() {
  auto attr = getStructuredAttr();
  return attr.getValue();
}

::mlir::BoolAttr ReductionOp::getImplicitAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().implicit);
}

bool ReductionOp::getImplicit() {
  auto attr = getImplicitAttr();
  return attr.getValue();
}

::mlir::StringAttr ReductionOp::getNameAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
}

::std::optional< ::llvm::StringRef > ReductionOp::getName() {
  auto attr = getNameAttr();
  return attr ? ::std::optional< ::llvm::StringRef >(attr.getValue()) : (::std::nullopt);
}

void ReductionOp::setDataClauseAttr(::mlir::acc::DataClauseAttr attr) {
  (*this)->setAttr(getDataClauseAttrName(), attr);
}

void ReductionOp::setDataClause(::mlir::acc::DataClause attrValue) {
  (*this)->setAttr(getDataClauseAttrName(), ::mlir::acc::DataClauseAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void ReductionOp::setStructuredAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getStructuredAttrName(), attr);
}

void ReductionOp::setStructured(bool attrValue) {
  (*this)->setAttr(getStructuredAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void ReductionOp::setImplicitAttr(::mlir::BoolAttr attr) {
  (*this)->setAttr(getImplicitAttrName(), attr);
}

void ReductionOp::setImplicit(bool attrValue) {
  (*this)->setAttr(getImplicitAttrName(), ::mlir::Builder((*this)->getContext()).getBoolAttr(attrValue));
}

void ReductionOp::setNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getNameAttrName(), attr);
}

void ReductionOp::setName(::std::optional<::llvm::StringRef> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(*attrValue));
    (*this)->removeAttr(getNameAttrName());
}

::mlir::Attribute ReductionOp::removeNameAttr() {
    auto &attr = getProperties().name;
    attr = {};
    return attr;
}

void ReductionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void ReductionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClauseAttr dataClause, ::mlir::BoolAttr structured, ::mlir::BoolAttr implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  if (dataClause) {
    odsState.getOrAddProperties<Properties>().dataClause = dataClause;
  }
  if (structured) {
    odsState.getOrAddProperties<Properties>().structured = structured;
  }
  if (implicit) {
    odsState.getOrAddProperties<Properties>().implicit = implicit;
  }
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReductionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type accPtr, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  odsState.addTypes(accPtr);
}

void ReductionOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value varPtr, /*optional*/::mlir::Value varPtrPtr, ::mlir::ValueRange bounds, ::mlir::acc::DataClause dataClause, bool structured, bool implicit, /*optional*/::mlir::StringAttr name) {
  odsState.addOperands(varPtr);
  if (varPtrPtr)
    odsState.addOperands(varPtrPtr);
  odsState.addOperands(bounds);
  ::llvm::copy(::llvm::ArrayRef<int32_t>({1, (varPtrPtr ? 1 : 0), static_cast<int32_t>(bounds.size())}), odsState.getOrAddProperties<Properties>().operandSegmentSizes.begin());
  odsState.getOrAddProperties<Properties>().dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), dataClause);
  odsState.getOrAddProperties<Properties>().structured = odsBuilder.getBoolAttr(structured);
  odsState.getOrAddProperties<Properties>().implicit = odsBuilder.getBoolAttr(implicit);
  if (name) {
    odsState.getOrAddProperties<Properties>().name = name;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReductionOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() >= 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

void ReductionOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.dataClause)
    properties.dataClause = ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_reduction);
  if (!properties.structured)
    properties.structured = odsBuilder.getBoolAttr(true);
  if (!properties.implicit)
    properties.implicit = odsBuilder.getBoolAttr(false);
}

::mlir::LogicalResult ReductionOp::verifyInvariantsImpl() {
  auto tblgen_dataClause = getProperties().dataClause; (void)tblgen_dataClause;
  auto tblgen_implicit = getProperties().implicit; (void)tblgen_implicit;
  auto tblgen_name = getProperties().name; (void)tblgen_name;
  auto tblgen_structured = getProperties().structured; (void)tblgen_structured;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps0(*this, tblgen_dataClause, "dataClause")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_structured, "structured")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps1(*this, tblgen_implicit, "implicit")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_name, "name")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    if (valueGroup1.size() > 1) {
      return emitOpError("operand group starting at #") << index
          << " requires 0 or 1 element, but found " << valueGroup1.size();
    }

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup2 = getODSOperands(2);

    for (auto v : valueGroup2) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_OpenACCOps0(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::mlir::LogicalResult ReductionOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult ReductionOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand varPtrRawOperands[1];
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> varPtrOperands(varPtrRawOperands);  ::llvm::SMLoc varPtrOperandsLoc;
  (void)varPtrOperandsLoc;
  ::mlir::Type varPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> varPtrTypes(varPtrRawTypes);
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> varPtrPtrOperands;
  ::llvm::SMLoc varPtrPtrOperandsLoc;
  (void)varPtrPtrOperandsLoc;
  ::llvm::SmallVector<::mlir::Type, 1> varPtrPtrTypes;
  ::llvm::SmallVector<::mlir::OpAsmParser::UnresolvedOperand, 4> boundsOperands;
  ::llvm::SMLoc boundsOperandsLoc;
  (void)boundsOperandsLoc;
  ::mlir::Type accPtrRawTypes[1];
  ::llvm::ArrayRef<::mlir::Type> accPtrTypes(accPtrRawTypes);
  if (parser.parseKeyword("varPtr"))
    return ::mlir::failure();
  if (parser.parseLParen())
    return ::mlir::failure();

  varPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(varPtrRawOperands[0]))
    return ::mlir::failure();
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    varPtrRawTypes[0] = type;
  }
  if (parser.parseRParen())
    return ::mlir::failure();
  bool varPtrPtrClause = false;
  bool boundsClause = false;
  while(true) {
if (succeeded(parser.parseOptionalKeyword("varPtrPtr"))) {

  if (varPtrPtrClause) {
    return parser.emitError(parser.getNameLoc())
          << "`varPtrPtr` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  varPtrPtrClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  {
    varPtrPtrOperandsLoc = parser.getCurrentLocation();
    ::mlir::OpAsmParser::UnresolvedOperand operand;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalOperand(operand);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrOperands.push_back(operand);
    }
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type optionalType;
    ::mlir::OptionalParseResult parseResult =
                                    parser.parseOptionalType(optionalType);
    if (parseResult.has_value()) {
      if (failed(*parseResult))
        return ::mlir::failure();
      varPtrPtrTypes.push_back(optionalType);
    }
  }
  if (parser.parseRParen())
    return ::mlir::failure();
    } else if (succeeded(parser.parseOptionalKeyword("bounds"))) {

  if (boundsClause) {
    return parser.emitError(parser.getNameLoc())
          << "`bounds` clause can appear at most once in the expansion of the "
             "oilist directive";
  }
  boundsClause = true;
  if (parser.parseLParen())
    return ::mlir::failure();

  boundsOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperandList(boundsOperands))
    return ::mlir::failure();
  if (parser.parseRParen())
    return ::mlir::failure();
    } else  {
    break;
  }
}
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::acc::PointerLikeType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    accPtrRawTypes[0] = type;
  }
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
::llvm::copy(::llvm::ArrayRef<int32_t>({1, static_cast<int32_t>(varPtrPtrOperands.size()), static_cast<int32_t>(boundsOperands.size())}), result.getOrAddProperties<ReductionOp::Properties>().operandSegmentSizes.begin());
  ::mlir::Type odsBuildableType0 = parser.getBuilder().getType<::mlir::acc::DataBoundsType>();
  result.addTypes(accPtrTypes);
  if (parser.resolveOperands(varPtrOperands, varPtrTypes, varPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(varPtrPtrOperands, varPtrPtrTypes, varPtrPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(boundsOperands, odsBuildableType0, boundsOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReductionOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ' << "varPtr";
  _odsPrinter << "(";
  _odsPrinter << getVarPtr();
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getVarPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  _odsPrinter << ")";
  _odsPrinter << ' ' << " ";
  if (false || getVarPtrPtr()) {
  _odsPrinter << ' ' << "varPtrPtr";
  _odsPrinter << "(";
  if (::mlir::Value value = getVarPtrPtr())
    _odsPrinter << value;
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter << (getVarPtrPtr() ? ::llvm::ArrayRef<::mlir::Type>(getVarPtrPtr().getType()) : ::llvm::ArrayRef<::mlir::Type>());
  _odsPrinter << ")";
  }
  if (false || getBounds().size()) {
  _odsPrinter << ' ' << "bounds";
  _odsPrinter << "(";
  _odsPrinter << getBounds();
  _odsPrinter << ")";
  }
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getAccPtr().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::acc::PointerLikeType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("operandSegmentSizes");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getDataClauseAttr();
     if(attr && (attr == ::mlir::acc::DataClauseAttr::get(odsBuilder.getContext(), mlir::acc::DataClause::acc_reduction)))
       elidedAttrs.push_back("dataClause");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getStructuredAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(true)))
       elidedAttrs.push_back("structured");
  }
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getImplicitAttr();
     if(attr && (attr == odsBuilder.getBoolAttr(false)))
       elidedAttrs.push_back("implicit");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::ReductionOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::ReductionRecipeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReductionRecipeOpGenericAdaptorBase::ReductionRecipeOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.reduction.recipe", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> ReductionRecipeOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  return {index, 1};
}

::mlir::DictionaryAttr ReductionRecipeOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::StringAttr ReductionRecipeOpGenericAdaptorBase::getSymNameAttr() {
  auto attr = ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
  return attr;
}

::llvm::StringRef ReductionRecipeOpGenericAdaptorBase::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr ReductionRecipeOpGenericAdaptorBase::getTypeAttr() {
  auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
  return attr;
}

::mlir::Type ReductionRecipeOpGenericAdaptorBase::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::acc::ReductionOperatorAttr ReductionRecipeOpGenericAdaptorBase::getReductionOperatorAttr() {
  auto attr = ::llvm::cast<::mlir::acc::ReductionOperatorAttr>(getProperties().reductionOperator);
  return attr;
}

::mlir::acc::ReductionOperator ReductionRecipeOpGenericAdaptorBase::getReductionOperator() {
  auto attr = getReductionOperatorAttr();
  return attr.getValue();
}

::mlir::Region &ReductionRecipeOpGenericAdaptorBase::getInitRegion() {
  return *odsRegions[0];
}

::mlir::Region &ReductionRecipeOpGenericAdaptorBase::getCombinerRegion() {
  return *odsRegions[1];
}

::mlir::RegionRange ReductionRecipeOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
ReductionRecipeOpAdaptor::ReductionRecipeOpAdaptor(ReductionRecipeOp op) : ReductionRecipeOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult ReductionRecipeOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_reductionOperator = getProperties().reductionOperator; (void)tblgen_reductionOperator;
  if (!tblgen_reductionOperator) return emitError(loc, "'acc.reduction.recipe' op ""requires attribute 'reductionOperator'");
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitError(loc, "'acc.reduction.recipe' op ""requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitError(loc, "'acc.reduction.recipe' op ""requires attribute 'type'");

  if (tblgen_sym_name && !((::llvm::isa<::mlir::StringAttr>(tblgen_sym_name))))
    return emitError(loc, "'acc.reduction.recipe' op ""attribute 'sym_name' failed to satisfy constraint: string attribute");

  if (tblgen_type && !(((::llvm::isa<::mlir::TypeAttr>(tblgen_type))) && ((::llvm::isa<::mlir::Type>(::llvm::cast<::mlir::TypeAttr>(tblgen_type).getValue()))) && ((true))))
    return emitError(loc, "'acc.reduction.recipe' op ""attribute 'type' failed to satisfy constraint: any type attribute");

  if (tblgen_reductionOperator && !((::llvm::isa<::mlir::acc::ReductionOperatorAttr>(tblgen_reductionOperator))))
    return emitError(loc, "'acc.reduction.recipe' op ""attribute 'reductionOperator' failed to satisfy constraint: built-in reduction operations supported by OpenACC");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> ReductionRecipeOp::getODSOperandIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::operand_range ReductionRecipeOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

std::pair<unsigned, unsigned> ReductionRecipeOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range ReductionRecipeOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &ReductionRecipeOp::getInitRegion() {
  return (*this)->getRegion(0);
}

::mlir::Region &ReductionRecipeOp::getCombinerRegion() {
  return (*this)->getRegion(1);
}

::mlir::LogicalResult ReductionRecipeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.reductionOperator;
       auto attr = dict.get("reductionOperator");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for reductionOperator in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `reductionOperator` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.sym_name;
       auto attr = dict.get("sym_name");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for sym_name in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `sym_name` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.type;
       auto attr = dict.get("type");
    if (attr || /*isRequired=*/true) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for type in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `type` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ReductionRecipeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.reductionOperator;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("reductionOperator",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.sym_name;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("sym_name",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.type;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("type",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ReductionRecipeOp::computePropertiesHash(const Properties &prop) {
  return llvm::hash_combine(
    llvm::hash_value(prop.reductionOperator.getAsOpaquePointer()), 
    llvm::hash_value(prop.sym_name.getAsOpaquePointer()), 
    llvm::hash_value(prop.type.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ReductionRecipeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "reductionOperator")
      return prop.reductionOperator;

    if (name == "sym_name")
      return prop.sym_name;

    if (name == "type")
      return prop.type;
  return std::nullopt;
}

void ReductionRecipeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "reductionOperator") {
       prop.reductionOperator = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.reductionOperator)>>(value);
       return;
    }

    if (name == "sym_name") {
       prop.sym_name = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.sym_name)>>(value);
       return;
    }

    if (name == "type") {
       prop.type = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.type)>>(value);
       return;
    }
}

void ReductionRecipeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.reductionOperator) attrs.append("reductionOperator", prop.reductionOperator);

    if (prop.sym_name) attrs.append("sym_name", prop.sym_name);

    if (prop.type) attrs.append("type", prop.type);
}

::mlir::LogicalResult ReductionRecipeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getReductionOperatorAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps8(attr, "reductionOperator", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSymNameAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(attr, "sym_name", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getTypeAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(attr, "type", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult ReductionRecipeOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.reductionOperator)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.sym_name)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.type)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReductionRecipeOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.reductionOperator);
  writer.writeAttribute(prop.sym_name);
  writer.writeAttribute(prop.type);
}

::mlir::StringAttr ReductionRecipeOp::getSymNameAttr() {
  return ::llvm::cast<::mlir::StringAttr>(getProperties().sym_name);
}

::llvm::StringRef ReductionRecipeOp::getSymName() {
  auto attr = getSymNameAttr();
  return attr.getValue();
}

::mlir::TypeAttr ReductionRecipeOp::getTypeAttr() {
  return ::llvm::cast<::mlir::TypeAttr>(getProperties().type);
}

::mlir::Type ReductionRecipeOp::getType() {
  auto attr = getTypeAttr();
  return ::llvm::cast<::mlir::Type>(attr.getValue());
}

::mlir::acc::ReductionOperatorAttr ReductionRecipeOp::getReductionOperatorAttr() {
  return ::llvm::cast<::mlir::acc::ReductionOperatorAttr>(getProperties().reductionOperator);
}

::mlir::acc::ReductionOperator ReductionRecipeOp::getReductionOperator() {
  auto attr = getReductionOperatorAttr();
  return attr.getValue();
}

void ReductionRecipeOp::setSymNameAttr(::mlir::StringAttr attr) {
  (*this)->setAttr(getSymNameAttrName(), attr);
}

void ReductionRecipeOp::setSymName(::llvm::StringRef attrValue) {
  (*this)->setAttr(getSymNameAttrName(), ::mlir::Builder((*this)->getContext()).getStringAttr(attrValue));
}

void ReductionRecipeOp::setTypeAttr(::mlir::TypeAttr attr) {
  (*this)->setAttr(getTypeAttrName(), attr);
}

void ReductionRecipeOp::setType(::mlir::Type attrValue) {
  (*this)->setAttr(getTypeAttrName(), ::mlir::TypeAttr::get(attrValue));
}

void ReductionRecipeOp::setReductionOperatorAttr(::mlir::acc::ReductionOperatorAttr attr) {
  (*this)->setAttr(getReductionOperatorAttrName(), attr);
}

void ReductionRecipeOp::setReductionOperator(::mlir::acc::ReductionOperator attrValue) {
  (*this)->setAttr(getReductionOperatorAttrName(), ::mlir::acc::ReductionOperatorAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue));
}

void ReductionRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  odsState.getOrAddProperties<Properties>().reductionOperator = reductionOperator;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void ReductionRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr sym_name, ::mlir::TypeAttr type, ::mlir::acc::ReductionOperatorAttr reductionOperator) {
  odsState.getOrAddProperties<Properties>().sym_name = sym_name;
  odsState.getOrAddProperties<Properties>().type = type;
  odsState.getOrAddProperties<Properties>().reductionOperator = reductionOperator;
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReductionRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  odsState.getOrAddProperties<Properties>().reductionOperator = ::mlir::acc::ReductionOperatorAttr::get(odsBuilder.getContext(), reductionOperator);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
}

void ReductionRecipeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef sym_name, ::mlir::Type type, ::mlir::acc::ReductionOperator reductionOperator) {
  odsState.getOrAddProperties<Properties>().sym_name = odsBuilder.getStringAttr(sym_name);
  odsState.getOrAddProperties<Properties>().type = ::mlir::TypeAttr::get(type);
  odsState.getOrAddProperties<Properties>().reductionOperator = ::mlir::acc::ReductionOperatorAttr::get(odsBuilder.getContext(), reductionOperator);
  (void)odsState.addRegion();
  (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

void ReductionRecipeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  for (unsigned i = 0; i != 2; ++i)
    (void)odsState.addRegion();
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

::mlir::LogicalResult ReductionRecipeOp::verifyInvariantsImpl() {
  auto tblgen_reductionOperator = getProperties().reductionOperator; (void)tblgen_reductionOperator;
  if (!tblgen_reductionOperator) return emitOpError("requires attribute 'reductionOperator'");
  auto tblgen_sym_name = getProperties().sym_name; (void)tblgen_sym_name;
  if (!tblgen_sym_name) return emitOpError("requires attribute 'sym_name'");
  auto tblgen_type = getProperties().type; (void)tblgen_type;
  if (!tblgen_type) return emitOpError("requires attribute 'type'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps2(*this, tblgen_sym_name, "sym_name")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps5(*this, tblgen_type, "type")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps8(*this, tblgen_reductionOperator, "reductionOperator")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(0)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "initRegion", index++)))
        return ::mlir::failure();

    for (auto &region : ::llvm::MutableArrayRef((*this)->getRegion(1)))
      if (::mlir::failed(__mlir_ods_local_region_constraint_OpenACCOps0(*this, region, "combinerRegion", index++)))
        return ::mlir::failure();
  }
  return ::mlir::success();
}

::mlir::LogicalResult ReductionRecipeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ReductionRecipeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::StringAttr sym_nameAttr;
  ::mlir::TypeAttr typeAttr;
  ::mlir::acc::ReductionOperatorAttr reductionOperatorAttr;
  std::unique_ptr<::mlir::Region> initRegionRegion = std::make_unique<::mlir::Region>();
  std::unique_ptr<::mlir::Region> combinerRegionRegion = std::make_unique<::mlir::Region>();

  if (parser.parseSymbolName(sym_nameAttr))
    return ::mlir::failure();
  if (sym_nameAttr) result.getOrAddProperties<ReductionRecipeOp::Properties>().sym_name = sym_nameAttr;
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(typeAttr, parser.getBuilder().getType<::mlir::NoneType>())) {
    return ::mlir::failure();
  }
  if (typeAttr) result.getOrAddProperties<ReductionRecipeOp::Properties>().type = typeAttr;
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDictWithKeyword(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseKeyword("reduction_operator"))
    return ::mlir::failure();

  if (parser.parseCustomAttributeWithFallback(reductionOperatorAttr, ::mlir::Type{})) {
    return ::mlir::failure();
  }
  if (reductionOperatorAttr) result.getOrAddProperties<ReductionRecipeOp::Properties>().reductionOperator = reductionOperatorAttr;
  if (parser.parseKeyword("init"))
    return ::mlir::failure();

  if (parser.parseRegion(*initRegionRegion))
    return ::mlir::failure();
  if (parser.parseKeyword("combiner"))
    return ::mlir::failure();

  if (parser.parseRegion(*combinerRegionRegion))
    return ::mlir::failure();
  result.addRegion(std::move(initRegionRegion));
  result.addRegion(std::move(combinerRegionRegion));
  return ::mlir::success();
}

void ReductionRecipeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter.printSymbolName(getSymNameAttr().getValue());
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  _odsPrinter.printAttributeWithoutType(getTypeAttr());
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("sym_name");
  elidedAttrs.push_back("type");
  elidedAttrs.push_back("reductionOperator");
  _odsPrinter.printOptionalAttrDictWithKeyword((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << "reduction_operator";
  _odsPrinter << ' ';
_odsPrinter.printStrippedAttrOrType(getReductionOperatorAttr());
  _odsPrinter << ' ' << "init";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getInitRegion());
  _odsPrinter << ' ' << "combiner";
  _odsPrinter << ' ';
  _odsPrinter.printRegion(getCombinerRegion());
}

} // namespace acc
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::acc::ReductionRecipeOp)

namespace mlir {
namespace acc {

//===----------------------------------------------------------------------===//
// ::mlir::acc::SerialOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SerialOpGenericAdaptorBase::SerialOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
    odsOpName.emplace("acc.serial", odsAttrs.getContext());
}

std::pair<unsigned, unsigned> SerialOpGenericAdaptorBase::getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::DictionaryAttr SerialOpGenericAdaptorBase::getAttributes() {
  return odsAttrs;
}

::mlir::UnitAttr SerialOpGenericAdaptorBase::getAsyncAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool SerialOpGenericAdaptorBase::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr SerialOpGenericAdaptorBase::getWaitAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool SerialOpGenericAdaptorBase::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr SerialOpGenericAdaptorBase::getSelfAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool SerialOpGenericAdaptorBase::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr SerialOpGenericAdaptorBase::getReductionRecipesAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > SerialOpGenericAdaptorBase::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr SerialOpGenericAdaptorBase::getPrivatizationsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > SerialOpGenericAdaptorBase::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr SerialOpGenericAdaptorBase::getFirstprivatizationsAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizations);
  return attr;
}

::std::optional< ::mlir::ArrayAttr > SerialOpGenericAdaptorBase::getFirstprivatizations() {
  auto attr = getFirstprivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::acc::ClauseDefaultValueAttr SerialOpGenericAdaptorBase::getDefaultAttrAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
  return attr;
}

::std::optional<::mlir::acc::ClauseDefaultValue> SerialOpGenericAdaptorBase::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

::mlir::Region &SerialOpGenericAdaptorBase::getRegion() {
  return *odsRegions[0];
}

::mlir::RegionRange SerialOpGenericAdaptorBase::getRegions() {
  return odsRegions;
}

} // namespace detail
SerialOpAdaptor::SerialOpAdaptor(SerialOp op) : SerialOpAdaptor(op->getOperands(), op->getAttrDictionary(), op.getProperties(), op->getRegions()) {}

::mlir::LogicalResult SerialOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_asyncAttr = getProperties().asyncAttr; (void)tblgen_asyncAttr;
  auto tblgen_defaultAttr = getProperties().defaultAttr; (void)tblgen_defaultAttr;
  auto tblgen_firstprivatizations = getProperties().firstprivatizations; (void)tblgen_firstprivatizations;
  auto tblgen_privatizations = getProperties().privatizations; (void)tblgen_privatizations;
  auto tblgen_reductionRecipes = getProperties().reductionRecipes; (void)tblgen_reductionRecipes;
  auto tblgen_selfAttr = getProperties().selfAttr; (void)tblgen_selfAttr;
  auto tblgen_waitAttr = getProperties().waitAttr; (void)tblgen_waitAttr;

  if (tblgen_asyncAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_asyncAttr))))
    return emitError(loc, "'acc.serial' op ""attribute 'asyncAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_waitAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_waitAttr))))
    return emitError(loc, "'acc.serial' op ""attribute 'waitAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_selfAttr && !((::llvm::isa<::mlir::UnitAttr>(tblgen_selfAttr))))
    return emitError(loc, "'acc.serial' op ""attribute 'selfAttr' failed to satisfy constraint: unit attribute");

  if (tblgen_reductionRecipes && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_reductionRecipes))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_reductionRecipes), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.serial' op ""attribute 'reductionRecipes' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_privatizations && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_privatizations))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_privatizations), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.serial' op ""attribute 'privatizations' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_firstprivatizations && !(((::llvm::isa<::mlir::ArrayAttr>(tblgen_firstprivatizations))) && (::llvm::all_of(::llvm::cast<::mlir::ArrayAttr>(tblgen_firstprivatizations), [&](::mlir::Attribute attr) { return attr && ((::llvm::isa<::mlir::SymbolRefAttr>(attr))); }))))
    return emitError(loc, "'acc.serial' op ""attribute 'firstprivatizations' failed to satisfy constraint: symbol ref array attribute");

  if (tblgen_defaultAttr && !((::llvm::isa<::mlir::acc::ClauseDefaultValueAttr>(tblgen_defaultAttr))))
    return emitError(loc, "'acc.serial' op ""attribute 'defaultAttr' failed to satisfy constraint: DefaultValue Clause");
  return ::mlir::success();
}

std::pair<unsigned, unsigned> SerialOp::getODSOperandIndexAndLength(unsigned index) {
  ::llvm::ArrayRef<int32_t> sizeAttr = getProperties().operandSegmentSizes;

  unsigned start = 0;
  for (unsigned i = 0; i < index; ++i)
    start += sizeAttr[i];
  return {start, sizeAttr[index]};
}

::mlir::Operation::operand_range SerialOp::getODSOperands(unsigned index) {
  auto valueRange = getODSOperandIndexAndLength(index);
  return {std::next(getOperation()->operand_begin(), valueRange.first),
           std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
}

::mlir::Value SerialOp::getAsync() {
  auto operands = getODSOperands(0);
  return operands.empty() ? ::mlir::Value{} : ::llvm::cast<::mlir::Value>(*operands.begin());
}

::mlir::Operation::operand_range SerialOp::getWaitOperands() {
  return getODSOperands(1);
}

::mlir::TypedValue<::mlir::IntegerType> SerialOp::getIfCond() {
  auto operands = getODSOperands(2);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::TypedValue<::mlir::IntegerType> SerialOp::getSelfCond() {
  auto operands = getODSOperands(3);
  return operands.empty() ? ::mlir::TypedValue<::mlir::IntegerType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*operands.begin());
}

::mlir::Operation::operand_range SerialOp::getReductionOperands() {
  return getODSOperands(4);
}

::mlir::Operation::operand_range SerialOp::getGangPrivateOperands() {
  return getODSOperands(5);
}

::mlir::Operation::operand_range SerialOp::getGangFirstPrivateOperands() {
  return getODSOperands(6);
}

::mlir::Operation::operand_range SerialOp::getDataClauseOperands() {
  return getODSOperands(7);
}

::mlir::MutableOperandRange SerialOp::getAsyncMutable() {
  auto range = getODSOperandIndexAndLength(0);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(0u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getWaitOperandsMutable() {
  auto range = getODSOperandIndexAndLength(1);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(1u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getIfCondMutable() {
  auto range = getODSOperandIndexAndLength(2);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(2u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getSelfCondMutable() {
  auto range = getODSOperandIndexAndLength(3);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(3u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getReductionOperandsMutable() {
  auto range = getODSOperandIndexAndLength(4);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(4u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getGangPrivateOperandsMutable() {
  auto range = getODSOperandIndexAndLength(5);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(5u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getGangFirstPrivateOperandsMutable() {
  auto range = getODSOperandIndexAndLength(6);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(6u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

::mlir::MutableOperandRange SerialOp::getDataClauseOperandsMutable() {
  auto range = getODSOperandIndexAndLength(7);
  auto mutableRange = ::mlir::MutableOperandRange(getOperation(), range.first, range.second, ::mlir::MutableOperandRange::OperandSegment(7u, {getOperandSegmentSizesAttrName(), ::mlir::DenseI32ArrayAttr::get(getContext(), getProperties().operandSegmentSizes)}));
  return mutableRange;
}

std::pair<unsigned, unsigned> SerialOp::getODSResultIndexAndLength(unsigned index) {
  return {index, 1};
}

::mlir::Operation::result_range SerialOp::getODSResults(unsigned index) {
  auto valueRange = getODSResultIndexAndLength(index);
  return {std::next(getOperation()->result_begin(), valueRange.first),
           std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
}

::mlir::Region &SerialOp::getRegion() {
  return (*this)->getRegion(0);
}

::mlir::LogicalResult SerialOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::mlir::InFlightDiagnostic *diag) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    if (diag)
      *diag << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.asyncAttr;
       auto attr = dict.get("asyncAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for asyncAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `asyncAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.defaultAttr;
       auto attr = dict.get("defaultAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for defaultAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `defaultAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.firstprivatizations;
       auto attr = dict.get("firstprivatizations");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for firstprivatizations in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `firstprivatizations` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.privatizations;
       auto attr = dict.get("privatizations");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for privatizations in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `privatizations` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.reductionRecipes;
       auto attr = dict.get("reductionRecipes");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for reductionRecipes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `reductionRecipes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.selfAttr;
       auto attr = dict.get("selfAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for selfAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `selfAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.waitAttr;
       auto attr = dict.get("waitAttr");
    if (attr || /*isRequired=*/false) {
      if (!attr) {
        if (diag)
          *diag << "expected key entry for waitAttr in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        if (diag)
          *diag << "Invalid attribute `waitAttr` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
;
    {
      auto setFromAttr = [] (auto &propStorage, ::mlir::Attribute propAttr,
                             ::mlir::InFlightDiagnostic *propDiag) {
        return convertFromAttribute(propStorage, propAttr, propDiag);;
      };
         auto attr = dict.get("operandSegmentSizes");   if (!attr) attr = dict.get("operand_segment_sizes");;
      if (!attr) {
        if (diag)
          *diag << "expected key entry for operandSegmentSizes in DictionaryAttr to set "
                   "Properties.";
        return ::mlir::failure();
      }
      if (::mlir::failed(setFromAttr(prop.operandSegmentSizes, attr, diag)))
        return ::mlir::failure();
    }
  return ::mlir::success();
}

::mlir::Attribute SerialOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.asyncAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("asyncAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.defaultAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("defaultAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.firstprivatizations;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("firstprivatizations",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.privatizations;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("privatizations",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.reductionRecipes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("reductionRecipes",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.selfAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("selfAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.waitAttr;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("waitAttr",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.operandSegmentSizes;
      attrs.push_back(odsBuilder.getNamedAttr("operandSegmentSizes",
                                              ::mlir::DenseI32ArrayAttr::get(ctx, propStorage)));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SerialOp::computePropertiesHash(const Properties &prop) {
  auto hash_operandSegmentSizes = [] (const auto &propStorage) -> llvm::hash_code {
    return ::llvm::hash_combine_range(std::begin(propStorage), std::end(propStorage));;
  };
  return llvm::hash_combine(
    llvm::hash_value(prop.asyncAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.defaultAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.firstprivatizations.getAsOpaquePointer()), 
    llvm::hash_value(prop.privatizations.getAsOpaquePointer()), 
    llvm::hash_value(prop.reductionRecipes.getAsOpaquePointer()), 
    llvm::hash_value(prop.selfAttr.getAsOpaquePointer()), 
    llvm::hash_value(prop.waitAttr.getAsOpaquePointer()), 
    hash_operandSegmentSizes(prop.operandSegmentSizes));
}

std::optional<mlir::Attribute> SerialOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "asyncAttr")
      return prop.asyncAttr;

    if (name == "defaultAttr")
      return prop.defaultAttr;

    if (name == "firstprivatizations")
      return prop.firstprivatizations;

    if (name == "privatizations")
      return prop.privatizations;

    if (name == "reductionRecipes")
      return prop.reductionRecipes;

    if (name == "selfAttr")
      return prop.selfAttr;

    if (name == "waitAttr")
      return prop.waitAttr;
    if (name == "operand_segment_sizes" || name == "operandSegmentSizes") return ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes);
  return std::nullopt;
}

void SerialOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "asyncAttr") {
       prop.asyncAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.asyncAttr)>>(value);
       return;
    }

    if (name == "defaultAttr") {
       prop.defaultAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.defaultAttr)>>(value);
       return;
    }

    if (name == "firstprivatizations") {
       prop.firstprivatizations = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.firstprivatizations)>>(value);
       return;
    }

    if (name == "privatizations") {
       prop.privatizations = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.privatizations)>>(value);
       return;
    }

    if (name == "reductionRecipes") {
       prop.reductionRecipes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.reductionRecipes)>>(value);
       return;
    }

    if (name == "selfAttr") {
       prop.selfAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.selfAttr)>>(value);
       return;
    }

    if (name == "waitAttr") {
       prop.waitAttr = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.waitAttr)>>(value);
       return;
    }
        if (name == "operand_segment_sizes" || name == "operandSegmentSizes") {
       auto arrAttr = ::llvm::dyn_cast_or_null<::mlir::DenseI32ArrayAttr>(value);
       if (!arrAttr) return;
       if (arrAttr.size() != sizeof(prop.operandSegmentSizes) / sizeof(int32_t))
         return;
       llvm::copy(arrAttr.asArrayRef(), prop.operandSegmentSizes.begin());
       return;
    }
}

void SerialOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.asyncAttr) attrs.append("asyncAttr", prop.asyncAttr);

    if (prop.defaultAttr) attrs.append("defaultAttr", prop.defaultAttr);

    if (prop.firstprivatizations) attrs.append("firstprivatizations", prop.firstprivatizations);

    if (prop.privatizations) attrs.append("privatizations", prop.privatizations);

    if (prop.reductionRecipes) attrs.append("reductionRecipes", prop.reductionRecipes);

    if (prop.selfAttr) attrs.append("selfAttr", prop.selfAttr);

    if (prop.waitAttr) attrs.append("waitAttr", prop.waitAttr);
  attrs.append("operandSegmentSizes", ::mlir::DenseI32ArrayAttr::get(ctx, prop.operandSegmentSizes));
}

::mlir::LogicalResult SerialOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> getDiag) {
    {
      ::mlir::Attribute attr = attrs.get(getAsyncAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "asyncAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getDefaultAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps4(attr, "defaultAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getFirstprivatizationsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "firstprivatizations", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getPrivatizationsAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "privatizations", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getReductionRecipesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps7(attr, "reductionRecipes", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getSelfAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "selfAttr", getDiag)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getWaitAttrAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_OpenACCOps3(attr, "waitAttr", getDiag)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::mlir::LogicalResult SerialOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.asyncAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.defaultAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.firstprivatizations)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.privatizations)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.reductionRecipes)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.selfAttr)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readOptionalAttribute(prop.waitAttr)))
    return ::mlir::failure();

  {
    auto &propStorage = prop.operandSegmentSizes;
    auto readProp = [&]() {

if (reader.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6) {
  ::mlir::DenseI32ArrayAttr attr;
  if (::mlir::failed(reader.readAttribute(attr))) return ::mlir::failure();
  if (attr.size() > static_cast<int64_t>(sizeof(propStorage) / sizeof(int32_t))) {
    reader.emitError("size mismatch for operand/result_segment_size");
    return ::mlir::failure();
  }
  llvm::copy(::llvm::ArrayRef<int32_t>(attr), propStorage.begin());
} else {
  return reader.readSparseArray(::llvm::MutableArrayRef(propStorage));
}
;
      return ::mlir::success();
    };
    if (::mlir::failed(readProp()))
      return ::mlir::failure();
  }
  return ::mlir::success();
}

void SerialOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.asyncAttr);

  writer.writeOptionalAttribute(prop.defaultAttr);

  writer.writeOptionalAttribute(prop.firstprivatizations);

  writer.writeOptionalAttribute(prop.privatizations);

  writer.writeOptionalAttribute(prop.reductionRecipes);

  writer.writeOptionalAttribute(prop.selfAttr);

  writer.writeOptionalAttribute(prop.waitAttr);

  {
    auto &propStorage = prop.operandSegmentSizes;

if (writer.getBytecodeVersion() < /*kNativePropertiesODSSegmentSize=*/6)
  writer.writeAttribute(::mlir::DenseI32ArrayAttr::get(getContext(), propStorage));
else
  writer.writeSparseArray(::llvm::ArrayRef(propStorage));
;
  }
}

::mlir::UnitAttr SerialOp::getAsyncAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().asyncAttr);
}

bool SerialOp::getAsyncAttr() {
  auto attr = getAsyncAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr SerialOp::getWaitAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().waitAttr);
}

bool SerialOp::getWaitAttr() {
  auto attr = getWaitAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::UnitAttr SerialOp::getSelfAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().selfAttr);
}

bool SerialOp::getSelfAttr() {
  auto attr = getSelfAttrAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

::mlir::ArrayAttr SerialOp::getReductionRecipesAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().reductionRecipes);
}

::std::optional< ::mlir::ArrayAttr > SerialOp::getReductionRecipes() {
  auto attr = getReductionRecipesAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr SerialOp::getPrivatizationsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().privatizations);
}

::std::optional< ::mlir::ArrayAttr > SerialOp::getPrivatizations() {
  auto attr = getPrivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::ArrayAttr SerialOp::getFirstprivatizationsAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().firstprivatizations);
}

::std::optional< ::mlir::ArrayAttr > SerialOp::getFirstprivatizations() {
  auto attr = getFirstprivatizationsAttr();
  return attr ? ::std::optional< ::mlir::ArrayAttr >(attr) : (::std::nullopt);
}

::mlir::acc::ClauseDefaultValueAttr SerialOp::getDefaultAttrAttr() {
  return ::llvm::dyn_cast_or_null<::mlir::acc::ClauseDefaultValueAttr>(getProperties().defaultAttr);
}

::std::optional<::mlir::acc::ClauseDefaultValue> SerialOp::getDefaultAttr() {
  auto attr = getDefaultAttrAttr();
  return attr ? ::std::optional<::mlir::acc::ClauseDefaultValue>(attr.getValue()) : (::std::nullopt);
}

void SerialOp::setAsyncAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getAsyncAttrAttrName(), attr);
}

void SerialOp::setAsyncAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getAsyncAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getAsyncAttrAttrName());
}

void SerialOp::setWaitAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getWaitAttrAttrName(), attr);
}

void SerialOp::setWaitAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getWaitAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getWaitAttrAttrName());
}

void SerialOp::setSelfAttrAttr(::mlir::UnitAttr attr) {
  (*this)->setAttr(getSelfAttrAttrName(), attr);
}

void SerialOp::setSelfAttr(bool attrValue) {
    if (attrValue)
      return (*this)->setAttr(getSelfAttrAttrName(), ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr));
    (*this)->removeAttr(getSelfAttrAttrName());
}

void SerialOp::setReductionRecipesAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getReductionRecipesAttrName(), attr);
}

void SerialOp::setPrivatizationsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getPrivatizationsAttrName(), attr);
}

void SerialOp::setFirstprivatizationsAttr(::mlir::ArrayAttr attr) {
  (*this)->setAttr(getFirstprivatizationsAttrName(), attr);
}

void SerialOp::setDefaultAttrAttr(::mlir::acc::ClauseDefaultValueAttr attr) {
  (*this)->setAttr(getDefaultAttrAttrName(), attr);
}

void SerialOp::setDefaultAttr(::std::optional<::mlir::acc::ClauseDefaultValue> attrValue) {
    if (attrValue)
      return (*this)->setAttr(getDefaultAttrAttrName(), ::mlir::acc::ClauseDefaultValueAttr::get(::mlir::Builder((*this)->getContext()).getContext(), *attrValue));
    (*this)->removeAttr(getDefaultAttrAttrName());
}

::mlir::Attribute SerialOp::removeAsyncAttrAttr() {
    auto &attr = getProperties().asyncAttr;
    attr = {};
    return attr;
}

: