% LTFAT - Non-stationary Gabor systems
%
%  Florent Jaillet and Peter L. Soendergaard, 2011 - 2023.
%
%  Transforms
%    NSDGT                - Non-stationary DGT
%    UNSDGT               - Uniform non-stationary DGT
%    INSDGT               - Inverse NSDGT and UNSDGT
%    NSDGTREAL            - Non-stationary DGT for real-valued signals
%    UNSDGTREAL           - Uniform non-stationary DGT for real-valued signals
%    INSDGTREAL           - Inverse NSDGTREAL and UNSDGTREAL
%
%  Window construction and bounds
%    NSGABDUAL            - Non-stationary dual windows
%    NSGABTIGHT           - Non-stationary tight windows
%    NSGABFRAMEBOUNDS     - Frame bounds of an NSDGT system
%    NSGABFRAMEDIAG       - Diagonal of non-stationary Gabor frame operator
%
%  Plots
%    PLOTNSDGT            - Plot output coefficients from NSDGT
%    PLOTNSDGTREAL        - Plot output coefficients from NSDGTREAL
%
%  For help, bug reports, suggestions etc. please visit 
%  http://github.com/ltfat/ltfat/issues
%
%   Url: http://ltfat.github.io/doc/nonstatgab/Contents.html

% Copyright (C) 2005-2023 Peter L. Soendergaard <peter@sonderport.dk> and others.
% This file is part of LTFAT version 2.6.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

