## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024, 2026 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the Loblolly dataset from R’s datasets package

classdef Loblolly < tblish.internal.dataset

  methods

    function this = Loblolly
      this.name = "Loblolly";
      this.summary = "Growth of Loblolly pine trees";
    endfunction

    function out = load (this)
      height = [4.51, 10.89, 28.72, 41.74, 52.7, 60.92, ...
        4.55, 10.92, 29.07, 42.83, 53.88, 63.39, 4.79, 11.37, 30.21, ...
        44.4, 55.82, 64.1, 3.91, 9.48, 25.66, 39.07, 50.78, 59.07, 4.81, ...
        11.2, 28.66, 41.66, 53.31, 63.05, 3.88, 9.4, 25.99, 39.55, 51.46, ...
        59.64, 4.32, 10.43, 27.16, 40.85, 51.33, 60.07, 4.57, 10.57, ...
        27.9, 41.13, 52.43, 60.69, 3.77, 9.03, 25.45, 38.98, 49.76, 60.28, ...
        4.33, 10.79, 28.97, 42.44, 53.17, 61.62, 4.38, 10.48, 27.93, ...
        40.2, 50.06, 58.49, 4.12, 9.92, 26.54, 37.82, 48.43, 56.81, 3.93, ...
        9.34, 26.08, 37.79, 48.31, 56.43, 3.46, 9.05, 25.85, 39.15, 49.12, ...
        59.49]';
      age = [3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, 3, ...
        5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, ...
        3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, ...
        25, 3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, 3, 5, 10, 15, ...
        20, 25, 3, 5, 10, 15, 20, 25, 3, 5, 10, 15, 20, 25, 3, 5, 10, ...
        15, 20, 25]';
      Seed = categorical ([10, 10, 10, 10, 10, 10, ...
        13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 4, 4, 4, 4, 4, ...
        4, 12, 12, 12, 12, 12, 12, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, ...
        9, 9, 9, 9, 9, 9, 8, 8, 8, 8, 8, 8, 11, 11, 11, 11, 11, 11, 3, ...
        3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 5, 5, 5, 5, ...
        5, 5]', 1:14,
        {"329", "327", "325", "307", "331", "311", "315", "321", ...
          "319", "301", "323", "309", "303", "305"});
      record = string ({"1", "15", "29", ...
        "43", "57", "71", "2", "16", "30", "44", "58", "72", "3", "17", ...
        "31", "45", "59", "73", "4", "18", "32", "46", "60", "74", "5", ...
        "19", "33", "47", "61", "75", "6", "20", "34", "48", "62", "76", ...
        "7", "21", "35", "49", "63", "77", "8", "22", "36", "50", "64", ...
        "78", "9", "23", "37", "51", "65", "79", "10", "24", "38", "52", ...
        "66", "80", "11", "25", "39", "53", "67", "81", "12", "26", "40", ...
        "54", "68", "82", "13", "27", "41", "55", "69", "83", "14", "28", ...
        "42", "56", "70", "84"}');
      out = table (record, height, age, Seed);
    endfunction

  endmethods

endclassdef
