## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024, 2026 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful, ...
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the sunspot_year dataset from R’s datasets package

classdef sunspot_year < tblish.internal.dataset

  methods

    function this = sunspot_year
      this.name = "sunspot_year";
      this.summary = "Yearly Sunspot Data, 1700-1988";
    endfunction

    function out = load (this)
      year = [1700:1988]';
      sunspots = [
        5.00, ...
        11.00, ...
        16.00, ...
        23.00, ...
        36.00, ...
        58.00, ...
        29.00, ...
        20.00, ...
        10.00, ...
        8.00, ...
        3.00, ...
        0.00, ...
        0.00, ...
        2.00, ...
        11.00, ...
        27.00, ...
        47.00, ...
        63.00, ...
        60.00, ...
        39.00, ...
        28.00, ...
        26.00, ...
        22.00, ...
        11.00, ...
        21.00, ...
        40.00, ...
        78.00, ...
        122.00, ...
        103.00, ...
        73.00, ...
        47.00, ...
        35.00, ...
        11.00, ...
        5.00, ...
        16.00, ...
        34.00, ...
        70.00, ...
        81.00, ...
        111.00, ...
        101.00, ...
        73.00, ...
        40.00, ...
        20.00, ...
        16.00, ...
        5.00, ...
        11.00, ...
        22.00, ...
        40.00, ...
        60.00, ...
        80.90, ...
        83.40, ...
        47.70, ...
        47.80, ...
        30.70, ...
        12.20, ...
        9.60, ...
        10.20, ...
        32.40, ...
        47.60, ...
        54.00, ...
        62.90, ...
        85.90, ...
        61.20, ...
        45.10, ...
        36.40, ...
        20.90, ...
        11.40, ...
        37.80, ...
        69.80, ...
        106.10, ...
        100.80, ...
        81.60, ...
        66.50, ...
        34.80, ...
        30.60, ...
        7.00, ...
        19.80, ...
        92.50, ...
        154.40, ...
        125.90, ...
        84.80, ...
        68.10, ...
        38.50, ...
        22.80, ...
        10.20, ...
        24.10, ...
        82.90, ...
        132.00, ...
        130.90, ...
        118.10, ...
        89.90, ...
        66.60, ...
        60.00, ...
        46.90, ...
        41.00, ...
        21.30, ...
        16.00, ...
        6.40, ...
        4.10, ...
        6.80, ...
        14.50, ...
        34.00, ...
        45.00, ...
        43.10, ...
        47.50, ...
        42.20, ...
        28.10, ...
        10.10, ...
        8.10, ...
        2.50, ...
        0.00, ...
        1.40, ...
        5.00, ...
        12.20, ...
        13.90, ...
        35.40, ...
        45.80, ...
        41.10, ...
        30.10, ...
        23.90, ...
        15.60, ...
        6.60, ...
        4.00, ...
        1.80, ...
        8.50, ...
        16.60, ...
        36.30, ...
        49.60, ...
        64.20, ...
        67.00, ...
        70.90, ...
        47.80, ...
        27.50, ...
        8.50, ...
        13.20, ...
        56.90, ...
        121.50, ...
        138.30, ...
        103.20, ...
        85.70, ...
        64.60, ...
        36.70, ...
        24.20, ...
        10.70, ...
        15.00, ...
        40.10, ...
        61.50, ...
        98.50, ...
        124.70, ...
        96.30, ...
        66.60, ...
        64.50, ...
        54.10, ...
        39.00, ...
        20.60, ...
        6.70, ...
        4.30, ...
        22.70, ...
        54.80, ...
        93.80, ...
        95.80, ...
        77.20, ...
        59.10, ...
        44.00, ...
        47.00, ...
        30.50, ...
        16.30, ...
        7.30, ...
        37.60, ...
        74.00, ...
        139.00, ...
        111.20, ...
        101.60, ...
        66.20, ...
        44.70, ...
        17.00, ...
        11.30, ...
        12.40, ...
        3.40, ...
        6.00, ...
        32.30, ...
        54.30, ...
        59.70, ...
        63.70, ...
        63.50, ...
        52.20, ...
        25.40, ...
        13.10, ...
        6.80, ...
        6.30, ...
        7.10, ...
        35.60, ...
        73.00, ...
        85.10, ...
        78.00, ...
        64.00, ...
        41.80, ...
        26.20, ...
        26.70, ...
        12.10, ...
        9.50, ...
        2.70, ...
        5.00, ...
        24.40, ...
        42.00, ...
        63.50, ...
        53.80, ...
        62.00, ...
        48.50, ...
        43.90, ...
        18.60, ...
        5.70, ...
        3.60, ...
        1.40, ...
        9.60, ...
        47.40, ...
        57.10, ...
        103.90, ...
        80.60, ...
        63.60, ...
        37.60, ...
        26.10, ...
        14.20, ...
        5.80, ...
        16.70, ...
        44.30, ...
        63.90, ...
        69.00, ...
        77.80, ...
        64.90, ...
        35.70, ...
        21.20, ...
        11.10, ...
        5.70, ...
        8.70, ...
        36.10, ...
        79.70, ...
        114.40, ...
        109.60, ...
        88.80, ...
        67.80, ...
        47.50, ...
        30.60, ...
        16.30, ...
        9.60, ...
        33.20, ...
        92.60, ...
        151.60, ...
        136.30, ...
        134.70, ...
        83.90, ...
        69.40, ...
        31.50, ...
        13.90, ...
        4.40, ...
        38.00, ...
        141.70, ...
        190.20, ...
        184.80, ...
        159.00, ...
        112.30, ...
        53.90, ...
        37.50, ...
        27.90, ...
        10.20, ...
        15.10, ...
        47.00, ...
        93.80, ...
        105.90, ...
        105.50, ...
        104.50, ...
        66.60, ...
        68.90, ...
        38.00, ...
        34.50, ...
        15.50, ...
        12.60, ...
        27.50, ...
        92.50, ...
        155.40, ...
        154.70, ...
        140.50, ...
        115.90, ...
        66.60, ...
        45.90, ...
        17.90, ...
        13.40, ...
        29.20, ...
        100.20]';
      out = table (year, sunspots);
    endfunction

  endmethods

endclassdef
