## Copyright (C) 1994-9 W. N. Venables and B. D. Ripley
## Copyright (C) 2019, 2023, 2024, 2026 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the beavers dataset from R’s datasets package

classdef beavers < tblish.internal.dataset
  # Body temperature of two beavers

  methods

    function this = beavers ()
      this.name = "beavers";
      this.summary = "Body Temperature Series of Two Beavers";
    endfunction

    function out = load (this)
      beaver1.day = [346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, 346, ...
        346, 346, 346, 346, 346, 347, 347, 347, 347, 347, 347, 347, 347, ...
        347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, 347, ...
        347, 347]';
      beaver1.time = [840, 850, 900, 910, 920, 930, 940, 950, 1000, ...
        1010, 1020, 1030, 1040, 1050, 1100, 1110, 1120, 1130, 1140, 1150, ...
        1200, 1210, 1220, 1230, 1240, 1250, 1300, 1310, 1320, 1330, 1340, ...
        1350, 1400, 1410, 1420, 1430, 1440, 1450, 1500, 1510, 1520, 1530, ...
        1540, 1550, 1600, 1610, 1620, 1630, 1640, 1650, 1700, 1710, 1720, ...
        1730, 1740, 1750, 1800, 1810, 1820, 1830, 1840, 1850, 1900, 1910, ...
        1920, 1930, 1940, 1950, 2000, 2010, 2020, 2030, 2040, 2050, 2100, ...
        2110, 2120, 2130, 2140, 2150, 2200, 2210, 2230, 2240, 2250, 2300, ...
        2310, 2320, 2330, 2340, 2350, 0, 10, 20, 30, 40, 50, 100, 110, ...
        120, 130, 140, 150, 200, 210, 220, 230, 240, 250, 300, 310, 320, ...
        330, 340]';
      beaver1.temp = [36.33, 36.34, 36.35, 36.42, 36.55, 36.69, ...
        36.71, 36.75, 36.81, 36.88, 36.89, 36.91, 36.85, 36.89, 36.89, ...
        36.67, 36.5, 36.74, 36.77, 36.76, 36.78, 36.82, 36.89, 36.99, ...
        36.92, 36.99, 36.89, 36.94, 36.92, 36.97, 36.91, 36.79, 36.77, ...
        36.69, 36.62, 36.54, 36.55, 36.67, 36.69, 36.62, 36.64, 36.59, ...
        36.65, 36.75, 36.8, 36.81, 36.87, 36.87, 36.89, 36.94, 36.98, ...
        36.95, 37, 37.07, 37.05, 37, 36.95, 37, 36.94, 36.88, 36.93, ...
        36.98, 36.97, 36.85, 36.92, 36.99, 37.01, 37.1, 37.09, 37.02, ...
        36.96, 36.84, 36.87, 36.85, 36.85, 36.87, 36.89, 36.86, 36.91, ...
        37.53, 37.23, 37.2, 37.25, 37.2, 37.21, 37.24, 37.1, 37.2, 37.18, ...
        36.93, 36.83, 36.93, 36.83, 36.8, 36.75, 36.71, 36.73, 36.75, ...
        36.72, 36.76, 36.7, 36.82, 36.88, 36.94, 36.79, 36.78, 36.8, ...
        36.82, 36.84, 36.86, 36.88, 36.93, 36.97, 37.15]';
      beaver1.activ = [0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, ...
        1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 1]';

      beaver2.day = [307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, 307, ...
        307, 308, 308, 308, 308, 308, 308, 308, 308, 308, 308, 308, 308, ...
        308]';
      beaver2.time = [930, 940, 950, 1000, 1010, 1020, 1030, 1040, 1050, ...
        1100, 1110, 1120, 1130, 1140, 1150, 1200, 1210, 1220, 1230, 1240, ...
        1250, 1300, 1310, 1320, 1330, 1340, 1350, 1400, 1410, 1420, 1430, ...
        1440, 1450, 1500, 1510, 1520, 1530, 1540, 1550, 1600, 1610, 1620, ...
        1630, 1640, 1650, 1700, 1710, 1720, 1730, 1740, 1750, 1800, 1810, ...
        1820, 1830, 1840, 1850, 1900, 1910, 1920, 1930, 1940, 1950, 2000, ...
        2010, 2020, 2030, 2040, 2050, 2100, 2110, 2120, 2130, 2140, 2150, ...
        2200, 2210, 2220, 2230, 2240, 2250, 2300, 2310, 2320, 2330, 2340, ...
        2350, 0, 10, 20, 30, 40, 50, 100, 110, 120, 130, 140, 150, 200]';
      beaver2.temp = [36.58, 36.73, 36.93, 37.15, 37.23, 37.24, 37.24, ...
        36.9, 36.95, 36.89, 36.95, 37, 36.9, 36.99, 36.99, 37.01, 37.04, ...
        37.04, 37.14, 37.07, 36.98, 37.01, 36.97, 36.97, 37.12, 37.13, ...
        37.14, 37.15, 37.17, 37.12, 37.12, 37.17, 37.28, 37.28, 37.44, ...
        37.51, 37.64, 37.51, 37.98, 38.02, 38, 38.24, 38.1, 38.24, 38.11, ...
        38.02, 38.11, 38.01, 37.91, 37.96, 38.03, 38.17, 38.19, 38.18, ...
        38.15, 38.04, 37.96, 37.84, 37.83, 37.84, 37.74, 37.76, 37.76, ...
        37.64, 37.63, 38.06, 38.19, 38.35, 38.25, 37.86, 37.95, 37.95, ...
        37.76, 37.6, 37.89, 37.86, 37.71, 37.78, 37.82, 37.76, 37.81, ...
        37.84, 38.01, 38.1, 38.15, 37.92, 37.64, 37.7, 37.46, 37.41, ...
        37.46, 37.56, 37.55, 37.75, 37.76, 37.73, 37.77, 38.01, 38.04, ...
        38.07]';
      beaver2.activ = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, ...
        0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, ...
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, ...
        1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1]';

      # Munge
      beaver1.activ = logical (beaver1.activ);
      beaver2.activ = logical (beaver2.activ);
      beaver1.time = convert_stupid_numeric_time_to_time_of_day (beaver1.time);
      beaver2.time = convert_stupid_numeric_time_to_time_of_day (beaver2.time);

      tbl1 = struct2table(beaver1);
      tbl2 = struct2table(beaver2);
      tbl1 = setvar(tbl1, 'beaver', 'beaver1');
      tbl2 = setvar(tbl2, 'beaver', 'beaver2');
      tbl = [tbl1; tbl2];

      out.beavers = tbl;
    endfunction

  endmethods

endclassdef

function out = convert_stupid_numeric_time_to_time_of_day(numtime)
hour = floor (numtime / 100);
minutes = rem (numtime, 100);
out = datetime (0, 0, 0, hour, minutes, 0);
endfunction
