## Copyright (C) 1995-2007 R Core Team
## Copyright (C) 2019, 2023, 2024, 2026 Andrew Janke
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 3 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; If not, see <http://www.gnu.org/licenses/>.

# This is based on the BJsales dataset from R’s datasets package

classdef BJsales < tblish.internal.dataset

  methods

    function this = BJsales
      this.name = "BJsales";
      this.summary = "Sales Data with Leading Indicator";
    endfunction

    function out = load (this)
      lead = [
        10.01, 10.07, 10.32,  9.75, 10.33, 10.13, 10.36, 10.32, 10.13, 10.16, 10.58, 10.62, 10.86, ...
        11.20, 10.74, 10.56, 10.48, 10.77, 11.33, 10.96, 11.16, 11.70, 11.39, 11.42, 11.94, 11.24, ...
        11.59, 10.96, 11.40, 11.02, 11.01, 11.23, 11.33, 10.83, 10.84, 11.14, 10.38, 10.90, 11.05, ...
        11.11, 11.01, 11.22, 11.21, 11.91, 11.69, 10.93, 10.99, 11.01, 10.84, 10.76, 10.77, 10.88, ...
        10.49, 10.50, 11.00, 10.98, 10.61, 10.48, 10.53, 11.07, 10.61, 10.86, 10.34, 10.78, 10.80, ...
        10.33, 10.44, 10.50, 10.75, 10.40, 10.40, 10.34, 10.55, 10.46, 10.82, 10.91, 10.87, 10.67, ...
        11.11, 10.88, 11.28, 11.27, 11.44, 11.52, 12.10, 11.83, 12.62, 12.41, 12.43, 12.73, 13.01, ...
        12.74, 12.73, 12.76, 12.92, 12.64, 12.79, 13.05, 12.69, 13.01, 12.90, 13.12, 12.47, 12.47, ...
        12.94, 13.10, 12.91, 13.39, 13.13, 13.34, 13.34, 13.14, 13.49, 13.87, 13.39, 13.59, 13.27, ...
        13.70, 13.20, 13.32, 13.15, 13.30, 12.94, 13.29, 13.26, 13.08, 13.24, 13.31, 13.52, 13.02, ...
        13.25, 13.12, 13.26, 13.11, 13.30, 13.06, 13.32, 13.10, 13.27, 13.64, 13.58, 13.87, 13.53, ...
        13.41, 13.25, 13.50, 13.58, 13.51, 13.77, 13.40]';
      sales = [
        200.1, 199.5, 199.4, 198.9, 199.0, 200.2, 198.6, 200.0, 200.3, 201.2, 201.6, 201.5, ...
        201.5, 203.5, 204.9, 207.1, 210.5, 210.5, 209.8, 208.8, 209.5, 213.2, 213.7, 215.1, ...
        218.7, 219.8, 220.5, 223.8, 222.8, 223.8, 221.7, 222.3, 220.8, 219.4, 220.1, 220.6, ...
        218.9, 217.8, 217.7, 215.0, 215.3, 215.9, 216.7, 216.7, 217.7, 218.7, 222.9, 224.9, ...
        222.2, 220.7, 220.0, 218.7, 217.0, 215.9, 215.8, 214.1, 212.3, 213.9, 214.6, 213.6, ...
        212.1, 211.4, 213.1, 212.9, 213.3, 211.5, 212.3, 213.0, 211.0, 210.7, 210.1, 211.4, ...
        210.0, 209.7, 208.8, 208.8, 208.8, 210.6, 211.9, 212.8, 212.5, 214.8, 215.3, 217.5, ...
        218.8, 220.7, 222.2, 226.7, 228.4, 233.2, 235.7, 237.1, 240.6, 243.8, 245.3, 246.0, ...
        246.3, 247.7, 247.6, 247.8, 249.4, 249.0, 249.9, 250.5, 251.5, 249.0, 247.6, 248.8, ...
        250.4, 250.7, 253.0, 253.7, 255.0, 256.2, 256.0, 257.4, 260.4, 260.0, 261.3, 260.4, ...
        261.6, 260.8, 259.8, 259.0, 258.9, 257.4, 257.7, 257.9, 257.4, 257.3, 257.6, 258.9, ...
        257.8, 257.7, 257.2, 257.5, 256.8, 257.5, 257.0, 257.6, 257.3, 257.5, 259.6, 261.1, ...
        262.9, 263.3, 262.8, 261.8, 262.2, 262.7]';
      record = [1:numel(sales)]';

      out = table (record, lead, sales);
    endfunction

  endmethods

endclassdef
