# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _meshdatacache
else:
    import _meshdatacache

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class MeshDataCache(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def setMesh(self, arg2):
        return _meshdatacache.MeshDataCache_setMesh(self, arg2)

    def times(self):
        return _meshdatacache.MeshDataCache_times(self)

    def size(self):
        return _meshdatacache.MeshDataCache_size(self)

    def restore(self, arg2):
        return _meshdatacache.MeshDataCache_restore(self, arg2)

    def restoreLatest(self):
        return _meshdatacache.MeshDataCache_restoreLatest(self)

    def interpolate(self, arg2):
        return _meshdatacache.MeshDataCache_interpolate(self, arg2)

    def record(self):
        return _meshdatacache.MeshDataCache_record(self)

    def clear(self):
        return _meshdatacache.MeshDataCache_clear(self)

    def latestTime(self):
        return _meshdatacache.MeshDataCache_latestTime(self)

    def earliestTime(self):
        return _meshdatacache.MeshDataCache_earliestTime(self)

    def transfer(self, arg2):
        return _meshdatacache.MeshDataCache_transfer(self, arg2)

    def atLatest(self):
        return _meshdatacache.MeshDataCache_atLatest(self)

    def atEarliest(self):
        return _meshdatacache.MeshDataCache_atEarliest(self)
    __swig_destroy__ = _meshdatacache.delete_MeshDataCache

# Register MeshDataCache in _meshdatacache:
_meshdatacache.MeshDataCache_swigregister(MeshDataCache)
class MemoryDataCache(MeshDataCache):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2):
        _meshdatacache.MemoryDataCache_swiginit(self, _meshdatacache.new_MemoryDataCache(arg2))
    __swig_destroy__ = _meshdatacache.delete_MemoryDataCache

# Register MemoryDataCache in _meshdatacache:
_meshdatacache.MemoryDataCache_swigregister(MemoryDataCache)
class DiskDataCache(MeshDataCache):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, arg2):
        _meshdatacache.DiskDataCache_swiginit(self, _meshdatacache.new_DiskDataCache(arg2))
    __swig_destroy__ = _meshdatacache.delete_DiskDataCache

# Register DiskDataCache in _meshdatacache:
_meshdatacache.DiskDataCache_swigregister(DiskDataCache)
# -*- python -*-

# This software was produced by NIST, an agency of the U.S. government,
# and by statute is not subject to copyright in the United States.
# Recipients of this software assume all responsibilities associated
# with its operation, modification and maintenance. However, to
# facilitate maintenance we ask that before distributing modified
# versions of this software, you first contact the authors at
# oof_manager@nist.gov. 

from ooflib.common import enum
from ooflib.common import registeredclass
from ooflib.common.IO import oofmenu
from ooflib.common.IO import xmlmenudump
from ooflib.engine import meshmod

class CacheType(enum.EnumClass(
        ('Memory', 'Store time steps in memory'),
        ('Disk', 'Store time steps in files'))):
    tip = "How to store data for previous time steps."
    discussion=xmlmenudump.loadFile('DISCUSSIONS/engine/enum/cachetype.xml')


class SetMeshDataCacheType(meshmod.MeshModification):
    def __init__(self, cachetype):
        self.cachetype = cachetype
    def apply(self, meshcontext):
        if (self.cachetype == 'Memory' and 
            isinstance(meshcontext.datacache, DiskDataCache)):
            oldcache = meshcontext.datacache
            meshcontext.datacache = MemoryDataCache(meshcontext.getObject())
            meshcontext.datacache.transfer(oldcache)
        elif (self.cachetype == 'Disk' and
              isinstance(meshcontext.datacache, MemoryDataCache)):
            oldcache = meshcontext.datacache
            meshcontext.datacache = DiskDataCache(meshcontext.getObject())
            meshcontext.datacache.transfer(oldcache)

cacheTypeParam = enum.EnumParameter('cachetype', CacheType, value='Memory',
                           tip='Type of cache to use for time step data.')     

dataCacheReg = registeredclass.Registration(
    'Set Data Cache Type',
    meshmod.MeshModification,
    SetMeshDataCacheType,
    ordering=10,
    params=[cacheTypeParam],
    tip='Choose to cache time step data in memory or on disk.',
    discussion=xmlmenudump.loadFile('DISCUSSIONS/engine/reg/setcachetype.xml'),
    xrefs=["MenuItem-OOF.Settings.Mesh_Defaults.Data_Cache_Type"]
)


def newMeshDataCache(femesh):
    if dataCacheReg.getParameter('cachetype').value == 'Memory':
        return MemoryDataCache(femesh)
    else:
        return DiskDataCache(femesh)

def getMeshDataCacheType(cache):
    if isinstance(cache, MemoryDataCache):
        return 'Memory'
    if isinstance(cache, DiskDataCache):
        return 'Disk'

###############

class ClearMeshDataCache(meshmod.MeshModification):
    def apply(self, meshcontext):
        meshcontext.clearDataCache()

registeredclass.Registration(
    'Clear Data Cache',
    meshmod.MeshModification,
    ClearMeshDataCache,
    ordering=11,
    tip='Remove cached field values for all times except the current time.',
    discussion=xmlmenudump.loadFile('DISCUSSIONS/engine/reg/clearcache.xml'),
    xrefs=["MenuItem-OOF.Settings.Mesh_Defaults.Data_Cache_Type"]
)



