/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.text.AttributedString;
import java.util.Objects;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JWindow;

public final class FontPanel
extends JPanel
implements AdjustmentListener {
    private final String[] STYLES = new String[]{"plain", "bold", "italic", "bold italic"};
    private final int NONE = 0;
    private final int SCALE = 1;
    private final int SHEAR = 2;
    private final int ROTATE = 3;
    private final String[] TRANSFORMS = new String[]{"with no transforms", "with scaling", "with Shearing", "with rotation"};
    private final int DRAW_STRING = 0;
    private final int DRAW_CHARS = 1;
    private final int DRAW_BYTES = 2;
    private final int DRAW_GLYPHV = 3;
    private final int TL_DRAW = 4;
    private final int GV_OUTLINE = 5;
    private final int TL_OUTLINE = 6;
    private final String[] METHODS = new String[]{"drawString", "drawChars", "drawBytes", "drawGlyphVector", "TextLayout.draw", "GlyphVector.getOutline", "TextLayout.getOutline"};
    public final int RANGE_TEXT = 0;
    public final int ALL_GLYPHS = 1;
    public final int USER_TEXT = 2;
    public final int FILE_TEXT = 3;
    private final String[] MS_OPENING = new String[]{" Unicode ", " Glyph Code ", " lines ", " lines "};
    private final String[] MS_CLOSING = new String[]{"", "", " of User Text ", " of LineBreakMeasurer-reformatted Text "};
    private final JScrollBar verticalBar;
    private final FontCanvas fc;
    private boolean updateFontMetrics = true;
    private boolean updateFont = true;
    private boolean force16Cols = false;
    public boolean showingError = false;
    private int g2Transform = 0;
    public final int ONE_PAGE = 0;
    public final int CUR_RANGE = 1;
    public final int ALL_TEXT = 2;
    private int printMode = 0;
    private PageFormat page = null;
    private PrinterJob printer = null;
    private String fontName = "Dialog";
    private float fontSize = 12.0f;
    private int fontStyle = 0;
    private int fontTransform = 0;
    private Font testFont = null;
    private Object antiAliasType = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
    private Object fractionalMetricsType = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    private Object lcdContrast = FontPanel.getDefaultLCDContrast();
    private int drawMethod = 0;
    private int textToUse = 0;
    private String[] userText = null;
    private String[] fileText = null;
    private int[] drawRange = new int[]{0, 127};
    private String[] fontInfos = new String[2];
    private boolean showGrid = true;
    private final Font2DTest f2dt;
    private final JFrame parent;
    private static Integer defaultContrast;

    public FontPanel(Font2DTest demo, JFrame f) {
        this.f2dt = demo;
        this.parent = f;
        this.verticalBar = new JScrollBar(1);
        this.fc = new FontCanvas(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.fc);
        this.add("East", this.verticalBar);
        this.verticalBar.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ FontPanel this$0;
            {
                FontPanel fontPanel = this$0;
                Objects.requireNonNull(fontPanel);
                this.this$0 = fontPanel;
            }

            @Override
            public void componentResized(ComponentEvent e) {
                this.this$0.updateFontMetrics = true;
            }
        });
        this.testFont = new Font(this.fontName, this.fontStyle, (int)this.fontSize);
        if ((float)((int)this.fontSize) != this.fontSize) {
            this.testFont = this.testFont.deriveFont(this.fontSize);
        }
        this.updateFontInfo();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    public void setTransformG2(int transform) {
        this.g2Transform = transform;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    private AffineTransform getAffineTransform(int transform) {
        AffineTransform at = new AffineTransform();
        switch (transform) {
            case 1: {
                at.setToScale(1.5, 1.5);
                break;
            }
            case 3: {
                at.setToRotation(0.5235987755982988);
                break;
            }
            case 2: {
                at.setToShear(0.4f, 0.0);
                break;
            }
            case 0: {
                break;
            }
        }
        return at;
    }

    public void setFontParams(Object obj, float size, int style, int transform) {
        this.setFontParams((String)obj, size, style, transform);
    }

    public void setFontParams(String name, float size, int style, int transform) {
        boolean fontModified = false;
        if (!name.equals(this.fontName) || style != this.fontStyle) {
            fontModified = true;
        }
        this.fontName = name;
        this.fontSize = size;
        this.fontStyle = style;
        this.fontTransform = transform;
        this.testFont = new Font(this.fontName, this.fontStyle, (int)this.fontSize);
        if ((float)((int)this.fontSize) != this.fontSize) {
            this.testFont = this.testFont.deriveFont(this.fontSize);
        }
        if (this.fontTransform != 0) {
            AffineTransform at = this.getAffineTransform(this.fontTransform);
            this.testFont = this.testFont.deriveFont(at);
        }
        this.updateFontMetrics = true;
        this.fc.repaint();
        if (fontModified) {
            this.updateFontInfo();
            this.f2dt.fireUpdateFontInfo();
        }
    }

    public void setRenderingHints(Object aa, Object fm, Object contrast) {
        this.antiAliasType = ((AAValues)((Object)aa)).getHint();
        this.fractionalMetricsType = ((FMValues)((Object)fm)).getHint();
        this.lcdContrast = contrast;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void setDrawMethod(int i) {
        this.drawMethod = i;
        this.fc.repaint();
    }

    public void setTextToDraw(int i, int[] range, String[] textSet, String[] fileData) {
        this.textToUse = i;
        if (this.textToUse == 0) {
            this.drawRange = range;
        } else if (this.textToUse == 1) {
            this.drawMethod = 3;
        } else if (this.textToUse == 2) {
            this.userText = textSet;
        } else if (this.textToUse == 3) {
            this.fileText = fileData;
            this.drawMethod = 4;
        }
        this.updateFontMetrics = true;
        this.fc.repaint();
        this.updateFontInfo();
    }

    public void setGridDisplay(boolean b) {
        this.showGrid = b;
        this.fc.repaint();
    }

    public void setForce16Columns(boolean b) {
        this.force16Cols = b;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void doPrint(int i) {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.printMode = i;
        this.printer.setPrintable(this.fc, this.page);
        if (this.printer.printDialog()) {
            try {
                this.printer.print();
            }
            catch (Exception e) {
                this.f2dt.fireChangeStatus("ERROR: Printing Failed; See Stack Trace", true);
            }
        }
    }

    public void doPageSetup() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.page = this.printer.pageDialog(this.page);
    }

    private void updateFontInfo() {
        int numGlyphs = 0;
        int numCharsInRange = this.drawRange[1] - this.drawRange[0] + 1;
        this.fontInfos[0] = "Font Face Name: " + this.testFont.getFontName();
        this.fontInfos[1] = "Glyphs in This Range: ";
        if (this.textToUse == 0) {
            for (int i = this.drawRange[0]; i < this.drawRange[1]; ++i) {
                if (!this.testFont.canDisplay(i)) continue;
                ++numGlyphs;
            }
            this.fontInfos[1] = this.fontInfos[1] + numGlyphs + " / " + numCharsInRange;
        } else {
            this.fontInfos[1] = null;
        }
    }

    public String[] getFontInfo() {
        return this.fontInfos;
    }

    public String getCurrentOptions() {
        boolean userTextSize = false;
        String options = this.fontName + "\n" + this.fontSize + "\n" + this.fontStyle + "\n" + this.fontTransform + "\n" + this.g2Transform + "\n" + this.textToUse + "\n" + this.drawMethod + "\n" + AAValues.getHintVal(this.antiAliasType) + "\n" + FMValues.getHintVal(this.fractionalMetricsType) + "\n" + String.valueOf(this.lcdContrast) + "\n";
        if (this.textToUse == 2) {
            for (int i = 0; i < this.userText.length; ++i) {
                options = options + this.userText[i] + "\n";
            }
        }
        return options;
    }

    public void loadOptions(boolean grid, boolean force16, int start, int end, String name, float size, int style, int transform, int g2transform, int text, int method, int aa, int fm, int contrast, String[] user) {
        int[] range = new int[]{start, end};
        this.setGridDisplay(grid);
        this.setForce16Columns(force16);
        if (this.textToUse != 3) {
            this.setTextToDraw(text, range, user, null);
        }
        this.setFontParams(name, size, style, transform);
        this.setTransformG2(g2transform);
        this.setDrawMethod(method);
        this.setRenderingHints(AAValues.getValue(aa), FMValues.getValue(fm), contrast);
    }

    public void doSavePNG(String fileName) {
        this.fc.writePNG(fileName);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.fc.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.fc.repaint();
    }

    static Integer getDefaultLCDContrast() {
        if (defaultContrast == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Graphics2D g2d = (Graphics2D)gc.createCompatibleImage(1, 1).getGraphics();
            defaultContrast = (Integer)g2d.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
        }
        return defaultContrast;
    }

    private class FontCanvas
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    Printable {
        private int numCharAcross;
        private int numCharDown;
        private int drawStart;
        private int drawEnd;
        private int drawLimit;
        private int maxAscent;
        private int maxDescent;
        private int gridWidth;
        private int gridHeight;
        private int canvasInset_X;
        private int canvasInset_Y;
        private Vector<TextLayout> lineBreakTLs;
        private boolean isPrinting;
        private int lastPage;
        private int printPageNumber;
        private int currentlyShownChar;
        private final int PR_OFFSET = 10;
        private final int PR_TITLE_LINEHEIGHT = 30;
        private final JWindow zoomWindow;
        private BufferedImage zoomImage;
        private int mouseOverCharX;
        private int mouseOverCharY;
        private int currMouseOverChar;
        private int prevZoomChar;
        private float ZOOM;
        private boolean nowZooming;
        private boolean firstTime;
        private String backupStatusString;
        private final String[] ERRORS;
        private final int DRAW_BYTES_ERROR = 0;
        private final int CANT_FIT_DRAW = 1;
        private final int CANT_FIT_PRINT = 2;
        private final Cursor blankCursor;
        final /* synthetic */ FontPanel this$0;

        public FontCanvas(FontPanel fontPanel) {
            FontPanel fontPanel2 = fontPanel;
            Objects.requireNonNull(fontPanel2);
            this.this$0 = fontPanel2;
            this.gridWidth = 0;
            this.gridHeight = 0;
            this.canvasInset_X = 5;
            this.canvasInset_Y = 5;
            this.lineBreakTLs = null;
            this.isPrinting = false;
            this.currentlyShownChar = 0;
            this.PR_OFFSET = 10;
            this.PR_TITLE_LINEHEIGHT = 30;
            this.zoomImage = null;
            this.mouseOverCharX = -1;
            this.mouseOverCharY = -1;
            this.currMouseOverChar = -1;
            this.prevZoomChar = -1;
            this.ZOOM = 2.0f;
            this.nowZooming = false;
            this.firstTime = true;
            this.backupStatusString = null;
            this.ERRORS = new String[]{"ERROR: drawBytes cannot handle characters beyond 0x00FF. Select different range or draw methods.", "ERROR: Cannot fit text with the current font size. Resize the window or use smaller font size.", "ERROR: Cannot print with the current font size. Use smaller font size."};
            this.DRAW_BYTES_ERROR = 0;
            this.CANT_FIT_DRAW = 1;
            this.CANT_FIT_PRINT = 2;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            Toolkit tk = Toolkit.getDefaultToolkit();
            byte[] bogus = new byte[]{0};
            this.blankCursor = tk.createCustomCursor(tk.createImage(bogus), new Point(0, 0), "");
            this.zoomWindow = new JWindow(this, fontPanel.parent){
                final /* synthetic */ FontCanvas this$1;
                {
                    FontCanvas fontCanvas = this$1;
                    Objects.requireNonNull(fontCanvas);
                    this.this$1 = fontCanvas;
                    super(arg0);
                }

                @Override
                public void paint(Graphics g) {
                    g.drawImage(this.this$1.zoomImage, 0, 0, this.this$1.zoomWindow);
                }
            };
            this.zoomWindow.setCursor(this.blankCursor);
            this.zoomWindow.pack();
        }

        public boolean firstTime() {
            return this.firstTime;
        }

        public void refresh() {
            this.firstTime = false;
            this.repaint();
        }

        private void setParams(Graphics2D g2) {
            g2.setFont(this.this$0.testFont);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.this$0.antiAliasType);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, this.this$0.fractionalMetricsType);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, this.this$0.lcdContrast);
            if (this.this$0.antiAliasType == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && (this.this$0.drawMethod == 6 || this.this$0.drawMethod == 5)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }

        private void drawGrid(Graphics2D g2) {
            int i;
            int totalGridWidth = this.numCharAcross * this.gridWidth;
            int totalGridHeight = this.numCharDown * this.gridHeight;
            g2.setColor(Color.black);
            for (i = 0; i < this.numCharDown + 1; ++i) {
                g2.drawLine(this.canvasInset_X, i * this.gridHeight + this.canvasInset_Y, this.canvasInset_X + totalGridWidth, i * this.gridHeight + this.canvasInset_Y);
            }
            for (i = 0; i < this.numCharAcross + 1; ++i) {
                g2.drawLine(i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y, i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y + totalGridHeight);
            }
        }

        public void modeSpecificDrawChar(Graphics2D g2, int charCode, int baseX, int baseY) {
            int[] oneGlyph = new int[]{charCode};
            char[] charArray = Character.toChars(charCode);
            FontRenderContext frc = g2.getFontRenderContext();
            AffineTransform oldTX = g2.getTransform();
            GlyphVector gv = this.this$0.textToUse == 1 ? this.this$0.testFont.createGlyphVector(frc, oneGlyph) : this.this$0.testFont.createGlyphVector(frc, charArray);
            Rectangle2D r2d2 = gv.getPixelBounds(frc, 0.0f, 0.0f);
            int shiftedX = baseX;
            try {
                double[] pt = new double[]{r2d2.getX(), r2d2.getY(), r2d2.getX() + r2d2.getWidth(), r2d2.getY() + r2d2.getHeight()};
                oldTX.inverseTransform(pt, 0, pt, 0, 2);
                shiftedX = baseX - (int)(pt[2] / 2.0 + pt[0]);
            }
            catch (NoninvertibleTransformException pt) {
                // empty catch block
            }
            g2.translate(shiftedX, baseY);
            g2.transform(this.this$0.getAffineTransform(this.this$0.g2Transform));
            if (this.this$0.textToUse == 1) {
                g2.drawGlyphVector(gv, 0.0f, 0.0f);
            } else {
                if (this.this$0.testFont.canDisplay(charCode)) {
                    g2.setColor(Color.black);
                } else {
                    g2.setColor(Color.lightGray);
                }
                switch (this.this$0.drawMethod) {
                    case 0: {
                        g2.drawString(new String(charArray), 0, 0);
                        break;
                    }
                    case 1: {
                        g2.drawChars(charArray, 0, 1, 0, 0);
                        break;
                    }
                    case 2: {
                        if (charCode > 255) {
                            throw new CannotDrawException(this.this$0, 0);
                        }
                        byte[] oneByte = new byte[]{(byte)charCode};
                        g2.drawBytes(oneByte, 0, 1, 0, 0);
                        break;
                    }
                    case 3: {
                        g2.drawGlyphVector(gv, 0.0f, 0.0f);
                        break;
                    }
                    case 4: {
                        TextLayout tl = new TextLayout(new String(charArray), this.this$0.testFont, frc);
                        tl.draw(g2, 0.0f, 0.0f);
                        break;
                    }
                    case 5: {
                        r2d2 = gv.getVisualBounds();
                        shiftedX = baseX - (int)(r2d2.getWidth() / 2.0 + r2d2.getX());
                        g2.draw(gv.getOutline(0.0f, 0.0f));
                        break;
                    }
                    case 6: {
                        r2d2 = gv.getVisualBounds();
                        shiftedX = baseX - (int)(r2d2.getWidth() / 2.0 + r2d2.getX());
                        TextLayout tlo = new TextLayout(new String(charArray), this.this$0.testFont, g2.getFontRenderContext());
                        g2.draw(tlo.getOutline(null));
                    }
                }
            }
            g2.setTransform(oldTX);
        }

        private void modeSpecificDrawLine(Graphics2D g2, String line, int baseX, int baseY) {
            AffineTransform oldTx = null;
            oldTx = g2.getTransform();
            g2.translate(baseX, baseY);
            g2.transform(this.this$0.getAffineTransform(this.this$0.g2Transform));
            switch (this.this$0.drawMethod) {
                case 0: {
                    g2.drawString(line, 0, 0);
                    break;
                }
                case 1: {
                    g2.drawChars(line.toCharArray(), 0, line.length(), 0, 0);
                    break;
                }
                case 2: {
                    try {
                        byte[] lineBytes = line.getBytes(StandardCharsets.ISO_8859_1);
                        g2.drawBytes(lineBytes, 0, lineBytes.length, 0, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    GlyphVector gv = this.this$0.testFont.createGlyphVector(g2.getFontRenderContext(), line);
                    g2.drawGlyphVector(gv, 0.0f, 0.0f);
                    break;
                }
                case 4: {
                    TextLayout tl = new TextLayout(line, this.this$0.testFont, g2.getFontRenderContext());
                    tl.draw(g2, 0.0f, 0.0f);
                    break;
                }
                case 5: {
                    GlyphVector gvo = this.this$0.testFont.createGlyphVector(g2.getFontRenderContext(), line);
                    g2.draw(gvo.getOutline(0.0f, 0.0f));
                    break;
                }
                case 6: {
                    TextLayout tlo = new TextLayout(line, this.this$0.testFont, g2.getFontRenderContext());
                    AffineTransform at = new AffineTransform();
                    g2.draw(tlo.getOutline(at));
                }
            }
            g2.setTransform(oldTx);
        }

        private void tlDrawLine(Graphics2D g2, TextLayout tl, float baseX, float baseY) {
            AffineTransform oldTx = null;
            oldTx = g2.getTransform();
            g2.translate(baseX, baseY);
            g2.transform(this.this$0.getAffineTransform(this.this$0.g2Transform));
            tl.draw(g2, 0.0f, 0.0f);
            g2.setTransform(oldTx);
        }

        private String modeSpecificNumStr(int i) {
            if (this.this$0.textToUse == 2 || this.this$0.textToUse == 3) {
                return String.valueOf(i + 1);
            }
            StringBuffer s = new StringBuffer(Integer.toHexString(i));
            while (s.length() < 4) {
                s.insert(0, "0");
            }
            return s.toString().toUpperCase();
        }

        private void resetScrollbar(int oldValue) {
            int totalNumRows = 1;
            if (this.this$0.textToUse == 0 || this.this$0.textToUse == 1) {
                int numCharToDisplay = this.this$0.textToUse == 0 ? this.this$0.drawRange[1] - this.this$0.drawRange[0] : this.this$0.testFont.getNumGlyphs();
                totalNumRows = numCharToDisplay / this.numCharAcross;
                if (numCharToDisplay % this.numCharAcross != 0) {
                    ++totalNumRows;
                }
                if (oldValue / this.numCharAcross > totalNumRows) {
                    oldValue = 0;
                }
                this.this$0.verticalBar.setValues(oldValue / this.numCharAcross, this.numCharDown, 0, totalNumRows);
            } else {
                totalNumRows = this.this$0.textToUse == 2 ? this.this$0.userText.length : this.lineBreakTLs.size();
                this.this$0.verticalBar.setValues(oldValue, this.numCharDown, 0, totalNumRows);
            }
            if (totalNumRows <= this.numCharDown && this.drawStart == 0) {
                this.this$0.verticalBar.setEnabled(true);
            } else {
                this.this$0.verticalBar.setEnabled(true);
            }
        }

        private void calcFontMetrics(Graphics2D g2d, int w, int h) {
            FontMetrics fm;
            Graphics2D g2 = (Graphics2D)g2d.create();
            if (this.this$0.g2Transform != 0 && this.this$0.textToUse != 3) {
                g2.setFont(g2.getFont().deriveFont(this.this$0.getAffineTransform(this.this$0.g2Transform)));
                fm = g2.getFontMetrics();
            } else {
                fm = g2.getFontMetrics();
            }
            this.maxAscent = fm.getMaxAscent();
            this.maxDescent = fm.getMaxDescent();
            if (this.maxAscent == 0) {
                this.maxAscent = 10;
            }
            if (this.maxDescent == 0) {
                this.maxDescent = 5;
            }
            if (this.this$0.textToUse == 0 || this.this$0.textToUse == 1) {
                this.maxAscent += 3;
                this.maxDescent += 3;
                this.gridWidth = fm.getMaxAdvance() + 6;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharAcross = this.this$0.force16Cols ? 16 : (w - 10) / this.gridWidth;
                this.numCharDown = (h - 10) / this.gridHeight;
                this.canvasInset_X = (w - this.numCharAcross * this.gridWidth) / 2;
                this.canvasInset_Y = (h - this.numCharDown * this.gridHeight) / 2;
                if (this.numCharDown == 0 || this.numCharAcross == 0) {
                    throw new CannotDrawException(this.this$0, this.isPrinting ? 2 : 1);
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(this.this$0.verticalBar.getValue() * this.numCharAcross);
                }
            } else {
                this.maxDescent += fm.getLeading();
                this.canvasInset_X = 5;
                this.canvasInset_Y = 5;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharDown = (h - this.canvasInset_Y * 2) / this.gridHeight;
                if (this.numCharDown == 0) {
                    throw new CannotDrawException(this.this$0, this.isPrinting ? 2 : 1);
                }
                if (this.this$0.textToUse == 3) {
                    if (!this.isPrinting) {
                        this.this$0.f2dt.fireChangeStatus("LineBreaking Text... Please Wait", false);
                    }
                    this.lineBreakTLs = new Vector();
                    for (int i = 0; i < this.this$0.fileText.length; ++i) {
                        AttributedString as = new AttributedString(this.this$0.fileText[i], g2.getFont().getAttributes());
                        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g2.getFontRenderContext());
                        while (lbm.getPosition() < this.this$0.fileText[i].length()) {
                            this.lineBreakTLs.add(lbm.nextLayout(w));
                        }
                    }
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(this.this$0.verticalBar.getValue());
                }
            }
        }

        private void calcTextRange() {
            Object displaying = null;
            if (this.this$0.textToUse == 0 || this.this$0.textToUse == 1) {
                this.drawStart = this.isPrinting ? (this.this$0.printMode == 0 ? this.currentlyShownChar : this.numCharAcross * this.numCharDown * this.printPageNumber) : this.this$0.verticalBar.getValue() * this.numCharAcross;
                if (this.this$0.textToUse == 0) {
                    this.drawStart += this.this$0.drawRange[0];
                    this.drawLimit = this.this$0.drawRange[1];
                } else {
                    this.drawLimit = this.this$0.testFont.getNumGlyphs();
                }
                this.drawEnd = this.drawStart + this.numCharAcross * this.numCharDown - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            } else {
                this.drawStart = this.isPrinting ? (this.this$0.printMode == 0 ? this.currentlyShownChar : this.numCharDown * this.printPageNumber) : this.this$0.verticalBar.getValue();
                this.drawEnd = this.drawStart + this.numCharDown - 1;
                this.drawLimit = this.this$0.textToUse == 2 ? this.this$0.userText.length - 1 : this.lineBreakTLs.size() - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            }
            if (this.drawStart > this.drawEnd) {
                this.drawStart = 0;
                this.this$0.verticalBar.setValue(this.drawStart);
            }
            if (!this.isPrinting) {
                this.backupStatusString = "Displaying" + this.this$0.MS_OPENING[this.this$0.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + this.this$0.MS_CLOSING[this.this$0.textToUse];
                this.this$0.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        private void drawText(Graphics g, int w, int h) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.white);
            g2.fillRect(0, 0, w, h);
            g2.setColor(Color.black);
            this.setParams(g2);
            if (this.this$0.updateFontMetrics || this.isPrinting) {
                this.calcFontMetrics(g2, w, h);
                this.this$0.updateFontMetrics = false;
            }
            this.calcTextRange();
            if (this.this$0.textToUse == 0 || this.this$0.textToUse == 1) {
                int charToDraw = this.drawStart;
                if (this.this$0.showGrid) {
                    this.drawGrid(g2);
                }
                for (int i = 0; i < this.numCharDown && charToDraw <= this.drawEnd; ++i) {
                    for (int j = 0; j < this.numCharAcross && charToDraw <= this.drawEnd; ++j, ++charToDraw) {
                        int gridLocX = j * this.gridWidth + this.canvasInset_X;
                        int gridLocY = i * this.gridHeight + this.canvasInset_Y;
                        this.modeSpecificDrawChar(g2, charToDraw, gridLocX + this.gridWidth / 2, gridLocY + this.maxAscent);
                    }
                }
            } else if (this.this$0.textToUse == 2) {
                g2.drawRect(0, 0, w - 1, h - 1);
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    int lineStartX = this.canvasInset_Y;
                    int lineStartY = (i - this.drawStart) * this.gridHeight + this.maxAscent;
                    this.modeSpecificDrawLine(g2, this.this$0.userText[i], lineStartX, lineStartY);
                }
            } else {
                float yPos = this.canvasInset_Y;
                g2.drawRect(0, 0, w - 1, h - 1);
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    TextLayout oneLine = this.lineBreakTLs.elementAt(i);
                    float xPos = oneLine.isLeftToRight() ? (float)this.canvasInset_X : (float)w - oneLine.getAdvance() - (float)this.canvasInset_X;
                    float[] fmData = new float[]{0.0f, oneLine.getAscent(), 0.0f, oneLine.getDescent(), 0.0f, oneLine.getLeading()};
                    if (this.this$0.g2Transform != 0) {
                        AffineTransform at = this.this$0.getAffineTransform(this.this$0.g2Transform);
                        at.transform(fmData, 0, fmData, 0, 3);
                    }
                    this.tlDrawLine(g2, oneLine, xPos, yPos += fmData[1]);
                    yPos += fmData[3] + fmData[5];
                }
            }
            g2.dispose();
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Dimension d = this.getSize();
            this.isPrinting = false;
            try {
                this.drawText(g, d.width, d.height);
            }
            catch (CannotDrawException e) {
                super.paintComponent(g);
                this.this$0.f2dt.fireChangeStatus(this.ERRORS[e.id], true);
                return;
            }
            this.this$0.showingError = false;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int pageIndex) {
            if (pageIndex == 0) {
                this.lastPage = Integer.MAX_VALUE;
                this.currentlyShownChar = this.this$0.verticalBar.getValue() * this.numCharAcross;
            }
            if (this.this$0.printMode == 0 ? pageIndex > 0 : pageIndex > this.lastPage) {
                return 1;
            }
            int pageWidth = (int)pf.getImageableWidth();
            int pageHeight = (int)pf.getImageableHeight();
            int backupDrawStart = this.drawStart;
            int backupDrawEnd = this.drawEnd;
            int backupNumCharAcross = this.numCharAcross;
            int backupNumCharDown = this.numCharDown;
            Vector<TextLayout> backupLineBreakTLs = null;
            if (this.this$0.textToUse == 3) {
                backupLineBreakTLs = new Vector<TextLayout>(this.lineBreakTLs);
            }
            this.printPageNumber = pageIndex;
            this.isPrinting = true;
            g.translate((int)pf.getImageableX(), (int)pf.getImageableY() + 60);
            try {
                this.drawText(g, pageWidth, pageHeight - 60);
            }
            catch (CannotDrawException e) {
                this.this$0.f2dt.fireChangeStatus(this.ERRORS[e.id], true);
                return 1;
            }
            String hints = " with antialias " + String.valueOf(this.this$0.antiAliasType) + "and fractional metrics " + String.valueOf(this.this$0.fractionalMetricsType) + " and lcd contrast = " + String.valueOf(this.this$0.lcdContrast);
            String infoLine1 = "Printing" + this.this$0.MS_OPENING[this.this$0.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + this.this$0.MS_CLOSING[this.this$0.textToUse];
            String infoLine2 = "With " + this.this$0.fontName + " " + this.this$0.STYLES[this.this$0.fontStyle] + " at " + this.this$0.fontSize + " point size " + this.this$0.TRANSFORMS[this.this$0.fontTransform];
            String infoLine3 = "Using " + this.this$0.METHODS[this.this$0.drawMethod] + hints;
            String infoLine4 = "Page: " + (pageIndex + 1);
            g.setFont(new Font("dialog", 0, 12));
            g.setColor(Color.black);
            g.translate(0, -60);
            g.drawString(infoLine1, 15, 10);
            g.drawString(infoLine2, 15, 22);
            g.drawString(infoLine3, 15, 34);
            g.drawString(infoLine4, 15, 46);
            if (this.drawEnd == this.drawLimit) {
                this.lastPage = pageIndex;
            }
            this.drawStart = backupDrawStart;
            this.drawEnd = backupDrawEnd;
            this.numCharAcross = backupNumCharAcross;
            this.numCharDown = backupNumCharDown;
            if (this.this$0.textToUse == 3) {
                this.lineBreakTLs = backupLineBreakTLs;
            }
            return 0;
        }

        public void writePNG(String fileName) {
            try {
                int w = this.getSize().width;
                int h = this.getSize().height;
                BufferedImage buffer = (BufferedImage)this.createImage(w, h);
                Graphics2D g2 = buffer.createGraphics();
                g2.setColor(Color.white);
                g2.fillRect(0, 0, w, h);
                g2.setColor(Color.black);
                this.this$0.updateFontMetrics = true;
                this.drawText(g2, w, h);
                this.this$0.updateFontMetrics = true;
                ImageIO.write((RenderedImage)buffer, "png", new File(fileName));
            }
            catch (Exception e) {
                this.this$0.f2dt.fireChangeStatus("ERROR: Failed to Save PNG image; See stack trace", true);
                e.printStackTrace();
            }
        }

        private boolean checkMouseLoc(MouseEvent e) {
            if (this.gridWidth != 0 && this.gridHeight != 0 && (this.this$0.textToUse == 0 || this.this$0.textToUse == 1)) {
                int charLocX = (e.getX() - this.canvasInset_X) / this.gridWidth;
                int charLocY = (e.getY() - this.canvasInset_Y) / this.gridHeight;
                if (charLocX >= 0 && charLocY >= 0 && charLocX < this.numCharAcross && charLocY < this.numCharDown) {
                    int mouseOverChar = charLocX + (this.this$0.verticalBar.getValue() + charLocY) * this.numCharAcross;
                    if (this.this$0.textToUse == 0) {
                        mouseOverChar += this.this$0.drawRange[0];
                    }
                    if (mouseOverChar > this.drawEnd) {
                        return false;
                    }
                    this.mouseOverCharX = charLocX;
                    this.mouseOverCharY = charLocY;
                    this.currMouseOverChar = mouseOverChar;
                    this.this$0.f2dt.fireChangeStatus("Pointing to" + this.this$0.MS_OPENING[this.this$0.textToUse] + this.modeSpecificNumStr(mouseOverChar), false);
                    return true;
                }
            }
            return false;
        }

        public void showZoomed() {
            Font backup = this.this$0.testFont;
            Point canvasLoc = this.getLocationOnScreen();
            int dialogOffsetX = (int)((float)this.gridWidth * (this.ZOOM - 1.0f) / 2.0f);
            int dialogOffsetY = (int)((float)this.gridHeight * (this.ZOOM - 1.0f) / 2.0f);
            int zoomAreaX = this.mouseOverCharX * this.gridWidth + this.canvasInset_X - dialogOffsetX;
            int zoomAreaY = this.mouseOverCharY * this.gridHeight + this.canvasInset_Y - dialogOffsetY;
            int zoomAreaWidth = (int)((float)this.gridWidth * this.ZOOM);
            int zoomAreaHeight = (int)((float)this.gridHeight * this.ZOOM);
            this.zoomWindow.setLocation(canvasLoc.x + zoomAreaX, canvasLoc.y + zoomAreaY);
            if (!this.nowZooming) {
                this.zoomWindow.setSize(zoomAreaWidth + 1, zoomAreaHeight + 1);
            }
            this.zoomImage = (BufferedImage)this.zoomWindow.createImage(zoomAreaWidth + 1, zoomAreaHeight + 1);
            Graphics2D g2 = (Graphics2D)this.zoomImage.getGraphics();
            this.this$0.testFont = this.this$0.testFont.deriveFont(this.this$0.fontSize * this.ZOOM);
            this.setParams(g2);
            g2.setColor(Color.white);
            g2.fillRect(0, 0, zoomAreaWidth, zoomAreaHeight);
            g2.setColor(Color.black);
            g2.drawRect(0, 0, zoomAreaWidth, zoomAreaHeight);
            this.modeSpecificDrawChar(g2, this.currMouseOverChar, zoomAreaWidth / 2, (int)((float)this.maxAscent * this.ZOOM));
            g2.dispose();
            if (!this.nowZooming) {
                this.zoomWindow.setVisible(true);
            }
            this.zoomWindow.getGraphics().drawImage(this.zoomImage, 0, 0, this);
            this.nowZooming = true;
            this.prevZoomChar = this.currMouseOverChar;
            this.this$0.testFont = backup;
            if (this.firstTime()) {
                this.refresh();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!this.this$0.showingError && this.checkMouseLoc(e)) {
                this.showZoomed();
                this.setCursor(this.blankCursor);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.this$0.textToUse == 0 || this.this$0.textToUse == 1) {
                if (this.nowZooming) {
                    this.zoomWindow.setVisible(false);
                }
                this.nowZooming = false;
            }
            this.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.this$0.showingError && !this.nowZooming) {
                this.this$0.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!this.this$0.showingError && !this.checkMouseLoc(e)) {
                this.this$0.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.this$0.showingError && this.nowZooming && this.checkMouseLoc(e) && this.currMouseOverChar != this.prevZoomChar) {
                this.showZoomed();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }
    }

    static enum AAValues {
        AADEFAULT("DEFAULT", RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT),
        AAOFF("OFF", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF),
        AAON("ON", RenderingHints.VALUE_TEXT_ANTIALIAS_ON),
        AAGASP("GASP", RenderingHints.VALUE_TEXT_ANTIALIAS_GASP),
        AALCDHRGB("LCD_HRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB),
        AALCDHBGR("LCD_HBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR),
        AALCDVRGB("LCD_VRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB),
        AALCDVBGR("LCD_VBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);

        private String name;
        private Object hint;
        private static AAValues[] valArray;

        private AAValues(String s, Object o) {
            this.name = s;
            this.hint = o;
        }

        public String toString() {
            return this.name;
        }

        public Object getHint() {
            return this.hint;
        }

        public static boolean isLCDMode(Object o) {
            return o instanceof AAValues && ((AAValues)((Object)o)).ordinal() >= AALCDHRGB.ordinal();
        }

        public static Object getValue(int ordinal) {
            if (valArray == null) {
                valArray = AAValues.values();
            }
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].ordinal() != ordinal) continue;
                return valArray[i];
            }
            return valArray[0];
        }

        private static AAValues[] getArray() {
            if (valArray == null) {
                valArray = AAValues.values();
            }
            return valArray;
        }

        public static int getHintVal(Object hint) {
            AAValues.getArray();
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].getHint() != hint) continue;
                return i;
            }
            return 0;
        }
    }

    static enum FMValues {
        FMDEFAULT("DEFAULT", RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT),
        FMOFF("OFF", RenderingHints.VALUE_FRACTIONALMETRICS_OFF),
        FMON("ON", RenderingHints.VALUE_FRACTIONALMETRICS_ON);

        private String name;
        private Object hint;
        private static FMValues[] valArray;

        private FMValues(String s, Object o) {
            this.name = s;
            this.hint = o;
        }

        public String toString() {
            return this.name;
        }

        public Object getHint() {
            return this.hint;
        }

        public static Object getValue(int ordinal) {
            if (valArray == null) {
                valArray = FMValues.values();
            }
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].ordinal() != ordinal) continue;
                return valArray[i];
            }
            return valArray[0];
        }

        private static FMValues[] getArray() {
            if (valArray == null) {
                valArray = FMValues.values();
            }
            return valArray;
        }

        public static int getHintVal(Object hint) {
            FMValues.getArray();
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].getHint() != hint) continue;
                return i;
            }
            return 0;
        }
    }

    private final class CannotDrawException
    extends RuntimeException {
        public final int id;
        final /* synthetic */ FontPanel this$0;

        public CannotDrawException(FontPanel fontPanel, int i) {
            FontPanel fontPanel2 = fontPanel;
            Objects.requireNonNull(fontPanel2);
            this.this$0 = fontPanel2;
            this.id = i;
        }
    }
}

