/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.LinkArg;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.decoration.LinkDecor;
import net.sourceforge.plantuml.decoration.LinkType;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.decoration.symbol.USymbols;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.descdiagram.command.Labels;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.skin.ActorStyle;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.stereo.StereotypePattern;
import net.sourceforge.plantuml.utils.Direction;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandLinkElement
extends SingleLineCommand2<DescriptionDiagram> {
    private static final String KEY1 = "dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+";
    private static final String UBREX_KEY1 = "dotted\u2507dashed\u2507plain\u2507bold\u2507hidden\u2507norank\u2507single\u2507thickness=\u3007+\u3034d";
    private static final String KEY2 = ",dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+";
    private static final String UBREX_KEY2 = ",dotted\u2507,dashed\u2507,plain\u2507,bold\u2507,hidden\u2507,norank\u2507,single\u2507,thickness=\u3007+\u3034d";
    public static final String LINE_STYLE = "(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*";
    public static final String UBREX_LINE_STYLE = "\u3010 #\u3007+\u3034w \u2507dotted\u2507dashed\u2507plain\u2507bold\u2507hidden\u2507norank\u2507single\u2507thickness=\u3007+\u3034d\u3011 \u3007*\u3010 ,#\u3007+\u3034w \u2507,dotted\u2507,dashed\u2507,plain\u2507,bold\u2507,hidden\u2507,norank\u2507,single\u2507,thickness=\u3007+\u3034d\u3011";
    private static final String LINE_STYLE_MUTILPLES = "(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)";
    public static final String STYLE_COLORS_MULTIPLES = "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->";

    public CommandLinkElement() {
        super(CommandLinkElement.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkElement.class.getName(), RegexLeaf.start(), CommandLinkElement.getGroup("ENT1"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "FIRST_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "HEAD1", LinkDecor.getRegexDecors1()), new RegexLeaf(1, "BODY1", "([-=.~]+)"), new RegexLeaf(1, "ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*))\\])?"), new RegexOptional((IRegex)new RegexLeaf(1, "DIRECTION", "(left|right|up|down|le?|ri?|up?|do?)(?=[-=.~0()\\[])")), new RegexOptional((IRegex)new RegexLeaf(1, "INSIDE", "(0|\\(0\\)|\\(0|0\\))(?=[-=.~])")), new RegexLeaf(1, "ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf(1, "BODY2", "([-=.~]*)"), new RegexLeaf(1, "HEAD2", LinkDecor.getRegexDecors2()), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "SECOND_LABEL", "[%g]([^%g]+)[%g]")), RegexLeaf.spaceZeroOrMore(), CommandLinkElement.getGroup("ENT2"), RegexLeaf.spaceZeroOrMore(), CommandLinkElement.color().getRegex(), StereotypePattern.optional("STEREOTYPE"), new RegexLeaf(1, "LABEL_LINK", "(?::[%s]*(.+))?"), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private String getHead(RegexResult arg, String key) {
        String result = arg.get(key, 0);
        result = CommandLinkElement.trimAndLowerCase(result);
        return result.replace("_", "");
    }

    private LinkType getLinkType(RegexResult arg) {
        String head1 = this.getHead(arg, "HEAD1");
        String head2 = this.getHead(arg, "HEAD2");
        LinkDecor d1 = LinkDecor.lookupDecors1(head1);
        LinkDecor d2 = LinkDecor.lookupDecors2(head2);
        LinkType result = new LinkType(d2, d1);
        String queue = this.getQueue(arg);
        if (queue.contains(".")) {
            result = result.goDashed();
        } else if (queue.contains("~")) {
            result = result.goDotted();
        } else if (queue.contains("=")) {
            result = result.goBold();
        }
        String middle = arg.get("INSIDE", 0);
        if ("0".equals(middle)) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private static String trimAndLowerCase(String s) {
        if (s == null) {
            return "";
        }
        return StringUtils.goLowerCase(StringUtils.trin(s));
    }

    private Direction getDirection(RegexResult arg) {
        String dir = arg.get("DIRECTION", 0);
        if (dir == null) {
            return StringUtils.getQueueDirection(this.getQueue(arg));
        }
        return StringUtils.getQueueDirection(dir);
    }

    private String getQueue(RegexResult arg) {
        return arg.get("BODY1", 0) + arg.get("BODY2", 0);
    }

    private static RegexLeaf getGroup(String name) {
        return new RegexLeaf(1, name, "([%pLN_.]+|[%g][^%g]+[%g]|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|(?!\\[\\*\\])\\[[^\\[\\]]+\\]|\\((?!\\*\\))[^)]+\\)/?)");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        Entity cl2;
        Entity cl1;
        String ent1 = arg.get("ENT1", 0);
        String ent2 = arg.get("ENT2", 0);
        String ent1clean = diagram.cleanId(ent1);
        String ent2clean = diagram.cleanId(ent2);
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        String queue = dir == Direction.LEFT || dir == Direction.RIGHT ? "-" : this.getQueue(arg);
        Labels labels = new Labels(arg);
        if (diagram.isGroup(ent1clean) && diagram.isGroup(ent2clean)) {
            cl1 = diagram.getGroup(ent1clean);
            cl2 = diagram.getGroup(ent2clean);
        } else {
            cl1 = this.getDummy(location, diagram, ent1);
            cl2 = this.getDummy(location, diagram, ent2);
        }
        LinkArg linkArg = LinkArg.build(Display.getWithNewlines(diagram.getPragma(), labels.getLabelLink()), queue.length(), diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(location, diagram, diagram.getSkinParam().getCurrentStyleBuilder(), cl1, cl2, linkType, linkArg.withQuantifier(labels.getFirstLabel(), labels.getSecondLabel()).withDistanceAngle(diagram.getLabeldistance(), diagram.getLabelangle()));
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setLinkArrow(labels.getLinkArrow());
        link.setColors(CommandLinkElement.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        if (arg.get("STEREOTYPE", 0) != null) {
            Stereotype stereotype = Stereotype.build(arg.get("STEREOTYPE", 0));
            link.setStereotype(stereotype);
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private Entity getDummy(LineLocation location, DescriptionDiagram diagram, String ident) {
        if (ident.startsWith("()")) {
            Quark<Entity> quark = diagram.quarkInContext(true, ident = diagram.cleanId(ident));
            if (quark.getData() != null) {
                return quark.getData();
            }
            return diagram.reallyCreateLeaf(location, quark, Display.getWithNewlines(diagram.getPragma(), quark.getName()), LeafType.DESCRIPTION, USymbols.INTERFACE);
        }
        char codeChar = ident.length() > 2 ? ident.charAt(0) : (char)'\u0000';
        boolean endWithSlash = ident.endsWith("/");
        Quark<Entity> quark = diagram.quarkInContext(true, ident = diagram.cleanId(ident));
        if (diagram.isGroup(quark)) {
            return quark.getData();
        }
        if (quark.getData() != null) {
            return quark.getData();
        }
        Display display = Display.getWithNewlines(diagram.getPragma(), quark.getName());
        if (codeChar == '(') {
            if (endWithSlash) {
                return diagram.reallyCreateLeaf(location, quark, display, LeafType.USECASE_BUSINESS, USymbols.USECASE_BUSINESS);
            }
            return diagram.reallyCreateLeaf(location, quark, display, LeafType.USECASE, USymbols.USECASE);
        }
        if (codeChar == ':') {
            if (endWithSlash) {
                return diagram.reallyCreateLeaf(location, quark, display, LeafType.DESCRIPTION, ActorStyle.STICKMAN_BUSINESS.toUSymbol());
            }
            return diagram.reallyCreateLeaf(location, quark, display, LeafType.DESCRIPTION, diagram.getSkinParam().actorStyle().toUSymbol());
        }
        if (codeChar == '[') {
            USymbol sym = diagram.getSkinParam().componentStyle().toUSymbol();
            return diagram.reallyCreateLeaf(location, quark, display, LeafType.DESCRIPTION, sym);
        }
        return diagram.reallyCreateLeaf(location, quark, display, LeafType.STILL_UNKNOWN, null);
    }
}

