/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.directdot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.atmp.ImageBuilder;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.directdot.CounterOutputStream;
import net.sourceforge.plantuml.dot.ExeState;
import net.sourceforge.plantuml.dot.Graphviz;
import net.sourceforge.plantuml.dot.GraphvizRuntimeEnvironment;
import net.sourceforge.plantuml.dot.ProcessState;
import net.sourceforge.plantuml.klimt.shape.GraphicStrings;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.svek.IEntityImage;

public class PSystemDot
extends AbstractPSystem {
    private final String data;

    public PSystemDot(UmlSource source, String data, PreprocessingArtifact preprocessing) {
        super(source, preprocessing);
        this.data = data;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dot)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
        Graphviz graphviz = GraphvizRuntimeEnvironment.getInstance().createForSystemDot(null, this.data, StringUtils.goLowerCase(fileFormat.getFileFormat().name()));
        if (graphviz.getExeState() != ExeState.OK) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("There is an issue with your Dot/Graphviz installation"), false);
            return ImageBuilder.create(fileFormat, result).seed(this.seed()).status(503).write(os);
        }
        CounterOutputStream counter = new CounterOutputStream(os);
        ProcessState state = graphviz.createFile3(counter);
        if (counter.getLength() == 0 || state.differs(ProcessState.TERMINATED_OK())) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("GraphViz has crashed"), false);
            return ImageBuilder.create(fileFormat, result).seed(this.seed()).status(503).write(os);
        }
        return ImageDataSimple.ok();
    }
}

