/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.sprite;

import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.klimt.sprite.SpriteColorBuilder4096;
import net.sourceforge.plantuml.klimt.sprite.SpriteGrayLevel;

public class SpriteUtils {
    public static final String SPRITE_NAME = "[-\\p{L}0-9_/]+";

    private SpriteUtils() {
    }

    public static String encodeColor(BufferedImage img, String name) {
        StringBuilder sb = new StringBuilder(img.getWidth() * img.getHeight() * 2);
        sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/color] {\n");
        List<String> result = SpriteColorBuilder4096.encodeImage(img);
        for (String s : result) {
            sb.append(s);
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static String encode(BufferedImage img, String name, SpriteGrayLevel level) {
        StringBuilder sb = new StringBuilder(img.getWidth() * img.getHeight() / 2);
        sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "] {\n");
        List<String> result = level.encode(img);
        for (String s : result) {
            sb.append(s);
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    public static String encodeCompressed(BufferedImage img, String name, SpriteGrayLevel level) {
        StringBuilder sb = new StringBuilder(img.getWidth() * img.getHeight() / 2);
        sb.append("sprite $" + name + " [" + img.getWidth() + "x" + img.getHeight() + "/" + level.getNbColor() + "z] ");
        List<String> list = level.encodeZ(img);
        if (list.size() == 1) {
            sb.append(list.get(0));
            sb.append("\n");
        } else {
            sb.append("{\n");
            for (String s : list) {
                sb.append(s);
                sb.append("\n");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }
}

