/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.png.quant;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;

public final class QuantUtils {
    public static BufferedImage toBufferedARGBorRGB(RenderedImage src) {
        if (src instanceof BufferedImage) {
            BufferedImage bi = (BufferedImage)src;
            int type = bi.getType();
            if (type == 2 || type == 1 || type == 5 || type == 6) {
                return bi;
            }
            if (type == 13) {
                return null;
            }
            throw new IllegalArgumentException("BufferedImage type=" + type);
        }
        throw new IllegalArgumentException();
    }

    public static int compressPackedARGB(int argb) {
        return argb & 0xFEFEFEFE | argb >>> 7 & 0x1010101;
    }
}

