/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.Pushable;
import net.sourceforge.plantuml.sequencediagram.graphic.SegmentColored;
import net.sourceforge.plantuml.sequencediagram.graphic.Stairs;
import net.sourceforge.plantuml.skin.ColorParam;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SkinParamBackcolored;
import net.sourceforge.plantuml.skin.SkinParamDelegator;
import net.sourceforge.plantuml.skin.SkinParamForceColor;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;

public class LifeLine {
    private final Pushable participant;
    private final double nominalPreferredWidth;
    private final List<Variation> events = new ArrayList<Variation>();
    private final Stairs stairs = new Stairs();
    private int maxLevel = 0;
    private final boolean shadowing;
    private final Display participantDisplay;
    private double create = 0.0;

    public LifeLine(Pushable participant, double nominalPreferredWidth, boolean shadowing, Display participantDisplay) {
        this.participant = participant;
        this.nominalPreferredWidth = nominalPreferredWidth;
        this.shadowing = shadowing;
        this.participantDisplay = participantDisplay;
    }

    public void addSegmentVariation(LifeSegmentVariation type, double y, Fashion colors, StyleBuilder styleBuilder) {
        if (this.events.size() > 0) {
            Variation last = this.events.get(this.events.size() - 1);
            if (y < last.y) {
                return;
            }
            if (y == last.y && type != last.type) {
                return;
            }
        }
        this.events.add(new Variation(type, y, colors, styleBuilder));
        int currentLevel = type.apply(this.stairs.getLastValue());
        this.stairs.addStep(y, currentLevel);
        assert (this.getLevel(y) == this.stairs.getValue(y));
        assert (currentLevel == this.stairs.getValue(y));
        assert (this.getLevel(y) == currentLevel);
        this.maxLevel = Math.max(this.getLevel(y), this.maxLevel);
    }

    public void finish(double y) {
        int missingClose = this.getMissingClose();
        for (int i = 0; i < missingClose; ++i) {
            this.addSegmentVariation(LifeSegmentVariation.SMALLER, y, null, null);
        }
    }

    int getMissingClose() {
        int level = 0;
        for (Variation ev : this.events) {
            if (ev.type == LifeSegmentVariation.LARGER) {
                ++level;
                continue;
            }
            --level;
        }
        return level;
    }

    int getLevel(double y) {
        return this.stairs.getValue(y);
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public double getRightShift(double y) {
        return this.getRightShiftAtLevel(this.getLevel(y));
    }

    public double getLeftShift(double y) {
        return this.getLeftShiftAtLevel(this.getLevel(y));
    }

    public double getMaxRightShift() {
        return this.getRightShiftAtLevel(this.getMaxLevel());
    }

    public double getMaxLeftShift() {
        return this.getLeftShiftAtLevel(this.getMaxLevel());
    }

    private double getRightShiftAtLevel(int level) {
        if (level == 0) {
            return 0.0;
        }
        return (double)level * (this.nominalPreferredWidth / 2.0);
    }

    private double getLeftShiftAtLevel(int level) {
        if (level == 0) {
            return 0.0;
        }
        return this.nominalPreferredWidth / 2.0;
    }

    private double getStartingX(StringBounder stringBounder) {
        double delta = this.participant.getCenterX(stringBounder) - this.nominalPreferredWidth / 2.0;
        return delta;
    }

    private SegmentColored getSegment(int i) {
        if (this.events.get(i).type != LifeSegmentVariation.LARGER) {
            return null;
        }
        int level = 1;
        for (int j = i + 1; j < this.events.size(); ++j) {
            level = this.events.get(j).type == LifeSegmentVariation.LARGER ? ++level : --level;
            if (level != 0) continue;
            double y1 = this.events.get(i).y;
            double y2 = this.events.get(j).y;
            return SegmentColored.create(y1, y2, this.events.get(i).colors, this.shadowing);
        }
        return SegmentColored.create(this.events.get(i).y, this.events.get(this.events.size() - 1).y, this.events.get(i).colors, this.shadowing);
    }

    private Collection<SegmentColored> getSegmentsCutted(StringBounder stringBounder, int i) {
        SegmentColored seg = this.getSegment(i);
        if (seg != null) {
            return seg.cutSegmentIfNeed(this.participant.getDelays(stringBounder));
        }
        return Collections.emptyList();
    }

    public void drawU(UGraphic ug, Rose skin, ISkinParam skinParam) {
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dx(this.getStartingX(stringBounder)));
        int eventLevel = 0;
        for (int i = 0; i < this.events.size(); ++i) {
            ComponentType type = ComponentType.ACTIVATION_BOX_CLOSE_OPEN;
            Collection<SegmentColored> segmentsCutted = this.getSegmentsCutted(stringBounder, i);
            if (this.events.get(i).type == LifeSegmentVariation.LARGER) {
                ++eventLevel;
            } else if (this.events.get(i).type == LifeSegmentVariation.SMALLER) {
                eventLevel = Math.max(0, eventLevel - 1);
            }
            Iterator<SegmentColored> it = segmentsCutted.iterator();
            while (it.hasNext()) {
                Style style;
                StyleBuilder currentStyleBuilder;
                SegmentColored seg = it.next();
                HColor specificBackColor = seg.getSpecificBackColor();
                SkinParamDelegator skinParam2 = new SkinParamBackcolored(skinParam, specificBackColor);
                HColor specificLineColor = seg.getSpecificLineColor();
                if (specificLineColor != null) {
                    skinParam2 = new SkinParamForceColor(skinParam2, ColorParam.sequenceLifeLineBorder, specificLineColor);
                }
                if (!it.hasNext()) {
                    ComponentType componentType = type = type == ComponentType.ACTIVATION_BOX_CLOSE_OPEN ? ComponentType.ACTIVATION_BOX_CLOSE_CLOSE : ComponentType.ACTIVATION_BOX_OPEN_CLOSE;
                }
                if ((currentStyleBuilder = this.events.get(i).styleBuilder) == null) {
                    currentStyleBuilder = skinParam2.getCurrentStyleBuilder();
                }
                if ((style = type.getStyleSignature().withTOBECHANGED(this.participant.getStereotype()).getMergedStyle(currentStyleBuilder)) != null) {
                    style = style.eventuallyOverride(PName.BackGroundColor, specificBackColor);
                    style = style.eventuallyOverride(PName.LineColor, specificLineColor);
                }
                Component compAliveBox = skin.createComponent(new Style[]{style}, type, null, skinParam2, this.participantDisplay);
                type = ComponentType.ACTIVATION_BOX_OPEN_OPEN;
                int currentLevel = Math.min(eventLevel, this.getLevel(seg.getPos1Initial()));
                seg.drawU(ug, compAliveBox, currentLevel);
            }
        }
    }

    public final void setCreate(double create) {
        this.create = create;
    }

    public final double getCreate() {
        return this.create;
    }

    public final double getDestroy() {
        return 0.0;
    }

    public final boolean shadowing() {
        return this.shadowing;
    }

    public Fashion getColors() {
        if (this.events.size() == 0) {
            return null;
        }
        return this.events.get(this.events.size() - 1).colors;
    }

    static class Variation {
        private final LifeSegmentVariation type;
        private final Fashion colors;
        private final double y;
        private final StyleBuilder styleBuilder;

        Variation(LifeSegmentVariation type, double y, Fashion backcolor, StyleBuilder styleBuilder) {
            this.type = type;
            this.y = y;
            this.colors = backcolor;
            this.styleBuilder = styleBuilder;
        }

        public String toString() {
            return (Object)((Object)this.type) + " " + this.y;
        }
    }
}

