/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.atmp.CucaDiagram;
import net.sourceforge.plantuml.AnnotatedBuilder;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.crash.GraphvizCrash;
import net.sourceforge.plantuml.dot.CucaDiagramSimplifierActivity;
import net.sourceforge.plantuml.dot.CucaDiagramSimplifierState;
import net.sourceforge.plantuml.dot.DotData;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.svek.BaseFile;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.GraphvizImageBuilder;
import net.sourceforge.plantuml.svek.NamedOutputStream;

public final class CucaDiagramFileMakerSvek
extends CucaDiagramFileMaker {
    public CucaDiagramFileMakerSvek(CucaDiagram diagram) throws IOException {
        super(diagram);
    }

    @Override
    public ImageData createFile(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException {
        try {
            return this.createFileInternal(os, dotStrings, fileFormatOption);
        }
        catch (InterruptedException e) {
            Logme.error(e);
            throw new IOException(e);
        }
    }

    @Override
    public void createOneGraphic(UGraphic ug) {
        throw new UnsupportedOperationException();
    }

    private ImageData createFileInternal(OutputStream os, List<String> dotStrings, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        TextBlock result;
        StringBounder stringBounder = fileFormatOption.getDefaultStringBounder(this.diagram.getSkinParam());
        if (this.diagram.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            new CucaDiagramSimplifierActivity().simplify(this.diagram, stringBounder, DotMode.NORMAL);
        } else if (this.diagram.getUmlDiagramType() == UmlDiagramType.STATE) {
            new CucaDiagramSimplifierState().simplify(this.diagram, stringBounder, DotMode.NORMAL);
        }
        DotStringFactory dotStringFactory = new DotStringFactory(this.bibliotekon, this.clusterManager.getCurrent(), this.diagram.getUmlDiagramType(), this.diagram.getSkinParam());
        DotData dotData = new DotData(this.diagram, this.diagram.getRootGroup(), this.getOrderedLinks(), this.diagram.leafs(), this.diagram, this.diagram);
        GraphvizImageBuilder imageBuilder = new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), this.diagram.getUmlDiagramType().getStyleName(), DotMode.NORMAL, dotStringFactory, this.clusterManager);
        BaseFile basefile = null;
        if (fileFormatOption.isDebugSvek() && os instanceof NamedOutputStream) {
            basefile = ((NamedOutputStream)os).getBasefile();
        }
        if ((result = imageBuilder.buildImage(stringBounder, basefile, this.diagram.getDotStringSkek(), fileFormatOption.isDebugSvek())) instanceof GraphvizCrash) {
            imageBuilder = new GraphvizImageBuilder(dotData, this.diagram.getSource(), this.diagram.getPragma(), this.diagram.getUmlDiagramType().getStyleName(), DotMode.NO_LEFT_RIGHT_AND_XLABEL, dotStringFactory, this.clusterManager);
            result = imageBuilder.buildImage(stringBounder, basefile, this.diagram.getDotStringSkek(), fileFormatOption.isDebugSvek());
        }
        AnnotatedBuilder builder = new AnnotatedBuilder(this.diagram, this.diagram.getSkinParam(), stringBounder);
        result = new AnnotatedWorker(this.diagram, builder).addAdd(result);
        String widthwarning = this.diagram.getSkinParam().getValue("widthwarning");
        String warningOrError = null;
        if (widthwarning != null && widthwarning.matches("\\d+")) {
            warningOrError = imageBuilder.getWarningOrError(Integer.parseInt(widthwarning));
        }
        result.calculateDimension(stringBounder);
        return this.diagram.createImageBuilder(fileFormatOption).annotations(false).drawable(result).status(result instanceof GraphvizCrash ? 503 : 0).warningOrError(warningOrError).write(os);
    }

    private List<Link> getOrderedLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link l : this.diagram.getLinks()) {
            this.addLinkNew(result, l);
        }
        return result;
    }

    private void addLinkNew(List<Link> result, Link link) {
        for (int i = 0; i < result.size(); ++i) {
            Link other = result.get(i);
            if (!other.sameConnections(link)) continue;
            while (i < result.size() && result.get(i).sameConnections(link)) {
                ++i;
            }
            if (i == result.size()) {
                result.add(link);
            } else {
                result.add(i, link);
            }
            return;
        }
        result.add(link);
    }
}

