/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.geom.GeneralPath;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;

public class ShapeEdge {
    private static final boolean DEBUG = false;
    private static final int TYPE_HORIZONTAL = 0;
    private static final int TYPE_VERTICAL = 1;
    private static final int TYPE_SLOPED = 2;
    private DiagramShape owner;
    private ShapePoint startPoint;
    private ShapePoint endPoint;

    public ShapeEdge(ShapePoint start, ShapePoint end, DiagramShape owner) {
        this.startPoint = start;
        this.endPoint = end;
        this.owner = owner;
    }

    public ShapeEdge(ShapeEdge other) {
        this(new ShapePoint(other.startPoint), new ShapePoint(other.endPoint), other.owner);
    }

    private float getDistanceFromOrigin() {
        int type = this.getType();
        if (type == 2) {
            throw new RuntimeException("Cannot calculate distance of sloped edge from origin");
        }
        if (type == 0) {
            return this.startPoint.y;
        }
        return this.startPoint.x;
    }

    public void moveInwardsBy(float offset) {
        int type = this.getType();
        if (type == 2) {
            throw new RuntimeException("Cannot move a sloped edge inwards: " + this);
        }
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        ShapePoint middle = this.getMiddle();
        GeneralPath path = this.owner.makeIntoPath();
        if (type == 0) {
            xOffset = 0.0f;
            ShapePoint up = new ShapePoint(middle.x, middle.y - 0.05f);
            ShapePoint down = new ShapePoint(middle.x, middle.y + 0.05f);
            if (path.contains(up)) {
                yOffset = -offset;
            } else if (path.contains(down)) {
                yOffset = offset;
            }
        } else if (type == 1) {
            yOffset = 0.0f;
            ShapePoint left = new ShapePoint(middle.x - 0.05f, middle.y);
            ShapePoint right = new ShapePoint(middle.x + 0.05f, middle.y);
            if (path.contains(left)) {
                xOffset = -offset;
            } else if (path.contains(right)) {
                xOffset = offset;
            }
        }
        this.translate(xOffset, yOffset);
    }

    public void translate(float dx, float dy) {
        this.startPoint.x += dx;
        this.startPoint.y += dy;
        this.endPoint.x += dx;
        this.endPoint.y += dy;
    }

    public ShapePoint getMiddle() {
        return new ShapePoint((this.startPoint.x + this.endPoint.x) / 2.0f, (this.startPoint.y + this.endPoint.y) / 2.0f);
    }

    private int getType() {
        if (this.isVertical()) {
            return 1;
        }
        if (this.isHorizontal()) {
            return 0;
        }
        return 2;
    }

    public ShapePoint getEndPoint() {
        return this.endPoint;
    }

    public ShapePoint getStartPoint() {
        return this.startPoint;
    }

    public void setEndPoint(ShapePoint point) {
        this.endPoint = point;
    }

    public void setStartPoint(ShapePoint point) {
        this.startPoint = point;
    }

    public DiagramShape getOwner() {
        return this.owner;
    }

    public void setOwner(DiagramShape shape) {
        this.owner = shape;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShapeEdge)) {
            return false;
        }
        ShapeEdge edge = (ShapeEdge)object;
        if (this.startPoint.equals(edge.getStartPoint()) && this.endPoint.equals(edge.getEndPoint())) {
            return true;
        }
        return this.startPoint.equals(edge.getEndPoint()) && this.endPoint.equals(edge.getStartPoint());
    }

    public boolean touchesWith(ShapeEdge other) {
        if (this.equals(other)) {
            return true;
        }
        if (this.isHorizontal() && other.isVertical()) {
            return false;
        }
        if (other.isHorizontal() && this.isVertical()) {
            return false;
        }
        if (this.getDistanceFromOrigin() != other.getDistanceFromOrigin()) {
            return false;
        }
        ShapeEdge first = new ShapeEdge(this);
        ShapeEdge second = new ShapeEdge(other);
        if (first.isVertical()) {
            first.changeAxis();
            second.changeAxis();
        }
        first.fixDirection();
        second.fixDirection();
        if (first.startPoint.x > second.startPoint.x) {
            ShapeEdge temp = first;
            first = second;
            second = temp;
        }
        if (first.endPoint.equals(second.startPoint)) {
            return false;
        }
        if (this.startPoint.isWithinEdge(other) || this.endPoint.isWithinEdge(other)) {
            return true;
        }
        return other.startPoint.isWithinEdge(this) || other.endPoint.isWithinEdge(this);
    }

    private void changeAxis() {
        ShapePoint temp = new ShapePoint(this.startPoint);
        this.startPoint = new ShapePoint(this.endPoint.y, this.endPoint.x);
        this.endPoint = new ShapePoint(temp.y, temp.x);
    }

    private void fixDirection() {
        if (this.isHorizontal()) {
            if (this.startPoint.x > this.endPoint.x) {
                this.flipDirection();
            }
        } else if (this.isVertical()) {
            if (this.startPoint.y > this.endPoint.y) {
                this.flipDirection();
            }
        } else {
            throw new RuntimeException("Cannot fix direction of sloped edge");
        }
    }

    private void flipDirection() {
        ShapePoint temp = this.startPoint;
        this.startPoint = this.endPoint;
        this.endPoint = temp;
    }

    public boolean isHorizontal() {
        return this.startPoint.y == this.endPoint.y;
    }

    public boolean isVertical() {
        return this.startPoint.x == this.endPoint.x;
    }

    public String toString() {
        return this.startPoint + " -> " + this.endPoint;
    }
}

