/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hpsf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFException;
import org.apache.poi.hpsf.HPSFRuntimeException;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderEvent;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.TempFile;

public final class CopyCompare {
    private CopyCompare() {
    }

    public static void main(String[] args) throws IOException {
        String originalFileName = null;
        String copyFileName = null;
        if (args.length == 1) {
            originalFileName = args[0];
            File f = TempFile.createTempFile((String)"CopyOfPOIFileSystem-", (String)".ole2");
            f.deleteOnExit();
            copyFileName = f.getAbsolutePath();
        } else if (args.length == 2) {
            originalFileName = args[0];
            copyFileName = args[1];
        } else {
            System.err.println("Usage: CopyCompare originPOIFS [copyPOIFS]");
            System.exit(1);
        }
        boolean result = CopyCompare.compare(originalFileName, copyFileName);
        System.out.println(result ? "Equal" : "Not equal");
    }

    /*
     * Exception decompiling
     */
    public static boolean compare(String originalFileName, String copyFileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void handleEvent(POIFSFileSystem poiFs, POIFSReaderEvent event) {
        DocumentInputStream stream = event.getStream();
        try {
            InputStreamSupplier su;
            if (stream != null && PropertySet.isPropertySetStream((InputStream)stream)) {
                PropertySet ps = PropertySetFactory.create((InputStream)stream);
                Object mps = ps instanceof DocumentSummaryInformation ? new DocumentSummaryInformation(ps) : (ps instanceof SummaryInformation ? new SummaryInformation(ps) : new PropertySet(ps));
                su = () -> ((PropertySet)mps).toInputStream();
            } else {
                su = () -> ((POIFSReaderEvent)event).getStream();
            }
            try (InputStream is = su.get();){
                POIFSDocumentPath path = event.getPath();
                DirectoryNode de = poiFs.getRoot();
                if (File.separator.equals(path.toString())) {
                    de.setStorageClsid(event.getStorageClassId());
                }
                for (int i = 0; i < path.length(); ++i) {
                    String subDir = path.getComponent(i);
                    if (de.hasEntry(subDir)) {
                        de = (DirectoryEntry)de.getEntry(subDir);
                        continue;
                    }
                    de = de.createDirectory(subDir);
                    if (i != path.length() - 1) continue;
                    de.setStorageClsid(event.getStorageClassId());
                }
                if (event.getName() != null) {
                    de.createDocument(event.getName(), is);
                }
            }
        }
        catch (IOException | HPSFException ex) {
            throw new HPSFRuntimeException("Could not read file " + event.getPath() + "/" + event.getName(), ex);
        }
    }

    private static /* synthetic */ void lambda$compare$0(POIFSFileSystem poiFs, POIFSReaderEvent e) {
        CopyCompare.handleEvent(poiFs, e);
    }

    private static interface InputStreamSupplier {
        public InputStream get() throws IOException, WritingNotSupportedException;
    }
}

