# SPDX-License-Identifier: Apache-2.0
# Copyright 2013 The Meson development team

from __future__ import annotations

import os, sys
import typing as T

def run(args: T.List[str]) -> int:
    if len(args) != 2:
        print('delwithsuffix.py <root of subdir to process> <suffix to delete>')
        sys.exit(1)

    topdir = args[0]
    suffix = args[1]
    if suffix[0] != '.':
        suffix = '.' + suffix

    for (root, _, files) in os.walk(topdir):
        for f in files:
            if f.endswith(suffix):
                fullname = os.path.join(root, f)
                os.unlink(fullname)
    return 0

if __name__ == '__main__':
    run(sys.argv[1:])
