from _typeshed import FileDescriptorOrPath, StrPath
from collections.abc import Iterator

from pygments.lexer import Lexer, LexerMeta

def get_all_lexers(plugins: bool = True) -> Iterator[tuple[str, tuple[str, ...], tuple[str, ...], tuple[str, ...]]]: ...
def find_lexer_class(name: str) -> LexerMeta | None: ...
def find_lexer_class_by_name(_alias: str) -> LexerMeta: ...
def get_lexer_by_name(_alias: str, **options) -> Lexer: ...
def load_lexer_from_file(filename: FileDescriptorOrPath, lexername: str = "CustomLexer", **options) -> Lexer: ...
def find_lexer_class_for_filename(_fn: StrPath, code: str | bytes | None = None) -> LexerMeta | None: ...
def get_lexer_for_filename(_fn: StrPath, code: str | bytes | None = None, **options) -> Lexer: ...
def get_lexer_for_mimetype(_mime: str, **options) -> Lexer: ...
def guess_lexer_for_filename(_fn: StrPath, _text: str, **options) -> Lexer: ...
def guess_lexer(_text: str | bytes, **options) -> Lexer: ...

# Having every lexer class here doesn't seem to be worth it
def __getattr__(name: str): ...  # incomplete module
