//@ui5-bundle sap/ui/commons/library-preload.js
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Accordion", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./AccordionRenderer","sap/ui/dom/jquery/control","sap/ui/thirdparty/jqueryui/jquery-ui-core","sap/ui/thirdparty/jqueryui/jquery-ui-widget","sap/ui/thirdparty/jqueryui/jquery-ui-mouse","sap/ui/thirdparty/jqueryui/jquery-ui-sortable"],function(jQuery,t,e,i){"use strict";var o=e.extend("sap.ui.commons.Accordion",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"200px"},openedSectionsId:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"sections",aggregations:{sections:{type:"sap.ui.commons.AccordionSection",multiple:true,singularName:"section"}},events:{sectionOpen:{parameters:{openSectionId:{type:"string"},closeSectionIds:{type:"string[]"}}},sectionClose:{parameters:{closeSectionId:{type:"string"}}},sectionsReorder:{parameters:{movedSectionId:{type:"string"},newIndex:{type:"int"}}}}}});o.CARD_1=1;o.CARD_0_1=2;o.aAccordions=[];o.prototype.init=function(){this.bInitialRendering=true;this.activationMode=o.CARD_1;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.aSectionTitles=[];o.aAccordions.push(this)};o.prototype.onsapspace=function(t){this.onclick(t)};o.prototype.onsappagedownmodifiers=function(t){var e=jQuery(t.target);var i=e.parentsUntil(".sapUiAcd");var o=i[i.length-1];var n=jQuery(o).next();while(!this.getCorrespondingSection(n[0]).getEnabled()){n=n.next()}n=n[0];this.openSection(n.id);var r=this.getSections();r[this.__idxOfSec(n.id)].focus();t.preventDefault();t.stopPropagation()};o.prototype.onsappageupmodifiers=function(t){var e=jQuery(t.target);var i=e.parentsUntil(".sapUiAcd");var o=i[i.length-1];var n=jQuery(o).prev();while(!this.getCorrespondingSection(n[0]).getEnabled()){n=n.prev()}n=n[0];this.openSection(n.id);var r=this.getSections();r[this.__idxOfSec(n.id)].focus();t.preventDefault();t.stopPropagation()};o.prototype.onsapupmodifiers=function(t){t.preventDefault();t.stopPropagation();var e=jQuery(t.target).parentsUntil(".sapUiAcd");var i=e[e.length-1];if(this.__idxOfSec(i.id)===0){return}var o=jQuery(i).prev().first()[0];var n=false;if(this.__idxOfSec(o.id)===0){n=true}this.dropSection(i,o,n);var r=this.getSections();r[this.__idxOfSec(i.id)].focus()};o.prototype.onsapdownmodifiers=function(t){t.preventDefault();t.stopPropagation();var e=jQuery(t.target).parentsUntil(".sapUiAcd");var i=e[e.length-1];if(this.__idxOfSec(i.id)==this.getSections().length-1){return}var o=jQuery(i).next().first()[0];this.dropSection(i,o,false);var n=this.getSections();n[this.__idxOfSec(i.id)].focus()};o.prototype.onsapprevious=function(t){if(t.srcControl.getMetadata().getName()!="sap.ui.commons.AccordionSection"){return}t.preventDefault();t.stopPropagation();var e=this.getCurrentSection(t.target),i=null;if(e.id==this.getSections()[0].getId()){i=jQuery(e).find("div.sapUiAcdSectionHdr");if(i){i.trigger("focus")}}if(e){var o=jQuery(e).prev();while(o&&jQuery(o).hasClass("sapUiAcdSectionDis")){o=jQuery(o).prev()}if(o){i=jQuery(o).find("div.sapUiAcdSectionHdr");if(i){i.trigger("focus")}}}};o.prototype.onsapnext=function(t){if(t.srcControl.getMetadata().getName()!="sap.ui.commons.AccordionSection"){return}t.preventDefault();t.stopPropagation();var e=this.getCurrentSection(t.target);if(e){var i=jQuery(e).next();while(i&&jQuery(i).hasClass("sapUiAcdSectionDis")){i=jQuery(i).next()}if(i){var o=jQuery(i).find("div.sapUiAcdSectionHdr");if(o){o.trigger("focus")}}}};o.prototype.onsaphome=function(t){t.preventDefault();t.stopPropagation();var e=this.getSections()[0].getDomRef();if(jQuery(e).hasClass("sapUiAcdSectionDis")){e=jQuery(e).next();while(e&&jQuery(e).hasClass("sapUiAcdSectionDis")){e=jQuery(e).next()}}if(e){var i=jQuery(e).find("div.sapUiAcdSectionHdr");if(i){i.trigger("focus")}}};o.prototype.onsapend=function(t){t.preventDefault();t.stopPropagation();var e=this.getSections().length;var i=this.getSections()[e-1].getDomRef();if(jQuery(i).hasClass("sapUiAcdSectionDis")){i=jQuery(i).prev();while(i&&jQuery(i).hasClass("sapUiAcdSectionDis")){i=jQuery(i).prev()}}if(i){var o=jQuery(i).find("div.sapUiAcdSectionHdr");if(o){o.trigger("focus")}}};o.prototype.getCurrentSection=function(t){var e=t;while(!jQuery(e).hasClass("sapUiAcdSection")){e=jQuery(e).parent()}return e[0]};o.prototype.dropSection=function(t,e,i){var o=jQuery(t).parent()[0];var n=jQuery(o).children(".sapUiAcdSection").toArray();var r=jQuery.inArray(e,n);if(i){r-=1}this.moveSection(t.id,r)};o.prototype.moveSection=function(t,e){var i=this.__idxOfSec(t);if(e==i){return}var o=this.aSectionTitles[i];this.aSectionTitles.splice(i,1);var n=this.getSections();var r=n[i];this.removeSection(i,true);if(e!=-1){this.aSectionTitles.splice(e,0,o)}else{this.aSectionTitles.splice(0,0,o)}this.insertSection(r,e,true);this.fireSectionsReorder({movedSectionId:t,newIndex:e})};o.prototype._onSortChange=function(t,e){t.preventDefault();t.stopPropagation();var i=e.item[0];var o=e.item[0].getAttribute("Id");var n=jQuery(i).parent()[0];var r=jQuery(n).children(".sapUiAcdSection").toArray();var s=jQuery.inArray(i,r);this.moveSection(o,s)};o.prototype.onclick=function(t){if(t.srcControl.getId()==this.getId()){return}var e=jQuery(t.target);if(e.hasClass("sapUiAcdSectionCont")){return}if(!(jQuery(t.target).control(0)instanceof sap.ui.commons.AccordionSection)){return}var i=t.srcControl.getDomRef();var o=this.getCorrespondingSection(i);if(o&&!o.getEnabled()){return}if(t.srcControl.getCollapsed()){this.openSection(i.id)}else{this.closeSection(i.id)}t.preventDefault();t.stopPropagation();var n=this.getSections();n[this.__idxOfSec(i.id)].focus()};o.prototype.openSection=function(t){var e=this.__idxOfSec(t);var i=this.getSections(),n=[];if(this.activationMode==o.CARD_0_1||this.activationMode==o.CARD_1){n=this.closeOpenedSections()}i[e]._setCollapsed(false);this.fireSectionOpen({openSectionId:t,closeSectionIds:n})};o.prototype.closeSection=function(t){var e=this.__idxOfSec(t);var i=this.getSections();i[e]._setCollapsed(true);this.fireSectionClose({closeSectionId:t})};o.prototype.closeOpenedSections=function(){var t=[];var e=this.getSections();for(var i=0;i<e.length;i++){if(!e[i].getCollapsed()){e[i]._setCollapsed(true);t.push(e[i].getId())}}return t};o.prototype.openDefaultSections=function(){var t=this.getSections();var e=this.getOpenedSectionsId().split(",");for(var i=0;i<e.length;i++){var o=t[this.__idxOfSec(e[i])];o._setCollapsed(false)}};o.prototype.getNumberOfOpenedSections=function(){var t=0;var e=this.getSections();for(var i=0;i<e.length;i++){if(e[i].getCollapsed()==false){t++}}return t};o.prototype.addSection=function(t){this.addAggregation("sections",t);if((this.getOpenedSectionsId()==null||this.getOpenedSectionsId()=="")&&t.getEnabled()){this.setOpenedSectionsId(t.getId())}this.aSectionTitles.push(t.getTitle());return this};o.prototype.__idxOfSec=function(t){if(typeof t=="string"){t=sap.ui.getCore().byId(t)}return this.indexOfSection(t)};o.prototype.setOpenedSectionsId=function(t){var e=this.getSections();var i=t.split(",");if(i.length==1){if(this.__idxOfSec(t)<0){this.setProperty("openedSectionsId",t);return this}if(e[this.__idxOfSec(t)].getEnabled()){this.setProperty("openedSectionsId",t)}else{for(var o=0;o<e.length;o++){if(e[o].getEnabled()){this.setProperty("openedSectionsId",e[o].getId());return this}}}}else if(i.length==0){return this}else{var n;for(var o=0;o<i.length;o++){if(e[this.__idxOfSec(i[o])].getEnabled()){if(n){n+=","+i[o]}else{n=i[o]}}}if(n){this.setProperty("openedSectionsId",n)}}return this};o.prototype.getCorrespondingSection=function(t){if(jQuery(t).hasClass("sapUiAcdSection")){var e=jQuery(t).parent();var i=e[0];var o=jQuery(i).children();var n=o.index(t);var r=this.getSections();return r[n-1]}};o.prototype.isLastSection=function(t){var e=this.getSections();return jQuery.inArray(t,e)===e.length-1};o.prototype.onAfterRendering=function(){var t=sap.ui.getCore(),e=this;function i(){var t=e.getDomRef();if(t){t.style.height=t.clientHeight-7+"px"}}if(t.isThemeApplied()){i()}else{t.attachThemeChanged(i,this)}this.$().sortable({handle:"> div.sapUiAcdSectionHdr > div",stop:jQuery.proxy(this._onSortChange,this)})};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/AccordionRenderer", ["./AccordionSection","sap/ui/core/Configuration"],function(e,t){"use strict";var i={};i.render=function(e,r){e.write("<div");e.writeControlData(r);if(t.getAccessibility()){e.writeAttribute("role","tablist")}e.addClass("sapUiAcd");e.addStyle("width",r.getWidth());e.writeClasses();e.writeStyles();e.write(">");e.write("<div id='"+r.getId()+"-dropTarget"+"' style='width:"+r.getWidth()+"' tabindex='-1' class='sapUiAcd-droptarget'></div>");var a=r.getSections();var d=r.getOpenedSectionsId().split(",");for(var s=0;s<a.length;s++){if(r.bInitialRendering){if(d.indexOf(a[s].getId())!=-1){a[s]._setCollapsed(false)}else{a[s]._setCollapsed(true)}}i.renderSection(e,a[s])}e.write('<span id="'+r.getId()+'-Descr" style="visibility: hidden; display: none;">');e.write(r.rb.getText("ACCORDION_DSC"));e.write("</span>");e.write("</div>");r.bInitialRendering=false};i.renderSection=function(i,r){var a=t.getAccessibility();var d=e._isSizeSet(r.getMaxHeight());var s=e._isSizeSet(r.getParent().getWidth());i.write("<div");i.writeElementData(r);i.addClass("sapUiAcdSection");if(r.getParent().isLastSection(r)){i.addClass("sapUiAcdSectionLast")}i.addStyle("width",r.getParent().getWidth());if(!r.getCollapsed()){i.addStyle("height",r.getMaxHeight())}else{i.addClass("sapUiAcdSectionColl")}i.addClass("sapUiAcdSectionArea");if(!d){i.addClass("sapUiAcdSectionFlexHeight")}if(!r.getEnabled()){i.addClass("sapUiAcdSectionDis")}i.writeClasses();i.writeStyles();i.write("><div class='sapUiAcdSectionHdr'");if(r.getEnabled()){i.write(" tabindex='0'")}i.writeAttribute("id",r.getId()+"-hdr");if(a){i.writeAttribute("role","tab");i.writeAttribute("aria-labelledby",r.getId()+"-lbl");i.writeAttribute("aria-describedby",r.getParent().getId()+"-Descr");if(r.getEnabled()){if(r.getCollapsed()){i.writeAttribute("aria-expanded","false")}else{i.writeAttribute("aria-expanded","true")}}}i.write(">");i.write("<div ");i.writeAttribute("id",r.getId()+"-trgt");i.write(">");i.write("<span id='"+r.getId()+"-hdrL'>");if(r.getEnabled()){i.write("<a id='"+r.getId()+"-minL' class='sapUiAcdSectionMinArrow' href='# title='Collapse/Expand'")}else{i.write("<a id='"+r.getId()+"-minL' class='sapUiAcdSectionMinArrow sapUiAcdCursorText' href='#' title='Collapse/Expand'")}i.write(" tabindex='-1' ");if(a){i.writeAttribute("aria-labelledby",r.getId()+"-lbl");if(r.getCollapsed()){i.writeAttribute("aria-selected","false")}else{i.writeAttribute("aria-selected","true")}if(r.getEnabled()){i.writeAttribute("aria-disabled","false");i.writeAttribute("aria-grabbed","false")}else{i.writeAttribute("aria-disabled","true");i.writeAttribute("aria-grabbed","")}}i.write("></a>");i.write("<span tabindex='-1' id='"+r.getId()+"-lbl' class='sapUiAcdSectionLabel'");if(r.getCollapsed()){i.writeAttribute("aria-selected","false");i.addStyle("font-weight","normal");i.writeStyles()}else{i.writeAttribute("aria-selected","true");i.addStyle("font-weight","bold");i.writeStyles()}if(a){i.writeAttribute("role","heading");if(r.getEnabled()){i.writeAttribute("aria-disabled","false")}else{i.writeAttribute("aria-disabled","true")}}i.write(">");i.writeEscaped(r.getTitle());i.write("</span>");i.write("</span>");i.write("</div></div>");if(!r.getCollapsed()){i.write("<div class='sapUiAcdSectionCont' tabindex='-1' id='"+r.getId()+"-cont'");if(d&&s){i.write(" style='position:absolute;'")}else{i.write(" style='position:relative;top:0px;'")}if(t.getAccessibility()){i.writeAttribute("role","tabpanel")}i.write(">");var l=r.getContent(),n=l.length;for(var w=0;w<n;w++){i.renderControl(l[w])}i.write("</div>")}i.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/AccordionSection", ["./library","sap/ui/core/Element","sap/ui/core/Configuration"],function(t,e,i){"use strict";var o=e.extend("sap.ui.commons.AccordionSection",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},collapsed:{type:"boolean",group:"Behavior",defaultValue:false},title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{scroll:{parameters:{left:{type:"int"},top:{type:"int"}}}}}});o.prototype.init=function(){this.oScrollDomRef=null;this.data("sap-ui-fastnavgroup","true",true)};o.prototype.focusFirstControl=function(){var t=this.getContent();if(t[0]){t[0].focus()}};o.prototype.focus=function(){var t=this.getDomRef("hdr");t.focus()};o.prototype.onThemeChanged=function(){var t=this.getDomRef("hdrL");if(t){t.style.width="auto";this.onAfterRendering()}};o.prototype.onAfterRendering=function(){this.oScrollDomRef=this.getDomRef("cont");var t=this.oScrollDomRef,e=this.getDomRef(),i=this.getParent().getDomRef(),s=this.getDomRef("lbl");if(!o._isSizeSet(this.getParent().getWidth())&&o._isSizeSet(this.getMaxHeight())){if(t){var r=t.offsetTop;var n=e.offsetHeight-r;t.style.height=n+"px";var a=t.offsetHeight;if(a>n){t.style.height=n-(a-n)+"px"}}}s.style.width=i.offsetWidth-30+"px";var l=this.__scrollproxy__;if(!l){l=this.__scrollproxy__=typeof this.onscroll==="function"?this.onscroll.bind(this):undefined}this.$("cont").on("scroll",l)};o.prototype.onBeforeRendering=function(){var t=this.__scrollproxy__;if(t){this.$("cont").off("scroll",t)}};o.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);var e=this.getDomRef();if(e){if(t){this.$().removeClass("sapUiAcdSectionDis")}else{this.$().addClass("sapUiAcdSectionDis")}}return this};o.prototype._setCollapsed=function(t){this.setProperty("collapsed",t,true);this._setCollapsedState(t)};o.prototype.setCollapsed=function(t){if(this.getParent()){if(!t){this.getParent().openSection(this.getId())}else{this.getParent().closeSection(this.getId())}}else{this._setCollapsed(t)}return this};o.prototype._setCollapsedState=function(t){var e=this.getDomRef("tb"),o=this.getDomRef("cont"),s=i.getAccessibility();if(this.getDomRef()){if(t){if(!this.getParent().getWidth()){this.getDomRef().style.width=this.getDomRef().offsetWidth+"px"}this.$().addClass("sapUiAcdSectionColl");if(e){e.style.display="none"}if(o){o.style.display="none"}if(s){o.setAttribute("aria-expanded","false");o.setAttribute("aria-hidden","true")}this.invalidate()}else{if(!o){this.invalidate()}else{this.$().removeClass("sapUiAcdSectionColl");if(e){e.style.display="block"}o.style.display="block";if(s){o.setAttribute("aria-expanded","true")}if(this.getMaxHeight()){this.getDomRef().style.height=this.getMaxHeight()}}}}};o._isSizeSet=function(t){return t&&!(t==="auto")&&!(t==="inherit")};o.prototype._handleTrigger=function(t){if(t.target.id===this.getId()+"-minL"||t.target.id===this.getId()+"-minR"){var e=!this.getProperty("collapsed");this._setCollapsed(e);t.preventDefault();t.stopPropagation()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ApplicationHeader", ["./library","sap/ui/core/Control","./Image","./TextView","./Button","./ApplicationHeaderRenderer","sap/ui/core/library"],function(t,o,e,i,s,r,n){"use strict";var a=n.AccessibleRole;var l=o.extend("sap.ui.commons.ApplicationHeader",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{logoSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},logoText:{type:"string",group:"Misc",defaultValue:null},displayLogoff:{type:"boolean",group:"Misc",defaultValue:true},userName:{type:"string",group:"Misc",defaultValue:null},displayWelcome:{type:"boolean",group:"Misc",defaultValue:true}},events:{logoff:{}}}});l.prototype.init=function(){this.initializationDone=false};l.prototype.exit=function(){this.oLogo&&this.oLogo.destroy();this.oLogoText&&this.oLogoText.destroy();this.oLogoffBtn&&this.oLogoffBtn.destroy()};l.prototype.initControls=function(){var t=this.getId();var o=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oLogo&&this.oLogo.destroy();this.oLogo=new e(t+"-logoImg");this.oLogo.setTooltip(o.getText("APPHDR_LOGO_TOOLTIP"));this.oLogo.setParent(this);this.oLogoText&&this.oLogoText.destroy();this.oLogoText=new i(t+"-logoText");this.oLogoText.setAccessibleRole(a.Heading);this.oLogoText.setParent(this);this.oLogoffBtn&&this.oLogoffBtn.destroy();this.oLogoffBtn=new s(t+"-logoffBtn");var r=o.getText("APPHDR_LOGOFF");this.oLogoffBtn.setText(r);this.oLogoffBtn.setTooltip(r);this.oLogoffBtn.attachPress(this.logoff,this);this.oLogoffBtn.setParent(this);this.oLogoffBtn.setLite(true)};l.prototype.logoff=function(t){this.fireLogoff()};l.prototype.setLogoSrc=function(t){this.initializationDone=false;this.setProperty("logoSrc",t);return this};l.prototype.setLogoText=function(t){this.initializationDone=false;this.setProperty("logoText",t);return this};l.prototype.setUserName=function(t){this.initializationDone=false;this.setProperty("userName",t);return this};l.prototype.setDisplayWelcome=function(t){this.initializationDone=false;this.setProperty("displayWelcome",t);return this};l.prototype.setDisplayLogoff=function(t){this.initializationDone=false;this.setProperty("displayLogoff",t);return this};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ApplicationHeaderRenderer", ["sap/ui/core/theming/Parameters","sap/ui/core/Configuration"],function(e,t){"use strict";var o={};o.render=function(e,t){if(!t.initializationDone){t.initControls();t.initializationDone=true}var o=t.getId();e.write("<header");e.writeControlData(t);e.addClass("sapUiAppHdr");e.writeClasses();e.write(">");e.write('<div id="'+o+'-appHeaderWelcomeLogoffAreas" class="sapUiAppHdrWelcomeLogoffArea sapUiInverted-CTX">');this.renderWelcomeAndLogoffAreas(e,t);e.write("</div>");e.write('<div id="'+o+'-logoArea" class="sapUiAppHdrLogo">');this.renderLogoArea(e,t);e.write("</div>");e.write("</header>")};o.renderLogoArea=function(o,i){var r=i.getLogoSrc();if(!r){r=e._getThemeImage()}if(!r){r=sap.ui.resource("sap.ui.commons","themes/"+t.getTheme()+"/img/applicationheader/SAPLogo.png")}i.oLogo.setSrc(r);o.renderControl(i.oLogo);if(i.getLogoText()!=""){i.oLogoText.setText(i.getLogoText());i.oLogoText.setTooltip(i.getLogoText());o.renderControl(i.oLogoText)}};o.renderWelcomeAndLogoffAreas=function(e,o){var i=o.getId();if(o.getDisplayWelcome()){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var a=t.getRTL()?"padding-left":"padding-right";if(o.getUserName()!=""){e.write('<label class="sapUiLbl sapUiLblEmph" style="text-align: left;" id="'+i+'-welcomeLabel">'+r.getText("APPHDR_WELCOME_USER")+":</label>");e.write("&nbsp;");e.write('<label class="sapUiLbl" style="text-align: left;',a,':15px;" id="',i,'-userLabel">');e.writeEscaped(o.getUserName());e.write("</label>")}else{e.write('<label class="sapUiLbl sapUiLblEmph" style="text-align: left;'+a+':15px;" id="'+i+'-welcomeLabel">'+r.getText("APPHDR_WELCOME")+"</label>")}}if(o.getDisplayLogoff()){if(o.getDisplayWelcome()){e.write('<span role="separator" class="sapUiTbSeparator"></span>')}e.renderControl(o.oLogoffBtn)}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Area", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Element","sap/ui/dom/jquery/control"],function(jQuery,e,r){"use strict";var t=r.extend("sap.ui.commons.Area",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{shape:{type:"string",group:"Misc",defaultValue:null},coords:{type:"string",group:"Misc",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alt:{type:"string",group:"Misc",defaultValue:null}}}});t.prototype.onclick=function(e){var r=jQuery(e.target).control(0);this.getParent().firePress({areaId:r.getId()})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/AutoComplete", ["sap/ui/thirdparty/jquery","./ComboBox","./library","./AutoCompleteRenderer","./TextField","sap/ui/events/KeyCodes","jquery.sap.strings"],function(jQuery,t,e,i,s,r){"use strict";var o=t.extend("sap.ui.commons.AutoComplete",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",deprecated:true,properties:{enableScrolling:{type:"boolean",group:"Misc",defaultValue:true}},events:{suggest:{parameters:{suggestValue:{type:"string"}}}}}});o._DEFAULTFILTER=function(t,e){if(this._skipFilter){return true}return jQuery.sap.startsWithIgnoreCase(e.getText(),t)};o.prototype.init=function(){t.prototype.init.apply(this,arguments);this.mobile=false;this._filter=o._DEFAULTFILTER};o.prototype.exit=function(){if(this._oListBox){this._oListBox.removeAllItems()}t.prototype.exit.apply(this,arguments)};o.prototype.setFilterFunction=function(t){if(typeof t=="function"){this._filter=t}else{this._filter=o._DEFAULTFILTER}};o.prototype.onkeypress=function(t){var e=t.which||t.keyCode;if(e===r.ESCAPE){s.prototype.onkeypress.apply(this,arguments);jQuery(this.getInputDomRef()).removeAttr("aria-posinset")}};o.prototype.onfocusin=function(e){if(!this.$().hasClass("sapUiTfFoc")){t.prototype.onfocusin.apply(this,arguments)}};(function(){function e(t,e){var i=t.getAriaDescribedBy();var s="";for(var r=0;r<i.length;r++){s+=i[r];if(r<i.length-1){s+=" "}}if(e){s+=" "+t.getId()+"-ariaLbl"}return s}function i(t){var i=jQuery(t.getInputDomRef());var s=e(t,false);if(s.length>0){i.attr("aria-describedby",s)}else{i.removeAttr("aria-describedby")}i.removeAttr("aria-posinset");i.removeAttr("aria-setsize")}o.prototype._close=function(){i(this);t.prototype._close.apply(this,arguments)};o.prototype._handleClosed=function(){i(this);t.prototype._handleClosed.apply(this,arguments)};o.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);jQuery(this.getInputDomRef()).removeAttr("aria-setsize")};o.prototype._prepareOpen=function(t){var i=jQuery(this.getInputDomRef());var s=e(this,true);i.attr("aria-describedby",s);i.removeAttr("aria-posinset")};o.prototype._fireLiveChange=function(e){var i=false;var o;if(!this.getEnabled()||!this.getEditable()){this._close()}else{this._sTypedChars=jQuery(this.getInputDomRef()).val();switch(e.type){case"keyup":case"sapup":case"sapdown":case"saphome":case"sapend":if(!t._isHotKey(e)){i=true}else{break}case"sapescape":this._close();break;case"keypress":o=e.which||e.keyCode;if(o===r.ESCAPE){this._close();break}default:s(this);i=true}}if(i){this.fireSuggest({suggestValue:this._sTypedChars})}t.prototype._fireLiveChange.apply(this,arguments)};o.prototype._doTypeAhead=function(){this._sTypeAhead=null;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sTypedChars=jQuery(this.getInputDomRef()).val();s(this)};o.prototype.refreshItems=function(t){var e=this.getBinding("items");if(t=="filter"&&e){e.getContexts()}else{o.prototype.updateItems.apply(this,arguments)}};o.prototype._handleItemsChanged=function(t,e){if(e){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined}if(this._bNoItemCheck){return}var i=[];if(this._getExistingListBox()){i=this._getListBox().getItems()}var s=this.getDomRef();if(s){jQuery(this.getInputDomRef()).attr("aria-setsize",i.length)}};o.prototype.getItems=function(){return this.getAggregation("items",[])};o.prototype.insertItem=function(t,e){this.insertAggregation("items",e,t,true);s(this);return this};o.prototype.addItem=function(t){this.addAggregation("items",t,true);s(this);return this};o.prototype.removeItem=function(t){var e=this.removeAggregation("items",t,true);s(this);return e};o.prototype.removeAllItems=function(){var t=this.removeAllAggregation("items");s(this);return t};o.prototype.indexOfItem=function(t){return this.indexOfAggregation("items",t)};o.prototype.destroyItems=function(){this.destroyAggregation("items",true);s(this);return this};o.prototype.setEnableScrolling=function(t){this.setProperty("enableScrolling",t,true);if(this.oPopup&&this.oPopup.isOpen()){s(this)}return this};function s(t){if(!t.getDomRef()||!t.$().hasClass("sapUiTfFoc")){return false}var e,i=t.getItems(),s=t._sTypedChars&&t._sTypedChars.length>0,r=t._getListBox(),o=t.getMaxPopupItems(),n=t.getEnableScrolling(),p=[];if(!s){t._close();return}r.removeAllItems();r.clearSelection();for(var a=0;a<i.length;a++){e=i[a];if(!e.__CLONE){e.__CLONE=e.clone(e.getId()+"-CLONE",null,{cloneBindings:false});e.__origexit=e.exit;e.exit=function(){this.__CLONE.destroy();delete this.__CLONE;this.exit=this.__origexit;delete this.__origexit;if(typeof this.exit==="function"){this.exit.apply(this,arguments)}}}if((!s||t._filter(t._sTypedChars,e))&&(n||!n&&p.length<o)){p.push(e.__CLONE)}}var h=p.length;if(h>0){if(t._sort){p.sort(function(t,e){if(t.getText()>e.getText()){return 1}if(t.getText()<e.getText()){return-1}return 0})}for(var a=0;a<h;a++){r.addItem(p[a])}r.setVisibleItems(o<h?o:h);if(!t.oPopup||!t.oPopup.isOpen()){t._open()}}else{t._close()}}})();o.prototype.setListBox=function(){return this};o.prototype.setSelectedKey=function(){return this};o.prototype.setSelectedItemId=function(){return this};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/AutoCompleteRenderer", ["./ComboBoxRenderer","sap/ui/core/Renderer","sap/ui/core/library"],function(e,t,r){"use strict";var i=r.ValueState;var n=t.extend(e);n.renderExpander=function(e,t){if(!t.__sARIATXT){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");t.__sARIATXT=r.getText("AUTOCOMPLETE_ARIA_SUGGEST")}e.write('<span id="',t.getId(),'-ariaLbl" style="display:none;">',t.__sARIATXT,"</span>")};n.renderOuterAttributes=function(t,r){t.addClass("sapUiTfAutoComp");e.renderOuterAttributes.apply(this,arguments)};n.renderComboARIAInfo=function(e,t){var r={role:"textbox",owns:t.getId()+"-input "+t._getListBox().getId()};if(!t.getEnabled()){r["disabled"]=true}e.writeAccessibilityState(null,r)};n.renderARIAInfo=function(e,t){var r={autocomplete:"list",live:"polite",relevant:"all",setsize:t._getListBox().getItems().length};if(t.getValueState()==i.Error){r["invalid"]=true}e.writeAccessibilityState(t,r)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Button", ["./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/IconPool","./ButtonRenderer","sap/ui/Device"],function(e,t,o,r,n,i){"use strict";var s=e.ButtonStyle;var a=t.extend("sap.ui.commons.Button",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Appearance",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},helpId:{type:"string",group:"Behavior",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:""},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},styled:{type:"boolean",group:"Appearance",defaultValue:true},lite:{type:"boolean",group:"Appearance",defaultValue:false},style:{type:"sap.ui.commons.ButtonStyle",group:"Appearance",defaultValue:s.Default}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});o.call(a.prototype);a.prototype.onclick=function(e){if(this.getEnabled()&&this.getVisible()){this.firePress({})}e.preventDefault();e.stopPropagation()};a.prototype.onsapenter=function(e){e.stopPropagation()};a.prototype.onmousedown=function(e){this.handleMouseDown(e,true)};a.prototype.handleMouseDown=function(e,t){if(this.getEnabled()&&this.getRenderer().onactive){this.getRenderer().onactive(this)}if(t&&(i.browser.webkit||i.browser.firefox&&navigator.platform.indexOf("Mac")===0)){if(i.browser.mobile&&i.browser.webkit){this.focus()}setTimeout(function(){this.focus()}.bind(this),0)}};a.prototype.onmouseup=function(e){if(this.getEnabled()&&this.getRenderer().ondeactive){this.getRenderer().ondeactive(this)}};a.prototype.onmouseout=function(e){if(this.getEnabled()&&this.getRenderer().onmouseout){this.getRenderer().onmouseout(this)}};a.prototype.onmouseover=function(e){if(this.getEnabled()&&this.getRenderer().onmouseover){this.getRenderer().onmouseover(this)}};a.prototype.onfocusout=function(e){if(this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}};a.prototype.onfocusin=function(e){if(this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this)}};a.prototype.setIcon=function(e){this._setIcon(e,"icon");return this};a.prototype.setIconHovered=function(e){this._setIcon(e,"iconHovered");return this};a.prototype.setIconSelected=function(e){this._setIcon(e,"iconSelected");return this};a.prototype._setIcon=function(e,t){var o=this.getProperty(t);if(o==e){return}var n=false;if(r.isIconURI(o)){n=true}var i=false;if(r.isIconURI(e)){i=true}var s=true;if(!o&&e||o&&!e||n!=i){s=false}this.setProperty(t,e,s);if(s==true&&this.getDomRef()&&this.getRenderer().changeIcon){this.getRenderer().changeIcon(this)}};a.prototype.getAccessibilityInfo=function(){var e=this.getText()||this.getTooltip_AsString();if(!e&&this.getIcon()){var t=r.getIconInfo(this.getIcon());if(t){e=t.text||t.name}}return{role:"button",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_BUTTON"),description:e,focusable:this.getEnabled(),enabled:this.getEnabled()}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ButtonRenderer", ["sap/ui/commons/library","sap/ui/core/IconPool","sap/base/security/encodeXML"],function(t,e,i){"use strict";var s=t.ButtonStyle;var n={};n.render=function(t,n){t.addClass("sapUiBtn");t.write('<button type="button"');t.writeControlData(n);if(n.getTooltip_AsString()){t.writeAttributeEscaped("title",n.getTooltip_AsString())}if(n.getStyled()){t.addClass("sapUiBtnS")}if(n.getLite()){t.addClass("sapUiBtnLite")}else{t.addClass("sapUiBtnNorm")}var a=n.getStyle();if(a!=""&&a!=s.Default){t.addClass("sapUiBtn"+i(a))}t.writeAccessibilityState(n,{role:"button",disabled:!n.getEnabled()});if(!n.getEnabled()){t.write(' tabindex="-1"');t.addClass("sapUiBtnDsbl")}else{t.write(' tabindex="0"');t.addClass("sapUiBtnStd")}var r=false;if(!n.getText()&&n.getIcon()){t.addClass("sapUiBtnIconOnly");r=true;var o=e.getIconInfo(n.getIcon()),c=n.getTooltip_AsString();if(c||o&&o.name){t.writeAttributeEscaped("title",c||o.name)}}if(n.getIcon()&&n.getText()){t.addClass("sapUiBtnIconAndText")}if(n.getWidth()&&n.getWidth()!=""){t.addStyle("width",n.getWidth());t.addClass("sapUiBtnFixedWidth")}if(n.getHeight()&&n.getHeight()!=""){t.addStyle("height",n.getHeight())}t.writeStyles();if(this.renderButtonAttributes){this.renderButtonAttributes(t,n)}t.writeClasses();t.write(">");if(this.renderButtonContentBefore){this.renderButtonContentBefore(t,n)}var g=false;if(e.isIconURI(n.getIcon())){g=true}if(n.getIconFirst()){if(g){this.writeIconHtml(t,n)}else if(this._getIconForState(n,"base")){this.writeImgHtml(t,n,r)}}if(n.getText()){if(!n.getIcon()&&!this.renderButtonContentBefore&&!this.renderButtonContentAfter){t.writeEscaped(n.getText())}else{t.write('<span class="sapUiBtnTxt">');t.writeEscaped(n.getText());t.write("</span>")}}if(!n.getIconFirst()){if(g){this.writeIconHtml(t,n)}else if(this._getIconForState(n,"base")){this.writeImgHtml(t,n,r)}}if(this.renderButtonContentAfter){this.renderButtonContentAfter(t,n)}t.write("</button>")};n.onactive=function(t){t.$().addClass("sapUiBtnAct").removeClass("sapUiBtnStd");t.$("img").attr("src",this._getIconForState(t,"active"))};n.ondeactive=function(t){t.$().addClass("sapUiBtnStd").removeClass("sapUiBtnAct");t.$("img").attr("src",this._getIconForState(t,"deactive"))};n.onblur=function(t){t.$().removeClass("sapUiBtnFoc");t.$("img").attr("src",this._getIconForState(t,"blur"))};n.onfocus=function(t){t.$().addClass("sapUiBtnFoc");t.$("img").attr("src",this._getIconForState(t,"focus"))};n.onmouseout=function(t){t.$().removeClass("sapUiBtnAct");t.$().addClass("sapUiBtnStd");t.$("img").attr("src",this._getIconForState(t,"mouseout"))};n.onmouseover=function(t){t.$("img").attr("src",this._getIconForState(t,"mouseover"))};n._getIconForState=function(t,e){if(!t.getEnabled()){e="disabled"}switch(e){case"focus":case"blur":case"base":if(t.$().hasClass("sapUiBtnAct")){var i=t.getIconSelected()||t.getIconHovered();return i?i:t.getIcon()}else if(t.$().hasClass("sapUiBtnFoc")){return t.getIcon()}return t.getIcon();case"mouseout":if(t.$().hasClass("sapUiBtnFoc")){return t.getIcon()}return t.getIcon();case"active":var i=t.getIconSelected()||t.getIconHovered();return i?i:t.getIcon();case"mouseover":case"deactive":var i=t.getIconHovered();return i?i:t.getIcon()}return t.getIcon()};n.writeImgHtml=function(t,e,i){var s=this._getIconForState(e,"base");t.write("<img");t.writeAttribute("id",e.getId()+"-img");t.writeAttributeEscaped("src",s);if(e.getTooltip_AsString()&&!e.getText()){t.writeAttributeEscaped("alt",e.getTooltip_AsString())}else{t.writeAttribute("alt","")}if(!i){t.writeAttribute("role","presentation")}t.addClass("sapUiBtnIco");if(e.getText()){t.addClass(e.getIconFirst()?"sapUiBtnIcoL":"sapUiBtnIcoR")}t.writeClasses();t.write(">")};n.writeIconHtml=function(t,e){var i=[];var s=a(e);i.push("sapUiBtnIco");if(e.getText()){i.push(e.getIconFirst()?"sapUiBtnIcoL":"sapUiBtnIcoR")}t.writeIcon(e.getIcon(),i,s)};n.changeIcon=function(t){if(e.isIconURI(t.getIcon())){var i=e.getIconInfo(t.getIcon());var s=t.$("icon");s.attr("data-sap-ui-icon-content",i.content);if(!i.skipMirroring){s.addClass("sapUiIconMirrorInRTL")}else{s.removeClass("sapUiIconMirrorInRTL")}}else if(t.$().hasClass("sapUiBtnAct")){t.$("img").attr("src",this._getIconForState(t,"active"))}else if(t.$().hasClass("sapUiBtnFoc")){t.$("img").attr("src",this._getIconForState(t,"focus"))}else if(t.$().hasClass("sapUiBtnStd")){t.$("img").attr("src",this._getIconForState(t,"base"))}};function a(t){var e={},i=t.getTooltip_AsString();e["id"]=t.getId()+"-icon";if(i){e["title"]=null;e["aria-label"]=null;e["aria-hidden"]=true}return e}return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Callout", ["./CalloutBase","./library","./CalloutRenderer"],function(e,t,a){"use strict";var r=e.extend("sap.ui.commons.Callout",{metadata:{library:"sap.ui.commons",deprecated:true,aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CalloutBase", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/TooltipBase","./CalloutBaseRenderer","sap/ui/core/Popup","sap/ui/events/ControlEvents","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Focusable"],function(jQuery,t,e,o,i,s,n,p){"use strict";var r=i.Dock;var u=e.extend("sap.ui.commons.CalloutBase",{metadata:{library:"sap.ui.commons",deprecated:true,events:{open:{parameters:{parent:{type:"sap.ui.core.Control"}}},close:{},beforeOpen:{allowPreventDefault:true,parameters:{parent:{type:"sap.ui.core.Control"}}},opened:{}}}});u.prototype.init=function(){this.oPopup=new i;this.oPopup.setShadow(true);this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.setPosition(r.BeginBottom,r.BeginTop);this.fAnyEventHandlerProxy=jQuery.proxy(this.onAnyEvent,this);var t=this;this.oPopup._applyPosition=function(e){i.prototype._applyPosition.call(this,e);t.setTip()};this.oPopup.setFollowOf(i.CLOSE_ON_SCROLL)};u.prototype.exit=function(){this.oPopup.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this.oPopup.destroy();delete this.oPopup;delete this.oRb;s.unbindAnyEvent(this.fAnyEventHandlerProxy)};u.prototype._getPopup=function(){return this.oPopup};u.prototype.hasChild=function(t){return t&&!!jQuery(t).closest(this.getDomRef()).length};u.prototype.isPopupElement=function(t){if(!t){return false}if(this.hasChild(t)){return true}var e=sap.ui.getCore().getStaticAreaRef();var o=parseInt(jQuery(t).closest(jQuery(e).children()).css("z-index"));var i=parseInt(this.$().css("z-index"));return o&&i&&o>=i};u.prototype.setTip=function(){if(!this.oPopup||!this.oPopup.isOpen()){return}var t=this._currentControl.$(),e=this.$(),o=this.$("arrow"),i=e.offset(),s=t.offset(),n=true,r={},u={l:i.left,r:i.left+e.outerWidth(),w:e.outerWidth(),t:i.top,b:i.top+e.outerHeight(),h:e.outerHeight()},h={l:s.left,r:s.left+t.outerWidth(),w:t.outerWidth(),t:s.top,b:s.top+t.outerHeight(),h:t.outerHeight()},f=(e.outerWidth()-e.innerWidth())/2,l=o.outerWidth()*1.4,a=o.outerWidth()/5,c=a-f-8,d=this.getMyPosition();if(u.r<h.l-c){r.x="right"}else if(u.l-c>h.r){r.x="left"}if(u.t>h.b-c){r.y="top"}else if(u.b<h.t+c){r.y="bottom"}if(r.x){var y=0;if(d.indexOf("top")>-1){y=20}else if(d.indexOf("bottom")>-1){y=u.h-20-l}else{y=(u.h-l)/2}var P=u.t+y+l/2+f;if(P<h.t||P>h.b||h.t>u.t&&h.b<u.b){y=(Math.max(u.t,h.t)+Math.min(u.b,h.b))/2-u.t-l/2}o.css(r.x,c+"px");o.css("top",y);if(y<0||y>u.h-l){n=false}}if(r.y){var m=p.getRTL();if(m){d.replace("begin","right").replace("end","left")}var O=0;if(d.indexOf("begin")>-1||d.indexOf("left")>-1){O=20}else if(d.indexOf("right")>-1||d.indexOf("end")>-1){O=u.w-20-l}else{O=(u.w-l)/2}var v=u.l+O+l/2+f;if(v<h.l||v>h.r){O=(Math.max(u.l,h.l)+Math.min(u.r,h.r))/2-u.l-l/2}o.css(r.y,c+"px");o.css("left",O+"px");if(O<0||O>u.w-l){n=false}}if(r.x&&r.y||!r.x&&!r.y){n=false}o.toggle(n)};u.prototype.adjustPosition=function(){function t(){if(this.oPopup){var t=this._currentControl.getDomRef();this.oPopup.setPosition(this.getMyPosition(),this.getAtPosition(),t,this.getOffset(),this.getCollision())}}setTimeout(jQuery.proxy(t,this),0)};u.prototype.focus=function(){if(this.oPopup&&this.oPopup.isOpen()){var t=this.$("cont");h(t.firstFocusableDomRef()||t.get(0))}};u.prototype.openPopup=function(t){if(!this.oPopup||this.oPopup.isOpen()){return}if(e.sOpenTimeout){clearTimeout(e.sOpenTimeout);e.sOpenTimeout=undefined}if(!this.fireEvent("beforeOpen",{parent:this._currentControl},true,false)){if(!this.sCloseNowTimeout){e.sOpenTimeout=setTimeout(function(){this.openPopup(this._currentControl)}.bind(this),200)}return}this.oParentFocusInfo=t.getFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);e.prototype.openPopup.call(this,t);this.adjustPosition();this.fireOpen({parent:this._currentControl})};u.prototype.close=function(){if(this.oPopup&&this.oPopup.isOpen()&&!this.sCloseNowTimeout){if(e.sOpenTimeout){clearTimeout(e.sOpenTimeout);e.sOpenTimeout=undefined}this.closePopup()}};u.prototype.closePopup=function(){var t=this.oPopup!==undefined&&this.oPopup.isOpen();if(this.fAnyEventHandlerProxy){s.unbindAnyEvent(this.onAnyEvent)}e.prototype.closePopup.call(this);if(t&&this._currentControl&&this.bFocused){this._currentControl.applyFocusInfo(this.oParentFocusInfo);this.bFocused=false}this.fireClose()};u.prototype.handleClosed=function(){if(this.oPopup){this.oPopup.detachEvent("closed",this.handleClosed,this);this.fireClosed()}};u.prototype.onkeydown=function(t){var o=t.ctrlKey&&t.which==n.I;var i=t.which==n.ESCAPE;if(!o&&!i){if(jQuery(t.target).control(0)===this._currentControl){this.close()}return}if(o){if(this.oPopup&&this.oPopup.isOpen()){return}this.bDoFocus=true}e.prototype.onkeydown.call(this,t)};u.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);if(this.bDoFocus){this.focus();this.bDoFocus=false;this.bFocused=true}this.$().css("display","");this.fireOpened();s.bindAnyEvent(this.fAnyEventHandlerProxy)};u.prototype.onfocusin=function(t){this.bFocused=true;var e=t.target;if(e.id===this.getId()+"-fhfe"){h(this.$("cont").lastFocusableDomRef())}else if(e.id===this.getId()+"-fhee"){h(this.$("cont").firstFocusableDomRef())}};u.prototype.onfocusout=function(t){return};u.prototype.onmouseover=function(t){if(this.oPopup&&(this.oPopup.isOpen()&&this.oPopup.getContent()==this)){if(this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null}return}else{e.prototype.onmouseover.call(this,t)}};u.prototype.onmouseout=function(t){if(this.oPopup&&(this.oPopup.isOpen()&&this.isPopupElement(t.relatedTarget))){return}e.prototype.onmouseout.call(this,t)};u.prototype.onmousedown=function(t){if(jQuery(t.target).control(0)===this._currentControl){this.close();this.removeStandardTooltips()}};u.prototype.onAnyEvent=function(t){if(this.oPopup&&!this.oPopup.isOpen()||t.type!="mouseover"||this.hasChild(t.target)){return}var o=this.isPopupElement(t.target)||jQuery(t.target).control(0)===this._currentControl;if(!o&&!this.sCloseNowTimeout&&!e.sOpenTimeout){this.sCloseNowTimeout=setTimeout(function(){this.closePopup()}.bind(this),400)}if(o&&this.sCloseNowTimeout){clearTimeout(this.sCloseNowTimeout);this.sCloseNowTimeout=null}};u.prototype.setPosition=function(t,e){var o=t||r.BeginBottom;var i=e||r.BeginTop;var s=0,n=0,p=0,u=0,h=5;if(o.indexOf("begin")>-1||o.indexOf("left")>-1){s=-1}else if(o.indexOf("right")>-1||o.indexOf("end")>-1){s=1}if(i.indexOf("begin")>-1||i.indexOf("left")>-1){p=-1}else if(i.indexOf("right")>-1||i.indexOf("end")>-1){p=1}if(o.indexOf("top")>-1){n=-1}else if(o.indexOf("bottom")>-1){n=1}if(i.indexOf("top")>-1){u=-1}else if(i.indexOf("bottom")>-1){u=1}var f=(s-p)*s*p*h+" "+(n-u)*n*u*h;this.setMyPosition(o);this.setAtPosition(i);this.setOffset(f);return this};function h(t){if(t){t.focus()}}return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CalloutBaseRenderer", ["sap/ui/core/Configuration"],function(t){"use strict";var e={};e.render=function(e,i){var s=t.getAccessibility();var r=i.getId();e.write("<div");e.writeControlData(i);e.addClass("sapUiCltBase");if(this.addRootClasses){this.addRootClasses(e,i)}e.writeClasses();if(s){e.writeAttribute("role","dialog");var a=i.oRb.getText("CALLOUT_ARIA_NAME");if(a){e.writeAttributeEscaped("aria-label",a)}}if(i.getTooltip_AsString()){e.writeAttributeEscaped("title",i.getTooltip_AsString())}e.addStyle("display","none");e.writeStyles();e.write(">");e.write('<span id="'+r+'-fhfe" tabindex="0"></span>');e.write("<div");e.writeAttribute("id",r+"-cont");e.addClass("sapUiCltBaseCont");if(this.addContentClasses){this.addContentClasses(e,i)}e.writeClasses();e.writeAttribute("tabindex","-1");e.write(">");if(this.renderContent){this.renderContent(e,i)}e.write("</div>");e.write("<div");e.writeAttribute("id",r+"-arrow");if(s){e.writeAttribute("role","presentation")}e.addClass("sapUiCltBaseArr");if(this.addArrowClasses){this.addArrowClasses(e,i)}e.writeClasses();e.write("></div>");e.write('<span id="'+r+'-fhee" tabindex="0"></span>');e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CalloutRenderer", ["./CalloutBaseRenderer","sap/ui/core/Renderer"],function(e,n){"use strict";var t=n.extend(e);t.renderContent=function(e,n){var t=n.getContent();for(var s=0;s<t.length;s++){e.renderControl(t[s])}};t.addRootClasses=function(e,n){e.addClass("sapUiClt")};t.addContentClasses=function(e,n){e.addClass("sapUiCltCont")};t.addArrowClasses=function(e,n){e.addClass("sapUiCltArr")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Carousel", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/strings/capitalize","sap/ui/dom/containsOrEquals","./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","./CarouselRenderer","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/Selectors","sap/ui/dom/jquery/Focusable"],function(jQuery,t,e,i,s,o,n,a,r,l,h,d){"use strict";var u=s.enums.Orientation;var c=o.extend("sap.ui.commons.Carousel",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{orientation:{type:"sap.ui.commons.enums.Orientation",group:"Misc",defaultValue:u.horizontal},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},defaultItemHeight:{type:"int",group:"Misc",defaultValue:150},defaultItemWidth:{type:"int",group:"Misc",defaultValue:150},animationDuration:{type:"int",group:"Misc",defaultValue:500},visibleItems:{type:"int",group:"Misc",defaultValue:null},handleSize:{type:"int",group:"Misc",defaultValue:22},firstVisibleIndex:{type:"int",group:"Appearance",defaultValue:0}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",bindable:"bindable"}}}});c.prototype.init=function(){this._visibleItems=0;this.data("sap-ui-fastnavgroup","true",true)};c.prototype.exit=function(){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}this._destroyItemNavigation()};c.prototype.onclick=function(t){switch(t.target){case this.getDomRef("prevbutton"):this.showPrevious();break;case this.getDomRef("nextbutton"):this.showNext();break;default:return}};c.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};c.prototype.onAfterRendering=function(){if(this.getOrientation()=="vertical"){this._sAnimationAttribute="margin-top"}else{if(d.getRTL()){this._sAnimationAttribute="margin-right"}else{this._sAnimationAttribute="margin-left"}}this.showElementWithId(this._getItemIdByIndex(this.getFirstVisibleIndex()));this.calculateAndSetSize();this.oDomRef=this.getDomRef();this.sResizeListenerId=n.register(this.oDomRef,jQuery.proxy(this.onresize,this));this._initItemNavigation()};c.prototype._initItemNavigation=function(){var t=this.$("scrolllist");if(!this._oItemNavigation){this._oItemNavigation=new a;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._oItemNavigation.attachEvent(a.Events.AfterFocus,function(t){var e=this.$("contentarea"),i=this.$("scrolllist");var s=t.getParameter("event");if(s&&s.type=="mousedown"){var o=false;for(var n=0;n<i.children().length;n++){var a=i.children()[n];if(s.target.id==a.id){o=true;break}}if(!o){s.target.focus()}}if(d.getRTL()){e.scrollLeft(i.width()-e.width())}else{e.scrollLeft(0)}},this)}this._oItemNavigation.setRootDomRef(t[0]);this._oItemNavigation.setItemDomRefs(t.children())};c.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this._oItemNavigation.destroy();this._oItemNavigation=undefined}};c.prototype.onThemeChanged=function(t){this.calculateAndSetSize()};c.prototype.onfocusin=function(t){var e=jQuery(t.target);if(!this._bIgnoreFocusIn&&(e.hasClass("sapUiCrslBefore")||e.hasClass("sapUiCrslAfter"))){this._leaveActionMode();jQuery(this._oItemNavigation.getFocusedDomRef()||this._oItemNavigation.getRootDomRef()).trigger("focus")}};c.prototype.onsaptabnext=function(t){var e=this.$();if(this._bActionMode){if(e.find(".sapUiCrslScl").lastFocusableDomRef()===t.target){e.find(".sapUiCrslScl").firstFocusableDomRef().focus();t.preventDefault();t.stopPropagation()}}else{if(this._oItemNavigation.getFocusedDomRef()===t.target){this._bIgnoreFocusIn=true;e.find(".sapUiCrslAfter").trigger("focus");this._bIgnoreFocusIn=false}}};c.prototype.onsaptabprevious=function(t){var e=this.$();if(this._bActionMode){if(e.find(".sapUiCrslScl").firstFocusableDomRef()===t.target){e.find(".sapUiCrslScl").lastFocusableDomRef().focus();t.preventDefault();t.stopPropagation()}}else{if(this._oItemNavigation.getFocusedDomRef()===t.target&&i(e.find(".sapUiCrslScl").get(0),t.target)){this._bIgnoreFocusIn=true;e.find(".sapUiCrslBefore").trigger("focus");this._bIgnoreFocusIn=false}}};c.prototype.onsapescape=function(t){this._leaveActionMode(t)};c.prototype.onsapnext=function(t){var e=jQuery(t.target);var i=this.$("scrolllist");i.stop(true,true);if(e.hasClass("sapUiCrslItm")&&e.nextAll(":visible").length<2){this.showNext();t.preventDefault()}};c.prototype.onsapprevious=function(t){var e=jQuery(t.target);var i=this.$("scrolllist");i.stop(true,true);if(e.hasClass("sapUiCrslItm")&&e.prevAll(":visible").length<2){this.showPrevious();t.preventDefault()}};c.prototype.onkeydown=function(t){var e=this.$();if(!this._bActionMode&&t.keyCode==h.F2||t.keyCode==h.ENTER){if(e.find(".sapUiCrslScl li:focus").length>0){this._enterActionMode(e.find(".sapUiCrslScl li:focus :sapFocusable").get(0));t.preventDefault();t.stopPropagation()}}else if(this._bActionMode&&t.keyCode==h.F2){this._leaveActionMode(t)}};c.prototype.onmouseup=function(t){if(this.$().find(".sapUiCrslScl li :focus").length>0){this._enterActionMode(this.$().find(".sapUiCrslScl li :focus").get(0))}else{this._leaveActionMode(t)}};if(l.support.touch){c.prototype.onswipeleft=function(t){this.showNext()};c.prototype.onswiperight=function(t){this.showPrevious()}}c.prototype._enterActionMode=function(t){if(t&&!this._bActionMode){this._bActionMode=true;this.removeDelegate(this._oItemNavigation);jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","-1");this.$("scrolllist").attr("aria-activedescendant",jQuery(this._oItemNavigation.getFocusedDomRef()).attr("id"));jQuery(t).trigger("focus")}};c.prototype._leaveActionMode=function(t){if(this._bActionMode){this._bActionMode=false;this.addDelegate(this._oItemNavigation);jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex","0");this.$("scrolllist").removeAttr("aria-activedescendant");if(t){if(jQuery(t.target).closest("li[tabindex=-1]").length>0){var e=jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(t.target).closest("li[tabindex=-1]").get(0));this._oItemNavigation.focusItem(e,null)}else{if(i(this.$().find(".sapUiCrslScl").get(0),t.target)){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null)}}}else{this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(),null)}}};c.prototype.onresize=function(t){if(!this.getDomRef()){if(this.sResizeListenerId){n.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}this.calculateAndSetSize()};c.prototype.showPrevious=function(){var t=this,e={},i=this.$("scrolllist");var s,o;e[this._sAnimationAttribute]=0;if(i.children("li").length<2){return}i.stop(true,true);i.css(this._sAnimationAttribute,-this._iMaxWidth);s=i.children("li:last");o=i.children("li:first");this._showAllItems();s.insertBefore(o);i.append(s.sapExtendedClone(true));i.animate(e,this.getAnimationDuration(),function(){i.children("li:last").remove();t.setProperty("firstVisibleIndex",t._getContentIndex(i.children("li:first").attr("id")),true);t._hideInvisibleItems()})};c.prototype.showNext=function(){var t=this,e={},i=this._sAnimationAttribute,s=this.$("scrolllist");var o;e[this._sAnimationAttribute]=-this._iMaxWidth;if(s.children("li").length<2){return}s.stop(true,true);this._showAllItems();o=s.children("li:first");o.appendTo(s);o.sapExtendedClone(true).insertBefore(s.children("li:first"));s.animate(e,this.getAnimationDuration(),function(){s.children("li:first").remove();jQuery(this).css(i,"0px");t.setProperty("firstVisibleIndex",t._getContentIndex(s.children("li:first").attr("id")),true);t._hideInvisibleItems()})};c.prototype.showElementWithId=function(t){this._showAllItems();var e=this.$("scrolllist"),i;i=e.children("li").index(this.getDomRef("item-"+t));e.children("li:lt("+i+")").appendTo(e);this._hideInvisibleItems()};c.prototype.calculateAndSetSize=function(){var t=this._getDimensions();var i=t.maxWidth;var s=t.maxHeight;var o;var n=this.getVisibleItems();var a=this.$();var r=this.$("nextbutton");var l=this.$("prevbutton");var h=this.$("contentarea");this._showAllItems();if(this.getContent().length<=0){return}if(this.getWidth()&&this.getOrientation()=="vertical"){i=a.width()}if(this.getHeight()&&this.getOrientation()=="horizontal"){s=a.height()}this.$().addClass("sapUiCrsl"+e(this.getOrientation()));if(this.getOrientation()=="horizontal"){o=a.width()-this.getHandleSize()*2-1;h.css("left",this.getHandleSize()+"px").css("right",this.getHandleSize()+"px");if(n==0){n=Math.floor(o/i)}i=o/n;this._iMaxWidth=i;var d=s+"px";h.find(".sapUiCrslItm").css("width",i+"px").css("height",s+"px").css("display","inline-block");l.css("height",s).css("line-height",d);r.css("height",s).css("line-height",d);h.height(s);a.height(s);var u=this.getContent().length<n?this.getContent().length:n;if(this.getWidth()){a.width(this.getWidth())}else{var c=a.width()-(i*u+(this.getHandleSize()*2-1));if(c>5){a.width(i*u+(this.getHandleSize()*2-1))}}}else{o=a.height()-this.getHandleSize()*2-1;h.css("top",this.getHandleSize()+"px").css("bottom",this.getHandleSize()+"px");if(n==0){n=Math.floor(o/s)}s=o/n;this._iMaxWidth=s;h.find(".sapUiCrslItm").css("width",i+"px").css("height",s+"px").css("display","block");l.width(i).after(h);r.width(i);h.width(i);a.width(i)}this._visibleItems=n;this._hideInvisibleItems()};c.prototype._getDimensions=function(){var t=this.getContent();var e=0;var i=0;for(var s=0;s<t.length;s++){var o,n;try{o=t[s].getWidth();if(o.substr(-1)=="%"){o=this.getDefaultItemWidth()}}catch(t){o=this.getDefaultItemWidth()}try{n=t[s].getHeight();if(n.substr(-1)=="%"){n=this.getDefaultItemHeight()}}catch(t){n=this.getDefaultItemHeight()}e=Math.max(e,parseInt(o));i=Math.max(i,parseInt(n))}if(e==0||isNaN(e)){e=this.getDefaultItemWidth()}if(i==0||isNaN(i)){i=this.getDefaultItemHeight()}return{maxWidth:e,maxHeight:i}};c.prototype.getFocusDomRef=function(){return this.$("scrolllist")[0]};c.prototype._showAllItems=function(){var t=this.$("contentarea");t.find(".sapUiCrslItm").show().css("display","inline-block")};c.prototype._hideInvisibleItems=function(){var t=this.$("contentarea");t.find(".sapUiCrslItm:gt("+(this._visibleItems-1)+")").hide()};c.prototype._getContentIndex=function(t){var e=t.split("-item-");return jQuery.inArray(sap.ui.getCore().byId(e[1]),this.getContent())};c.prototype._getItemIdByIndex=function(t){var e=this.getContent()[t];if(!e){return null}return e.getId()};c.prototype.setFirstVisibleIndex=function(e){if(e>this.getContent().length-1){t.warning("The index is invalid. There are less items available in the carousel.");return this}this.setProperty("firstVisibleIndex",e,true);this.showElementWithId(this._getItemIdByIndex(e));if(this._oItemNavigation){this._oItemNavigation.focusItem(e)}return this};
//Licensed under the terms of the MIT source code license
(function(t){jQuery.fn.sapExtendedClone=function(){var e=t.apply(this,arguments);var i=this.find("textarea").add(this.filter("textarea"));var s=e.find("textarea").add(e.filter("textarea"));var o=this.find("select").add(this.filter("select"));var n=e.find("select").add(e.filter("select"));for(var a=0,r=i.length;a<r;++a){jQuery(s[a]).val(jQuery(i[a]).val())}for(var a=0,r=o.length;a<r;++a){n[a].selectedIndex=o[a].selectedIndex}return e}})(jQuery.fn.clone);return c});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CarouselRenderer", ["sap/ui/core/Configuration"],function(t){"use strict";var e={};e.render=function(e,i){var r=t.getRTL();e.write("<div");e.addClass("sapUiCrsl");if(i.getWidth()!=""){e.addStyle("width",i.getWidth())}if(i.getHeight()!=""){e.addStyle("height",i.getHeight())}e.writeStyles();e.writeClasses();e.writeControlData(i);e.write(">");var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");e.write("<div");e.writeAttribute("id",i.getId()+"-prevbutton");e.writeAttribute("title",s.getText("CAROUSEL_SHOW_PREV"));e.addClass("sapUiCrslPrevBtn");e.writeClasses();if(i.getHandleSize()!=22){if(i.getOrientation()=="vertical"){e.addStyle("height",i.getHandleSize()+"px")}else{e.addStyle("width",i.getHandleSize()+"px")}e.writeStyles()}e.write(">");if(i.getOrientation()=="vertical"){e.write("&#9650")}else{if(r){e.write("&#9658")}else{e.write("&#9668")}}e.write("</div>");e.write("<div");e.writeAttribute("id",i.getId()+"-nextbutton");e.writeAttribute("title",s.getText("CAROUSEL_SHOW_NEXT"));e.addClass("sapUiCrslNextBtn");e.writeClasses();if(i.getHandleSize()!=22){if(i.getOrientation()=="vertical"){e.addStyle("height",i.getHandleSize()+"px")}else{e.addStyle("width",i.getHandleSize()+"px")}e.writeStyles()}e.write(">");if(i.getOrientation()=="vertical"){e.write("&#9660")}else{if(r){e.write("&#9668")}else{e.write("&#9658")}}e.write("</div>");e.write("<div");e.writeAttribute("id",i.getId()+"-contentarea");e.addClass("sapUiCrslCnt");e.writeClasses();e.write(">");var a=i.getContent();e.write("<ul");e.writeAttribute("id",i.getId()+"-scrolllist");e.writeAttribute("role","listbox");e.writeAttribute("aria-describedby",i.getId()+"-navigate");e.addClass("sapUiCrslScl");e.writeClasses();e.write(">");for(var d=0;d<a.length;d++){var l=a[d];e.write("<li");e.writeAttribute("id",i.getId()+"-item-"+l.getId());e.writeAccessibilityState(i,{role:"option",posinset:d+1,setsize:a.length,labelledby:i.getId()+"-toggleaction"});e.writeAttribute("tabindex","-1");e.addClass("sapUiCrslItm");e.writeClasses();e.write(">");e.renderControl(l);e.write("</li>")}e.write("</ul>");e.write("</div>");e.write("<div");e.writeAttribute("tabindex","0");e.addClass("sapUiCrslBefore");e.writeClasses();e.write("></div>");e.write("<div");e.writeAttribute("tabindex","0");e.addClass("sapUiCrslAfter");e.writeClasses();e.write("></div>");e.write("<span");e.writeAttribute("id",i.getId()+"-toggleaction");e.addStyle("position","absolute");e.addStyle("top","-20000px");e.writeStyles();e.write(">");e.write(s.getText("CAROUSEL_ACTION_MODE"));e.write("</span>");e.write("<span");e.writeAttribute("id",i.getId()+"-navigate");e.addStyle("position","absolute");e.addStyle("top","-20000px");e.writeStyles();e.write(">");e.write(s.getText("CAROUSEL_NAV"));e.write("</span>");e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CheckBox", ["./library","sap/ui/core/Control","./CheckBoxRenderer","sap/ui/core/library","sap/ui/Device"],function(e,t,a,i,o){"use strict";var r=i.TextDirection;var s=i.ValueState;var l=t.extend("sap.ui.commons.CheckBox",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{checked:{type:"boolean",group:"Data",defaultValue:false,bindable:"bindable"},text:{type:"string",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:s.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:r.Inherit},name:{type:"string",group:"Misc",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{checked:{type:"boolean"}}}}}});l.prototype.onclick=function(e){if(o.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",0).addClass("sapUiCbFoc")}this.userToggle(e)};l.prototype.onfocusout=function(e){if(o.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",-1).removeClass("sapUiCbFoc")}};l.prototype.onsapspace=function(e){this.userToggle(e)};l.prototype.userToggle=function(e){e.preventDefault();if(this.getEnabled()&&this.getEditable()){this.toggle();this.fireChange({checked:this.getChecked()})}else{this.getDomRef().focus()}};l.prototype.toggle=function(){this.setChecked(!this.getChecked());return this};l.prototype.getAccessibilityInfo=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"checkbox",type:e.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getChecked()?" "+e.getText("ACC_CTR_STATE_CHECKED"):""),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEditable()}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/CheckBoxRenderer", ["sap/ui/core/ValueStateSupport","sap/ui/core/library"],function(e,t){"use strict";var i=t.TextDirection;var a=t.ValueState;var r=t.AccessibleRole;var s={};s.render=function(t,i){t.addClass("sapUiCb");t.write("<span");t.writeControlData(i);t.writeAccessibilityState(i,{role:r.Checkbox.toLowerCase()});t.writeAttributeEscaped("aria-labelledby",i.getId()+"-label");var s=i.getEnabled()!=null&&i.getEnabled();var d=i.getEditable()!=null&&i.getEditable();var l=false;var b=false;if(i.getValueState()!=null){l=a.Error==i.getValueState();b=a.Warning==i.getValueState()}if(i.getChecked()){t.addClass("sapUiCbChk")}var n=0;if(!d){t.addClass("sapUiCbRo");n=0}if(!s){t.addClass("sapUiCbDis");n=-1}if(l){t.addClass("sapUiCbErr");t.writeAttribute("aria-invalid","true")}else if(b){t.addClass("sapUiCbWarn")}if(s&&d&&!l&&!b){t.addClass("sapUiCbStd")}if(s&&d){t.addClass("sapUiCbInteractive")}t.writeClasses();if(i.getWidth()&&i.getWidth()!=""){t.writeAttribute("style","width:"+i.getWidth()+";")}t.writeAttribute("tabindex",n);t.write(">");t.write("<input type='CheckBox' tabindex='-1' id='");t.write(i.getId());t.write("-CB'");if(i.getName()){t.writeAttributeEscaped("name",i.getName())}if(i.getChecked()){t.write(" checked='checked'")}if(!s){t.write(" disabled='disabled'")}var w=e.enrichTooltip(i,i.getTooltip_AsString());if(w){t.writeAttributeEscaped("title",w)}if(!d){t.write(" disabled='disabled'")}t.write(">");t.write("<label");t.writeAttributeEscaped("id",i.getId()+"-label");if(w){t.writeAttributeEscaped("title",w)}t.writeAttribute("for",i.getId()+"-CB");if(!i.getText()){t.write(" class='sapUiCbNoText'")}t.write(">");if(i.getText()){this.renderText(t,i.getText(),i.getTextDirection())}t.write("</label>");t.write("</span>")};s.renderText=function(e,t,a){if(!a||a==i.Inherit){e.writeEscaped(t)}else{e.write('<span style="direction:'+a.toLowerCase()+';">');e.writeEscaped(t);e.write("</span>")}};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ColorPicker", ["./library","sap/ui/unified/ColorPicker","sap/base/Log"],function(r,e,i){"use strict";var a=e.extend("sap.ui.commons.ColorPicker",{metadata:{deprecated:true,library:"sap.ui.commons"},renderer:"sap.ui.unified.ColorPickerRenderer"});try{sap.ui.getCore().loadLibrary("sap.ui.unified")}catch(r){i.error("The control 'sap.ui.commons.ColorPicker' needs library 'sap.ui.unified'.");throw r}return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ComboBox", ["sap/ui/thirdparty/jquery","./TextField","./library","sap/ui/Device","sap/ui/core/Popup","./ComboBoxRenderer","sap/ui/core/library","./ListBox","sap/ui/base/Event","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes","sap/ui/events/jquery/EventExtension","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/selectText","jquery.sap.strings"],function(jQuery,e,t,i,s,o,n,a,d,r,h,l){"use strict";var p=n.AccessibleRole;var g=e.extend("sap.ui.commons.ComboBox",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",deprecated:true,properties:{maxPopupItems:{type:"int",group:"Behavior",defaultValue:10},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:null},selectedItemId:{type:"string",group:"Data",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item",bindable:"bindable"},myListBox:{type:"sap.ui.commons.ListBox",multiple:false,visibility:"hidden"}},associations:{listBox:{type:"sap.ui.commons.ListBox",multiple:false}}}});g.prototype.init=function(){e.prototype.init.apply(this,arguments);this._iClosedUpDownIdx=-1;this._sCloseId=null;this.setAccessibleRole(p.Combobox);if(!i.system.desktop){this.mobile=true}};g.prototype.exit=function(){if(this._oListBox){if(this._oListBoxDelegate){this._oListBox.removeDelegate(this._oListBoxDelegate)}if(this.getAggregation("myListBox")){this.destroyAggregation("myListBox",true)}else{this._oListBox.destroy()}this._oListBox=null}else if(this.getListBox()){var e=sap.ui.getCore().byId(this.getListBox());if(e){e.detachEvent("itemsChanged",this._handleItemsChanged,this);e.detachEvent("itemInvalidated",this._handleItemInvalidated,this)}}this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;if(this._sHandleItemsChanged){clearTimeout(this._sHandleItemsChanged);this._sHandleItemsChanged=null;this._bNoItemCheck=undefined}};g.prototype.onclick=function(e){if(this.getEnabled&&this.getEnabled()&&this.getEditable()&&e.target===this.getF4ButtonDomRef()){if(this.oPopup&&this.oPopup.isOpen()){this._close()}else if(!this._F4ForClose){this._open()}this.focus()}this._F4ForClose=false};g.prototype.onmousedown=function(e){var t=this.getF4ButtonDomRef();if(e.target!==t||!this.getEnabled()||!this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){e.stopPropagation()}return}else if(e.target==t&&jQuery(this.getFocusDomRef()).data("sap.INItem")){e.stopPropagation();this.focus()}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true}else{this._F4ForOpen=true}};g.prototype.onsapshow=function(e){if(this.mobile){return}if(this.oPopup&&this.oPopup.isOpen()){this._close()}else{this._open()}e.preventDefault();e.stopImmediatePropagation()};g.prototype.onsapnextmodifiers=function(t){e.prototype.onsapnextmodifiers.apply(this,arguments);if(t.keyCode==h.ARROW_DOWN&&t.altKey){this.onsapshow(t);t.stopPropagation()}};g.prototype.onsaphide=function(e){if(this.mobile){return}this._close();e.stopPropagation()};g.prototype.onsapescape=function(t){if(this.oPopup&&this.oPopup.isOpen()){this._close();t.stopPropagation()}e.prototype.onsapescape.apply(this,arguments);var i=this.getSelectedItemId();if(i){var s=sap.ui.getCore().byId(i);this._iClosedUpDownIdx=this.indexOfItem(s);var o=this._getListBox();o.setSelectedIndex(this._iClosedUpDownIdx);this._updatePosInSet(null,this._iClosedUpDownIdx+1,s.getAdditionalText?s.getAdditionalText():"")}else{this._updatePosInSet(null,-1,null);this._iClosedUpDownIdx=-1}};g.prototype.onsapenter=function(e){this._close();this._checkChange(e)};g.prototype.onsapfocusleave=function(t){var i=this._getListBox();if(t.relatedControlId&&r(i.getFocusDomRef(),sap.ui.getCore().byId(t.relatedControlId).getFocusDomRef())||this._bOpening){this.focus()}else{e.prototype.onsapfocusleave.apply(this,arguments)}};g.prototype._checkChange=function(e,t){var i=this.getInputDomRef();if(!i){return}var s=jQuery(i).val(),o=this.getValue();if(!this._F4ForOpen&&(this.getEditable()&&this.getEnabled())){var n=this.getItems(),a=null,d,r,h,l;if(o!=s){this.setValue(s,true);for(var p=0,g=n.length;p<g;p++){d=n[p].getText();if(d===s){if(p==this._iClosedUpDownIdx){a=n[p];r=a.getKey();h=a.getId();l=p;break}else if(!l){a=n[p];r=a.getKey();h=a.getId();l=p}}}this.setProperty("selectedKey",r,true);this.setProperty("selectedItemId",h,true);if(h){this._iClosedUpDownIdx=l}else{this._iClosedUpDownIdx=-1}if(this.mobile){if(!h){this._addDummyOption(s)}else{this._removeDummyOption();this.getDomRef("select").selectedIndex=l}}}else{var u=this.getSelectedItemId();var f;l=this._iClosedUpDownIdx;if(l>=0){a=n[l];if(a.getText()==s){f=a.getId()}}if(f&&f!=u){this.setSelectedItemId(f,true)}else{return}}this.fireChange({newValue:s,selectedItem:a})}};g.prototype.onkeypress=function(t){if(t.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}if(this._sTypeAhead){clearTimeout(this._sTypeAhead)}if(g._isHotKey(t)||t.keyCode===h.F4&&t.which===0){return}var i=t.which||t.keyCode;if(i!==h.DELETE&&i!==h.BACKSPACE&&i!==h.ESCAPE){this._sTypeAhead=setTimeout(function(){this._doTypeAhead()}.bind(this),200)}else{e.prototype.onkeypress.apply(this,arguments);if(i!==h.ESCAPE){this._updatePosInSet(null,-1,null)}}};g.prototype.onsapup=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")){return}var t=this._getListBox(),i=t.getItems(),s=this.getInputDomRef(),o=jQuery(s).val();var n=this._prepareUpDown(i,o);n=this._updateIdx(i,s,n-1,n,e);e.preventDefault();e.stopPropagation()};g.prototype.onsapdown=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")){return}var t=this._getListBox(),i=t.getItems(),s=this.getInputDomRef(),o=jQuery(s).val();var n=this._prepareUpDown(i,o);n=this._updateIdx(i,s,n+1,n,e);e.preventDefault();e.stopPropagation()};g.prototype.onsaphome=function(t){e.prototype.onsaphome.apply(this,arguments);if(t.target.id==this.getId()+"-select"){return}if(!this.getEditable()||!this.getEnabled()||!this.oPopup||!this.oPopup.isOpen()){return}var i=this._getListBox(),s=i.getItems(),o=this.getInputDomRef();this._updateIdx(s,o,0,undefined,t);t.preventDefault();t.stopPropagation()};g.prototype.onsapend=function(t){e.prototype.onsapend.apply(this,arguments);if(t.target.id==this.getId()+"-select"){return}if(!this.getEditable()||!this.getEnabled()||!this.oPopup||!this.oPopup.isOpen()){return}var i=this._getListBox(),s=i.getItems(),o=this.getInputDomRef();var n=s.length-1;n=this._updateIdx(s,o,n,undefined,t);t.preventDefault();t.stopPropagation()};g.prototype._doTypeAhead=function(){this._sTypeAhead=null;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;var e=this._getListBox(),t=e.getItems(),i,s,o=jQuery(this.getInputDomRef()),n=o.val(),a=jQuery.sap.startsWithIgnoreCase;this._sTypedChars=n;var d=false;var r=0;for(var h=t.length;r<h;r++){i=t[r];s=""+i.getText();if(a(s,n)&&i.getEnabled()){this._updatePosInSet(o,r+1,i.getAdditionalText?i.getAdditionalText():"");o.val(s);this._doSelect(n.length,s.length);e.setSelectedIndex(r);e.scrollToIndex(r,true);d=true;if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=r}return}}e.clearSelection();e.scrollToIndex(r,true);if(!d){this._updatePosInSet(o,-1,null);if(this.mobile){this._addDummyOption(n)}}};g.prototype._prepareUpDown=function(e,t){var i;if(this._iClosedUpDownIdx>=0&&e[this._iClosedUpDownIdx]&&e[this._iClosedUpDownIdx].getText()!==t){this._iClosedUpDownIdx=-1}if(this._iClosedUpDownIdx===-1){for(var s=0,o=e.length;s<o;s++){i=e[s].getText();if(i===t){this._iClosedUpDownIdx=s;break}}}return this._iClosedUpDownIdx};g.prototype._updateIdx=function(e,t,i,s,o){var n=e.length,a=i===0&&s===undefined,d=s!==undefined&&s<i||a,r,h=jQuery(t);if(i<0){r=0}else if(i<n){r=i}else{r=n-1}var l,p=false;do{i=d?r++:r--;l=e[i];p=l&&l.getEnabled()&&!(l instanceof sap.ui.core.SeparatorItem)&&l.getId()!==this.getId()+"_shi"}while(!p&&r<n&&r>=0);if(p){var g=l.getText();var u=i+1;if(this._determinePosinset){u=this._determinePosinset(e,i)}this._updatePosInSet(h,u,l.getAdditionalText?l.getAdditionalText():"");h.val(g);this._doSelect();this._fireLiveChange(o);var f=this._getListBox();f.setSelectedIndex(i);f.scrollToIndex(i,true)}else{i=s}this._iClosedUpDownIdx=i;return i};g.prototype._doSelect=function(e,t){var i=this.getInputDomRef();if(i){var s=jQuery(i);i.focus();s.selectText(e?e:0,t?t:s.val().length)}return this};g.prototype.getF4ButtonDomRef=function(){return this.getDomRef("icon")};g.prototype._getPrivateListBox=function(){if(this._oListBox){return this._oListBox}this._oListBox=new a(this.getId()+"-lb",{allowMultiSelect:false});this.setAggregation("myListBox",this._oListBox,true);this._oListBox.attachEvent("itemsChanged",this._handleItemsChanged,this);this._oListBox.attachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this.getDomRef()){this.$().attr("aria-owns",this.getId()+"-input "+this._oListBox.getId())}return this._oListBox};g.prototype._getExistingListBox=function(){var e=this.getListBox(),t;if(e){t=sap.ui.getCore().byId(e)}else if(this._oListBox){t=this._getPrivateListBox()}return t};g.prototype._getListBox=function(e){var t=this._getExistingListBox();if(!t){t=this._getPrivateListBox()}if(e){t.setAllowMultiSelect(false);t.setDisplaySecondaryValues(this.getDisplaySecondaryValues());var i=this.getDomRef();if(i){t.setMinWidth(jQuery(i).rect().width+"px")}}return t};g.prototype._open=function(e){if(this.mobile){return}if(e===undefined){e=-1}if(!this.getEditable()||!this.getEnabled()){return}if(!this.oPopup){this.oPopup=new s}this._F4ForOpen=false;var t=this._getListBox(!this.oPopup.isOpen());var i=this.oPopup;this._prepareOpen(t);if(!this._oListBoxDelegate){this._oListBoxDelegate={oCombo:this,onclick:function(e){var t=jQuery(e.target).closest("li").attr("id");if(t){var i=new d("_internalSelect",this.oCombo,{selectedId:t});this.oCombo._handleSelect(i)}}}}t.addDelegate(this._oListBoxDelegate);i.setContent(t);i.setAutoClose(true);i.setAutoCloseAreas([this.getDomRef()]);i.setDurations(0,0);i.setInitialFocusId(this.getId()+"-input");var o=this._rerenderListBox(t);if(o){return}i.attachOpened(this._handleOpened,this);var n=s.Dock;i.open(e,n.BeginTop,n.BeginBottom,this,null,null,s.CLOSE_ON_SCROLL);jQuery(t.getFocusDomRef()).attr("tabindex","-1");jQuery(this.getDomRef()).attr("aria-expanded",true)};g.prototype._rerenderListBox=function(e){sap.ui.getCore().applyChanges();return false};g.prototype._prepareOpen=function(e){this._bOpening=true;var t=jQuery(this.getInputDomRef()),i=t.val(),s,o=e.getItems(),n,a=jQuery.sap.startsWithIgnoreCase,d=i==="",r=this.getSelectedItemId(),l;var p=0;var g=-1;for(var u=o.length;p<u;p++){l=o[p];if(!l.getEnabled()){continue}n=""+l.getText();if(d||a(n,i)){if(n==i&&p==this._iClosedUpDownIdx){g=p;s=n;break}else if(this._iClosedUpDownIdx<0&&n==i&&l.getId()==r){g=p;s=n;break}else if(g<0){g=p;s=n}}}if(g>=0){this._iClosedUpDownIdx=g;this._updatePosInSet(t,g+1,l.getAdditionalText?l.getAdditionalText():"");t.val(s);this._doSelect();var f=new jQuery.Event("sapshow");f.which=h.F4;this._fireLiveChange(f)}var c=e.getItems().length;var m=this.getMaxPopupItems();e.setVisibleItems(m<c?m:-1);e.setSelectedIndex(g)};g.prototype._handleOpened=function(){this.oPopup.detachOpened(this._handleOpened,this);var e=this._getListBox();e.scrollToIndex(this._iClosedUpDownIdx,true);e.attachSelect(this._handleSelect,this);this.oPopup.attachClosed(this._handleClosed,this);if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")){jQuery(this.getFocusDomRef()).data("sap.InNavArea",false)}this._bOpening=false};g.prototype._close=function(e){if(this.oPopup){this.oPopup.close(0)}};g.prototype._handleClosed=function(){this.oPopup.detachClosed(this._handleClosed,this);var e=this._getListBox();e.removeDelegate(this._oListBoxDelegate);e.detachSelect(this._handleSelect,this);jQuery(this.getDomRef()).attr("aria-expanded",false);if(this._cleanupClose){this._cleanupClose(e)}};g.prototype._handleSelect=function(e){var t=e.getParameter("selectedIndex"),i=e.getParameter("selectedId"),s=e.getParameter("selectedItem");if(!s&&i){s=sap.ui.getCore().byId(i);if(s.getParent()!==this._getListBox(false)){s=null}t=jQuery.inArray(s,this._getListBox().getItems())}if(s&&s.getEnabled()){var o=s.getText();this._iClosedUpDownIdx=t;this._close();this._updatePosInSet(null,this._getListBox().getSelectedIndex()+1,s.getAdditionalText?s.getAdditionalText():"");var n=this.getValue();var a=this.getSelectedKey();var d=s.getKey();var r=this.getSelectedItemId();var h=s.getId();this._sTypedChars=o;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;if(n!=o||a!=d||r!=h){this.setValue(o,true);this.setProperty("selectedKey",d,true);this.setProperty("selectedItemId",h,true);this.fireChange({newValue:o,selectedItem:s})}else if(o!=jQuery(this.getInputDomRef()).val()){jQuery(this.getInputDomRef()).val(o)}}this._doSelect();return s};g.prototype.getItems=function(){var e=this._getExistingListBox();return e?e.getItems():[]};g.prototype.insertItem=function(e,t){e=this.validateAggregation("items",e,true);this._getListBox().insertItem(e,t);return this};g.prototype.addItem=function(e){e=this.validateAggregation("items",e,true);this._getListBox().addItem(e);return this};g.prototype.removeItem=function(e){return this._getListBox().removeItem(e)};g.prototype.removeAllItems=function(){var e=this._getExistingListBox();return e?e.removeAllItems():[]};g.prototype.indexOfItem=function(e){return this._getListBox().indexOfItem(e)};g.prototype.destroyItems=function(){var e=this._getExistingListBox();if(e){this._getListBox().destroyItems()}return this};g.prototype.updateItems=function(){this._bNoItemCheck=true;this.updateAggregation("items");if(!this._sHandleItemsChanged){this._sHandleItemsChanged=setTimeout(function(){this._handleItemsChanged(null,true)}.bind(this),0)}};g.prototype.setListBox=function(e){var t=sap.ui.getCore().byId(this.getListBox());if(t){t.detachEvent("itemsChanged",this._handleItemsChanged,this);t.detachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this._bListBoxDependentSet){this.removeDependent(t);this._bListBoxDependentSet=false}}if(this._oListBox&&e){this._oListBox.detachEvent("itemsChanged",this._handleItemsChanged,this);this._oListBox.detachEvent("itemInvalidated",this._handleItemInvalidated,this);if(this.getAggregation("myListBox")){this.destroyAggregation("myListBox",true)}else{this._oListBox.destroy()}this._oListBox=null}this.setAssociation("listBox",e);var i=typeof e==="string"?sap.ui.getCore().byId(e):e;if(i&&i.attachEvent){i.attachEvent("itemsChanged",this._handleItemsChanged,this);i.attachEvent("itemInvalidated",this._handleItemInvalidated,this)}if(i&&!i.getParent()){this.addDependent(i);this._bListBoxDependentSet=true}if(this.getDomRef()&&i){this.$().attr("aria-owns",this.getId()+"-input "+i.getId())}return this};g.prototype._handleItemsChanged=function(e,t){if(t){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined}if(this._bNoItemCheck){return}var i=[];if(this._getExistingListBox()){i=this._getListBox().getItems()}var s=this.getSelectedKey();var o=this.getSelectedItemId();var n,a,d,r;var h=this.getValue();var l=-1;var p=false;var g=false;var u=false;this._iClosedUpDownIdx=-1;var f=!!this.getBinding("value");var c=!!this.getBinding("selectedKey");if(f&&c){f=false}var m=0;var I;for(m=0;m<i.length;m++){I=i[m];if((this._sWantedSelectedKey||this._sWantedSelectedItemId)&&(I.getKey()==this._sWantedSelectedKey||I.getId()==this._sWantedSelectedItemId)&&I.getEnabled()){n=I.getKey();a=I.getId();d=I.getText();r=I.getAdditionalText?I.getAdditionalText():"";l=m;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;break}else if(s&&I.getKey()==s&&I.getEnabled()&&!(u&&f)){p=true;n=s;a=I.getId();d=I.getText();r=I.getAdditionalText?I.getAdditionalText():"";l=m;if(d==h&&a==o&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break}if(c&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break}}else if(o&&I.getId()==o&&I.getEnabled()&&!p&&!(u&&f)){g=true;n=I.getKey();a=o;d=I.getText();r=I.getAdditionalText?I.getAdditionalText():"";l=m}else if(I.getText()==h&&I.getEnabled()&&!(p&&!f)&&!(g&&!f)&&!u){u=true;n=I.getKey();a=I.getId();d=h;r=I.getAdditionalText?I.getAdditionalText():"";l=m;if(f&&!this._sWantedSelectedKey&&!this._sWantedSelectedItemId){break}}}this._iClosedUpDownIdx=l;if(h!=d&&l>=0){this.setProperty("value",d,true);jQuery(this.getInputDomRef()).val(d)}this.setProperty("selectedKey",n,true);this.setProperty("selectedItemId",a,true);var _=this.getDomRef();if(_){jQuery(this.getInputDomRef()).attr("aria-setsize",i.length);if(a){this._updatePosInSet(null,l+1,r)}else{this._updatePosInSet(null,-1,null)}if(this.mobile){var y=this.getDomRef("select");while(y.length>0){y.remove(0)}for(m=0;m<i.length;m++){I=i[m];var v=document.createElement("option");v.text=I.getText();v.id=this.getId()+"-"+I.getId();if(!I.getEnabled()){v.disabled="disabled"}y.add(v,null)}y.selectedIndex=l}}};g.prototype._handleItemInvalidated=function(t){if(this._bNoItemCheck){return}var i=t.getParameter("item");if(i.getId()==this.getSelectedItemId()){if(i.getKey()!=this.getSelectedKey()){this.setProperty("selectedKey",i.getKey(),true)}if(i.getText()!=this.getValue()){e.prototype.setValue.apply(this,[i.getText()])}}if(!this._sHandleItemsChanged){this._handleItemsChanged(t)}};g.prototype.onAfterRendering=function(t){e.prototype.onAfterRendering.apply(this,arguments);var i=this.getListBox();if(i){var s=sap.ui.getCore().byId(i);if(s.getDomRef()){s.$().appendTo(sap.ui.getCore().getStaticAreaRef())}}if(this.mobile){var o=this;this.$("select").on("change",function(){var e=o.$("select").val();var t=o.getItems();var i=true;var s=0;var n=o.getValue();for(var a=0;a<t.length;a++){if(t[a].getText()==e){i=t[a].getEnabled()}if(t[a].getText()==n){s=a}}if(i){o.setValue(e);o.fireChange({newValue:e,selectedItem:sap.ui.getCore().byId(o.getSelectedItemId())})}else{o.getDomRef("select").selectedIndex=s}});if(this.getSelectedItemId()){for(var n=0;n<this.getItems().length;n++){var a=this.getItems()[n];if(this.getSelectedItemId()==a.getId()){this.getDomRef("select").selectedIndex=n;break}}}else{this._addDummyOption(this.getValue())}}};g._isHotKey=function(e){if(e.altKey||e.ctrlKey||e.metaKey){return true}var t=e.keyCode||e.which;switch(t){case h.ENTER:case h.SHIFT:case h.TAB:case h.ALT:case h.CONTROL:return true;case h.END:case h.HOME:case h.ARROW_LEFT:case h.ARROW_UP:case h.ARROW_RIGHT:case h.ARROW_DOWN:case h.F1:case h.F2:case h.F3:case h.F4:case h.F5:case h.F6:case h.F7:case h.F8:case h.F9:case h.F10:case h.F11:case h.F12:if(e.type=="keypress"){return e.which===0}else{return true}default:return false}};g.prototype.setSelectedKey=function(e){if(this.getSelectedKey()==e){return this}if(!e&&this._isSetEmptySelectedKeyAllowed()){return this}var t=this.getItems();var i=true;var s;var o;var n;for(var a=0;a<t.length;a++){if(t[a].getKey()==e&&t[a].getEnabled()){var d=t[a];s=d.getId();var r=d.getText();n=d.getAdditionalText?d.getAdditionalText():"";this.setValue(r,true);this._sTypedChars=r;o=a;i=false;break}}if(!i){this.setProperty("selectedKey",e,true);this.setProperty("selectedItemId",s,true);var h=this.getDomRef();if(h){this._updatePosInSet(null,o+1,n);if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=o}}this._sWantedSelectedKey=undefined;this._iClosedUpDownIdx=o}else{this._sWantedSelectedKey=e;this._iClosedUpDownIdx=-1}this._sWantedSelectedItemId=undefined;return this};g.prototype._isSetEmptySelectedKeyAllowed=function(){this.setProperty("selectedKey","",true);this.setProperty("selectedItemId","",true);this.setValue("",true);return true};g.prototype.setSelectedItemId=function(e){if(this.getSelectedItemId()==e){return this}if(!e&&this._isSetEmptySelectedKeyAllowed()){return this}var t=this.getItems();var i=true;var s;var o;var n;for(var a=0;a<t.length;a++){if(t[a].getId()==e&&t[a].getEnabled()){var d=t[a];s=d.getKey();var r=d.getText();n=d.getAdditionalText?d.getAdditionalText():"";this.setValue(r,true);this._sTypedChars=r;o=a;i=false;break}}if(!i){this.setProperty("selectedItemId",e,true);this.setProperty("selectedKey",s,true);var h=this.getDomRef();if(h){this._updatePosInSet(null,o+1,n);if(this.mobile){this._removeDummyOption();this.getDomRef("select").selectedIndex=o}}this._sWantedSelectedItemId=undefined;this._iClosedUpDownIdx=o}else{this._sWantedSelectedItemId=e;this._iClosedUpDownIdx=-1}this._sWantedSelectedKey=undefined;return this};g.prototype.setValue=function(t,i){if(!i){var s=this.getItems();var o;var n;var a;var d;this._iClosedUpDownIdx=-1;for(var r=0;r<s.length;r++){if(s[r].getText()==t&&s[r].getEnabled()){var h=s[r];n=h.getId();o=h.getKey();d=h.getAdditionalText?h.getAdditionalText():"";a=r;this._iClosedUpDownIdx=a;break}}this.setProperty("selectedKey",o,true);this.setProperty("selectedItemId",n,true);var l=this.getDomRef();if(l){if(n){this._updatePosInSet(null,a+1,d)}else{this._updatePosInSet(null,-1,null)}if(this.mobile){if(!n){this._addDummyOption(t)}else{this._removeDummyOption();this.getDomRef("select").selectedIndex=a}}}}e.prototype.setValue.apply(this,[t]);this._sTypedChars=this.getValue();this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;return this};g.prototype.invalidate=function(t){if(!t||!(t instanceof a)||t!=this._getListBox()){e.prototype.invalidate.apply(this,arguments)}else{if(this.getUIArea()&&t.getDomRef()){this.getUIArea().addInvalidatedControl(t)}}};g.prototype.clone=function(t){var i=e.prototype.clone.apply(this,arguments),s=this.getAggregation("myListBox"),o;if(s&&!i._oListBox){s.detachEvent("itemsChanged",this._handleItemsChanged,this);s.detachEvent("itemInvalidated",this._handleItemInvalidated,this);o=s.clone(t);o.attachEvent("itemsChanged",i._handleItemsChanged,i);o.attachEvent("itemInvalidated",i._handleItemInvalidated,i);i.setAggregation("myListBox",o,true);i._oListBox=o;s.attachEvent("itemsChanged",this._handleItemsChanged,this);s.attachEvent("itemInvalidated",this._handleItemInvalidated,this)}return i};g.prototype._addDummyOption=function(e){var t=this.getDomRef("dummyOption");if(!t){var i=this.getItems();t=document.createElement("option");t.text=e;t.id=this.getId()+"-dummyOption";if(i.length>0){this.getDomRef("select").add(t,document.getElementById(this.getId()+"-"+i[0].getId()))}else{this.getDomRef("select").add(t,null)}}else{t.text=e}this.getDomRef("select").selectedIndex=0};g.prototype._removeDummyOption=function(){var e=this.getDomRef("dummyOption");if(e){this.getDomRef("select").remove(0)}};g.prototype.getFocusDomRef=function(){if(this.mobile){return this.getDomRef("select")||null}else{return this.getDomRef("input")||null}};g.prototype._updatePosInSet=function(e,t,i){if(!e){e=this.$("input")}if(t>=0){e.attr("aria-posinset",t);if(this.getDisplaySecondaryValues()){this.$("SecVal").text(i)}}else{e.removeAttr("aria-posinset");if(this.getDisplaySecondaryValues()){this.$("SecVal").text("")}}};g.prototype.getAccessibilityInfo=function(){var t=e.prototype.getAccessibilityInfo.apply(this,arguments);t.role="combobox";t.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_COMBO");return t};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ComboBoxRenderer", ["./TextFieldRenderer","sap/ui/core/Renderer","sap/ui/core/library","sap/ui/core/Configuration"],function(e,t,i,r){"use strict";var d=i.ValueState;var a=t.extend(e);a.renderOuterAttributes=function(e,t){e.addClass("sapUiTfCombo");this.renderComboARIAInfo(e,t)};a.renderOuterContentBefore=function(e,t){this.renderExpander(e,t);this.renderSelectBox(e,t,"-1")};a.renderExpander=function(e,t){e.write("<div");e.writeAttributeEscaped("id",t.getId()+"-icon");e.writeAttribute("unselectable","on");if(r.getAccessibility()){e.writeAttribute("role","presentation")}e.addClass("sapUiTfComboIcon");e.writeClasses();e.write(">&#9660;</div>")};a.renderSelectBox=function(e,t,i){if(t.mobile){e.write("<select");e.writeAttributeEscaped("id",t.getId()+"-select");e.writeAttribute("tabindex",i);if(!t.getEnabled()||!t.getEditable()){e.writeAttribute("disabled","disabled")}e.write(">");for(var r=0;r<t.getItems().length;r++){var d=t.getItems()[r];e.write("<option");e.writeAttributeEscaped("id",t.getId()+"-"+d.getId());if(!d.getEnabled()){e.writeAttribute("disabled","disabled")}e.write(">");e.writeEscaped(d.getText());e.write("</option>")}e.write("</select>")}};a.renderOuterContent=function(e,t){if(t.getDisplaySecondaryValues()){e.write('<span id="'+t.getId()+'-SecVal" style="display: none;"></span>')}};a.renderInnerAttributes=function(e,t){if(t.mobile){e.writeAttribute("autocapitalize","off");e.writeAttribute("autocorrect","off")}};a.renderComboARIAInfo=function(e,t){var i=t.getListBox();if(!i&&t._oListBox){i=t._oListBox.getId()}var r={role:"combobox",owns:t.getId()+"-input "+i};if(!t.getEnabled()){r["disabled"]=true}e.writeAccessibilityState(null,r)};a.renderARIAInfo=function(e,t){var i=-1;if(t.getSelectedItemId()){for(var r=0;r<t.getItems().length;r++){var a=t.getItems()[r];if(a.getId()==t.getSelectedItemId()){i=r+1;break}}}var n={autocomplete:"inline",live:"polite",setsize:t.getItems().length,posinset:i>=0?i:undefined};if(t.getValueState()==d.Error){n["invalid"]=true}if(t.getDisplaySecondaryValues()){n["describedby"]={value:t.getId()+"-SecVal",append:true}}e.writeAccessibilityState(t,n)};a.setEditable=function(t,i){if(t.mobile){var r=t.$("select");if(i&&t.getEnabled()){r.removeAttr("disabled")}else{r.attr("disabled","disabled")}}e.setEditable.apply(this,arguments)};a.setEnabled=function(t,i){if(t.mobile){var r=t.$("select");if(i&&t.getEditable()){r.removeAttr("disabled")}else{r.attr("disabled","disabled")}}e.setEnabled.apply(this,arguments)};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/DatePicker", ["sap/ui/thirdparty/jquery","sap/base/Log","./TextField","sap/ui/model/type/Date","sap/ui/core/date/UniversalDate","./library","./DatePickerRenderer","sap/ui/core/format/DateFormat","sap/ui/core/library","sap/ui/Device","sap/ui/core/Locale","sap/ui/core/LocaleData","sap/ui/core/Popup","sap/ui/dom/containsOrEquals","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos"],function(jQuery,e,t,a,i,o,r,s,n,p,u,l,h,f,d){"use strict";var _=h.Dock;var y=n.CalendarType;var g=t.extend("sap.ui.commons.DatePicker",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{locale:{type:"string",group:"Misc",defaultValue:null},yyyymmdd:{type:"string",group:"Misc",defaultValue:null}}}});g.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oFormatYyyymmdd=s.getInstance({pattern:"yyyyMMdd",strictParsing:true,calendarType:y.Gregorian});if(!p.system.desktop){this._bMobile=true;this._oFormatMobile=s.getInstance({pattern:"yyyy-MM-dd",strictParsing:true,calendarType:y.Gregorian})}this._oMinDate=new Date(1,0,1);this._oMinDate.setFullYear(1);this._oMaxDate=new Date(9999,11,31,23,59,59,99)};g.prototype.exit=function(){this._oDate=undefined;this._oLocale=undefined;if(this._oPopup){if(this._oPopup.isOpen()){this._oPopup.close()}delete this._oPopup}if(this._oCalendar){this._oCalendar.destroy();delete this._oCalendar}};g.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);if(this._bMobile){if(this._oDate){var e=jQuery(this.getInputDomRef());var a=this._oFormatMobile.format(this._oDate);e.val(a)}}};g.prototype.invalidate=function(e){if(!e||e!=this._oCalendar){t.prototype.invalidate.apply(this,arguments)}};g.prototype.onsapshow=function(e){var t=this;T(t);e.preventDefault()};g.prototype.onsaphide=g.prototype.onsapshow;g.prototype.onsappageup=function(e){var t=this;M(t,1,"day");e.preventDefault()};g.prototype.onsappageupmodifiers=function(e){var t=this;if(!e.ctrlKey&&e.shiftKey){M(t,1,"month")}else{M(t,1,"year")}e.preventDefault()};g.prototype.onsappagedown=function(e){var t=this;M(t,-1,"day");e.preventDefault()};g.prototype.onsappagedownmodifiers=function(e){var t=this;if(!e.ctrlKey&&e.shiftKey){M(t,-1,"month")}else{M(t,-1,"year")}e.preventDefault()};g.prototype.onkeypress=function(e){if(e.charCode){var t=this;var a=m(t);var i=String.fromCharCode(e.charCode);if(i&&a.sAllowedCharacters&&a.sAllowedCharacters.indexOf(i)<0){e.preventDefault()}}};g.prototype.onclick=function(e){if(jQuery(e.target).hasClass("sapUiTfDateIcon")&&!this._bMobile){var t=this;T(t)}};g.prototype.onsapfocusleave=function(e){if(this._oCalendar&&e.relatedControlId&&(f(this._oCalendar.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())||this.getId()==e.relatedControlId)){return}t.prototype.onsapfocusleave.apply(this,arguments)};g.prototype.setValue=function(t){var a=this.getValue();if(t==a){return this}var i=this;D(i);this.setProperty("value",t,true);this._bValueSet=true;if(t){this._oDate=this._parseValue(t);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}var o="";if(this._oDate){o=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",o,true);if(this.getDomRef()){var r="";var s=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){r=this._oFormatMobile.format(this._oDate)}else{r=t}s.val(r)}return this};g.prototype.setYyyymmdd=function(t){var a=this.getYyyymmdd();if(t==a){return this}this.setProperty("yyyymmdd",t,true);this._bValueSet=false;var i="";if(t){this._oDate=this._oFormatYyyymmdd.parse(t);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}if(this._oDate){i=this._formatValue(this._oDate)}this.setProperty("value",i,true);if(this.getDomRef()){var o="";var r=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){o=this._oFormatMobile.format(this._oDate)}else{o=i}r.val(o)}return this};g.prototype.setLocale=function(t){var a=this.getLocale();if(t==a){return this}this.setProperty("locale",t,true);var i=this;D(i);this._oLocale=new u(t);this._sUsedPattern=undefined;var o="";if(this._bValueSet){o=this.getValue();if(o){this._oDate=this._parseValue(o);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;e.warning("Value can not be converted to a valid date",this)}}else{this._oDate=undefined}var r="";if(this._oDate){r=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",r,true)}else{if(this._oDate){o=this._formatValue(this._oDate)}this.setProperty("value",o,true)}if(this.getDomRef()){var s="";var n=jQuery(this.getInputDomRef());if(this._bMobile&&this._oDate){s=this._oFormatMobile.format(this._oDate)}else{s=o}n.val(s)}return this};g.prototype.oninput=function(e){if(this._bMobile){var a=this.getInputDomRef();var i=a&&a.value;if(i){var o=this._oFormatMobile.parse(i)}if(!i||o){this._checkChange(e)}}else{t.prototype.oninput.apply(this,arguments)}};g.prototype._checkChange=function(e){var t=this.getInputDomRef();var a=t&&t.value;if(this._bMobile&&a!=""){this._oDate=this._oFormatMobile.parse(a);a=this._formatValue(this._oDate)}if(this.getEditable()&&this.getEnabled()&&a!=this.getValue()){var i=false;if(a!=""){if(!this._bMobile){this._oDate=this._parseValue(a);if(!this._oDate||this._oDate.getTime()<this._oMinDate.getTime()||this._oDate.getTime()>this._oMaxDate.getTime()){this._oDate=undefined;i=true}else{a=this._formatValue(this._oDate);t.value=a;if(this._oPopup&&this._oPopup.isOpen()){this._oCalendar.focusDate(this._oDate);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=this._oDate.getTime()){this._oDateRange.setStartDate(new Date(this._oDate.getTime()))}}}}}else{this._oDate=undefined}this.setProperty("value",a,true);this._bValueSet=false;if(!i){var o="";if(this._oDate){o=this._oFormatYyyymmdd.format(this._oDate)}this.setProperty("yyyymmdd",o,true)}this.fireChange(i)}else if(this.getEditable()&&this.getEnabled()&&a==this.getYyyymmdd()){t.value=this.getValue()}};g.prototype.fireChange=function(e,t){if(!(typeof e==="object")){t=e}this.fireEvent("change",{newValue:this.getValue(),newYyyymmdd:this.getYyyymmdd(),invalidValue:t});return this};g.prototype._parseValue=function(e){var t=this;var a=m(t);var i=a.parse(e);return i};g.prototype._formatValue=function(e){var t=this;var a=m(t);var i=a.format(e);return i};g.prototype.getAccessibilityInfo=function(){var e=t.prototype.getAccessibilityInfo.apply(this,arguments);e.type=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_DATEINPUT");return e};function m(e){var t="";var i=false;var o=e.getBinding("value");var r;var n;if(o&&o.oType&&o.oType instanceof a){t=o.oType.getOutputPattern();i=!!o.oType.oOutputFormat.oFormatOptions.relative;n=o.oType.oOutputFormat.oFormatOptions.calendarType}if(!t){r=c(e);var p=l.getInstance(r);t=p.getDatePattern("medium");n=d.getCalendarType()}if(t!=e._sUsedPattern||n!=e._sUsedCalendarType){e._sUsedPattern=t;e._sUsedCalendarType=n;if(t=="short"||t=="medium"||t=="long"){e._oFormat=s.getInstance({style:t,strictParsing:true,relative:i,calendarType:n},r)}else{e._oFormat=s.getInstance({pattern:t,strictParsing:true,relative:i,calendarType:n},r)}}return e._oFormat}function c(e){var t=e.getLocale();var a;if(t){a=e._oLocale}else{a=d.getFormatSettings().getFormatLocale()}return a}function D(t){var i=t.getBinding("value");var o=t.getLocale();if(i&&i.oType&&i.oType instanceof a&&o){e.warning("DatePicker "+t.getId()+": Using a locale and Databinding at the same time is not supported");t._bIgnoreLocale=true}}function v(e){if(!e._oPopup){e._oPopup=new h;e._oPopup.setAutoClose(true);e._oPopup.setDurations(0,0);e._oPopup.attachClosed(P,e)}if(!e._oCalendar){sap.ui.getCore().loadLibrary("sap.ui.unified");sap.ui.require("sap/ui/unified/library");e._oCalendar=new sap.ui.unified.Calendar(e.getId()+"-cal");e._oDateRange=new sap.ui.unified.DateRange;e._oCalendar.addSelectedDate(e._oDateRange);e._oCalendar.attachSelect(b,e);e._oCalendar.attachCancel(C,e);e._oPopup.setContent(e._oCalendar);e._oCalendar.addStyleClass("sapUiSizeCompact");e._oCalendar.setParent(e,undefined,true)}var t="";if(e._oDate){t=e._formatValue(e._oDate)}if(t!=e.$("input").val()){e._checkChange()}var i;var o=e.getBinding("value");if(o&&o.oType&&o.oType instanceof a){i=o.oType.oOutputFormat.oFormatOptions.calendarType}if(i){e._oCalendar.setPrimaryCalendarType(i)}var r=e._oDate;if(r){e._oCalendar.focusDate(r);if(!e._oDateRange.getStartDate()||e._oDateRange.getStartDate().getTime()!=r.getTime()){e._oDateRange.setStartDate(new Date(r.getTime()))}}else{e._oCalendar.focusDate(new Date);if(e._oDateRange.getStartDate()){e._oDateRange.setStartDate(undefined)}}if(!e._bIgnoreLocale){e._oCalendar.setLocale(e.getLocale())}e._oPopup.setAutoCloseAreas([e.getDomRef()]);e._oPopup.open(0,_.BeginTop,_.BeginBottom,e,null,null,true)}function T(e){if(e.getEditable()&&e.getEnabled()){if(!e._oPopup||!e._oPopup.isOpen()){v(e)}else{e._oPopup.close();e.focus()}}}function b(e){var t=this._oCalendar.getSelectedDates();var a="";if(t.length>0){this._oDate=t[0].getStartDate();a=this._formatValue(this._oDate)}this._oPopup.close();this.focus();var i=this._formatValue(this._oDate);this.setProperty("value",i,true);this._bValueSet=false;var o=this._oFormatYyyymmdd.format(this._oDate);this.setProperty("yyyymmdd",o,true);var r=this.$("input");if(r.val()!==a){r.val(a);this._curpos=a.length;r.cursorPos(this._curpos)}this.fireChange()}function C(e){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();this.focus()}}function P(e){if(!f(this.getDomRef(),document.activeElement)&&this.getRenderer().onblur){this.getRenderer().onblur(this)}}function M(e,t,o){var r=e._oDate;if(r&&e.getEditable()&&e.getEnabled()){var s=e.getBinding("value");var n;if(s&&s.oType&&s.oType instanceof a){n=s.oType.oOutputFormat.oFormatOptions.calendarType}else{n=d.getCalendarType()}var p=i.getInstance(new Date(r.getTime()),n);r=i.getInstance(new Date(r.getTime()),n);var u=jQuery(e.getInputDomRef());var l=u.cursorPos();switch(o){case"day":p.setDate(p.getDate()+t);break;case"month":p.setMonth(p.getMonth()+t);var h=(r.getMonth()+t)%12;if(h<0){h=12+h}while(p.getMonth()!=h){p.setDate(p.getDate()-1)}break;case"year":p.setFullYear(p.getFullYear()+t);while(p.getMonth()!=r.getMonth()){p.setDate(p.getDate()-1)}break;default:break}if(p.getTime()<e._oMinDate.getTime()){p=new i(e._oMinDate.getTime())}else if(p.getTime()>e._oMaxDate.getTime()){p=new i(e._oMaxDate.getTime())}e._oDate=new Date(p.getTime());var f=e._formatValue(e._oDate);u.val(f);u.cursorPos(l)}}return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/DatePickerRenderer", ["./TextFieldRenderer","sap/ui/core/Renderer","sap/ui/core/ValueStateSupport","sap/ui/core/library"],function(e,t,r,i){"use strict";var a=i.ValueState;var n=t.extend(e);n.renderOuterAttributes=function(e,t){e.addClass("sapUiTfCombo");this.renderDatePickerARIAInfo(e,t)};n.renderOuterContentBefore=function(e,t){e.write("<div");e.writeAttribute("id",t.getId()+"-icon");e.writeAttribute("tabindex","-1");e.addClass("sapUiTfDateIcon");e.writeClasses();e.write("></div>");var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var a=i.getText("DATEPICKER_DATE_TYPE");var n=r.enrichTooltip(t,t.getTooltip_AsString());if(n){a=a+". "+n}e.write('<span id="'+t.getId()+'-Descr" style="visibility: hidden; display: none;">');e.writeEscaped(a);e.write("</span>")};n.renderInnerAttributes=function(e,t){if(t._bMobile){e.writeAttribute("type","date");e.addStyle("position","absolute")}};n.renderDatePickerARIAInfo=function(e,t){};n.renderARIAInfo=function(e,t){var r={role:t.getAccessibleRole().toLowerCase(),multiline:false,autocomplete:"none",haspopup:true,describedby:{value:t.getId()+"-Descr",append:true}};if(t.getValueState()==a.Error){r["invalid"]=true}e.writeAccessibilityState(t,r)};n.convertPlaceholder=function(e){var t=e.getPlaceholder();if(t.length==8&&!isNaN(t)){var r=e._oFormatYyyymmdd.parse(t);if(r){t=e._formatValue(r)}}return t};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Dialog", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/containsOrEquals","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/RenderManager","./DialogRenderer","sap/ui/core/library","sap/ui/core/ResizeHandler","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/control","sap/ui/dom/jquery/Selectors"],function(jQuery,t,e,i,o,s,n,r,a,h,u){"use strict";var p=a.OpenState;var l=a.AccessibleRole;var d=i.enums.BorderDesign;var f=o.extend("sap.ui.commons.Dialog",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},title:{type:"string",group:"Misc",defaultValue:""},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},showCloseButton:{type:"boolean",group:"Behavior",defaultValue:true},resizable:{type:"boolean",group:"Behavior",defaultValue:true},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxHeight:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},contentBorderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:d.None},modal:{type:"boolean",group:"Misc",defaultValue:false},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:l.Dialog},keepInWindow:{type:"boolean",group:"Behavior",defaultValue:false},autoClose:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{defaultButton:{type:"sap.ui.commons.Button",multiple:false},initialFocus:{type:"sap.ui.core.Control",multiple:false}},events:{closed:{parameters:{width:{type:"int"},height:{type:"int"},top:{type:"int"},left:{type:"int"}}}}}});f.prototype.init=function(){this.oPopup=new s(this,true,true);this._minWidth=64;this._minHeight=48;this.allowTextSelection(false);this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-fhfe";this._mParameters.lastFocusable=this.getId()+"-fhee";this._fnOnResizeRecenter=jQuery.proxy(this._onResize,this)};f.prototype.setInitialFocus=function(t){if(t&&typeof t!="string"){t=t.getId()}this.oPopup.setInitialFocusId(t);this.setAssociation("initialFocus",t,true);return this};f.prototype.onAfterRendering=function(){var t=this.$("cont");var e=this.getMinSize();this._minWidth=e.width;this._minHeight=e.height;if(!this._isSizeSet(this.getWidth())&&!this._isSizeSet(this.getMaxWidth())){t.children().each(function(t,e){if(this.style.width.trim()=="100%"){this.style.width="auto"}})}if(!this._isSizeSet(this.getHeight())&&this._isSizeSet(this.getMinHeight())){var i=this.getDomRef("footer");var o=i.offsetTop+i.offsetHeight;var s=this.getDomRef().offsetHeight;if(o<s){this.$().removeClass("sapUiDlgFlexHeight")}}};f.prototype.onclick=function(t){var e=this.getId()+"-close";if(t.target.id===e){this.close();t.preventDefault()}return false};f.prototype.open=function(){if(!this.oPopup){t.fatal("This dialog instance has been destroyed already")}else if(!this._bOpen){this._oPreviousFocus=s.getCurrentFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);this.oPopup.attachEvent("closed",this.handleClosed,this);this.oPopup.setModal(this.getModal());this.oPopup.setAutoClose(this.getAutoClose());this.oPopup.open(400);this._onResize();this._bOpen=true;this._registerContentResizeHandler()}};f.prototype.onThemeChanged=function(){this.invalidate()};f.prototype._handleOpened=function(){this.$().show();var t=this.getInitialFocus();var e;this._bInitialFocusSet=true;if(t){sap.ui.getCore().byId(t).focus();return}t=this.getDefaultButton();e=jQuery(":sapTabbable",this.$("cont"));if(t){sap.ui.getCore().byId(t).focus()}else if(this.getButtons().length){this.getButtons()[0].focus()}else if(this.getContent().length&&e.length){e[0].focus()}else{var i=document.getElementById(this._mParameters.firstFocusable);if(i){i.focus()}}};f.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);this._handleOpened()};f.prototype.close=function(){if(!this._bOpen){return}var t=this.$().rect();this._bOpen=false;this._bInitialFocusSet=false;if(this.oPopup.isOpen()){this.oPopup.close(400)}setTimeout(function(){this.restorePreviousFocus()}.bind(this),400);jQuery.each(t,function(e,i){t[e]=parseInt(i)});this._oRect=t};f.prototype.handleClosed=function(){this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.fireClosed(this._oRect);this.close();if(this.getDomRef()){n.preserveContent(this.getDomRef());this.$().remove()}};f.prototype.restorePreviousFocus=function(){s.applyFocusInfo(this._oPreviousFocus)};f.prototype.setTitle=function(t){this.setProperty("title",t,true);this.$("lbl").text(t);return this};f.prototype.exit=function(){var t=this.isOpen();this.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this._deregisterContentResizeHandler();this.oPopup.destroy();if(t){this.fireClosed(this._oRect)}this.oPopup=null;clearTimeout(this._sDelayedCall);this._sDelayedCall=null;delete this._mParameters;this._fnOnResizeRecenter=null};f.prototype._isSizeSet=function(t){return!!(t&&t!=="auto"&&t!=="inherit")};f.prototype.onsapescape=function(t){this.close();t.preventDefault();t.stopPropagation()};f.prototype.onsapenter=function(t){var e,i=this.getDefaultButton();if(i&&(e=sap.ui.getCore().byId(i))&&jQuery.contains(this.getDomRef(),e.getDomRef())){if(e instanceof sap.ui.commons.Button){e.onclick(t)}}t.preventDefault();t.stopPropagation()};f.prototype.onfocusin=function(t){this.sLastRelevantNavigation=null;if(!this._bInitialFocusSet){return}this._mParameters.event=t;this._mParameters.$FocusablesContent=jQuery(":sapTabbable",this.$("cont"));this._mParameters.$FocusablesFooter=jQuery(":sapTabbable",this.$("footer"));this.oPopup.focusTabChain(this._mParameters)};f.prototype.restoreFocus=function(){if(this.oRestoreFocusInfo&&this.oPopup.bOpen){var t=sap.ui.getCore().byId(this.oRestoreFocusInfo.sFocusId);if(t){t.applyFocusInfo(this.oRestoreFocusInfo.oFocusInfo)}}};f.prototype.onselectstart=function(t){if(!e(this.getDomRef("cont"),t.target)){t.preventDefault();t.stopPropagation()}};f.prototype.getMinSize=function(){var t=36;var e=this.$();var i=this.$("hdr");var o=this.$("footer");var s=o.children("DIV").get(0);var n=s?s.offsetWidth:0;var r=o.css("display")!=="none";var a=0;var h;var u;a+=o.outerWidth(false)-o.width();a+=e.outerWidth(false)-e.width();if(a<=20){a=20}n+=a;if(n<100){n=100}h=i.outerHeight(false);u=o.outerHeight(false);return{width:n,height:h+u+(r?t:0)}};f.prototype.forceInvalidate=o.prototype.invalidate;f.prototype.invalidate=function(t){if(this.oPopup&&(this.oPopup.eOpenState!=="CLOSING"||this.isOpen())){this.forceInvalidate(t)}};f.prototype.isOpen=function(){return this.oPopup.isOpen()};f.prototype.getOpenState=function(){return this.oPopup.getOpenState()};f.prototype.getEnabled=function(){var t=this.getOpenState();return t===p.OPENING||t===p.OPEN};f.prototype.ondragstart=function(t){if(this.sDragMode=="resize"||this.sDragMode=="move"){t.preventDefault();t.stopPropagation()}};f.prototype.onmousedown=function(t){var i=t.target,o=this.getId();this._bRtlMode=u.getRTL();var s=this.getDomRef();if(e(this.getDomRef("hdr"),i)){if(i.id!=o+"-close"){this.sDragMode="move";this._RootWidth=s.offsetWidth;this._RootHeight=s.offsetHeight}}else if(i.id==o+"-grip"){this.sDragMode="resize";var n=s.offsetWidth+"px";var r=s.offsetHeight+"px";s.style.width=n;s.style.height=r;jQuery(s).removeClass("sapUiDlgFlexHeight sapUiDlgFlexWidth");this.setProperty("width",n,true);this.setProperty("height",r,true)}if(!this.sDragMode){return}var a=document.activeElement;if(a&&a.id){var h=jQuery(a).control(0);if(h){this.oRestoreFocusInfo={sFocusId:h.getId(),oFocusInfo:h.getFocusInfo()}}}this.startDragX=t.screenX;this.startDragY=t.screenY;this.originalRectangle=this.$().rect();jQuery(window.document).on("selectstart",jQuery.proxy(this.ondragstart,this));jQuery(window.document).on("mousemove",jQuery.proxy(this.handleMove,this));jQuery(window.document).on("mouseup",jQuery.proxy(this.handleMouseUp,this));var p=this._findSameDomainParentWinDoc();if(p){jQuery(p).on("selectstart",jQuery.proxy(this.ondragstart,this));jQuery(p).on("mousemove",jQuery.proxy(this.handleMove,this));jQuery(p).on("mouseup",jQuery.proxy(this.handleMouseUp,this))}};f.prototype._findSameDomainParentWinDoc=function(){var t=null;try{var e=window;while(e.parent&&e.parent!=e){if(e.parent.document){t=e.parent.document;e=e.parent}}}catch(t){}return t};f.prototype.handleMove=function(t){if(!this.sDragMode){return}t=t||window.event;this._deregisterContentResizeHandler();if(this.sDragMode=="resize"){var e=t.screenX-this.startDragX||0;var i=t.screenY-this.startDragY||0;var o=(this._bRtlMode?this.originalRectangle.width-e:this.originalRectangle.width+e)||0;var n=this.originalRectangle.height+i||0;o=Math.max(o,this._minWidth);n=Math.max(n,this._minHeight);var r=this.getDomRef();r.style.width=o+"px";r.style.height=n+"px";o=r.offsetWidth;n=r.offsetHeight;this.setProperty("width",o+"px",true);this.setProperty("height",n+"px",true)}else if(this.sDragMode=="move"){var a=this.originalRectangle.left+t.screenX-this.startDragX;var h=this.originalRectangle.top+t.screenY-this.startDragY;h=Math.max(h,window.pageYOffset);if(this._bRtlMode||this._keepInWindow()){a=Math.min(a,document.documentElement.clientWidth+window.pageXOffset-this._RootWidth)}if(!this._bRtlMode||this._keepInWindow()){a=Math.max(a,0)}if(this._keepInWindow()){h=Math.min(h,document.documentElement.clientHeight+window.pageYOffset-this._RootHeight)}this.oPopup.setPosition(s.Dock.LeftTop,{left:a,top:h})}t.cancelBubble=true;this._registerContentResizeHandler();return false};f.prototype._keepInWindow=function(){return this.getKeepInWindow()||this.getModal()};f.prototype.handleMouseUp=function(t){if(this.sDragMode===null){return}jQuery(window.document).off("selectstart",this.ondragstart);jQuery(window.document).off("mousemove",this.handleMove);jQuery(window.document).off("mouseup",this.handleMouseUp);var e=this._findSameDomainParentWinDoc();if(e){jQuery(e).off("selectstart",this.ondragstart);jQuery(e).off("mousemove",this.handleMove);jQuery(e).off("mouseup",this.handleMouseUp)}this.restoreFocus();this.sDragMode=null};f.setAutoClose=function(t){this.oPopup.setAutoClose(t)};f.getAutoClose=function(){this.oPopup.getAutoClose()};f.prototype._deregisterContentResizeHandler=function(){if(this._sContentResizeListenerId){h.deregister(this._sContentResizeListenerId);this._sContentResizeListenerId=null}};f.prototype._registerContentResizeHandler=function(){if(!this._sContentResizeListenerId){this._sContentResizeListenerId=h.register(this.getDomRef("cont"),this._fnOnResizeRecenter)}};f.prototype._onResize=function(){var t=s.Dock;if(this.oPopup){this.oPopup.setPosition(t.CenterCenter,t.CenterCenter,window)}};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/DialogRenderer", [],function(){"use strict";var e={};e.render=function(e,t){var i=t._isSizeSet(t.getHeight());var a=t._isSizeSet(t.getWidth());var d=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");t.getScrollTop();t.getScrollLeft();var s=t.getButtons();var r=s.length;e.write("<div");e.writeControlData(t);e.addClass("sapUiDlg");if(t.getModal()){e.addClass("sapUiDlgModal")}e.addClass("sapUiDlgContentBorderDesign"+t.getContentBorderDesign());e.addStyle("width",t.getWidth());e.addStyle("height",t.getHeight());e.addStyle("min-width",t.getMinWidth());e.addStyle("min-height",t.getMinHeight());e.addStyle("max-width",t.getMaxWidth());e.addStyle("max-height",t.getMaxHeight());e.addStyle("display","none");if(!i){e.addClass("sapUiDlgFlexHeight")}if(!a){e.addClass("sapUiDlgFlexWidth")}if(r==0){e.addClass("sapUiDlgNoButtons")}if(!t.getApplyContentPadding()){e.addClass("sapUiDlgNoPad")}e.writeClasses();e.writeStyles();e.writeAttribute("aria-labelledby",t.getId()+"-lbl "+t.getId()+"-acc");e.writeAttribute("role",t.getAccessibleRole().toLowerCase());e.writeAttribute("tabindex","-1");e.write("><span style='display:none;' id='",t.getId(),"-acc'>",d.getText("DIALOG_CLOSE_HELP"),"</span>");e.write("<span id='"+t.getId()+"-fhfe' tabindex='0'></span><div id='"+t.getId()+"-hdr' class='sapUiDlgHdr'>");e.write("<span class='sapUiDlgHdrLeft' id='"+t.getId()+"-hdrL'>");var l=t.getTitle();e.write("<span id='"+t.getId()+"-lbl' class='sapUiDlgLabel'");e.writeAttribute("role","heading");e.writeAttribute("aria-level","1");if(l){e.writeAttributeEscaped("title",l)}e.write(">");if(!l){e.write("&nbsp;")}else{e.writeEscaped(l)}e.write("</span></span>");e.write("<span id='",t.getId(),"-hdrR' class='sapUiDlgHdrBtns'>");if(t.getShowCloseButton()){e.write("<a id='",t.getId(),"-close' class='sapUiDlgCloseBtn' href='#'");e.write(" tabindex='-1'");e.writeAttribute("role","button");e.writeAttributeEscaped("aria-label",d.getText("DIALOG_CLOSE_HELP"));e.writeAttributeEscaped("title",d.getText("DIALOG_CLOSE_TEXT"));e.write("></a>")}e.write("</span></div>");e.write('<div class="sapUiDlgHdrSep"></div>');e.write("<div class='sapUiDlgCont' id='",t.getId(),'-cont\' tabindex="-1">');var g=t.getContent();for(var n=0;n<g.length;n++){e.renderControl(g[n])}e.write("</div>");if(r>0){e.write('<div class="sapUiDlgFooterSep"></div>')}e.write("<div id='");e.write(t.getId());e.write("-footer' class='sapUiDlgFooter'>");e.write("<div class='sapUiDlgBtns'>");for(var n=0;n<r;n++){e.renderControl(s[n])}e.write("</div><div class='sapUiDlgWave'></div></div>");if(t.getResizable()){e.write("<span id='");e.write(t.getId());e.write("-grip' class='sapUiDlgGrip'>&#916;</span>")}e.write("<span id='"+t.getId()+"-fhee' tabindex='0'></span></div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/DropdownBox", ["sap/ui/thirdparty/jquery","sap/base/Log","./ComboBox","./library","sap/ui/core/History","sap/ui/core/SeparatorItem","./DropdownBoxRenderer","sap/ui/Device","./TextField","sap/ui/core/ListItem","sap/ui/dom/containsOrEquals","sap/ui/events/jquery/EventExtension","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText"],function(jQuery,e,t,s,i,o,r,a,h,p,n,l,u,d){"use strict";var f=t.extend("sap.ui.commons.DropdownBox",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{searchHelpEnabled:{type:"boolean",group:"Behavior",defaultValue:false},searchHelpText:{type:"string",group:"Appearance",defaultValue:null},searchHelpAdditionalText:{type:"string",group:"Appearance",defaultValue:null},searchHelpIcon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},events:{searchHelp:{parameters:{value:{type:"string"}}}}}});f.prototype.init=function(){t.prototype.init.apply(this,arguments);this._oValueBeforePaste=null;this._oValueBeforeOpen=null;this.__aItems=null;this._iCursorPosBeforeBackspace=null;this._searchHelpItem=null;this._iItemsForHistory=10;this._oHistory=new i(this.getId())};f.prototype.exit=function(){var e=this.getId()+"-h-";if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null}t.prototype.exit.apply(this,arguments);function s(e){var t=sap.ui.getCore().byId(e);if(t){t.destroy()}}for(var i=0;i<this.getMaxHistoryItems();i++){s(e+i)}if(this.__oSeparator){this.__oSeparator.destroy();this.__oSeparator=null}this._oHistory=null;this.__aItems=null;this._sWantedValue=undefined};f.prototype.onAfterRendering=function(e){t.prototype.onAfterRendering.apply(this,arguments);if(!this._sHandleItemsChanged){this.checkValueInItems()}};f.prototype.getItems=function(){if(this.oPopup&&this.oPopup.isOpen()){return this.__aItems}else{return t.prototype.getItems.apply(this,arguments)}};f.prototype.insertItem=function(e,s){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.splice(s,0,e);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().insertItem(e,s)}if(!this._bNoItemCheck){var i=jQuery(this.getInputDomRef());var o=i.cursorPos();this._doTypeAhead(i.val().substr(0,o),"")}return this}else{return t.prototype.insertItem.apply(this,arguments)}};f.prototype.addItem=function(e){if(this.oPopup&&this.oPopup.isOpen()){this.__aItems.push(e);if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().addItem(e)}if(!this._bNoItemCheck){var s=jQuery(this.getInputDomRef());var i=s.cursorPos();this._doTypeAhead(s.val().substr(0,i),"")}return this}else{return t.prototype.addItem.apply(this,arguments)}};f.prototype.removeItem=function(s){if(this.oPopup&&this.oPopup.isOpen()){var i=null;var o=s;if(typeof s=="string"){s=sap.ui.getCore().byId(s)}if(typeof s=="object"){for(var r=0;r<this.__aItems.length;r++){if(this.__aItems[r]==s){s=r;break}}}if(typeof s=="number"){if(s<0||s>=this.__aItems.length){e.warning("Element.removeAggregation called with invalid index: Items, "+s)}else{i=this.__aItems[s];this.__aItems.splice(s,1)}}if(this.__aItems.length<=this._iItemsForHistory&&!this._searchHelpItem){this._getListBox().removeItem(o)}if(!this._bNoItemCheck){var a=jQuery(this.getInputDomRef());var h=a.cursorPos();this._doTypeAhead(a.val().substr(0,h),"")}return i}else{return t.prototype.removeItem.apply(this,arguments)}};f.prototype.removeAllItems=function(){if(this.oPopup&&this.oPopup.isOpen()){var e=this.__aItems;if(!e){return[]}t.prototype.removeAllItems.apply(this,arguments);this.__aItems=[];return e}else{return t.prototype.removeAllItems.apply(this,arguments)}};f.prototype.indexOfItem=function(e){if(this.oPopup&&this.oPopup.isOpen()){if(this.__aItems){if(this.__aItems.length==undefined){return-2}for(var s=0;s<this.__aItems.length;s++){if(this.__aItems[s]==e){return s}}}return-1}else{return t.prototype.indexOfItem.apply(this,arguments)}};f.prototype.destroyItems=function(){if(this.oPopup&&this.oPopup.isOpen()){if(!this.__aItems){return this}this._getListBox().removeAllItems();for(var e=0;e<this.__aItems.length;e++){if(this.__aItems[e]){this.__aItems[e].destroy()}}this.__aItems=[];return this}else{return t.prototype.destroyItems.apply(this,arguments)}};f.prototype.updateItems=function(){t.prototype.updateItems.apply(this,arguments);if(this.oPopup&&this.oPopup.isOpen()){var e=jQuery(this.getInputDomRef());var s=e.cursorPos();this._doTypeAhead(e.val().substr(0,s),"")}};f.prototype._handleItemsChanged=function(e,s){if(s){this._sHandleItemsChanged=null;this._bNoItemCheck=undefined}if(this._bNoItemCheck){return}if(this.__aItems&&(!this.oPopup||!this.oPopup.isOpen())){throw new Error("DropdownBox "+this.getId()+" : this.__aItems is not empty!")}if(this.getListBox()&&this.oPopup&&this.oPopup.isOpen()){if(this.__aItems.length>this._iItemsForHistory||this._searchHelpItem){var i;var o=0;switch(e.getParameter("event")){case"destroyItems":for(o=0;o<this.__aItems.length;o++){i=this.__aItems[o];if(!i.bIsDestroyed){i.destroy()}}this.__aItems=[];if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon())}break;case"removeAllItems":this.__aItems=[];break;case"removeItem":i=e.getParameter("item");for(o=0;o<this.__aItems.length;o++){if(this.__aItems[o]==i){this.__aItems.splice(o,1);break}}if(this.__aItems.length<=this._iItemsForHistory){this._getListBox().setItems(this.__aItems,false,true)}break;case"insertItem":this.__aItems.splice(e.getParameter("index"),0,e.getParameter("item"));break;case"addItem":this.__aItems.push(e.getParameter("item"));break;case"setItems":this.__aItems=e.getParameter("items");break;case"updateItems":for(o=0;o<this.__aItems.length;o++){i=this.__aItems[o];if(!i.bIsDestroyed){i.destroy()}}if(this.getSearchHelpEnabled()){this._searchHelpItem=null;this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),this.getSearchHelpIcon())}this.__aItems=this._getListBox().getItems();break;default:break}}else{this.__aItems=this._getListBox().getItems()}var r=jQuery(this.getInputDomRef());var a=r.cursorPos();this._doTypeAhead(r.val().substr(0,a),"")}t.prototype._handleItemsChanged.apply(this,arguments);this.checkValueInItems()};f.prototype.onclick=function(e){if(!this.mobile&&this.getEnabled&&this.getEnabled()&&this.getEditable()){if(this.oPopup&&this.oPopup.isOpen()){this._close();this._doSelect()}else if(!this._F4ForClose){this._open()}this.focus()}this._F4ForClose=false};f.prototype.onmousedown=function(e){if(!this.getEnabled()||!this.getEditable()){return}if(this.oPopup&&this.oPopup.isOpen()){this._F4ForClose=true}else{this._F4ForOpen=true}t.prototype.onmousedown.apply(this,arguments)};f.prototype.onsapshow=function(e){if(this.mobile){return}if(!this.getEnabled()||!this.getEditable()){e.preventDefault();e.stopImmediatePropagation();return}if(e.which===u.F4&&this._searchHelpItem){this._close();this.fireSearchHelp({value:jQuery(this.getInputDomRef()).val()});e.preventDefault();e.stopImmediatePropagation();return}if(this.oPopup&&this.oPopup.isOpen()){this._close()}else{this._open();var t=this._getListBox();t.scrollToIndex(t.getSelectedIndex());this._doSelect()}e.preventDefault();e.stopImmediatePropagation()};f.prototype.onkeydown=function(e){if(e.target.id==this.getId()+"-select"){return}if(a.browser.webkit&&(e.which==u.DELETE||e.which==u.BACKSPACE)){this.onkeypress(e)}if(e.which!==u.BACKSPACE){return}};f.prototype.onpaste=function(e){if(e.target.id==this.getId()+"-select"){return}if(this._oValueBeforePaste===null){this._oValueBeforePaste=jQuery(this.getInputDomRef()).val()}};f.prototype.oncut=f.prototype.onpaste;f.prototype.oninput=function(e){if(this.mobile){return}var t=jQuery(this.getInputDomRef());var s=t.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined}var i=this._doTypeAhead(s,"");if(!i&&this._oValueBeforePaste){this._doTypeAhead("",this._oValueBeforePaste)}this._oValueBeforePaste=null;this._fireLiveChange(e)};f.prototype.onkeyup=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}var t=e.which;h.prototype.onkeyup.apply(this,arguments);if(this._oValueBeforePaste===null||t===u.TAB){return}if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined}var s=jQuery(this.getInputDomRef()),i=false;if(t===u.BACKSPACE&&this._iCursorPosBeforeBackspace!==null){var o=s.cursorPos();if(this._iCursorPosBeforeBackspace!==o){o++}this._iCursorPosBeforeBackspace=null;i=this._doTypeAhead(s.val().substr(0,o-1),"")}else if(!(i=this._doTypeAhead("",s.val()))){s.val(this._oValueBeforePaste)}if(i){this._getListBox().rerender()}this._oValueBeforePaste=null};f.prototype.onsaphome=function(e){if(e.target.id==this.getId()+"-select"){return}if((!this.oPopup||!this.oPopup.isOpen())&&this.getEditable()&&this.getEnabled()){h.prototype.onsaphome.apply(this,arguments);var s=jQuery(this.getInputDomRef());s.cursorPos(0);this._updateSelection();e.preventDefault()}else{t.prototype.onsaphome.apply(this,arguments)}};f.prototype.onsapdelete=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.oPopup||!this.oPopup.isOpen()){return}var t=this._getListBox(),s=t.getSelectedItem(),i=s.getId().match(/\-h\-([0-4])/),o=t.getSelectedIndex();if(i&&i.length===2){this._oHistory.remove(s.getText());t.removeItem(o);var r=this._oHistory.get().length;if(r===0){t.removeItem(0)}t.rerender();var a=o+(this._searchHelpItem?2:0);if(a==r){a++}t.setSelectedIndex(a);this.setValue(t.getSelectedItem().getText())}};f.prototype.onkeypress=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}var s=e.which,i=e.keyCode;if((t._isHotKey(e)||a.browser.firefox&&i===u.HOME||i===u.F4&&e.which===0)&&!(e.ctrlKey&&e.which==120)){return}else if(i==u.ESCAPE){var o=this.getProperty("value");var r=this.getInputDomRef();if(r&&r.value!==o){jQuery(r).val(o)}return}var h=String.fromCharCode(s),p=jQuery(this.getInputDomRef()),n=p.cursorPos(),l=p.val();if(!this.oPopup||!this.oPopup.isOpen()){this.noTypeAheadByOpen=true;this._open();this.noTypeAheadByOpen=undefined}if(s===u.BACKSPACE){this._doTypeAhead(l.substr(0,n-1),"")}else{this._doTypeAhead(l.substr(0,n),h)}if(l!=p.val()){this._fireLiveChange(e)}this._bFocusByOpen=undefined;e.preventDefault()};f.prototype.onsapright=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}var t=d.getRTL();if(!t){this._updateSelection(1)}else{this._updateSelection(-1)}e.preventDefault()};f.prototype.onsapleft=function(e){if(e.target.id==this.getId()+"-select"){return}if(!this.getEnabled()||!this.getEditable()){return}var t=d.getRTL();if(!t){this._updateSelection(-1)}else{this._updateSelection(1)}e.preventDefault()};f.prototype.onfocusin=function(e){if(!this.oPopup||!this.oPopup.isOpen()||this._bFocusByOpen){var s=jQuery(this.getInputDomRef()),i=s.val().length;if(i>0&&!this.mobile){this._callDoSelectAfterFocusIn(0,i)}this._bFocusByOpen=undefined}t.prototype.onfocusin.apply(this,arguments)};f.prototype._callDoSelectAfterFocusIn=function(e,t){this._doSelect(e,t)};f.prototype.onselect=function(e){var t=(new Date).getTime();if(this._bIgnoreSelect){this._bIgnoreSelect=false;this.iOldTimestamp=t;return}if(this.iOldTimestamp&&t-this.iOldTimestamp<50){return}this.iOldTimestamp=undefined;if(!this.getEnabled()||!this.getEditable()){return}var s=jQuery(this.getInputDomRef()),i=s.cursorPos(),o=s.val();if(o.length>0&&i>0){this._doTypeAhead(o.substr(0,i),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox())}}e.preventDefault()};f.prototype._determinePosinset=function(e,t){var s=t+1;if(this.oPopup&&this.oPopup.isOpen()){this.dontSetPoisinset=undefined;var i=e[t];var o=e[0].getId().search(this.getId()+"-h-")!=-1;if(i.getId().search(this.getId()+"-h-")==-1){if(o){s=s-1}if(this._searchHelpItem){s=s-2}}}return s};f.prototype._doSelect=function(e,t){this._bIgnoreSelect=true;var s=this.getInputDomRef();if(s){var i=jQuery(s);i.selectText(e?e:0,t?t:i.val().length)}return this};f.prototype._updateSelection=function(e){var t=jQuery(this.getInputDomRef()),s=t.cursorPos()+(e||0),i=t.val();this._doTypeAhead(i.substr(0,s),"");if(!this.oPopup||!this.oPopup.isOpen()){this._cleanupClose(this._getListBox())}else{this._getListBox().rerender()}};f.prototype._doTypeAhead=function(e,t,s,i){if(this.__doTypeAhead===true){return}this.__doTypeAhead=true;this._sWantedSelectedKey=undefined;this._sWantedSelectedItemId=undefined;this._sWantedValue=undefined;var o=this._getListBox(),r=this.getMaxPopupItems(),a=this.__aItems||o.getItems(),h=a.length,p=this.getMaxHistoryItems()>0&&a.length>this._iItemsForHistory,n=!s&&p,l=e+t,u=new RegExp("[.*+?|()\\[\\]{}\\\\]","g"),d=l.toLowerCase().replace(u,"\\$&"),f=RegExp("^"+d+".*$"),c=t&&t.length||0,_=jQuery(this.getInputDomRef());this.__aItems=a;if(h<=0){this.__doTypeAhead=false;return false}var m,g=this._getFilteredItems(a,f),I=g.length>0;if(!I){n=false}if(n){m=g}else{m=a.slice(0)}var y=[];if(p){y=this._addHistoryItems(m,n&&f);o.setItems(m,false,true);h=m.length}o.setVisibleItems(r<h?r:-1);var v,H=y.length;var x=0;if(i>=0){v=a[i]}if(!n&&H>0&&I){y=this._getFilteredItems(y,f);v=y[0]}if(n){v=g[0]}else if(!v){if(g.length>0){v=g[0]}else{var P=_.val();var b=0;for(x=0;x<m.length;x++){var S=m[x];if(S.getEnabled()){if(!b){b=x}if(S.getText()==P){v=S;break}}}if(!v){v=m[b]}}}var T=this._searchHelpItem;if(T){m.splice(H++,0,T[0],T[1]);o.setItems(m,false,true)}x=o.indexOfItem(v);var B=v.getText();var A=x+1;var D=m.length;if(y.length>0){D=D-1}if(T){D=D-2}if(A>y.length){if(y.length>0){A=A-1}if(T){A=A-2}}this._updatePosInSet(_,A,v.getAdditionalText?v.getAdditionalText():"");_.attr("aria-setsize",D);_.val(B);this._sTypedChars=l;this._doSelect(e.length+c,B.length);o.setSelectedIndex(x);if(T&&x==2){o.scrollToIndex(0)}else{o.scrollToIndex(x)}this._iClosedUpDownIdx=x;if(!I){_=this.$();_.addClass("sapUiTfErr");setTimeout(function(){_.removeClass("sapUiTfErr")},300);_.cursorPos(e.length);this._doSelect(e.length,B.length)}this.__doTypeAhead=false;return I};f.prototype._prepareOpen=function(e,t){this._oValueBeforeOpen=jQuery(this.getInputDomRef()).val();this._bOpening=true;if(!this.noTypeAheadByOpen){var s;if(this._iClosedUpDownIdx>=0){s=this._iClosedUpDownIdx}else if(this.getSelectedItemId()){s=this.indexOfItem(sap.ui.getCore().byId(this.getSelectedItemId()))}this._doTypeAhead("",jQuery(this.getInputDomRef()).val(),true,s);this._doSelect()}return this};f.prototype._handleOpened=function(){t.prototype._handleOpened.apply(this,arguments);jQuery(this.getInputDomRef()).trigger("focus")};f.prototype._cleanupClose=function(e){if(this.__aItems){var t=e.getSelectedItem();e.setItems(this.__aItems,false,true);this._iClosedUpDownIdx=e.indexOfItem(t);e.setSelectedIndex(this._iClosedUpDownIdx);this.__aItems=undefined}this._oValueBeforeOpen=null;this._bOpening=undefined;return this};f.prototype._getFilteredItems=function(e,t){var s=e.slice(0),i;for(var o=s.length-1;o>=0;o--){i=s[o];if(!t.test(i.getText().toLowerCase())||!i.getEnabled()){s.splice(o,1)}}return s};f.prototype._addHistoryItems=function(e,t){var s=this.getId()+"-h-",i,o=this._oHistory.get(),r=o.length,a=[];for(var h=0,n=0;n<this.getMaxHistoryItems()&&h<r;h++){if(!t||t.test(o[h])){i=(i=sap.ui.getCore().byId(s+n))&&i.setText(o[h])||new p(s+n,{text:o[h]});a.push(i);n++}}if(a.length>0){var l=s+"separator",u=this._getSeparator(l);a.push(u)}e.unshift.apply(e,a);return a};f.prototype._getSeparator=function(e){if(!this.__oSeparator&&e){this.__oSeparator=sap.ui.getCore().byId(e)||new o(e)}return this.__oSeparator||null};f.prototype.fireChange=function(e){this.fireEvent("change",e);if(e.newValue&&this.getMaxHistoryItems()>0){this._oHistory.add(e.newValue)}this._sWantedValue=undefined;return this};f.prototype.setValue=function(e,s){e=e===undefined||e===null||e===""?"":e;var i=this.getItems(),o,r=false,a;for(var h=0,p=i.length;h<p&&!r;h++){var n=i[h];var l=n.getEnabled();o=n.getText();if(l&&!a){a=o}r=o===e&&l}if(r){t.prototype.setValue.call(this,e,s);this._sWantedValue=undefined}else if(e===""&&i.length>0){t.prototype.setValue.call(this,a,s)}else{this._sWantedValue=e}return this};f.prototype.applyFocusInfo=function(e){t.prototype.applyFocusInfo.apply(this,arguments);if(!this._bOpening&&(!this.oPopup||!this.oPopup.isOpen())){this._cleanupClose(this._getListBox())}return this};f.prototype._focusAfterListBoxClick=function(){if(!a.browser.webkit){this.focus()}else{var e=this._getListBox();e.addDelegate({onclick:function(){e.removeDelegate(this);this.focus()}.bind(this)})}};f.prototype.onsapfocusleave=function(e){var t=this._getListBox();if(e.relatedControlId&&n(t.getFocusDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this._focusAfterListBoxClick()}else{if(this.oPopup&&this.oPopup.isOpen()){this._close()}h.prototype.onsapfocusleave.apply(this,arguments)}};f.prototype.getTooltip_AsString=function(){var e=t.prototype.getTooltip_AsString.apply(this,arguments);if(!this._searchHelpItem){return e}else{var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var i=s.getText("DDBX_SHI_ARIA");i=i==="DDBX_SHI_ARIA"?"Open search help via {0}":i;var o=this._searchHelpItem[0]&&this._searchHelpItem[0].getAdditionalText()||s.getText("DDBX_SHIF4");o=o==="DDBX_SHIF4"?"F4":o;i=i.replace("{0}",o);return(e?e+" - ":"")+i}};f.prototype._handleSelect=function(e){if(this._searchHelpItem&&e.getParameter("selectedItem")===this._searchHelpItem[0]){var s=new jQuery.Event("sapshow");s.which=u.F4;this.onsapshow(s)}else{var i=e.getParameter("selectedItem");if(!i){i=sap.ui.getCore().byId(e.getParameter("selectedId"))}if(i.getId().search(this.getId()+"-h-")!=-1){var o=this._getListBox(),r=o.getItems();var a=this._oHistory.get().length;if(a>this.getMaxHistoryItems()){a=Math.max(this.getMaxHistoryItems(),0)}for(var h=a;h<r.length;h++){if(r[h].getText()==i.getText()&&r[h].getEnabled()){e.mParameters.selectedIndex=h;if(!e.getParameter("selectedIndices")){e.mParameters.selectedIndices=new Array(1);e.mParameters.aSelectedIndices=new Array(1)}e.mParameters.selectedIndices[0]=h;e.mParameters.aSelectedIndices[0]=h;e.mParameters.selectedItem=r[h];break}}}this._sWantedValue=undefined;return t.prototype._handleSelect.apply(this,arguments)}};f.prototype.setSearchHelpEnabled=function(e,t,s,i){this.setProperty("searchHelpEnabled",e);if(t){this.setProperty("searchHelpText",t)}else{t=this.getSearchHelpText()}if(s){this.setProperty("searchHelpAdditionalText",s)}else{s=this.getSearchHelpAdditionalText()}if(i){this.setProperty("searchHelpIcon",i)}else{i=this.getSearchHelpIcon()}if(e){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(r){t=t||r.getText("DDBX_SHI");t=t==="DDBX_SHI"?"Search Help":t;s=s||r.getText("DDBX_SHIF4");s=s==="DDBX_SHIF4"?"F4":s}i=i||sap.ui.require.toUrl("sap/ui/commons/images/dropdown/ico12_f4.gif");if(!this._searchHelpItem){this._searchHelpItem=[new p(this.getId()+"_shi",{text:t,additionalText:s,enabled:true,icon:i}),new o]}else{this._searchHelpItem[0].setText(t).setAdditionalText(s).setIcon(i)}}else{if(this._searchHelpItem){this._searchHelpItem[0].destroy();this._searchHelpItem[1].destroy();this._searchHelpItem=null}}return this};f.prototype.setSearchHelpText=function(e){this.setProperty("searchHelpText",e);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),e,this.getSearchHelpAdditionalText(),this.getSearchHelpIcon());return this};f.prototype.setSearchHelpAdditionalText=function(e){this.setProperty("searchHelpAdditionalText",e);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),e,this.getSearchHelpIcon());return this};f.prototype.setSearchHelpIcon=function(e){this.setProperty("searchHelpIcon",e);this.setSearchHelpEnabled(this.getSearchHelpEnabled(),this.getSearchHelpText(),this.getSearchHelpAdditionalText(),e);return this};f.prototype.checkValueInItems=function(){var e=this.getValue();var s=t.prototype.getItems.apply(this);var i=this._sWantedSelectedKey;var o=this._sWantedSelectedItemId;if(s&&s.length>0){var r=false;var a;var h=0,p=0;var n;var l=false;var u="";if(this._sWantedValue){for(h=0,p=s.length;h<p&&!r;h++){n=s[h];l=n.getEnabled();u=n.getText();if(l&&!a){a=u}r=u===this._sWantedValue&&l}if(r){e=this._sWantedValue;this._sWantedValue=undefined;i=undefined;o=undefined;t.prototype.setValue.call(this,e)}}if(!r){for(h=0,p=s.length;h<p&&!r;h++){n=s[h];l=n.getEnabled();u=n.getText();if(l&&!a){a=u}r=u===e&&l}}if(!r){e=a;t.prototype.setValue.call(this,e)}}else{e="";t.prototype.setValue.call(this,e)}this._sWantedSelectedKey=i;this._sWantedSelectedItemId=o;return e};f.prototype.setMaxHistoryItems=function(e){var t=this.getMaxHistoryItems();var s=this.getId()+"-h-";var i;this.setProperty("maxHistoryItems",e,true);if(e<t){var o=this._getListBox();for(var r=Math.max(e,0);r<t;r++){i=sap.ui.getCore().byId(s+r);if(i){o.removeItem(i);i.destroy()}}if(e<=0&&this.__oSeparator){o.removeItem(this.__oSeparator)}}return this};f.prototype.clearHistory=function(){this._oHistory.clear();var e=this.getId()+"-h-";var t=this._getListBox();var s;for(var i=0;i<this.getMaxHistoryItems();i++){s=sap.ui.getCore().byId(e+i);if(s){t.removeItem(s);s.destroy()}}if(this.__oSeparator){t.removeItem(this.__oSeparator)}};f.prototype.ondrop=function(e){e.preventDefault()};f.prototype._isSetEmptySelectedKeyAllowed=function(){return false};return f});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/DropdownBoxRenderer", ["./ComboBoxRenderer","sap/ui/core/Renderer","sap/ui/core/library"],function(e,t,i){"use strict";var r=i.ValueState;var n=t.extend(e);n.renderOuterContentBefore=function(e,t){this.renderExpander(e,t)};n.renderOuterContent=function(e,t){this.renderSelectBox(e,t,"0");if(t.getDisplaySecondaryValues()){e.write('<span id="'+t.getId()+'-SecVal" style="display: none;"></span>')}};n.renderTextFieldEnabled=function(e,t){if(t.mobile){e.writeAttribute("tabindex","-1")}else if(!t.getEnabled()){e.writeAttribute("disabled","disabled");e.writeAttribute("tabindex","-1")}else if(!t.getEditable()){e.writeAttribute("tabindex","0")}else{e.writeAttribute("tabindex","0")}};n.renderARIAInfo=function(e,t){var i=-1;if(t.getSelectedItemId()){for(var n=0;n<t.getItems().length;n++){var a=t.getItems()[n];if(a.getId()==t.getSelectedItemId()){i=n+1;break}}}var d={autocomplete:"list",live:"polite",setsize:t.getItems().length,posinset:i>=0?i:undefined};if(t.getValueState()==r.Error){d["invalid"]=true}if(t.getDisplaySecondaryValues()){d["describedby"]={value:t.getId()+"-SecVal",append:true}}e.writeAccessibilityState(t,d)};return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/FileUploader", ["sap/base/Log","./library","sap/ui/unified/FileUploader","./FileUploaderRenderer","sap/ui/core/Core"],function(e,r,a,i,o){"use strict";var s=a.extend("sap.ui.commons.FileUploader",{metadata:{deprecated:true,library:"sap.ui.commons"}});try{sap.ui.getCore().loadLibrary("sap.ui.unified")}catch(r){e.error("The control 'sap.ui.commons.FileUploader' needs library 'sap.ui.unified'.");throw r}return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/FileUploaderParameter", ["sap/base/Log","./library","sap/ui/unified/FileUploaderParameter"],function(e,a,r){"use strict";var i=r.extend("sap.ui.commons.FileUploaderParameter",{metadata:{deprecated:true,library:"sap.ui.commons"}});try{sap.ui.getCore().loadLibrary("sap.ui.unified")}catch(a){e.error("The element 'sap.ui.commons.FileUploaderParameter' needs library 'sap.ui.unified'.");throw a}return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/FileUploaderRenderer", ["sap/ui/core/Renderer","sap/ui/unified/FileUploaderRenderer"],function(e,r){"use strict";var i=e.extend(r);return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/FormattedTextView", ["sap/base/Log","./library","sap/ui/core/Control","./FormattedTextViewRenderer","sap/ui/core/library","sap/base/security/sanitizeHTML"],function(e,t,r,i,n,s){"use strict";var a=n.AccessibleRole;var o=r.extend("sap.ui.commons.FormattedTextView",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:a.Document},htmlText:{type:"string",group:"Misc",defaultValue:""}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control"}}}});o.prototype.init=function(){this._renderingRules={};this._renderingRules.ATTRIBS={"span::class":1,"div::class":1,"div::id":1,"span::id":1,"embed::data-index":1};this._renderingRules.ELEMENTS={abbr:1,acronym:1,address:1,blockquote:1,br:1,cite:1,code:1,dfn:1,div:1,em:1,h1:1,h2:1,h3:1,h4:1,h5:1,h6:1,kbd:1,p:1,pre:1,q:1,samp:1,strong:1,span:1,var:1,dl:1,dt:1,dd:1,ol:1,ul:1,li:1,embed:1}};o.prototype.exit=function(){delete this._renderingRules};o.prototype.hasControls=function(){var e=this.getAggregation("controls");return!!(e&&e.length>0)};var l=function(t,r){var i=/^[0-9]*$/;for(var n=0;n<r.length;n+=2){var s=t+"::"+r[n];if(this._renderingRules.ATTRIBS[s]){if(t==="embed"&&!r[n+1].match(i)){return null}}else{var a="<"+t+"> with attribute ["+r[n]+'="'+r[n+1]+'"] is not allowed and cut';e.warning(a,this);r[n+1]=null}}return r};var u=function(t,r){if(this._renderingRules.ELEMENTS[t]){return l.call(this,t,r)}else{var i="<"+t+"> is not allowed";e.warning(i,this)}};o.prototype.setHtmlText=function(e){var t=s(e,{tagPolicy:u.bind(this)});this.setProperty("htmlText",t);return this};var c=function(e){if(this.hasControls()){this.removeAllAggregation("controls")}var t=Array.isArray(e);if(t&&e.length>0){for(var r=0;r<e.length;r++){this.addAggregation("controls",e[r],true)}this.invalidate()}};o.prototype.setContent=function(e,t){this.setHtmlText(e);c.call(this,t)};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/FormattedTextViewRenderer", ["sap/base/Log"],function(e){"use strict";var t={};t.render=function(t,r){var n=/<embed\s+data-index="([0-9]+)"\s*\/?>/gim;var i=r.getHtmlText();var a=r.getControls().slice();var l=a.length;var s=0;var o=[];t.write("<span");t.writeControlData(r);t.addClass("sapUiFTV");t.writeClasses();if(r.getTooltip_AsString()){t.writeAttributeEscaped("title",r.getTooltip_AsString())}t.write(">");while((o=n.exec(i))!==null){t.write(i.slice(s,o.index));if(this._renderReplacement(t,o[1],a)){l--}else{e.warning("Could not find matching control to placeholder #"+o[1])}s=n.lastIndex}t.write(i.slice(s,i.length));if(l>0){e.warning("There are leftover controls in the aggregation that have not been used in the formatted text",r)}t.write("</span>")};t._renderReplacement=function(e,t,r){if(r[t]){e.renderControl(r[t]);r[t]=null;return true}else{return false}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/HorizontalDivider", ["./library","sap/ui/core/Control","./HorizontalDividerRenderer"],function(e,r,i){"use strict";var a=e.HorizontalDividerHeight;var o=e.HorizontalDividerType;var t=r.extend("sap.ui.commons.HorizontalDivider",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},type:{type:"sap.ui.commons.HorizontalDividerType",group:"Appearance",defaultValue:o.Area},height:{type:"sap.ui.commons.HorizontalDividerHeight",group:"Appearance",defaultValue:a.Medium}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/HorizontalDividerRenderer", [],function(){"use strict";var i={};i.render=function(i,e){i.write("<hr");i.writeControlData(e);i.writeAttribute("role","separator");if(e.getWidth()){i.writeAttribute("style","width:"+e.getWidth()+";")}i.addClass("sapUiCommonsHoriDiv");i.addClass(e.getType()=="Page"?"sapUiCommonsHoriDivTypePage":"sapUiCommonsHoriDivTypeArea");switch(e.getHeight()){case"Ruleheight":i.addClass("sapUiCommonsHoriDivHeightR");break;case"Small":i.addClass("sapUiCommonsHoriDivHeightS");break;case"Large":i.addClass("sapUiCommonsHoriDivHeightL");break;default:i.addClass("sapUiCommonsHoriDivHeightM")}i.writeClasses();i.write(">")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Image", ["./library","sap/ui/core/Control","./ImageRenderer"],function(e,t,r){"use strict";var o=t.extend("sap.ui.commons.Image",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.commons.FormattedTextViewControl","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},decorative:{type:"boolean",group:"Accessibility",defaultValue:true},alt:{type:"string",group:"Accessibility",defaultValue:null},useMap:{type:"string",group:"Misc",defaultValue:null}},events:{press:{}}}});o.prototype.onclick=function(e){this.firePress({})};o.prototype.onsapenter=o.prototype.onclick;o.prototype.getFormDoNotAdjustWidth=function(){return true};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ImageMap", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./ImageMapRenderer","./Area"],function(jQuery,e,t,a,i,o){"use strict";var r=t.extend("sap.ui.commons.ImageMap",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{name:{type:"string",group:"Misc",defaultValue:null}},aggregations:{areas:{type:"sap.ui.commons.Area",multiple:true,singularName:"area"}},events:{press:{parameters:{areaId:{type:"string"}}}}}});r.prototype.createArea=function(){var e=new o;for(var t=0;t<arguments.length;t++){var a=arguments[t];var e;if(a instanceof o){e=a}else{e=new o(a)}this.addArea(e)}return this};r.prototype.onAfterRendering=function(){this.oDomRef=this.getDomRef();if(!this.oItemNavigation){this.oItemNavigation=new a}this.addDelegate(this.oItemNavigation);this.oItemNavigation.setRootDomRef(this.oDomRef);var e=[];var t=this.getAreas();for(var i=0;i<t.length;i++){var o=t[i].getFocusDomRef();if(o){e.push(o)}}this.oItemNavigation.setItemDomRefs(e);this.oItemNavigation.setCycling(true);this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.setFocusedIndex(-1)};r.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ImageMapRenderer", ["sap/ui/core/Configuration"],function(t){"use strict";var e={};e.render=function(e,i){var r=t.getAccessibility();var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");e.write('<span id="'+i.getId()+'-Descr" style="visibility: hidden; display: none; outline: none;">');e.writeEscaped(a.getText("IMAGEMAP_DSC"));e.write("</span>");e.write("<map tabindex='-1'");e.writeControlData(i);e.writeAttributeEscaped("name",i.getName());if(i.getTooltip_AsString()){e.writeAttributeEscaped("title",i.getTooltip_AsString())}e.write(">");var s=i.getAreas();for(var n=0,o=s.length;n<o;n++){e.write("<area ");e.writeElementData(s[n]);e.write(' style="display: inline;"');if(r){e.writeAttribute("aria-describedby",i.getId()+"-Descr")}var d=s[n].getShape();var p=s[n].getCoords();var u=s[n].getHref();var l=s[n].getAlt();var c=s[n].getTooltip_AsString();if(d==="rect"||d==="circle"||d==="poly"){e.writeAttribute("shape",d)}else{e.writeAttribute("shape","default")}if(p){e.writeAttributeEscaped("coords",p)}if(u){e.writeAttributeEscaped("href",u)}if(l){e.writeAttributeEscaped("alt",l)}if(c){e.writeAttributeEscaped("title",c)}e.writeAttribute("tabindex",0);e.write(">")}e.write("</map>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ImageRenderer", [],function(){"use strict";var t={};t.render=function(t,e){t.write("<img");t.writeControlData(e);t.writeAttributeEscaped("src",e.getSrc()||sap.ui.require.toUrl("sap/ui/commons/img/1x1.gif"));t.addClass("sapUiImg");if(e.hasListeners("press")){t.addClass("sapUiImgWithHandler")}if(!e.getSrc()){t.addClass("sapUiImgNoSource")}t.writeClasses();var i=e.getTooltip_AsString();if(i){t.writeAttributeEscaped("title",i)}var r=e.getUseMap();if(r){if(!r.startsWith("#")){r="#"+r}t.writeAttributeEscaped("usemap",r)}var s=0;if(e.getDecorative()&&!r){s=-1;t.writeAttribute("role","presentation");t.write(" alt=''")}else{if(e.getAlt()){t.writeAttributeEscaped("alt",e.getAlt()||i)}else if(i){t.writeAttributeEscaped("alt",i)}}t.writeAttribute("tabindex",s);var a="";if(e.getWidth()&&e.getWidth()!=""){a+="width:"+e.getWidth()+";"}if(e.getHeight()&&e.getHeight()!=""){a+="height:"+e.getHeight()+";"}if(a!=""){t.writeAttribute("style",a)}t.write(">")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/InPlaceEdit", ["./TextField","./TextView","./library","sap/ui/core/Control","sap/ui/core/ValueStateSupport","sap/ui/core/theming/Parameters","./InPlaceEditRenderer","sap/ui/core/library","sap/ui/Device","./Button","sap/ui/dom/containsOrEquals","sap/ui/events/KeyCodes"],function(t,e,i,o,s,n,a,l,r,d,h,u){"use strict";var _=i.TextViewDesign;var f=l.ValueState;var p=o.extend("sap.ui.commons.InPlaceEdit",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:f.None},undoEnabled:{type:"boolean",group:"Misc",defaultValue:true},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:_.Standard}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});p.prototype.init=function(){this._bEditMode=false};p.prototype.exit=function(){this._bEditMode=undefined;this._oDisplayControl=undefined;this._oEditControl=undefined;this._sOldText=undefined;this._sOldTextAvailable=undefined;this._bUseEditButton=undefined;this._iHeight=undefined;if(this._oTextView){this._oTextView.destroy();delete this._oTextView}if(this._oTextField){this._oTextField.destroy();delete this._oTextField}if(this._oUndoButton){this._oUndoButton.destroy();delete this._oUndoButton}if(this._oEditButton){this._oEditButton.destroy();delete this._oEditButton}var e=this.getContent();if(e){e.detachEvent("_change",B,this);if(e instanceof t){e.detachEvent("change",w,this);e.detachEvent("liveChange",D,this)}}};p.prototype.onBeforeRendering=function(){var t=this;g(t);x(t);var e=this.getTooltip();if(e instanceof sap.ui.core.TooltipBase){if(this._bEditMode){e._currentControl=this._oEditControl}else{e._currentControl=this._oDisplayControl}}};p.prototype.onAfterRendering=function(){if(!this._bEditMode&&this.getEditable()&&this._oTextView&&this._oTextView.getDomRef()){this._oTextView.$().attr("tabindex","0")}var t=this.$();var e;var i;if(this._bEditMode){this._oEditControl.$().css("width","100%");if(this._iHeight>0){i=t.height();var o=this._iHeight-i;var s=t.outerHeight(true)-t.outerHeight(false);o=o+s;var n=Math.floor(o/2);var a=o-n;t.css("margin-top",n+"px").css("margin-bottom",a+"px")}}else if(this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){this._oDisplayControl.$().css("width","auto").css("max-width","100%")}else{var l=this._oDisplayControl.$();l.css("width","100%");if(!this._iHeight&&this._iHeight!=0&&this.getDesign()!=_.Standard){e=l.outerHeight(true);i=t.innerHeight();if(i<e){var r=t.outerHeight()-t.innerHeight();this._iHeight=e+r}else{this._iHeight=0}}if(this._iHeight>0){t.css("height",this._iHeight+"px")}}if(this._sOldTextAvailable&&this._oUndoButton&&this._oUndoButton.getDomRef()){this._oUndoButton.$().attr("tabindex","-1")}if(this._oEditButton&&this._oEditButton.getDomRef()){this._oEditButton.$().attr("tabindex","-1")}if(this._delayedCallId){clearTimeout(this._delayedCallId);this._delayedCallId=null}if(this.getValueState()==f.Success){this._delayedCallId=setTimeout(function(){this.removeValidVisualization()}.bind(this),3e3)}};p.prototype.removeValidVisualization=function(){var t=this.$();if(t){t.removeClass("sapUiIpeSucc")}};p.prototype.clearOldText=function(){if(!this.getUndoEnabled()){return}if(this._bEditMode){this._sOldText=this._oEditControl.getValue();this._sOldTextAvailable=true}else{this._sOldText=undefined;this._sOldTextAvailable=false}this.rerender()};p.prototype.getRequired=function(){if(this.getContent()&&this.getContent().getRequired){return this.getContent().getRequired()}else{return false}};p.prototype.getEditable=function(){var t=this.getContent();if(!t||t.getEditable&&!t.getEditable()||t.getEnabled&&!t.getEnabled()){return false}else{return true}};p.prototype.onsapescape=function(t){if(this.getUndoEnabled()){if(!r.browser.firefox){var e=this;b(e)}else{this._bEsc=true}if(this.$().hasClass("sapUiIpeUndo")){t.stopPropagation()}this._oEditControl._bEsc=undefined;this._oEditControl._sValue=undefined}};p.prototype.onkeypress=function(t){if(this._bEsc){var e=this;this._bEsc=undefined;b(e)}};p.prototype.onkeydown=function(t){if(t.keyCode==u.F2&&!this._bEditMode){var e=this;T(e);this.$().addClass("sapUiIpeFocus")}};p.prototype.onfocusin=function(t){if(!this._bEditMode){if(!this._bUseEditButton&&t.target.id!=this.getId()+"--X"){var e=this;T(e)}this.$().addClass("sapUiIpeFocus")}else if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null}};p.prototype.ontap=function(t){if(r.os.name=="iOS"){this.onfocusin(t)}};p.prototype.onfocusout=function(t){if(this._focusDelay){clearTimeout(this._focusDelay);this._focusDelay=null}this._focusDelay=setTimeout(function(){this._handleFocusOut(t)}.bind(this),200)};p.prototype._handleFocusOut=function(t){var e=document.activeElement;if(!h(this.getDomRef(),e)){if(!this._bEditMode){this.$().removeClass("sapUiIpeFocus")}var i=this;E(i)}this._focusDelay=undefined};p.prototype.setContent=function(e){var i=this.getContent();if(i){i.detachEvent("_change",B,this);if(i instanceof t){i.detachEvent("change",w,this);i.detachEvent("liveChange",D,this);i._propagateEsc=undefined}}this._sOldText=undefined;this._sOldTextAvailable=false;this._oDisplayControl=undefined;this._oEditControl=undefined;this.setAggregation("content",e);if(e){e.attachEvent("_change",B,this);if(e instanceof t){e.attachEvent("change",w,this);e.attachEvent("liveChange",D,this);e._propagateEsc=true}}var o=this;g(o);return this};p.prototype.setValueState=function(t){var e=this.getContent();if(e&&e.setValueState){e.setValueState(t)}else if(this._oEditControl&&this._oEditControl.setValueState){this._oEditControl.setValueState(t);B.call(this)}else{this.setProperty("valueState",t)}return this};p.prototype.getValueState=function(){var t=this.getContent();if(t&&t.getValueState){return t.getValueState()}else if(this._oEditControl&&this._oEditControl.getValueState){return this._oEditControl.getValueState()}else{return this.getProperty("valueState")}};p.prototype.setTooltip=function(t){var e=this.getContent();if(e){e.setTooltip(t)}else{this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t)}return this};p.prototype.getTooltip=function(){var t=this.getContent();if(t){return t.getTooltip()}else{return this.getAggregation("tooltip")}};p.prototype.setDesign=function(t){this.setProperty("design",t);this._iHeight=undefined;return this};p.prototype.clone=function(){var e=this.getContent();if(e){e.detachEvent("_change",B,this);if(e instanceof t){e.detachEvent("change",w,this);e.detachEvent("liveChange",D,this)}}var i=o.prototype.clone.apply(this,arguments);if(e){e.attachEvent("_change",B,this);if(e instanceof t){e.attachEvent("change",w,this);e.attachEvent("liveChange",D,this)}}return i};p.prototype.getFocusDomRef=function(){if(!this.getDomRef()){return undefined}if(this._bEditMode){return this._oEditControl.getFocusDomRef()}else{return this._oDisplayControl.getFocusDomRef()}};p.prototype.getIdForLabel=function(){if(this._oDisplayControl&&this._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){return this._oDisplayControl.getId()}else if(this._oEditControl){return this._oEditControl.getId()}else{return this.getId()}};p.prototype.onThemeChanged=function(t){var e=this;C(e);V(e);this._iHeight=undefined;if(this.getDomRef()&&!this._bEditMode){this.rerender()}};p.prototype.getAccessibilityInfo=function(){var t=this.getContent();return t&&t.getAccessibilityInfo?t.getAccessibilityInfo():null};var c={onAfterRendering:function(){this.onAfterRendering()}};function g(t){var i=t.getContent();if(!i){return}var o=i.getTooltip();switch(i.getMetadata().getName()){case"sap.ui.commons.TextField":case"sap.ui.commons.ComboBox":case"sap.ui.commons.DropdownBox":if(!t._oTextView){t._oTextView=new e(t.getId()+"--TV",{wrapping:false});t._oTextView.setParent(t);t._oTextView.removeDelegate(c);t._oTextView.addDelegate(c,t);t._oTextView.getTooltip=function(){return this.getParent().getTooltip()}}t._oTextView.setText(i.getValue());t._oTextView.setEnabled(i.getEnabled());t._oTextView.setTextDirection(i.getTextDirection());t._oTextView.setVisible(i.getVisible());t._oTextView.setWidth("100%");t._oTextView.setTextAlign(i.getTextAlign());t._oTextView.setDesign(t.getDesign());t._oTextView.setHelpId(i.getHelpId());t._oTextView.setAccessibleRole(i.getAccessibleRole());if(t._oTextView._oTooltip&&t._oTextView._oTooltip!=o){t._oTextView.removeDelegate(t._oTextView._oTooltip);t._oTextView._oTooltip=undefined}if(o instanceof sap.ui.core.TooltipBase){if(!t._oTextView._oTooltip||t._oTextView._oTooltip!=o){t._oTextView.addDelegate(o);t._oTextView._oTooltip=o}}t._oDisplayControl=t._oTextView;t._oEditControl=i;t._bUseEditButton=false;break;case"sap.ui.commons.Link":t._oDisplayControl=i;t._oDisplayControl.removeDelegate(c);t._oDisplayControl.addDelegate(c,t);if(t._oTextField){t._oTextField.setValue(i.getText());t._oTextField.setWidth("100%");t._oEditControl=t._oTextField;if(t._oTextField._oTooltip&&t._oTextField._oTooltip!=o){t._oTextField.removeDelegate(t._oTextField._oTooltip);t._oTextField._oTooltip=undefined}if(o instanceof sap.ui.core.TooltipBase){if(!t._oTextField._oTooltip||t._oTextField._oTooltip!=o){t._oTextField.addDelegate(o);t._oTextField._oTooltip=o}}}y(t);t._bUseEditButton=true;break;default:throw new Error("Control not supported for InPlaceEdit")}}function T(e){if(!e._bEditMode&&e.getEditable()){if(!e._oEditControl&&e.getContent().getMetadata().getName()=="sap.ui.commons.Link"){var i=e.getValueState();e._oTextField=new t(e.getId()+"--input",{valueState:i});e._oTextField.setParent(e);e._oTextField.attachEvent("change",U,e);e._oTextField.attachEvent("liveChange",D,e);e._oTextField._propagateEsc=true;e._oTextField.getTooltip=function(){return this.getParent().getTooltip()}}if(!e._sOldTextAvailable&&e.getUndoEnabled()){e._sOldText=v(e);e._sOldTextAvailable=true}e._bEditMode=true;e.rerender();e._oEditControl.focus()}}function E(t){if(t._bEditMode&&t.getEditable()){t._bEditMode=false;if(t._sOldText==v(t)){t._sOldText=undefined;t._sOldTextAvailable=false}t.rerender()}}function v(t){var e=t.getContent();if(!e){return undefined}if(e.getValue){return e.getValue()}else if(e.getText){return e.getText()}}function x(t){if(!t._oUndoButton&&t.getUndoEnabled()){t._oUndoButton=new d(t.getId()+"--X",{lite:true}).setParent(t);C(t);t._oUndoButton.attachEvent("press",m,t)}if(t._oUndoButton){t._oUndoButton.setEnabled(t.getEditable())}}function C(t){if(t._oUndoButton){var e=n._getThemeImage("_sap_ui_commons_InPlaceEdit_UndoImageURL");var i=n._getThemeImage("_sap_ui_commons_InPlaceEdit_UndoImageDownURL");if(!e){e="sap-icon://decline"}t._oUndoButton.setIcon(e);t._oUndoButton.setIconHovered(i)}}function m(t){var e=this;b(e);if(this._bEditMode){this._oEditControl.focus();this.$().removeClass("sapUiIpeUndo")}}function b(t){if(t.getUndoEnabled()&&t._sOldTextAvailable){var e=t.getContent();if(!e){return}if(e.setValue){e.setValue(t._sOldText)}else if(e.setText){e.setText(t._sOldText)}if(t._bEditMode){t._oEditControl.setValue(t._sOldText);t._oEditControl.fireChange({newValue:t._sOldText})}else if(e.fireChange){e.fireChange({newValue:t._sOldText})}else{t.fireChange({newValue:t._sOldText})}if(!t._bEditMode){t._sOldText=undefined;t._sOldTextAvailable=false}}}function y(t){if(!t._oEditButton){t._oEditButton=new d(t.getId()+"--Edit",{lite:true}).setParent(t);t._oEditButton.addStyleClass("sapUiIpeEBtn");V(t);t._oEditButton.attachEvent("press",I,t)}}function V(t){if(t._oEditButton){var e=n._getThemeImage("_sap_ui_commons_InPlaceEdit_EditImageURL");var i=n._getThemeImage("_sap_ui_commons_InPlaceEdit_EditImageDownURL");if(!e){e="sap-icon://edit"}t._oEditButton.setIcon(e);t._oEditButton.setIconHovered(i)}}function I(t){var e=this;T(e);this.$().addClass("sapUiIpeFocus")}function U(t){var e=this.getContent();if(e.setText){var i=t.getParameter("newValue");e.setText(i);w.apply(this,arguments)}}function w(t){if(this._sOldText!=t.getParameter("newValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo")}else{this.$().removeClass("sapUiIpeUndo")}this.fireChange(t.getParameters())}function D(t){if(this._sOldText!=t.getParameter("liveValue")&&this.getUndoEnabled()){this.$().addClass("sapUiIpeUndo")}else{this.$().removeClass("sapUiIpeUndo")}this.fireLiveChange({liveValue:t.getParameter("liveValue")})}function B(){if(!this._bEditMode){this.invalidate()}else{switch(this.getValueState()){case f.Error:if(!this.$().hasClass("sapUiIpeErr")){this.$().addClass("sapUiIpeErr");this.$().removeClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeSucc")}break;case f.Success:if(!this.$().hasClass("sapUiIpeSucc")){this.$().addClass("sapUiIpeSucc");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeWarn")}break;case f.Warning:if(!this.$().hasClass("sapUiIpeWarn")){this.$().addClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeSucc")}break;default:this.$().removeClass("sapUiIpeWarn");this.$().removeClass("sapUiIpeErr");this.$().removeClass("sapUiIpeSucc");break}}}return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/InPlaceEditRenderer", ["sap/base/Log","sap/ui/core/library","sap/ui/core/ValueStateSupport"],function(e,t,a){"use strict";var i=t.ValueState;var o={};o.render=function(t,o){var s=o.getContent();var d;if(s){if(s.getWidth){d=s.getWidth()}if(s.getVisible&&!s.getVisible()){e.warning("Content is not visivle - nothing is rendered",this);return}}else{e.warning("No content provided - nothing is rendered",this);return}t.write("<div");t.writeControlData(o);t.addClass("sapUiIpe");if(!o.getEditable()){t.addClass("sapUiIpeRo")}else if(!o._bEditMode){t.writeAttribute("tabindex","-1");if(!o._sOldTextAvailable){if(s.getMetadata().getName()=="sap.ui.commons.ComboBox"||s.getMetadata().getName()=="sap.ui.commons.DropdownBox"){t.addClass("sapUiIpeCombo")}}if(s.getMetadata().getName()=="sap.ui.commons.Link"){t.addClass("sapUiIpeLink")}}else{t.addClass("sapUiIpeEdit")}if(d){t.addStyle("width",d)}if(o.getUndoEnabled()&&o._sOldTextAvailable&&(!o._bEditMode||o._bEditMode&&o._oEditControl.getValue()!=o._sOldText)){t.addClass("sapUiIpeUndo")}switch(o.getValueState()){case i.Error:t.addClass("sapUiIpeErr");break;case i.Success:t.addClass("sapUiIpeSucc");break;case i.Warning:t.addClass("sapUiIpeWarn");break;default:break}var n=a.enrichTooltip(o,o.getTooltip_AsString());if(n){t.writeAttributeEscaped("title",n)}t.writeClasses();t.writeStyles();t.write(">");if(o._sOldTextAvailable||s.getMetadata().getName()=="sap.ui.commons.Link"){t.write("<div");t.addClass("sapUiIpeCont");if(s.getMetadata().getName()=="sap.ui.commons.ComboBox"||s.getMetadata().getName()=="sap.ui.commons.DropdownBox"){t.addClass("sapUiIpeCombo")}t.writeClasses();t.write(">")}if(o._bEditMode){this.renderEditContent(t,o)}else{this.renderDisplayContent(t,o)}if(o._sOldTextAvailable||s.getMetadata().getName()=="sap.ui.commons.Link"){t.write("</div>");if(o.getUndoEnabled()&&o._sOldTextAvailable){t.renderControl(o._oUndoButton)}}t.write("</div>")};o.renderDisplayContent=function(e,t){if(t._oDisplayControl){e.renderControl(t._oDisplayControl);if(t.getEditable()&&t._oDisplayControl.getMetadata().getName()=="sap.ui.commons.Link"){e.renderControl(t._oEditButton)}}};o.renderEditContent=function(e,t){if(t._oEditControl){e.renderControl(t._oEditControl)}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Label", ["./library","sap/ui/core/Control","sap/ui/core/LabelEnablement","./LabelRenderer","sap/ui/core/library"],function(e,t,o,i,r){"use strict";var n=r.TextAlign;var a=r.TextDirection;var p=e.LabelDesign;var l=t.extend("sap.ui.commons.Label",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.Label"],library:"sap.ui.commons",deprecated:true,properties:{design:{type:"sap.ui.commons.LabelDesign",group:"Appearance",defaultValue:p.Standard},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},text:{type:"string",group:"Misc",defaultValue:""},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:n.Begin},required:{type:"boolean",group:"Appearance",defaultValue:false},requiredAtBegin:{type:"boolean",group:"Misc",defaultValue:null}},associations:{labelFor:{type:"sap.ui.core.Control",multiple:false}}}});l.prototype.onAfterRendering=function(){var e=this._getLabeledControl();if(e){if(this.getTooltip_AsString()==""||!(this.getTooltip()instanceof sap.ui.core.TooltipBase)){if(e.getTooltip()instanceof sap.ui.core.TooltipBase){this.oForTooltip=e.getTooltip();this.addDelegate(this.oForTooltip)}}this._oFor=e}};l.prototype.onBeforeRendering=function(){if(this.oForTooltip){this.removeDelegate(this.oForTooltip);this.oForTooltip=null}if(this._oFor){this._oFor=undefined}};l.prototype.exit=function(){if(this.oForTooltip){this.removeDelegate(this.oForTooltip);this.oForTooltip=null}if(this._oFor){this._oFor=undefined}};l.prototype.setReqiuredAtBegin=function(e){return this.setRequiredAtBegin(e)};l.prototype.getReqiuredAtBegin=function(){return this.getRequiredAtBegin()};l.prototype._getLabeledControl=function(){var e=this.getLabelForRendering();if(!e){return null}return sap.ui.getCore().byId(e)};l.prototype.getAccessibilityInfo=function(){return{description:this.getText()}};o.enrich(l.prototype);return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/LabelRenderer", ["sap/ui/core/Renderer","sap/ui/core/LabelEnablement","sap/ui/commons/library","sap/ui/core/library"],function(e,t,i,a){"use strict";var r=a.TextDirection;var l=i.LabelDesign;var s={};s.render=function(e,i){e.write("<label");e.writeControlData(i);t.writeLabelForAttribute(e,i);var a=i._getLabeledControl();var r=i.getTooltip_AsString();if((!r||r=="")&&a&&a.getTooltip_AsString()&&a.getTooltip_AsString()!=""){r=a.getTooltip_AsString()}if(i.isRequired()){e.addClass("sapUiLblReq");if(i.getRequiredAtBegin()){e.addClass("sapUiLblReqBeg")}else{e.addClass("sapUiLblReqEnd")}}if(r){e.writeAttributeEscaped("title",r)}e.addClass("sapUiLbl");if(i.getDesign()==l.Bold){e.addClass("sapUiLblEmph")}var n=i.getTextDirection();if(n){e.addStyle("direction",n.toLowerCase())}var g=s.getTextAlign(i.getTextAlign(),n);if(g){e.addStyle("text-align",g)}var o=i.getWidth();if(o){e.addStyle("width",o)}if(!i.isWrapping()){e.addClass("sapUiLblNowrap")}e.writeStyles();e.writeClasses();e.write(">");if(i.getIcon()){this.writeImgHtml(e,i)}if(i.getText()){e.writeEscaped(i.getText())}e.write("</label>")};s.writeImgHtml=function(e,t){var i=t.getIcon();var a=e.getConfiguration();var l=[];var s={title:null};l.push("sapUiLblIco");if(t.getTextDirection()==r.RTL&&!a.getRTL()||t.getTextDirection()==r.LTR&&a.getRTL()){l.push("sapUiLblIcoR")}else{l.push("sapUiLblIcoL")}e.writeIcon(i,l,s)};s.getTextAlign=e.getTextAlign;return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Link", ["./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/LabelEnablement","./LinkRenderer"],function(e,t,a,r,i){"use strict";var o=t.extend("sap.ui.commons.Link",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.commons.FormattedTextViewControl","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Appearance",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},helpId:{type:"string",group:"Behavior",defaultValue:""},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},target:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{allowPreventDefault:true}}}});a.call(o.prototype);o.prototype.onBeforeRendering=function(){this.removeAssociation("ariaLabelledBy",this.getId(),true);if(this.getAriaLabelledBy().length>0||r.getReferencingLabels(this).length>0){this.addAssociation("ariaLabelledBy",this.getId(),true)}};o.prototype.onsapspace=function(e){o.prototype.onclick.apply(this,arguments)};o.prototype.onclick=function(e){if(this.getEnabled()){if(!this.firePress()||!this.getHref()){e.preventDefault()}}else{e.preventDefault()}};o.prototype.onsapenter=function(e){e.stopPropagation()};o.prototype.getAccessibilityInfo=function(){return{role:"link",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_LINK"),description:this.getText()||this.getHref()||"",focusable:this.getEnabled(),enabled:this.getEnabled()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/LinkRenderer", [],function(){"use strict";var t={};t.render=function(t,e){t.write("<a");t.writeControlData(e);t.writeAccessibilityState(e);if(!e.getEnabled()){t.addClass("sapUiLnkDsbl");t.writeAttribute("disabled","true")}else{t.addClass("sapUiLnk")}t.writeClasses();if(e.getTooltip_AsString()){t.writeAttributeEscaped("title",e.getTooltip_AsString())}if(e.getHref()){t.writeAttributeEscaped("href",e.getHref())}else{t.writeAttribute("href","#")}if(e.getTarget()){t.writeAttributeEscaped("target",e.getTarget())}if(!e.getEnabled()){t.writeAttribute("tabindex","-1")}else{t.writeAttribute("tabindex","0")}if(e.getWidth()){t.addStyle("width",e.getWidth())}t.writeStyles();t.write(">");if(e.getText()){t.writeEscaped(e.getText())}t.write("</a>")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ListBox", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./ListBoxRenderer","sap/ui/core/library","sap/ui/Device"],function(jQuery,e,t,i,s,n,a){"use strict";var o=n.TextAlign;var r=t.extend("sap.ui.commons.ListBox",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},allowMultiSelect:{type:"boolean",group:"Behavior",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},scrollTop:{type:"int",group:"Behavior",defaultValue:-1},displayIcons:{type:"boolean",group:"Behavior",defaultValue:false},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},valueTextAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:o.Begin},secondaryValueTextAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:o.Begin},minWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},visibleItems:{type:"int",group:"Dimension",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{id:{type:"string"},selectedIndex:{type:"int"},selectedItem:{type:"sap.ui.core.Item"},selectedIndices:{type:"int[]"}}}}}});r.prototype.init=function(){this.allowTextSelection(false);if(!this._bHeightInItems){this._bHeightInItems=false;this._iVisibleItems=-1}this._sTotalHeight=null;if(r._fItemHeight===undefined){r._fItemHeight=-1}if(r._iBordersAndStuff===undefined){r._iBordersAndStuff=-1}this._aSelectionMap=[];this._iLastDirectlySelectedIndex=-1;this._aActiveItems=null};r.prototype.onThemeChanged=function(){this._sTotalHeight=null;if(!this._bHeightInItems){this._iVisibleItems=-1}this._skipStoreScrollTop=true;if(this.getDomRef()){this.invalidate()}};r.prototype.onBeforeRendering=function(){if(this._skipStoreScrollTop){delete this._skipStoreScrollTop;return}this.getScrollTop()};r.prototype.onAfterRendering=function(){var e=this.getDomRef();if(r._fItemHeight<=0){var t=sap.ui.getCore().getStaticAreaRef();var s=document.createElement("div");s.id="sap-ui-commons-ListBox-sizeDummy";s.innerHTML='<div class="sapUiLbx sapUiLbxFlexWidth sapUiLbxStd"><ul><li class="sapUiLbxI"><span class="sapUiLbxITxt">&nbsp;</span></li></ul></div>';if(a.browser.safari){t.insertBefore(s,t.firstChild)}else{t.appendChild(s)}var n=s.firstChild.firstChild.firstChild;r._fItemHeight=n.offsetHeight;t.removeChild(s)}if(r._iBordersAndStuff==-1){var o=jQuery(this.getDomRef());var l=o.outerHeight();var h=o.height();r._iBordersAndStuff=l-h}if(this._bHeightInItems){if(this._sTotalHeight==null){this._calcTotalHeight();e.style.height=this._sTotalHeight}}if(this._iVisibleItems==-1){this._updatePageSize()}var d=this.getFocusDomRef(),c=d.childNodes,p=[],f=this.getItems();this._aActiveItems=[];var g=this._aActiveItems;for(var u=0;u<c.length;u++){if(!(f[u]instanceof sap.ui.core.SeparatorItem)){g[p.length]=u;p.push(c[u])}}if(!this.oItemNavigation){var I=!this.getEnabled()||!this.getEditable();this.oItemNavigation=new i(null,null,I);this.oItemNavigation.attachEvent(i.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(d);this.oItemNavigation.setItemDomRefs(p);this.oItemNavigation.setCycling(false);this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(this.getSelectedIndex()));this.oItemNavigation.setPageSize(this._iVisibleItems);if(this.oScrollToIndexRequest){this.scrollToIndex(this.oScrollToIndexRequest.iIndex,this.oScrollToIndexRequest.bLazy)}else{var m=this.getProperty("scrollTop");if(m>-1){e.scrollTop=m}}var v=this;window.setTimeout(function(){if(v.oScrollToIndexRequest){v.scrollToIndex(v.oScrollToIndexRequest.iIndex,v.oScrollToIndexRequest.bLazy);v.oScrollToIndexRequest=null}else{var t=v.getProperty("scrollTop");if(t>-1){e.scrollTop=t}}},0)};r.prototype._getNavigationIndexForRealIndex=function(e){var t=this.getItems();var i=e;for(var s=0;s<e;s++){if(t[s]instanceof sap.ui.core.SeparatorItem){i--}}return i};r.prototype._updatePageSize=function(){var e=this.getDomRef();if(e){if(r._fItemHeight>0){this._iVisibleItems=Math.floor(e.clientHeight/r._fItemHeight)}}};r.prototype.scrollToIndex=function(e,t){var i=this.getDomRef();if(i){var s=this.$("list").children("li[data-sap-ui-lbx-index="+e+"]");s=s.get(0);if(s){var n=s.offsetTop;if(!t){this.setScrollTop(n)}else{var a=i.scrollTop;var o=jQuery(i).height();if(a>=n){this.setScrollTop(n)}else if(n+r._fItemHeight>a+o){this.setScrollTop(Math.ceil(n+r._fItemHeight-o))}}}this.getScrollTop()}else{this.oScrollToIndexRequest={iIndex:e,bLazy:t}}return this};r.prototype.getVisibleItems=function(){return this._iVisibleItems};r.prototype.setVisibleItems=function(e){this.setProperty("visibleItems",e,true);this._iVisibleItems=e;if(e<0){this._bHeightInItems=false}else{this._bHeightInItems=true}this._sTotalHeight=null;var t=this.getDomRef();if(t){if(this._bHeightInItems){var i=t.firstChild?t.firstChild.firstChild:null;if(i||r._fItemHeight>0&&r._iBordersAndStuff>0){t.style.height=this._calcTotalHeight()}else{this.invalidate()}}else{t.style.height=this.getHeight();this._updatePageSize();if(this.oItemNavigation){this.oItemNavigation.setPageSize(this._iVisibleItems)}}}return this};r.prototype._calcTotalHeight=function(){var e=this._iVisibleItems*r._fItemHeight;this._sTotalHeight=e+r._iBordersAndStuff+"px";return this._sTotalHeight};r.prototype.setHeight=function(e){this.validateProperty("height",e);if(this.getHeight()===e){return this}this._bHeightInItems=false;this._iVisibleItems=-1;var t=this.getDomRef();if(t){t.style.height=e;this._updatePageSize();if(this.oItemNavigation){this.oItemNavigation.setPageSize(this._iVisibleItems)}}return this.setProperty("height",e,true)};r.prototype.setWidth=function(e){var t=this.getDomRef();if(t){t.style.width=e}this.setProperty("width",e,true);return this};r.prototype.setScrollTop=function(e){e=Math.round(e);var t=this.getDomRef();this.oScrollToIndexRequest=null;if(t){t.scrollTop=e}this.setProperty("scrollTop",e,true);return this};r.prototype.getScrollTop=function(){var e=this.getDomRef();if(e){var t=Math.round(e.scrollTop);this.setProperty("scrollTop",t,true);return t}else{return this.getProperty("scrollTop")}};r.prototype.onmousedown=function(e){if(a.browser.webkit&&e.target&&e.target.id===this.getId()){var t=document.activeElement?document.activeElement.id:this.getId();var i=this;setTimeout(function(){var e=i.getDomRef().scrollTop;var s=t?document.getElementById(t):null;if(s){s.focus()}i.getDomRef().scrollTop=e},0)}};r.prototype.onclick=function(e){this._handleUserActivation(e)};r.prototype.ontouchmove=function(e){e.setMarked()};r.prototype.onsapspace=function(e){this._handleUserActivation(e)};r.prototype.onsapspacemodifiers=r.prototype.onsapspace;r.prototype.onsapenter=r.prototype.onsapspace;r.prototype.onsapentermodifiers=r.prototype.onsapspace;r.prototype._handleUserActivation=function(e){if(!this.getEnabled()||!this.getEditable()){return}var t=e.target;if(t.id===""||t.id&&t.id.endsWith("-txt")){t=t.parentNode;if(t.id===""){t=t.parentNode}}var i=jQuery(t).attr("data-sap-ui-lbx-index");if(typeof i=="string"&&i.length>0){var s=parseInt(i);var n=this.getItems();var a=n[s];if(n.length<=s){s=n.length-1}if(s>=0&&s<n.length){if(a.getEnabled()&&!(a instanceof sap.ui.core.SeparatorItem)){if(e.ctrlKey||e.metaKey){this._handleUserActivationCtrl(s,a)}else if(e.shiftKey){this.setSelectedIndices(this._getUserSelectionRange(s));this.fireSelect({id:this.getId(),selectedIndex:s,selectedIndices:this.getSelectedIndices(),selectedItem:a,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()});this._iLastDirectlySelectedIndex=s}else{this._handleUserActivationPlain(s,a)}}}e.preventDefault();e.stopPropagation()}};r.prototype._handleUserActivationPlain=function(e,t){this._iLastDirectlySelectedIndex=e;this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(e));if(this.getSelectedIndex()!=e||this.getSelectedIndices().length>1){this.setSelectedIndex(e);this.fireSelect({id:this.getId(),selectedIndex:e,selectedIndices:this.getSelectedIndices(),selectedItem:t,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()})}};r.prototype._handleUserActivationCtrl=function(e,t){this._iLastDirectlySelectedIndex=e;this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(e));if(this.isIndexSelected(e)){this.removeSelectedIndex(e)}else{this.addSelectedIndex(e)}this.fireSelect({id:this.getId(),selectedIndex:e,selectedIndices:this.getSelectedIndices(),selectedItem:t,sId:this.getId(),aSelectedIndices:this.getSelectedIndices()})};r.prototype._getUserSelectionRange=function(e){if(this._iLastDirectlySelectedIndex==-1){return[]}var t=this.getItems();var i=[];var s;if(this._iLastDirectlySelectedIndex<=e){for(s=this._iLastDirectlySelectedIndex;s<=e;s++){if(s>-1&&(t[s].getEnabled()&&!(t[s]instanceof sap.ui.core.SeparatorItem))){i.push(s)}}}else{for(s=e;s<=this._iLastDirectlySelectedIndex;s++){if(s>-1&&(t[s].getEnabled()&&!(t[s]instanceof sap.ui.core.SeparatorItem))){i.push(s)}}}return i};r.prototype.getSelectedIndex=function(){for(var e=0;e<this._aSelectionMap.length;e++){if(this._aSelectionMap[e]){return e}}return-1};r.prototype.setSelectedIndex=function(e){if(e<-1||e>this._aSelectionMap.length-1){return this}var t=this.getItems();if(e>-1&&(!t[e].getEnabled()||t[e]instanceof sap.ui.core.SeparatorItem)){return this}for(var i=0;i<this._aSelectionMap.length;i++){this._aSelectionMap[i]=false}this._aSelectionMap[e]=true;if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(this._getNavigationIndexForRealIndex(e))}this.getRenderer().handleSelectionChanged(this);return this};r.prototype.addSelectedIndex=function(e){if(!this.getAllowMultiSelect()){this.setSelectedIndex(e)}if(e<-1||e>this._aSelectionMap.length-1){return this}var t=this.getItems();if(e>-1&&(!t[e].getEnabled()||t[e]instanceof sap.ui.core.SeparatorItem)){return this}if(this._aSelectionMap[e]){return this}this._aSelectionMap[e]=true;this.getRenderer().handleSelectionChanged(this);return this};r.prototype.removeSelectedIndex=function(e){if(e<0||e>this._aSelectionMap.length-1){return this}if(!this._aSelectionMap[e]){return this}this._aSelectionMap[e]=false;this.getRenderer().handleSelectionChanged(this);return this};r.prototype.clearSelection=function(){for(var e=0;e<this._aSelectionMap.length;e++){if(this._aSelectionMap[e]){this._aSelectionMap[e]=false}}this._iLastDirectlySelectedIndex=-1;if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(-1)}this.getRenderer().handleSelectionChanged(this);return this};r.prototype.getSelectedIndices=function(){var e=[];for(var t=0;t<this._aSelectionMap.length;t++){if(this._aSelectionMap[t]){e.push(t)}}return e};r.prototype.setSelectedIndices=function(e){var t=[];var i=this.getItems();var s;for(s=0;s<e.length;s++){if(e[s]>-1&&e[s]<this._aSelectionMap.length){if(i[e[s]].getEnabled()&&!(i[e[s]]instanceof sap.ui.core.SeparatorItem)){t.push(e[s])}}}if(t.length>0){if(!this.getAllowMultiSelect()){t=[t[0]]}}for(s=0;s<this._aSelectionMap.length;s++){this._aSelectionMap[s]=false}for(s=0;s<t.length;s++){this._aSelectionMap[t[s]]=true}this.getRenderer().handleSelectionChanged(this);return this};r.prototype.addSelectedIndices=function(e){var t=[];var i=this.getItems();var s;for(s=0;s<e.length;s++){if(e[s]>-1&&e[s]<this._aSelectionMap.length){if(i[e[s]].getEnabled()&&!(i[e[s]]instanceof sap.ui.core.SeparatorItem)){t.push(e[s])}}}if(t.length>0){if(!this.getAllowMultiSelect()){t=[t[0]]}for(s=0;s<t.length;s++){this._aSelectionMap[t[s]]=true}this.getRenderer().handleSelectionChanged(this)}return this};r.prototype.isIndexSelected=function(e){if(e<-1||e>this._aSelectionMap.length-1){return false}return this._aSelectionMap[e]};r.prototype.setSelectedKeys=function(e){var t=this.getItems();var i={};for(var s=0;s<e.length;s++){i[e[s]]=true}var n=[];for(var a=0;a<t.length;a++){if(i[t[a].getKey()]){n.push(a)}}return this.setSelectedIndices(n)};r.prototype.getSelectedKeys=function(){var e=this.getItems();var t=[];for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){t.push(e[i].getKey())}}return t};r.prototype.getSelectedItem=function(){var e=this.getSelectedIndex();if(e<0||e>=this._aSelectionMap.length){return null}return this.getItems()[e]};r.prototype.getSelectedItems=function(){var e=this.getItems();var t=[];for(var i=0;i<this._aSelectionMap.length;i++){if(this._aSelectionMap[i]){t.push(e[i])}}return t};r.prototype.setAllowMultiSelect=function(e){this.setProperty("allowMultiSelect",e);var t=false;var i=false;if(!e&&this._aSelectionMap){for(var s=0;s<this._aSelectionMap.length;s++){if(this._aSelectionMap[s]){if(!t){t=true}else{this._aSelectionMap[s]=false;i=true}}}}if(i){this.getRenderer().handleSelectionChanged(this)}return this};r.prototype._handleAfterFocus=function(e){var t=e.getParameter("index");t=t!==undefined&&t>=0?this._aActiveItems[t]:0;this.getRenderer().handleARIAActivedescendant(this,t)};r.prototype.setItems=function(e,t,i){this._bNoItemsChangeEvent=true;if(t){this.destroyItems()}else{this.removeAllItems()}for(var s=0,n=e.length;s<n;s++){this.addItem(e[s])}this._bNoItemsChangeEvent=undefined;if(!i){this.fireEvent("itemsChanged",{event:"setItems",items:e})}return this};r.prototype.addItem=function(e){this._bNoItemInvalidateEvent=true;this.addAggregation("items",e);this._bNoItemInvalidateEvent=false;if(!this._aSelectionMap){this._aSelectionMap=[]}this._aSelectionMap.push(false);if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"addItem",item:e})}e.attachEvent("_change",this._handleItemChanged,this);return this};r.prototype.insertItem=function(e,t){if(t<0||t>this._aSelectionMap.length){return this}this._bNoItemInvalidateEvent=true;this.insertAggregation("items",e,t);this._bNoItemInvalidateEvent=false;this._aSelectionMap.splice(t,0,false);this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"insertItems",item:e,index:t})}e.attachEvent("_change",this._handleItemChanged,this);return this};r.prototype.removeItem=function(e){var t=e;if(typeof e=="string"){e=sap.ui.getCore().byId(e)}if(typeof e=="object"){t=this.indexOfItem(e)}if(t<0||t>this._aSelectionMap.length-1){if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeItem",item:e})}return undefined}this._bNoItemInvalidateEvent=true;var i=this.removeAggregation("items",t);this._bNoItemInvalidateEvent=false;this._aSelectionMap.splice(t,1);this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeItem",item:i})}i.detachEvent("_change",this._handleItemChanged,this);return i};r.prototype.removeAllItems=function(){this._bNoItemInvalidateEvent=true;var e=this.removeAllAggregation("items");this._bNoItemInvalidateEvent=false;this._aSelectionMap=[];this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"removeAllItems"})}for(var t=0;t<e.length;t++){e[t].detachEvent("_change",this._handleItemChanged,this)}return e};r.prototype.destroyItems=function(){var e=this.getItems();for(var t=0;t<e.length;t++){e[t].detachEvent("_change",this._handleItemChanged,this)}this._bNoItemInvalidateEvent=true;var i=this.destroyAggregation("items");this._bNoItemInvalidateEvent=false;this._aSelectionMap=[];this.invalidate();if(!this._bNoItemsChangeEvent){this.fireEvent("itemsChanged",{event:"destroyItems"})}return i};r.prototype.updateItems=function(){this._bNoItemsChangeEvent=true;this.updateAggregation("items");this._bNoItemInvalidateEvent=true;if(!this._bItemsChangedAfterUpdate){this._bItemsChangedAfterUpdate=setTimeout(function(){this._itemsChangedAfterUpdate()}.bind(this),0)}};r.prototype._itemsChangedAfterUpdate=function(){this._bNoItemsChangeEvent=undefined;this._bItemsChangedAfterUpdate=undefined;this._bNoItemInvalidateEvent=undefined;this.fireEvent("itemsChanged",{event:"updateItems"})};r.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}if(this._bItemsChangedAfterUpdate){clearTimeout(this._bItemsChangedAfterUpdate);this._bItemsChangedAfterUpdate=undefined;this._bNoItemsChangeEvent=undefined;this._bNoItemInvalidateEvent=undefined}};r.prototype.getFocusDomRef=function(){return this.getDomRef("list")};r.prototype.getIdForLabel=function(){return this.getId()+"-list"};r.prototype._handleItemChanged=function(e){if(!this._bNoItemInvalidateEvent){this.fireEvent("itemInvalidated",{item:e.oSource})}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ListBoxRenderer", ["sap/ui/thirdparty/jquery","sap/base/security/encodeXML","sap/ui/core/Renderer","sap/ui/core/IconPool"],function(jQuery,e,t,i){"use strict";var a={};a.render=function(e,t){if(a.borderWidths===undefined){a.borderWidths=0}e.addClass("sapUiLbx");var i=true;if(!t.getEditable()){e.addClass("sapUiLbxRo");i=false}if(!t.getEnabled()){e.addClass("sapUiLbxDis");i=false}if(i){e.addClass("sapUiLbxStd")}e.write("<div");e.writeControlData(t);e.writeAttribute("tabindex","-1");var s=t.getWidth();if(s){e.addStyle("width",s);var r=t.getDisplaySecondaryValues();var l=t.getDisplayIcons();if(!r&&!l){e.addClass("sapUiLbxFixed")}}if(!s||s=="auto"||s=="inherit"){e.addClass("sapUiLbxFlexWidth")}e.writeClasses();var d=t.getMinWidth();var n=t.getMaxWidth();if(d){e.addStyle("min-width",d)}if(n){e.addStyle("max-width",n)}if(t._bHeightInItems){if(t._sTotalHeight!=null){e.addStyle("height",t._sTotalHeight)}}else{var o=t.getHeight();if(o){e.addStyle("height",o)}}e.writeStyles();var g=t.getTooltip_AsString();if(g){e.writeAttributeEscaped("title",g)}e.write(">");this.renderItemList(t,e);e.write("</div>")};a.renderItemList=function(t,s){s.write("<ul id='"+t.getId()+"-list'");s.writeAttribute("tabindex",this.getTabIndex(t));s.writeAccessibilityState(t,{role:"listbox",multiselectable:t.getAllowMultiSelect()});s.write(">");var r=t.getItems(),l=0,d=0;var n;for(n=0;n<r.length;n++){if(!(r[n]instanceof sap.ui.core.SeparatorItem)){d++}}var o=t.getDisplaySecondaryValues();for(n=0;n<r.length;n++){var g=r[n];if(g instanceof sap.ui.core.SeparatorItem){s.write("<div id='",g.getId(),"' class='sapUiLbxSep' role='separator'><hr>");if(t.getDisplayIcons()){s.write("<hr>")}if(o){s.write("<hr>")}s.write("</div>")}else{s.write("<li");s.writeElementData(g);s.writeAttribute("data-sap-ui-lbx-index",n);s.addClass("sapUiLbxI");if(!g.getEnabled()){s.addClass("sapUiLbxIDis")}s.writeAttribute("tabindex","-1");if(t.isIndexSelected(n)){s.addClass("sapUiLbxISel")}s.writeClasses();var c=g.getText();var p=g.getAdditionalText?g.getAdditionalText():"";if(g.getTooltip_AsString()){s.writeAttributeEscaped("title",g.getTooltip_AsString())}else{s.writeAttributeEscaped("title",c+(o&&p?"  --  "+p:""))}s.writeAccessibilityState(g,{role:"option",selected:n===t.getSelectedIndex(),setsize:d,posinset:l+1});s.write(">");if(t.getDisplayIcons()){var f;if(g.getIcon){f=g.getIcon()}s.write("<span");if(i.isIconURI(f)){s.addClass("sapUiLbxIIco");s.addClass("sapUiLbxIIcoFont");var w=i.getIconInfo(f);s.addStyle("font-family","'"+e(w.fontFamily)+"'");if(w&&!w.skipMirroring){s.addClass("sapUiIconMirrorInRTL")}s.writeClasses();s.writeStyles();s.write(">");s.writeEscaped(w.content)}else{s.write(" class='sapUiLbxIIco'><img src='");if(f){s.writeEscaped(f)}else{s.write(sap.ui.resource("sap.ui.commons","img/1x1.gif"))}s.write("'>")}s.write("</span>")}s.write("<span class='sapUiLbxITxt");s.write("'");s.writeAttribute("id",g.getId()+"-txt");var u=a.getTextAlign(t.getValueTextAlign(),null);if(u){s.write("style='text-align:"+u+"'")}s.write(">");if(c===""||c===null){s.write("&nbsp;")}else{s.writeEscaped(c)}if(o){s.write("</span><span class='sapUiLbxISec");s.write("'");var x=a.getTextAlign(t.getSecondaryValueTextAlign(),null);if(x){s.write("style='text-align:"+x+"'")}s.write(">");s.writeEscaped(p)}s.write("</span></li>");l++}}s.write("</ul>")};a.fixWidth=function(e){if(a.borderWidths>0){if(/px$/i.test(e)){var t=parseInt(e.substr(0,e.length-2));var i=t-a.borderWidths;if(i>=0){return i+"px"}}}return e};a.getTabIndex=function(e){if(e.getEnabled()&&e.getEditable()){return 0}else{return-1}};a.handleSelectionChanged=function(e){if(e.getDomRef()){var t=e.getItems();for(var i=0,a=t.length;i<a;i++){if(e.isIndexSelected(i)){t[i].$().addClass("sapUiLbxISel").attr("aria-selected","true")}else{t[i].$().removeClass("sapUiLbxISel").attr("aria-selected","false")}}}};a.handleARIAActivedescendant=function(e,t){var i=e.$("list");if(i.length>0){var a=i.children("li[data-sap-ui-lbx-index="+t+"]");i.attr("aria-activedescendant",a.attr("id"))}};a.getTextAlign=t.getTextAlign;return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Menu", ["./MenuItemBase","./library","sap/ui/unified/Menu","./MenuRenderer"],function(e,r,u,a){"use strict";var n=u.extend("sap.ui.commons.Menu",{metadata:{deprecated:true,library:"sap.ui.commons"}});n.prototype.bCozySupported=false;return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuBar", ["sap/ui/thirdparty/jquery","./Menu","./MenuItem","./MenuItemBase","./library","sap/ui/core/Control","./MenuBarRenderer","sap/ui/core/ResizeHandler","sap/ui/core/Popup","sap/ui/events/checkMouseEnterOrLeave","sap/ui/events/KeyCodes","sap/ui/core/Configuration"],function(jQuery,e,t,r,i,n,s,o,u,a,l,f){"use strict";var p=u.Dock;var d=i.MenuBarDesign;var v=n.extend("sap.ui.commons.MenuBar",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},design:{type:"sap.ui.commons.MenuBarDesign",group:"Appearance",defaultValue:d.Standard}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItem",multiple:true,singularName:"item"}}}});var g=t.extend("sap.ui.commons._DelegatorMenuItem",{constructor:function(e){t.apply(this);this.oAlterEgoItm=e;this.bNoSubMenu=true;var r=this.oAlterEgoItm.getSubmenu();if(r){var i=this;r.getRootMenu=function(){return i.getParent()};this.bNoSubMenu=false}},exit:function(){if(!this.bNoSubMenu){this.oAlterEgoItm.getSubmenu().getRootMenu=e.prototype.getRootMenu}this.bNoSubMenu=true;this.oAlterEgoItm=null},getText:function(){return this.oAlterEgoItm.getText()},getIcon:function(){return this.oAlterEgoItm.getIcon()},getEnabled:function(){return this.oAlterEgoItm.getEnabled()},getVisible:function(){return this.oAlterEgoItm.getVisible()},getSubmenu:function(){return this.oAlterEgoItm.getSubmenu()}});v.prototype.init=function(){this.oOvrFlwMnu=null;this.sCurrentFocusedItemRefId=null;this.data("sap-ui-fastnavgroup","true",true)};v.prototype.exit=function(){if(this.oOvrFlwMnu){this.oOvrFlwMnu.destroy()}this.oOvrFlwMnu=null;if(this.sResizeListenerId){o.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};v.prototype.doBeforeRendering=function(){var e=this.getItems();for(var t=0;t<e.length;t++){var r=e[t].getSubmenu();if(r){r.setRootMenuTopStyle(this.getDesign()==d.Header)}}if(this.oOvrFlwMnu){this.oOvrFlwMnu.setRootMenuTopStyle(this.getDesign()==d.Header)}if(this.sResizeListenerId){o.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};v.prototype.onAfterRendering=function(){this.sResizeListenerId=o.register(this.getDomRef(),jQuery.proxy(this.onresize,this));this.onresize()};v.prototype.onresize=function(e){b(this)};v.prototype.onfocusin=function(e){var t=this.getId();var r=jQuery(e.target);var i=r.attr("id");if(!i||i==t||i==t+"-area"){var n=this.$("area").children();this.sCurrentFocusedItemRefId=n.length==0?null:jQuery(n.get(0)).attr("id")}else{this.sCurrentFocusedItemRefId=i}var s=this.sCurrentFocusedItemRefId?document.getElementById(this.sCurrentFocusedItemRefId):null;if(s){s.focus()}this.$().attr("tabindex","-1")};v.prototype.onfocusout=function(e){this.$().attr("tabindex","0")};v.prototype.onmousedown=function(e){var t=I(this,e);if(t==="ovrflw"){this._bOvrFlwMnuSkipOpen=this.oOvrFlwMnu&&this.oOvrFlwMnu.bOpen}else if(t){var r=t.getSubmenu();t._bSkipOpen=r&&r.bOpen}};v.prototype.onmouseout=function(e){var t=I(this,e);if(t==="ovrflw"){var r=m(this,e);if(this._bOvrFlwMnuSkipOpen&&a(e,r[0])){this._bOvrFlwMnuSkipOpen=false}}else if(t){var r=m(this,e);if(t._bSkipOpen&&a(e,r[0])){t._bSkipOpen=false}}};v.prototype.onclick=function(e){c(this,e,false)};v.prototype.onsapselect=function(e){c(this,e,true)};v.prototype.onsapdown=function(e){c(this,e,true)};v.prototype.onsapdownmodifiers=function(e){if(e.altKey){c(this,e,true)}};v.prototype.onsapprevious=function(e){if(e.keyCode!=l.ARROW_UP){y(this,e,"prev")}};v.prototype.onsapnext=function(e){if(e.keyCode!=l.ARROW_DOWN){y(this,e,"next")}};v.prototype.onsaphome=function(e){y(this,e,"first")};v.prototype.onsapend=function(e){y(this,e,"last")};var c=function(e,t,r){t.preventDefault();t.stopPropagation();if(e.getEnabled()){var i=I(e,t);if(i==="ovrflw"){var n=m(e,t);if(e.oOvrFlwMnu&&!e._bOvrFlwMnuSkipOpen){var s=p;e.oOvrFlwMnu.open(r,n.get(0),s.EndTop,s.EndBottom,n.get(0))}}else if(i){if(i.getEnabled()){var n=m(e,t);var o=i.getSubmenu();if(o&&!i._bSkipOpen){var s=p;o.open(r,n.get(0),s.BeginTop,s.BeginBottom,n.get(0))}else if(!o){i.fireSelect({item:i})}}}}e._bOvrFlwMnuSkipOpen=false;var u=e.getItems();for(var a=0;a<u.length;a++){u[a]._bSkipOpen=false}};var m=function(e,t){var r=jQuery(t.target);if(!r.attr("itemidx")){r=r.parent()}return r.attr("itemidx")?r:null};var I=function(e,t){var r=m(e,t);if(r){var i=r.attr("itemidx");if(i){if(i=="ovrflw"){return"ovrflw"}else{var n=parseInt(i);var s=e.getItems()[n];return s}}}return null};var h=function(e){var t=0;var r=e.$("area");var i=r.children();var n=f.getRTL();var s=n?1e5:0;i.each(function(r){if(r==0){return true}var i=this.offsetLeft;var o=n?i>=s:i<=s;if(o){t=r;return false}else if(jQuery(this).attr("id")==e.getId()+"-ovrflw"){t=r;return false}else{s=i;return true}});return t};var b=function(t){var r=h(t);var i=r;var n=t.$("area");var s=n.children();var o=t.$("ovrflw");var u=false;if(r<s.length-1){o.attr("style","display:block;");if(!t.oOvrFlwMnu){t.oOvrFlwMnu=new e(t.getId()+"-ovrflwmnu");t.oOvrFlwMnu.bUseTopStyle=t.getDesign()==d.Header;t.oOvrFlwMnu.attachItemSelect(function(t){var r=t.getParameter("item");if(!(r instanceof g)){var i=e.prototype.getRootMenu.apply(r.getParent());i.fireItemSelect({item:r})}else if(r.bNoSubMenu&&r instanceof g){r.oAlterEgoItm.fireSelect({item:r.oAlterEgoItm})}})}t.oOvrFlwMnu.destroyItems();var a=t.getItems();for(var l=0;l<a.length;l++){var p=a[l];if(r!=0){if(p.getVisible()){r--}if(r==0){t.sLastVisibleItemId=p.getId()}}else{t.oOvrFlwMnu.addItem(new g(p));if(p.getId()==t.sCurrentFocusedItemRefId){u=true}}}if(f.getAccessibility()){s.attr("aria-setsize",i+1);o.attr("aria-posinset",i+1)}}else{o.attr("style","display:none;");if(t.oOvrFlwMnu){t.oOvrFlwMnu.destroyItems()}t.sLastVisibleItemId=null;if(f.getAccessibility()){s.attr("aria-setsize",i);o.attr("aria-posinset",0)}}n.scrollTop(0);if(u){t.sCurrentFocusedItemRefId=t.sLastVisibleItemId;document.getElementById(t.sLastVisibleItemId).focus()}};var y=function(e,t,r){t.stopPropagation();t.preventDefault();if(!e.sCurrentFocusedItemRefId){return}var i=null;if(e.sLastVisibleItemId&&(e.sCurrentFocusedItemRefId==e.sLastVisibleItemId&&r=="next"||r=="last")){i=e.getId()+"-ovrflw"}else if(e.sLastVisibleItemId&&e.sCurrentFocusedItemRefId==e.getId()+"-ovrflw"&&r=="prev"){i=e.sLastVisibleItemId}else{var n=r+"All";var s=false;if(r=="first"){n="prevAll";s=true}else if(r=="last"){n="nextAll";s=true}var o=jQuery(document.getElementById(e.sCurrentFocusedItemRefId));var u=o[n](":visible");i=jQuery(u.get(s?u.length-1:0)).attr("id")}if(i){e.sCurrentFocusedItemRefId=i;document.getElementById(i).focus()}};return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuBarRenderer", ["sap/ui/commons/library","sap/ui/core/Configuration"],function(t,e){"use strict";var i=t.MenuBarDesign;var r={};r.render=function(t,e){e.doBeforeRendering();t.write("<div");t.writeControlData(e);t.addClass("sapUiMnuBar");if(e.getDesign()==i.Header){t.addClass("sapUiMnuBarHeader")}var a=!e.getEnabled();if(a){t.addClass("sapUiMnuBarDsbl")}t.addStyle("width",e.getWidth());t.writeStyles();t.writeClasses();t.writeAttribute("tabindex","0");var s=e.getTooltip_AsString();r.writeAria(t,"menubar",s,a);t.write("><ul");t.writeAttribute("id",e.getId()+"-area");t.writeAttribute("class","sapUiMnuBarArea");t.write(">");var n=0;var u=e.getItems();for(var d=0;d<u.length;d++){var l=u[d];if(l.getVisible()){n++;t.write("<li");t.writeElementData(l);t.addClass("sapUiMnuBarItm");var w=!l.getEnabled()||a;if(w){t.addClass("sapUiMnuBarItmDsbl")}t.writeClasses();t.writeAttribute("itemidx",""+d);var s=l.getTooltip_AsString();r.writeAria(t,"menuitem",s,w,n,!!l.getSubmenu());t.writeAttribute("tabindex","-1");t.write("><span>");t.writeEscaped(l.getText());t.write("</span></li>")}}t.write("<li");t.writeAttribute("id",e.getId()+"-ovrflw");t.writeAttribute("itemidx","ovrflw");t.writeAttribute("style","display:none;");t.writeAttribute("tabindex","-1");t.addClass("sapUiMnuBarItm");t.addClass("sapUiMnuBarOvrFlw");if(w){t.addClass("sapUiMnuBarItmDsbl")}t.writeClasses();var b=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var o;if(b){o=b.getText("MNUBAR_OVRFLW")}r.writeAria(t,"menuitem",o,false,0,true);t.write("><span></span></li></ul></div>")};r.writeAria=function(t,i,r,a,s,n){if(r){t.writeAttributeEscaped("title",r)}if(!e.getAccessibility()){return}t.writeAttribute("role",i);if(i=="menuitem"){if(n){t.writeAttribute("aria-haspopup",true)}t.writeAttribute("aria-posinset",s)}if(a){t.writeAttribute("aria-disabled",true)}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuButton", ["./Button","./Menu","./MenuItemBase","./library","./MenuButtonRenderer","sap/ui/core/Popup","sap/ui/events/checkMouseEnterOrLeave"],function(t,e,i,n,o,s,r){"use strict";var u=s.Dock;var a=t.extend("sap.ui.commons.MenuButton",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{dockButton:{type:"string",group:"Misc",defaultValue:null},dockMenu:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"menu",aggregations:{menu:{type:"sap.ui.unified.Menu",multiple:false}},events:{itemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});a.prototype.init=function(){this.addStyleClass("sapUiMenuButton");this.bWithKeyboard=false};a.prototype.onclick=function(t){if(this.getEnabled()&&!this._bSkipOpen){var e=this.getTooltip();if(e&&e instanceof sap.ui.core.TooltipBase){e._closeOrPreventOpen()}var i=this.getDockButton()?this.getDockButton():u.BeginBottom;var n=this.getDockMenu()?this.getDockMenu():u.BeginTop;this.getMenu().open(this.bWithKeyboard,this,n,i,this)}this.bWithKeyboard=false;this._bSkipOpen=false;t.preventDefault();t.stopPropagation()};a.prototype.onmousedown=function(t){this.handleMouseDown(t,false);this._bSkipOpen=this.getMenu()&&this.getMenu().bOpen};a.prototype.onmouseout=function(e){if(t.prototype.onmouseout){t.prototype.onmouseout.apply(this,arguments)}if(this._bSkipOpen&&r(e,this.getDomRef())){this._bSkipOpen=false}};a.prototype.onsapenter=function(t){this.bWithKeyboard=true};a.prototype.onsapspace=function(t){this.bWithKeyboard=true};a.prototype.onsapdownmodifiers=function(t){if(t.altKey){this.bWithKeyboard=true;this.onclick(t)}};a.prototype.clone=function(e,i){p(this);var n=t.prototype.clone.apply(this,arguments);p(this,this.getMenu());return n};a.prototype.setMenu=function(t){p(this,t);this.setAggregation("menu",t);return this};a.prototype.destroyMenu=function(){p(this,null);this.destroyAggregation("menu");return this};var p=function(t,e){var i=t.getMenu();if(i){i.detachItemSelect(t._fItemSelectHandler)}t._fItemSelectHandler=h.bind(t);if(e){e.attachItemSelect(t._fItemSelectHandler)}};var h=function(t){var e=t.getParameter("item");this.fireItemSelected({itemId:e.getId(),item:e});this.firePress({itemId:e.getId(),item:e})};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuButtonRenderer", ["./ButtonRenderer","sap/ui/core/Renderer","sap/ui/core/Configuration"],function(t,e,n){"use strict";var r=e.extend(t);r.renderButtonAttributes=function(t,e){if(n.getAccessibility()){t.writeAttribute("aria-haspopup","true")}};r.renderButtonContentAfter=function(t,e){t.write('<span class="sapUiMenuButtonIco"></span>')};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuItem", ["./MenuItemBase","./library","sap/ui/unified/MenuItem"],function(e,a,t){"use strict";var u=t.extend("sap.ui.commons.MenuItem",{metadata:{deprecated:true,library:"sap.ui.commons"}});return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuItemBase", ["sap/base/Log","sap/ui/core/Core"],function(e,i){"use strict";try{sap.ui.getCore().loadLibrary("sap.ui.unified")}catch(i){e.error("The controls/elements 'sap.ui.commons.Menu*' needs library 'sap.ui.unified'.");throw i}jQuery.sap.require("sap.ui.unified.MenuItemBase");return sap.ui.require("sap/ui/unified/MenuItemBase")},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuRenderer", ["sap/ui/core/Renderer","sap/ui/unified/MenuRenderer"],function(e,r){"use strict";var n=e.extend(r);return n},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MenuTextFieldItem", ["./MenuItemBase","./library","sap/ui/unified/MenuTextFieldItem"],function(e,t,i){"use strict";var a=i.extend("sap.ui.commons.MenuTextFieldItem",{metadata:{deprecated:true,library:"sap.ui.commons"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Message", ["sap/ui/thirdparty/jquery","./Dialog","./library","sap/ui/core/Control","./MessageRenderer","./Button","sap/ui/core/Configuration","sap/ui/dom/jquery/rect"],function(jQuery,t,e,s,i,o,n){"use strict";var a=s.extend("sap.ui.commons.Message",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{type:{type:"sap.ui.commons.MessageType",group:"Behavior",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},associatedElementId:{type:"string",group:"Data",defaultValue:null},design:{type:"string",group:"Misc",defaultValue:null}}}});a.prototype.init=function(){this.isRTL=n.getRTL();this.fnCallBack=null;this.oLink=null;this.oContainer=null;this.oDetails=null;this.oBtnOK=null};a.prototype.exit=function(){if(this.oLink){this.oLink.destroy();this.oLink=null}if(this.oDetails){this.oDetails.destroy();this.oDetails=null}if(this.oContainer){this.oContainer.destroy();this.oContainer=null}if(this.oBtnOK){this.oBtnOK.destroy();this.oBtnOK=null}};a.closeDetails=function(t){t.getSource().getParent().close()};a.prototype.closeDetails=function(){if(this.oContainer){this.oContainer.close()}};a.prototype.openDetails=function(){if(!this.oContainer){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=e.getText("MSGBAR_DETAILS_DIALOG_CLOSE");var i=e.getText("MSGBAR_DETAILS_DIALOG_TITLE");var n=this.fnCallBack(this.getId());this.oDetails=new a({type:this.getType(),text:n});this.oBtnOK=new o({text:s,press:a.closeDetails});this.oContainer=new t;this.oContainer.addContent(this.oDetails);this.oContainer.setTitle(i);this.oContainer.addButton(this.oBtnOK)}var r=this.oContainer.getId();var l=0;var f=jQuery(".sapUiDlg");for(var p=f.length-1;p>=0;p--){if(jQuery(f[p]).css("visibility")!="visible"){f.splice(p,1)}else if(f[p].id==r){f.splice(p,1)}else{l=Math.max(l,jQuery(f[p]).css("zIndex"))}}var u=this.oContainer.isOpen();this.oContainer.open();var h=this.oContainer.$();var c=h.rect();if(f.length==0){if(this.isRTL){c.left=Number(h.css("right").replace("px",""))}this.setLastOffsets(c);return}if(u){if(l>h.css("zIndex")){h.css("zIndex",l+1)}return}var d=this.getNextOffsets();h.css("top",d.top-a.TOP_INCR+"px");if(this.isRTL){h.css("right",d.left-a.LEFT_INCR+"px")}else{h.css("left",d.left-a.LEFT_INCR+"px")}var c=h.rect();var g=jQuery(window).scrollTop();var C=jQuery(window).scrollLeft();var L=-C;if(jQuery(window).height()+g<d.top+c.height){d.top=g;this.setLastOffsets(d)}if(this.isRTL){if(jQuery(window).width()+L<d.left+c.width){d.left=L;this.setLastOffsets(d)}h.animate({top:d.top+"px",right:d.left+"px"},200)}else{if(jQuery(window).width()+C<d.left+c.width){d.left=C;this.setLastOffsets(d)}h.animate({top:d.top+"px",left:d.left+"px"},200)}};a.TOP_INCR=20;a.LEFT_INCR=10;var r=null;a.setLastOffsets=function(t){r=t};a.prototype.setLastOffsets=function(t){a.setLastOffsets(t)};a.getNextOffsets=function(){r.top+=a.TOP_INCR;r.left+=a.LEFT_INCR;return r};a.prototype.getNextOffsets=function(){return a.getNextOffsets()};a.prototype.bindDetails=function(t){this.fnCallBack=t};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageBar", ["sap/ui/thirdparty/jquery","sap/base/Log","./library","sap/ui/core/Control","sap/ui/core/Popup","./MessageToast","./MessageList","./MessageBarRenderer","sap/ui/core/Configuration","sap/ui/dom/jquery/rect"],function(jQuery,t,s,e,i,o,r,a,n){"use strict";var h=s.MessageType;var l=e.extend("sap.ui.commons.MessageBar",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{anchorID:{type:"string",group:"Appearance",defaultValue:""},visible:{type:"boolean",group:"Behavior",defaultValue:true},maxToasted:{type:"int",group:"Misc",defaultValue:3},maxListed:{type:"int",group:"Misc",defaultValue:7},anchorSnapPoint:{type:"string",group:"Misc",defaultValue:"begin top"}}}});l.prototype.init=function(){this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.maxToastsReached=false;this.oPopup=new i(this,false,true,false);this.oList=null;var t=this.getId();this.oToast=new o(t+"__Toast",{anchorId:t+"__sums"});var s=this;this.oToast.attachNext(function(){s.checkForToast()});this.snapPoint=null;this.oHomePosition=null;this.oDropPosition=null;this.bToggleListBackAfterDrag=null};l.prototype.exit=function(){this.onmouseup();this.close();this.oPopup.destroy();this.oPopup=null;this.oToast.destroy();this.oToast=null;if(this.oList){this.oList.destroy();this.oList=null}};l.prototype.ondragstart=function(t){t.preventDefault();t.stopPropagation()};l.prototype.onmousedown=function(t){var s=t.target;var e=jQuery(s);if(e.css("cursor")!="move"){return}this.sDragMode="move";this.oMsgBarDragStartPosition=this.$().rect();this.oMsgBarDragStartPosition.right=Number(this.$().css("right").replace("px",""));if(!this.oHomePosition){this.oHomePosition=this.oMsgBarDragStartPosition}this.mouseDragStartPositionX=t.screenX;this.mouseDragStartPositionY=t.screenY;var i=jQuery(window.document);i.on("mousemove",jQuery.proxy(this.handleMove,this));if(window.parent){jQuery(window.parent.document).on("mousemove",jQuery.proxy(this.handleMove,this),true)}i.on("selectstart",jQuery.proxy(this.ondragstart,this),true)};l.prototype.handleMove=function(t){if(!this.sDragMode){return}if(this.bToggleListBackAfterDrag==null&&this.oList){this.bToggleListBackAfterDrag=this.oList.getVisible();if(this.bToggleListBackAfterDrag){this.toggleList()}}t=t||window.event;var s=this.oMsgBarDragStartPosition.top+t.screenY-this.mouseDragStartPositionY;var e=this.oMsgBarDragStartPosition.left+t.screenX-this.mouseDragStartPositionX;var i=this.oMsgBarDragStartPosition.right-t.screenX+this.mouseDragStartPositionX;this.oPopup._$().css("top",s);if(this.snapPoint.indexOf("right")!=-1){this.oPopup._$().css("right",i)}else{this.oPopup._$().css("left",e)}this.oDropPosition={top:s,left:e,right:i};t.cancelBubble=true;return false};l.prototype.onmouseup=function(t){if(!this.sDragMode){return}if(this.oDropPosition){this.addStyleClass("sapUiMsgBarMoved")}if(this.bToggleListBackAfterDrag){this.toggleList()}this.bToggleListBackAfterDrag=null;var s=jQuery(window.document);s.off("mousemove",jQuery.proxy(this.handleMove,this));if(window.parent){jQuery(window.parent.document).off("mousemove",jQuery.proxy(this.handleMove,this))}s.off("selectstart",jQuery.proxy(this.ondragstart,this));this.sDragMode=null;this.checkForToast()};l.prototype.onclick=function(s){var e=s.target;var i=jQuery(e);if(i.css("cursor")!="pointer"){return}if(i.hasClass("sapUiMsgBarToggle")){this.toggleList()}else if(i.hasClass("sapUiMsgBarHome")){this.backHome()}else{t.debug("Warning: MessageBar unsupported click on "+i.attr("className"))}};l.prototype.checkForToast=function(){if(this.maxToastsReached){return}if(this.aToasts==null||this.aToasts.length==0){return}var t=this.getMaxToasted();if(t==0){return}if(this.sDragMode){return}var s=null;var e="";if(this.aToasts.length>this.getMaxToasted()){this.aToasts=[];this.maxToastsReached=true;e=this.getId()+"__arrowImg"}else{if(!this.oToast.isIdle()){return}s=this.aToasts.splice(0,1)[0];e=this.getId()+"__"+s.getType()+"Img"}this.oToast.toast(s,e)};l.prototype.addToasts=function(t){for(var s=0,e=t.length;s<e;s++){var i=t[s];var o=false;for(var r=this.aToasts.length;r>=0;r--){if(i==this.aToasts[r]){o=true;break}}if(!o){this.aToasts.push(i)}}};l.prototype.deleteToast=function(t){if(!this.aToasts){return}for(var s=0,e=this.aToasts.length;s<e;s++){if(this.aToasts[s].getId()==t){this.aToasts.splice(s,1);return}}};l.prototype.deleteOneMessage=function(t){if(!t){return}for(var s=0,e=this.aErrors.length;s<e;s++){if(this.aErrors[s].getId()==t){this.aErrors[s].closeDetails();this.aErrors.splice(s,1);return}}for(var s=0,e=this.aWarnings.length;s<e;s++){if(this.aWarnings[s].getId()==t){this.aWarnings[s].closeDetails();this.aWarnings.splice(s,1);return}}for(var s=0,e=this.aSuccesses.length;s<e;s++){if(this.aSuccesses[s].getId()==t){this.aSuccesses[s].closeDetails();this.aSuccesses.splice(s,1);return}}};l.prototype.getSnapPoint=function(){if(!this.snapPoint){this.snapPoint=this.getAnchorSnapPoint();if(n.getRTL()){this.snapPoint=this.snapPoint.replace("begin","right").replace("end","left")}else{this.snapPoint=this.snapPoint.replace("begin","left").replace("end","right")}}return this.snapPoint};l.prototype.open=function(){var t=0;var s=this.getSnapPoint();var e=null;var i=this.getAnchorID();if(i){e=document.getElementById(i)}if(!e){e=document.body}this.oPopup.open(t,s,s,e,"0 0");if(this.oDropPosition){this.oPopup._$().css("top",this.oDropPosition.top);if(s.indexOf("right")!=-1){this.oPopup._$().css("right",this.oDropPosition.right)}else{this.oPopup._$().css("left",this.oDropPosition.left)}}if(this.hasStyleClass("sapUiMsgBarOpen")){this.oList.setVisible(true)}};l.prototype.close=function(){if(this.oList&&this.oList.getVisible()){this.oList.setVisible(false)}var t=0;this.oPopup.close(t);this.maxToastsReached=false};l.prototype.updateCountersAndVisibility=function(){if(!this.getProperty("visible")){return}var t=this.getId();var s=document.getElementById(t+"__ErrorCount");if(!s){this.open();s=document.getElementById(t+"__ErrorCount")}var e=this.aErrors.length;var i=s.innerHTML;var o="("+e+")";var r=null;var a=null;if(o!=i){s.innerHTML=o;if(o=="(0)"){r=jQuery(document.getElementById(t+"__ErrorImg"));a=jQuery(document.getElementById(t+"__ErrorCount"));r.addClass("sapUiMsgBarZeroCount");a.addClass("sapUiMsgBarZeroCount")}else if(i=="(0)"){r=jQuery(document.getElementById(t+"__ErrorImg"));a=jQuery(document.getElementById(t+"__ErrorCount"));r.removeClass("sapUiMsgBarZeroCount");a.removeClass("sapUiMsgBarZeroCount")}}s=document.getElementById(t+"__WarningCount");e=this.aWarnings.length;i=s.innerHTML;o="("+e+")";r=null;a=null;if(o!=i){s.innerHTML=o;if(o=="(0)"){r=jQuery(document.getElementById(t+"__WarningImg"));a=jQuery(document.getElementById(t+"__WarningCount"));r.addClass("sapUiMsgBarZeroCount");a.addClass("sapUiMsgBarZeroCount")}else if(i=="(0)"){r=jQuery(document.getElementById(t+"__WarningImg"));a=jQuery(document.getElementById(t+"__WarningCount"));r.removeClass("sapUiMsgBarZeroCount");a.removeClass("sapUiMsgBarZeroCount")}}s=document.getElementById(t+"__SuccessCount");e=this.aSuccesses.length;i=s.innerHTML;o="("+e+")";r=null;a=null;if(o!=i){s.innerHTML=o;if(o=="(0)"){r=jQuery(document.getElementById(t+"__SuccessImg"));a=jQuery(document.getElementById(t+"__SuccessCount"));r.addClass("sapUiMsgBarZeroCount");a.addClass("sapUiMsgBarZeroCount")}else if(i=="(0)"){r=jQuery(document.getElementById(t+"__SuccessImg"));a=jQuery(document.getElementById(t+"__SuccessCount"));r.removeClass("sapUiMsgBarZeroCount");a.removeClass("sapUiMsgBarZeroCount")}}if(this.aErrors.length==0&&this.aWarnings.length==0&&this.aSuccesses.length==0){this.close();return}else{this.open()}if(this.oList&&this.oList.getVisible()){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors))}this.checkForToast()};l.prototype.toggleList=function(){if(!this.oList){var t=this.getId()+"__List";this.oList=new r(t,{anchorId:this.getId(),maxListed:this.getMaxListed()})}var s=this.oList.getVisible();if(!s){this.oList.setMessages(this.aSuccesses.concat(this.aWarnings).concat(this.aErrors));this.addStyleClass("sapUiMsgBarOpen")}else{this.removeStyleClass("sapUiMsgBarOpen")}this.oList.setVisible(!s)};l.prototype.backHome=function(){var t=this.oPopup._$();if(this.oList&&this.oList.getVisible()){this.toggleList();var s=this;if(this.snapPoint.indexOf("right")!=-1){t.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200,function(){s.toggleList()})}else{t.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200,function(){s.toggleList()})}}else{if(this.snapPoint.indexOf("right")!=-1){t.animate({right:this.oHomePosition.right+"px",top:this.oHomePosition.top+"px"},200)}else{t.animate({left:this.oHomePosition.left+"px",top:this.oHomePosition.top+"px"},200)}}this.oDropPosition=null;this.removeStyleClass("sapUiMsgBarMoved")};l.prototype.addMessages=function(s){if(!s){return}for(var e=0,i=s.length;e<i;e++){this.deleteOneMessage(s[e].getId());switch(s[e].getType()){case h.Error:this.aErrors.push(s[e]);break;case h.Warning:this.aWarnings.push(s[e]);break;case h.Success:this.aSuccesses.push(s[e]);break;default:t.debug("ERROR: MessageBar supplied messageType="+s[e].getType())}}this.addToasts(s);this.updateCountersAndVisibility();return this};l.prototype.deleteMessages=function(t){if(!t){return}for(var s=0,e=t.length;s<e;s++){this.deleteOneMessage(t[s]);this.deleteToast(t[s])}this.updateCountersAndVisibility();return this};l.prototype.deleteAllMessages=function(){for(var t=this.aErrors.length-1;t>=0;t--){this.aErrors[t].closeDetails()}for(var t=this.aWarnings.length-1;t>=0;t--){this.aWarnings[t].closeDetails()}for(var t=this.aSuccesses.length-1;t>=0;t--){this.aSuccesses[t].closeDetails()}this.aErrors=[];this.aWarnings=[];this.aSuccesses=[];this.aToasts=[];this.updateCountersAndVisibility();return this};l.prototype.setVisible=function(t){this.setProperty("visible",t);if(t){this.updateCountersAndVisibility()}else{this.close()}return this};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageBarRenderer", ["sap/ui/core/Popup"],function(s){"use strict";var i={};i.render=function(s,i){var a=i.getId();s.write('<div draggable="true"');s.writeControlData(i);s.addClass("sapUiMsgBar");if(this.oDropPosition){s.addClass("sapUiMsgBarMoved")}s.writeClasses();s.write(">");s.write('<div id="'+a+'__sums" class="sapUiMsgBarSums">');s.write('<div id="'+a+'__arrowImg" class="sapUiMsgBarToggle"></div>');s.write('<div id="'+a+'__ErrorImg" class="sapUiMsgIcon sapUiMsgIconError sapUiMsgBarZeroCount"></div>');s.write('<span id="'+a+'__ErrorCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');s.write('<div id="'+a+'__WarningImg" class="sapUiMsgIcon sapUiMsgIconWarning sapUiMsgBarZeroCount"></div>');s.write('<span id="'+a+'__WarningCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');s.write('<div id="'+a+'__SuccessImg" class="sapUiMsgIcon sapUiMsgIconSuccess sapUiMsgBarZeroCount"></div>');s.write('<span id="'+a+'__SuccessCount" class="sapUiMsgTxt sapUiMsgBarZeroCount">(0)</span>');s.write("</div>");s.write('<div class="sapUiMsgBarHome"></div>');s.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageBox", ["sap/ui/thirdparty/jquery","sap/ui/core/library","sap/ui/core/ElementMetadata","sap/ui/core/Control","./library","./Button","./Dialog","./Image","./TextView","./layout/MatrixLayout","./layout/MatrixLayoutCell"],function(jQuery,e,t,o,i,n,a,r,s,u,l){"use strict";var c={};c.Action={OK:"OK",CANCEL:"CANCEL",YES:"YES",NO:"NO",ABORT:"ABORT",RETRY:"RETRY",IGNORE:"IGNORE",CLOSE:"CLOSE"};c.Icon={NONE:"NONE",INFORMATION:"INFORMATION",WARNING:"WARNING",ERROR:"ERROR",CRITICAL:"CRITICAL",SUCCESS:"SUCCESS",QUESTION:"QUESTION"};var d=e.AccessibleRole,f=c.Action,O=c.Icon,C=i.layout.Padding,N=i.layout.VAlign;var p={INFORMATION:"sapUiMboxInfo",CRITICAL:"sapUiMboxCritical",ERROR:"sapUiMboxError",WARNING:"sapUiMboxWarning",SUCCESS:"sapUiMboxSuccess",QUESTION:"sapUiMboxQuestion"};c.show=function(e,i,O,R,E,I,y){var S=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),A,T,x,b,M;if(typeof R!=="undefined"&&!Array.isArray(R)){R=[R]}if(!R||R.length===0){R=[f.OK]}y=y||t.uid("mbox");function U(e){var t=S&&S.getText("MSGBOX_"+e),o=new n({id:y+"--btn-"+e,text:t||e,press:function(){T=e;A.close()}});if(e===I){M=o}return o}function g(e){return new l({padding:C.None,vAlign:N.Top,content:e})}function w(e){var t=new r({id:y+"--icon",tooltip:S&&S.getText("MSGBOX_ICON_"+e),decorative:true});t.addStyleClass("sapUiMboxIcon");t.addStyleClass(p[e]);return t}function L(){if(typeof E==="function"){E(T||f.CLOSE)}A.detachClosed(L);A.destroy()}x=new u({id:y+"--lyt",layoutFixed:false}).addStyleClass("sapUiMboxCont");if(typeof e==="string"){b=new s({id:y+"--msg"}).setText(e).addStyleClass("sapUiMboxText")}else if(e instanceof o){b=e.addStyleClass("sapUiMboxText")}if(i!==c.Icon.NONE){x.createRow(g(w(i)),g(b))}else{x.createRow(g(b))}A=new a({id:y,applyContentPadding:false,accessibleRole:d.AlertDialog,resizable:false,modal:true,buttons:jQuery.map(R,U),content:x,defaultButton:M,closed:L}).setTitle(O);A.open()};c.alert=function(e,o,i,n){return c.show(e,O.NONE,i,f.OK,function(e){if(typeof o==="function"){o()}},f.OK,n||t.uid("alert"))};c.confirm=function(e,o,i,n){return c.show(e,O.QUESTION,i,[f.OK,f.CANCEL],function(e){if(typeof o==="function"){o(e===f.OK)}},undefined,n||t.uid("confirm"))};return c},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageList", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/Popup","./MessageListRenderer","sap/ui/core/Configuration"],function(jQuery,e,t,i,o,r){"use strict";var s=t.extend("sap.ui.commons.MessageList",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{visible:{type:"boolean",group:"Behavior",defaultValue:false},anchorId:{type:"string",group:"Appearance",defaultValue:null},maxListed:{type:"string",group:"Misc",defaultValue:"7"}}}});s.prototype.init=function(){this.aMessages=[];this.iItemHeight=0;this.oPopup=new i(this,false,true,false)};s.prototype.exit=function(){this.close();this.oPopup.destroy();this.oPopup=null};s.prototype.onThemeChanged=function(){this.iItemHeight=0};s.prototype.onAfterRendering=function(){var e=this.getDomRef();var t=jQuery(e);var i=this.getMaxListed();var o=this.aMessages.length;if(o<=i){t.height("auto");return}if(this.iItemHeight==0){var r=e.firstChild;var s=jQuery(r);this.iItemHeight=s.height()}e.style.overflowY="scroll";e.style.overflowX="hidden";var a=i*this.iItemHeight+"px";t.height(a)};s.prototype.open=function(){var e=r.getRTL();var t=200;var o=e?i.Dock.RightTop:i.Dock.LeftTop;var s=e?i.Dock.RightBottom:i.Dock.LeftBottom;var a="0 0";var n=null;var p=this.getAnchorId();if(p){n=document.getElementById(p)}if(!n){n=document.body}this.oPopup.open(t,o,s,n,a)};s.prototype.close=function(){var e=200;this.oPopup.close(e)};s.prototype.setMessages=function(e){this.aMessages=e;if(this.getVisible()){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true)}return this};s.prototype.setVisible=function(e){this.setProperty("visible",e);if(e){sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);this.open()}else{this.close()}return this};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageListRenderer", [],function(){"use strict";var e={};e.render=function(e,r){e.write('<ul class="sapUiMsgList"');e.writeControlData(r);e.write(">");for(var s=r.aMessages.length-1;s>=0;s--){e.write('<li class="sapUiMsgListLi">');e.renderControl(r.aMessages[s]);e.write("</li>")}e.write("</ul>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageRenderer", ["./Link"],function(e){"use strict";var i={};i.render=function(i,t){i.write('<div class="sapUiMsg" tabindex="0"');i.writeControlData(t);i.write(">");i.write('<div class="sapUiMsgIcon sapUiMsgIcon'+t.getType()+'"></div>');if(typeof t.fnCallBack==="function"){i.write('<span class="sapUiMsgLnk">');if(!t.oLink){t.oLink=new e;var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");t.oLink.setText(s.getText("MSGLIST_DETAILS"));t.oLink.attachPress(function(){t.openDetails()})}i.renderControl(t.oLink);i.write(" - </span>")}i.write('<span class="sapUiMsgTxt">');i.writeEscaped(t.getText());i.write("</span>");i.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageToast", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./MessageToastRenderer","sap/ui/core/Popup","sap/ui/core/Configuration","sap/ui/thirdparty/jqueryui/jquery-ui-core","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(jQuery,t,e,s,i,o){"use strict";var r=i.Dock;var n=e.extend("sap.ui.commons.MessageToast",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{anchorId:{type:"string",group:"Misc",defaultValue:null}},events:{next:{}}}});n.prototype.init=function(){this.oMessage=null;this.sAnchorId="";this.bIdle=true;this.sLeftOffset="";this.oPopup=new i(this,false,false,false);this.oPopup.attachClosed(this.next,this)};n.prototype.exit=function(){if(!this.bIdle){this.close()}this.oPopup.destroy();this.oPopup=null};n.prototype.onAfterRendering=function(){var t=o.getRTL();var e=jQuery(this.sAnchorId?document.getElementById(this.sAnchorId):null);var s=e.position();var i=jQuery(this.getAnchorId()?document.getElementById(this.getAnchorId()):null);var r=i.outerWidth();if(s){var n=t?s.left+e.outerWidth():r-s.left;var a=this.$();var p=a.width();var u=Math.max(p,r);var h=r-p;if(h>0){a.css("minWidth",r)}var d=t?u-n+2+"px":u-n-2+"px";if(u>=n){var c=jQuery(document.getElementById(this.getId()+"Arrow"));if(o.getRTL()){c.css("marginRight",d)}else{c.css("marginLeft",d)}this.sLeftOffset="0"}}};n.prototype.next=function(){this.bIdle=true;this.fireNext()};n.prototype.open=function(t){if(!this.bIdle){this.oPopup.close(0)}this.bIdle=false;var e=o.getRTL();var s=e?r.LeftBottom:r.RightBottom;var i=e?r.LeftTop:r.RightTop;var n=this.sLeftOffset+" 5";var a=null;var p=this.getAnchorId();if(p){a=document.getElementById(p)}if(!a){a=document.body}this.oPopup.open(t,s,i,a,n)};n.prototype.close=function(t){this.oPopup.close(t)};n.prototype.getClasses=function(){var t="sapUiMsgToast";if(this.oMessage&&this.oMessage.getType()){t+=" sapUiMsgT"+this.oMessage.getType()}return t};n.prototype.toast=function(t,e){this.oMessage=t;this.sAnchorId=e;sap.ui.getCore().getRenderManager().render(this,sap.ui.getCore().getStaticAreaRef(),true);this.open(750);this.close(2250);return this};n.prototype.isIdle=function(){return this.bIdle};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/MessageToastRenderer", [],function(){"use strict";var s={};s.render=function(s,e){s.write('<div class="'+e.getClasses()+'"');s.writeControlData(e);s.write(">");s.write('<div class="sapUiMsgToastMsg sapUiShd">');if(e.oMessage){s.renderControl(e.oMessage)}else{var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("MSGTOAST_MULTI_MSGS");s.write('<div class="sapUiMsg" tabindex="0"><span class="sapUiMsgTxt">'+i+"</span></div>")}s.write("</div>");s.write('<div id="'+e.getId()+'Arrow" class="sapUiMsgToastArrow"></div>');s.write("</div>")};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Paginator", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./PaginatorRenderer","sap/ui/dom/jquery/Selectors"],function(jQuery,e,t,i){"use strict";var a=e.PaginatorEvent;var r=t.extend("sap.ui.commons.Paginator",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{currentPage:{type:"int",group:"Misc",defaultValue:1},numberOfPages:{type:"int",group:"Misc",defaultValue:null}},events:{page:{parameters:{srcPage:{type:"int"},targetPage:{type:"int"},type:{type:"sap.ui.commons.PaginatorEvent"}}}}}});r.MAX_NUMBER_PAGES=5;r.prototype.init=function(){this.bShowAnimation=true};r.prototype.onclick=function(e){this._handleSelect(e)};r.prototype.setCurrentPage=function(e,t){this.setProperty("currentPage",e,t);if(this.getDomRef()){i.updateBackAndForward(this)}return this};r.prototype.triggerPaginatorAnimation=function(){var e=[];var t=[];var a=this.$("pages").children();var r=this._calculatePagesRange();var s;if(this._oOldRange){s=this._oOldRange}else{s={};var n=a[0].id.split("--");s.firstPage=parseInt(n[n.length-1]);n=a[a.length-1].id.split("--");s.lastPage=parseInt(n[n.length-1])}var g;for(g=r.firstPage;g<=r.lastPage;g++){if(g<s.firstPage||g>s.lastPage){t.push(g)}}var o={firstPage:t[0],lastPage:t[t.length-1]};for(g=s.firstPage;g<=s.lastPage;g++){if(g<r.firstPage||g>r.lastPage){e.push(g)}}var f=i.getPagesHtml(this.getId(),s,this.getCurrentPage(),true);var u=i.getPagesHtml(this.getId(),o,this.getCurrentPage(),false);if(s.firstPage<o.firstPage){u=f+u}else{u=u+f}var l=document.activeElement;var p=l?l.id:undefined;this.getDomRef("pages").innerHTML=u;if(p){l=document.getElementById(p)}else{l=document.getElementById("testPaginator-a--"+this.getCurrentPage())}if(l){l.focus()}var h="li--";this._oOldRange=r;function d(){var e=document.getElementById(this.id);if(e){e.parentNode.removeChild(e)}}for(g=0;g<e.length;g++){this.$(h+e[g]).hide(400,d)}for(g=0;g<t.length;g++){this.$(h+t[g]).show(400)}};r.prototype._calculatePagesRange=function(){var e=1;var t=this.getNumberOfPages();var i=this.getCurrentPage();var a=this.getNumberOfPages();if(i<4){e=1;if(t>r.MAX_NUMBER_PAGES){t=r.MAX_NUMBER_PAGES}}else if(i==t){if(a<5){e=1}else{e=t-4}}else if(t-i<3){e=t-4}else{e=i-2;t=i+2}return{firstPage:e,lastPage:t}};r.prototype.onkeydown=function(e){var t=e.getPseudoTypes();if(t.indexOf("saptabnext")!=-1){this.triggerTabbingNavigation(e,false)}else if(t.indexOf("saptabprevious")!=-1){this.triggerTabbingNavigation(e,true)}else if(t.indexOf("sapincrease")!=-1){this.triggerInternalNavigation(e,"next")}else if(t.indexOf("sapdecrease")!=-1){this.triggerInternalNavigation(e,"previous")}else if(t.indexOf("sapenter")!=-1){this._handleSelect(e)}};r.prototype.triggerInternalNavigation=function(e,t){var i=this.$().find(":sapFocusable");var a=jQuery(i).index(e.target);var r,s;if(t=="next"){r=a+1;if(jQuery(e.target).hasClass("sapUiPagCurrentPage")){r=r+1}s=i[r];if(s){jQuery(s).trigger("focus");e.preventDefault();e.stopPropagation()}}else if(t=="previous"&&i[a-1]){r=a-1;s=i[r];if(s&&jQuery(s).hasClass("sapUiPagCurrentPage")){s=i[r-1]}if(s){jQuery(s).trigger("focus");e.preventDefault();e.stopPropagation()}}};r.prototype.triggerTabbingNavigation=function(e,t){var i=this.$().find(":sapFocusable");if(!t){jQuery(i[i.length-1]).trigger("focus")}else{var a=jQuery(i).index(e.target);if(a!=0){jQuery(i[0]).trigger("focus")}}};r.prototype.getFocusInfo=function(){var e=this.$().find(":focus").attr("id");if(e){return{customId:e}}else{return t.prototype.getFocusInfo.apply(this,arguments)}};r.prototype.applyFocusInfo=function(e){if(e&&e.customId){this.$().find("#"+e.customId).trigger("focus")}else{t.prototype.getFocusInfo.apply(this,arguments)}return this};r.prototype._handleSelect=function(e){if(e&&e.target){e.preventDefault();var t=e.target;if(!t.id){t=t.parentNode}if(t.id&&t.id!=this.getId()+"-pages"){var i=t.id.split("--");if(i.length>1){var r=i[i.length-1];var s=null;var n=this.getCurrentPage();var g=n;if(r.match(/^\d+$/)){s=a.Goto;g=parseInt(r)}else if(r=="firstPageLink"){s=a.First;g=1}else if(r=="backLink"){s=a.Previous;g=Math.max(n-1,1)}else if(r=="forwardLink"){s=a.Next;g=Math.min(n+1,this.getNumberOfPages())}else if(r=="lastPageLink"){s=a.Last;g=this.getNumberOfPages()}if(g!=n){if(this.bShowAnimation){this.setCurrentPage(g,true);this.triggerPaginatorAnimation()}else{this.setCurrentPage(g)}this.firePage({srcPage:n,targetPage:g,type:s})}}}}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/PaginatorRenderer", ["sap/base/security/encodeXML","sap/ui/thirdparty/jquery"],function(e,jQuery){"use strict";var a={};a.render=function(e,a){var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");e.write("<div");e.writeControlData(a);e.writeAccessibilityState(a,{role:"toolbar",labelledby:a.getId()+"-accDesc"});e.addClass("sapUiPag");e.writeClasses();e.write(">");e.write("<span class='sapUiPagAccDesc' id='"+a.getId()+"-accDesc'>");e.writeEscaped(t.getText("PAGINATOR"));e.write("</span>");this.renderPaginator(e,a);e.write("</div>")};a.renderPaginator=function(e,t){if(t.getNumberOfPages()<=1){return}var s=t.getId();var r=t.getCurrentPage();var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var g=r==1?"sapUiLnkDsbl":"sapUiLnk";var l=r==1?" aria-disabled='true'":"";if(t.getNumberOfPages()>5){e.write("<a id='"+s+"--firstPageLink' href='#;' title='");e.writeEscaped(i.getText("FIRST_PAGE"));e.write("' class='sapUiPagBtn sapUiPagFirst "+g+"' "+l+"><span class='sapUiPagText'>");e.writeEscaped(i.getText("PAGINATOR_OTHER_PAGE",[1]));e.write("</span></a>")}e.write("<a id='"+s+"--backLink' href='#' title='");e.writeEscaped(i.getText("PREVIOUS_PAGE"));e.write("' class='sapUiPagBtn sapUiPagBack "+g+"' "+l+"><span class='sapUiPagText'>");e.writeEscaped(i.getText("BACK"));e.write("</span></a>");e.write("<ul id='"+s+"-pages' role='presentation'>");e.write(a.getPagesHtml(s,t._calculatePagesRange(),t.getCurrentPage(),true));e.write("</ul>");g=r===t.getNumberOfPages()?"sapUiLnkDsbl":"sapUiLnk";l=r===t.getNumberOfPages()?" aria-disabled='true'":"";e.write("<a id='"+s+"--forwardLink' href='#' title='");e.writeEscaped(i.getText("NEXT_PAGE"));e.write("' class='sapUiPagBtn sapUiPagForward "+g+"' "+l+"><span class='sapUiPagText'>");e.writeEscaped(i.getText("FORWARD"));e.write("</span></a>");if(t.getNumberOfPages()>5){e.write("<a id='"+s+"--lastPageLink' href='#' title='");e.writeEscaped(i.getText("LAST_PAGE"));e.write("' class='sapUiPagBtn sapUiPagLast "+g+"' "+l+"><span class='sapUiPagText'>");e.writeEscaped(i.getText("PAGINATOR_OTHER_PAGE",[t.getNumberOfPages()]));e.write("</span></a>")}};a.getPagesHtml=function(a,t,s,r){var i=[];var g=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");for(var l=t.firstPage;l<=t.lastPage;l++){i.push("<li id='"+a+"-li--"+l+"' class='sapUiPagPage");i.push(l==s?" sapUiPagCurrentPage'":"'");if(!r){i.push(" style='display:none'")}i.push(">");i.push("<a id='"+a+"-a--"+l+"' title='");if(l==s){i.push(e(g.getText("PAGINATOR_CURRENT_PAGE",[l])))}else{i.push(e(g.getText("PAGINATOR_OTHER_PAGE",[l])))}i.push("' href='#'");if(l==s){i.push(" tabindex='0' class='sapUiLnkDsbl'")}else{i.push(" class='sapUiLnk'")}i.push(">"+l+"</a>");i.push("</li>")}return i.join("")};a.updateBackAndForward=function(e){var a=e.getCurrentPage();var t=e.getId();var s=a==1;var r=a==e.getNumberOfPages();var i=jQuery(document.getElementById(t+"--firstPageLink")).toggleClass("sapUiLnk",!s).toggleClass("sapUiLnkDsbl",s);var g=jQuery(document.getElementById(t+"--backLink")).toggleClass("sapUiLnk",!s).toggleClass("sapUiLnkDsbl",s);var l=jQuery(document.getElementById(t+"--forwardLink")).toggleClass("sapUiLnk",!r).toggleClass("sapUiLnkDsbl",r);var n=jQuery(document.getElementById(t+"--lastPageLink")).toggleClass("sapUiLnk",!r).toggleClass("sapUiLnkDsbl",r);if(s){i.attr("aria-disabled","true");g.attr("aria-disabled","true");l.removeAttr("aria-disabled");n.removeAttr("aria-disabled")}else if(r){i.removeAttr("aria-disabled");g.removeAttr("aria-disabled");l.attr("aria-disabled","true");n.attr("aria-disabled","true")}else{i.removeAttr("aria-disabled");g.removeAttr("aria-disabled");l.removeAttr("aria-disabled");n.removeAttr("aria-disabled")}};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Panel", ["sap/ui/thirdparty/jquery","sap/base/assert","./library","sap/ui/core/Control","./PanelRenderer","sap/ui/core/ResizeHandler","sap/ui/core/Title","sap/ui/core/Configuration","sap/ui/dom/jquery/scrollLeftRTL"],function(jQuery,t,e,i,o,s,r,l){"use strict";var n=e.enums.BorderDesign;var h=e.enums.AreaDesign;var a=i.extend("sap.ui.commons.Panel",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},scrollLeft:{type:"int",group:"Behavior",defaultValue:0},scrollTop:{type:"int",group:"Behavior",defaultValue:0},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},collapsed:{type:"boolean",group:"Behavior",defaultValue:false},areaDesign:{type:"sap.ui.commons.enums.AreaDesign",group:"Appearance",defaultValue:h.Fill},borderDesign:{type:"sap.ui.commons.enums.BorderDesign",group:"Appearance",defaultValue:n.Box},showCollapseIcon:{type:"boolean",group:"Behavior",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},title:{type:"sap.ui.core.Title",multiple:false},buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}}}});a.prototype.init=function(){this._oScrollDomRef=null;this._iMaxTbBtnWidth=-1;this._iTbMarginsAndBorders=0;this._iMinTitleWidth=30;this._iOptTitleWidth=30;this._iTitleMargin=0;this._bFocusCollapseIcon=false;this._resizeDelayTimer=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.data("sap-ui-fastnavgroup","true",true)};a.prototype.exit=function(){this._rb=undefined};a.prototype.onThemeChanged=function(){if(this.getDomRef()&&this._oTitleDomRef){this.getDomRef().style.minWidth="auto";if(this._oToolbarDomRef){this._oToolbarDomRef.style.width="auto"}this._oTitleDomRef.style.width="auto";this._initializeSizes()}};a.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};a.prototype.onAfterRendering=function(){this._oScrollDomRef=this.getDomRef("cont");if(!this._oScrollDomRef){return}this._oHeaderDomRef=this.getDomRef("hdr");this._oTitleDomRef=this.getDomRef("title");this._oToolbarDomRef=this.getDomRef("tb");if(this._bFocusCollapseIcon){this._bFocusCollapseIcon=false;var t=this.$("collArrow");if(t.is(":visible")&&(t.css("visibility")=="visible"||t.css("visibility")=="inherit")){t.trigger("focus")}else{var e=this.$("collIco");if(e.is(":visible")&&(e.css("visibility")=="visible"||e.css("visibility")=="inherit")){e.trigger("focus")}}}this._initializeSizes();if(a._isSizeSet(this.getHeight())&&(this._hasIcon()||this.getButtons().length>0)){this._handleResizeNow();this.sResizeListenerId=s.register(this.getDomRef(),jQuery.proxy(this._handleResizeSoon,this))}};a.prototype.getFocusInfo=function(){var t=null;var e=this.getId();if(this._bFocusCollapseIcon){var i=this.$("collArrow");if(i.is(":visible")&&(i.css("visibility")=="visible"||i.css("visibility")=="inherit")){t=i[0].id}else{var o=this.$("collIco");if(o.is(":visible")&&(o.css("visibility")=="visible"||o.css("visibility")=="inherit")){t=o[0].id}}}return{id:t?t:e}};a.prototype.applyFocusInfo=function(t){var e;if(t&&t.id&&(e=jQuery(document.getElementById(t.id)))&&e.length>0){e.trigger("focus")}else{this.focus()}return this};a.prototype._initializeSizes=function(){var t=l.getRTL();var e=this.getButtons();if(e&&e.length>0){var i=0;jQuery(this._oToolbarDomRef).children().each(function(){var t=this.offsetWidth;if(t>i){i=t}});this._iMaxTbBtnWidth=i;if(this._oToolbarDomRef){this._oToolbarDomRef.style.minWidth=i+"px";var o=jQuery(this._oToolbarDomRef);this._iTbMarginsAndBorders=o.outerWidth(true)-o.width()}}var s=this._oTitleDomRef.offsetLeft;var r=this.getDomRef().offsetWidth;if(t){s=r-(s+this._oTitleDomRef.offsetWidth)}var n=jQuery(this._oTitleDomRef);this._iOptTitleWidth=n.width()+1;this._iTitleMargin=n.outerWidth(true)-n.outerWidth();var h=1e4;jQuery(this._oHeaderDomRef).children(".sapUiPanelHdrRightItem").each(function(){var e=this.offsetLeft;if(t){e=r-(e+this.offsetWidth)}if(e<h&&e>0){h=e}});var a=s;a+=this._iMinTitleWidth;a+=this._iMaxTbBtnWidth+1;a+=h==1e4?10:r-h;this.getDomRef().style.minWidth=a+10+"px";if(this._oScrollDomRef){var f=this.getProperty("scrollTop");if(f>0){this._oScrollDomRef.scrollTop=f}var p=this.getProperty("scrollLeft");if(p>0){this._oScrollDomRef.scrollLeft=p}}};a.prototype._fixContentHeight=function(){if(a._isSizeSet(this.getHeight())&&(this._hasIcon()||this.getButtons().length>0)){this._iContTop=this._oHeaderDomRef.offsetHeight;if(this._oScrollDomRef){this._oScrollDomRef.style.top=this._iContTop+"px"}}};a.prototype._handleResizeSoon=function(){if(this._resizeDelayTimer){clearTimeout(this._resizeDelayTimer)}this._resizeDelayTimer=setTimeout(function(){this._handleResizeNow();this._resizeDelayTimer=null}.bind(this),200)};a.prototype._handleResizeNow=function(){this._fixContentHeight()};a.prototype._hasIcon=function(){return this.getTitle()&&this.getTitle().getIcon()};a.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);jQuery(this.getDomRef()).toggleClass("sapUiPanelDis",!t);return this};a.prototype.setApplyContentPadding=function(t){this.setProperty("applyContentPadding",t,true);jQuery(this.getDomRef()).toggleClass("sapUiPanelWithPadding",t);return this};a.prototype.setCollapsed=function(t){this.setProperty("collapsed",t,true);this._setCollapsedState(t);return this};a.prototype._setCollapsedState=function(t){var e=this.getDomRef();if(e){var i=l.getAccessibility();if(t){if(!this.getWidth()){e.style.width=this.getDomRef().offsetWidth+"px"}jQuery(e).addClass("sapUiPanelColl");if(i){e.setAttribute("aria-expanded","false")}if(this.getHeight()){e.style.height="auto"}var o=this._rb.getText("PANEL_EXPAND");this.$("collArrow").attr("title",o);this.$("collIco").attr("title",o)}else{if(!this.getDomRef("cont")){this._bFocusCollapseIcon=true;this.rerender()}else{jQuery(e).removeClass("sapUiPanelColl");if(i){e.setAttribute("aria-expanded","true")}if(!this.getWidth()){e.style.width="auto"}if(this.getHeight()){e.style.height=this.getHeight()}var s=this._rb.getText("PANEL_COLLAPSE");this.$("collArrow").attr("title",s);this.$("collIco").attr("title",s)}}}};a._isSizeSet=function(t){return t&&!(t=="auto")&&!(t=="inherit")};a.prototype.setTitle=function(t){var e=this.getTitle();this.setAggregation("title",t);if(e&&e!==t&&e.getId()===this.getId()+"-tit"){e.destroy()}return this};a.prototype.setText=function(t){if(!this.getTitle()){this.setTitle(new r(this.getId()+"-tit",{text:t}))}else{this.getTitle().setText(t)}return this};a.prototype.getText=function(){if(!this.getTitle()){return""}else{return this.getTitle().getText()}};a.prototype.getScrollLeft=function(){var e=0;if(this._oScrollDomRef){if(l.getRTL()){e=jQuery(this._oScrollDomRef).scrollLeftRTL()}else{e=jQuery(this._oScrollDomRef).scrollLeft()}t(typeof e=="number","scrollLeft read from DOM should be a number");this.setProperty("scrollLeft",e,true)}return e};a.prototype.setScrollLeft=function(t){this.setProperty("scrollLeft",t,true);if(this._oScrollDomRef){if(l.getRTL()){jQuery(this._oScrollDomRef).scrollLeftRTL(t)}else{jQuery(this._oScrollDomRef).scrollLeft(t)}}return this};a.prototype.getScrollTop=function(){var t=0;if(this._oScrollDomRef){t=Math.ceil(this._oScrollDomRef.scrollTop);this.setProperty("scrollTop",t,true)}return t};a.prototype.setScrollTop=function(t){this.setProperty("scrollTop",t,true);if(this._oScrollDomRef){this._oScrollDomRef.scrollTop=t}return this};a.prototype.setDimensions=function(e,i){t(typeof e=="string"&&typeof i=="string","sWidth and sHeight must be strings");this.setWidth(e);this.setHeight(i);return this};a.prototype.setWidth=function(t){this.setProperty("width",t,true);var e=this.getDomRef();if(e){e.style.width=t}return this};a.prototype.setHeight=function(t){this.setProperty("height",t,true);var e=this.getDomRef();if(e){e.style.height=t}return this};a.prototype.onclick=function(t){this._handleTrigger(t)};a.prototype.onsapspace=function(t){this._handleTrigger(t)};a.prototype._handleTrigger=function(t){var e=this.getId();if(t.target.id===e+"-collArrow"||t.target.id===e+"-collIco"||t.target.id===e&&t.type==="sapspace"&&this.getShowCollapseIcon()){this.setCollapsed(!this.getProperty("collapsed"));t.preventDefault();t.stopPropagation();this.fireEvent("collapsedToggled")}};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/PanelRenderer", ["sap/base/security/encodeXML","sap/ui/core/library","sap/ui/core/Configuration"],function(e,t,i){"use strict";var a=t.TitleLevel;var r=function(){};r.render=function(t,r){var s=r.getId();var n=i.getAccessibility();var d=l(r.getHeight());var o=l(r.getWidth());r.getScrollTop();r.getScrollLeft();t.write("<section");t.writeControlData(r);t.addClass("sapUiPanel");t.addStyle("width",r.getWidth());if(!r.getCollapsed()){t.addStyle("height",r.getHeight())}else{t.addClass("sapUiPanelColl");t.addStyle("height","auto")}if(d){t.addClass("sapUiPanelHeightSet")}if(o){t.addClass("sapUiPanelWidthSet")}if(r.getApplyContentPadding()){t.addClass("sapUiPanelWithPadding")}if(!r.getEnabled()){t.addClass("sapUiPanelDis")}if(r.getShowCollapseIcon()){t.addClass("sapUiPanelWithCollapseIcon")}t.addClass("sapUiPanelBorderDesign"+r.getBorderDesign());t.addClass("sapUiPanelAreaDesign"+r.getAreaDesign());t.writeClasses();t.writeStyles();if(n){t.writeAttribute("aria-labelledby",s+"-title ");t.writeAttribute("aria-describedby",s+"-acc");t.writeAttribute("role","region");if(r.getCollapsed()){t.writeAttribute("aria-expanded","false")}else{t.writeAttribute("aria-expanded","true")}t.writeAttribute("tabindex","0")}var p=r.getTooltip_AsString();if(p){t.writeAttributeEscaped("title",p)}t.write("><header id='"+s+"-hdr'");t.addClass("sapUiPanelHdr");var g=r.getTitle();var c;var w=a.H5;var C=true;if(g){c=g.getTooltip_AsString();if(c){t.writeAttributeEscaped("title",c)}if(g.getLevel()!=a.Auto){w=g.getLevel();C=g.getEmphasized()}}if(C){t.addClass("sapUiPanelHdrEmph")}t.writeClasses();t.write(">");if(r.getShowCollapseIcon()&&n){t.write('<span id="'+s+'-acc" style="display:none;">');t.writeEscaped(r._rb.getText("PANEL_HEAD_ACC"));t.write("</span>")}var u=r._rb.getText(r.getCollapsed()?"PANEL_EXPAND":"PANEL_COLLAPSE");if(r.getShowCollapseIcon()){t.write("<a id='"+s+"-collArrow' class='sapUiPanelHdrItem sapUiPanelCollArrow' href='#' tabindex='0' title='"+u+"'");if(n){t.writeAttribute("role","button")}t.write(">&nbsp;</a>")}if(g&&g.getIcon()){var f=g.getIcon();var h=[];var b={};b["id"]=s+"-ico";b["title"]=null;h.push("sapUiPanelIco");h.push("sapUiPanelHdrItem");h.push("sapUiTv"+w);t.writeIcon(f,h,b)}var v=e(r.getText());if(!v){v="&nbsp;"}t.write("<"+w+" ");t.addClass("sapUiTv"+w);t.write(" id='"+s+"-title' ");t.addClass("sapUiPanelHdrItem");t.addClass("sapUiPanelTitle");t.writeClasses();if(n){t.writeAttribute("role","heading")}t.write(">");t.write(v);t.write("</"+w+">");var P=r.getButtons();if(P&&P.length>0){t.write("<div id='"+s+"-tb' class='sapUiPanelHdrItem sapUiPanelTb sapUiTbDesignFlat'>");for(var A=0;A<P.length;A++){t.renderControl(P[A])}t.write("</div>")}if(r.getShowCollapseIcon()){t.write("<a id='"+s+"-collIco' class='sapUiPanelHdrRightItem sapUiPanelCollIco' href='#' tabindex='0' title='"+u+"'");if(n){t.writeAttribute("role","button")}t.write(">&nbsp;</a>")}t.write("</header>");if(!r.getCollapsed()){t.write("<div class='sapUiPanelCont' id='",s,"-cont'>");var U=r.getContent(),I=U.length;for(var A=0;A<I;A++){t.renderControl(U[A])}t.write("</div>")}else{r.getContent().forEach(function(e){t.cleanupControlWithoutRendering(e)})}t.write("</section>")};function l(e){return e&&e!=="auto"&&e!=="inherit"}return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/PasswordField", ["sap/ui/thirdparty/jquery","./TextField","./library","./PasswordFieldRenderer","sap/ui/Device"],function(jQuery,e,t,o,p){"use strict";var r=e.extend("sap.ui.commons.PasswordField",{metadata:{library:"sap.ui.commons",deprecated:true}});r.prototype.onfocusin=function(t){e.prototype.onfocusin.apply(this,arguments);if(!p.support.input.placeholder&&this.getPlaceholder()){jQuery(this.getInputDomRef()).attr("type","password")}};r.prototype.onsapfocusleave=function(t){if(!p.support.input.placeholder&&this.getPlaceholder()){var o=jQuery(this.getInputDomRef());if(!o.val()){o.removeAttr("type")}}e.prototype.onsapfocusleave.apply(this,arguments)};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/PasswordFieldRenderer", ["./TextFieldRenderer","sap/ui/core/Renderer","sap/ui/Device"],function(e,t,a){"use strict";var r=t.extend(e);r.renderInnerAttributes=function(e,t){if(a.support.input.placeholder||t.getValue()||!t.getPlaceholder()){e.writeAttribute("type","password")}};r.renderTextFieldEnabled=function(e,t){if(!t.getEnabled()&&!t.getEditable()){e.writeAttribute("readonly","readonly");e.writeAttribute("tabindex","-1")}else{e.writeAttribute("tabindex","0")}};r.setEnabled=function(e,t){var a=e.$();if(t){if(e.getEditable()){a.removeClass("sapUiTfDsbl").addClass("sapUiTfStd");a.removeAttr("readonly").attr("tabindex","0")}else{a.removeClass("sapUiTfDsbl").addClass("sapUiTfRo");a.attr("tabindex","0")}}else{if(e.getEditable()){a.removeClass("sapUiTfStd").addClass("sapUiTfDsbl");a.attr("readonly","readonly").attr("tabindex","-1")}else{a.removeClass("sapUiTfRo").addClass("sapUiTfDsbl");a.attr("tabindex","-1")}}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ProgressIndicator", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./ProgressIndicatorRenderer","sap/ui/core/library"],function(jQuery,e,t,i,a){"use strict";var r=a.BarColor;var s=t.extend("sap.ui.commons.ProgressIndicator",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},barColor:{type:"sap.ui.core.BarColor",group:"Appearance",defaultValue:r.NEUTRAL},displayValue:{type:"string",group:"Appearance",defaultValue:"0%"},percentValue:{type:"int",group:"Data",defaultValue:0},showValue:{type:"boolean",group:"Appearance",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}}}});s.prototype.onclick=function(e){this.focus()};s.prototype.onselectstart=function(e){return false};s.prototype.setEndBar=function(){var e=this.getPercentValue();var t;var i=this.getBarColor();var a;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");jQuery(this.oEnd).removeClass("sapUiProgIndEndHidden");jQuery(this.oEnd).addClass(this._getProgIndTypeClass(i));if(e>100){t=1e4/e+"%"}else{t="100%"}if(e>100){a=(e-100)*20}else{a=(100-e)*20}jQuery(this.oBox).animate({width:t},0,"linear");if(this.bRtl){jQuery(this.oEnd).animate({right:t},a,"linear")}else{jQuery(this.oEnd).animate({left:t},a,"linear")}jQuery(this.oBar).animate({width:e+"%"},a,"linear");if(!this.oThis){this.oThis=this.$()}this.oThis.attr("aria-valuenow",e+"%")};s.prototype.setEndBarGoesBack=function(e){var t=this.getPercentValue();var i;var a=this.getBarColor();var r;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");if(e>100){i=1e4/e+"%"}else{i="100%"}jQuery(this.oEnd).removeClass(this._getProgIndTypeClass(a));jQuery(this.oEnd).addClass("sapUiProgIndEndHidden");if(t>100){r=(t-100)*20}else{r=(100-t)*20}jQuery(this.oBox).animate({width:i},0,"linear");if(this.bRtl){jQuery(this.oEnd).animate({right:i},r,"linear")}else{jQuery(this.oEnd).animate({left:i},r,"linear")}jQuery(this.oBar).animate({width:t+"%"},r,"linear");if(!this.oThis){this.oThis=this.$()}this.oThis.attr("aria-valuenow",t+"%")};s.prototype.setPercentValue=function(e){var t=this.getPercentValue();var i;this.oBar=this.getDomRef("bar");this.oEnd=this.getDomRef("end");this.oBox=this.getDomRef("box");var a=this;var r;if(e<0){e=0}if(e>100){i=1e4/e+"%"}else{i="100%"}if(!this.oBar){r=e*20;this.setProperty("percentValue",e,true);jQuery(this.oBar).animate({width:e+"%"},r,"linear");return this}if(e>100&&t<=100){r=(100-t)*20;this.setProperty("percentValue",e,true);jQuery(this.oBar).animate({width:"100%"},r,"linear",function(){a.setEndBar()})}else if(e<=100&&t>100){r=(t-100)*20;this.setProperty("percentValue",e,true);jQuery(this.oBar).animate({width:"100%"},r,"linear",function(){a.setEndBarGoesBack()})}else if(e>100&&t>100){if(e>t){r=(e-t)*20}else{r=(t-e)*20}i=1e4/e+"%";this.setProperty("percentValue",e,true);jQuery(this.oBox).animate({width:i},0,"linear");if(this.bRtl){jQuery(this.oEnd).animate({right:i},r,"linear")}else{jQuery(this.oEnd).animate({left:i},r,"linear")}jQuery(this.oBar).animate({width:e+"%"},r,"linear",function(){});if(!this.oThis){this.oThis=this.$()}this.oThis.attr("aria-valuenow",e+"%")}else{if(e>t){r=(e-t)*20}else{r=(t-e)*20}this.setProperty("percentValue",e,true);jQuery(this.oBar).animate({width:e+"%"},r,"linear");if(!this.oThis){this.oThis=this.$()}this.oThis.attr("aria-valuenow",e+"%")}return this};s.prototype._getProgIndTypeClass=function(e){switch(e){case"POSITIVE":return"sapUiProgIndPosEnd";case"NEGATIVE":return"sapUiProgIndNegEnd";case"CRITICAL":return"sapUiProgIndCritEnd";case"NEUTRAL":return"sapUiProgIndEnd";default:return"sapUiProgIndEnd"}};s.prototype.getAccessibilityInfo=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"progressbar",type:e.getText("ACC_CTR_TYPE_PROGRESS"),description:e.getText("ACC_CTR_STATE_PROGRESS",[this.getPercentValue()]),focusable:this.getEnabled(),enabled:this.getEnabled()}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ProgressIndicatorRenderer", ["sap/ui/core/Configuration"],function(e){"use strict";var t={};t.render=function(t,i){var r=i.getWidth(),a=i.getPercentValue(),s=i.getTooltip_AsString(),d=i.getDisplayValue(),l;i.bRtl=e.getRTL();if(a>100){l=1e4/a+"%"}else{l="100%"}t.write("<div");t.writeControlData(i);t.writeAttribute("tabindex","0");if(e.getAccessibility()){t.writeAccessibilityState(i,{role:"progressbar",valuemin:"0%",valuenow:a+"%",valuemax:"100%"})}if(d){t.writeAttributeEscaped("aria-valuetext",d)}if(s){t.writeAttributeEscaped("title",s)}if(i.getWidth()&&i.getWidth()!==""){t.writeAttribute("style","height: 16px; width:"+r+";")}t.addClass("sapUiProgInd");t.writeClasses();t.write(">");t.write("<div");t.writeAttribute("id",i.getId()+"-box");if(i.getWidth()&&i.getWidth()!==""){t.writeAttribute("style","height: 16px; width:"+l+";")}t.addClass("sapUiProgIndBorder");t.writeClasses();t.write(">");t.write("<div");t.writeAttribute("id",i.getId()+"-bar");t.writeAttribute("style","height: 14px; width:"+i.getPercentValue()+"%;");var w=i.getBarColor();switch(w){case"POSITIVE":t.addClass("sapUiProgIndBarPos");break;case"NEGATIVE":t.addClass("sapUiProgIndBarNeg");break;case"CRITICAL":t.addClass("sapUiProgIndBarCrit");break;case"NEUTRAL":t.addClass("sapUiProgIndBar");break;default:t.addClass("sapUiProgIndBar");break}t.writeClasses();t.write(">");t.write("<div");t.writeAttribute("id",i.getId()+"-end");if(a>100){t.addClass(i._getProgIndTypeClass(w))}else{t.addClass("sapUiProgIndEndHidden")}t.writeClasses();if(i.bRtl){t.writeAttribute("style","position: relative; right:"+l)}else{t.writeAttribute("style","position: relative; left:"+l)}t.write(">");t.write("</div>");t.write("<span");t.addClass("sapUiProgIndFont");t.writeClasses();t.write(">");if(i.getShowValue()&&i.getShowValue()){if(i.getDisplayValue()&&i.getDisplayValue()!==""){t.writeEscaped(i.getDisplayValue())}}t.write("</span>");t.write("</div>");t.write("</div>");t.write("</div>")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RadioButton", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RadioButtonRenderer","sap/ui/core/library"],function(jQuery,e,t,i,a){"use strict";var r=a.TextDirection;var o=a.ValueState;var s=t.extend("sap.ui.commons.RadioButton",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Data",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},selected:{type:"boolean",group:"Data",defaultValue:false},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:o.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:r.Inherit},groupName:{type:"string",group:"Behavior",defaultValue:"sapUiRbDefaultGroup"},key:{type:"string",group:"Data",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{}}}});s.prototype.init=function(){this._changeGroupName(this.getGroupName())};s.prototype.exit=function(){var e=this.getGroupName(),t=this._groupNames[e];t.splice(t.indexOf(this),1)};s.prototype.onclick=function(e){if(this.getEnabled()&&e.target.id==this.getId()+"-RB"){this.focus()}this.userSelect(e)};s.prototype._groupNames={};s.prototype.onsapspace=function(e){if(this.getEnabled()&&e.target.id==this.getId()+"-RB"){this.focus()}this.userSelect(e)};s.prototype.onfocusin=function(e){if(this.getEnabled()&&e.target.id==this.getId()+"-RB"){this.focus()}};s.prototype.userSelect=function(e){if(this.getEnabled()&&this.getEditable()){var t=this.getSelected();if(!t){this.setSelected(true);this.fireSelect({})}}else{e.preventDefault()}};s.prototype.setSelected=function(e){var t,i=this.getSelected(),a=this.getGroupName(),r=this._groupNames[a],o=r&&r.length;this.setProperty("selected",e,true);if(e&&a&&a!==""){for(var u=0;u<o;u++){t=r[u];if(t instanceof s&&t!==this&&t.getSelected()){t.setSelected(false)}}}if(i!=e&&this.getDomRef()&&this.getRenderer().setSelected){this.getRenderer().setSelected(this,e)}return this};s.prototype.setGroupName=function(e){e=this.validateProperty("groupName",e);this._changeGroupName(e,this.getGroupName());return this.setProperty("groupName",e,false)};s.prototype.getTooltipDomRefs=function(){return this.getDomRef().children};s.prototype._changeGroupName=function(e,t){var i=this._groupNames[e],a=this._groupNames[t];if(!i){i=this._groupNames[e]=[]}if(i.indexOf(this)===-1){i.push(this)}if(a&&a.indexOf(this)!==-1){a.splice(a.indexOf(this),1)}};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RadioButtonGroup", ["sap/base/Log","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./RadioButton","./RadioButtonGroupRenderer","sap/ui/core/library"],function(e,t,i,s,a,n,h){"use strict";var o=h.ValueState;var r=i.extend("sap.ui.commons.RadioButtonGroup",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},columns:{type:"int",group:"Appearance",defaultValue:1},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:o.None},selectedIndex:{type:"int",group:"Data",defaultValue:0},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selectedIndex:{type:"int"}}}}}});r.prototype.exit=function(){this.destroyItems();if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};r.prototype.onBeforeRendering=function(){if(this.getSelectedIndex()>this.getItems().length){e.warning("Invalid index, set to 0");this.setSelectedIndex(0)}};r.prototype.onAfterRendering=function(){this.initItemNavigation();for(var e=0;e<this.aRBs.length;e++){this.aRBs[e].getDomRef().setAttribute("aria-posinset",e+1);this.aRBs[e].getDomRef().setAttribute("aria-setsize",this.aRBs.length)}};r.prototype.initItemNavigation=function(){var e=[];this._aActiveItems=[];var t=this._aActiveItems;var i=false;for(var a=0;a<this.aRBs.length;a++){t[e.length]=a;e.push(this.aRBs[a].getDomRef());if(!i&&this.aRBs[a].getEnabled()){i=true}}if(i){i=this.getEnabled()}if(!i){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}return}if(!this.oItemNavigation){this.oItemNavigation=new s;this.oItemNavigation.attachEvent(s.Events.AfterFocus,this._handleAfterFocus,this);this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(this.getDomRef());this.oItemNavigation.setItemDomRefs(e);this.oItemNavigation.setCycling(true);this.oItemNavigation.setColumns(this.getColumns());this.oItemNavigation.setSelectedIndex(this.getSelectedIndex());this.oItemNavigation.setFocusedIndex(this.getSelectedIndex())};r.prototype.setSelectedIndex=function(t){var i=this.getSelectedIndex();if(t<0){e.warning("Invalid index, will not be changed");return this}this.setProperty("selectedIndex",t,true);if(!isNaN(i)&&this.aRBs&&this.aRBs[i]){this.aRBs[i].setSelected(false)}if(this.aRBs&&this.aRBs[t]){this.aRBs[t].setSelected(true)}if(this.oItemNavigation){this.oItemNavigation.setSelectedIndex(t);this.oItemNavigation.setFocusedIndex(t)}return this};r.prototype.setSelectedItem=function(e){for(var t=0;t<this.getItems().length;t++){if(e.getId()==this.getItems()[t].getId()){this.setSelectedIndex(t);break}}};r.prototype.getSelectedItem=function(){return this.getItems()[this.getSelectedIndex()]};r.prototype.addItem=function(e){this.myChange=true;this.addAggregation("items",e);e.attachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this._bUpdateItems){if(this.getSelectedIndex()===undefined){this.setSelectedIndex(0)}}if(!this.aRBs){this.aRBs=[]}var t=this.aRBs.length;this.aRBs[t]=this.createRadioButton(e,t);return this};r.prototype.insertItem=function(e,t){this.myChange=true;this.insertAggregation("items",e,t);e.attachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this.aRBs){this.aRBs=[]}var i=this.aRBs.length;if(!this._bUpdateItems){if(this.getSelectedIndex()===undefined||i==0){this.setSelectedIndex(0)}else if(this.getSelectedIndex()>=t){this.setProperty("selectedIndex",this.getSelectedIndex()+1,true)}}if(t>=i){this.aRBs[t]=this.createRadioButton(e,t)}else{for(var s=i;s>t;s--){this.aRBs[s]=this.aRBs[s-1];if(s-1==t){this.aRBs[s-1]=this.createRadioButton(e,t)}}}return this};r.prototype.createRadioButton=function(e,t){if(this.iIDCount==undefined){this.iIDCount=0}else{this.iIDCount++}var i=new a(this.getId()+"-"+this.iIDCount);i.setText(e.getText());i.setTooltip(e.getTooltip());if(this.getEnabled()){i.setEnabled(e.getEnabled())}else{i.setEnabled(false)}i.setKey(e.getKey());i.setTextDirection(e.getTextDirection());i.setEditable(this.getEditable());i.setGroupName(this.getId());i.setValueState(this.getValueState());i.setParent(this);if(t==this.getSelectedIndex()){i.setSelected(true)}i.attachEvent("select",this.handleRBSelect,this);return i};r.prototype.removeItem=function(e){var t=e;if(typeof e=="string"){e=sap.ui.getCore().byId(e)}if(typeof e=="object"){t=this.indexOfItem(e)}this.myChange=true;var i=this.removeAggregation("items",t);i.detachEvent("_change",this._handleItemChanged,this);this.myChange=undefined;if(!this.aRBs){this.aRBs=[]}if(!this.aRBs[t]){return null}this.aRBs[t].destroy();this.aRBs.splice(t,1);if(!this._bUpdateItems){if(this.aRBs.length==0){this.setSelectedIndex(undefined)}else if(this.getSelectedIndex()==t){this.setSelectedIndex(0)}else if(this.getSelectedIndex()>t){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true)}}return i};r.prototype.removeAllItems=function(){this.myChange=true;var e=this.removeAllAggregation("items");for(var t=0;t<e.length;t++){e[t].detachEvent("_change",this._handleItemChanged,this)}this.myChange=undefined;if(!this._bUpdateItems){this.setSelectedIndex(undefined)}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1)}return e}else{return null}};r.prototype.destroyItems=function(){this.myChange=true;var e=this.getItems();for(var t=0;t<e.length;t++){e[t].detachEvent("_change",this._handleItemChanged,this)}this.destroyAggregation("items");this.myChange=undefined;if(!this._bUpdateItems){this.setSelectedIndex(undefined)}if(this.aRBs){while(this.aRBs.length>0){this.aRBs[0].destroy();this.aRBs.splice(0,1)}}return this};r.prototype.updateItems=function(){var e=this.getSelectedIndex();this._bUpdateItems=true;this.updateAggregation("items");this._bUpdateItems=undefined;var t=this.getItems();if(e===undefined&&t.length>0){this.setSelectedIndex(0)}else if(e>=0&&t.length==0){this.setSelectedIndex(undefined)}else if(e>=t.length){this.setSelectedIndex(t.length-1)}};r.prototype.clone=function(){var e=this.getItems();var t=0;for(t=0;t<e.length;t++){e[t].detachEvent("_change",this._handleItemChanged,this)}var s=i.prototype.clone.apply(this,arguments);for(t=0;t<e.length;t++){e[t].attachEvent("_change",this._handleItemChanged,this)}return s};r.prototype.handleRBSelect=function(e){for(var t=0;t<this.aRBs.length;t++){if(this.aRBs[t].getId()==e.getParameter("id")){this.setSelectedIndex(t);this.oItemNavigation.setSelectedIndex(t);this.oItemNavigation.setFocusedIndex(t);this.fireSelect({selectedIndex:t});break}}};r.prototype.setEditable=function(e){this.setProperty("editable",e,false);if(this.aRBs){for(var t=0;t<this.aRBs.length;t++){this.aRBs[t].setEditable(e)}}return this};r.prototype.setEnabled=function(e){this.setProperty("enabled",e,false);if(this.aRBs){for(var t=0;t<this.aRBs.length;t++){this.aRBs[t].setEnabled(e)}}return this};r.prototype.setValueState=function(e){this.setProperty("valueState",e,false);if(this.aRBs){for(var t=0;t<this.aRBs.length;t++){this.aRBs[t].setValueState(e)}}return this};r.prototype._handleAfterFocus=function(e){var t=e.getParameter("index");var i=e.getParameter("event");if(t!=this.getSelectedIndex()&&!(i.ctrlKey||i.metaKey)&&this.aRBs[t].getEditable()&&this.aRBs[t].getEnabled()){this.setSelectedIndex(t);this.oItemNavigation.setSelectedIndex(t);this.fireSelect({selectedIndex:t})}};r.prototype._handleItemChanged=function(e){var t=e.oSource;var i=e.getParameter("name");var s=e.getParameter("newValue");var a=this.getItems();var n;for(var h=0;h<a.length;h++){if(a[h]==t){if(this.aRBs[h]){n=this.aRBs[h]}break}}switch(i){case"text":n.setText(s);break;case"tooltip":n.setTooltip(s);break;case"enabled":if(this.getEnabled()){n.setEnabled(s)}break;case"key":n.setKey(s);break;case"textDirection":n.setTextDirection(s);break;default:break}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RadioButtonGroupRenderer", ["sap/ui/core/library"],function(t){"use strict";var e=t.ValueState;var i={};i.render=function(t,i){if(!i.aRBs){return}var a=i.getColumns();var r=i.getEnabled();if(r){var s=i.getItems();r=false;for(var l=0;l<s.length;l++){if(s[l].getEnabled()){r=true;break}}}t.write("<div");t.writeControlData(i);t.addClass("sapUiRbG");if(a>1){if(a==i.aRBs.length){t.addClass("sapUiRbG1Row")}else{t.addClass("sapUiRbGTab");if(i.getWidth()&&i.getWidth()!=""){t.addClass("sapUiRbGTabFlex")}}}if(i.getWidth()&&i.getWidth()!=""){t.addStyle("width",i.getWidth())}if(i.getTooltip_AsString()){t.writeAttributeEscaped("title",i.getTooltip_AsString())}if(r){t.writeAttribute("tabindex","0")}else{t.writeAttribute("tabindex","-1")}t.writeAccessibilityState(i,{role:"radiogroup",invalid:i.getValueState()==e.Error,disabled:!i.getEditable()});t.writeClasses();t.writeStyles();t.write(">");for(var d=0;d<a;d++){if(a>1&&a!=i.aRBs.length){t.write("<div");t.addClass("sapUiRbGCol");t.writeClasses();t.write(">")}for(var l=d;l<i.aRBs.length;l=l+a){t.renderControl(i.aRBs[l])}if(a>1&&a!=i.aRBs.length){t.write("</div>")}}if(a>1&&a!=i.aRBs.length){t.write('<div class="sapUiRbGDummy"> </DIV>')}t.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RadioButtonRenderer", ["sap/ui/core/ValueStateSupport","sap/ui/core/library"],function(e,t){"use strict";var i=t.TextDirection;var a=t.ValueState;var r={};r.render=function(t,i){var r=i.getId();var d=i.getTooltip_AsString();t.addClass("sapUiRb");t.write("<span");t.writeControlData(i);t.writeAccessibilityState(i,{role:"radio",checked:i.getSelected()===true,invalid:i.getValueState()==a.Error,disabled:!i.getEditable(),labelledby:r+"-label",describedby:d?r+"-Descr":undefined});var s=i.getEnabled()!=null&&i.getEnabled();var l=i.getEditable()!=null&&i.getEditable();var n=false;var c=false;if(i.getValueState()!=null){n=a.Error==i.getValueState();c=a.Warning==i.getValueState()}if(i.getSelected()){t.addClass("sapUiRbSel")}var b=0;var u=false;if(!s){b=-1;u=true;t.addClass("sapUiRbDis")}if(!l){u=true;t.addClass("sapUiRbRo")}if(n){t.addClass("sapUiRbErr")}else if(c){t.addClass("sapUiRbWarn")}if(s&&l&&!n&&!c){t.addClass("sapUiRbStd")}if(s&&l){t.addClass("sapUiRbInteractive")}t.writeClasses();if(i.getWidth()&&i.getWidth()!=""){t.writeAttribute("style","width:"+i.getWidth()+";")}t.writeAttribute("tabindex",b);var w=e.enrichTooltip(i,d?d:i.getText());if(w){t.writeAttributeEscaped("title",w)}t.write(">");t.write("<input type='radio' tabindex='-1' id='");t.write(r);t.write("-RB' name=\"");t.writeEscaped(i.getGroupName());t.write('" ');if(i.getSelected()){t.write(" checked='checked'")}if(!s){t.write(" disabled='disabled'")}if(u){t.write(" readonly='readonly'");t.write(" disabled='disabled'")}if(i.getKey()){t.writeAttributeEscaped("value",i.getKey())}t.write(">");t.write('<label id="'+r+'-label"');t.writeAttribute("for",r+"-RB");if(!i.getText()){t.write(' class="sapUiRbNoText"')}t.write(">");if(i.getText()){this.renderText(t,i.getText(),i.getTextDirection())}t.write("</label>");if(d){t.write('<span id="'+r+'-Descr" style="visibility: hidden; display: none;">');t.writeEscaped(d);t.write("</span>")}t.write("</span>")};r.renderText=function(e,t,a){if(!a||a==i.Inherit){e.writeEscaped(t)}else{e.write('<span style="direction:'+a.toLowerCase()+';">');e.writeEscaped(t);e.write("</span>")}};r.setSelected=function(e,t){e.$().toggleClass("sapUiRbSel",t).attr("aria-checked",t);var i=e.getDomRef("RB");if(t){i.checked=true;i.setAttribute("checked","checked")}else{i.checked=false;i.removeAttribute("checked")}};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RangeSlider", ["./Slider","./library","./RangeSliderRenderer"],function(t,i,e){"use strict";var s=t.extend("sap.ui.commons.RangeSlider",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{value2:{type:"float",group:"Appearance",defaultValue:80}}}});s.prototype.onAfterRendering=function(){this.oGrip2=this.getDomRef("grip2");t.prototype.onAfterRendering.apply(this);var i=this.getValue();var e=this.getValue2();if(e>=this.getMax()){e=this.getMax()}else if(e<i){e=i}var s=(e-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){s=this.getBarWidth()-s}this.changeGrip(e,s,this.oGrip2)};s.prototype.onresize=function(i){var e=this.getValue2();var s=(e-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){s=this.getBarWidth()-s}this.changeGrip(e,s,this.oGrip2);t.prototype.onresize.apply(this,arguments)};s.prototype.onfocusin=function(t){this.oMovingGrip=t.target};s.prototype.onsaphome=function(t){if(this.getEditable()&&this.getEnabled()){var i=0;var e=0;if(this.oMovingGrip==this.oGrip){i=this.getMin();if(this.getVertical()||this.bRtl&&!this.getVertical()){e=this.getBarWidth()}}else if(this.oMovingGrip==this.oGrip2){i=this.getValue();e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};s.prototype.onsapend=function(t){if(this.getEditable()&&this.getEnabled()){var i=0;var e=0;if(this.oMovingGrip==this.oGrip){i=this.getValue2();e=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}else if(this.oMovingGrip==this.oGrip2){i=this.getMax();if(this.getVertical()||this.bRtl&&!this.getVertical()){e=0}else{e=this.getBarWidth()}}this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};s.prototype.fireLiveChangeForGrip=function(t,i,e){if(t==this.oGrip){if(e!=i){this.fireLiveChange({value:i,value2:this.getValue2()})}}else if(t==this.oGrip2){if(e!=i){this.fireLiveChange({value2:i,value:this.getValue()})}}};s.prototype.adjustHighlightBar=function(t,i){if(t<0||isNaN(t)){t=0}var e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;var s=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;var h;if(this.getVertical()){this.setLeft(s,this.oHiLi);this.setRight(this.getBarWidth()-e,this.oHiLi);h=Math.round(e-s)}else{if(this.bRtl){this.setLeft(s,this.oHiLi);this.setRight(this.getBarWidth()-e,this.oHiLi)}else{this.setLeft(e,this.oHiLi);this.setRight(this.getBarWidth()-s,this.oHiLi)}h=Math.abs(Math.round(s-e))}if(h<0){h=0}this.setObjectWidth(h+"px",this.oHiLi)};s.prototype.setRight=function(t,i){if(i==undefined){return}if(this.getVertical()){i.style.bottom=t+"px"}else{i.style.right=t+"px"}};s.prototype.updateValueProperty=function(t,i){if(i==this.oGrip){this.setProperty("value",t,true)}else{this.setProperty("value2",t,true)}};s.prototype.setValue=function(t){this.setProperty("value",t,true);this._oldValue1=t;if(isNaN(t)){return this}if(!this.oBar){return this}var i=parseFloat(t);var e;if(i>=this.getValue2()){i=this.getValue2();e=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}}else if(i<=this.getMin()){i=this.getMin();if(this.getVertical()){e=this.getBarWidth()}else{e=0}}else{e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth()}if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}this.changeGrip(i,e,this.oGrip);this._oldValue1=i;return this};s.prototype.setValue2=function(t){this.setProperty("value2",t,true);this._oldValue2=t;if(isNaN(t)){return this}if(!this.oBar){return this}var i=parseFloat(t);var e;if(i>=this.getMax()){i=this.getMax();if(this.getVertical()){e=0}else{e=this.getBarWidth()}}else if(i<=this.getValue()){i=this.getValue();e=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}}else{e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth()}if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}this.changeGrip(i,e,this.oGrip2);this._oldValue2=i;return this};s.prototype.getLeftGrip=function(){return this.oGrip};s.prototype.getRightGrip=function(){return this.oGrip2};s.prototype.getValueForGrip=function(t){if(t==this.oGrip){return this.getValue()}else{return this.getValue2()}};s.prototype.validateNewPosition=function(t,i,e,s){if(!this.bRtl&&!this.getVertical()){if(e==this.oGrip){if(s){if(t<=this.getMin()||i<=0){t=this.getMin();i=0}}else{if(t>=this.getValue2()){t=this.getValue2();i=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}}}else{if(s){if(t<=this.getValue()){t=this.getValue();i=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}}else{if(t>=this.getMax()||i>=this.getBarWidth()){t=this.getMax();i=this.getBarWidth()}}}}else{if(e==this.oGrip){if(s){if(t<=this.getMin()||i>=this.getBarWidth()){t=this.getMin();i=this.getBarWidth()}}else{if(t>=this.getValue2()){t=this.getValue2();i=this.getOffsetLeft(this.oGrip2)+this.iShiftGrip}}}else{if(s){if(t<=this.getValue()){t=this.getValue();i=this.getOffsetLeft(this.oGrip)+this.iShiftGrip}}else{if(t>=this.getMax()||i<=0){t=this.getMax();i=0}}}}this.oGrip.setAttribute("aria-valuemax",this.getValue2());this.oGrip2.setAttribute("aria-valuemin",this.getValue());return{fNewValue:t,iNewPos:i}};s.prototype.handleMove=function(i){var e=Math.abs(this.getOffsetLeft(this.oGrip2)-this.getOffsetLeft(this.oGrip));if(!this.bRtl){if(this.oMovingGrip==this.oGrip2&&this.getValue2()==this.getMax()&&e<2){this.oMovingGrip=this.oGrip;this.oGrip.focus()}else if(this.oMovingGrip==this.oGrip&&this.getValue()==this.getMin()&&e<2){this.oMovingGrip=this.oGrip2;this.oGrip2.focus()}}else{if(this.oMovingGrip==this.oGrip&&this.getValue2()==this.getMin()&&e<2){this.oMovingGrip=this.oGrip2;this.oGrip2.focus()}else if(this.oMovingGrip==this.oGrip2&&this.getValue()==this.getMax()&&e<2){this.oMovingGrip=this.oGrip;this.oGrip.focus()}}t.prototype.handleMove.apply(this,[i])};s.prototype.handleFireChange=function(t){var i=this.getValue();var e=this.getValue2();if(i!==this._oldValue1||e!==this._oldValue2){this._oldValue1=i;this._oldValue2=e;this.fireChange({value2:e,value:i});if(!t){this.fireLiveChange({value:i,value2:e})}}};s.prototype.getNearestGrip=function(t){var i;var e=0;var s=0;if(this.getVertical()){e=Math.abs(t-this.getOffsetLeft(this.oGrip2));s=Math.abs(this.getOffsetLeft(this.oGrip)-t);if(e==s){if(t>s){i=this.oGrip}else{i=this.oGrip2}}else if(e>=s){i=this.oGrip}else{i=this.oGrip2}}else{e=Math.abs(t-this.getOffsetLeft(this.oGrip));s=Math.abs(this.getOffsetLeft(this.oGrip2)-t);if(e==s){if(t>s&&!this.bRtl||t<s&&this.bRtl){i=this.oGrip2}else{i=this.oGrip}}else if(e<=s){i=this.oGrip}else{i=this.oGrip2}}return i};s.prototype.setObjectWidth=function(t,i){if(this.getVertical()){i.style.height=t}else{i.style.width=t}};s.prototype.targetIsGrip=function(t){if(t==this.oGrip.id||t==this.oGrip2.id){return true}return false};s.prototype.setAriaState=function(){t.prototype.setAriaState.apply(this);var i=this.getValue2();if(this.bTextLabels){i=this.getNearestLabel(i)}this.oGrip2.setAttribute("aria-valuenow",i)};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RangeSliderRenderer", ["./SliderRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var i=t.extend(e);i.renderGrip=function(e,t){e.write("<div");e.writeAttribute("id",t.getId()+"-grip");if(t.getEnabled()){e.writeAttribute("tabindex","0")}else{e.writeAttribute("tabindex","-1")}e.writeAttribute("class","sapUiSliGrip");e.writeAttribute("title",t.getValue());e.writeAccessibilityState(t,{role:"slider",controls:t.getId()+"-grip2",orientation:"horizontal",valuemin:t.getMin(),valuemax:t.getValue2(),live:"assertive",disabled:!t.getEditable()||!t.getEnabled(),describedby:t.getTooltip_AsString()?t.getId()+"-Descr "+t.getAriaDescribedBy().join(" "):undefined});e.write(">&#9650;</div>");e.write("<div");e.writeAttribute("id",t.getId()+"-grip2");if(t.getEnabled()){e.writeAttribute("tabindex","0")}else{e.writeAttribute("tabindex","-1")}e.writeAttribute("class","sapUiSliGrip");e.writeAttribute("title",t.getValue2());var i="horizontal";if(t.getVertical()){i="vertical"}e.writeAccessibilityState(t,{role:"slider",controls:t.getId()+"-grip",orientation:i,valuemin:t.getValue(),valuemax:t.getMax(),disabled:!t.getEditable()||!t.getEnabled(),describedby:t.getTooltip_AsString()?t.getId()+"-Descr "+t.getAriaDescribedBy().join(" "):undefined});e.write(">&#9650;</div>")};i.controlAdditionalCode=function(e,t){e.addClass("sapUiRSli")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RatingIndicator", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RatingIndicatorRenderer","sap/ui/events/checkMouseEnterOrLeave"],function(jQuery,e,t,a,i){"use strict";var r=e.RatingIndicatorVisualMode;var o=t.extend("sap.ui.commons.RatingIndicator",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{editable:{type:"boolean",group:"Behavior",defaultValue:true},maxValue:{type:"int",group:"Behavior",defaultValue:5},value:{type:"float",group:"Behavior",defaultValue:0,bindable:"bindable"},averageValue:{type:"float",group:"Behavior",defaultValue:0},iconSelected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconUnselected:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null},visualMode:{type:"sap.ui.commons.RatingIndicatorVisualMode",group:"Behavior",defaultValue:r.Half}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"int"}}}}}});o.NoValue=-9999;o.prototype.init=function(){this.iHoveredRating=-1};o.prototype.exit=function(){};o.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};o.prototype.ondragstart=function(e){e.preventDefault()};o.prototype._getDisplayValue=function(){var e=this.getValue();if(e==o.NoValue){return this.getAverageValue()}else{return e}};o.prototype.onsapincrease=function(e){var t=this.iHoveredRating;if(t==-1){t=Math.round(this._getDisplayValue())-1;if(t==-1){t=0}}if(t<this.getMaxValue()){t=t+1}else{t=this.getMaxValue()}this.updateHoverState(e,t)};o.prototype.onsapdecrease=function(e){var t=this.iHoveredRating;if(t==-1&&Math.round(this._getDisplayValue())==0){return}if(t==-1){t=Math.round(this._getDisplayValue())+1}if(t>1){t=t-1}else{t=1}this.updateHoverState(e,t)};o.prototype.onsaphome=function(e){this.updateHoverState(e,1)};o.prototype.onsapend=function(e){this.updateHoverState(e,this.getMaxValue())};o.prototype.onsapselect=function(e){this.saveValue(e,true,this.iHoveredRating)};o.prototype.onsapescape=function(e){this.saveValue(e,true,-1)};o.prototype.onfocusout=function(e){this.saveValue(e,false,this.iHoveredRating)};o.prototype.onclick=function(e){this.saveValue(e,true,this.getSymbolValue(e))};o.prototype.onmouseover=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}this.iHoveredRating=-1;var t=this.getSymbolValue(e);if(t==-1){return}for(var i=1;i<=t;i++){a.hoverRatingSymbol(i,this)}for(var i=t+1;i<=this.getMaxValue();i++){a.hoverRatingSymbol(i,this,true)}};o.prototype.onmouseout=function(e){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}if(i(e,this.getDomRef())){this.iHoveredRating=-1;for(var t=1;t<=this.getMaxValue();t++){a.unhoverRatingSymbol(t,this)}}};o.prototype.getSymbolValue=function(e){var t=jQuery(e.target);if(t.hasClass("sapUiRatingItmImg")||t.hasClass("sapUiRatingItmOvrflw")){t=jQuery(e.target.parentNode)}else if(t.hasClass("sapUiRatingItmOvrflwImg")){t=jQuery(e.target.parentNode.parentNode)}var a=t.attr("itemvalue");if(a){return parseInt(a)}return-1};o.prototype.updateKeyboardHoverState=function(e){for(var t=1;t<=this.getMaxValue();t++){a.unhoverRatingSymbol(t,this);if(t<=this.iHoveredRating){a.hoverRatingSymbol(t,this)}else if(!e){a.hoverRatingSymbol(t,this,true)}}this.setAriaState()};o.prototype.onAfterRendering=function(){this.setAriaState()};o.prototype.setAriaState=function(){var e=this.iHoveredRating==-1?this._getDisplayValue():this.iHoveredRating;this.$().attr("aria-valuenow",e).attr("aria-valuetext",this._getText("RATING_ARIA_VALUE",[e])).attr("aria-label",this._getText("RATING_ARIA_NAME"))};o.prototype._getText=function(e,t){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(a){return a.getText(e,t)}return e};o.prototype.saveValue=function(e,t,i){if(t){e.preventDefault()}if(!this.getEditable()){return false}this.iHoveredRating=-1;if(i!=-1&&i!=this.getValue()){this.setValue(i);this.fireChange({value:i});return true}else{for(var r=1;r<=this.getMaxValue();r++){a.unhoverRatingSymbol(r,this)}this.setAriaState();return false}};o.prototype.updateHoverState=function(e,t){e.preventDefault();e.stopPropagation();if(!this.getEditable()){return}this.iHoveredRating=t;this.updateKeyboardHoverState()};o.prototype.setMaxValue=function(e){if(e<1){e=1}this.setProperty("maxValue",e);return this};o.prototype.getAccessibilityInfo=function(){var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");return{role:"slider",type:e.getText("ACC_CTR_TYPE_RATING"),description:e.getText("ACC_CTR_STATE_RATING",[this._getDisplayValue(),this.getMaxValue()]),focusable:true,editable:this.getEditable()}};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RatingIndicatorRenderer", ["sap/ui/core/theming/Parameters"],function(t){"use strict";var e=function(){};e.render=function(t,i){var r=i.getMaxValue();t.write("<div");t.writeControlData(i);t.addClass("sapUiRating");if(i.getEditable()){t.addClass("sapUiRatingEdit")}t.writeClasses();t.writeAttribute("tabindex","0");if(i.getTooltip()&&i.getTooltip_AsString()){t.writeAttributeEscaped("title",i.getTooltip_AsString())}else if(!i.getEditable()){t.writeAttribute("title",i._getDisplayValue())}t.writeAccessibilityState(i,{role:"slider",orientation:"horizontal",valuemin:1,valuemax:r,disabled:!i.getEditable(),live:"assertive"});t.write(">");for(var a=0;a<r;a++){e.renderItem(t,i,a,i._getDisplayValue())}t.write("</div>")};e.renderItem=function(t,i,r,a){var l=r+1;t.write("<div");t.writeAttribute("id",i.getId()+"-itm-"+l);t.writeAttribute("itemvalue",l);t.writeAttribute("class","sapUiRatingItm");t.writeAttribute("style","line-height:0px;");if(!i.getTooltip()&&i.getEditable()){t.writeAttributeEscaped("title",i._getText("RATING_TOOLTIP",[l,i.getMaxValue()]))}t.write(">");t.write("<img");t.writeAttribute("class","sapUiRatingItmImg");var s=e.getThemeSymbol("selected",i);t.writeAttributeEscaped("src",s);t.write(">");t.write("<div");t.writeAttribute("class","sapUiRatingItmOvrflw");var n=i.getVisualMode();if(n=="Full"){a=Math.round(a)}var o;if(a>=l){o="width:0%;"}else if(a<r){o="width:100%;"}else{var d=a-r;if(n=="Half"){var g=50;if(d<.25){g=100}if(d>=.75){g=0}o="width:"+g+"%;"}else{o="width:"+(100-Math.round(d*100))+"%;"}}t.writeAttribute("style",o);t.write(">");t.write("<img");t.writeAttribute("class","sapUiRatingItmOvrflwImg");s=e.getThemeSymbol("unselected",i);t.writeAttributeEscaped("src",s);t.write(">");t.write("</div>");t.write("</div>")};e.hoverRatingSymbol=function(t,i,r){var a=i.$("itm-"+t);a.addClass("sapUiRatingItmHov");var l=a.children("img");var s=e.getThemeSymbol(r?"unselected":"hover",i);l.attr("src",s)};e.unhoverRatingSymbol=function(t,i){var r=i.$("itm-"+t);r.removeClass("sapUiRatingItmHov");var a=r.children("img");var l=e.getThemeSymbol("selected",i);a.attr("src",l)};e.getThemeSymbol=function(e,i){var r,a;if(e=="selected"){r=i.getIconSelected();a="_sap_ui_commons_RatingIndicator_SymbolSelected"}else if(e=="unselected"){r=i.getIconUnselected();a="_sap_ui_commons_RatingIndicator_SymbolUnselected"}else{r=i.getIconHovered();a="_sap_ui_commons_RatingIndicator_SymbolHovered"}if(!r){r=t._getThemeImage(a)}return r};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ResponsiveContainer", ["./library","sap/ui/core/Control","sap/ui/core/ResizeHandler","./ResponsiveContainerRenderer"],function(e,t,i,n){"use strict";var s=t.extend("sap.ui.commons.ResponsiveContainer",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},aggregations:{ranges:{type:"sap.ui.commons.ResponsiveContainerRange",multiple:true,singularName:"range"},content:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{defaultContent:{type:"sap.ui.core.Control",multiple:false}},events:{rangeSwitch:{parameters:{currentRange:{type:"sap.ui.commons.ResponsiveContainerRange"}}}}}});s.prototype.init=function(){this.oCurrentRange=null};s.prototype.exit=function(){if(this.sResizeListenerId){i.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};s.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){i.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(!this.getAggregation("content")){var e=sap.ui.getCore().byId(this.getDefaultContent());this.setAggregation("content",e)}};s.prototype.onAfterRendering=function(){var e=this.onresize.bind(this);this.sResizeListenerId=i.register(this.getDomRef(),e);this.refreshRangeDimensions();if(!this.oCurrentRange){setTimeout(e,0)}};s.prototype.onresize=function(e){var t=this.findMatchingRange(),i=t&&t.getContent(),n;if(this.oCurrentRange!=t){this.oCurrentRange=t;if(!t){i=this.getDefaultContent()}n=sap.ui.getCore().byId(i);this.setAggregation("content",n);this.fireRangeSwitch({currentRange:this.oCurrentRange})}};s.prototype.refreshRangeDimensions=function(){var e=this.getRanges(),t=[],i;e.forEach(function(e){i=e.$();t.push({range:e,width:i.width(),height:i.height()})});this.aRangeDimensions=t};s.prototype.findMatchingRange=function(){var e=this.$(),t=e.width(),i=e.height(),n,s,r=this.aRangeDimensions,o=null;r.forEach(function(e){n=e.width||t;s=e.height||i;if(n<=t&&s<=i){e.area=n*s;if(!o||o.area<e.area){o=e}}});return o&&o.range};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ResponsiveContainerRange", ["./library","sap/ui/core/Element"],function(e,i){"use strict";var t=i.extend("sap.ui.commons.ResponsiveContainerRange",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:""},key:{type:"string",group:"Misc",defaultValue:""}},associations:{content:{type:"sap.ui.core.Control",multiple:false}}}});return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ResponsiveContainerRenderer", [],function(){"use strict";var t=function(){};t.render=function(t,e){var i=e.getAggregation("content");t.write("<div ");t.writeControlData(e);t.addStyle("width",e.getWidth());t.addStyle("height",e.getHeight());t.writeStyles();t.write(">");if(i){t.renderControl(i)}t.write("<div ");t.addStyle("width","0px");t.addStyle("height","0px");t.addStyle("overflow","hidden");t.writeStyles();t.write(">");e.getRanges().forEach(function(e){t.write("<div ");t.writeElementData(e);t.addStyle("width",e.getWidth());t.addStyle("height",e.getHeight());t.writeStyles();t.write("></div>")});t.write("</div>");t.write("</div>")};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RichTooltip", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/TooltipBase","./RichTooltipRenderer","./FormattedTextView","sap/ui/dom/jquery/control"],function(jQuery,t,e,i,a){"use strict";var r=e.extend("sap.ui.commons.RichTooltip",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{title:{type:"string",group:"Misc",defaultValue:null},imageSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},valueStateText:{type:"string",group:"Misc",defaultValue:null},imageAltText:{type:"string",group:"Misc",defaultValue:null}},aggregations:{formattedText:{type:"sap.ui.commons.FormattedTextView",multiple:false,visibility:"hidden"},individualStateText:{type:"sap.ui.commons.FormattedTextView",multiple:false,visibility:"hidden"}}}});r.prototype.onAfterRendering=function(){var t=this.getAggregation("formattedText");if(t&&t.getDomRef()){t.$().attr("role","tooltip");if(this.getImageSrc()!==""){this.$().addClass("sapUiRttContentWide")}}};r.prototype.setValueStateText=function(t){var e=this.getAggregation("individualStateText");if(t){if(e){e.setHtmlText(t)}else{e=new a(this.getId()+"-valueStateText",{htmlText:t}).addStyleClass("sapUiRttValueStateText").addStyleClass("individual");this.setAggregation("individualStateText",e);this.setProperty("valueStateText",t,true)}}else{if(e){this.setAggregation("individualStateText",e)}}return this};r.prototype.getValueStateText=function(){var t=this.getAggregation("individualStateText");if(t){return t.getHtmlText()}return""};r.prototype.setText=function(t){if(t){t=t.replace(/(\r\n|\n|\r)/g,"<br>")}var e=this.getAggregation("formattedText");if(e){e.setHtmlText(t)}else{e=new a(this.getId()+"-txt");e.setHtmlText(t);e.addStyleClass("sapUiRttText");this.setAggregation("formattedText",e);this.setProperty("text",t,true)}return this};r.prototype.getText=function(){var t=this.getAggregation("formattedText");if(t){return t.getHtmlText()}return""};r.prototype.onfocusin=function(t){e.prototype.onfocusin.apply(this,arguments);var i=jQuery(t.target).control(0);if(i!=null){var a=this.getId();var r="";if(this.getTitle()!==""){r+=a+"-title "}var s=this.$("valueStateText");if(s.length>0){r+=a+"-valueStateText "}if(this.getImageSrc()!==""){r+=a+"-image "}if(this.getText()!==""){r+=a+"-txt"}var o=i.getFocusDomRef();o.setAttribute("aria-describedby",r)}};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RichTooltipRenderer", ["sap/ui/core/ValueStateSupport","sap/ui/core/library","sap/ui/core/Configuration"],function(t,i,e){"use strict";var a=i.ValueState;var r={};r.render=function(i,r){var s=r.getId();i.write("<div ");i.writeControlData(r);i.addClass("sapUiRtt");i.writeClasses();i.write(" ><div><div>");i.write("<div class='sapUiRttTopL'></div><div class='sapUiRttTopR'></div>");i.write("<div class='sapUiRttCL'>");i.write("<div class='sapUiRttCR'>");i.write("<div class='sapUiRttContent'>");var d=r.getTitle();if(d){i.write("<div id='"+s+"-title' role='tooltip' class='sapUiRttTitle'>");i.writeEscaped(d);i.write("</div>");i.write("<div class='sapUiRttSep'></div>")}var v=t.getAdditionalText(r.getParent());var l=r.getAggregation("individualStateText");if(v||l){i.write('<div class="sapUiRttValueStateContainer">');if(v){var p=r.getParent().getValueState();var o=p!==a.None?"ValueState_"+p+".png":"";if(o!==""){o=sap.ui.require.toUrl("sap/ui/commons/themes/"+e.getTheme()+"/img/richtooltip/"+o);i.write('<img id="'+s+'-valueStateImage" class="sapUiRttValueStateImage" src="');i.writeEscaped(o);i.write('">')}}if(l){i.renderControl(l)}else{i.write('<div id="'+s+'-valueStateText" class="sapUiRttValueStateText">');i.writeEscaped(v);i.write("</div>")}i.write("</div>");i.write("<div class='sapUiRttSep'></div>")}i.write('<div class="sapUiRttContentContainer">');var c=r.getImageSrc();if(c){var n=r.getImageAltText();i.write('<img id="'+s+'-image" class="sapUiRttImage"');i.writeAttributeEscaped("alt",n);i.writeAttributeEscaped("src",c);i.write(">")}var w=r.getAggregation("formattedText");if(w){i.renderControl(w)}i.write("</div>");i.write("</div></div></div>");i.write("<div class='sapUiRttBotL'></div>");i.write("<div class='sapUiRttBotR'></div>");i.write("</div></div></div>")};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RoadMap", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RoadMapRenderer","sap/ui/core/ResizeHandler","sap/ui/Device"],function(jQuery,e,t,i,s,r){"use strict";var n=t.extend("sap.ui.commons.RoadMap",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{numberOfVisibleSteps:{type:"int",group:"Misc",defaultValue:null},firstVisibleStep:{type:"string",group:"Misc",defaultValue:null},selectedStep:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},defaultAggregation:"steps",aggregations:{steps:{type:"sap.ui.commons.RoadMapStep",multiple:true,singularName:"step"}},events:{stepSelected:{parameters:{stepId:{type:"string"}}},stepExpanded:{parameters:{stepId:{type:"string"}}}}}});(function(){n.prototype.init=function(){this.iStepWidth=-1;this.sCurrentFocusedStepRefId=null};n.prototype.exit=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};n.prototype.setNumberOfVisibleSteps=function(e){var t=this.getDomRef()?true:false;this.setProperty("numberOfVisibleSteps",e,t);if(t){i.updateScrollArea(this,true)}return this};n.prototype.setFirstVisibleStep=function(e){var t=this.getDomRef()?true:false;if(t){if(e){var s=sap.ui.getCore().byId(e);if(s&&s.getParent()&&(s.getParent()===this||s.getParent().getParent()===this)&&s.getVisible()){this.setProperty("firstVisibleStep",e,true);i.updateScrollArea(this)}}else{this.setProperty("firstVisibleStep","",true);i.updateScrollArea(this)}}else{this.setProperty("firstVisibleStep",e)}return this};n.prototype.setWidth=function(e){var t=this.getDomRef()?true:false;this.setProperty("width",e,t);if(t){i.setRoadMapWidth(this,e);i.updateScrollArea(this,true)}return this};n.prototype.setSelectedStep=function(e){var t=this.getDomRef()?true:false;if(t){if(e){var s=sap.ui.getCore().byId(e);if(s&&s.getParent()&&(s.getParent()===this||s.getParent().getParent()===this)&&s.getEnabled()&&s.getVisible()){i.selectStepWithId(this,e);this.setProperty("selectedStep",e,true)}}else{i.selectStepWithId(this,"");this.setProperty("selectedStep","",true)}}else{this.setProperty("selectedStep",e)}return this};n.prototype.onThemeChanged=function(e){this.iStepWidth=-1;if(this.getDomRef()){this.invalidate()}};n.prototype.doBeforeRendering=function(){var e=false;var t=false;var i=this.getSteps();for(var r=0;r<i.length;r++){var n=i[r];if(n.getSubSteps().length==0||!n.getEnabled()){n.setProperty("expanded",false,true)}if(!n.getEnabled()&&!n.getVisible()&&this.getSelectedStep()==n.getId()){this.setProperty("selectedStep","",true)}else if(n.getEnabled()&&n.getVisible()&&this.getSelectedStep()==n.getId()){e=true}if(n.getVisible()&&this.getFirstVisibleStep()==n.getId()){t=true}var o=n.getSubSteps();for(var p=0;p<o.length;p++){var a=o[p];a.setProperty("expanded",false,true);if(!a.getEnabled()&&!a.getVisible()&&this.getSelectedStep()==a.getId()){this.setProperty("selectedStep","",true)}else if(a.getEnabled()&&a.getVisible()&&this.getSelectedStep()==a.getId()){e=true}if(a.getVisible()&&this.getFirstVisibleStep()==a.getId()){t=true}}}if(!e){this.setProperty("selectedStep","",true)}if(!t){this.setProperty("firstVisibleStep","",true)}if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};n.prototype.onAfterRendering=function(){var e=this.getSteps();if(this.iStepWidth==-1&&e.length>0){var t=e[0].$();this.iStepWidth=t.outerWidth()}for(var r=0;r<e.length;r++){var n=e[r];i.addEllipses(n);var o=n.getSubSteps();for(var p=0;p<o.length;p++){i.addEllipses(o[p])}}i.updateScrollArea(this);this.sResizeListenerId=s.register(this.getDomRef(),jQuery.proxy(this.onresize,this))};n.prototype.onresize=function(e){var t=function(){if(this.getDomRef()){i.updateScrollArea(this,true);p(this,"prev");this.sResizeInProgress=null}}.bind(this);if(r.browser.firefox){t()}else{if(!this.sResizeInProgress){this.sResizeInProgress=setTimeout(t,300)}}};n.prototype.onclick=function(t){e(this,t)};n.prototype.onsapselect=function(t){e(this,t)};n.prototype.onfocusin=function(e){var t=jQuery(e.target);var s=t.attr("id");if(s&&s.endsWith("-box")){this.sCurrentFocusedStepRefId=s.slice(0,-4)}else if(s&&(s.endsWith("-Start")||s.endsWith("-End"))){}else{this.sCurrentFocusedStepRefId=i.getFirstVisibleRef(this).attr("id");p(this)}this.$().attr("tabindex","-1")};n.prototype.onfocusout=function(e){this.$().attr("tabindex","0")};n.prototype.onsapprevious=function(e){o(e,this,"prev")};n.prototype.onsapnext=function(e){o(e,this,"next")};n.prototype.onsaphome=function(e){o(e,this,"first")};n.prototype.onsapend=function(e){o(e,this,"last")};var e=function(e,i){i.stopPropagation();i.preventDefault();var s=jQuery(i.target);var r=s.attr("id");if(!r){return}var n=r.lastIndexOf("-expandend");if(n!=-1){var o=sap.ui.getCore().byId(r.substring(0,n));if(o&&e.indexOfStep(o)>=0){o.handleSelect(i,true);return}}if(r==e.getId()+"-Start"){if(s.hasClass("sapUiRoadMapStartScroll")){t(e,"prev",true)}else{p(e)}}else if(r==e.getId()+"-End"){if(s.hasClass("sapUiRoadMapEndScroll")){t(e,"next",true)}else{p(e)}}};var t=function(e,t,s){i.scrollToNextStep(e,t,function(i){var r=i.lastIndexOf("-expandend");if(r!=-1){i=i.substring(0,r)}e.setProperty("firstVisibleStep",i,true);if(s){p(e,t)}})};var o=function(e,s,r){if(e){e.stopPropagation();e.preventDefault()}if(!s.sCurrentFocusedStepRefId){return}var n=r+"All";var o=false;if(r=="first"){n="prevAll";o=true}else if(r=="last"){n="nextAll";o=true}var p=jQuery(document.getElementById(s.sCurrentFocusedStepRefId));var a=p[n](":visible");var l=jQuery(a.get(o?a.length-1:0)).attr("id");if(l){if(!i.isVisibleRef(s,l)){t(s,r)}document.getElementById(l+"-box").focus()}};var p=function(e,t){if(!e.sCurrentFocusedStepRefId){return}if(t&&!i.isVisibleRef(e,e.sCurrentFocusedStepRefId)){o(null,e,t)}else{document.getElementById(e.sCurrentFocusedStepRefId+"-box").focus()}}})();return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RoadMapRenderer", ["sap/ui/thirdparty/jquery","sap/ui/Device","sap/base/security/encodeXML","sap/ui/core/Configuration","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(jQuery,e,t,a){"use strict";var i={};i.render=function(e,t){t.doBeforeRendering();e.write("<div");e.writeControlData(t);e.addClass("sapUiRoadMap");e.writeClasses();e.writeAttribute("tabindex","0");var i=t.getTooltip_AsString();if(i){e.writeAttributeEscaped("title",i)}e.writeAttribute("style","width:"+(t.getWidth()?t.getWidth():"100%")+";");e.write(">");s(e,t,true);e.write("<ul");e.writeAttribute("id",t.getId()+"-steparea");e.addClass("sapUiRoadMapStepArea");e.writeClasses();if(a.getAccessibility()){e.writeAttribute("role","group");e.writeAttributeEscaped("aria-label",b("RDMP_DEFAULT_TOOLTIP",[]));if(i){e.writeAttributeEscaped("title",i)}}e.write(">");var r=t.getSteps();for(var l=0;l<r.length;l++){var n=r[l];if(n.getSubSteps().length>0){v(e,t,n)}else{d(e,t,n)}}e.write("</ul>");s(e,t,false);e.write("</div>")};i.selectStepWithId=function(e,t){var i=e.getSelectedStep();if(i){r(i).removeClass("sapUiRoadMapSelected")}if(t){r(t).addClass("sapUiRoadMapSelected")}if(a.getAccessibility()){if(i){r(i+"-box").removeAttr("aria-checked")}if(t){r(t+"-box").attr("aria-checked",true)}}};i.selectStep=function(e,t,s,d,l,n){if(!n){i.selectStepWithId(e,t.getId())}if(!s&&t.getSubSteps().length>0){var p=t.getSubSteps();var o=t.$();var f=o.hasClass("sapUiRoadMapExpanded");var u=1;var v=function(){u--;if(u>0){return}if(l){l(!f?"expanded":"collapsed")}i.updateStepArea(e)};var g=function(t,a,i){var s=r(t);if(!jQuery.fx.off&&!d){s.width(a?"0px":e.iStepWidth);var l=r(t+"-label");l.addClass("sapUiRoadMapHidden");if(a){s.toggleClass("sapUiRoadMapHidden")}s.animate({width:a?e.iStepWidth:"0px"},"fast",function(){if(!a){s.toggleClass("sapUiRoadMapHidden")}s.width("");l.removeClass("sapUiRoadMapHidden");if(i){i()}})}else{s.toggleClass("sapUiRoadMapHidden");if(i){i()}}};o.toggleClass("sapUiRoadMapExpanded");if(a.getAccessibility()){var c=o.hasClass("sapUiRoadMapExpanded");t.$("box").attr("aria-expanded",c);t.$("expandend-box").attr("aria-expanded",c)}for(var b=0;b<p.length;b++){if(p[b].getVisible()){u++;g(p[b].getId(),!f,v)}}g(t.getId()+"-expandend",!f,v)}else{if(l){l("selected")}}};i.updateStepArea=function(e){if(e.iStepWidth!=-1){var t=e.$("steparea");var a=e.$("Start");var i=e.$("End");var r=e.$();var s=t.scrollLeft();var d=r.width()-a.outerWidth(true)-i.outerWidth(true);var l=e.getNumberOfVisibleSteps();var n=S(e);if(l<1){l=n}else{l=Math.min(l,n)}var p=Math.floor(d/e.iStepWidth);var o=Math.min(l,p);t.width(o*e.iStepWidth).scrollLeft(s);c(e)}};i.updateScrollArea=function(e,t){i.updateStepArea(e);if(!t){var a=e.$("steparea");var s=M(e,false);if(e.getFirstVisibleStep()){var d=r(e.getFirstVisibleStep());if(d.length){s=h(a,d)}}C(e,s+w()*a.scrollLeft(),true)}};i.isVisibleRef=function(e,t){var a=e.$("steparea");var i=a.children(":visible");for(var r=0;r<i.length;r++){var s=jQuery(i.get(r));if(s.attr("id")==t){var d=h(a,s);return d>=0&&d<a.width()}}return false};i.getFirstVisibleRef=function(e){var t=e.$("steparea");var a=t.children(":visible");for(var i=0;i<a.length;i++){var r=jQuery(a.get(i));if(h(t,r)==0){return r}}return null};i.setStepLabel=function(e,i){var r=i?t(i):"";e.$("label").html(r);e.$("expandend-label").html(r);if(!a.getAccessibility()){return}e.$("box").attr("aria-label",o(e,i));e.$("expandend-box").attr("aria-label",o(e,i))};i.setStepEnabled=function(e,t,i){var r=t.$();var s=t.$("expandend");if(i){r.removeClass("sapUiRoadMapDisabled");s.removeClass("sapUiRoadMapDisabled");if(a.getAccessibility()){t.$("box").removeAttr("aria-disabled");t.$("expandend-box").removeAttr("aria-disabled")}return false}else{var d=e.getSelectedStep()==t.getId();if(d){r.removeClass("sapUiRoadMapSelected")}r.addClass("sapUiRoadMapDisabled");s.addClass("sapUiRoadMapDisabled");if(a.getAccessibility()){var l=t.$("box");l.attr("aria-disabled",true);if(d){l.removeAttr("aria-checked")}t.$("expandend-box").attr("aria-disabled",true)}return d}};i.setStepVisible=function(e,t,a,i){var r=t.$();var s=t.$("expandend");var d=e.getSelectedStep()==t.getId();var l=t.getParent();if(a){if(l.getEnabled()&&l.getVisible()&&l.getExpanded()){if(i){r.removeClass("sapUiRoadMapHidden")}else{r.addClass("sapUiRoadMapHidden")}}}else{if(i){r.removeClass("sapUiRoadMapHidden")}else{r.addClass("sapUiRoadMapHidden")}var n=t.getSubSteps();if(n.length>0&&t.getExpanded()){if(i){s.removeClass("sapUiRoadMapHidden")}else{s.addClass("sapUiRoadMapHidden")}for(var p=0;p<n.length;p++){if(n[p].getVisible()){var o=n[p].$();if(e.getSelectedStep()==n[p].getId()){d=true;o.removeClass("sapUiRoadMapSelected");n[p].$("box").removeAttr("aria-checked")}if(i){o.removeClass("sapUiRoadMapHidden")}else{o.addClass("sapUiRoadMapHidden")}}}}}return d};i.setRoadMapWidth=function(e,t){var a=e.$();a.attr("style","width:"+(t?t:"100%")+";")};i.scrollToNextStep=function(e,t,a){var i=t;if(t=="first"||t=="last"){i=M(e,t=="last")}C(e,i,false,a)};i.addEllipses=function(e){if(!e){return}var a=e.$("label");var i=e.getLabel();var r=i+"";var s=jQuery('<label class="sapUiRoadMapTitle" style="display:none;position:absolute;overflow:visible;font-weight:bold;height:auto">'+r+"</label>");s.width(a.width());jQuery(sap.ui.getCore().getStaticAreaRef()).append(s);var d=false;while(r.length>0&&s.height()>a.height()){r=r.substr(0,r.length-1);s.html(t(r+"..."));d=true}if(d){a.html("<span>"+t(r)+"</span>");a.attr("title",e.getLabel())}else{a.attr("title",l(e))}s.remove()};i.updateStepAria=function(e){if(!a.getAccessibility()){return}var t=e.getParent()instanceof sap.ui.commons.RoadMap;var i=e.getParent()[t?"getSteps":"getSubSteps"]();for(var r=0;r<i.length;r++){var s=f(i[r]);var d=u(i[r]);var l=i[r].$("box");l.attr("aria-posinset",s);l.attr("aria-setsize",d);if(t&&i[r].getSubSteps().length>0){l=i[r].$("expandend-box");l.attr("aria-posinset",s);l.attr("aria-setsize",d)}}};var r=function(e){return jQuery(e?document.getElementById(e):null)};var s=function(e,t,a){var i=a?"Start":"End";e.write("<div");e.writeAttribute("id",t.getId()+"-"+i);e.writeAttribute("tabindex","-1");var r=true;e.addClass(r?"sapUiRoadMap"+i+"Scroll":"sapUiRoadMap"+i+"Fixed");e.addClass("sapUiRoadMapDelim");e.addClass("sapUiRoadMapContent");e.writeClasses();e.write("></div>")};var d=function(e,t,a,i,r,s){e.write("<li");if(s){e.writeAttribute("id",s)}else{e.writeElementData(a)}var d=g(t,a);a.__stepName=d;var o=l(a);e.addClass("sapUiRoadMapContent");e.addClass("sapUiRoadMapStep");if(!a.getVisible()){e.addClass("sapUiRoadMapHidden")}if(a.getEnabled()){if(t.getSelectedStep()==a.getId()){e.addClass("sapUiRoadMapSelected")}}else{e.addClass("sapUiRoadMapDisabled")}if(i){for(var f=0;f<i.length;f++){e.addClass(i[f])}}e.writeClasses();e.write(">");n(e,s?s:a.getId(),1);e.write("<div");e.writeAttribute("id",(s?s:a.getId())+"-box");e.writeAttribute("tabindex","-1");e.addClass("sapUiRoadMapStepBox");e.writeClasses();e.writeAttributeEscaped("title",o);p(e,t,a,r?true:false);e.write("><span>");e.write(d);e.write("</span>");if(r){r(e,t,a)}e.write("</div>");e.write("<label");e.writeAttribute("id",(s?s:a.getId())+"-label");e.addClass("sapUiRoadMapTitle");e.writeAttributeEscaped("title",o);e.writeClasses();e.write(">");var u=a.getLabel();if(u){e.writeEscaped(u)}e.write("</label>");n(e,s?s:a.getId(),2);e.write("</li>")};var l=function(e){var t=e.getTooltip_AsString();if(!t&&!e.getTooltip()&&a.getAccessibility()){t=b("RDMP_DEFAULT_STEP_TOOLTIP",[e.__stepName])}return t||""};var n=function(e,t,a){e.write("<div");e.writeAttribute("id",t+"-add"+a);e.addClass("sapUiRoadMapStepAdd"+a);e.writeClasses();e.write("></div>")};var p=function(e,t,i,r){if(!a.getAccessibility()){return}e.writeAttribute("role","treeitem");if(i.getEnabled()){e.writeAttribute("aria-checked",t.getSelectedStep()==i.getId())}else{e.writeAttribute("aria-disabled",true)}e.writeAttribute("aria-haspopup",r);e.writeAttribute("aria-level",i.getParent()instanceof sap.ui.commons.RoadMap?1:2);e.writeAttribute("aria-posinset",f(i));e.writeAttribute("aria-setsize",u(i));e.writeAttributeEscaped("aria-label",o(i,i.getLabel()));if(!r){return}e.writeAttribute("aria-expanded",i.getExpanded())};var o=function(e,t){var a=e.getParent()instanceof sap.ui.commons.RoadMap&&e.getSubSteps().length>0;var i=t||"";if(e.getEnabled()){i=b(a?"RDMP_ARIA_EXPANDABLE_STEP":"RDMP_ARIA_STANDARD_STEP",[i])}return i};var f=function(e){var t=e.getParent()instanceof sap.ui.commons.RoadMap;var a=e.getParent()[t?"indexOfStep":"indexOfSubStep"](e);var i=0;var r=e.getParent()[t?"getSteps":"getSubSteps"]();for(var s=0;s<a;s++){if(!r[s].getVisible()){i++}}return a+1-i};var u=function(e){var t=e.getParent()instanceof sap.ui.commons.RoadMap;var a=e.getParent()[t?"getSteps":"getSubSteps"]();var i=a.length;for(var r=0;r<a.length;r++){if(!a[r].getVisible()){i--}}return i};var v=function(e,t,a){var i=function(e,t,a,i,r){e.write("<div");e.writeAttribute("id",a+"-ico");e.addClass("sapUiRoadMapStepIco");if(r){e.addClass(r)}e.writeClasses();e.write("></div>")};var r=a.getExpanded();d(e,t,a,r?["sapUiRoadMapExpanded"]:null,function(e,t,a){i(e,t,a.getId(),r?"roundtripstart.gif":"roundtrip.gif")});var s=a.getSubSteps();for(var l=0;l<s.length;l++){var n=["sapUiRoadMapSubStep"];if(!r&&s[l].getVisible()){n.push("sapUiRoadMapHidden")}d(e,t,s[l],n)}n=["sapUiRoadMapExpanded","sapUiRoadMapStepEnd"];if(!r){n.push("sapUiRoadMapHidden")}d(e,t,a,n,function(e,t,a){i(e,t,a.getId()+"-expandend","roundtripend.gif")},a.getId()+"-expandend")};var g=function(e,t){var a=t.getParent();if(a===e){return a.indexOfStep(t)+1}var i=a.indexOfSubStep(t);if(i<26){return String.fromCharCode(97+i)}var r=Math.floor(i/26)-1;var s=i%26;return String.fromCharCode(97+r,97+s)};var c=function(e){var t=w();var a=e.$("steparea");var i=R(a);var r=e.$("Start");r.removeClass("sapUiRoadMapStartScroll").removeClass("sapUiRoadMapStartFixed");r.addClass(t*i>=e.iStepWidth?"sapUiRoadMapStartScroll":"sapUiRoadMapStartFixed");var s=e.$("End");s.removeClass("sapUiRoadMapEndScroll").removeClass("sapUiRoadMapEndFixed");var d=a.get(0).scrollWidth-t*i-a.width()<e.iStepWidth;s.addClass(d?"sapUiRoadMapEndFixed":"sapUiRoadMapEndScroll")};var b=function(e,t){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(a){return a.getText(e,t)}return e};var S=function(e){var t=0;var a=e.getSteps();for(var i=0;i<a.length;i++){if(a[i].getVisible()){t++;if(a[i].getExpanded()){t++;var r=a[i].getSubSteps();for(var s=0;s<r.length;s++){if(r[s].getVisible()){t++}}}}}return t};var h=function(e,t){var i=t.position().left;if(a.getRTL()){i=e.width()-i-t.outerWidth()}return i};var w=function(){return a.getRTL()?-1:1};var R=function(t){if(a.getRTL()&&e.browser.webkit){return-1*(t.get(0).scrollWidth-t.scrollLeft()-t.width())}return t.scrollLeft()};var M=function(t,i){var r=t.$("steparea").get(0).scrollWidth;if(a.getRTL()&&e.browser.webkit){return i?0:-1*r}return i?r:0};var C=function(e,t,a,r){var s=e.$("steparea");s.stop(false,true);if(t=="next"){t=s.scrollLeft()+e.iStepWidth*w()}else if(t=="prev"){t=s.scrollLeft()-e.iStepWidth*w()}else if(t=="keep"){t=s.scrollLeft()}else{t=t*w()}var d=function(){c(e);if(r){var t=i.getFirstVisibleRef(e);r(t.attr("id"))}};if(!jQuery.fx.off&&!a){s.animate({scrollLeft:t},"fast",d)}else{s.scrollLeft(t);d()}};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RoadMapStep", ["sap/ui/dom/containsOrEquals","./library","sap/ui/core/Element","./RoadMapRenderer"],function(e,t,r,s){"use strict";var i=r.extend("sap.ui.commons.RoadMapStep",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{label:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true},expanded:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"subSteps",aggregations:{subSteps:{type:"sap.ui.commons.RoadMapStep",multiple:true,singularName:"subStep",deprecated:true}}}});i.prototype.setLabel=function(e){u(this,"label",e,function(){s.setStepLabel(this,e);this.setProperty("label",e,true);s.addEllipses(this);return true});return this};i.prototype.setEnabled=function(e){var t=this.getEnabled();if(e&&t||!e&&!t){return this}u(this,"enabled",e,function(){var t=n(this);var r=s.setStepEnabled(t,this,e);if(r){t.setProperty("selectedStep","",true)}if(!e){this.setExpanded(false)}return false});return this};i.prototype.setExpanded=function(e){var t=this.getExpanded();if(e&&t||!e&&!t){return this}u(this,"expanded",e,function(){if(a(this)||this.getSubSteps().length==0||!this.getEnabled()||!e){this.setProperty("expanded",false,true);if(!a(this)&&this.getSubSteps().length>0&&this.getEnabled()){s.selectStep(n(this),this,false,true,null,true)}}else{this.setProperty("expanded",true,true);s.selectStep(n(this),this,false,true,null,true)}return true});return this};i.prototype.setVisible=function(e){var t=this.getVisible();if(e&&t||!e&&!t){return this}u(this,"visible",e,function(){var t=n(this);var r=s.setStepVisible(t,this,a(this),e);if(r){t.setProperty("selectedStep","",true)}this.setProperty("visible",e,true);s.updateStepArea(t);s.updateStepAria(this);return true});return this};i.prototype.getFocusDomRef=function(){return this.getFocusInfo().id?document.getElementById(this.getFocusInfo().id):null};i.prototype.getFocusInfo=function(){return{id:this.getId()+"-box"}};i.prototype.onclick=function(e){this.handleSelect(e)};i.prototype.onsapselect=function(e){this.handleSelect(e)};i.prototype.handleSelect=function(t,r){t.stopPropagation();t.preventDefault();if(!r&&!e(this.getDomRef(),t.target)){return}if(this.getEnabled()){var i=n(this);var u=this;s.selectStep(i,this,a(this),false,function(e){var t=i.getSelectedStep()==u.getId();i.setProperty("selectedStep",u.getId(),true);u.focus();if(e!="selected"){u.setProperty("expanded",e=="expanded",true);i.fireStepExpanded({stepId:u.getId()})}if(!t){i.fireStepSelected({stepId:u.getId()})}})}else{this.focus()}};var n=function(e){var t=e.getParent();if(a(e)){t=t.getParent()}return t};var a=function(e){return!(e.getParent()instanceof sap.ui.commons.RoadMap)};var u=function(e,t,r,s){if(!e.getDomRef()){e.setProperty(t,r);return}var i=s.apply(e,[]);if(!i){e.setProperty(t,r,true)}};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RowRepeater", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","./RowRepeaterRenderer","./Toolbar","./Paginator","./Button","sap/ui/model/FilterType","sap/ui/core/Configuration"],function(jQuery,t,e,i,r,s,o,n,a){"use strict";var g=t.PaginatorEvent;var h=t.ToolbarDesign;var u=t.RowRepeaterDesign;var p=e.extend("sap.ui.commons.RowRepeater",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{numberOfRows:{type:"int",group:"Dimension",defaultValue:5},currentPage:{type:"int",group:"Data",defaultValue:1},showMoreSteps:{type:"int",group:"Behavior",defaultValue:0},fixedRowHeight:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:""},design:{type:"sap.ui.commons.RowRepeaterDesign",group:"Appearance",defaultValue:u.Standard},threshold:{type:"int",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.core.Control",multiple:true,singularName:"row",bindable:"bindable"},title:{type:"sap.ui.core.Title",multiple:false},filters:{type:"sap.ui.commons.RowRepeaterFilter",multiple:true,singularName:"filter"},sorters:{type:"sap.ui.commons.RowRepeaterSorter",multiple:true,singularName:"sorter"},noData:{type:"sap.ui.core.Control",multiple:false},filterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},sorterToolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"},headerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerShowMoreButton:{type:"sap.ui.commons.Button",multiple:false,visibility:"hidden"},footerPager:{type:"sap.ui.commons.Paginator",multiple:false,visibility:"hidden"}},events:{filter:{parameters:{filterId:{type:"string"}}},sort:{parameters:{sorterId:{type:"string"}}},page:{parameters:{currentPage:{type:"int"},previousPage:{type:"int"}}},resize:{parameters:{numberOfRows:{type:"int"},previousNumberOfRows:{type:"int"}}}}}});p.prototype.bPagingMode=true;p.prototype.bShowAnimation=true;p.SHOW_MORE="show_more";p.RESIZE="resize";p.FIRST_PAGE="first_page";p.LAST_PAGE="last_page";p.PREVIOUS_PAGE="previous_page";p.NEXT_PAGE="next_page";p.GOTO_PAGE="goto_page";p.prototype.init=function(){var t=this.getId();this.oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.sCurrentAnimation=null;this.aAnimationQueue=[];this.aRemoveBuffer=[];this.iPreviousPage=this.getCurrentPage();this.iPreviousNumberOfRows=this.getNumberOfRows();this.setAggregation("filterToolbar",new r(t+"-ftb",{standalone:false,design:h.Transparent}));this.setAggregation("sorterToolbar",new r(t+"-stb",{standalone:false}));var e=new s(t+"-fp",{page:[this.paging,this]});this.setAggregation("footerPager",e);var i=this.oResourceBundle.getText("SHOW_MORE");this.setAggregation("headerShowMoreButton",new o(t+"-hsm",{text:i,tooltip:i,press:[this.triggerShowMore,this]}));this.setAggregation("footerShowMoreButton",new o(t+"-fsm",{text:i,tooltip:i,press:[this.triggerShowMore,this]}));this._bSecondPage=false};p.prototype.triggerShowMore=function(){if(this.getShowMoreSteps()<=0){return this}var t=this.getShowMoreSteps();var e=this.getNumberOfRows();var i=Math.min(this._getRowCount(),e+t);if(e===i){return this}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.SHOW_MORE,animationFunction:this.triggerShowMore,args:arguments});return this}else{this.sCurrentAnimation=p.SHOW_MORE}this.iPreviousNumberOfRows=e;this.setProperty("numberOfRows",i,true);this.startResizeAnimation()}else{this.setNumberOfRows(i)}this.fireResize({numberOfRows:i,previousNumberOfRows:e});return this};p.prototype.resize=function(t){if(this.getShowMoreSteps()<=0){return this}var e=this.getNumberOfRows();if(t<=0||t>this._getRowCount()||t===e){return this}if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.RESIZE,animationFunction:this.resize,args:arguments});return this}else{this.sCurrentAnimation=p.RESIZE}this.iPreviousNumberOfRows=e;this.setProperty("numberOfRows",t,true);this.startResizeAnimation()}else{this.setNumberOfRows(t)}this.fireResize({numberOfRows:t,previousNumberOfRows:e});return this};p.prototype.applyFilter=function(t){var e=this.getFilters();var i=this.getBinding("rows");var r,s;if(e.length===0||i===null){return this}for(s=0;s<e.length;s++){if(e[s].getId()===t){r=e[s];break}}if(r){i.filter(r.getFilters(),n.Control);this.fireFilter({filterId:t});this.firstPage()}return this};p.prototype.triggerSort=function(t){var e=this.getSorters();var i=this.getBinding("rows");var r,s;if(e.length===0||i===null){return this}for(s=0;s<e.length;s++){if(e[s].getId()===t){r=e[s];break}}if(r){i.sort(r.getSorter());this.fireSort({sorterId:t});this.firstPage()}return this};p.prototype.firstPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();if(t===1){return this}this.getAggregation("footerPager").setCurrentPage(1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.FIRST_PAGE,animationFunction:this.firstPage,args:arguments});return this}else{this.sCurrentAnimation=p.FIRST_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",1,true);this.startPagingAnimation()}else{this.setCurrentPage(1)}this.firePage({currentPage:1,previousPage:t});return this};p.prototype.lastPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();var e=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t===e){return this}this.getAggregation("footerPager").setCurrentPage(e);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.LAST_PAGE,animationFunction:this.lastPage,args:arguments});return this}else{this.sCurrentAnimation=p.LAST_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",e,true);this.startPagingAnimation()}else{this.setCurrentPage(e)}this.firePage({currentPage:e,previousPage:t});return this};p.prototype.previousPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();if(t<=1){return this}this.getAggregation("footerPager").setCurrentPage(t-1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.PREVIOUS_PAGE,animationFunction:this.previousPage,args:arguments});return this}else{this.sCurrentAnimation=p.PREVIOUS_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",t-1,true);this.startPagingAnimation()}else{this.setCurrentPage(t-1)}this.firePage({currentPage:t-1,previousPage:t});return this};p.prototype.nextPage=function(){if(this.getShowMoreSteps()>0){return this}var t=this.getCurrentPage();var e=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t>=e){return this}this.getAggregation("footerPager").setCurrentPage(t+1);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.NEXT_PAGE,animationFunction:this.nextPage,args:arguments});return this}else{this.sCurrentAnimation=p.NEXT_PAGE}this.iPreviousPage=t;this.setProperty("currentPage",t+1,true);this.startPagingAnimation()}else{this.setCurrentPage(t+1)}this.firePage({currentPage:t+1,previousPage:t});return this};p.prototype.gotoPage=function(t){if(this.getShowMoreSteps()>0){return this}var e=this.getCurrentPage();var i=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(t<1||t>i||e===t){return this}this.getAggregation("footerPager").setCurrentPage(t);if(this.getDomRef()&&this.bShowAnimation){if(this.sCurrentAnimation!==null){this.aAnimationQueue.push({name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:arguments});return this}else{this.sCurrentAnimation=p.GOTO_PAGE}this.iPreviousPage=e;this.setProperty("currentPage",t,true);this.startPagingAnimation()}else{this.setCurrentPage(t)}this.firePage({currentPage:t,previousPage:e});return this};p.prototype.setNumberOfRows=function(t){this.setProperty("numberOfRows",t);if(this.getBinding("rows")){this.updateRows(true)}this.updateChildControls();return this};p.prototype.setCurrentPage=function(t){if(this.getCurrentPage()!=t){this.setProperty("currentPage",t);if(this.getBinding("rows")){this.updateRows(true)}this.updateChildControls()}return this};p.prototype.setShowMoreSteps=function(t){var e=t>0?false:true,i=this.getBinding("rows");if(e!==this.bPagingMode){this.bPagingMode=e;this.setCurrentPage(1)}this.setProperty("showMoreSteps",t);if(i){this._bSecondPage=false;this.updateRows(true)}return this};p.prototype.insertRow=function(t,e){this.insertAggregation("rows",t,e);this.updateChildControls();return this};p.prototype.addRow=function(t){this.addAggregation("rows",t);this.updateChildControls();return this};p.prototype.removeRow=function(t){this.removeAggregation("rows",t);this.updateChildControls();return this};p.prototype.removeAllRows=function(){this.removeAllAggregation("rows");this.updateChildControls();return this};p.prototype.destroyRows=function(){this.destroyAggregation("rows");this.updateChildControls();return this};p.prototype.setThreshhold=function(t){this.setProperty("threshold",t,true);return this};p.prototype.insertFilter=function(t,e){var i=this.getAggregation("filterToolbar");var r=t.getId();var s=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.applyFilter(r)},this]});i.insertItem(s,e);this.insertAggregation("filters",t,e);return this};p.prototype.addFilter=function(t){var e=this.getAggregation("filterToolbar");var i=t.getId();var r=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.applyFilter(i)},this]});e.addItem(r);this.addAggregation("filters",t);return this};p.prototype.removeFilter=function(t){var e=this.getAggregation("filterToolbar");e.removeItem(t);return this.removeAggregation("filters",t)};p.prototype.removeAllFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();return this.removeAllAggregation("filters")};p.prototype.destroyFilters=function(){var t=this.getAggregation("filterToolbar");t.removeAllItems();this.destroyAggregation("filters");return this};p.prototype.insertSorter=function(t,e){var i=this.getAggregation("sorterToolbar");var r=t.getId();var s=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.triggerSort(r)},this]});i.insertItem(s,e);this.insertAggregation("sorters",t,e);return this};p.prototype.addSorter=function(t){var e=this.getAggregation("sorterToolbar");var i=t.getId();var r=new o({text:t.getText(),icon:t.getIcon(),tooltip:t.getTooltip(),press:[function(){this.triggerSort(i)},this]});e.addItem(r);this.addAggregation("sorters",t);return this};p.prototype.removeSorter=function(t){var e=this.getAggregation("sorterToolbar");e.removeItem(t);return this.removeAggregation("sorters",t)};p.prototype.removeAllSorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();return this.removeAllAggregation("sorters")};p.prototype.destroySorters=function(){var t=this.getAggregation("sorterToolbar");t.removeAllItems();this.destroyAggregation("sorters");return this};p.prototype.startPagingAnimation=function(){var t=sap.ui.getCore(),e=t.getRenderManager(),i=this.getId(),r=this.iPreviousPage,s=this.getCurrentPage(),o=this.getNumberOfRows(),n=(s-1)*o,g=this.getRows(),h=this._getRowCount()>o*s?o:this._getRowCount()-o*(s-1),u,p=this.getBinding("rows");var l,f=this.$("page_"+r),m=this.getDomRef("body"),d=jQuery(m);d.css("height",d.outerHeight());var P;if(sap.ui.getCore()&&a&&a.getRTL()){P=s<r?"left":"right"}else{P=s<r?"right":"left"}if(p){this._bSecondPage=!this._bSecondPage;this.updateRows(true);g=this.getRows();n=(this._bSecondPage?1:0)*o}var w='"top:-'+f.outerHeight(true)+"px;"+P+":"+f.outerWidth(true)+'px;"';jQuery('<ul id="'+i+"-page_"+s+'" class="sapUiRrPage" style='+w+"></ul>").appendTo(m);var c=m.lastChild;var v=jQuery(c);for(u=n;u<n+h;u++){jQuery('<li id="'+i+"-row_"+u+'" class="sapUiRrRow"></li>').appendTo(c);l=c.lastChild;e.render(g[u],l)}if(P==="right"){f.animate({right:-f.outerWidth(true)},"slow");v.animate({right:0},"slow")}else{f.animate({left:-f.outerWidth(true)},"slow");v.animate({left:0},"slow")}d.animate({height:v.outerHeight(true)},"slow",jQuery.proxy(this.endPagingAnimation,this))};p.prototype.endPagingAnimation=function(){var t=this.getDomRef("body");var e=this.getDomRef("page_"+this.iPreviousPage);var i=this.getDomRef("page_"+this.getCurrentPage());var r=jQuery(i);jQuery(t).css("height","");jQuery(e).remove();var s;if(sap.ui.getCore()&&a&&a.getRTL()){s=this.getCurrentPage()<this.iPreviousPage?"left":"right"}else{s=this.getCurrentPage()<this.iPreviousPage?"right":"left"}r.css("top","");r.css(s,"");this.sCurrentAnimation=null;this.nextQueuedAnimation()};p.prototype.startResizeAnimation=function(){var t=sap.ui.getCore().getRenderManager(),e=this.getNumberOfRows(),i=this.iPreviousNumberOfRows,r=this.getId(),s=0,o,n=this.getBinding("rows");var a,g=this.getDomRef("body"),h=jQuery(g),u=this.getDomRef("page_"+this.getCurrentPage());h.css("height",h.outerHeight());if(n){this.updateRows(true)}o=this.getRows();if(e>i){for(var p=i;p<e;p++){jQuery('<li id="'+r+"-row_"+p+'" class="sapUiRrRow"></li>').appendTo(u);a=u.lastChild;t.render(o[p],a)}}else{for(var p=e;p<i;p++){a=this.getDomRef("row_"+p);s-=jQuery(a).outerHeight(true);this.aRemoveBuffer.push(a)}}h.animate({height:jQuery(u).outerHeight(true)+s},"slow",jQuery.proxy(this.endResizeAnimation,this))};p.prototype.endResizeAnimation=function(){var t=this.getDomRef("body");while(this.aRemoveBuffer.length>0){jQuery(this.aRemoveBuffer.pop()).remove()}jQuery(t).css("height","");this.sCurrentAnimation=null;this.nextQueuedAnimation()};p.prototype.nextQueuedAnimation=function(){var t,e;var i=1;var r=this.aAnimationQueue;var s,o;if(r.length>0){t=r.shift()}if(t&&r.length>0){while(r[0]&&r[0].name===t.name){i++;e=r.shift()}if(i>0){switch(t.name){case p.SHOW_MORE:o=Math.min(this._getRowCount(),this.getNumberOfRows()+this.getShowMoreSteps()*i);t={name:p.RESIZE,animationFunction:this.resize,args:[o]};break;case p.RESIZE:t=e;break;case p.FIRST_PAGE:break;case p.LAST_PAGE:break;case p.PREVIOUS_PAGE:s=Math.max(1,this.getCurrentPage()-i);t={name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:[s]};break;case p.NEXT_PAGE:s=Math.min(Math.ceil(this._getRowCount()/this.getNumberOfRows()),this.getCurrentPage()+i);t={name:p.GOTO_PAGE,animationFunction:this.gotoPage,args:[s]};break;case p.GOTO_PAGE:t=e;break}}}if(t){t.animationFunction.apply(this,t.args)}};p.prototype.paging=function(t){switch(t.getParameter("type")){case g.First:this.firstPage();break;case g.Last:this.lastPage();break;case g.Previous:this.previousPage();break;case g.Next:this.nextPage();break;case g.Goto:this.gotoPage(t.getParameter("targetPage"));break}};p.prototype.updateChildControls=function(){var t,e;var i;if(this.bPagingMode){var r=this.getCurrentPage();var s=Math.ceil(this._getRowCount()/this.getNumberOfRows());if(this._getRowCount()==0){s=1}e=this.getAggregation("footerPager");if(e){e.setCurrentPage(r);e.setNumberOfPages(s)}}else{i=this._getRowCount()>this.getNumberOfRows();t=this.getAggregation("headerShowMoreButton");if(t){t.setEnabled(i)}t=this.getAggregation("footerShowMoreButton");if(t){t.setEnabled(i)}}};p.prototype.isBound=function(t){return e.prototype.isBound.call(this,t||"rows")};p.prototype._getRowCount=function(){var t=this.getBinding("rows");if(t){return t.getLength()}else{return this.getRows().length}};p.prototype.unbindAggregation=function(t){e.prototype.unbindAggregation.apply(this,arguments);if(t==="rows"){this.destroyRows()}return this};p.prototype.refreshRows=function(){var t=this.getBindingInfo("rows"),e=t.binding,i=this._getRowCount(),r=this.getNumberOfRows(),s=Math.min(i,r),o=this.getThreshold();this.setProperty("currentPage",1,true);e.getContexts(0,s,o)};p.prototype.updateRows=function(t){var e=this.getBindingInfo("rows"),i=e.factory,r=e.binding,s=this.getShowMoreSteps(),o=s>0,n=this.getCurrentPage(),a=this._getRowCount(),g=this.getNumberOfRows(),h=Math.min(a,g),u=Math.ceil(a/g)||1;if(n>u){n=u;this.setProperty("currentPage",n);this._bSecondPage=false}var p=o?0:(n-1)*h,l=(this._bSecondPage?1:0)*h,f=this.getThreshold(),m=r?r.getContexts(p,h,f):[];if(t!==true){this._bSecondPage=false;this.destroyRows();for(var d=0,P=h;d<P;d++){var w=this.getId()+"-"+d,c=i(w,m[d]);c.setBindingContext(m[d],e.model);this.addRow(c)}}else{this._bSuppressInvalidate=true;for(var d=0,P=h;d<P;d++){var v=l+d;var R=this.getRows()[v];if(!o){if(R){this.removeAggregation("rows",R,true);R.destroy()}R=undefined}if(!R){var w=this.getId()+"-"+v;R=i(w,m[d]);R.setBindingContext(m[d],e.model);this.insertAggregation("rows",R,v,true)}else{R.setBindingContext(m[d],e.model)}}this._bSuppressInvalidate=false}this.updateChildControls()};p.prototype.invalidate=function(t){if(this._bSuppressInvalidate){return}e.prototype.invalidate.apply(this,arguments)};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RowRepeaterFilter", ["./library","sap/ui/core/Element"],function(e,t){"use strict";var a=t.extend("sap.ui.commons.RowRepeaterFilter",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"string",group:"Appearance",defaultValue:null},filters:{type:"object",group:"Data",defaultValue:null}}}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RowRepeaterRenderer", ["./Button","./Paginator","./Toolbar","./library"],function(e,r,t,i){"use strict";var s=i.RowRepeaterDesign;var a={};a.render=function(e,r){e.write("<div");e.writeControlData(r);e.addClass("sapUiRrDesign"+r.getDesign());e.writeClasses();e.write(">");if(r.getDesign()!==s.BareShell){this.renderHeader(e,r)}this.renderBody(e,r);if(r.getDesign()!==s.BareShell){this.renderFooter(e,r)}e.write("</div>")};a.renderHeader=function(e,r){this.renderPrimaryToolbar(e,r);if(r.getSorters().length>1&&r.isBound()){this.renderSecondaryToolbar(e,r)}};a.renderPrimaryToolbar=function(e,r){e.write("<div");e.addClass("sapUiRrPtb");e.writeClasses();e.write(">");if(r.getTitle()!==null){this.renderTitle(e,r)}this.renderFilterToolbar(e,r);this.renderController(e,r);e.write("</div>")};a.renderTitle=function(e,r){var t=r.getTitle();var i=t.getTooltip_AsString();if(t.getIcon()){e.write("<div");e.addClass("sapUiRrLogo");e.writeClasses();if(i!==undefined){e.writeAttributeEscaped("title",i)}e.write(">");if(t.getIcon()){e.write("<img");e.writeAttributeEscaped("src",t.getIcon());e.write(">")}e.write("</div>")}if(t.getText()){e.write("<div");e.addClass("sapUiRrTitle");e.writeClasses();e.writeAttribute("role","heading");e.write(">");e.writeEscaped(t.getText());e.write("</div>")}};a.renderFilterToolbar=function(e,r){var t=r.getFilters();if(t.length>0){e.write("<div");e.addClass("sapUiRrFilters");e.writeClasses();e.write(">");if(t.length>1&&r.isBound()){e.renderControl(r.getAggregation("filterToolbar"))}e.write("</div>")}};a.renderController=function(e,r){if(!r.bPagingMode){e.write("<div");e.addClass("sapUiRrCtrl");e.writeClasses();e.write(">");e.renderControl(r.getAggregation("headerShowMoreButton"));e.write("</div>")}};a.renderSecondaryToolbar=function(e,r){e.write("<div");e.addClass("sapUiRrStb");e.writeClasses();e.write(">");e.write("<div");e.addClass("sapUiRrSortBy");e.writeClasses();e.write(">");e.writeEscaped(r.oResourceBundle.getText("SORT_BY")+":");e.write("</div>");e.write("<div");e.addClass("sapUiRrSorters");e.writeClasses();e.write(">");e.renderControl(r.getAggregation("sorterToolbar"));e.write("</div>");e.write("</div>")};a.renderBody=function(e,r){var t=r.getId();var i=r.getShowMoreSteps();var s=r.getCurrentPage();var a=r.getNumberOfRows();var o=(s-1)*a;var d=r.getRows();var n=r._getRowCount();var l=n-o;var w=r._getRowCount()>a?a:l;var g=Math.ceil(n/a);var C;w=Math.min(w,l);if(i>0){o=0}e.write("<div");e.writeAttribute("id",t+"-body");e.addClass("sapUiRrBody");e.writeClasses();e.write(">");e.write("<ul");e.writeAttribute("id",t+"-page_"+s);e.addClass("sapUiRrPage");e.writeClasses();e.write(">");if(d.length===0||g<s){e.write("<li");e.addClass("sapUiRrNoData");e.writeClasses();e.write(">");var v=r.getNoData();if(v){e.renderControl(v)}else{e.writeEscaped(r.oResourceBundle.getText("NO_DATA"))}e.write("</li>")}else{var u;if(r.getFixedRowHeight()!==""){u="height:"+r.getFixedRowHeight()+";overflow:hidden;"}if(r.getBinding("rows")){o=r._bSecondPage?a:0}for(C=o;C<o+w;C++){e.write("<li");e.writeAttribute("id",t+"-row_"+C);if(u){e.writeAttribute("style",u)}e.addClass("sapUiRrRow");e.writeClasses();e.write(">");e.renderControl(d[C]);e.write("</li>")}}e.write("</ul>");e.write("</div>")};a.renderFooter=function(e,r){e.write("<div");e.addClass("sapUiRrFtr");e.writeClasses();e.write(">");if(r.bPagingMode){e.renderControl(r.getAggregation("footerPager"))}else{e.renderControl(r.getAggregation("footerShowMoreButton"))}e.write("</div>")};return a},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/RowRepeaterSorter", ["./library","sap/ui/core/Element"],function(e,t){"use strict";var r=t.extend("sap.ui.commons.RowRepeaterSorter",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"string",group:"Appearance",defaultValue:null},sorter:{type:"object",group:"Data",defaultValue:null}}}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SearchField", ["sap/ui/thirdparty/jquery","./ComboBox","./ComboBoxRenderer","./ListBox","./TextField","./TextFieldRenderer","./library","sap/ui/core/Control","sap/ui/core/History","sap/ui/core/Renderer","./SearchFieldRenderer","sap/ui/core/library","./Button","sap/ui/Device","sap/ui/core/SeparatorItem","sap/ui/core/ListItem","sap/ui/events/KeyCodes","sap/ui/dom/containsOrEquals","sap/ui/core/Configuration","sap/ui/dom/jquery/rect","sap/ui/dom/jquery/getSelectedText"],function(jQuery,e,t,i,r,s,a,o,n,u,l,h,g,p,c,d,f,b,y){"use strict";var _=h.TextAlign;var m=h.ValueState;var v=o.extend("sap.ui.commons.SearchField",{metadata:{deprecated:true,interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",properties:{enableListSuggest:{type:"boolean",group:"Behavior",defaultValue:true},showListExpander:{type:"boolean",group:"Behavior",defaultValue:true},enableClear:{type:"boolean",group:"Behavior",defaultValue:false},showExternalButton:{type:"boolean",group:"Behavior",defaultValue:false},enableCache:{type:"boolean",group:"Behavior",defaultValue:true},enableFilterMode:{type:"boolean",group:"Behavior",defaultValue:false},value:{type:"string",group:"Data",defaultValue:""},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:m.None},placeholder:{type:"string",group:"Appearance",defaultValue:""},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:_.Begin},visibleItemCount:{type:"int",group:"Behavior",defaultValue:20},startSuggestion:{type:"int",group:"Behavior",defaultValue:3},maxSuggestionItems:{type:"int",group:"Behavior",defaultValue:10},maxHistoryItems:{type:"int",group:"Behavior",defaultValue:0}},aggregations:{searchProvider:{type:"sap.ui.core.search.SearchProvider",multiple:false}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{search:{parameters:{query:{type:"string"}}},suggest:{parameters:{value:{type:"string"}}}}}});var S=20;v.prototype.init=function(){I(this,this.getEnableListSuggest());this._oHistory=new n(this.getId());this._clearTooltipText=C("SEARCHFIELD_CLEAR_TOOLTIP")};v.prototype.exit=function(){if(this._ctrl){this._ctrl.destroy()}if(this._lb){this._lb.destroy()}if(this._btn){this._btn.destroy()}this._ctrl=null;this._lb=null;this._btn=null;this._oHistory=null};v.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};v.prototype.onAfterRendering=function(){if(this.getShowExternalButton()){var e=this._btn.$().outerWidth(true);this._ctrl.$().css(y.getRTL()?"left":"right",e+"px")}E(this)};v.prototype.getFocusDomRef=function(){return this._ctrl.getFocusDomRef()};v.prototype.getIdForLabel=function(){return this._ctrl.getId()+"-input"};v.prototype.onpaste=function(e){var t=this;setTimeout(function(){t._ctrl._triggerValueHelp=true;t._ctrl.onkeyup()},0)};v.prototype.oncut=v.prototype.onpaste;v.prototype.fireSearch=function(e){var t=jQuery(this._ctrl.getInputDomRef()).val();if(!this.getEditable()||!this.getEnabled()){return this}this.setValue(t);if(!t&&!this.getEnableFilterMode()){return this}if(!e){e={}}if(!e.noFocus){t=this.getValue();this.focus();if(t&&this.getMaxHistoryItems()>0){this._oHistory.add(t)}this.fireEvent("search",{query:t})}return this};v.prototype.hasListExpander=function(){return x()?false:this.getShowListExpander()};v.prototype.clearHistory=function(){this._oHistory.clear()};v.prototype.suggest=function(e,t){if(!this.getEnableListSuggest()||!e||!t){return}this._ctrl.updateSuggestions(e,t)};v.prototype.setEnableListSuggest=function(e){if(this.getEnableListSuggest()&&e||!this.getEnableListSuggest()&&!e){return this}I(this,e);this.setProperty("enableListSuggest",e);return this};v.prototype.getValue=function(){return A(this,"Value")};v.prototype.setValue=function(e){var t=P(this,"Value",e,!!this.getDomRef(),true);if(this.getEnableClear()&&this.getDomRef()){this.$().toggleClass("sapUiSearchFieldVal",!!e);E(this)}return t};v.prototype.setEnableCache=function(e){return this.setProperty("enableCache",e,true)};v.prototype.getEnabled=function(){return A(this,"Enabled")};v.prototype.setEnabled=function(e){if(this._btn){this._btn.setEnabled(e&&this.getEditable())}return P(this,"Enabled",e,false,true)};v.prototype.getEditable=function(){return A(this,"Editable")};v.prototype.setEditable=function(e){if(this._btn){this._btn.setEnabled(e&&this.getEnabled())}return P(this,"Editable",e,false,true)};v.prototype.getMaxLength=function(){return A(this,"MaxLength")};v.prototype.setMaxLength=function(e){return P(this,"MaxLength",e,false,true)};v.prototype.getValueState=function(){return A(this,"ValueState")};v.prototype.setValueState=function(e){return P(this,"ValueState",e,false,true)};v.prototype.getPlaceholder=function(){return A(this,"Placeholder")};v.prototype.setPlaceholder=function(e){return P(this,"Placeholder",e,false,true)};v.prototype.getTextAlign=function(){return A(this,"TextAlign")};v.prototype.setTextAlign=function(e){return P(this,"TextAlign",e,false,true)};v.prototype.getTooltip=function(){return A(this,"Tooltip")};v.prototype.setTooltip=function(e){return P(this,"Tooltip",e,true,false)};v.prototype.getVisibleItemCount=function(){return A(this,"MaxPopupItems")};v.prototype.setVisibleItemCount=function(e){return P(this,"MaxPopupItems",e,false,true)};v.prototype.setShowExternalButton=function(e){if(!this._btn){var t=this;this._btn=new g(this.getId()+"-btn",{text:C("SEARCHFIELD_BUTTONTEXT"),enabled:this.getEditable()&&this.getEnabled(),press:function(){t.fireSearch()}});this._btn.setParent(this)}this.setProperty("showExternalButton",e);return this};v.prototype.getAriaDescribedBy=function(){return this._ctrl.getAriaDescribedBy()};v.prototype.getAriaLabelledBy=function(){return this._ctrl.getAriaLabelledBy()};v.prototype.removeAllAriaDescribedBy=function(){return this._ctrl.removeAllAriaDescribedBy()};v.prototype.removeAllAriaLabelledBy=function(){return this._ctrl.removeAllAriaLabelledBy()};v.prototype.removeAriaDescribedBy=function(e){return this._ctrl.removeAriaDescribedBy(e)};v.prototype.removeAriaLabelledBy=function(e){return this._ctrl.removeAriaLabelledBy(e)};v.prototype.addAriaDescribedBy=function(e){this._ctrl.addAriaDescribedBy(e);return this};v.prototype.addAriaLabelledBy=function(e){this._ctrl.addAriaLabelledBy(e);return this};var E=function(e){var t=e.$(),i=e._ctrl.$("searchico");if(t.hasClass("sapUiSearchFieldClear")&&t.hasClass("sapUiSearchFieldVal")){i.attr("title",e._clearTooltipText)}else{i.removeAttr("title")}};var P=function(e,t,i,r,s){var a=A(e,t);e._ctrl["set"+t](i);if(!r){e.invalidate()}if(s){e.updateModelProperty(t.toLowerCase(),i,a)}return e};var A=function(e,t){return e._ctrl["get"+t]()};var I=function(e,t){if(!e._lb){e._lb=new i(e.getId()+"-lb")}var r=e._ctrl;var s=null;if(t){s=new v.CB(e.getId()+"-cb",{listBox:e._lb,maxPopupItems:S});s.addDependent(e._lb)}else{s=new v.TF(e.getId()+"-tf")}s.setParent(e);s.addEventDelegate({onAfterRendering:function(){E(e);var t=jQuery(s.getFocusDomRef());var i=t.attr("aria-labelledby")||"";if(i){i=" "+i}t.attr("aria-labelledby",e.getId()+"-label"+i)}});if(r){s.setValue(r.getValue());s.setEnabled(r.getEnabled());s.setEditable(r.getEditable());s.setMaxLength(r.getMaxLength());s.setValueState(r.getValueState());s.setPlaceholder(r.getPlaceholder());s.setTextAlign(r.getTextAlign());s.setTooltip(r.getTooltip());s.setMaxPopupItems(r.getMaxPopupItems());var a=r.getAriaDescribedBy();for(var o=0;o<a.length;o++){s.addAriaDescribedBy(a[o])}r.removeAllAriaDescribedBy();a=r.getAriaLabelledBy();for(var o=0;o<a.length;o++){s.addAriaLabelledBy(a[o])}r.removeAllAriaLabelledBy();r.removeAllDependents();r.destroy()}e._ctrl=s};var C=function(e,t){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(i){return i.getText(e,t)}return e};var x=function(){return p.browser.mobile&&!p.system.desktop};var V=function(e,t){e.write("<div");e.writeAttributeEscaped("id",t.getId()+"-searchico");e.writeAttribute("unselectable","on");if(y.getAccessibility()){e.writeAttribute("role","presentation")}e.addClass("sapUiSearchFieldIco");e.writeClasses();e.write("></div>")};r.extend("sap.ui.commons.SearchField.TF",{metadata:{library:"sap.ui.commons"},constructor:function(e,t){r.apply(this,arguments)},getInputDomRef:function(){return this.getDomRef("input")},onkeyup:function(e){v.CB.prototype.onkeyup.apply(this,arguments)},_triggerSuggest:function(e){this._sSuggest=null;if(e&&e.length>=this.getParent().getStartSuggestion()||!e&&this.getParent().getStartSuggestion()==0){this.getParent().fireSuggest({value:e})}},_checkChange:function(e,t){this.getParent().fireSearch({noFocus:t})},onsapfocusleave:function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur&&e.relatedControlId!=this.getId()){this.getRenderer().onblur(this)}this._checkChange(e,true)},onclick:function(e){if(e.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close()}if(this.getEditable()&&this.getEnabled()){this.focus()}if(!this.getParent().getEnableClear()){this._checkChange(e)}else{if(!jQuery(this.getInputDomRef()).val()||!this.getEditable()||!this.getEnabled()){return}this.setValue("");this._triggerValueHelp=true;this.onkeyup();if(this.getParent().getEnableFilterMode()){jQuery(this.getInputDomRef()).val("");this.getParent().fireSearch()}}}},getMaxPopupItems:function(){return this._iVisibleItemCount?this._iVisibleItemCount:S},setMaxPopupItems:function(e){this._iVisibleItemCount=e},renderer:{renderOuterContentBefore:V,renderOuterAttributes:function(e,t){e.addClass("sapUiSearchFieldTf")},renderInnerAttributes:function(e,t){if(!p.os.ios){e.writeAttribute("type","search")}if(x()){e.writeAttribute("autocapitalize","off");e.writeAttribute("autocorrect","off")}}}});v.TF.prototype.getFocusDomRef=v.TF.prototype.getInputDomRef;e.extend("sap.ui.commons.SearchField.CB",{metadata:{library:"sap.ui.commons"},constructor:function(t,i){e.apply(this,arguments);this._mSuggestions={};this._aSuggestValues=[];this.mobile=false},updateSuggestions:function(e,t){this._mSuggestions[e]=t;if(this.getInputDomRef()&&jQuery(this.getInputDomRef()).val()===e&&this._hasSuggestValue(e)){this._doUpdateList(e)}},applyFocusInfo:function(e){jQuery(this.getInputDomRef()).val(e.sTypedChars);return this},_getListBox:function(){return this.getParent()._lb},_hasSuggestValue:function(e){return this._aSuggestValues.length>0&&e==this._aSuggestValues[this._aSuggestValues.length-1]},_doUpdateList:function(e,t){var i=this._updateList(e);this._aSuggestValues=[e];if((!this.oPopup||!this.oPopup.isOpen())&&!t&&!i){this._open()}else if(this.oPopup&&this.oPopup.isOpen()&&i){this._close()}if(!i&&!this._lastKeyIsDel&&e===jQuery(this.getInputDomRef()).val()){this._doTypeAhead()}},onclick:function(t){e.prototype.onclick.apply(this,arguments);if(t.target===this.getDomRef("searchico")){if(this.oPopup&&this.oPopup.isOpen()){this.oPopup.close()}if(!this.getParent().getEnableClear()){this.getParent().fireSearch()}else if(jQuery(this.getInputDomRef()).val()&&this.getEditable()&&this.getEnabled()){this.setValue("");this._triggerValueHelp=true;this.onkeyup();this._aSuggestValues=[];if(this.getParent().getEnableFilterMode()){jQuery(this.getInputDomRef()).val("");this.getParent().fireSearch()}}if(this.getEditable()&&this.getEnabled()){this.focus()}}else if(b(this.getDomRef("providerico"),t.target)){if(this.getEditable()&&this.getEnabled()){this.focus()}}},onkeypress:v.TF.prototype.onkeypress,onkeyup:function(t){var i=jQuery(this.getInputDomRef());var r=i.val();this.getParent().$().toggleClass("sapUiSearchFieldVal",!!r);E(this.getParent());if(t){if(t.keyCode===f.F2){var s=jQuery(this.getFocusDomRef());var a=s.data("sap.InNavArea");if(typeof a==="boolean"){s.data("sap.InNavArea",!a)}}if(e._isHotKey(t)||t.keyCode===f.F4&&t.which===0){return}if(r&&r==i.getSelectedText()){return}var o=t.which||t.keyCode;if(o!==f.ESCAPE||this instanceof v.TF){this._triggerValueHelp=true;this._lastKeyIsDel=o==f.DELETE||o==f.BACKSPACE}}if(this._triggerValueHelp){this._triggerValueHelp=false;if(this._sSuggest){clearTimeout(this._sSuggest);this._sSuggest=null}var n=jQuery(this.getInputDomRef()).val();if(n&&n.length>=this.getParent().getStartSuggestion()||!n&&this.getParent().getStartSuggestion()==0){this._sSuggest=setTimeout(function(){this._triggerSuggest(n)}.bind(this),200)}else if(this._doUpdateList){this._doUpdateList(n,true)}}},_triggerSuggest:function(e){this._sSuggest=null;if(!this._mSuggestions[e]||!this.getParent().getEnableCache()){this._aSuggestValues.push(e);var t=this.getParent().getSearchProvider();if(t){var i=this.getParent();t.suggest(e,function(e,t){if(i){i.suggest(e,t)}})}else{this.getParent().fireSuggest({value:e})}}else{this._doUpdateList(e)}},_updateList:function(e){var t=false;var i=this._getListBox();i.destroyAggregation("items",true);var r=function(e,t,i,r){t=t?t:[];var s=Math.min(t.length,i);if(r&&s>0){e.addItem(new c)}for(var a=0;a<s;a++){e.addItem(new d({text:t[a]}))}return s};var s=r(i,this.getParent()._oHistory.get(e),this.getParent().getMaxHistoryItems(),false);var a=r(i,e&&e.length>=this.getParent().getStartSuggestion()?this._mSuggestions[e]:[],this.getParent().getMaxSuggestionItems(),s>0);if(s<=0&&a==0){i.addItem(new d({text:C("SEARCHFIELD_NO_ITEMS"),enabled:false}));t=true}var o=i.getItems().length;var n=this.getMaxPopupItems();i.setVisibleItems(n<o?n:o);i.setSelectedIndex(-1);i.setMinWidth(jQuery(this.getDomRef()).rect().width+"px");i.rerender();return t},_prepareOpen:function(){},_open:function(){e.prototype._open.apply(this,[0])},_rerenderListBox:function(){return this._updateList(this._aSuggestValues.length>0?this._aSuggestValues[this._aSuggestValues.length-1]:null)&&!this._forceOpen},_checkChange:function(e,t,i){this.getParent().fireSearch({noFocus:i})},onsapfocusleave:function(e){if(e.relatedControlId===this._getListBox().getId()){this.focus();return}this._checkChange(e,true,true)},onfocusout:function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}this._checkChange(e,true,true)},onsapshow:function(t){if(this.getParent().hasListExpander()){e.prototype.onsapshow.apply(this,arguments)}else{t.preventDefault();t.stopImmediatePropagation()}},_handleSelect:function(t){var i=e.prototype._handleSelect.apply(this,arguments);if(i&&i.getEnabled()){this.getParent().fireSearch()}},renderer:{renderOuterContentBefore:function(e,i){if(i.getParent().hasListExpander()){t.renderOuterContentBefore.apply(this,arguments)}V.apply(this,arguments);if(i.getParent().getSearchProvider()&&i.getParent().getSearchProvider().getIcon()){e.write("<div");e.writeAttributeEscaped("id",i.getId()+"-providerico");e.writeAttribute("unselectable","on");if(y.getAccessibility()){e.writeAttribute("role","presentation")}e.addClass("sapUiSearchFieldProvIco");e.writeClasses();e.write('><img src="'+i.getParent().getSearchProvider().getIcon()+'"></div>')}},renderOuterAttributes:function(e,i){t.renderOuterAttributes.apply(this,arguments);e.addClass("sapUiSearchFieldCb");if(i.getParent().getSearchProvider()&&i.getParent().getSearchProvider().getIcon()){e.addClass("sapUiSearchFieldCbProv")}},renderInnerAttributes:function(e,t){if(!p.os.ios){e.writeAttribute("type","search")}if(x()){e.writeAttribute("autocapitalize","off");e.writeAttribute("autocorrect","off")}}}});return v});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SearchFieldRenderer", [],function(){"use strict";var e={};e.render=function(e,a){e.write("<div");e.writeControlData(a);e.addClass("sapUiSearchField");if(!a.getEditable()||!a.getEnabled()){e.addClass("sapUiSearchFieldDsbl")}if(!a.hasListExpander()){e.addClass("sapUiSearchFieldNoExp")}if(a.getEnableClear()){e.addClass("sapUiSearchFieldClear")}if(a.getWidth()){e.addStyle("width",a.getWidth())}if(a.getValue()){e.addClass("sapUiSearchFieldVal")}e.writeClasses();e.writeStyles();e.write(">");e.renderControl(a._ctrl);if(a.getShowExternalButton()){e.renderControl(a._btn)}var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");e.write("<span id='",a.getId(),"-label' style='display:none;' aria-hidden='true'>");e.writeEscaped(t.getText("SEARCHFIELD_BUTTONTEXT"));e.write("</span>");e.write("</div>")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SearchProvider", ["./library","sap/ui/core/search/OpenSearchProvider"],function(e,r){"use strict";var t=r.extend("sap.ui.commons.SearchProvider",{metadata:{deprecated:true,library:"sap.ui.commons"}});t.prototype._doSuggest=function(e,r){this.suggest(r,function(r,t){if(e&&e.suggest){e.suggest(r,t)}})};return t});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SegmentedButton", ["sap/ui/thirdparty/jquery","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","./SegmentedButtonRenderer"],function(jQuery,t,e,o){"use strict";var i=t.extend("sap.ui.commons.SegmentedButton",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{enabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{buttons:{type:"sap.ui.commons.Button",multiple:true,singularName:"button"}},associations:{selectedButton:{type:"sap.ui.commons.Button",multiple:false}},events:{select:{parameters:{selectedButtonId:{type:"string"}}}}}});i.prototype.init=function(){if(!this._oItemNavigation){this._oItemNavigation=new e;this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation)}this._oButtonDelegate={oSegmentedButton:this,onAfterRendering:this._buttonOnAfterRendering}};i.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation}};i.prototype.onAfterRendering=function(){this._setItemNavigation(true)};i.prototype._buttonSelected=function(t){var e=sap.ui.getCore().byId(this.getSelectedButton()),o=t.getSource();if(o!==e){this.setSelectedButton(o);this.fireSelect({selectedButtonId:o.getId()})}};i.prototype._setItemNavigation=function(t){var e,o,i=[];if(!this.getEnabled()){return}if(this.getDomRef()){this._oItemNavigation.setRootDomRef(this.getDomRef("radiogroup"));o=this.getButtons();for(var n=0;n<o.length;n++){e=o[n];i.push(e.getDomRef());this._setAriaInfo(e,n+1);if(t){e.removeDelegate(this._oButtonDelegate);e.addDelegate(this._oButtonDelegate)}}this._oItemNavigation.setItemDomRefs(i)}};i.prototype._setAriaInfo=function(t,e){var o=jQuery(t.getDomRef()),i=this.getButtons().length;o.attr("aria-posinset",e);o.attr("aria-setsize",i);o.attr("role","radio");if(t.getId()===this.getSelectedButton()){o.attr("aria-checked","true");o.removeAttr("aria-describedby")}else{o.removeAttr("aria-checked");o.attr("aria-describedby",this.getId()+"-label")}};i.prototype._buttonOnAfterRendering=function(){this.oSegmentedButton._setItemNavigation()};i.prototype._rerenderButtons=function(){var t=this.$();if(t.length>0){var e=sap.ui.getCore().createRenderManager();o.renderButtons(e,this);e.flush(t[0]);e.destroy()}};i.prototype.addButton=function(t){this.addAggregation("buttons",t,true);t.attachPress(this._buttonSelected,this);this._rerenderButtons();return this};i.prototype.insertButton=function(t,e){this.insertAggregation("buttons",t,e,true);t.attachPress(this._buttonSelected,this);this._rerenderButtons();return this};i.prototype.removeButton=function(t){var e=this.removeAggregation("buttons",t,true);if(e){e.detachPress(this._buttonSelected,this);e.removeDelegate(this._oButtonDelegate);this._rerenderButtons()}return e};i.prototype.removeAllButtons=function(){var t=this.removeAllAggregation("buttons",true);jQuery.each(t,function(t,e){e.detachPress(this._buttonSelected,this);e.removeDelegate(this._oButtonDelegate)});this._rerenderButtons();return t};i.prototype.setSelectedButton=function(t){var e,o=sap.ui.getCore().byId(this.getSelectedButton());this.setAssociation("selectedButton",t,true);e=sap.ui.getCore().byId(this.getSelectedButton());this._setItemNavigation();var i=this.getButtons();for(var n=0;n<i.length;n++){if(i[n]===e){this._oItemNavigation.setFocusedIndex(n);break}}if(o){o.removeStyleClass("sapUiSegButtonSelected");o.$().trigger("blur")}if(o&&o._icon){o.setIcon(o._icon);o._icon=null}if(e){if(e.getIconHovered()){e._icon=e.getIcon();e.setIcon(e.getIconHovered())}e.addStyleClass("sapUiSegButtonSelected")}return this};i.prototype.setEnabled=function(t){jQuery.each(this.getButtons(),function(e,o){o.setEnabled(t)});if(this._oItemNavigation&&!t){this.removeDelegate(this._oItemNavigation)}else{this.addDelegate(this._oItemNavigation)}this.setProperty("enabled",t);return this};i.prototype.clone=function(e){var o=this.getButtons(),i,n=0;for(;n<o.length;n++){i=o[n];i.detachPress(this._buttonSelected,this)}var s=t.prototype.clone.apply(this,arguments);for(n=0;n<o.length;n++){i=o[n];i.attachPress(this._buttonSelected,this)}return s};i.prototype.getFocusDomRef=function(){return this.getDomRef("radiogroup")||null};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SegmentedButtonRenderer", [],function(){"use strict";var e={};e.render=function(e,t){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons"),r=i.getText("SEGMENTEDBUTTON_ARIA_SELECT");e.write("<span");e.writeControlData(t);e.addClass("sapUiSegmentedButton");e.writeClasses();e.write(">");e.write('<span id="'+t.getId()+'-radiogroup"');e.writeAccessibilityState(t,{role:"radiogroup",disabled:!t.getEnabled()});if(t.getEnabled()){e.writeAttribute("tabindex","0")}else{e.writeAttribute("tabindex","-1")}e.write(">");this.renderButtons(e,t);e.write("</span>");e.write('<span id="'+t.getId()+'-label" style="visibility: hidden; display: none;">');e.writeEscaped(r);e.write("</span>");e.write("</span>")};e.renderButtons=function(e,t){t.getButtons().forEach(function(t){e.renderControl(t)})};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Slider", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/ui/dom/containsOrEquals","sap/ui/events/ControlEvents","./library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/ResizeHandler","./SliderRenderer","sap/ui/core/Configuration"],function(jQuery,t,i,e,s,a,h,r,o,l){"use strict";var n=a.extend("sap.ui.commons.Slider",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},min:{type:"float",group:"Appearance",defaultValue:0},max:{type:"float",group:"Appearance",defaultValue:100},value:{type:"float",group:"Appearance",defaultValue:50},smallStepWidth:{type:"float",group:"Appearance",defaultValue:null},totalUnits:{type:"int",group:"Appearance",defaultValue:null},stepLabels:{type:"boolean",group:"Appearance",defaultValue:false},editable:{type:"boolean",group:"Behavior",defaultValue:true},enabled:{type:"boolean",group:"Behavior",defaultValue:true},labels:{type:"string[]",group:"Misc",defaultValue:null},vertical:{type:"boolean",group:"Appearance",defaultValue:false},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"float"}}},liveChange:{parameters:{value:{type:"float"}}}}}});h.call(n.prototype);n.prototype.exit=function(){if(this.sResizeListenerId){r.deregister(this.sResizeListenerId);this.sResizeListenerId=null}};n.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){r.deregister(this.sResizeListenerId);this.sResizeListenerId=null}var i=this.getMin();var e=this.getMax();if(i>e){t.warning("Property wrong: Min:"+i+" > Max:"+e+"; values switched",this);this.setMin(e);this.setMax(i);e=i;i=this.getMin()}};n.prototype.onAfterRendering=function(){this.oGrip=this.getDomRef("grip");this.oBar=this.getDomRef("bar");this.oHiLi=this.getDomRef("hili");this.bRtl=l.getRTL();this.bAcc=l.getAccessibility();this.bTextLabels=this.getLabels()&&this.getLabels().length>0;this.oMovingGrip=this.oGrip;if(this.bTextLabels&&this.getLabels().length-1!=this.getTotalUnits()){t.warning("label count should be one more than total units",this)}this.iDecimalFactor=this.calcDecimalFactor(this.getSmallStepWidth());this.iShiftGrip=Math.round(this.getOffsetWidth(this.oGrip)/2);var i=this.getValue();var e=this.getMin();var s=this.getMax();if(i>s){t.warning("Property wrong: value:"+i+" > Max:"+s+"; value set to Max",this);i=s}else if(i<e){t.warning("Property wrong: value:"+i+" < Min:"+e+"; value set to Min",this);i=e}var a=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl||this.getVertical()){a=this.getBarWidth()-a}this.changeGrip(i,a,this.oGrip);this.repositionTicksAndLabels();this.allowTextSelection(false);this.oDomRef=this.getDomRef();this.sResizeListenerId=r.register(this.oDomRef,jQuery.proxy(this.onresize,this))};n.prototype.onclick=function(t){var i=this.oMovingGrip;if(this.getEditable()&&this.getEnabled()){var e;var s=t.target.getAttribute("ID");var a=this.getValue();var h=this.getOffsetLeft(this.oGrip)+this.iShiftGrip;var r=0;var o=0;var l=0;switch(s){case this.oBar.id:case this.oHiLi.id:if(this.getVertical()){e=this.getBarWidth()-this.getOffsetX(t)}else{e=this.getOffsetX(t)}if(s==this.oHiLi.id){if(this.getVertical()){e-=this.getOffsetLeft(this.oHiLi)}else{e+=this.getOffsetLeft(this.oHiLi)}}a=this.convertRtlValue(this.getMin()+(this.getMax()-this.getMin())/this.getBarWidth()*e);h=this.getOffsetX(t);if(s==this.oHiLi.id){h+=this.getOffsetLeft(this.oHiLi)}if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){i=this.oStartTarget}else if(this.targetIsGrip(s)){i=t.target}else{i=this.getNearestGrip(h)}break;case this.getId()+"-left":h=0;if(this.getVertical()){a=this.getMax();i=this.getRightGrip()}else{a=this.getMin();i=this.getLeftGrip()}break;case this.getId()+"-right":h=this.getBarWidth();if(!this.getVertical()){a=this.getMax();i=this.getRightGrip()}else{a=this.getMin();i=this.getLeftGrip()}break;default:if(this.targetIsGrip(s)){return}r=s.search("-tick");if(r>=0){var n=parseInt(s.slice(this.getId().length+5));h=this.fTickDist*n;var g;if(this.bTextLabels){g=this.getLabels().length-1}else{g=this.getTotalUnits()}a=this.convertRtlValue(this.getMin()+(this.getMax()-this.getMin())/g*n);if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){i=this.oStartTarget}else if(this.targetIsGrip(s)){i=t.target}else{i=this.getNearestGrip(h)}break}o=jQuery(this.oBar).offset();l=jQuery(t.target).offset();if(this.getVertical()){h=this.getOffsetX(t)-(o.top-l.top)}else{h=this.getOffsetX(t)-(o.left-l.left)}if(h<=0){h=0;if(this.getVertical()){a=this.getMax()}else{a=this.getMin()}}else{if(h>=this.getBarWidth()){h=this.getBarWidth();if(this.getVertical()){a=this.getMin()}else{a=this.getMax()}}else{if(this.getVertical()){e=this.getBarWidth()-h}else{e=h}a=this.getMin()+(this.getMax()-this.getMin())/this.getBarWidth()*e}}a=this.convertRtlValue(a);if(this.oStartTarget&&this.targetIsGrip(this.oStartTarget.id)){i=this.oStartTarget}else if(this.targetIsGrip(s)){i=t.target}else{i=this.getNearestGrip(h)}break}var f=this.validateNewPosition(a,h,i,this.getValueForGrip(i)>a);a=f.fNewValue;h=f.iNewPos;this.changeGrip(a,h,i);this.handleFireChange()}i.focus();this.oMovingGrip=i;this.oStartTarget=null};n.prototype.onmousedown=function(t){if(this.getEditable()&&this.getEnabled()&&!this._cancelMousedown){var i=t.target.getAttribute("ID");if(this.targetIsGrip(i)){this.bGripMousedown=true;if(t.targetTouches){this.iStartDragX=t.targetTouches[0].pageX;this.iStartDragY=t.targetTouches[0].pageY}else{this.iStartDragX=t.pageX;this.iStartDragY=t.pageY}this.iStartLeft=this.getOffsetLeft(t.target)+this.iShiftGrip;this.oMovingGrip=t.target;var s=this;this.handleMoveCall=function(t){s.handleMove(t)};this.preventSelect=function(t){return false};if(!t.targetTouches){jQuery(window.document).on("mousemove",this.handleMoveCall);jQuery(window.document).on("selectstart",this.preventSelect);e.bindAnyEvent(jQuery.proxy(this.onAnyEvent,this))}}this.oStartTarget=null}};function g(t){return t.originalEvent&&t.originalEvent.type&&t.originalEvent.type.startsWith("mouse")||t.handleObj&&t.handleObj.origType&&t.handleObj.origType.startsWith("mouse")}n.prototype.ontouchstart=function(t){if(g(t)){return}this._cancelMousedown=false;this.onmousedown(t);this._cancelMousedown=true};n.prototype.onmouseup=function(t){if(this.getEditable()&&this.getEnabled()){this.bGripMousedown=false;if(this.handleMoveCall){jQuery(window.document).off("mousemove",this.handleMoveCall);jQuery(window.document).off("selectstart",this.preventSelect);e.unbindAnyEvent(this.onAnyEvent);if(this.iStartLeft!=this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip){this.handleFireChange(true)}this.handleMoveCall=null;this.iStartDragX=null;this.iStartDragY=null;this.iStartLeft=null}}};n.prototype.ontouchend=function(t){if(g(t)){return}this.onmouseup(t)};n.prototype.handleMove=function(t){if(this.getEditable()&&this.getEnabled()&&this.bGripMousedown){t=t||window.event;var i,e;if(t.targetTouches){i=t.targetTouches[0].pageX;e=t.targetTouches[0].pageY}else{i=t.pageX;e=t.pageY}var s;var a;if(this.getVertical()){s=this.iStartLeft+e-this.iStartDragY}else{s=this.iStartLeft+i-this.iStartDragX}if(s<=0){s=0;if(this.getVertical()){a=this.getMax()}else{a=this.getMin()}}else{if(s>=this.getBarWidth()){s=this.getBarWidth();if(this.getVertical()){a=this.getMin()}else{a=this.getMax()}}else{var h;if(this.getVertical()){h=this.getBarWidth()-s}else{h=s}a=this.getMin()+(this.getMax()-this.getMin())/this.getBarWidth()*h}}a=this.convertRtlValue(a);var r=this.getValueForGrip(this.oMovingGrip);var o=this.validateNewPosition(a,s,this.oMovingGrip,r>a);a=o.fNewValue;s=o.iNewPos;this.changeGrip(a,s,this.oMovingGrip);a=this.getValueForGrip(this.oMovingGrip);this.fireLiveChangeForGrip(this.oMovingGrip,a,r);this.oStartTarget=this.oMovingGrip}t.cancelBubble=true;return false};n.prototype.ontouchmove=function(t){if(g(t)){return}this.handleMove(t);t.preventDefault()};n.prototype.fireLiveChangeForGrip=function(t,i,e){if(t==this.oGrip){if(e!=i){this.fireLiveChange({value:i})}}};n.prototype.onAnyEvent=function(e){t.debug('onAnyEvent fired: "'+e.type+'"');if(!this.getEditable()||!this.getEnabled()||!this.bGripMousedown){return}var s=e.target;if((!i(this.oDomRef,s)||s.tagName=="BODY")&&e.type=="mouseup"){this.onmouseup(e)}};n.prototype.onsapright=function(t){if(this.getEditable()&&this.getEnabled()){var i=this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));var e=this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip;if(this.getSmallStepWidth()>0){var s=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if(s>1){i=i+this.getSmallStepWidth();if(this.getVertical()){e=e-s}else{e=e+s}}else{i=i+1/s*this.getSmallStepWidth();if(this.getVertical()){e=e-1}else{e=e+1}}}else{i=i+(this.getMax()-this.getMin())/this.getBarWidth();if(this.getVertical()){e=e-1}else{e=e+1}}i=this.convertRtlValue(i);var a=this.validateNewPosition(i,e,this.oMovingGrip,!this.getVertical()&&this.bRtl);i=a.fNewValue;e=a.iNewPos;this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsapleft=function(t){if(this.getEditable()&&this.getEnabled()){var i=this.convertRtlValue(this.getValueForGrip(this.oMovingGrip));var e=this.getOffsetLeft(this.oMovingGrip)+this.iShiftGrip;if(this.getSmallStepWidth()>0){var s=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if(s>1){i=i-this.getSmallStepWidth();if(this.getVertical()){e=e+s}else{e=e-s}}else{i=i-1/s*this.getSmallStepWidth();if(this.getVertical()){e=e+1}else{e=e-1}}}else{i=i-(this.getMax()-this.getMin())/this.getBarWidth();if(this.getVertical()){e=e+1}else{e=e-1}}i=this.convertRtlValue(i);var a=this.validateNewPosition(i,e,this.oMovingGrip,this.getVertical()||!this.bRtl);i=a.fNewValue;e=a.iNewPos;this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsapup=function(t){if(this.bRtl&&!this.getVertical()){this.onsapleft(t)}else{this.onsapright(t)}};n.prototype.onsapdown=function(t){if(this.bRtl&&!this.getVertical()){this.onsapright(t)}else{this.onsapleft(t)}};n.prototype.onsapexpand=function(t){if(!this.bRtl){this.onsapright(t)}else{this.onsapleft(t)}};n.prototype.onsapcollapse=function(t){if(!this.bRtl){this.onsapleft(t)}else{this.onsapright(t)}};n.prototype.onsaphome=function(t){if(this.getEditable()&&this.getEnabled()){var i=0;if(this.getVertical()||this.bRtl&&!this.getVertical()){i=this.getBarWidth()}this.changeGrip(this.getMin(),i,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsapend=function(t){if(this.getEditable()&&this.getEnabled()){var i=this.getBarWidth();if(this.getVertical()||this.bRtl&&!this.getVertical()){i=0}this.changeGrip(this.getMax(),i,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsaprightmodifiers=function(t){if(this.getEditable()&&this.getEnabled()){if(!this.fPageSize){if(this.getTotalUnits()>0){this.fPageSize=(this.getMax()-this.getMin())/this.getTotalUnits()}else{this.fPageSize=(this.getMax()-this.getMin())/10}}var i;if(!this.bRtl||this.getVertical()){i=this.getValueForGrip(this.oMovingGrip)+this.fPageSize}else{i=this.getValueForGrip(this.oMovingGrip)-this.fPageSize}var e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}if(this.getVertical()){if(e>this.getBarWidth()){e=this.getBarWidth()}e=this.getBarWidth()-e}var s=this.validateNewPosition(i,e,this.oMovingGrip,!this.getVertical()&&this.bRtl);i=s.fNewValue;e=s.iNewPos;this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsapleftmodifiers=function(t){if(this.getEditable()&&this.getEnabled()){if(!this.fPageSize){if(this.getTotalUnits()>0){this.fPageSize=(this.getMax()-this.getMin())/this.getTotalUnits()}else{this.fPageSize=(this.getMax()-this.getMin())/10}}var i;if(!this.bRtl||this.getVertical()){i=this.getValueForGrip(this.oMovingGrip)-this.fPageSize}else{i=this.getValueForGrip(this.oMovingGrip)+this.fPageSize}var e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.bRtl&&!this.getVertical()){e=this.getBarWidth()-e}if(this.getVertical()){if(e<0){e=0}e=this.getBarWidth()-e}var s=this.validateNewPosition(i,e,this.oMovingGrip,this.getVertical()||!this.bRtl);i=s.fNewValue;e=s.iNewPos;this.changeGrip(i,e,this.oMovingGrip);this.handleFireChange()}t.preventDefault();t.stopPropagation()};n.prototype.onsapdownmodifiers=function(t){if(this.bRtl&&!this.getVertical()){this.onsaprightmodifiers(t)}else{this.onsapleftmodifiers(t)}};n.prototype.onsapupmodifiers=function(t){if(this.bRtl&&!this.getVertical()){this.onsapleftmodifiers(t)}else{this.onsaprightmodifiers(t)}};n.prototype.onresize=function(t){if(!this.getDomRef()){if(this.sResizeListenerId){r.deregister(this.sResizeListenerId);this.sResizeListenerId=null}return}var i=this.getValue();var e=(i-this.getMin())/(this.getMax()-this.getMin())*this.getBarWidth();if(this.getVertical()||this.bRtl){e=this.getBarWidth()-e}this.changeGrip(i,e,this.oGrip);this.repositionTicksAndLabels()};n.prototype.repositionTicksAndLabels=function(){var t;if(this.bTextLabels){t=this.getLabels().length-1}else{t=this.getTotalUnits()}if(t>0){var i=null;var e=null;this.fTickDist=this.getBarWidth()/t;for(var s=0;s<=t;s++){i=this.getDomRef("tick"+s);var a=0;if(!this.bRtl||this.getVertical()){a=Math.round(this.fTickDist*s)-Math.ceil(this.getOffsetWidth(i)/2)}else{a=Math.round(this.fTickDist*s)-Math.floor(this.getOffsetWidth(i)/2)}if(this.getVertical()){a=this.getBarWidth()-a-this.getOffsetWidth(i)}this.setLeft(a,i);if(this.getStepLabels()&&s>0&&s<t){e=this.getDomRef("text"+s);if(this.getSmallStepWidth()>0&&this.iDecimalFactor>0&&!this.bTextLabels){jQuery(e).text(Math.round(parseFloat(jQuery(e).text())*this.iDecimalFactor)/this.iDecimalFactor)}if(!this.bRtl||this.getVertical()){a=Math.round(this.fTickDist*s)-Math.round(this.getOffsetWidth(e)/2)}else{a=Math.round(this.fTickDist*(t-s))-Math.round(this.getOffsetWidth(e)/2)}if(this.getVertical()){a=this.getBarWidth()-a-this.getOffsetWidth(e)}this.setLeft(a,e)}}}};n.prototype.onThemeChanged=function(t){if(this.getDomRef()){this.iShiftGrip=Math.round(this.getOffsetWidth(this.oGrip)/2);this.onresize()}};n.prototype.changeGrip=function(i,e,s){if(e!=this.getOffsetLeft(s)+this.iShiftGrip){if(this.getSmallStepWidth()>0){var a=parseInt((i-this.getMin())/this.getSmallStepWidth());var h=a*this.getSmallStepWidth()+this.getMin();var r=(a+1)*this.getSmallStepWidth()+this.getMin();if(r>this.getMax()){r=this.getMax()}var o=this.getBarWidth()/(this.getMax()-this.getMin())*this.getSmallStepWidth();if(i-h<r-i){i=h;e=a*o}else{i=r;e=(a+1)*o;if(e>this.getBarWidth()){e=this.getBarWidth()}}if(this.getVertical()||this.bRtl){e=this.getBarWidth()-e}i=Math.round(i*this.iDecimalFactor)/this.iDecimalFactor}var l=Math.round(e-this.iShiftGrip);if(isNaN(l)){return}t.debug("iNewPos: "+e+" - iLeft: "+l+" - iShiftGrip: "+this.iShiftGrip);this.updateValueProperty(i,s);if(this.bTextLabels){s.title=this.getNearestLabel(i)}else{s.title=i}this.setLeft(l,s);this.adjustHighlightBar(e,s);if(this.bAcc){this.setAriaState()}}};n.prototype.updateValueProperty=function(t,i){this.setProperty("value",t,true)};n.prototype.adjustHighlightBar=function(t,i){if(this.bRtl){if(this.getVertical()){this.oHiLi.style.height=this.getBarWidth()-Math.round(t)+"px"}else{this.oHiLi.style.width=this.getBarWidth()-Math.round(t)+"px"}}else{if(this.getVertical()){this.oHiLi.style.height=this.getBarWidth()-Math.round(t)+"px"}else{this.oHiLi.style.width=Math.round(t)+"px"}}};n.prototype.calcDecimalFactor=function(t){var i=1;if(!(t>0)){return i}var e=String(t);var s=0;if(e.indexOf(".")>=0){s=e.length-e.indexOf(".")-1}else{if(e.indexOf("e-")>=0){s=e.slice(e.indexOf("e-")+2)}else{return i}}for(var a=1;a<=s;a++){i=i*10}return i};n.prototype.setEditable=function(t){this.setProperty("editable",t,true);if(this.oDomRef&&this.getEnabled()){if(t){jQuery(this.oDomRef).removeClass("sapUiSliRo").addClass("sapUiSliStd");if(this.bAcc){jQuery(this.oGrip).attr("aria-disabled",false).attr("aria-readonly",false)}}else{jQuery(this.oDomRef).removeClass("sapUiSliStd").addClass("sapUiSliRo");if(this.bAcc){jQuery(this.oGrip).attr("aria-disabled",true).attr("aria-readonly",true)}}}return this};n.prototype.setEnabled=function(t){this.setProperty("enabled",t,true);if(this.oDomRef){jQuery(this.oDomRef).toggleClass("sapUiSliDsbl",!t);if(t){jQuery(this.oGrip).attr("tabindex","0");if(this.getEditable()){jQuery(this.oDomRef).addClass("sapUiSliStd");if(this.bAcc){jQuery(this.oGrip).attr("aria-disabled",false)}}else{jQuery(this.oDomRef).addClass("sapUiSliRo");if(this.bAcc){jQuery(this.oGrip).attr("aria-disabled",true)}}}else{jQuery(this.oGrip).attr("tabindex","-1").attr("aria-disabled",true);if(this.getEditable()){jQuery(this.oDomRef).removeClass("sapUiSliStd")}else{jQuery(this.oDomRef).removeClass("sapUiSliRo")}}}return this};n.prototype.setTotalUnits=function(t){this.setProperty("totalUnits",t,false);this.fPageSize=false;return this};n.prototype.setValue=function(t){var i,e,s,a,h,r=parseFloat(t);this.setProperty("value",t,true);this._lastValue=t;if(!this.oBar||isNaN(t)){return this}e=this.getMin();s=this.getMax();a=this.getBarWidth();h=this.getVertical();if(r>s){r=s;i=a}else if(r<e){r=e;i=0}else{i=(r-e)/(s-e)*a}if(this.bRtl||h){i=a-i}this.changeGrip(r,i,this.oGrip);this._lastValue=r;return this};n.prototype.handleFireChange=function(t){var i=this.getValue();if(i!==this._lastValue){this.fireChange({value:i});if(!t){this.fireLiveChange({value:i})}this._lastValue=i}};n.prototype.setAriaState=function(){var t=this.getValue();if(this.bTextLabels){t=this.getNearestLabel(t)}this.oGrip.setAttribute("aria-valuenow",t)};n.prototype.getValueForGrip=function(t){return this.getValue()};n.prototype.validateNewPosition=function(t,i,e,s){if(!this.bRtl||this.getVertical()){if(s){if(t<=this.getMin()||i<=0){t=this.getMin();if(this.getVertical()){i=this.getBarWidth()}else{i=0}}}else{if(t>=this.getMax()||i>this.getBarWidth()){t=this.getMax();if(!this.getVertical()){i=this.getBarWidth()}else{i=0}}}}else{if(s){if(t<=this.getMin()||i>this.getBarWidth()){t=this.getMin();i=this.getBarWidth()}}else{if(t>=this.getMax()||i<=0){t=this.getMax();i=0}}}return{fNewValue:t,iNewPos:i}};n.prototype.getNearestLabel=function(t){var i=Math.round((this.getLabels().length-1)/(this.getMax()-this.getMin())*(t-this.getMin()));if(this.bRtl){i=this.getLabels().length-1-i}return this.getLabels()[i]};n.prototype.getNearestGrip=function(t){return this.oGrip};n.prototype.getLeftGrip=function(){return this.oGrip};n.prototype.getRightGrip=function(){return this.oGrip};n.prototype.setLeft=function(t,i){if(i==undefined){return}if(this.getVertical()){i.style.top=t+"px"}else{i.style.left=t+"px"}};n.prototype.getOffsetWidth=function(t){if(this.getVertical()){return t.offsetHeight}else{return t.offsetWidth}};n.prototype.getBarWidth=function(){if(this.getVertical()){return this.oBar.clientHeight}else{return this.oBar.clientWidth}};n.prototype.getOffsetLeft=function(t){if(this.getVertical()){return t.offsetTop}else{return t.offsetLeft}};n.prototype.getOffsetX=function(t){if(this.getVertical()){return t.getOffsetY()}else{if(this.bRtl){return t.getOffsetX()}else{return t.getOffsetX()}}};n.prototype.convertRtlValue=function(t){if(this.bRtl&&!this.getVertical()){t=this.getMax()-t+this.getMin()}return t};n.prototype.targetIsGrip=function(t){if(t==this.oGrip.id){return true}return false};n.prototype.getFocusDomRef=function(){return this.oGrip};n.prototype.getIdForLabel=function(){return this.getId()+"-grip"};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SliderRenderer", [],function(){"use strict";var i={};i.render=function(i,t){i.write("<div");i.writeControlData(t);i.addClass("sapUiSli");this.controlAdditionalCode(i,t);if(t.getTooltip_AsString()){i.writeAttributeEscaped("title",t.getTooltip_AsString())}if(!t.getVertical()&&t.getWidth()){i.writeAttribute("style","width:"+t.getWidth()+";")}else{i.writeAttribute("style","height:"+t.getHeight()+";")}if(!t.getEnabled()){i.addClass("sapUiSliDsbl")}else{if(!t.getEditable()){i.addClass("sapUiSliRo")}else{i.addClass("sapUiSliStd")}}if(t.getVertical()){i.addClass("sapUiSliVert")}else{i.addClass("sapUiSliHori")}i.writeClasses();if(t.getTooltip_AsString()){i.write('><span id="'+t.getId()+'-Descr" style="visibility: hidden; display: none;">');i.writeEscaped(t.getTooltip_AsString());i.write("</span")}i.write("><div");i.writeAttribute("id",t.getId()+"-right");i.write('class="sapUiSliR" > <DIV');i.writeAttribute("id",t.getId()+"-left");i.write('class="sapUiSliL" > <DIV');i.writeAttribute("id",t.getId()+"-bar");i.write('class="sapUiSliBar" >');var e=false;if(t.getLabels()&&t.getLabels().length>0){e=true}if(t.getTotalUnits()>0||e){var r=t.getTotalUnits();if(e){r=t.getLabels().length-1}var s=(t.getMax()-t.getMin())/r;for(var a=0;a<=r;a++){i.write("<div");i.writeAttribute("id",t.getId()+"-tick"+a);i.write('class="sapUiSliTick" ');i.write("></div>");if(t.getStepLabels()){i.write("<div");i.writeAttribute("id",t.getId()+"-text"+a);switch(a){case 0:i.write('class="sapUiSliText sapUiSliTextLeft" >');break;case r:i.write('class="sapUiSliText sapUiSliTextRight" >');break;default:i.write('class="sapUiSliText" >');break}if(e){i.writeEscaped(t.getLabels()[a])}else{i.write(t.getMin()+a*s)}i.write("</div>")}}}i.write("<div");i.writeAttribute("id",t.getId()+"-hili");i.write('class="sapUiSliHiLi"></DIV>');this.renderGrip(i,t);i.write("</div></div></div></div>")};i.renderGrip=function(i,t){i.write("<div");i.writeAttribute("id",t.getId()+"-grip");if(t.getEnabled()){i.writeAttribute("tabindex","0")}else{i.writeAttribute("tabindex","-1")}i.writeAttribute("class","sapUiSliGrip");i.writeAttribute("title",t.getValue());var e="horizontal";if(t.getVertical()){e="vertical"}i.writeAccessibilityState(t,{role:"slider",orientation:e,valuemin:t.getMin(),valuemax:t.getMax(),disabled:!t.getEditable()||!t.getEnabled(),describedby:t.getTooltip_AsString()?t.getId()+"-Descr "+t.getAriaDescribedBy().join(" "):undefined});if(t.getVertical()){i.write(">&#9668;</div>")}else{i.write(">&#9650;</div>")}};i.controlAdditionalCode=function(i,t){};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Splitter", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","./SplitterRenderer","sap/ui/core/library","sap/ui/core/Configuration"],function(jQuery,t,e,i,s,r,o,n,a){"use strict";var h=n.Orientation;var p=e.extend("sap.ui.commons.Splitter",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{splitterOrientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:h.Vertical},splitterPosition:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"50%"},minSizeFirstPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"0%"},minSizeSecondPane:{type:"sap.ui.core.Percentage",group:"Behavior",defaultValue:"0%"},width:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:"100%"},height:{type:"sap.ui.commons.SplitterSize",group:"Behavior",defaultValue:"100%"},showScrollBars:{type:"boolean",group:"Behavior",defaultValue:true},splitterBarVisible:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{firstPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"firstPaneContent"},secondPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondPaneContent"}}}});p.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sSpecialResizeListenerId){s.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null}};p.prototype.onAfterRendering=function(){this._recalculateInternals();this.sResizeListenerId=s.register(this.splitterDIV,jQuery.proxy(this.onresize,this))};p.prototype._recalculateInternals=function(){this.splitterDIV=this.getDomRef();this.splitterBar=document.getElementById(this.getId()+"_SB");this.firstPane=document.getElementById(this.getId()+"_firstPane");this.secondPane=document.getElementById(this.getId()+"_secondPane");this.minSizeFP=this.getMinSizeFirstPane();this.minSizeSP=this.getMinSizeSecondPane();this.minSizeFP=this.minSizeFP.substring(0,this.minSizeFP.length-1);this.minSizeFP=parseFloat(this.minSizeFP);this.minSizeSP=this.minSizeSP.substring(0,this.minSizeSP.length-1);this.minSizeSP=parseFloat(this.minSizeSP);this.spOrientation=this.getSplitterOrientation();this.sBarPosition=this.getSplitterPosition();this.sBarPosition=this.sBarPosition.substring(0,this.sBarPosition.length-1);this.sBarPosition=parseFloat(this.sBarPosition);if(a.getTheme()=="sap_hcb"){this.sbSize=6}else{this.sbSize=4}this.resizeSplitterElements();var t=jQuery(this.splitterBar).height();if(this.spOrientation==h.Vertical){if(t<=0||t>jQuery(this.splitterDIV).height()){this.fixHeight()}}else{if(t<=0||t!=this.sbSize){this.fixHeight()}}};p.prototype.onresize=function(t){this.resizeSplitterElements()};p.prototype.resizeSplitterElements=function(){var t,e,i,s,r,o;if(this.spOrientation==h.Vertical){i=jQuery(this.splitterDIV).width();if(i==0){i=100}t=this.sbSize*100/i;if(this.sBarPosition>=100||this.sBarPosition+t>100){this.sBarPosition=100-t;r=0}else{r=100-t-this.sBarPosition}jQuery(this.firstPane).css("width",this.sBarPosition+"%");jQuery(this.splitterBar).css("width",t+"%");jQuery(this.secondPane).css("width",r+"%")}else{s=jQuery(this.splitterDIV).height();if(s==0){s=100}e=this.sbSize*100/s;if(this.sBarPosition>=100||this.sBarPosition+e>100){this.sBarPosition=100-e;o=0}else{o=100-e-this.sBarPosition}jQuery(this.firstPane).css("height",this.sBarPosition+"%");jQuery(this.splitterBar).css("height",e+"%");jQuery(this.secondPane).css("height",o+"%")}this.setProperty("splitterPosition",this.sBarPosition+"%",true);if(jQuery(this.splitterDIV).height()==0&&!this.splitterDIV.style.height){jQuery(this.splitterDIV).css("height","100px");jQuery(this.splitterBar).css("height","100px")}};p.prototype.setSplitterPosition=function(t){if(this.getDomRef()){this.setProperty("splitterPosition",t,true);this._recalculateInternals()}else{this.setProperty("splitterPosition",t)}return this};p.prototype.setSplitterBarVisible=function(t){if(this.getDomRef()){this.setProperty("splitterBarVisible",t,true);var e=this.getSplitterOrientation()===h.Vertical?"sapUiVertical":"sapUiHorizontal";if(t){jQuery(document.getElementById(this.getId()+"_SB")).removeClass(e+"SplitterBarHidden").addClass(e+"SplitterBar")}else{jQuery(document.getElementById(this.getId()+"_SB")).removeClass(e+"SplitterBar").addClass(e+"SplitterBarHidden")}}else{this.setProperty("splitterBarVisible",t)}return this};p.prototype.fixHeight=function(){var t=jQuery(this.splitterDIV.parentNode).height();var e=jQuery(this.splitterDIV).height();if(t>e){e=t;var i=this.getHeight();if(i&&i.toLowerCase().indexOf("px")!=-1){e=parseInt(i)}if(i&&i.toLowerCase().indexOf("%")!=-1){var r=parseInt(i);if(r<100){e=jQuery(this.splitterDIV).height()}}if(e<=0){e=t}}jQuery(this.splitterDIV).css("height",e+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",e+"px")}var o=this.splitterDIV.parentNode;if(o){var n=jQuery.proxy(this.onresizespecial,this);this.sSpecialResizeListenerId=s.register(o,n)}};p.prototype.exit=function(){if(this.sResizeListenerId){s.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sSpecialResizeListenerId){s.deregister(this.sSpecialResizeListenerId);this.sSpecialResizeListenerId=null}};p.prototype.onresizespecial=function(t){var e=jQuery(this.splitterDIV);var i=e.height();e.css("height","0px");var s=this.getDomRef();if(s&&window.getComputedStyle){window.getComputedStyle(s)}var r=jQuery(t.target).height();var o=e.height();if(o!=r){e.css("height",r+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",r+"px")}}if(r<=0){e.css("height",i+"px");if(this.spOrientation==h.Vertical){jQuery(this.splitterBar).css("height",i+"px")}}};p.prototype.onmousedown=function(t){if(t.target!=this.splitterBar){return}var e=jQuery(document.body);e.on("selectstart",jQuery.proxy(this.splitterSelectStart,this));var s=jQuery(this.splitterBar).offset();var r=jQuery(this.splitterBar).height();var o=jQuery(this.splitterBar).width();var n;if(this.spOrientation==h.Vertical){n="sapUiVSBGhost"}else{n="sapUiHSBGhost"}var a=i.getLastZIndex()+5;if(a<20){a=20}jQuery(document.body).append('<div id="'+this.getId()+'_ghost" class="'+n+'" style =" height:'+r+"px; width:"+o+"px; left:"+s.left+"px; top:"+s.top+"px;z-index:"+a+'"></div>');jQuery(document.body).append('<div id="'+this.getId()+'_overlay" style ="left: 0px;'+" right: 0px; bottom: 0px; top: 0px; position:fixed; z-index:"+a+'" ></div>');jQuery(document).on("mouseup",jQuery.proxy(this.onGhostMouseRelease,this));jQuery(document).on("mousemove",jQuery.proxy(this.onGhostMouseMove,this));jQuery(this.splitterBar).trigger("focus");t.preventDefault();t.stopPropagation()};p.prototype.splitterSelectStart=function(t){t.preventDefault();t.stopPropagation();return false};p.prototype.onGhostMouseRelease=function(t){var e,i,s;var r=document.getElementById(this.getId()+"_ghost");var o=a.getRTL();if(this.spOrientation==h.Vertical){if(!o){e=t.pageX-jQuery(this.firstPane).offset().left;s=jQuery(this.splitterDIV).width();e=e*100/s}else{e=t.pageX-jQuery(this.secondPane).offset().left;s=jQuery(this.splitterDIV).width();e=(s-e)*100/s}}else{e=t.pageY-jQuery(this.firstPane).offset().top;i=jQuery(this.splitterDIV).height();e=e*100/i}if(e<this.minSizeFP){e=this.minSizeFP}else if(100-e<this.minSizeSP){e=100-this.minSizeSP}this.sBarPosition=e;this.resizeSplitterElements();jQuery(r).remove();jQuery(document.getElementById(this.getId()+"_overlay")).remove();var n=jQuery(document.body);n.off("selectstart",this.splitterSelectStart);jQuery(document).off("mouseup",this.onGhostMouseRelease);jQuery(document).off("mousemove",this.onGhostMouseMove)};p.prototype.onGhostMouseMove=function(t){var e=document.getElementById(this.getId()+"_ghost");var i;var s;var r=a.getRTL();var o=jQuery(this.firstPane).offset().left;var n=jQuery(this.splitterDIV).width();var p=jQuery(this.secondPane).offset().left;if(this.getSplitterOrientation()==h.Vertical){if(!r){s=o+n*this.minSizeFP/100;i=o+n*(100-this.minSizeSP)/100;if(t.pageX>s&&t.pageX<i){jQuery(e).css("left",t.pageX+"px")}}else{s=p+n*this.minSizeSP/100;i=p+n*(100-this.minSizeFP)/100;if(t.pageX>s&&t.pageX<i){jQuery(e).css("left",t.pageX+"px")}}}else{var l=jQuery(this.splitterDIV).height();s=jQuery(this.firstPane).offset().top+l*this.minSizeFP/100;i=jQuery(this.secondPane).offset().top+jQuery(this.secondPane).height()-l*this.minSizeSP/100;if(t.pageY>s&&t.pageY<i){jQuery(e).css("top",t.pageY+"px")}}};p.prototype.getCtrlKey=function(t){return!!(t.ctrlKey||t.metaKey)};p.prototype.checkModifierKey=function(t,e,i,s){return t.shiftKey==s&&t.altKey==i&&this.getCtrlKey(t)==e};p.prototype.onsaphome=function(t){if(t.target==this.splitterBar){this.sBarPosition=this.minSizeFP;this.resizeSplitterElements();t.preventDefault();t.stopPropagation()}};p.prototype.onsapend=function(t){if(t.target==this.splitterBar){this.sBarPosition=100-this.minSizeSP;this.resizeSplitterElements();t.preventDefault();t.stopPropagation()}};p.prototype.onArrowKeys=function(t,e){var i,s,r,o,n;if(this.spOrientation==h.Vertical){i=jQuery(this.splitterDIV).width();o=jQuery(this.firstPane).width();o=o*100/i;r=10*100/i}else{s=jQuery(this.splitterDIV).height();o=jQuery(this.firstPane).height();o=o*100/s;r=10*100/s}if(e=="false"){n=o-r}else if(e=="true"){n=o+r}if(n<this.minSizeFP){n=this.minSizeFP}else if(100-n<this.minSizeSP){n=100-this.minSizeSP}this.sBarPosition=n;this.resizeSplitterElements()};p.prototype.onsapupmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Horizontal){this.onArrowKeys(t,"false")}else{this.onsapleftmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsapdownmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Horizontal){this.onArrowKeys(t,"true")}else{this.onsaprightmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsapleftmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Vertical){var e=a.getRTL();if(e){this.onArrowKeys(t,"true")}else{this.onArrowKeys(t,"false")}}else{this.onsapupmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.onsaprightmodifiers=function(t){if(this.checkModifierKey(t,false,false,true)){if(t.target==this.splitterBar){if(this.spOrientation==h.Vertical){var e=a.getRTL();if(e){this.onArrowKeys(t,"false")}else{this.onArrowKeys(t,"true")}}else{this.onsapdownmodifiers(t)}}t.preventDefault();t.stopPropagation()}};p.prototype.ondragstart=function(t){if(t.target!=this.splitterBar){return}t.preventDefault();t.stopPropagation()};p.prototype.getText=function(t,e){var i=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");if(i){return i.getText(t,e)}return t};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/SplitterRenderer", ["sap/ui/core/library"],function(e){"use strict";var t=e.Orientation;var i={};i.render=function(e,i){var r=i.getSplitterOrientation();var a=i.getSplitterPosition();var d;var l;var s;var n;a=a.substring(0,a.length-1);d=100-a;e.write("<div ");e.writeControlData(i);e.addClass("sapUiSplitter");e.addStyle("width",i.getWidth());e.addStyle("height",i.getHeight());e.writeStyles();e.writeClasses();e.write(">");e.write('<div id="'+i.getId()+'_firstPane" ');if(i.getShowScrollBars()){e.addStyle("overflow","auto")}else{e.addStyle("overflow","hidden")}if(r==t.Vertical){e.addClass("sapUiVSplitterFirstPane");e.addStyle("width",a+"%")}else if(r==t.Horizontal){e.addClass("sapUiHSplitterFirstPane");e.addStyle("height",a+"%")}e.writeClasses();e.writeStyles();e.write(">");l=i.getFirstPaneContent();s=l.length;for(n=0;n<s;n++){e.renderControl(l[n])}e.write("</div>");e.write('<div  id="'+i.getId()+'_SB" tabIndex="0" role="separator" title="'+i.getText("SPLITTER_MOVE")+'"');if(r==t.Vertical){if(i.getSplitterBarVisible()){e.addClass("sapUiVerticalSplitterBar")}else{e.addClass("sapUiVerticalSplitterBarHidden")}e.addStyle("width",0+"%")}else if(r==t.Horizontal){if(i.getSplitterBarVisible()){e.addClass("sapUiHorizontalSplitterBar")}else{e.addClass("sapUiHorizontalSplitterBarHidden")}e.addStyle("height",0+"%")}e.writeClasses();e.writeStyles();e.write(">");e.write("</div>");e.write('<div id="'+i.getId()+'_secondPane" ');if(i.getShowScrollBars()){e.addStyle("overflow","auto")}else{e.addStyle("overflow","hidden")}if(r==t.Vertical){e.addClass("sapUiVSplitterSecondPane");e.addStyle("width",d+"%")}else if(r==t.Horizontal){e.addClass("sapUiHSplitterSecondPane");e.addStyle("height",d+"%")}e.writeClasses();e.writeStyles();e.write(">");l=i.getSecondPaneContent();s=l.length;for(n=0;n<s;n++){e.renderControl(l[n])}e.write("</div>");e.write("</div>")};return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Tab", ["./Panel","./library","sap/ui/core/library"],function(e,t,r){"use strict";var o=r.Scrolling;var l=e.extend("sap.ui.commons.Tab",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{verticalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:o.None},horizontalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:o.None},closable:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",group:"Behavior",defaultValue:false,deprecated:true}}},renderer:null});l.prototype.init=function(){this.oScrollDomRef=null};l.prototype.rerender=function(){var e=this.getParent();if(e){e.rerender()}};l.prototype.invalidate=function(){var e=this.getParent();if(e){e.invalidate()}};l.prototype.onAfterRendering=function(){this.oScrollDomRef=this.getDomRef("panel");if(this.oScrollDomRef){var e=this.getProperty("scrollTop")||0;this.oScrollDomRef.scrollTop=e;var t=this.getProperty("scrollLeft")||0;this.oScrollDomRef.scrollLeft=t}};l.prototype.getScrollLeft=function(){var e=0;if(this.oScrollDomRef){e=this.oScrollDomRef.scrollLeft;this.setProperty("scrollLeft",e,true)}return e};l.prototype.setScrollLeft=function(e){this.setProperty("scrollLeft",e,true);if(this.oScrollDomRef){this.bIgnoreScrollEvent=true;this.oScrollDomRef.scrollLeft=e}return this};l.prototype.getScrollTop=function(){var e=0;if(this.oScrollDomRef){e=this.oScrollDomRef.scrollTop;this.setProperty("scrollTop",e,true)}return e};l.prototype.setScrollTop=function(e){this.setProperty("scrollTop",e,true);if(this.oScrollDomRef){this.bIgnoreScrollEvent=true;this.oScrollDomRef.scrollTop=e}return this};l.prototype.setEnabled=function(e){if(e==this.getEnabled()){return this}var t=this.getDomRef();var r=this.getParent();if(!t||!e&&this.$().hasClass("sapUiTabSel")||e&&r&&r.getSelectedIndex&&r.getSelectedIndex()<0){this.setProperty("enabled",e,false);if(r&&r._getActualSelectedIndex){var o=r._getActualSelectedIndex();r.setProperty("selectedIndex",o,true)}}else{this.setProperty("enabled",e,true);this.$().toggleClass("sapUiTab",e).toggleClass("sapUiTabDsbl",!e).attr("aria-disabled",!e)}return this};l.prototype.setWidth=function(e){this.setProperty("width",e,true);return this};l.prototype.setApplyContentPadding=function(e){this.setProperty("applyContentPadding",e,true);return this};l.prototype._handleTrigger=function(e){};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TabStrip", ["sap/ui/thirdparty/jquery","sap/base/Log","./library","sap/ui/core/Control","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Icon","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","./TabStripRenderer","sap/ui/core/ResizeHandler","sap/ui/core/Title","./Tab","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/parentByAttribute","sap/ui/dom/jquery/zIndex","sap/ui/thirdparty/jqueryui/jquery-ui-position"],function(jQuery,e,t,i,s,r,a,o,n,l,h,f,p,d){"use strict";var g=i.extend("sap.ui.commons.TabStrip",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},selectedIndex:{type:"int",group:"Misc",defaultValue:0},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"tabs",aggregations:{tabs:{type:"sap.ui.commons.Tab",multiple:true,singularName:"tab"},_leftArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_rightArrowControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{select:{parameters:{index:{type:"int"}}},close:{parameters:{index:{type:"int"}}}}}});g.SCROLL_SIZE=320;g.ANIMATION_DURATION=d.getAnimation()?200:0;g.SCROLL_ANIMATION_DURATION=d.getAnimation()?500:0;g.prototype.init=function(){this._bInitialized=true;this._bRtl=d.getRTL();this._iCurrentScrollLeft=0;this._iMaxOffsetLeft=null;this._scrollable=null;this._oScroller=new a(this,this.getId()+"-tablist",{horizontal:!this.getEnableTabReordering(),vertical:false,nonTouchScrolling:true});this.data("sap-ui-fastnavgroup","true",true)};g.prototype.setEnableTabReordering=function(e){this.setProperty("enableTabReordering",e,true);if(this._oScroller){this._oScroller.setHorizontal(!e)}return this};g.prototype.onBeforeRendering=function(){if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}};g.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,jQuery.proxy(this._updateScrollingAppearance,this),null)}this._initItemNavigation();this._updateScrollingAppearance();this._sResizeListenerId=l.register(this.getDomRef(),jQuery.proxy(this._updateScrollingAppearance,this));var e=this.getTabs();var t=this.getSelectedIndex();var i=e[t];if(this._oScroller&&i&&i.$().length>0){if(!this._oScroller._$Container){this._oScroller.onAfterRendering()}this._scrollIntoView(i.$(),g.SCROLL_ANIMATION_DURATION)}for(var s=0;s<e.length;s++){e[s].onAfterRendering()}};g.prototype.createTab=function(e,t){var i=new h({text:e}),s=new f;s.setTitle(i);s.addContent(t);this.addTab(s);return s};g.prototype.selectTabByDomRef=function(e){var t=this.getItemIndex(e);if(t>-1){if(t!=this.getSelectedIndex()&&this.getTabs()[t].getEnabled()){var i=this.getSelectedIndex();this.setProperty("selectedIndex",t,true);this.rerenderPanel(i,true);this.oItemNavigation.setSelectedIndex(this.oItemNavigation.getFocusedIndex())}}};g.prototype.onsapspace=function(e){var t=e.target;this.selectTabByDomRef(t)};g.prototype.onsapspacemodifiers=g.prototype.onsapspace;g.prototype.onsapenter=g.prototype.onsapspace;g.prototype.onsapentermodifiers=g.prototype.onsapspace;g.prototype.onsapdelete=function(e){var t=e.target;var i=this.getItemIndex(t);if(i>-1&&this.getTabs()[i].getClosable()){this.fireClose({index:i})}};g.prototype.getFocusDomRef=function(){return this.getDomRef().firstChild};g.prototype.exit=function(){this._bInitialized=false;this._iCurrentScrollLeft=null;this._iMaxOffsetLeft=null;this._scrollable=null;if(this._oScroller){this._oScroller.destroy();this._oScroller=null}if(this._sResizeListenerId){l.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}};g.prototype.getItemIndex=function(e){var t;if(!e.id||e.id.search("-close")!=-1){var i=jQuery(e).parentByAttribute("id");t=i.id}else{t=e.id}for(var s=0,r=this.getTabs();s<r.length;s++){if(t==r[s].getId()){return s}}return-1};g.prototype.removeTab=function(e){var t=e;if(typeof e=="string"){e=sap.ui.getCore().byId(e)}if(typeof e=="object"){t=this.indexOfTab(e)}var i=this.getTabs()[t];if(i.getVisible()){i.setProperty("visible",false,true);this.hideTab(t);i.setProperty("visible",true,true)}if(this.getSelectedIndex()>t){this.setProperty("selectedIndex",this.getSelectedIndex()-1,true)}return this.removeAggregation("tabs",t,true)};g.prototype.setSelectedIndex=function(e){var t=this.getSelectedIndex();if(e==t){return this}var i=this.getTabs();var s=i[e];if(this._oScroller&&s&&s.$().length>0){this._scrollIntoView(s.$(),g.SCROLL_ANIMATION_DURATION)}if(!s&&!this.getDomRef()){this.setProperty("selectedIndex",e,false)}else if(s&&s.getEnabled()&&s.getVisible()){this.setProperty("selectedIndex",e,true);if(this.getDomRef()&&!this.invalidated){this.rerenderPanel(t);if(this.oItemNavigation){var r=0;var a=-1;for(var o=0;o<i.length;o++){s=i[o];if(s.getVisible()===false){continue}if(o==e){a=r;break}r++}this.oItemNavigation.setSelectedIndex(a)}}}else{this._warningInvalidSelectedIndex(e,s)}return this};g.prototype.closeTab=function(e){var t=this.getTabs()[e];if(!t||!t.getClosable()||!t.getVisible()){return}t.setProperty("visible",false,true);this.hideTab(e)};g.prototype.hideTab=function(e){var t=this.getTabs()[e];if(!this.getDomRef()){return}var i=this.oItemNavigation.getFocusedIndex();var s=parseInt(t.$().attr("aria-posinset"))-1;var r=sap.ui.getCore().getCurrentFocusedControlId();t.$().remove();if(this.iVisibleTabs==1){this.setProperty("selectedIndex",-1,true);t.$("panel").remove()}else if(e==this.getSelectedIndex()){var a=e+1;while(a<this.getTabs().length&&(!this.getTabs()[a].getEnabled()||!this.getTabs()[a].getVisible())){a++}if(a==this.getTabs().length){a=e-1;while(a>=0&&(!this.getTabs()[a].getEnabled()||!this.getTabs()[a].getVisible())){a--}}this.setProperty("selectedIndex",a,true);this.rerenderPanel(e)}else{this.toggleTabClasses(this.getSelectedIndex(),this.getSelectedIndex())}this.iVisibleTabs--;var s=0;var o=[];var n=-1;var l=false;for(var h=0;h<this.getTabs().length;h++){var t=this.getTabs()[h];if(r==t.getId()){l=true}if(t.getVisible()===false){continue}if(h==this.getSelectedIndex()){n=s}s++;t.$().attr("aria-posinset",s).attr("aria-setsize",this.iVisibleTabs);o.push(t.getDomRef())}if(s<=i){i--}this.oItemNavigation.setItemDomRefs(o);this.oItemNavigation.setSelectedIndex(n);this.oItemNavigation.setFocusedIndex(i);if(l){this.oItemNavigation.focusItem(i)}this._updateScrollingAppearance()};g.prototype.rerenderPanel=function(e,t){var i=this.getTabs();var s=this.getSelectedIndex();var r=i[s];var a=i[e];setTimeout(function(){if(!this._bInitialized){return}var e=this.$().find(".sapUiTabPanel");if(r){if(e.length>0){var i=sap.ui.getCore().createRenderManager();this.getRenderer().renderTabContents(i,r);i.flush(e[0]);i.destroy()}var o=r.getId();e.attr("id",o+"-panel").attr("aria-labelledby",o)}else{e.empty()}a.setProperty("scrollTop",e.scrollTop(),true);a.setProperty("scrollLeft",e.scrollLeft(),true);if(r){r.onAfterRendering()}if(t){this.fireSelect({index:s})}}.bind(this),0);if(r){this.toggleTabClasses(e,s)}};g.prototype.toggleTabClasses=function(e,t){var i=this.getTabs();var s=i[e];if(s){s.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",false)}var r=e-1;while(r>=0&&!i[r].getVisible()){r--}if(r>=0){i[r].$().removeClass("sapUiTabBeforeSel")}var a=e+1;while(a<i.length&&!i[a].getVisible()){a++}if(a<i.length){i[a].$().removeClass("sapUiTabAfterSel")}s=i[t];if(s){s.$().toggleClass("sapUiTabSel sapUiTab").attr("aria-selected",true)}r=t-1;while(r>=0&&!i[r].getVisible()){r--}if(r>=0){i[r].$().addClass("sapUiTabBeforeSel")}a=t+1;while(a<i.length&&!i[a].getVisible()){a++}if(a<i.length){i[a].$().addClass("sapUiTabAfterSel")}};g.prototype.invalidate=function(){this.invalidated=true;i.prototype.invalidate.apply(this,arguments)};g.prototype._warningInvalidSelectedIndex=function(t,i){var s="";if(!i){s="Tab not exists"}else if(!i.getEnabled()){s="Tab disabled"}else if(!i.getVisible()){s="Tab not visible"}e.warning("SelectedIndex "+t+" can not be set",s,"sap.ui.commons.TabStrip")};g.prototype.onkeydown=function(e){if(e.which===p.ESCAPE){this._stopMoving()}};g.prototype.onclick=function(e){var t=e.target;var i=jQuery(t);if(t.className=="sapUiTabClose"){var s=this.getItemIndex(i.parentByAttribute("id"));if(s>-1){this.fireClose({index:s})}}};g.prototype.onmousedown=function(e){var t=!e.button;var i=this._isTouchMode(e);if(!i&&!t){return}var s=e.target;var r=jQuery(s);if(s.className=="sapUiTabClose"){e.preventDefault();e.stopPropagation();e.target=null;return}this.selectTabByDomRef(s);if(!this.getEnableTabReordering()){return}var a=r.closest(".sapUiTab, .sapUiTabSel, .sapUiTabDsbl");if(a.length===1){this._onTabMoveStart(a,e,i)}};g.prototype._onTabMoveStart=function(e,t,i){this._disableTextSelection();t.preventDefault();e.zIndex(this.$().zIndex()+10);var s=this.getItemIndex(t.target);var r=this.getTabs()[s];var a=this.$().find(".sapUiTabBarCnt").children();var o=jQuery.inArray(e[0],a);var n=e.outerWidth();this._dragContext={index:o,tabIndex:s,isTouchMode:i,startX:i?t.originalEvent.targetTouches[0].pageX:t.pageX,tab:r,tabWidth:n,tabCenter:e.position().left+n/2};this._aMovedTabIndexes=[];var l=jQuery(document);if(i){l.on("touchmove",jQuery.proxy(this._onTabMove,this));l.on("touchend",jQuery.proxy(this._onTabMoved,this))}else{l.on("mousemove",jQuery.proxy(this._onTabMove,this));l.on("mouseup",jQuery.proxy(this._onTabMoved,this))}};g.prototype._onTabMove=function(e){var t=this._dragContext;if(!t){return}var i=this._isTouchMode(e);if(i){e.preventDefault()}var s=i?e.targetTouches[0].pageX:e.pageX;var r=s-t.startX;t.tab.$().css({left:r});var a,o,n,l,h=this.$().find(".sapUiTabBarCnt").children(),f=this._aMovedTabIndexes,p=d.getRTL();for(var g=0;g<h.length;g++){if(g==t.index){continue}a=jQuery(h[g]);o=a.position().left;n=parseFloat(a.css("left"));if(!isNaN(n)){o-=n}if(g<t.index!=p){l=o+a.outerWidth()>t.tabCenter+r;this._onAnimateTab(a,t.tabWidth,l,f,g)}else{l=o<t.tabCenter+r;this._onAnimateTab(a,-t.tabWidth,l,f,g)}}};g.prototype._onAnimateTab=function(e,t,i,s,r){var a=jQuery.inArray(r,s);var o=a!=-1;if(i&&!o){e.stop(true,true);e.animate({left:t},g.ANIMATION_DURATION);s.push(r)}else if(!i&&o){e.stop(true,true);e.animate({left:0},g.ANIMATION_DURATION);s.splice(a,1)}};g.prototype._onTabMoved=function(e){var t=this._dragContext;if(!t){return}this._stopMoving();var i=this._aMovedTabIndexes;if(i.length==0){return}var s=t.tab.$(),r,a=this.$().find(".sapUiTabBarCnt").children();var o=i[i.length-1],n=o,l=this.getItemIndex(a[o]);this.removeAggregation("tabs",t.tab,true);this.insertAggregation("tabs",t.tab,l,true);if(o>t.index){s.insertAfter(jQuery(a[o]))}else{s.insertBefore(jQuery(a[o]))}a=this.$().find(".sapUiTabBarCnt").children();if(!t.tab.getEnabled()){for(var h=0;h<a.length;h++){r=jQuery(a[h]);if(r.hasClass("sapUiTabSel")){n=h;l=this.getItemIndex(r[0]);break}}}this.setProperty("selectedIndex",l,true);a.removeClass("sapUiTabAfterSel");a.removeClass("sapUiTabBeforeSel");for(var h=0;h<a.length;h++){r=jQuery(a[h]);r.attr("aria-posinset",h+1);if(h==n-1){r.addClass("sapUiTabBeforeSel")}else if(h==n+1){r.addClass("sapUiTabAfterSel")}}s.trigger("focus");this._initItemNavigation()};g.prototype._stopMoving=function(){var e=this._dragContext;if(!e){return}var t=e.tab.$();t.css("z-index","");var i=this.$().find(".sapUiTabBarCnt").children();i.stop(true,true);i.css("left","");this._dragContext=null;var s=jQuery(document);if(e.isTouchMode){s.off("touchmove",this._onTabMove);s.off("touchend",this._onTabMoved)}else{s.off("mousemove",this._onTabMove);s.off("mouseup",this._onTabMoved)}this._enableTextSelection()};g.prototype._isTouchMode=function(e){return!!e.originalEvent["touches"]};g.prototype._initItemNavigation=function(){var e=this.getDomRef("tablist"),t=e.childNodes,i=[],r=-1;for(var a=0;a<t.length;a++){i.push(t[a]);if(jQuery(t[a]).hasClass("sapUiTabSel")){r=a}}if(!this.oItemNavigation){this.oItemNavigation=new s;this.oItemNavigation.attachEvent(s.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.oItemNavigation.setCycling(false);this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(e);this.oItemNavigation.setItemDomRefs(i);this.oItemNavigation.setSelectedIndex(r)};g.prototype._disableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","on").addClass("sapUiTabStripNoSelection").bind("selectstart",function(e){e.preventDefault();return false})};g.prototype._enableTextSelection=function(e){jQuery(e||document.body).attr("unselectable","off").removeClass("sapUiTabStripNoSelection").unbind("selectstart")};g.prototype._getActualSelectedIndex=function(){var e=Math.max(0,this.getSelectedIndex());var t=this.getTabs();var i=t[e];if(i&&i.getVisible()&&i.getEnabled()){return e}for(var s=0;s<t.length;s++){var r=t[s];if(r.getVisible()&&r.getEnabled()){return s}}return 0};g.prototype._getLeftArrowControl=function(){var e=this.getAggregation("_leftArrowControl");var t=this;if(!e){e=new r({src:"sap-icon://navigation-left-arrow",noTabStop:true,useIconTooltip:false,tooltip:"",press:function(e){t._scroll(-g.SCROLL_SIZE,g.SCROLL_ANIMATION_DURATION)}}).addStyleClass("sapUiTabStripScrollIcon sapUiTabStripLeftScrollIcon");this.setAggregation("_leftArrowControl",e,true)}return e};g.prototype._getRightArrowControl=function(){var e=this.getAggregation("_rightArrowControl");var t=this;if(!e){e=new r({src:"sap-icon://navigation-right-arrow",noTabStop:true,useIconTooltip:false,tooltip:"",press:function(e){t._scroll(g.SCROLL_SIZE,g.SCROLL_ANIMATION_DURATION)}}).addStyleClass("sapUiTabStripScrollIcon sapUiTabStripRightScrollIcon");this.setAggregation("_rightArrowControl",e,true)}return e};g.prototype._scroll=function(e,t){var i=this.getDomRef("scrollCont").scrollLeft,s;if(this._bRtl&&o.browser.firefox){s=i-e;if(s<-this._iMaxOffsetLeft){s=-this._iMaxOffsetLeft}if(s>0){s=0}}else{s=i+e;if(s<0){s=0}if(s>this._iMaxOffsetLeft){s=this._iMaxOffsetLeft}}if(this._oScroller){this._oScroller.scrollTo(s,0,t)}this._iCurrentScrollLeft=s};g.prototype._scrollIntoView=function(e,t){var i=this.$("tablist"),s=i.innerWidth()-i.width(),r=e.outerWidth(true),a=e.position().left-s/2,n=this.getDomRef("scrollCont"),l=n.scrollLeft,h=this.$("scrollCont").width(),f=l;if(a<0||a>h-r){if(this._bRtl&&o.browser.firefox){if(a<0){f+=a+r-h}else{f+=a}}else{if(a<0){f+=a}else{f+=a+r-h}}this._iCurrentScrollLeft=f;if(this._oScroller){this._oScroller.scrollTo(f,0,t)}}};g.prototype._hasScrolling=function(){var e=this.getDomRef("tablist"),t=this.getDomRef("scrollCont"),i=e&&e.scrollWidth>t.clientWidth;this.$().toggleClass("sapUiTabStripScrollable",i);return i};g.prototype._updateScrollingAppearance=function(){var e=this.getDomRef("tablist"),t=this.getDomRef("scrollCont"),i,s,r,a=false,n=false;if(this._hasScrolling()&&e&&t){if(this._bRtl&&o.browser.firefox){i=-t.scrollLeft}else{i=t.scrollLeft}s=e.scrollWidth;r=t.clientWidth;if(Math.abs(s-r)===1){s=r}if(i>0){a=true}if(s>r&&i+r<s){n=true}}this.$().toggleClass("sapUiTabStripScrollBack",a).toggleClass("sapUiTabStripScrollForward",n);this._iMaxOffsetLeft=Math.abs(jQuery(t).width()-jQuery(e).width())};g.prototype._onItemNavigationAfterFocus=function(e){var t=e.getParameter("index"),i=e.getParameter("event");if(!i){return}var s=jQuery(i.target);if(!s||i.keyCode===undefined){return}if(t!==null&&t!==undefined){var r=jQuery(s.parent().children()[t]);if(r&&r.length){this._scrollIntoView(r,0)}}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TabStripRenderer", ["sap/base/Log"],function(e){"use strict";var t=function(){};t.render=function(i,a){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var s=a.getId();i.write("<div role='presentation'");i.addClass("sapUiTabStrip");i.addStyle("height",a.getHeight());i.addStyle("width",a.getWidth());i.writeClasses();i.writeStyles();i.writeControlData(a);i.write('><div class="sapUiTabBar"');if(a.getTooltip_AsString()){i.writeAttributeEscaped("title",a.getTooltip_AsString())}i.write('><div class="sapUiTabMenu"></div>');i.renderControl(a._getLeftArrowControl());i.write('<div id="'+s+'-scrollCont" class="sapUiTabStripScrollContainer">');i.write('<ul id="'+s+'-tablist" class="sapUiTabBarCnt" role="tablist">');var l=a.getTabs();var n=false;var d=a.getSelectedIndex();if(d<0){d=0;a.setProperty("selectedIndex",0,true)}var o=l[d];if(!o||!o.getVisible()||!o.getEnabled()){a._warningInvalidSelectedIndex(d,o);n=true}a.iVisibleTabs=0;for(var b=0;b<l.length;b++){var g=l[b];if(g.getVisible()===false){continue}a.iVisibleTabs++}var p=0;for(var b=0;b<l.length;b++){var g=l[b];if(g.getVisible()===false){continue}if(n&&g.getEnabled()){a.setProperty("selectedIndex",b,true);d=b;n=false}i.write("<li");if(g.getEnabled()==false){i.addClass("sapUiTabDsbl")}else if(b==d){i.addClass("sapUiTabSel")}else{i.addClass("sapUiTab")}if(b==d-1){i.addClass("sapUiTabBeforeSel")}else if(b==d+1){i.addClass("sapUiTabAfterSel")}i.writeControlData(g);i.writeAttribute("tabidx",b);p++;i.writeAttribute("tabindex","-1");i.writeAttribute("role","tab");i.writeAccessibilityState(g,{selected:b==d,controls:g.getId()+"-panel",disabled:!g.getEnabled(),posinset:p,setsize:a.iVisibleTabs});if(g.getClosable()){i.writeAccessibilityState(g,{describedby:g.getId()+"-close"})}i.writeClasses();var f=g.getTitle();if(f&&f.getTooltip_AsString()){i.writeAttributeEscaped("title",f.getTooltip_AsString())}else if(g.getTooltip_AsString()){i.writeAttributeEscaped("title",g.getTooltip_AsString())}i.write(">");if(f){var c=f.getIcon();if(c){var w=[];var u={title:null};w.push("sapUiTabIco");i.writeIcon(c,w,u)}i.writeEscaped(f.getText())}else{e.warning("No title configured for "+g+". Either set a string as 'text' property or an sap.ui.core.Title as 'title' aggregation.")}if(g.getClosable()){i.write("<button id='"+g.getId()+'-close\' type="button" tabindex= "-1" class="sapUiTabClose" title="'+r.getText("TAB_CLOSE_TEXT")+'"></button>')}i.write("</li>")}i.write("</ul></div>");i.renderControl(a._getRightArrowControl());i.write("</div>");if(n){a.setProperty("selectedIndex",-1,true);d=-1;i.write('<div id="'+s+"-panel"+'" role="tabpanel"');i.addClass("sapUiTabPanel");if(a.getHeight()){i.addClass("sapUiTabPanelHeight")}i.writeClasses();i.write("></div>")}else{for(var b=0;b<l.length;b++){var g=l[b];if(b!=d||g.getVisible()===false){continue}i.write('<div id="'+g.getId()+"-panel"+'" role="tabpanel" aria-labelledby="'+g.getId()+'"');i.addClass("sapUiTabPanel");if(a.getHeight()){i.addClass("sapUiTabPanelHeight")}i.writeClasses();i.write(">");t.renderTabContents(i,g);i.write("</div>")}}i.write("</div>");a.invalidated=false};t.renderTabContents=function(e,t){var i=t.getContent(),a=i.length;for(var r=0;r<a;r++){e.renderControl(i[r])}};return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextArea", ["sap/ui/thirdparty/jquery","./TextField","./library","./TextAreaRenderer","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText"],function(jQuery,t,e,o,r,n){"use strict";var p=t.extend("sap.ui.commons.TextArea",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},cols:{type:"int",group:"Dimension",defaultValue:null},rows:{type:"int",group:"Dimension",defaultValue:null},wrapping:{type:"sap.ui.core.Wrapping",group:"Appearance",defaultValue:null},cursorPos:{type:"int",group:"Appearance",defaultValue:null},explanation:{type:"string",group:"Misc",defaultValue:null},labeledBy:{type:"string",group:"Identification",defaultValue:null,deprecated:true}}}});p.prototype.exit=function(){this._detachEventHandler()};p.prototype.onBeforeRendering=function(){this._detachEventHandler()};p.prototype.onAfterRendering=function(){t.prototype.onAfterRendering.apply(this,arguments);this._attachEventHandler()};p.prototype._attachEventHandler=function(){var t=this.$();this.proChHandlerId=t.on("propertychange",jQuery.proxy(this.oninput,this))};p.prototype._detachEventHandler=function(){var t=this.$();if(this.proChHandlerId){t.off("propertychange",this.oninput);this.proChHandlerId=null}};p.prototype.onfocusin=function(e){t.prototype.onfocusin.apply(this,arguments);this.bFocus=true;e.preventDefault()};p.prototype.onsapfocusleave=function(e){t.prototype.onsapfocusleave.apply(this,arguments);var o=this.getFocusDomRef();if(o&&r.browser.firefox){if(o.selectionStart!=o.selectionEnd){jQuery(o).selectText(o.selectionStart,o.selectionStart)}}this.bFocus=false;e.preventDefault();e.stopPropagation()};p.prototype.applyFocusInfo=function(e){t.prototype.applyFocusInfo.apply(this,arguments);return this};p.prototype.onkeypress=function(e){t.prototype.onkeypress.apply(this,arguments);if(!this.getEditable()||!this.getEnabled()||this.getMaxLength()<=0){return}var o=e.which||e.keyCode;var r=this.getDomRef();if(document.selection){var p=document.selection.createRange();if(p.text.length>0){return}}else{if(r.selectionStart!=r.selectionEnd){return}}if(r.value.length>=this.getMaxLength()&&(o>n.DELETE||o==n.ENTER||o==n.SPACE)&&!e.ctrlKey){e.preventDefault();e.stopPropagation()}};p.prototype.onkeyup=function(e){var o=this.getDomRef();this.setProperty("cursorPos",jQuery(o).cursorPos(),true);t.prototype.onkeyup.apply(this,arguments)};p.prototype.onsapenter=function(t){t.stopPropagation()};p.prototype.onsapnext=function(t){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&t.keyCode!=n.END){t.preventDefault();return}this._checkCursorPosForNav(t,true)};p.prototype.onsapprevious=function(t){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&t.keyCode!=n.HOME){t.preventDefault();return}this._checkCursorPosForNav(t,false)};p.prototype.onsapnextmodifiers=p.prototype.onsapnext;p.prototype.onsappreviousmodifiers=p.prototype.onsapprevious;p.prototype.onsapend=p.prototype.onsapnext;p.prototype.onsaphome=p.prototype.onsapprevious;p.prototype.onmouseup=function(t){var e=this.getDomRef();this.setProperty("cursorPos",jQuery(e).cursorPos(),true)};p.prototype.onpaste=function(t){if(!this.getEditable()||!this.getEnabled()||this.getMaxLength()<=0){return}var e=this.getDomRef();if(e.value.length>=this.getMaxLength()&&e.selectionStart==e.selectionEnd){t.preventDefault();t.stopPropagation()}};p.prototype.oninput=function(e){if(e.originalEvent&&e.originalEvent.propertyName&&e.originalEvent.propertyName.toLowerCase()!="value"){return}if(this.getEditable()&&this.getEnabled()&&this.getMaxLength()>0){var o=this.getDomRef();if(o.value.length>this.getMaxLength()){o.value=o.value.substring(0,this.getMaxLength())}}t.prototype.oninput.apply(this,arguments);var r=this.getDomRef();this.setProperty("cursorPos",jQuery(r).cursorPos(),true)};p.prototype.setMaxLength=function(t){this.setProperty("maxLength",t,true);var e=this.getDomRef();if(e&&e.value.length>t&&t>0){e.value=e.value.substring(0,t)}var o=this.getValue();if(o.length>t&&t>0){this.setProperty("value",o.substring(0,t))}return this};p.prototype.setCursorPos=function(t){this.setProperty("cursorPos",t,true);if(this.bFocus){jQuery(this.getDomRef()).cursorPos(t)}return this};return p});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextAreaRenderer", ["./TextFieldRenderer","sap/ui/core/Renderer","sap/ui/core/library","sap/ui/Device"],function(e,t,r,i){"use strict";var a=r.ValueState;var n=r.Wrapping;var o=t.extend(e);o.getInnerTagName=function(){return"textarea"};o.renderInnerAttributes=function(e,t){e.addClass("sapUiTxtA");e.addStyle("overflow","auto");if(t.getWidth()&&t.getWidth()!=""){}else{if(t.getCols()&&t.getCols()!=""){e.writeAttribute("cols",t.getCols())}}if(t.getHeight()&&t.getHeight()!=""){e.addStyle("height",t.getHeight());e.addStyle("margin-top","0");e.addStyle("margin-bottom","0")}else{if(t.getRows()&&t.getRows()!=""){e.writeAttribute("rows",t.getRows())}}switch(t.getWrapping()){case n.Soft:e.writeAttribute("wrap","soft");break;case n.Hard:e.writeAttribute("wrap","hard");break;case n.Off:e.writeAttribute("wrap","off");break}};o.renderARIAInfo=function(e,t){e.writeAccessibilityState(t,{role:t.getAccessibleRole().toLowerCase()||"textbox",labelledby:t.getLabeledBy()?t.getLabeledBy()+" "+t.getAriaDescribedBy().join(" "):undefined,required:t.getRequired(),readonly:!t.getEditable(),multiline:true,autocomplete:"none",invalid:t.getValueState()==a.Error})};o.renderInnerContent=function(e,t){var r=t.getValue();var a=t.getPlaceholder();if(r.length>t.getMaxLength()&&t.getMaxLength()>0){r=r.substring(0,t.getMaxLength())}if(!i.support.input.placeholder&&a&&!r){e.writeEscaped(a)}else{e.writeEscaped(r)}};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextField", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/ValueStateSupport","./TextFieldRenderer","sap/ui/core/library","sap/ui/Device","sap/ui/events/KeyCodes","sap/ui/core/Configuration","sap/ui/dom/jquery/cursorPos","sap/ui/dom/jquery/selectText"],function(jQuery,e,t,i,r,a,s,o,n){"use strict";var u=a.AccessibleRole;var p=a.Design;var l=a.ImeMode;var h=a.TextAlign;var d=a.ValueState;var f=a.TextDirection;var g=t.extend("sap.ui.commons.TextField",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{value:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:f.Inherit},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},required:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLength:{type:"int",group:"Behavior",defaultValue:0},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:d.None},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:h.Begin},imeMode:{type:"sap.ui.core.ImeMode",group:"Behavior",defaultValue:l.Auto},design:{type:"sap.ui.core.Design",group:"Appearance",defaultValue:p.Standard},helpId:{type:"string",group:"Behavior",defaultValue:""},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility",defaultValue:u.Textbox},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Appearance",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{newValue:{type:"string"}}},liveChange:{parameters:{liveValue:{type:"string"}}}}}});g.prototype.init=function(){};g.prototype.onfocusin=function(e){if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onfocus){this.getRenderer().onfocus(this)}};g.prototype.onsapfocusleave=function(e){this._doOnEscape(e);this._checkChange(e);if(this.getEditable()&&this.getEnabled()&&this.getRenderer().onblur){this.getRenderer().onblur(this)}var t=jQuery(this.getFocusDomRef());if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}};g.prototype.onsapenter=function(e){this._checkChange(e)};g.prototype._checkChange=function(e){var t=this.getInputDomRef(),i=t&&t.value,r=this.getValue();if(this.getEditable()&&this.getEnabled()&&r!=i){this.setProperty("value",i,true);this.fireChange({newValue:i})}};g.prototype.onselectstart=function(e){if(!this.getEnabled()){e.preventDefault();e.stopPropagation()}};g.prototype._checkCursorPosForNav=function(e,t){var i=n.getRTL();var r=t?i:!i;var a=jQuery(this.getInputDomRef());var s=a.cursorPos();var o=a.val().length;if(i){s=o-s}if(!r&&s!=o||r&&s!=0){e.stopPropagation()}};g.prototype.onsapnext=function(e){if(e.keyCode!=o.ARROW_DOWN){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=o.END){e.preventDefault();return}this._checkCursorPosForNav(e,true)}};g.prototype.onsapprevious=function(e){if(e.keyCode!=o.ARROW_UP){if(jQuery(this.getFocusDomRef()).data("sap.InNavArea")&&e.keyCode!=o.HOME){e.preventDefault();return}this._checkCursorPosForNav(e,false)}};g.prototype.onsapnextmodifiers=g.prototype.onsapnext;g.prototype.onsappreviousmodifiers=g.prototype.onsapprevious;g.prototype.onsapend=g.prototype.onsapnext;g.prototype.onsaphome=g.prototype.onsapprevious;g.prototype.onsapexpand=function(e){var t=jQuery(this.getFocusDomRef()).data("sap.InNavArea");if(t||t===false){e.stopPropagation();return}};g.prototype.onsapcollapse=g.prototype.onsapexpand;g.prototype.onsapescape=function(e){var t=this.getProperty("value");this._bEsc=true;this._sValue=t;var i=this.getInputDomRef();if(i&&i.value!==t&&!this._propagateEsc){e.stopPropagation()}if(!s.browser.firefox){this._doOnEscape(e)}};g.prototype.onkeydown=function(e){if(e.which==o.Z&&e.ctrlKey&&!e.altKey){e.preventDefault()}};g.prototype.onkeypress=function(e){this._doOnEscape(e);var t=e.which;if(t>0&&t!==o.ESCAPE){var i=jQuery(this.getFocusDomRef());if(i.data("sap.InNavArea")){i.data("sap.InNavArea",false)}}};g.prototype._doOnEscape=function(e){if(this._bEsc){var t=this.getInputDomRef();if(t){if(t.value!==this._sValue){jQuery(t).val(this._sValue)}var i=jQuery(this.getFocusDomRef());if(i.data("sap.InNavArea")===false){i.data("sap.InNavArea",true)}}this._fireLiveChange(e);this._bEsc=undefined;this._sValue=undefined}};g.prototype.onkeyup=function(e){if(e.keyCode==o.F2){var t=jQuery(this.getFocusDomRef());if(t.data("sap.InNavArea")){t.data("sap.InNavArea",false)}else if(t.data("sap.InNavArea")===false){t.data("sap.InNavArea",true)}}};g.prototype.oninput=function(e){this._fireLiveChange(e)};g.prototype._fireLiveChange=function(e){if(this.getEnabled()&&this.getEditable()){var t=jQuery(this.getInputDomRef()).val();this.fireLiveChange({liveValue:t})}};g.prototype.setValueState=function(e){var t=this.getValueState();this.setProperty("valueState",e,true);e=this.getValueState();if(t==e){return this}if(!this.getDomRef()){return this}if(this.getRenderer().setValueState){this.getRenderer().setValueState(this,t,e)}if(this.delayedCallId){clearTimeout(this.delayedCallId);this.delayedCallId=null}if(d.Success==e){this.delayedCallId=setTimeout(function(){this.removeValidVisualization()}.bind(this),3e3)}return this};g.prototype.removeValidVisualization=function(){if(this.getRenderer().removeValidVisualization){this.getRenderer().removeValidVisualization(this)}};g.prototype.setEditable=function(e){var t=this.getEditable();this.setProperty("editable",e,true);e=this.getEditable();if(t!=e){if(this.getDomRef()&&this.getRenderer().setEditable){this.getRenderer().setEditable(this,e)}}return this};g.prototype.setEnabled=function(e){var t=this.getEnabled();this.setProperty("enabled",e,true);e=this.getEnabled();if(t!=e){if(this.getDomRef()&&this.getRenderer().setEnabled){this.getRenderer().setEnabled(this,e)}}return this};g.prototype.setRequired=function(e){var t=this.getRequired();this.setProperty("required",e,true);e=this.getRequired();if(t!=e){if(this.getDomRef()){if(this.getRenderer().setRequired){this.getRenderer().setRequired(this,e)}}this.fireEvent("requiredChanged",{required:e})}return this};g.prototype.setDesign=function(e){var t=this.getDesign();this.setProperty("design",e,true);e=this.getDesign();if(t!=e){if(this.getDomRef()){if(this.getRenderer().setDesign){this.getRenderer().setDesign(this,e)}}}return this};g.prototype.setValue=function(e){var t=e;if(t&&t.length>this.getMaxLength()&&this.getMaxLength()>0){t=t.substring(0,this.getMaxLength())}this.setProperty("value",t,true);t=this.getValue();var i=this.getInputDomRef();if(i&&i.value!==t){if(!s.support.input.placeholder){if(t){this.$().removeClass("sapUiTfPlace");i.value=t}else if(document.activeElement!==i){this.$().addClass("sapUiTfPlace");var r=this.getPlaceholder();if(this.getRenderer().convertPlaceholder){r=this.getRenderer().convertPlaceholder(this)}i.value=r}else{i.value=""}}else{i.value=t}this._sRenderedValue=t}return this};g.prototype.setTooltip=function(e){this._refreshTooltipBaseDelegate(e);this.setAggregation("tooltip",e,true);var t=this.getInputDomRef();if(t){var r=i.enrichTooltip(this,this.getTooltip_AsString());jQuery(t).attr("title",r||"");if(this._getRenderOuter()){jQuery(this.getDomRef()).attr("title",r||"")}}return this};g.prototype.getInputDomRef=function(){if(!this._getRenderOuter()){return this.getDomRef()||null}else{return this.getDomRef("input")||null}};g.prototype.applyFocusInfo=function(e){this.focus();this._restoreUnsavedUserInput(e.userinput);return this};g.prototype.getFocusInfo=function(){return{id:this.getId(),userinput:this._getUnsavedUserInputInfo()}};g.prototype.getLiveValue=function(){var e=this.getInputDomRef();if(e){return jQuery(e).val()}else{return this.getValue()}};g.prototype.ondrop=function(e){if(s.browser.firefox){this.focus()}};g.prototype._getRenderOuter=function(){if(this.bRenderOuter==undefined){var e=this.getRenderer();if(e.renderOuterAttributes||e.renderOuterContentBefore||e.renderOuterContent){this.bRenderOuter=true}else{this.bRenderOuter=false}}return this.bRenderOuter};g.prototype.getIdForLabel=function(){if(!this._getRenderOuter()){return this.getId()}else{return this.getId()+"-input"}};g.prototype.getFocusDomRef=function(){return this.getInputDomRef()};g.prototype._getUnsavedUserInputInfo=function(){var e=this.$();if(e.length&&e.hasClass("sapUiTfFoc")&&!e.hasClass("sapUiTfPlace")&&this.getEnabled()&&this.getEditable()){var t=jQuery(this.getInputDomRef());var i=t.val();var r=this.getValue();var a=0;var s=0;if(typeof t.get(0).selectionStart==="number"){a=t.get(0).selectionStart;s=t.get(0).selectionEnd}return{userinput:i,value:r,cursorPos:t.cursorPos(),selStart:a,selEnd:s}}return null};g.prototype._restoreUnsavedUserInput=function(e){if(e&&this.getEnabled()&&this.getEditable()&&this.getValue()==e.value){var t=e.userinput;if(t&&t.length>this.getMaxLength()&&this.getMaxLength()>0){t=t.substring(0,this.getMaxLength())}var i=jQuery(this.getInputDomRef());if(t!=e.value){i.val(t)}i.cursorPos(e.cursorPos);if(e.selStart!=e.selEnd){i.selectText(e.selStart,e.selEnd)}}};g.prototype.getAccessibilityInfo=function(){return{role:"textbox",type:sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_TYPE_INPUT"),description:this.getValue()||"",focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEnabled()&&this.getEditable()}};return g});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextFieldRenderer", ["sap/ui/core/Renderer","sap/ui/core/ValueStateSupport","sap/ui/core/library","sap/ui/Device"],function(e,t,a,r){"use strict";var i=a.ValueState;var s=a.Design;var d=a.ImeMode;var l={};l.render=function(e,a){var i=a.getWidth();var n=t.enrichTooltip(a,a.getTooltip_AsString());var o=a._getRenderOuter();if(o){e.write("<div");e.writeControlData(a);e.addClass("sapUiTfBack");this.renderStyles(e,a);if(n){e.writeAttributeEscaped("title",n)}var f;if(i&&i!=""){f="width: "+i+";"}if(this.renderOuterAttributes){this.renderOuterAttributes(e,a)}if(f){e.writeAttribute("style",f)}e.writeStyles();e.writeClasses();e.write(">");if(this.renderOuterContentBefore){this.renderOuterContentBefore(e,a)}}if(this.getInnerTagName){e.write("<"+this.getInnerTagName())}else{e.write("<input")}e.addClass("sapUiTf");if(!o){e.writeControlData(a);e.addClass("sapUiTfBack");this.renderStyles(e,a);if(i&&i!=""){e.addStyle("width",i)}}else{e.writeAttribute("id",a.getId()+"-input");e.addClass("sapUiTfInner");e.addStyle("width","100%")}if(n){e.writeAttributeEscaped("title",n)}if(a.getName()){e.writeAttributeEscaped("name",a.getName())}if(!a.getEditable()&&a.getEnabled()){e.writeAttribute("readonly","readonly")}if(this.renderTextFieldEnabled){this.renderTextFieldEnabled(e,a)}else if(!a.getEnabled()){e.writeAttribute("disabled","disabled");e.writeAttribute("tabindex","-1")}else if(!a.getEditable()){e.writeAttribute("tabindex","0")}else{e.writeAttribute("tabindex","0")}var u=a.getTextDirection();if(u){e.addStyle("direction",u.toLowerCase())}var c=l.getTextAlign(a.getTextAlign(),u);if(c){e.addStyle("text-align",c)}switch(a.getImeMode()){case d.Inactive:e.addStyle("ime-mode","inactive");break;case d.Active:e.addStyle("ime-mode","active");break;case d.Disabled:e.addStyle("ime-mode","disabled");break}if(a.getDesign()==s.Monospace){e.addClass("sapUiTfMono")}if(a.getMaxLength()){e.writeAttribute("maxlength",a.getMaxLength())}if(this.renderInnerAttributes){this.renderInnerAttributes(e,a)}if(this.renderARIAInfo){this.renderARIAInfo(e,a)}var p=a.getPlaceholder();if(p){if(this.convertPlaceholder){p=this.convertPlaceholder(a)}if(r.support.input.placeholder){e.writeAttributeEscaped("placeholder",p)}}e.writeStyles();e.writeClasses();if(this.getInnerTagName){e.write(">")}else{e.write(' value="');if(!r.support.input.placeholder&&p&&!a.getValue()){e.writeEscaped(p)}else{e.writeEscaped(a.getValue())}e.write('"');e.write(">")}if(this.getInnerTagName){if(this.renderInnerContent){this.renderInnerContent(e,a)}e.write("</"+this.getInnerTagName()+">")}if(o){if(this.renderOuterContent){this.renderOuterContent(e,a)}e.write("</div>")}};l.renderStyles=function(e,t){e.addClass("sapUiTfBrd");if(t.getEnabled()){if(!t.getEditable()){e.addClass("sapUiTfRo")}else{e.addClass("sapUiTfStd")}}else{e.addClass("sapUiTfDsbl")}switch(t.getValueState()){case i.Error:e.addClass("sapUiTfErr");break;case i.Success:e.addClass("sapUiTfSucc");break;case i.Warning:e.addClass("sapUiTfWarn");break}if(t.getRequired()){e.addClass("sapUiTfReq")}if(t.getPlaceholder()&&!r.support.input.placeholder){e.addClass("sapUiTfPlace")}};l.onfocus=function(e){var t=e.$();var a;t.addClass("sapUiTfFoc");if(!r.support.input.placeholder&&!e.getValue()&&e.getPlaceholder()){if(e._getRenderOuter()){a=e.$("input")}else{a=t}t.removeClass("sapUiTfPlace");a.val("")}};l.onblur=function(e){var t=e.$();var a;t.removeClass("sapUiTfFoc");var i=e.getPlaceholder();if(!r.support.input.placeholder){if(e._getRenderOuter()){a=e.$("input")}else{a=t}if(!a.val()&&i){t.addClass("sapUiTfPlace");if(this.convertPlaceholder){i=this.convertPlaceholder(e)}a.val(i)}}};l.setValueState=function(e,a,r){var s=e.$();var d;var l=e._getRenderOuter();if(l){d=e.$("input")}else{d=s}switch(a){case i.Error:s.removeClass("sapUiTfErr");d.removeAttr("aria-invalid");break;case i.Success:s.removeClass("sapUiTfSucc");break;case i.Warning:s.removeClass("sapUiTfWarn");break}switch(r){case i.Error:s.addClass("sapUiTfErr");d.attr("aria-invalid",true);break;case i.Success:s.addClass("sapUiTfSucc");break;case i.Warning:s.addClass("sapUiTfWarn");break}var n=t.enrichTooltip(e,e.getTooltip_AsString());if(n){s.attr("title",n);if(l){e.$("input").attr("title",n)}}else{s.removeAttr("title");if(l){e.$("input").removeAttr("title")}}};l.setEditable=function(e,t){if(!e.getEnabled()){return}var a=e.$();var r;if(e._getRenderOuter()){r=e.$("input")}else{r=a}if(t){a.removeClass("sapUiTfRo").addClass("sapUiTfStd");r.removeAttr("readonly");r.removeAttr("aria-readonly")}else{a.removeClass("sapUiTfStd").addClass("sapUiTfRo");r.attr("readonly","readonly");r.attr("aria-readonly",true)}};l.setEnabled=function(e,t){var a=e.$();var r;if(e._getRenderOuter()){r=e.$("input")}else{r=a}if(t){if(e.getEditable()){a.removeClass("sapUiTfDsbl").addClass("sapUiTfStd").removeAttr("aria-disabled");r.removeAttr("disabled").removeAttr("aria-disabled").attr("tabindex","0")}else{a.removeClass("sapUiTfDsbl").addClass("sapUiTfRo").removeAttr("aria-disabled");r.removeAttr("disabled").removeAttr("aria-disabled").attr("tabindex","0").attr("readonly","readonly").attr("aria-readonly",true)}}else{if(e.getEditable()){a.removeClass("sapUiTfStd").addClass("sapUiTfDsbl").attr("aria-disabled","true");r.attr("disabled","disabled").attr("aria-disabled","true").attr("tabindex","-1")}else{a.removeClass("sapUiTfRo").addClass("sapUiTfDsbl").attr("aria-disabled","true");r.removeAttr("readonly").removeAttr("aria-readonly").attr("disabled","disabled").attr("aria-disabled","true").attr("tabindex","-1")}}};l.removeValidVisualization=function(e){var t=e.$();if(t){t.removeClass("sapUiTfSucc")}else{setTimeout(function(){l.removeValidVisualization(e)},1e3)}};l.setDesign=function(e,t){e.$().toggleClass("sapUiTfMono",t==s.Monospace)};l.setRequired=function(e,t){var a;if(e._getRenderOuter()){a=e.$("input")}else{a=e.$()}e.$().toggleClass("sapUiTfReq",t);if(t){a.attr("aria-required",true)}else{a.removeAttr("aria-required")}};l.renderARIAInfo=function(e,t){var a={role:t.getAccessibleRole().toLowerCase(),multiline:false,autocomplete:"none"};if(t.getValueState()==i.Error){a["invalid"]=true}e.writeAccessibilityState(t,a)};l.getTextAlign=e.getTextAlign;return l},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextView", ["./library","sap/ui/core/Control","./TextViewRenderer","sap/ui/core/library","sap/base/security/encodeXML"],function(e,t,i,a,r){"use strict";var o=a.TextAlign;var u=e.TextViewColor;var p=e.TextViewDesign;var n=a.TextDirection;var l=t.extend("sap.ui.commons.TextView",{metadata:{interfaces:["sap.ui.commons.ToolbarItem","sap.ui.core.IFormContent"],library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",defaultValue:"",bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:n.Inherit},enabled:{type:"boolean",group:"Behavior",defaultValue:true},helpId:{type:"string",group:"Behavior",defaultValue:""},accessibleRole:{type:"sap.ui.core.AccessibleRole",group:"Accessibility"},design:{type:"sap.ui.commons.TextViewDesign",group:"Data",defaultValue:p.Standard},wrapping:{type:"boolean",group:"Appearance",defaultValue:true},semanticColor:{type:"sap.ui.commons.TextViewColor",group:"Appearance",defaultValue:u.Default},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:o.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});l.prototype.setText=function(e){this.setProperty("text",e,true);var t=this.getDomRef();if(t){e=this.getText();t.innerHTML=r(e).replace(/&#xa;/g,"<br>");if(!this.getTooltip_AsString()){t.title=e}}return this};l.prototype.getAccessibilityInfo=function(){return{description:this.getText()}};return l});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TextViewRenderer", ["sap/ui/core/Renderer","sap/ui/commons/library"],function(e,a){"use strict";var s=a.TextViewDesign;var t=a.TextViewColor;var i={};i.render=function(e,a){this.applyEnabledStyles(e,a);this.applyTextDesign(e,a);if(!a.getWrapping()){e.addClass("sapUiTvWrap")}if(a.getWidth()){e.addStyle("width",a.getWidth())}e.write("<span");e.writeControlData(a);e.addClass("sapUiTv");if(a.getTooltip_AsString()){e.writeAttributeEscaped("title",a.getTooltip_AsString())}else if(a.getText()){e.writeAttributeEscaped("title",a.getText())}var s=a.getTextDirection();if(s){e.addStyle("direction",s.toLowerCase())}var l=i.getTextAlign(a.getTextAlign(),s);if(l){l=l.charAt(0).toUpperCase()+l.substring(1);e.addClass("sapUiTvAlign"+l)}e.writeAttribute("tabindex","-1");e.writeAccessibilityState(a,{role:a.getAccessibleRole()?a.getAccessibleRole().toLowerCase():undefined,invalid:a.getSemanticColor()==t.Negative,disabled:!a.getEnabled()});e.writeClasses();e.writeStyles();e.write(">");e.writeEscaped(a.getText(),true);e.write("</span>")};i.applyTextDesign=function(e,a){var t=a.getDesign();if(t==s.Standard){return}switch(t){case s.Bold:e.addClass("sapUiTvEmph");break;case s.H1:e.addClass("sapUiTvH1");break;case s.H2:e.addClass("sapUiTvH2");break;case s.H3:e.addClass("sapUiTvH3");break;case s.H4:e.addClass("sapUiTvH4");break;case s.H5:e.addClass("sapUiTvH5");break;case s.H6:e.addClass("sapUiTvH6");break;case s.Italic:e.addClass("sapUiTvItalic");break;case s.Small:e.addClass("sapUiTvSmall");break;case s.Monospace:e.addClass("sapUiTvMono");break;case s.Underline:e.addClass("sapUiTvULine");break;default:break}};i.applyEnabledStyles=function(e,a){if(!a.getEnabled()){e.addClass("sapUiTvDsbl");a.allowTextSelection(false)}else{switch(a.getSemanticColor()){case t.Negative:e.addClass("sapUiTvErr");break;case t.Positive:e.addClass("sapUiTvSucc");break;case t.Critical:e.addClass("sapUiTvWarn");break}}};i.getTextAlign=e.getTextAlign;return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Title", ["./library","sap/ui/core/Title"],function(e,a){"use strict";var i=a.extend("sap.ui.commons.Title",{metadata:{deprecated:true,library:"sap.ui.commons"}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ToggleButton", ["./Button","./ToggleButtonRenderer"],function(e,t){"use strict";var s=e.extend("sap.ui.commons.ToggleButton",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{pressed:{type:"boolean",group:"Data",defaultValue:false}}}});s.prototype.onclick=function(e){if(this.getEnabled()){this.setPressed(!this.getPressed());if(this.$().is(":visible")){this.firePress({pressed:this.getPressed()})}}e.preventDefault();e.stopPropagation()};s.prototype.setPressed=function(e){var t;if(e!==this.getProperty("pressed")){t=this.getRenderer();this.setProperty("pressed",e,true);if(!this.getPressed()){t.ondeactivePressed(this)}else{t.onactivePressed(this)}t.updateImage(this)}return this};s.prototype.onAfterRendering=function(){var e=this.getRenderer();if(!this.getPressed()){e.ondeactivePressed(this)}else{e.onactivePressed(this)}};s.prototype.getAccessibilityInfo=function(){var t=e.prototype.getAccessibilityInfo.apply(this,arguments);if(this.getPressed()){t.description=((t.description||"")+" "+sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons").getText("ACC_CTR_STATE_PRESSED")).trim()}return t};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ToggleButtonRenderer", ["./ButtonRenderer","sap/ui/core/Renderer"],function(e,t){"use strict";var s=t.extend(e);s.renderButtonAttributes=function(e,t){e.addClass("sapUiToggleBtn");if(t.getPressed()){e.addClass("sapUiToggleBtnPressed");e.writeAttribute("aria-pressed",true)}else{e.writeAttribute("aria-pressed",false)}};s.onactivePressed=function(e){e.$().addClass("sapUiToggleBtnPressed").attr("aria-pressed",true)};s.ondeactivePressed=function(e){e.$().removeClass("sapUiToggleBtnPressed").attr("aria-pressed",false)};s.updateImage=function(e){e.$("img").attr("src",this._getIconForState(e,"base"))};s._getIconForState=function(e,t){var s;switch(t){case"mouseout":case"focus":case"blur":case"base":return e.getPressed()&&e.getIconSelected()?e.getIconSelected():e.getIcon();case"active":s=e.getIconSelected();return s?s:e.getIcon();case"mouseover":case"deactive":s=e.getIconHovered();if(s){return s}else if(e.getPressed()&&e.getIconSelected()){return e.getIconSelected()}else{return e.getIcon()}}return e.getIcon()};return s},true);
/*!
 # * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Toolbar", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/Control","sap/ui/core/Popup","sap/ui/core/delegate/ItemNavigation","./ToolbarRenderer","sap/base/assert","sap/ui/dom/containsOrEquals","sap/ui/core/ResizeHandler","sap/ui/core/Element","sap/ui/events/KeyCodes","sap/ui/core/Configuration"],function(jQuery,e,t,i,o,s,n,r,a,h,p,l){"use strict";var u=e.ToolbarDesign;var f=t.extend("sap.ui.commons.Toolbar",{metadata:{interfaces:["sap.ui.core.Toolbar"],library:"sap.ui.commons",deprecated:true,properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},design:{type:"sap.ui.commons.ToolbarDesign",group:"Appearance",defaultValue:u.Flat},standalone:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"item"},rightItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"rightItem"}}}});f.prototype.init=function(){this.bOpen=false;this.oDomRef=null;this.oInnerRef=null;this.oOverflowDomRef=null;this._oOverflowPopup=null;this.sOriginalStylePropertyWidth=null;this.bHasRightItems=false;this._bRendering=false;this.bRtl=l.getRTL();this._detectVisibleItemCountChangeTimer=null;var e=this;this.oItemDelegate={onAfterRendering:jQuery.proxy(e._itemRendered,e)};this.data("sap-ui-fastnavgroup","true",true)};f.prototype.onBeforeRendering=function(){s.emptyOverflowPopup(this,false);this.cleanup();this.$("mn").off("keydown",this._handleKeyDown);this.bFirstTime=true;this._bRendering=true};f.prototype.onAfterRendering=function(){this._bRendering=false;this.oDomRef=this.getDomRef();this.oInnerRef=this.oDomRef.firstChild.firstChild;jQuery(this.oInnerRef).css("visibility","visible");this.oOverflowDomRef=this.getDomRef("mn");if(!this.oItemNavigation){this.oItemNavigation=new o;this.addDelegate(this.oItemNavigation)}this.$("mn").on("keydown",jQuery.proxy(this._handleKeyDown,this));this.sResizeListenerId=a.register(this.oDomRef,jQuery.proxy(this.ontoolbarresize,this));var e=this.getRightItems().length;this.bHasRightItems=e>0;if(this.bHasRightItems){this.sRightSideResizeListenerId=a.register(this.oDomRef.lastChild,jQuery.proxy(this.onrightsideresize,this));this.updateAfterResize(true);this._observeVisibleItemCountChange(40)}else{this.updateAfterResize(true);this._observeVisibleItemCountChange(350)}};f.prototype._handleKeyDown=function(e){if(e.keyCode==p.SPACE&&e.target.id===this.getId()+"-mn"){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}};f.prototype.exit=function(){this.cleanup();if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation}this.oItemDelegate=undefined;jQuery(window).off("resize",this.onwindowresize);I.call(this)};f.prototype.updateAfterResize=function(e){if(this._bRendering){return}var t=this.getVisibleItemInfo();this._oLastVisibleItem=t.oLastVisibleItem;this._oFirstInvisibleItem=t.oFirstInvisibleItem;this._iLastVisibleItemTop=t.iLastVisibleItemTop;this.updateItemNavigation(t.iAllItemsBeforeBreak,e);this.updateOverflowIcon(t.bOverflow);if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null}};f.prototype._detectVisibleItemCountChange=function(){if(!this.getDomRef()){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null}return}if(this._oLastVisibleItem&&this._oFirstInvisibleItem){var e=this._oLastVisibleItem.offsetLeft;var t=this._oFirstInvisibleItem.offsetLeft;var i=this._oLastVisibleItem.offsetTop;var o=this.bRtl?t<e:t>e;if(i!=this._iLastVisibleItemTop||!this.bOpen&&o){if(this.bOpen){this.closePopup(true)}this.updateAfterResize(false)}}else if(this._oLastVisibleItem&&!this._oFirstInvisibleItem){if(this._oLastVisibleItem.offsetTop!=this._iLastVisibleItemTop){this.updateAfterResize(false)}}this._observeVisibleItemCountChange(350);if(this.bFirstTime&&this.bHasRightItems){this.onrightsideresize();this.bFirstTime=false}};f.prototype._observeVisibleItemCountChange=function(e){this._detectVisibleItemCountChangeTimer=setTimeout(function(){this._detectVisibleItemCountChange()}.bind(this),e)};f.prototype.updateItemNavigation=function(e,t){this.oItemNavigation.setRootDomRef(this.oDomRef);var i=g.call(this);var o=[];for(var s=0;s<e;s++){var n=i[s].getFocusDomRef();if(n){o.push(n)}}o.push(this.oOverflowDomRef);this.iLeftItemDomRefCount=o.length;var r=this.getRightItems();for(var s=0;s<r.length;s++){var n=r[s].getFocusDomRef();if(n){o.push(n)}}this.oItemNavigation.setItemDomRefs(o);this.iItemDomRefCount=o.length;if(t){for(var s=e;s<i.length;s++){var n=i[s].getFocusDomRef();var a=jQuery(n);if(n&&a.attr("tabindex")=="0"){a.attr("tabIndex",-1)}}}};f.prototype.getVisibleItemInfo=function(e){var t=0;if(this.oInnerRef){var i=e?this.oInnerRef.childNodes:this.oInnerRef.parentNode.querySelectorAll("#"+this.oInnerRef.id+" > :not(.sapUiHiddenPlaceholder)");this.bRtl=l.getRTL();var o,s,r=0,a,h,p=0,u=null,f=null,m,g,I=false;for(var v=1,b=i.length;v<b;v++){s=i[v];a=s.offsetLeft;if(v==1){h=i[0].offsetWidth;p=i[0].offsetLeft}if(this.bRtl){r=s.offsetWidth;o=!d.call(this,s)&&a+r>=p+h}else{o=!d.call(this,s)&&a<=p&&s.offsetTop>i[0].offsetTop}if(o){t=v;u=i[v-1];f=s;m=u.offsetTop;I=true;break}else if(d.call(this,s)){t=v;n(t===b-1,"visible items ("+t+") must be one less than the items count ("+b+")");u=i[v-1];f=null;m=u.offsetTop;I=false;break}else{p=a;h=r}}g=c.call(this,u)}return{count:t,oLastVisibleItem:u,oFirstInvisibleItem:f,iLastVisibleItemTop:m,iAllItemsBeforeBreak:g,bOverflow:I}};f.prototype.updateOverflowIcon=function(e){this.oOverflowDomRef.style.display=e||this.bOpen?"block":"none"};f.prototype.onclick=function(e){if(e.target.id===this.getId()+"-mn"){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}};f.prototype.onsapdown=function(e){if(e.target.id===this.getId()+"-mn"){if(!this.bOpen){this.handleOverflowButtonTriggered();e.preventDefault();e.stopImmediatePropagation()}}};f.prototype.onsapup=function(e){if(e.target.id===this.getId()+"-mn"){if(this.bOpen){this.handleOverflowButtonTriggered();e.preventDefault();e.stopPropagation()}}};f.prototype.handleOverflowButtonTriggered=function(){if(!this.bPopupInitialized){this._oOverflowPopup=new m(this);this.popup=new i(this._oOverflowPopup,false,true,true);this.popup.setAutoCloseAreas([this.getId()+"-mn"]);this.bPopupInitialized=true}if(this.bOpen){this.closePopup(false)}else{this.openPopup()}};f.prototype.openPopup=function(){this.getRenderer().setActive(this);var e=jQuery(this.getDomRef());this.sOriginalStylePropertyWidth=e.prop("style").width;e.width(e.width());s.fillOverflowPopup(this);this.popup.attachEvent("opened",this.handlePopupOpened,this);this.popup.attachEvent("closed",this.handlePopupClosed,this);jQuery(window).on("resize",jQuery.proxy(this.onwindowresize,this));var t=0;this.popup.open(t,i.Dock.EndTop,i.Dock.EndBottom,this.$("mn"),"","fit",true)};f.prototype.handlePopupOpened=function(){var e=g.call(this);var t=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.bOpen=true;var i=[];for(var o=t;o<e.length;o++){var s=e[o].getFocusDomRef();if(s){i.push(s)}}this.popup.getContent().initItemNavigation(i)};f.prototype.closePopup=function(e){this._bResetFocus=e;this.popup.close();jQuery(window).off("resize",this.onwindowresize)};f.prototype.handlePopupClosed=function(){this.getRenderer().unsetActive(this);this.bOpen=false;s.emptyOverflowPopup(this);var e=this.getVisibleItemInfo().iAllItemsBeforeBreak;this.updateItemNavigation(e,true);if(this._bResetFocus){this.oItemNavigation.focusItem(this.iLeftItemDomRefCount-1)}this._bResetFocus=false};f.prototype.prepareFocusInfoRedirect=function(e){if(e&&!e._orig_getFocusInfo){var t=this.getId();e._orig_getFocusInfo=e.getFocusInfo;e.getFocusInfo=function(){return{id:t,childInfo:this._orig_getFocusInfo()}};var i=this;e._orig_applyFocusInfo=e.applyFocusInfo;e.applyFocusInfo=function(e){return i.applyFocusInfo(e.childInfo)}}return e};f.prototype.cleanupFocusInfoRedirect=function(e){if(e){e.getFocusInfo=e._orig_getFocusInfo;delete e._orig_getFocusInfo;delete e._orig_applyFocusInfo}return e};f.prototype.insertItem=function(e,t){this.insertAggregation("items",this.prepareFocusInfoRedirect(e),t);e.addDelegate(this.oItemDelegate);return this};f.prototype.addItem=function(e){this.addAggregation("items",this.prepareFocusInfoRedirect(e));e.addDelegate(this.oItemDelegate);return this};f.prototype.removeItem=function(e){var t=this.removeAggregation("items",e);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t)};f.prototype.removeAllItems=function(){var e=this.removeAllAggregation("items");for(var t=0,i=e.length;t<i;t++){e[t]=this.cleanupFocusInfoRedirect(e[t]);e[t].removeDelegate(this.oItemDelegate)}return e};f.prototype.insertRightItem=function(e,t){this.insertAggregation("rightItems",this.prepareFocusInfoRedirect(e),t);e.addDelegate(this.oItemDelegate);return this};f.prototype.addRightItem=function(e){this.addAggregation("rightItems",this.prepareFocusInfoRedirect(e));e.addDelegate(this.oItemDelegate);return this};f.prototype.removeRightItem=function(e){var t=this.removeAggregation("rightItems",e);t.removeDelegate(this.oItemDelegate);return this.cleanupFocusInfoRedirect(t)};f.prototype.removeAllRightItems=function(){var e=this.removeAllAggregation("rightItems");for(var t=0,i=e.length;t<i;t++){e[t]=this.cleanupFocusInfoRedirect(e[t]);e[t].removeDelegate(this.oItemDelegate)}return e};f.prototype.getFocusInfo=function(){var e=this.getId();if(this.bOpen){return{id:e,childId:e}}else{return{id:e}}};f.prototype.applyFocusInfo=function(e){if(e){var t=e.childId;if(this.bOpen&&t){if(t===this.getId()){return}var i=sap.ui.getCore().byId(t);var o;if(i&&this.popup&&(o=this.popup.getContent())&&r(o.getDomRef(),i.getDomRef())){o.applyFocusInfo(e.childInfo);return}}}this.focus()};var m=h.extend("sap.ui.commons.ToolbarOverflowPopup",{constructor:function(e){this.oToolbar=e;var t=e.getId()+"-pu";h.call(this,t)},exit:function(){this.$().remove()},initItemNavigation:function(e){if(!this.oItemNavigation){this.oItemNavigation=new o;this.addDelegate(this.oItemNavigation)}this.oItemNavigation.setRootDomRef(s.getPopupArea(this.oToolbar));this.oItemNavigation.setItemDomRefs(e);this.oItemNavigation.focusItem(0)},getDomRef:function(){var e=s.getPopupArea(this.oToolbar);if(e){return e.parentNode}else{return null}},isActive:function(){return s.getPopupArea(this.oToolbar)!=null},onsapescape:function(e){this.oToolbar.closePopup(true)},onsaptabnext:function(e){this.oToolbar.closePopup(true);e.preventDefault();e.stopPropagation()},onsaptabprevious:function(e){this.oToolbar.closePopup(true);e.preventDefault();e.stopPropagation()}});f.prototype._itemRendered=function(){if(this.oItemNavigation){this.updateAfterResize(true)}else{if(!this.sUpdateItemNavigationTimer){this.sUpdateItemNavigationTimer=setTimeout(function(){this.updateAfterResize(true)}.bind(this),0)}}};f.prototype.onwindowresize=function(e){if(this.bOpen){this.closePopup(true)}};f.prototype.ontoolbarresize=function(e){if(this.bOpen){this.closePopup(true)}};f.prototype.onrightsideresize=function(){if(!this.getDomRef()){this.cleanup();return}if(this.getRightItems().length>0){var e=this.oDomRef.lastChild;var t=e.offsetWidth;if(this.bRtl){jQuery(this.oInnerRef).css("margin-left",t+10+"px")}else{jQuery(this.oInnerRef).css("margin-right",t+10+"px")}var i=this.oDomRef.firstChild.firstChild.firstChild;var o=this.getDomRef("mn").offsetWidth;var s=i.offsetWidth+t+o+20;jQuery(this.oDomRef).css("min-width",s+"px");jQuery(this.oInnerRef).css("visibility","visible")}};f.prototype.cleanup=function(){if(this._detectVisibleItemCountChangeTimer){clearTimeout(this._detectVisibleItemCountChangeTimer);this._detectVisibleItemCountChangeTimer=null}if(this.sUpdateItemNavigationTimer){clearTimeout(this.sUpdateItemNavigationTimer);this.sUpdateItemNavigationTimer=null}if(this.sResizeListenerId){a.deregister(this.sResizeListenerId);this.sResizeListenerId=null}if(this.sRightSideResizeListenerId){a.deregister(this.sRightSideResizeListenerId);this.sRightSideResizeListenerId=null}};function g(){var e=[];this.getItems().forEach(function(t){if(t instanceof sap.ui.commons.ToolbarSeparator||t.getVisible()){e.push(t)}});return e}function d(e){var t=this.getId()+"-mn";return e.id===t}function c(e){var t=0;var i=g.call(this);i.forEach(function(i,o){if(i.getDomRef()===e){t=o+1;return false}});return t}return f;function I(){if(this.bPopupInitialized){this._oOverflowPopup.destroy();this._oOverflowPopup=null;this.popup.detachOpened(this.handlePopupOpened,this);this.popup.detachClosed(this.handlePopupClosed,this);this.popup.destroy();this.popup=null;this.bPopupInitialized=false}}});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ToolbarRenderer", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/assert","./library","./ToolbarSeparator"],function(jQuery,e,t,r,i){"use strict";var a=r.ToolbarSeparatorDesign;var o={};o.render=function(e,r){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");t(r&&r.isA("sap.ui.commons.Toolbar"),"ToolbarRenderer.render: oToolbar must be a toolbar");e.write("<div role='toolbar' tabindex='0'");e.writeControlData(r);if(r.getWidth()){e.addStyle("width",r.getWidth())}var s=r.getTooltip_AsString();if(s){e.writeAttributeEscaped("title",s)}e.addClass("sapUiTb");e.addClass("sapUiTbDesign"+r.getDesign());if(r.getStandalone()){e.addClass("sapUiTbStandalone")}e.writeStyles();e.writeClasses();e.write(">");var n=r.getRightItems();var l=n.length;var d=l>0;var p="<div class='sapUiTbInner' id='"+r.getId()+"-inner"+"'>";if(d){e.write("<div class='sapUiTbCont sapUiTbContLeft'>"+p)}else{e.write("<div class='sapUiTbCont'>"+p)}var u=r.getItems();var f=u.length;for(var b=0;b<f;b++){var g=u[b];if(g){t(g.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"),"ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");if(g instanceof i){o.renderSeparator(e,g)}else{e.renderControl(g)}}}e.write("<div id='");e.write(r.getId());e.write("-mn' class='sapUiTbOB' role='button' aria-haspopup='true' title='"+a.getText("TOOLBAR_OVERFLOW")+"' tabindex='-1'></div></div></div>");if(d){e.write("<div class='sapUiTbInnerRight' >");for(var b=0;b<l;b++){var g=n[b];if(g){t(g.getMetadata().isInstanceOf("sap.ui.commons.ToolbarItem"),"ToolbarRenderer.render: oToolbarItem must be a ToolbarItem");if(g instanceof i){o.renderSeparator(e,g)}else{e.renderControl(g)}}}e.write("</div>")}e.write("</div>")};o.renderSeparator=function(e,t){if(t.getDisplayVisualSeparator()){e.write("<span ");e.writeElementData(t);if(t.getDesign()===a.FullHeight){e.write(" class='sapUiTbSeparator sapUiTbSepFullHeight' role='separator'></span>")}else{e.write(" class='sapUiTbSeparator' role='separator'></span>")}}else{e.write("<span ");e.writeElementData(t);e.write(" class='sapUiTbSpacer' role='separator'></span>")}};o.fillOverflowPopup=function(e){var t=e.getDomRef("pu");if(!t){t=o.initOverflowPopup(e).firstChild}var r=jQuery(t.parentNode),i=e.getVisibleItemInfo(true).count,a=e.getDomRef().firstChild.firstChild,s=0,n=a.firstChild,l=e.getId()+"-mn",d=r.width(),p=0;while(n){var u=n.nextSibling;if(s>=i){if(n.id===l){break}p=p<jQuery(n).outerWidth(true)?jQuery(n).outerWidth(true):p;t.appendChild(n)}n=u;s++}if(p>d){var f=12;r.width(p+f)}};o.initOverflowPopup=function(e){var t=sap.ui.getCore().getStaticAreaRef();var r=document.createElement("div");r.className="sapUiTbDD sapUiTbDesignFlat";r.innerHTML="<div id='"+e.getId()+"-pu' data-sap-ui="+e.getId()+" tabindex='0' role='menu'></div>";t.appendChild(r);return r};o.emptyOverflowPopup=function(t,r){var i=t.getDomRef("pu"),a=t.getDomRef(),o=null,s="",n=[];if(r===undefined){r=true}if(i){if(r&&a){o=a.firstChild.firstChild;s="insertBefore";n=[t.getDomRef("mn")]}else if(!r){o=i;s="removeChild"}else{e.error("The renderer 'sap.ui.commons.ToolbarRenderer' cannot empty the toolbar overflow popup.");return}while(i.hasChildNodes()){var l=[i.firstChild].concat(n);o[s].apply(o,l)}if(a&&t.sOriginalStylePropertyWidth){jQuery(a).width(t.sOriginalStylePropertyWidth);t.sOriginalStylePropertyWidth=null}}};o.getPopupArea=function(e){return e.getDomRef("pu")};o.setActive=function(e){e.$("mn").addClass("sapUiTbOBAct")};o.unsetActive=function(e){e.$("mn").removeClass("sapUiTbOBAct")};return o},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ToolbarSeparator", ["./library","sap/ui/core/Element"],function(e,a){"use strict";var r=a.extend("sap.ui.commons.ToolbarSeparator",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],library:"sap.ui.commons",deprecated:true,properties:{displayVisualSeparator:{type:"boolean",group:"Appearance",defaultValue:true},design:{type:"sap.ui.commons.ToolbarSeparatorDesign",group:"Misc",defaultValue:null}}}});r.prototype.getFocusDomRef=function(){return undefined};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/Tree", ["sap/ui/thirdparty/jquery","sap/base/Log","sap/base/util/isEmptyObject","./library","sap/ui/core/Control","./TreeRenderer","./Button","sap/ui/core/Configuration"],function(jQuery,e,t,o,i,s,n,l){"use strict";var d=o.TreeSelectionMode;var r=i.extend("sap.ui.commons.Tree",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{title:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"auto"},showHeader:{type:"boolean",group:"Misc",defaultValue:true},showHeaderIcons:{type:"boolean",group:"Misc",defaultValue:true},showHorizontalScrollbar:{type:"boolean",group:"Misc",defaultValue:false},minWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},selectionMode:{type:"sap.ui.commons.TreeSelectionMode",group:"Behavior",defaultValue:d.Legacy}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node",bindable:"bindable"}},events:{select:{allowPreventDefault:true,parameters:{node:{type:"sap.ui.commons.TreeNode"},nodeContext:{type:"object"}}},selectionChange:{parameters:{nodes:{type:"sap.ui.commons.TreeNode[]"},nodeContexts:{type:"object[]"}}}}}});r.prototype.resizeListenerId;r.prototype.init=function(){this.bAllCollapsed=false;this.allowTextSelection(false);this.iOldScrollTop=null;this.mSelectedNodes={};this.mSelectedContexts={};this.aLeadSelection=null;var e=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.oCollapseAllButton=new n(this.getId()+"-CollapseAll",{icon:this.getIconPrefix()+"CollapseAll.png",tooltip:e.getText("TREE_COLLAPSE_ALL"),lite:true});this.oExpandAllButton=new n(this.getId()+"-ExpandAll",{icon:this.getIconPrefix()+"ExpandAll.png",tooltip:e.getText("TREE_EXPAND_ALL"),lite:true});this.oCollapseAllButton.attachPress(this.onCollapseAll,this);this.oExpandAllButton.attachPress(this.onExpandAll,this);this.oCollapseAllButton.addStyleClass("sapUiTreeCol");this.oExpandAllButton.addStyleClass("sapUiTreeExp")};r.prototype.exit=function(){if(this.oCollapseAllButton){this.oCollapseAllButton.destroy();this.oCollapseAllButton=null}if(this.oExpandAllButton){this.oExpandAllButton.destroy();this.oExpandAllButton=null}};r.SelectionType={Select:"Select",Toggle:"Toggle",Range:"Range"};r.prototype.onThemeChanged=function(){if(this.oCollapseAllButton&&this.oExpandAllButton){this.oCollapseAllButton.setIcon(this.getIconPrefix()+"CollapseAll.png");this.oExpandAllButton.setIcon(this.getIconPrefix()+"ExpandAll.png")}};r.prototype.onExpandAll=function(){this.expandAll()};r.prototype.onCollapseAll=function(){this.collapseAll()};r.prototype.expandAll=function(){var e=this._getNodes();for(var t=0;t<e.length;t++){e[t].expand(true,true);this._adjustSelectionOnExpanding(e[t])}};r.prototype.collapseAll=function(){var e=this._getNodes();for(var t=0;t<e.length;t++){e[t].collapse(true,true);this._adjustSelectionOnCollapsing(e[t])}this._adjustFocus()};r.prototype.onsapdown=function(e){this.moveFocus(false);e.preventDefault()};r.prototype.onsapup=function(e){this.moveFocus(true);e.preventDefault()};r.prototype.onsaphome=function(e){this.placeFocus(this.getFirstSibling(e.target));e.preventDefault()};r.prototype.onsaphomemodifiers=function(e){this.placeFocus(this.getFirst());e.preventDefault()};r.prototype.onsapend=function(e){this.placeFocus(this.getLastSibling(e.target));e.preventDefault()};r.prototype.onsapendmodifiers=function(e){this.placeFocus(this.getLast());e.preventDefault()};r.prototype.onsapcollapseall=function(e){if(this.bAllCollapsed){this.expandAll()}else{this.collapseAll()}this.bAllCollapsed=!this.bAllCollapsed};r.prototype.getIconPrefix=function(){var e="themes/"+l.getTheme()+"/";if(!l.getRTL()){e+="img/tree/"}else{e+="img-RTL/tree/"}return sap.ui.resource("sap.ui.commons",e)};r.prototype.getFirstSibling=function(e){var t=jQuery(e).siblings(".sapUiTreeNode:visible").first();if(t.length){return t[0]}return null};r.prototype.getLastSibling=function(e){var t=jQuery(e).siblings(".sapUiTreeNode:visible").last();if(t.length){return t[0]}return null};r.prototype.getFirst=function(){var e=this.$().find(".sapUiTreeNode:visible").first();if(e.length){return e[0]}return null};r.prototype.getLast=function(){var e=this.$().find(".sapUiTreeNode:visible").last();if(e.length){return e[0]}return null};r.prototype.moveFocus=function(e){var t=jQuery(".sapUiTreeNode:focus");if(t.length){var o=sap.ui.getCore().byId(t[0].id);var i=this.$().find(".sapUiTreeNode:visible");var s=i.index(t[0]);var n=s;if(e){n--}else{n++}if(n>=0&&n<i.length){var l=i.eq(n);var d=sap.ui.getCore().byId(l[0].id);o.blur();d.focus()}}};r.prototype._adjustFocus=function(){var e=this.$().find('.sapUiTreeNode[tabIndex="0"]');if(!e.is(":visible")){var t=this.$().find(".sapUiTreeNode");var o=t.index(e[0]);var i=t.filter(":lt("+o+")");var s=i.filter(":visible");var n=s[s.length-1];if(n){n.setAttribute("tabindex","0");if(jQuery(".sapUiTreeNode:focus").is(":not(:visible)")){n.focus()}}}};r.prototype.placeFocus=function(e){if(!e){return}var t=this.$().find(".sapUiTreeNode[tabIndex='0']");if(t.length){t[0].setAttribute("tabindex","-1")}e.setAttribute("tabindex","0");var o=sap.ui.getCore().byId(e.id);o.focus()};r.prototype._adjustSelectionOnExpanding=function(e){if(!e){return}var t=[];if(e.getSelectedForNodes().length){t.push(e)}a(e,t,null);var o=e.$();if(o&&o.hasClass("sapUiTreeNodeSelectedParent")){o.removeClass("sapUiTreeNodeSelectedParent")}var i=e.$("children").find(".sapUiTreeNodeExpanded.sapUiTreeNodeSelectedParent");i.removeClass("sapUiTreeNodeSelectedParent")};function a(e,t,o){var i=e.getExpanded(),s=false,n=i&&!!e.getSelectedForNodes().length,l=o||i?o:e,d;for(d=0;d<t.length;d++){if(t[d].getSelectedForNodes().indexOf(e.getId())!==-1){s=true;t[d].removeAssociation("selectedForNodes",e,true)}}if(l&&s&&l!==e){if(l.getSelectedForNodes().indexOf(e.getId())===-1){l.addAssociation("selectedForNodes",e,true)}l.$().addClass("sapUiTreeNodeSelectedParent")}if(n){t.push(e)}var r=e._getNodes();for(d=0;d<r.length;d++){a(r[d],t,l)}if(n){t.pop(e)}}function c(e,t){var o=e._getNodes(),i;for(var s=0;s<o.length;s++){i=o[s];if(i.getIsSelected()){t.addAssociation("selectedForNodes",i,true)}c(i,t)}}r.prototype._adjustSelectionOnCollapsing=function(e){if(!e){return}c(e,e);if(e.getSelectedForNodes().length){var t=e.$();if(t&&!t.hasClass("sapUiTreeNodeSelectedParent")){t.addClass("sapUiTreeNodeSelectedParent")}}};r.prototype.isTreeBinding=function(e){return e=="nodes"};r.prototype.updateNodes=function(e){var t,o,i,s,n;if(e==="filter"){t=this.getAggregation("nodes");s=t.length;for(n=0;n<s;n++){t[n].destroy()}this.mSelectedNodes={}}this.updateAggregation("nodes");for(i in this.mSelectedContexts){o=this.getNodeByContext(this.mSelectedContexts[i]);if(o){o.setIsSelected(true)}else{this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,i)}}};r.prototype._removeItemFromObject=function(e,t){var o,i={};for(o in e){if(o!==t){i[o]=e[o]}}return i};r.prototype.getNodeContext=function(e){var t=this.getBindingInfo("nodes"),o=t&&t.model;return e.getBindingContext(o)};r.prototype.getNodeByContext=function(e){var t=this.getBindingInfo("nodes"),o=t&&t.model;return this.findNode(this,function(t){var i=t.getBindingContext(o);return e&&i&&e.getPath()===i.getPath()})};r.prototype.findNode=function(e,t){var o,i=this;if(t(e)){return e}jQuery.each(e._getNodes(),function(e,s){o=i.findNode(s,t);if(o){return false}});return o};r.prototype.setSelectionMode=function(e){e=this.validateProperty("selectionMode",e);if(this.getSelectionMode()!=e){this.setProperty("selectionMode",e);this._delSelection()}return this};r.prototype.getSelection=function(){for(var e in this.mSelectedNodes){return this.mSelectedNodes[e]}return null};r.prototype.setSelection=function(e,t,o){var i=true;if(!t){i=this.fireSelect({node:e,nodeContext:this.getNodeContext(e)})}if(i){switch(this.getSelectionMode()){case d.Legacy:case d.Single:this._setSelectedNode(e,t);break;case d.Multi:if(o==r.SelectionType.Range){this._setSelectedNodeMapRange(e,t)}else if(o==r.SelectionType.Toggle){this._setSelectedNodeMapToggle(e,t)}else{this._setSelectedNode(e,t)}break;case d.None:break}}};r.prototype.onAfterRendering=function(){if(this.iOldScrollTop){this.$("TreeCont").scrollTop(this.iOldScrollTop)}};r.prototype.invalidate=function(){var e=this;i.prototype.invalidate.apply(this,arguments);if(this.iSelectionUpdateTimer){return}this.iSelectionUpdateTimer=setTimeout(function(){e.mSelectedNodes={};e.mSelectedContexts=[];e.updateSelection(e,true);e.iSelectionUpdateTimer=null},0)};r.prototype._addSelectedNodeContext=function(e){var t;if(e&&e.sPath){t=e.sPath;if(this.getSelectionMode()===d.Multi){if(!(t in this.mSelectedContexts)){this.mSelectedContexts[t]=e}}else{this.mSelectedContexts={};this.mSelectedContexts[t]=e}}};r.prototype.updateSelection=function(o,i){var s=this;jQuery.each(o._getNodes(),function(o,n){if(n.getIsSelected()){switch(s.getSelectionMode()){case d.None:e.warning("Added selected nodes in a tree with disabled selection");n.setIsSelected(false);break;case d.Legacy:if(t(s.mSelectedNodes)){s.mSelectedNodes[n.getId()]=n;s._addSelectedNodeContext(s.getNodeContext(n))}break;case d.Single:if(t(s.mSelectedNodes)==false){e.warning("Added multiple selected nodes in single select tree");n.setIsSelected(false)}else{s.mSelectedNodes[n.getId()]=n;s._addSelectedNodeContext(s.getNodeContext(n))}break;case d.Multi:if(!i){e.warning("Added selected node inside collapsed node in multi select tree");n.setIsSelected(false)}else{s.mSelectedNodes[n.getId()]=n;s._addSelectedNodeContext(s.getNodeContext(n))}break}}s.updateSelection(n,i&&n.getExpanded())})};r.prototype.onBeforeRendering=function(){this.iOldScrollTop=this.$("TreeCont").scrollTop()};r.prototype._setSelectedNode=function(e,t){var o=this,i=this.getNodeContext(e);jQuery.each(this.mSelectedNodes,function(e,i){o._delMultiSelection(i,t)});e._select(t,true);this.mSelectedNodes[e.getId()]=e;this._addSelectedNodeContext(i);this.oLeadSelection=e;if(!t){this.fireSelectionChange({nodes:[e],nodeContexts:[i]})}};r.prototype._setSelectedNodeMapToggle=function(e,t){this._setNodeSelection(e,!e.getIsSelected(),t)};r.prototype._setSelectedNodeMapRange=function(e,t){var o,i=[],s=[],n,l,d,r;if(this.mSelectedNodes[e.getId()]==e){return}else{if(this._getNodes().length>0){o=this._getSelectableNodes();n=o.indexOf(this.oLeadSelection);l=o.indexOf(e);d=n<l?n:l;r=n<l?l:n;for(var a=d;a<=r;a++){this._setMultiSelection(o[a],t)}}}if(!t){jQuery.map(this.mSelectedNodes,function(e){i.push(e)});jQuery.map(this.mSelectedContexts,function(e){s.push(e)});this.fireSelectionChange({nodes:i,nodeContexts:s})}};r.prototype._getSelectableNodes=function(e){var t=[];function o(e){jQuery.each(e,function(e,i){if(i.getSelectable()){t.push(i)}if(i.getExpanded()){o(i._getNodes())}})}o(this._getNodes());return t};r.prototype._setNodeSelection=function(e,t,o){var i=[],s=[],n;if(this.getSelectionMode()==d.Single){if(t){var l=this.getSelection();this._setSelectedNode(e,o);if(!e.isVisible()){n=this._getVisibleNode(e);this._adjustSelectionOnCollapsing(n)}if(l&&!l.isVisible()){n=this._getVisibleNode(l);this._adjustSelectionOnExpanding(n)}return}else{this._delMultiSelection(e,o);if(!e.isVisible()){n=this._getVisibleNode(e);this._adjustSelectionOnExpanding(n)}}}if(t){this._setMultiSelection(e,o);this.oLeadSelection=e}else{this._delMultiSelection(e,o);this.oLeadSelection=e}if(!o){jQuery.map(this.mSelectedNodes,function(e){i.push(e)});jQuery.map(this.mSelectedContexts,function(e){s.push(e)});this.fireSelectionChange({nodes:i,nodeContexts:s})}};r.prototype._setMultiSelection=function(e,t){if(!e){return}e._select(t);this.mSelectedNodes[e.getId()]=e;this._addSelectedNodeContext(this.getNodeContext(e))};r.prototype._delMultiSelection=function(e){var t;if(!e){return}e._deselect();this.mSelectedNodes=this._removeItemFromObject(this.mSelectedNodes,e.getId());t=e.getBindingContext();if(t&&t.sPath){if(t.sPath in this.mSelectedContexts){this.mSelectedContexts=this._removeItemFromObject(this.mSelectedContexts,t.sPath)}}};r.prototype._delSelection=function(){var e=this;if(this.oSelectedNode){this.oSelectedNode._deselect()}if(t(this.mSelectedNodes)==false){jQuery.each(this.mSelectedNodes,function(t,o){e._delMultiSelection(o)})}};r.prototype._getNodes=function(){return this.mAggregations.nodes||[]};r.prototype._getVisibleNode=function(e){var t=e.getParent();if(t.isVisible()){var o=t}else{o=this._getVisibleNode(t)}return o};return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TreeNode", ["sap/ui/thirdparty/jquery","./library","sap/ui/core/CustomStyleClassSupport","sap/ui/core/Element","./Tree","sap/ui/core/Configuration"],function(jQuery,e,t,s,i,o){"use strict";var r=e.TreeSelectionMode;var a=s.extend("sap.ui.commons.TreeNode",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{text:{type:"string",group:"Misc",defaultValue:null},expanded:{type:"boolean",group:"Misc",defaultValue:true},hasExpander:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},isSelected:{type:"boolean",group:"Misc",defaultValue:false},selectable:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"nodes",aggregations:{nodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"node"}},associations:{selectedForNodes:{type:"sap.ui.commons.TreeNode",multiple:true,singularName:"selectedForNode",visibility:"hidden"},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{toggleOpenState:{parameters:{opened:{type:"boolean"}}},selected:{}}}});a.prototype.getSelectedForNodes=function(){return this.getAssociation("selectedForNodes",[])};a.ANIMATION_DURATION=600;t.apply(a.prototype);a.prototype.expand=function(e,t){this.setProperty("expanded",true,true);var s=null;if(!t){s=l.bind(this)}var i=this.$();if(i.hasClass("sapUiTreeNodeCollapsed")){i.toggleClass("sapUiTreeNodeCollapsed");i.toggleClass("sapUiTreeNodeExpanded");i.attr("aria-expanded","true");var o=this.$("children");if(o){if(e){o.show()}else{o.stop(true,true);o.show(a.ANIMATION_DURATION,s)}o.css({display:"block"})}this.fireToggleOpenState({opened:true})}if(e){var r=this._getNodes();for(var n=0;n<r.length;n++){r[n].expand(e,true)}s&&s()}};a.prototype.collapse=function(e,t){this.setProperty("expanded",false,true);var s=null;if(!t){s=n.bind(this)}var i=this.$();if(i.hasClass("sapUiTreeNodeExpanded")){i.toggleClass("sapUiTreeNodeCollapsed");i.toggleClass("sapUiTreeNodeExpanded");i.attr("aria-expanded","false");var o=this.$("children");if(o){if(e){o.hide()}else{o.stop(true,true);o.hide(a.ANIMATION_DURATION,s)}}this.fireToggleOpenState({opened:false})}if(e){var r=this._getNodes();for(var l=0;l<r.length;l++){r[l].collapse(e,true)}s&&s()}};a.prototype.select=function(e){var t=this.getTree();if(t){t.setSelection(this,e)}else{this._select()}};function l(){var e=this.getTree();if(e){e._adjustSelectionOnExpanding(this)}}function n(){var e=this.getTree();if(e){e._adjustSelectionOnCollapsing(this);e._adjustFocus()}}a.prototype._select=function(e){this.setProperty("isSelected",true,true);if(!e){this.fireSelected()}if(this.getDomRef()){this.$().closest(".sapUiTreeNode").addClass("sapUiTreeNodeSelected").attr("aria-selected","true");this.scrollIntoView()}};a.prototype._deselect=function(e){this.setProperty("isSelected",false,true);if(this.getDomRef()){this.$().removeClass("sapUiTreeNodeSelected").removeAttr("aria-selected")}};a.prototype._getNodes=function(){return this.mAggregations.nodes||[]};a.prototype.hasSelectedHiddenChild=function(){var e=this._getNodes();for(var t=0;t<e.length;t++){if(!e[t].isVisible()&&e[t].getIsSelected()||e[t].hasSelectedHiddenChild()){return true}}return false};a.prototype.setIsSelected=function(e){var t=this.getTree();if(!this.getSelectable()){return this}if(e==this.getProperty("isSelected")){return this}if(t){t._setNodeSelection(this,e,true)}else{this.setProperty("isSelected",e,true)}return this};a.prototype.setSelectable=function(e){if(!e&&this.getIsSelected()){this.setIsSelected(false)}this.setProperty("selectable",e);return this};a.prototype.onclick=function(e){var t=e.target,s=this.getTree();if(jQuery(t).is(".sapUiTreeNode")||jQuery(t).is(".sapUiTreeNodeNotSelectable")){if(jQuery(t).is(".sapUiTreeNodeNotSelectable")){t=jQuery(t).closest(".sapUiTreeNode")[0]}if(jQuery(t).hasClass("sapUiTreeNodeExpanded")){this.collapse()}else{this.expand()}s.placeFocus(t);t.focus()}else if(jQuery(t).is(".sapUiTreeNodeContent")||jQuery(t).is(".sapUiTreeIcon")){var o=i.SelectionType.Select;if(s.getSelectionMode()==r.Multi){if(e.shiftKey){o=i.SelectionType.Range}if(e.metaKey||e.ctrlKey){o=i.SelectionType.Toggle}}s.setSelection(this,false,o);t=jQuery(t).closest(".sapUiTreeNode")[0];s.placeFocus(t);t.focus()}};a.prototype.onsapselect=function(e){if(this.getSelectable()){this.getTree().setSelection(this)}else if(this.getExpanded()){this.collapse()}else{this.expand()}};a.prototype.onsapexpand=function(e){this.expand()};a.prototype.onsapcollapse=function(e){this.collapse()};a.prototype.onsapleft=function(e){if(o.getRTL()){this.expand()}else{this.collapse()}e.preventDefault()};a.prototype.onsapright=function(e){if(o.getRTL()){this.collapse()}else{this.expand()}e.preventDefault()};a.prototype.focus=function(){var e=this.getFocusDomRef();if(e){e.setAttribute("tabindex","0");e.focus()}};a.prototype.blur=function(){var e=this.getFocusDomRef();if(e){e.setAttribute("tabindex","-1")}};a.prototype.getTree=function(){var e=this.getParent();while(e instanceof a){e=e.getParent()}return e};a.prototype.hasChildren=function(){var e=this._getNodes();if(e.length){return true}return false};a.prototype.isVisible=function(){var e=this.getParent();while(e instanceof a){if(!e.getExpanded()){return false}e=e.getParent()}return true};a.prototype.scrollIntoView=function(){var e=this.$(),t=this.getTree().$(),s=t.find(".sapUiTreeCont"),i=e[0].offsetTop,o=s.scrollTop(),r=s.height(),a,l=e[0].offsetLeft,n=s.scrollLeft(),p=s.width(),d;if(i>o+r||i<o){a=i-Math.floor(r*.5);a=Math.max(a,0)}if(l>n+p||l<n){d=l-Math.floor(p*.5);d=Math.max(d,0)}if(a!==undefined||d!==undefined){var u={};if(a!==undefined){u.scrollTop=a}if(d!==undefined){u.scrollLeft=d}s.stop(true,true).animate(u)}};a.prototype.getTooltip_AsString=function(){var e;var t=this.getTooltip();if(typeof t==="string"||t instanceof String){e=t}if(!e){e=this.getText()}return e};return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TreeRenderer", [],function(){"use strict";var e={};e.render=function(t,i){e.bFirstNodeRendered=false;t.write("<div");t.writeControlData(i);t.addClass("sapUiTree");if(i.getHeight()!=""&&i.getHeight()!="auto"){t.addClass("sapUiTreeFixedHeight")}if(!i.getShowHeader()){t.addClass("sapUiTreeTransparent")}t.writeClasses();t.addStyle("width",i.getWidth()||"auto");t.addStyle("height",i.getHeight());t.addStyle("min-width",i.getMinWidth());t.writeStyles();t.writeAttribute("role","tree");t.write(">");if(i.getShowHeader()){t.write('<div id="'+i.getId()+'-Header" class="sapUiTreeHeader"');t.writeAttribute("role","heading");t.write(">");t.write("<div class='sapUiTreeTitle'");if(i.getTooltip_AsString()){t.writeAttributeEscaped("title",i.getTooltip_AsString())}t.write(">");t.writeEscaped(i.getTitle());t.write("</div>");if(i.getShowHeaderIcons()){t.write("<div id='"+i.getId()+"-TBCont' class='sapUiTreeTbCont'");t.writeAttribute("role","toolbar");t.write(">");t.renderControl(i.oCollapseAllButton);t.renderControl(i.oExpandAllButton);t.write("</div>")}t.write("</div>")}t.write('<div id="'+i.getId()+'-TreeCont"');t.addClass("sapUiTreeCont");var r=i.getShowHorizontalScrollbar();if(r){t.addClass("sapUiTreeContScroll")}else{t.addClass("sapUiTreeContNoScroll")}t.writeClasses();t.write(">");t.write('<ul class="sapUiTreeList">');var d=i.getNodes();for(var a=0;a<d.length;a++){e.renderNode(t,d[a],1,d.length,a+1)}t.write("</ul>");t.write("</div>");t.write("</div>")};e.renderNode=function(t,i,r,d,a){var s;t.write("<li");t.writeElementData(i);t.addClass("sapUiTreeNode");if(i.getExpanded()&&(i.getHasExpander()||i.hasChildren())){t.addClass("sapUiTreeNodeExpanded");s=true}else if(!i.getExpanded()&&(i.getHasExpander()||i.hasChildren())){t.addClass("sapUiTreeNodeCollapsed");s=false}if(i.getSelectable()&&i.getIsSelected()){t.addClass("sapUiTreeNodeSelected");t.writeAttribute("aria-selected","true")}if(!s&&i.hasSelectedHiddenChild()){t.addClass("sapUiTreeNodeSelectedParent");t.writeAttribute("aria-selected","true")}t.writeClasses(i);var l={role:"treeitem",level:r,setsize:d,posinset:a};if(s){l["expanded"]=true}else{if(i.getHasExpander()){l["expanded"]=false}}t.writeAccessibilityState(i,l);t.writeAttributeEscaped("title",i.getTooltip_AsString());if(!e.bFirstNodeRendered){t.write("tabindex='0'");e.bFirstNodeRendered=true}t.write(">");t.write("<span");t.addClass("sapUiTreeNodeContent");if(!i.getSelectable()){t.addClass("sapUiTreeNodeNotSelectable")}t.writeClasses();t.write(">");if(i.getIcon()){t.writeIcon(i.getIcon(),"sapUiTreeIcon",{title:null})}t.writeEscaped(i.getText());t.write("</span>");t.write("</li>");if(i.getNodes()){var o=i.getNodes();t.write("<ul");t.writeAttribute("id",i.getId()+"-children");t.addClass("sapUiTreeChildrenNodes");if(!s){t.addClass("sapUiTreeHiddenChildrenNodes")}else{t.writeAttribute("style","display: block;")}t.writeClasses();t.write(">");r++;for(var n=0;n<o.length;n++){e.renderNode(t,o[n],r,o.length,n+1)}t.write("</ul>")}};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TriStateCheckBox", ["./library","sap/ui/core/Control","./TriStateCheckBoxRenderer","sap/ui/core/library","sap/ui/Device"],function(e,t,a,i,o){"use strict";var r=i.TextDirection;var s=i.ValueState;var n=e.TriStateCheckBoxState;var u=t.extend("sap.ui.commons.TriStateCheckBox",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{selectionState:{type:"sap.ui.commons.TriStateCheckBoxState",group:"Data",defaultValue:n.Unchecked},text:{type:"string",group:"Appearance",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:s.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:r.Inherit}},events:{change:{parameters:{selectionState:{type:"string"}}}}}});u.prototype.onclick=function(e){if(o.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",0).addClass("sapUiTriCbFoc")}this.userToggle(e)};u.prototype.onfocusout=function(e){if(o.browser.msie&&!this.getEnabled()){this.$().attr("tabindex",-1).removeClass("sapUiTriCbFoc")}};u.prototype.onsapspace=function(e){e.preventDefault();this.userToggle(e)};u.prototype.userToggle=function(e){if(this.getEnabled()&&this.getEditable()){if(this.getSelectionState()==="Mixed"||this.getSelectionState()==="Unchecked"){this.toggle("Checked")}else{this.toggle("Unchecked")}this.fireChange({selectionState:this.getSelectionState()})}else{this.getDomRef().focus()}};u.prototype.toggle=function(e){if(e in n){this.setSelectionState(e)}};return u});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/TriStateCheckBoxRenderer", ["sap/ui/core/ValueStateSupport","sap/ui/core/library"],function(e,i){"use strict";var t=i.TextDirection;var a=i.AccessibleRole;var r=i.ValueState;var s={};s.render=function(i,t){var s=0;var l=false;var d=!!t.getEnabled();var n=!!t.getEditable();var c=false;var o=false;var b=t.getSelectionState();var p=b.toLowerCase();if(p=="checked"){p=true}else if(p=="unchecked"){p=false}var w=e.enrichTooltip(t,t.getTooltip_AsString());var C="sapUiAriaLabel"+t.getIdForLabel();if(t.getValueState()!=null){c=r.Error==t.getValueState();o=r.Warning==t.getValueState()}i.write("<span");i.writeControlData(t);i.addClass("sapUiTriCb");if(t.getWidth()){i.writeAttribute("style","width:"+t.getWidth()+";")}i.writeAccessibilityState(t,{role:a.Checkbox.toLowerCase(),checked:p});i.writeClasses();if(!d){s=-1}i.writeAttribute("tabindex",s);i.write(">");i.write("<span");i.writeAccessibilityState(t,{labelledby:C});if(w){i.writeAttributeEscaped("title",w)}if(!d){l=true;s=-1;i.write(" disabled='disabled'")}if(!n){l=true}if(l){i.write(" readOnly='readOnly'")}i.addClass("sapUiTriCbInner");if(!d){i.addClass("sapUiTriCbDis")}if(!n){i.addClass("sapUiTriCbRo")}if(c){i.addClass("sapUiTriCbErr")}else if(o){i.addClass("sapUiTriCbWarn")}if(b==="Checked"){i.addClass("sapUiTriCbCheck")}else if(b==="Mixed"){i.addClass("sapUiTriCbMix")}i.writeClasses();i.write(">");i.write("</span>");if(t.getText()){this.renderText(C,i,t.getText(),t.getTextDirection())}i.write("</span>")};s.renderText=function(e,i,a,r){i.write("<span id="+e+' class="sapUiTriCbLbl"');if(!r||r==t.Inherit){i.write(">");i.writeEscaped(a)}else{i.write(' style="direction:'+r.toLowerCase()+';">');i.writeEscaped(a)}i.write("</span>")};return s},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ValueHelpField", ["./TextField","./ValueHelpFieldRenderer"],function(e,t){"use strict";var s=e.extend("sap.ui.commons.ValueHelpField",{metadata:{library:"sap.ui.commons",deprecated:true,properties:{iconURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconHoverURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},iconDisabledURL:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},events:{valueHelpRequest:{}}}});s.prototype.onBeforeRendering=function(){this.sIconDsblUrl="sap-icon://value-help";this.sIconRegularUrl="sap-icon://value-help";this.sIconHoverUrl="sap-icon://value-help"};s.prototype.onmouseover=function(e){if(e.target.id==this.getId()+"-icon"&&this.getEnabled()&&this.getEditable()&&!this.bIsIconURI){if(this.getIconHoverURL()){this.sIconHoverUrl=this.getIconHoverURL()}else if(this.getIconURL()){this.sIconHoverUrl=this.sIconRegularUrl}else{this.sIconHoverUrl="sap-icon://value-help"}e.target.setAttribute("src",this.sIconHoverUrl)}};s.prototype.onmouseout=function(e){if(e.target.id==this.getId()+"-icon"&&this.getEnabled()&&this.getEditable()&&!this.bIsIconURI){e.target.setAttribute("src",this.sIconRegularUrl)}};s.prototype.onclick=function(e){if(e.target.id==this.getId()+"-icon"&&this.getEnabled()&&this.getEditable()){this.fireValueHelpRequest({})}};s.prototype.setEnabled=function(t){var s=this.getEnabled();e.prototype.setEnabled.apply(this,arguments);if(this.getDomRef()&&s!=t&&!this.bIsIconURI){var i=this.$("icon");if(t){i.attr("src",this.sIconRegularUrl);i.removeClass("sapUiTfValueHelpDsblIcon");i.addClass("sapUiTfValueHelpRegularIcon")}else{i.attr("src",this.sIconRegularUrl);i.removeClass("sapUiTfValueHelpRegularIcon");i.addClass("sapUiTfValueHelpDsblIcon")}}return this};s.prototype.setEditable=function(t){var s=this.getEditable();e.prototype.setEditable.apply(this,arguments);if(this.getDomRef()&&s!=t&&!this.bIsIconURI){var i=this.$("icon");if(t){i.removeClass("sapUiTfValueHelpDsblIcon");i.addClass("sapUiTfValueHelpRegularIcon")}else{i.removeClass("sapUiTfValueHelpRegularIcon");i.addClass("sapUiTfValueHelpDsblIcon")}}return this};s.prototype.onsapshow=function(e){this._checkChange(e);this.fireValueHelpRequest({});e.preventDefault();e.stopPropagation()};s.prototype.getTooltip_AsString=function(){var t=e.prototype.getTooltip_AsString.apply(this,arguments);if(this.getEnabled()&&this.getEditable()){var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");var i=s.getText("VHF_TOOLTIP");return(t?t+" - ":"")+i}else{return t}};s.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate()}};s.prototype.exit=function(){this.sIconRegularUrl=undefined;this.sIconHoverUrl=undefined;this.sIconDsblUrl=undefined};return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/ValueHelpFieldRenderer", ["./TextFieldRenderer","sap/ui/core/Renderer","sap/ui/core/IconPool"],function(e,n,t){"use strict";var r=n.extend(e);r.renderOuterAttributes=function(e,n){e.addClass("sapUiTfCombo");e.writeAttribute("aria-owns",n.getId()+"-input "+n.getId()+"-icon")};r.renderOuterContent=function(e,n){var r=n.getIconURL();var o=[];var i={};i["id"]=n.getId()+"-icon";i["role"]="button";o.push("sapUiTfValueHelpIcon");if(r&&t.isIconURI(r)){n.bIsIconURI=true;i.title=n.getTooltip_AsString()}else{n.bIsIconURI=false;if(n.getEnabled()&&n.getEditable()){o.push("sapUiTfValueHelpRegularIcon")}r=this.renderIcon(e,n,o)}e.writeIcon(r,o,i)};r.renderIcon=function(e,n,t){var r="";if(!n.getEnabled()){if(n.getIconDisabledURL()){n.sIconDsblUrl=n.getIconDisabledURL()}else if(n.getIconURL()){n.sIconDsblUrl=n.getIconURL();t.push("sapUiTfValueHelpDsblIcon")}r=n.sIconDsblUrl}else{if(n.getIconURL()){n.sIconRegularUrl=n.getIconURL()}r=n.sIconRegularUrl}return r};return r},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/Form", ["sap/ui/commons/library","sap/ui/layout/form/Form","./FormRenderer"],function(r,e,a){"use strict";var o=e.extend("sap.ui.commons.form.Form",{metadata:{deprecated:true,library:"sap.ui.commons"}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/FormContainer", ["sap/ui/commons/library","sap/ui/layout/form/FormContainer"],function(r,a){"use strict";var o=a.extend("sap.ui.commons.form.FormContainer",{metadata:{deprecated:true,library:"sap.ui.commons"}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/FormElement", ["sap/ui/commons/library","sap/ui/layout/form/FormElement"],function(e,r){"use strict";var a=r.extend("sap.ui.commons.form.FormElement",{metadata:{deprecated:true,library:"sap.ui.commons"}});return a});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/FormLayout", ["sap/ui/commons/library","sap/ui/layout/form/FormLayout","./FormLayoutRenderer"],function(r,a,o){"use strict";var e=a.extend("sap.ui.commons.form.FormLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return e});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/FormLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/form/FormLayoutRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/FormRenderer", ["sap/ui/core/Renderer","sap/ui/layout/form/FormRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/GridContainerData", ["sap/ui/commons/library","sap/ui/layout/form/GridContainerData"],function(a,r){"use strict";var i=r.extend("sap.ui.commons.form.GridContainerData",{metadata:{deprecated:true,library:"sap.ui.commons"}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/GridElementData", ["sap/ui/commons/library","sap/ui/layout/form/GridElementData"],function(a,e){"use strict";var r=e.extend("sap.ui.commons.form.GridElementData",{metadata:{deprecated:true,library:"sap.ui.commons"}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/GridLayout", ["sap/ui/commons/library","sap/ui/layout/form/GridLayout","./GridLayoutRenderer"],function(r,a,e){"use strict";var i=a.extend("sap.ui.commons.form.GridLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/GridLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/form/GridLayoutRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/ResponsiveLayout", ["sap/ui/commons/library","sap/ui/layout/form/ResponsiveLayout","./ResponsiveLayoutRenderer"],function(e,a,o){"use strict";var s=a.extend("sap.ui.commons.form.ResponsiveLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/ResponsiveLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/form/ResponsiveLayoutRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/SimpleForm", ["sap/ui/commons/library","sap/ui/layout/library","sap/ui/layout/form/SimpleForm","./SimpleFormRenderer"],function(r,e,o,a){"use strict";var i=e.form.SimpleFormLayout;var m=o.extend("sap.ui.commons.form.SimpleForm",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:i.ResponsiveLayout}}}});return m});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/form/SimpleFormRenderer", ["sap/ui/core/Renderer","sap/ui/layout/form/SimpleFormRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/AbsoluteLayout", ["sap/ui/thirdparty/jquery","./PositionContainer","sap/ui/commons/library","sap/ui/core/Control","./AbsoluteLayoutRenderer","sap/ui/core/library"],function(jQuery,t,e,o,i,n){"use strict";var r=n.Scrolling;var s=o.extend("sap.ui.commons.layout.AbsoluteLayout",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},verticalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:r.Hidden},horizontalScrolling:{type:"sap.ui.core.Scrolling",group:"Behavior",defaultValue:r.Hidden}},defaultAggregation:"positions",aggregations:{positions:{type:"sap.ui.commons.layout.PositionContainer",multiple:true,singularName:"position"}}}});s.prototype.setWidth=function(t){return p(this,"width",t,"LYT_SIZE")};s.prototype.setHeight=function(t){return p(this,"height",t,"LYT_SIZE")};s.prototype.setVerticalScrolling=function(t){return p(this,"verticalScrolling",t,"LYT_SCROLL")};s.prototype.setHorizontalScrolling=function(t){return p(this,"horizontalScrolling",t,"LYT_SCROLL")};s.prototype.insertPosition=function(t,e){var o=!!this.getDomRef();this.insertAggregation("positions",t,e,o);if(o&&t&&t.getControl()){this.contentChanged(t,"CTRL_ADD")}return this};s.prototype.addPosition=function(t){var e=!!this.getDomRef();this.addAggregation("positions",t,e);if(e&&t&&t.getControl()){this.contentChanged(t,"CTRL_ADD")}return this};s.prototype.removePosition=function(t){var e=!!this.getDomRef();var o=this.removeAggregation("positions",t,e);if(o){u([o]);this.contentChanged(o,"CTRL_REMOVE")}return o};s.prototype.removeAllPositions=function(){u(this.getPositions());var t=!!this.getDomRef();var e=this.removeAllAggregation("positions",t);if(t){this.contentChanged(e,"CTRL_REMOVE_ALL")}return e};s.prototype.destroyPositions=function(){u(this.getPositions());var t=!!this.getDomRef();this.destroyAggregation("positions",t);if(t){this.contentChanged(null,"CTRL_REMOVE_ALL")}return this};s.prototype.getContent=function(){var t=[];var e=this.getPositions();for(var o=0;o<e.length;o++){t.push(e[o].getControl())}return t};s.prototype.addContent=function(e,o){var i=t.createPosition(e,o);this.addPosition(i);return this};s.prototype.insertContent=function(e,o,i){var n=t.createPosition(e,i);this.insertPosition(n,o);return this};s.prototype.removeContent=function(t){var e=t;if(typeof t=="string"){t=sap.ui.getCore().byId(t)}if(typeof t=="object"){e=this.indexOfContent(t)}if(e>=0&&e<this.getContent().length){this.removePosition(e);return t}return null};s.prototype.removeAllContent=function(){var t=this.getContent();this.removeAllPositions();return t};s.prototype.indexOfContent=function(t){var e=this.getContent();for(var o=0;o<e.length;o++){if(t===e[o]){return o}}return-1};s.prototype.destroyContent=function(){this.destroyPositions();return this};s.prototype.setPositionOfChild=function(t,e){var o=this.indexOfContent(t);if(o>=0){var i=this.getPositions()[o];i.updatePosition(e);return true}return false};s.prototype.getPositionOfChild=function(t){var e=this.indexOfContent(t);if(e>=0){var o=this.getPositions()[e];return o.getComputedPosition()}return{}};s.prototype.exit=function(){u(this.getPositions())};s.prototype.doBeforeRendering=function(){var t=this.getPositions();if(!t||t.length==0){return}for(var e=0;e<t.length;e++){var o=t[e];o.reinitializeEventHandlers(true);l(o,true)}};s.prototype.onAfterRendering=function(){var t=this.getPositions();if(!t||t.length==0){return}for(var e=0;e<t.length;e++){t[e].reinitializeEventHandlers()}};s.cleanUpControl=function(t){if(t&&t[a]){t.removeDelegate(t[a]);t[a]=undefined}};s.prototype.contentChanged=function(t,e){switch(e){case"CTRL_POS":i.updatePositionStyles(t);l(t);t.reinitializeEventHandlers();break;case"CTRL_CHANGE":l(t,true);i.updatePositionedControl(t);t.reinitializeEventHandlers();break;case"CTRL_REMOVE":i.removePosition(t);t.reinitializeEventHandlers(true);break;case"CTRL_REMOVE_ALL":i.removeAllPositions(this);var o=t;if(o){for(var n=0;n<o.length;n++){o[n].reinitializeEventHandlers(true)}}break;case"CTRL_ADD":l(t,true);i.insertPosition(this,t);t.reinitializeEventHandlers();break;case"LYT_SCROLL":i.updateLayoutScolling(this);break;case"LYT_SIZE":i.updateLayoutSize(this);break}};var a="__absolutelayout__delegator";var u=function(t){for(var e=0;e<t.length;e++){var o=t[e];var i=o.getControl();if(i){s.cleanUpControl(i)}}};var l=function(t,e){var o=t.getControl();if(o){s.cleanUpControl(o);if(!e){g(o)}var i=function(t){return{onAfterRendering:function(){g(t)}}}(o);o[a]=i;o.addDelegate(i,true)}};var g=function(t){var e=false;if(t.getParent()&&t.getParent().getComputedPosition){var o=t.getParent().getComputedPosition();if(o.top&&o.bottom||o.height){jQuery(t.getDomRef()).css("height","100%");e=true}if(o.left&&o.right||o.width){jQuery(t.getDomRef()).css("width","100%");e=true}if(e){i.updatePositionStyles(t.getParent())}}return e};var p=function(t,e,o,i){var n=!!t.getDomRef();t.setProperty(e,o,n);if(n){t.contentChanged(null,i)}return t};t.cleanUpControl=s.cleanUpControl;return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/AbsoluteLayoutRenderer", ["sap/ui/core/library"],function(t){"use strict";var i=t.Scrolling;var e={};e.render=function(t,i){i.doBeforeRendering();t.write("<div");t.writeControlData(i);t.addClass("sapUiLayoutAbs");t.addClass("sapUiLayoutAbsOvrflwY"+i.getVerticalScrolling());t.addClass("sapUiLayoutAbsOvrflwX"+i.getHorizontalScrolling());t.writeClasses();var e="width:"+i.getWidth()+";height:"+i.getHeight()+";";t.writeAttribute("style",e);var o=i.getTooltip_AsString();if(o){t.writeAttributeEscaped("title",o)}t.write(">");var a=i.getPositions();if(a&&a.length>0){for(var s=0;s<a.length;s++){var n=a[s];var l=n.getControl();if(l){t.write("<div");t.writeElementData(n);t.writeAttribute("class","sapUiLayoutAbsPos");t.writeAttribute("style",r(n));o=n.getTooltip_AsString();if(o){t.writeAttributeEscaped("title",o)}t.write(">");t.renderControl(l);t.write("</div>")}}}t.write("</div>")};e.updateLayoutSize=function(t){t.$().css("width",t.getWidth()).css("height",t.getHeight())};e.updateLayoutScolling=function(t){var e=t.$();for(var r in i){e.removeClass("sapUiLayoutAbsOvrflwY"+r).removeClass("sapUiLayoutAbsOvrflwX"+r)}e.addClass("sapUiLayoutAbsOvrflwY"+t.getVerticalScrolling()).addClass("sapUiLayoutAbsOvrflwX"+t.getHorizontalScrolling())};e.updatePositionStyles=function(t){t.$().attr("style",r(t))};e.removePosition=function(t){t.$().remove()};e.removeAllPositions=function(t){t.$().html("")};e.updatePositionedControl=function(t){e.updatePositionStyles(t);var i=sap.ui.getCore().createRenderManager();i.renderControl(t.getControl());i.flush(t.getDomRef());i.destroy()};e.insertPosition=function(t,i){var r=t.indexOfPosition(i);var o=t.getPositions();var a=null;while(r>0){r--;if(o[r].getDomRef()){a=o[r];break}}var s='<div id="'+i.getId()+'" data-sap-ui="'+i.getId()+'" class="sapUiLayoutAbsPos"></div>';if(!a){t.$().prepend(s)}else{a.$().after(s)}e.updatePositionedControl(i)};var r=function(t){var i=t.getComputedPosition();var e=function(t,i,e,r){if(r){i.push(e+":"+r+";")}};var r=[];e(t,r,"top",i.top);e(t,r,"bottom",i.bottom);e(t,r,"left",i.left);e(t,r,"right",i.right);e(t,r,"width",i.width);e(t,r,"height",i.height);return r.join("")};return e},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/BorderLayout", ["sap/base/assert","sap/ui/commons/library","sap/ui/core/Control","./BorderLayoutRenderer","./BorderLayoutArea"],function(e,t,r,o,a){"use strict";var n=t.layout.BorderLayoutAreaTypes;var i=r.extend("sap.ui.commons.layout.BorderLayout",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{rtl:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"}},aggregations:{top:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},begin:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},center:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},end:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false},bottom:{type:"sap.ui.commons.layout.BorderLayoutArea",multiple:false}}}});i.prototype._getOrCreateArea=function(t,r){var o=n,i=this,s;function u(e){var o;if(r){o=new a({id:i.getId()+"--"+t,areaId:t,content:r});i[e](o)}return o}if(!o.hasOwnProperty(t)){throw new Error("Invalid Area Id '"+t+"'")}switch(t){case o.top:s=this.getTop()||u("setTop");break;case o.begin:s=this.getBegin()||u("setBegin");break;case o.center:s=this.getCenter()||u("setCenter");break;case o.end:s=this.getEnd()||u("setEnd");break;case o.bottom:s=this.getBottom()||u("setBottom");break;default:e(false,"default case must not be reached");break}return s};i.prototype.getArea=function(e,t){return this._getOrCreateArea(e,t?[]:null)};i.prototype.createArea=function(e,t){return this._getOrCreateArea(e,Array.prototype.slice.call(arguments,1))};i.prototype.getAreaById=function(e){return this._getOrCreateArea(e,[])};i.prototype.getAreaData=function(e){var t=this.getAreaById(e);return t?{size:t.getSize(),visible:t.getVisible(),overflowX:t.getOverflowX(),overflowY:t.getOverflowY(),contentAlign:t.getContentAlign()}:{}};i.prototype.setAreaData=function(e,t){this.getArea(e,true).applySettings(t);return this};i.prototype.addContent=function(e){var t=this.getArea(e,true),r;for(var r=1;r<arguments.length;r++){t.addContent(arguments[r])}return this};i.prototype.insertContent=function(e,t){var r=this.getArea(e,true),o;for(o=2;o<arguments.length;o++){r.insertContent(arguments[o],t++)}return this};i.prototype.removeContent=function(e,t){var r=this.getAreaById(e);if(r){r.removeContent(t)}return this};i.prototype.removeAllContent=function(e){var t=this.getAreaById(e);if(t){t.removeAllContent()}return this};i.prototype.getContent=function(e){var t=this.getAreaById(e);return t?t.getContent():[]};i.prototype.indexOfContent=function(e,t){var r=this.getAreaById(e);return r?r.indexOfContent(t):-1};i.prototype.destroyContent=function(e){this.getAreaById(e,true).destroyContent();return this};return i});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/BorderLayoutArea", ["sap/ui/commons/library","sap/ui/core/CustomStyleClassSupport","sap/ui/core/Element"],function(e,t,r){"use strict";var a=e.layout.BorderLayoutAreaTypes;var o=r.extend("sap.ui.commons.layout.BorderLayoutArea",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{areaId:{type:"sap.ui.commons.layout.BorderLayoutAreaTypes",group:"Identification",defaultValue:a.top,deprecated:true},overflowX:{type:"string",group:"Misc",defaultValue:"auto"},overflowY:{type:"string",group:"Misc",defaultValue:"auto"},contentAlign:{type:"string",group:"Misc",defaultValue:"left"},size:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:"100px"},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});t.apply(o.prototype);o.prototype.getAreaId=function(){var e=this.getParent();return e&&e instanceof sap.ui.commons.layout.BorderLayout?this.sParentAggregationName:undefined};o.prototype.setVisible=function(e,t){var r=this.getAreaId();if(r==="center"||!t){this.setProperty("visible",e);return this}this.setProperty("visible",e,true);this.getParent().getMetadata().getRenderer().animate(this,e);return this};return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/BorderLayoutRenderer", ["sap/ui/thirdparty/jquery","sap/base/assert","sap/base/security/encodeXML","sap/ui/core/Configuration"],function(jQuery,t,e,a){"use strict";var i={};i.render=function(t,e){var i={top:e.getTop(),begin:e.getBegin(),center:e.getCenter(),end:e.getEnd(),bottom:e.getBottom()};var n={top:o(i.top),begin:o(i.begin),center:o(i.center),end:o(i.end),bottom:o(i.bottom)};var d=a.getRTL();t.write("<div");t.writeControlData(e);t.addClass("sapUiBorderLayout");t.addStyle("width",e.getWidth());t.addStyle("height",e.getHeight());t.writeClasses();t.writeStyles();t.write(">");if(i.top){r(t,"top",i.top,n,d)}if(i.begin){r(t,"begin",i.begin,n,d)}if(i.center&&i.center.getVisible()){r(t,"center",i.center,n,d)}if(i.end){r(t,"end",i.end,n,d)}if(i.bottom){r(t,"bottom",i.bottom,n,d)}t.write("</div>")};i.animate=function(t,e){var i=a.getRTL();var o=e?t.getSize():"0";switch(t.getAreaId()){case"top":n(t,"top").animate({height:o});n(t,"begin").animate({top:o});n(t,"center").animate({top:o});n(t,"end").animate({top:o});break;case"begin":n(t,"begin").animate({width:o});n(t,"center").animate(i?{right:o}:{left:o});break;case"end":n(t,"center").animate(i?{left:o}:{right:o});n(t,"end").animate({width:o});break;case"bottom":n(t,"begin").animate({bottom:o});n(t,"center").animate({bottom:o});n(t,"end").animate({bottom:o});n(t,"bottom").animate({height:o});break;default:break}};function o(t){var e=t&&t.getVisible()&&t.getSize();return e||"0"}function r(a,i,o,r,n){var d=o.getContent();var s=d.length;a.write("<div");a.writeAttribute("id",o.getId());switch(i){case"top":a.addClass("sapUiBorderLayoutTop");a.addStyle("height",r.top);break;case"begin":a.addClass("sapUiBorderLayoutBegin");a.addStyle("width",r.begin);a.addStyle("top",r.top);a.addStyle("bottom",r.bottom);break;case"center":a.addClass("sapUiBorderLayoutCenter");a.addStyle("top",r.top);a.addStyle("right",n?r.begin:r.end);a.addStyle("bottom",r.bottom);a.addStyle("left",n?r.end:r.begin);break;case"end":a.addClass("sapUiBorderLayoutEnd");a.addStyle("width",r.end);a.addStyle("top",r.top);a.addStyle("bottom",r.bottom);break;case"bottom":a.addClass("sapUiBorderLayoutBottom");a.addStyle("height",r.bottom);break;default:t("default branch must not be reached");break}a.addStyle("overflow-x",e(o.getOverflowX()||""));a.addStyle("overflow-y",e(o.getOverflowY()||""));var g=o.getContentAlign();if(n){if(g==="right"){g="left"}else if(g==="left"){g="right"}}a.addStyle("text-align",e(g||""));a.writeClasses(o);a.writeStyles();a.write(">");for(var b=0;b<s;b++){a.renderControl(d[b])}a.write("</div>")}function n(t,e){var a=t.getParent().getArea(e);return a?a.$():jQuery()}return i},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/HorizontalLayout", ["sap/ui/commons/library","sap/ui/layout/HorizontalLayout","./HorizontalLayoutRenderer"],function(a,o,t){"use strict";var r=o.extend("sap.ui.commons.layout.HorizontalLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/HorizontalLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/HorizontalLayoutRenderer"],function(e,r){"use strict";var t=e.extend(r);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/MatrixLayout", ["sap/ui/thirdparty/jquery","./MatrixLayoutCell","./MatrixLayoutRow","sap/ui/commons/library","sap/ui/core/Control","sap/ui/core/EnabledPropagator","./MatrixLayoutRenderer","sap/ui/commons/TextView"],function(jQuery,e,t,a,r,o,i,u){"use strict";var n=r.extend("sap.ui.commons.layout.MatrixLayout",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},layoutFixed:{type:"boolean",group:"Appearance",defaultValue:true},columns:{type:"int",group:"Appearance",defaultValue:null},widths:{type:"sap.ui.core.CSSSize[]",group:"Appearance",defaultValue:null}},defaultAggregation:"rows",aggregations:{rows:{type:"sap.ui.commons.layout.MatrixLayoutRow",multiple:true,singularName:"row"}}}});o.call(n.prototype,true,true);n.prototype.createRow=function(){var a=new t;this.addRow(a);for(var o=0;o<arguments.length;o++){var i=arguments[o];var n;if(i instanceof e){n=i}else if(i instanceof r){n=new e({content:i})}else if(i instanceof Object&&i.height){a.setHeight(i.height)}else{var s=i?i.toString():"";n=new e({content:new u({text:s})})}a.addCell(n)}return this};n.prototype.setWidths=function(e){var t;if(!Array.isArray(e)){t=jQuery.makeArray(arguments)}else{t=e}for(var a=0;a<t.length;a++){if(t[a]==""||!t[a]){t[a]="auto"}}this.setProperty("widths",t);return this};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/MatrixLayoutCell", ["sap/ui/commons/library","sap/ui/core/CustomStyleClassSupport","sap/ui/core/Element"],function(a,e,t){"use strict";var o=t.extend("sap.ui.commons.layout.MatrixLayoutCell",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{backgroundDesign:{type:"sap.ui.commons.layout.BackgroundDesign",defaultValue:"Transparent"},colSpan:{type:"int",defaultValue:1},hAlign:{type:"sap.ui.commons.layout.HAlign",defaultValue:"Begin"},padding:{type:"sap.ui.commons.layout.Padding",defaultValue:"End"},rowSpan:{type:"int",defaultValue:1},separation:{type:"sap.ui.commons.layout.Separation",defaultValue:"None"},vAlign:{type:"sap.ui.commons.layout.VAlign",defaultValue:"Middle"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});e.apply(o.prototype);return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/MatrixLayoutRenderer", ["sap/base/assert","sap/ui/commons/library","sap/ui/core/Configuration"],function(e,t,a){"use strict";var i=t.layout.Separation;var l=t.layout.Padding;var r=t.layout.BackgroundDesign;var n=t.layout.VAlign;var s=t.layout.HAlign;var d={};d.render=function(e,t){var i=a.getRTL();var l=0;var r=0;var n=0;var s=0;var g;var o;var u;var f;var p;var c;var h;e.write('<table role="presentation"');e.writeControlData(t);e.write(' cellpadding="0" cellspacing="0"');e.addStyle("border-collapse","collapse");var w=t.getWidth();if(w){e.addStyle("width",w)}var S=t.getHeight();if(S&&S!="auto"){e.addStyle("height",S);f=d.getValueUnit(S)}if(t.getLayoutFixed()){e.addStyle("table-layout","fixed");if(!w){e.addStyle("width","100%")}}e.addClass("sapUiMlt");e.writeStyles();e.writeClasses();if(t.getTooltip_AsString()){e.writeAttributeEscaped("title",t.getTooltip_AsString())}e.write(">");var v=t.getRows();var y=t.getColumns();if(y<1){for(l=0;l<v.length;l++){g=v[l];o=g.getCells();if(y<o.length){y=o.length}}}if(y>0){var C=t.getWidths();e.write("<colgroup>");for(r=0;r<y;r++){e.write("<col");if(C&&C[r]&&C[r]!="auto"){e.addStyle("width",C[r]);e.writeStyles()}e.write(">")}e.write("</colgroup>")}e.write('<tbody style="width: 100%; height: 100%">');for(l=0;l<v.length;l++){g=v[l];var U=g.getHeight();if(U=="auto"){U=""}if(U&&f){p=d.getValueUnit(U);if(p.Unit=="%"&&f.Unit!="%"){U=f.Value*p.Value/100+f.Unit}}e.write("<tr");e.writeElementData(g);e.writeClasses(g);if(g.getTooltip_AsString()){e.writeAttributeEscaped("title",g.getTooltip_AsString())}e.write(">");o=g.getCells();var M=y;if(y<1){M=o.length}var m=0;if(!g.RowSpanCells){g.RowSpanCells=0}for(r=0;r<M;r++){if(r>=M-m-g.RowSpanCells){break}var R=o[r];e.write("<td");if(U&&(!R||R.getRowSpan()==1)){e.addStyle("height",U)}if(R){e.writeElementData(R);if(R.getTooltip_AsString()){e.writeAttributeEscaped("title",R.getTooltip_AsString())}if(t.getLayoutFixed()&&R.getContent().length>0){e.addStyle("overflow","hidden")}var V=d.getHAlignClass(R.getHAlign(),i);if(V){e.addClass(V)}h=d.getVAlign(R.getVAlign());if(h){e.addStyle("vertical-align",h)}if(R.getColSpan()>1){e.writeAttribute("colspan",R.getColSpan());m=m+R.getColSpan()-1}if(R.getRowSpan()>1){e.writeAttribute("rowspan",R.getRowSpan());var L=0;var b="";for(var A=0;A<R.getRowSpan();A++){var F=v[l+A];if(!F){b=false;break}if(!F.RowSpanCells){F.RowSpanCells=0}if(A>0){F.RowSpanCells=F.RowSpanCells+R.getColSpan()}var x=F.getHeight();if(!x||x=="auto"){b=false}else{var B=d.getValueUnit(x);if(B.Unit=="%"&&f.Unit!="%"){B.Value=f.Value*p.Value/100;B.Unit=f.Unit}if(b==""){b=B.Unit}else if(b!=B.Unit){b=false}L=L+B.Value}}if(b!=false){c=L+b;e.addStyle("height",c)}}e.addClass(d.getBackgroundClass(R.getBackgroundDesign()));e.addClass(d.getSeparationClass(R.getSeparation()));if(!t.getLayoutFixed()||!U){e.addClass(d.getPaddingClass(R.getPadding()));e.addClass("sapUiMltCell")}else{e.addStyle("white-space","nowrap")}e.writeClasses(R)}e.writeStyles();e.write(">");if(R){if(t.getLayoutFixed()&&U){e.write("<div");if(R.getRowSpan()!=1&&c&&c.search("%")==-1){e.addStyle("height",c)}else if(U.search("%")!=-1||R.getRowSpan()!=1&&!c){e.addStyle("height","100%")}else{e.addStyle("height",U)}e.addStyle("display","inline-block");if(h){e.addStyle("vertical-align",h)}e.writeStyles();e.writeClasses(false);e.write("></div>");e.write("<div");e.addStyle("display","inline-block");if(h){e.addStyle("vertical-align",h)}if(R.getRowSpan()!=1&&c&&c.search("%")==-1){e.addStyle("max-height",c)}else if(U.search("%")!=-1||R.getRowSpan()!=1&&!c){e.addStyle("max-height","100%")}else{e.addStyle("max-height",U)}var k="0";var H="";var P="0";u=R.getContent();for(n=0,s=u.length;n<s;n++){if(u[n].getHeight&&u[n].getHeight()!=""){var T=d.getValueUnit(u[n].getHeight());if(T){if(H==""){H=T.Unit}if(H!=T.Unit){H="%";k="100";break}if(T.Unit=="%"){if(parseFloat(k)<parseFloat(T.Value)){k=T.Value;if(k!="100"){P=1e4/parseFloat(k)}}}}}}if(k!="0"){e.addStyle("height",k+H)}e.addStyle("white-space","normal");e.addStyle("width","100%");e.writeStyles();e.writeClasses(false);e.write("><div");e.addStyle("overflow","hidden");e.addStyle("text-overflow","inherit");if(k!="0"){if(P!="0"){e.addStyle("height",P+"%")}else{e.addStyle("height","100%")}}e.addClass("sapUiMltCell");e.addClass(d.getPaddingClass(R.getPadding()));e.writeStyles();e.writeClasses(false);e.write(">")}u=R.getContent();for(n=0,s=u.length;n<s;n++){e.renderControl(u[n])}if(t.getLayoutFixed()&&U){e.write("</div></div>")}}e.write("</td>")}e.write("</tr>");g.RowSpanCells=undefined}e.write("</tbody></table>")};d.getHAlignClass=function(t,a){var i="sapUiMltCellHAlign";switch(t){case s.Begin:return null;case s.Center:return i+"Center";case s.End:return i+(a?"Left":"Right");case s.Left:return a?i+"Left":null;case s.Right:return a?null:i+"Right";default:e(false,"MatrixLayoutRenderer.getHAlign: oHAlign must be a known value");return null}};d.getVAlign=function(t){switch(t){case n.Bottom:return"bottom";case n.Middle:return"middle";case n.Top:return"top";default:e(false,"MatrixLayoutRenderer.getVAlign: oVAlign must be a known value");return null}};d.getBackgroundClass=function(t){switch(t){case r.Border:return"sapUiMltBgBorder";case r.Fill1:return"sapUiMltBgFill1";case r.Fill2:return"sapUiMltBgFill2";case r.Fill3:return"sapUiMltBgFill3";case r.Header:return"sapUiMltBgHeader";case r.Plain:return"sapUiMltBgPlain";case r.Transparent:return null;default:e(false,"MatrixLayoutRenderer.getBackgroundClass: oBackgroundDesign must be a known value");return null}};d.getPaddingClass=function(t){switch(t){case l.None:return"sapUiMltPadNone";case l.Begin:return"sapUiMltPadLeft";case l.End:return"sapUiMltPadRight";case l.Both:return"sapUiMltPadBoth";case l.Neither:return"sapUiMltPadNeither";default:e(false,"MatrixLayoutRenderer.getPaddingClass: oPadding must be a known value");return null}};d.getSeparationClass=function(t){switch(t){case i.None:return null;case i.Small:return"sapUiMltSepS";case i.SmallWithLine:return"sapUiMltSepSWL";case i.Medium:return"sapUiMltSepM";case i.MediumWithLine:return"sapUiMltSepMWL";case i.Large:return"sapUiMltSepL";case i.LargeWithLine:return"sapUiMltSepLWL";default:e(false,"MatrixLayoutRenderer.getSeparationClass: oSeparation must be a known value");return null}};d.getValueUnit=function(e){var t=0;var a="";var i=e.search("px");if(i>-1){a="px";t=parseInt(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("pt");if(i>-1){a="pt";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("in");if(i>-1){a="in";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("mm");if(i>-1){a="mm";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("cm");if(i>-1){a="cm";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("em");if(i>-1){a="em";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("ex");if(i>-1){a="ex";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}i=e.search("%");if(i>-1){a="%";t=parseFloat(e.slice(0,i));return{Value:t,Unit:a}}};return d},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/MatrixLayoutRow", ["sap/ui/commons/library","sap/ui/core/CustomStyleClassSupport","sap/ui/core/Element"],function(e,a,t){"use strict";var o=t.extend("sap.ui.commons.layout.MatrixLayoutRow",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null}},defaultAggregation:"cells",aggregations:{cells:{type:"sap.ui.commons.layout.MatrixLayoutCell",multiple:true,singularName:"cell"}}}});a.apply(o.prototype);return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/PositionContainer", ["sap/base/Log","sap/ui/commons/library","sap/ui/core/Element","sap/ui/core/ResizeHandler"],function(t,e,i,r){"use strict";var n=i.extend("sap.ui.commons.layout.PositionContainer",{metadata:{deprecated:true,library:"sap.ui.commons",properties:{top:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},bottom:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},left:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},right:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},centerHorizontally:{type:"boolean",group:"Dimension",defaultValue:false},centerVertically:{type:"boolean",group:"Dimension",defaultValue:false}},defaultAggregation:"control",aggregations:{control:{type:"sap.ui.core.Control",multiple:false}}}});n.prototype.setControl=function(t){s(this);if(this.getDomRef()){this.setAggregation("control",t,true);l(this,t?"CTRL_CHANGE":"CTRL_REMOVE")}else{if(this.getParent()&&this.getParent().getDomRef()){this.setAggregation("control",t,true);if(t){l(this,"CTRL_ADD")}}else{this.setAggregation("control",t)}}if(t){t.attachEvent("_change",f,this)}return this};n.prototype.destroyControl=function(){s(this);var t=!!this.getDomRef();this.destroyAggregation("control",t);if(t){l(this,"CTRL_REMOVE")}return this};n.prototype.setTop=function(t){o(this,"top",t,true);return this};n.prototype.setBottom=function(t){o(this,"bottom",t,true);return this};n.prototype.setLeft=function(t){o(this,"left",t,true);return this};n.prototype.setRight=function(t){o(this,"right",t,true);return this};n.prototype.setCenterHorizontally=function(t){o(this,"centerHorizontally",t,true);return this};n.prototype.setCenterVertically=function(t){o(this,"centerVertically",t,true);return this};n.prototype.updatePosition=function(t){if(!t){t={}}o(this,"centerHorizontally",t.centerHorizontally?t.centerHorizontally:null);o(this,"centerVertically",t.centerVertically?t.centerVertically:null);o(this,"left",t.left?t.left:null);o(this,"right",t.right?t.right:null);o(this,"top",t.top?t.top:null);var e=o(this,"bottom",t.bottom?t.bottom:null);if(e){l(this,"CTRL_POS")}};n.prototype.getComputedPosition=function(){var t=this.getTop();var e=this.getBottom();var i=this.getLeft();var r=this.getRight();var n=null;var o=null;var l=this.getControl();if(l){if(this.getCenterHorizontally()){i="50%";r=null}else{if(!a(this,l,"width","left",i,"right",r)){r=undefined}if(!i&&!r){i="0px"}}if(this.getCenterVertically()){t="50%";e=null}else{if(!a(this,l,"height","top",t,"bottom",e)){e=undefined}if(!t&&!e){t="0px"}}n=h(l,"width");o=h(l,"height")}return{top:t,bottom:e,left:i,right:r,width:n,height:o}};n.createPosition=function(t,e){var i=new n;i.setControl(t);if(e){if(e.left){i.setLeft(e.left)}if(e.right){i.setRight(e.right)}if(e.top){i.setTop(e.top)}if(e.bottom){i.setBottom(e.bottom)}if(e.centerHorizontally){i.setCenterHorizontally(e.centerHorizontally)}if(e.centerVertically){i.setCenterVertically(e.centerVertically)}}return i};n.cleanUpControl=function(t){};n.prototype.reinitializeEventHandlers=function(t){if(this._sResizeListenerId){r.deregister(this._sResizeListenerId);this._sResizeListenerId=null}if(!t&&this.getDomRef()&&(this.getCenterHorizontally()||this.getCenterVertically())){var e=this;var i=function(){var t=e.$();if(e.getCenterHorizontally()){t.css("margin-left","-"+t.children().outerWidth()/2+"px")}if(e.getCenterVertically()){t.css("margin-top","-"+t.children().outerHeight()/2+"px")}};this._sResizeListenerId=r.register(this.getDomRef(),i);i()}};n.prototype.exit=function(t){this.reinitializeEventHandlers(true)};n.prototype.init=function(){this._disableWidthCheck=true;this._disableHeightCheck=false};var o=function(t,e,i,r){var n=!!t.getDomRef();t.setProperty(e,i,n);if(n&&r){l(t,"CTRL_POS")}return n};var l=function(t,e){var i=t.getParent();if(i){i.contentChanged(t,e)}};var s=function(t){var e=t.getControl();if(e){n.cleanUpControl(e);e.detachEvent("_change",f,t)}};var a=function(e,i,r,n,o,l,s){if(o&&s){var a=e.getParent();var h=u(i,r);if(h){var f=i[h._sGetter]();if(!(!f||f==""||f=="auto"||f=="inherit")){t.warning("Position "+l+"="+s+" ignored, because child control "+i.getId()+" has fixed "+r+" ("+f+").","","AbsoluteLayout '"+(a?a.getId():"_undefined")+"'");return false}}else{if(r==="width"&&!e._disableWidthCheck||r==="height"&&!e._disableHeightCheck){t.warning("Position "+l+"="+s+" ignored, because child control "+i.getId()+" not resizable.","","AbsoluteLayout '"+(a?a.getId():"_undefined")+"'");return false}}}return true};var u=function(t,e){var i=t.getMetadata().getProperty(e);if(i&&i.type==="sap.ui.core.CSSSize"){return i}return null};var h=function(t,e){var i=u(t,e);if(i){var r=t[i._sGetter]();if(r&&r.endsWith("%")){return r}}return null};var f=function(t){var e=t.getParameter("name");var i=this.getParent();if((e==="width"||e==="height")&&i&&i.getDomRef()){l(this,"CTRL_POS")}};return n});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/ResponsiveFlowLayout", ["sap/ui/commons/library","sap/ui/layout/ResponsiveFlowLayout","./ResponsiveFlowLayoutRenderer"],function(e,o,a){"use strict";var s=o.extend("sap.ui.commons.layout.ResponsiveFlowLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return s});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/ResponsiveFlowLayoutData", ["sap/ui/commons/library","sap/ui/layout/ResponsiveFlowLayoutData"],function(a,e){"use strict";var o=e.extend("sap.ui.commons.layout.ResponsiveFlowLayoutData",{metadata:{deprecated:true,library:"sap.ui.commons"}});return o});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/ResponsiveFlowLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/ResponsiveFlowLayoutRenderer"],function(e,r){"use strict";var u=e.extend(r);return u},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/VerticalLayout", ["sap/ui/commons/library","sap/ui/layout/VerticalLayout","./VerticalLayoutRenderer"],function(a,e,t){"use strict";var r=e.extend("sap.ui.commons.layout.VerticalLayout",{metadata:{deprecated:true,library:"sap.ui.commons"}});return r});
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/layout/VerticalLayoutRenderer", ["sap/ui/core/Renderer","sap/ui/layout/VerticalLayoutRenderer"],function(e,r){"use strict";var t=e.extend(r);return t},true);
/*!
 * OpenUI5
 * (c) Copyright 2009-2024 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine("sap/ui/commons/library", ["sap/ui/base/DataType","sap/base/util/ObjectPath","sap/ui/core/library","sap/ui/layout/library","sap/ui/unified/library"],function(o,e){"use strict";var a=sap.ui.getCore().initLibrary({name:"sap.ui.commons",version:"1.128.0",dependencies:["sap.ui.core","sap.ui.layout","sap.ui.unified"],types:["sap.ui.commons.ButtonStyle","sap.ui.commons.HorizontalDividerHeight","sap.ui.commons.HorizontalDividerType","sap.ui.commons.LabelDesign","sap.ui.commons.MenuBarDesign","sap.ui.commons.MessageType","sap.ui.commons.PaginatorEvent","sap.ui.commons.RatingIndicatorVisualMode","sap.ui.commons.RowRepeaterDesign","sap.ui.commons.SplitterSize","sap.ui.commons.TextViewColor","sap.ui.commons.TextViewDesign","sap.ui.commons.TitleLevel","sap.ui.commons.ToolbarDesign","sap.ui.commons.ToolbarSeparatorDesign","sap.ui.commons.TreeSelectionMode","sap.ui.commons.TriStateCheckBoxState","sap.ui.commons.enums.AreaDesign","sap.ui.commons.enums.BorderDesign","sap.ui.commons.enums.Orientation","sap.ui.commons.form.GridElementCells","sap.ui.commons.form.SimpleFormLayout","sap.ui.commons.layout.BackgroundDesign","sap.ui.commons.layout.BorderLayoutAreaTypes","sap.ui.commons.layout.HAlign","sap.ui.commons.layout.Padding","sap.ui.commons.layout.Separation","sap.ui.commons.layout.VAlign","sap.ui.commons.ColorPickerMode"],interfaces:["sap.ui.commons.FormattedTextViewControl","sap.ui.commons.ToolbarItem"],controls:["sap.ui.commons.Accordion","sap.ui.commons.ApplicationHeader","sap.ui.commons.AutoComplete","sap.ui.commons.Button","sap.ui.commons.Callout","sap.ui.commons.CalloutBase","sap.ui.commons.Carousel","sap.ui.commons.CheckBox","sap.ui.commons.ColorPicker","sap.ui.commons.ComboBox","sap.ui.commons.DatePicker","sap.ui.commons.Dialog","sap.ui.commons.DropdownBox","sap.ui.commons.FileUploader","sap.ui.commons.FormattedTextView","sap.ui.commons.HorizontalDivider","sap.ui.commons.Image","sap.ui.commons.ImageMap","sap.ui.commons.InPlaceEdit","sap.ui.commons.Label","sap.ui.commons.Link","sap.ui.commons.ListBox","sap.ui.commons.Menu","sap.ui.commons.MenuBar","sap.ui.commons.MenuButton","sap.ui.commons.Message","sap.ui.commons.MessageBar","sap.ui.commons.MessageList","sap.ui.commons.MessageToast","sap.ui.commons.Paginator","sap.ui.commons.Panel","sap.ui.commons.PasswordField","sap.ui.commons.ProgressIndicator","sap.ui.commons.RadioButton","sap.ui.commons.RadioButtonGroup","sap.ui.commons.RangeSlider","sap.ui.commons.RatingIndicator","sap.ui.commons.ResponsiveContainer","sap.ui.commons.RichTooltip","sap.ui.commons.RoadMap","sap.ui.commons.RowRepeater","sap.ui.commons.SearchField","sap.ui.commons.SegmentedButton","sap.ui.commons.Slider","sap.ui.commons.Splitter","sap.ui.commons.Tab","sap.ui.commons.TabStrip","sap.ui.commons.TextArea","sap.ui.commons.TextField","sap.ui.commons.TextView","sap.ui.commons.ToggleButton","sap.ui.commons.Toolbar","sap.ui.commons.Tree","sap.ui.commons.TriStateCheckBox","sap.ui.commons.ValueHelpField","sap.ui.commons.form.Form","sap.ui.commons.form.FormLayout","sap.ui.commons.form.GridLayout","sap.ui.commons.form.ResponsiveLayout","sap.ui.commons.form.SimpleForm","sap.ui.commons.layout.AbsoluteLayout","sap.ui.commons.layout.BorderLayout","sap.ui.commons.layout.HorizontalLayout","sap.ui.commons.layout.MatrixLayout","sap.ui.commons.layout.ResponsiveFlowLayout","sap.ui.commons.layout.VerticalLayout"],elements:["sap.ui.commons.AccordionSection","sap.ui.commons.Area","sap.ui.commons.FileUploaderParameter","sap.ui.commons.MenuItem","sap.ui.commons.MenuItemBase","sap.ui.commons.MenuTextFieldItem","sap.ui.commons.ResponsiveContainerRange","sap.ui.commons.RoadMapStep","sap.ui.commons.RowRepeaterFilter","sap.ui.commons.RowRepeaterSorter","sap.ui.commons.SearchProvider","sap.ui.commons.Title","sap.ui.commons.ToolbarSeparator","sap.ui.commons.TreeNode","sap.ui.commons.form.FormContainer","sap.ui.commons.form.FormElement","sap.ui.commons.form.GridContainerData","sap.ui.commons.form.GridElementData","sap.ui.commons.layout.BorderLayoutArea","sap.ui.commons.layout.MatrixLayoutCell","sap.ui.commons.layout.MatrixLayoutRow","sap.ui.commons.layout.PositionContainer","sap.ui.commons.layout.ResponsiveFlowLayoutData"]});a.ButtonStyle={Emph:"Emph",Accept:"Accept",Reject:"Reject",Default:"Default"};a.ColorPickerMode=sap.ui.unified.ColorPickerMode;a.HorizontalDividerHeight={Ruleheight:"Ruleheight",Small:"Small",Medium:"Medium",Large:"Large"};a.HorizontalDividerType={Area:"Area",Page:"Page"};a.LabelDesign={Bold:"Bold",Standard:"Standard"};a.MenuBarDesign={Standard:"Standard",Header:"Header"};a.MessageType={Error:"Error",Warning:"Warning",Success:"Success"};a.PaginatorEvent={First:"First",Previous:"Previous",Goto:"Goto",Next:"Next",Last:"Last"};a.RatingIndicatorVisualMode={Full:"Full",Half:"Half",Continuous:"Continuous"};a.RowRepeaterDesign={Standard:"Standard",Transparent:"Transparent",BareShell:"BareShell"};a.SplitterSize=o.createType("sap.ui.commons.SplitterSize",{isValid:function(o){return/^((0*|([0-9]+|[0-9]*\.[0-9]+)([pP][xX]|%)))$/.test(o)}},o.getType("string"));a.TextViewColor={Default:"Default",Positive:"Positive",Negative:"Negative",Critical:"Critical"};a.TextViewDesign={Standard:"Standard",Bold:"Bold",H1:"H1",H2:"H2",H3:"H3",H4:"H4",H5:"H5",H6:"H6",Italic:"Italic",Small:"Small",Monospace:"Monospace",Underline:"Underline"};a.TitleLevel=sap.ui.core.TitleLevel;a.ToolbarDesign={Standard:"Standard",Transparent:"Transparent",Flat:"Flat"};a.ToolbarSeparatorDesign={Standard:"Standard",FullHeight:"FullHeight"};a.TreeSelectionMode={Multi:"Multi",Single:"Single",None:"None",Legacy:"Legacy"};a.TriStateCheckBoxState={Unchecked:"Unchecked",Mixed:"Mixed",Checked:"Checked"};a.enums=a.enums||{};a.enums.AreaDesign={Plain:"Plain",Fill:"Fill",Transparent:"Transparent"};a.enums.BorderDesign={Box:"Box",None:"None"};a.enums.Orientation={horizontal:"horizontal",vertical:"vertical"};a.form=a.form||{};a.form.GridElementCells=sap.ui.layout.form.GridElementCells;a.form.SimpleFormLayout=sap.ui.layout.form.SimpleFormLayout;a.layout=a.layout||{};a.layout.BackgroundDesign={Border:"Border",Fill1:"Fill1",Fill2:"Fill2",Fill3:"Fill3",Header:"Header",Plain:"Plain",Transparent:"Transparent"};a.layout.BorderLayoutAreaTypes={top:"top",begin:"begin",center:"center",end:"end",bottom:"bottom"};a.layout.HAlign={Begin:"Begin",Center:"Center",End:"End",Left:"Left",Right:"Right"};a.layout.Padding={None:"None",Begin:"Begin",End:"End",Both:"Both",Neither:"Neither"};a.layout.Separation={None:"None",Small:"Small",SmallWithLine:"SmallWithLine",Medium:"Medium",MediumWithLine:"MediumWithLine",Large:"Large",LargeWithLine:"LargeWithLine"};a.layout.VAlign={Bottom:"Bottom",Middle:"Middle",Top:"Top"};sap.ui.lazyRequire("sap.ui.commons.MessageBox","alert confirm show");sap.ui.lazyRequire("sap.ui.commons.MenuItemBase","new extend getMetadata");a.Orientation={Vertical:sap.ui.core.Orientation.Vertical,Horizontal:sap.ui.core.Orientation.Horizontal,vertical:sap.ui.core.Orientation.Vertical,horizontal:sap.ui.core.Orientation.Horizontal};var i=e.get("sap.ui.table.TableHelper");if(!i||!i.bFinal){e.set("sap.ui.table.TableHelper",{createLabel:function(o){return new sap.ui.commons.Label(o)},createTextView:function(o){if(o&&!o.wrapping){o.wrapping=false}return new sap.ui.commons.TextView(o)},addTableClass:function(){return"sapUiTableCommons"},bFinal:false})}if(!sap.ui.layout.GridHelper||!sap.ui.layout.GridHelper.bFinal){sap.ui.layout.GridHelper={getLibrarySpecificClass:function(){return"sapUiRespGridOverflowHidden"},bFinal:false}}return a});
sap.ui.require.preload({
	"sap/ui/commons/manifest.json":'{"_version":"1.21.0","sap.app":{"id":"sap.ui.commons","type":"library","embeds":[],"applicationVersion":{"version":"1.128.0"},"title":"Common basic controls, mainly intended for desktop scenarios","description":"Common basic controls, mainly intended for desktop scenarios","ach":"CA-UI5-CTR","resources":"resources.json","offline":true,"openSourceComponents":[{"name":"jquery_UI","packagedWithMySelf":true,"version":"1.10.4"},{"name":"jquery-fix-clone","packagedWithMySelf":true,"version":"unknown"}]},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.128","libs":{"sap.ui.core":{"minVersion":"1.128.0"},"sap.ui.layout":{"minVersion":"1.128.0"},"sap.ui.unified":{"minVersion":"1.128.0"}}},"library":{"i18n":{"bundleUrl":"messagebundle.properties","supportedLocales":["","ar","bg","ca","cnr","cs","cy","da","de","el","en","en-GB","en-US-sappsd","en-US-saprigi","en-US-saptrc","es","es-MX","et","fi","fr","fr-CA","hi","hr","hu","id","it","iw","ja","kk","ko","lt","lv","mk","ms","nl","no","pl","pt","pt-PT","ro","ru","sh","sk","sl","sr","sv","th","tr","uk","vi","zh-CN","zh-TW"]},"content":{"controls":["sap.ui.commons.Accordion","sap.ui.commons.ApplicationHeader","sap.ui.commons.AutoComplete","sap.ui.commons.Button","sap.ui.commons.Callout","sap.ui.commons.CalloutBase","sap.ui.commons.Carousel","sap.ui.commons.CheckBox","sap.ui.commons.ColorPicker","sap.ui.commons.ComboBox","sap.ui.commons.DatePicker","sap.ui.commons.Dialog","sap.ui.commons.DropdownBox","sap.ui.commons.FileUploader","sap.ui.commons.FormattedTextView","sap.ui.commons.HorizontalDivider","sap.ui.commons.Image","sap.ui.commons.ImageMap","sap.ui.commons.InPlaceEdit","sap.ui.commons.Label","sap.ui.commons.Link","sap.ui.commons.ListBox","sap.ui.commons.Menu","sap.ui.commons.MenuBar","sap.ui.commons.MenuButton","sap.ui.commons.Message","sap.ui.commons.MessageBar","sap.ui.commons.MessageList","sap.ui.commons.MessageToast","sap.ui.commons.Paginator","sap.ui.commons.Panel","sap.ui.commons.PasswordField","sap.ui.commons.ProgressIndicator","sap.ui.commons.RadioButton","sap.ui.commons.RadioButtonGroup","sap.ui.commons.RangeSlider","sap.ui.commons.RatingIndicator","sap.ui.commons.ResponsiveContainer","sap.ui.commons.RichTooltip","sap.ui.commons.RoadMap","sap.ui.commons.RowRepeater","sap.ui.commons.SearchField","sap.ui.commons.SegmentedButton","sap.ui.commons.Slider","sap.ui.commons.Splitter","sap.ui.commons.Tab","sap.ui.commons.TabStrip","sap.ui.commons.TextArea","sap.ui.commons.TextField","sap.ui.commons.TextView","sap.ui.commons.ToggleButton","sap.ui.commons.Toolbar","sap.ui.commons.Tree","sap.ui.commons.TriStateCheckBox","sap.ui.commons.ValueHelpField","sap.ui.commons.form.Form","sap.ui.commons.form.FormLayout","sap.ui.commons.form.GridLayout","sap.ui.commons.form.ResponsiveLayout","sap.ui.commons.form.SimpleForm","sap.ui.commons.layout.AbsoluteLayout","sap.ui.commons.layout.BorderLayout","sap.ui.commons.layout.HorizontalLayout","sap.ui.commons.layout.MatrixLayout","sap.ui.commons.layout.ResponsiveFlowLayout","sap.ui.commons.layout.VerticalLayout"],"elements":["sap.ui.commons.AccordionSection","sap.ui.commons.Area","sap.ui.commons.FileUploaderParameter","sap.ui.commons.MenuItem","sap.ui.commons.MenuItemBase","sap.ui.commons.MenuTextFieldItem","sap.ui.commons.ResponsiveContainerRange","sap.ui.commons.RoadMapStep","sap.ui.commons.RowRepeaterFilter","sap.ui.commons.RowRepeaterSorter","sap.ui.commons.SearchProvider","sap.ui.commons.Title","sap.ui.commons.ToolbarSeparator","sap.ui.commons.TreeNode","sap.ui.commons.form.FormContainer","sap.ui.commons.form.FormElement","sap.ui.commons.form.GridContainerData","sap.ui.commons.form.GridElementData","sap.ui.commons.layout.BorderLayoutArea","sap.ui.commons.layout.MatrixLayoutCell","sap.ui.commons.layout.MatrixLayoutRow","sap.ui.commons.layout.PositionContainer","sap.ui.commons.layout.ResponsiveFlowLayoutData"],"types":["sap.ui.commons.ButtonStyle","sap.ui.commons.HorizontalDividerHeight","sap.ui.commons.HorizontalDividerType","sap.ui.commons.LabelDesign","sap.ui.commons.MenuBarDesign","sap.ui.commons.MessageType","sap.ui.commons.PaginatorEvent","sap.ui.commons.RatingIndicatorVisualMode","sap.ui.commons.RowRepeaterDesign","sap.ui.commons.SplitterSize","sap.ui.commons.TextViewColor","sap.ui.commons.TextViewDesign","sap.ui.commons.TitleLevel","sap.ui.commons.ToolbarDesign","sap.ui.commons.ToolbarSeparatorDesign","sap.ui.commons.TreeSelectionMode","sap.ui.commons.TriStateCheckBoxState","sap.ui.commons.enums.AreaDesign","sap.ui.commons.enums.BorderDesign","sap.ui.commons.enums.Orientation","sap.ui.commons.form.GridElementCells","sap.ui.commons.form.SimpleFormLayout","sap.ui.commons.layout.BackgroundDesign","sap.ui.commons.layout.BorderLayoutAreaTypes","sap.ui.commons.layout.HAlign","sap.ui.commons.layout.Padding","sap.ui.commons.layout.Separation","sap.ui.commons.layout.VAlign","sap.ui.commons.ColorPickerMode"],"interfaces":["sap.ui.commons.FormattedTextViewControl","sap.ui.commons.ToolbarItem"]}}}}'
});
//# sourceMappingURL=library-preload.js.map
