# coding: us-ascii

# automatically generated by template/unicode_norm_gen.tmpl

module UnicodeNormalize
  UNICODE_VERSION = "7.0.0".freeze

  accents = "" \
    "[\u0300-\u034E\u0350-\u036F\u0483-\u0487\u0591-\u05BD\u05BF\u05C1\u05C2\u05C4\u05C5\u05C7" \
    "\u0610-\u061A\u064B-\u065F\u0670\u06D6-\u06DC\u06DF-\u06E4\u06E7\u06E8\u06EA-\u06ED\u0711" \
    "\u0730-\u074A\u07EB-\u07F3\u0816-\u0819\u081B-\u0823\u0825-\u0827\u0829-\u082D\u0859-\u085B\u08E4-\u08FF" \
    "\u093C\u094D\u0951-\u0954\u09BC\u09BE\u09CD\u09D7\u0A3C" \
    "\u0A4D\u0ABC\u0ACD\u0B3C\u0B3E\u0B4D\u0B56\u0B57\u0BBE" \
    "\u0BCD\u0BD7\u0C4D\u0C55\u0C56\u0CBC\u0CC2\u0CCD\u0CD5\u0CD6" \
    "\u0D3E\u0D4D\u0D57\u0DCA\u0DCF\u0DDF\u0E38-\u0E3A\u0E48-\u0E4B" \
    "\u0EB8\u0EB9\u0EC8-\u0ECB\u0F18\u0F19\u0F35\u0F37\u0F39\u0F71\u0F72\u0F74" \
    "\u0F7A-\u0F7D\u0F80\u0F82-\u0F84\u0F86\u0F87\u0FC6\u102E\u1037\u1039\u103A" \
    "\u108D\u135D-\u135F\u1714\u1734\u17D2\u17DD\u18A9\u1939-\u193B" \
    "\u1A17\u1A18\u1A60\u1A75-\u1A7C\u1A7F\u1AB0-\u1ABD\u1B34\u1B35\u1B44\u1B6B-\u1B73" \
    "\u1BAA\u1BAB\u1BE6\u1BF2\u1BF3\u1C37\u1CD0-\u1CD2\u1CD4-\u1CE0\u1CE2-\u1CE8\u1CED" \
    "\u1CF4\u1CF8\u1CF9\u1DC0-\u1DF5\u1DFC-\u1DFF\u20D0-\u20DC\u20E1\u20E5-\u20F0\u2CEF-\u2CF1" \
    "\u2D7F\u2DE0-\u2DFF\u302A-\u302F\u3099\u309A\uA66F\uA674-\uA67D\uA69F\uA6F0\uA6F1" \
    "\uA806\uA8C4\uA8E0-\uA8F1\uA92B-\uA92D\uA953\uA9B3\uA9C0\uAAB0" \
    "\uAAB2-\uAAB4\uAAB7\uAAB8\uAABE\uAABF\uAAC1\uAAF6\uABED\uFB1E\uFE20-\uFE2D" \
    "\u{101FD}\u{102E0}\u{10376}-\u{1037A}\u{10A0D}\u{10A0F}\u{10A38}-\u{10A3A}\u{10A3F}\u{10AE5}\u{10AE6}" \
    "\u{11046}\u{1107F}\u{110B9}\u{110BA}\u{11100}-\u{11102}\u{11127}\u{11133}\u{11134}\u{11173}\u{111C0}" \
    "\u{11235}\u{11236}\u{112E9}\u{112EA}\u{1133C}\u{1133E}\u{1134D}\u{11357}\u{11366}-\u{1136C}\u{11370}-\u{11374}" \
    "\u{114B0}\u{114BA}\u{114BD}\u{114C2}\u{114C3}\u{115AF}\u{115BF}\u{115C0}\u{1163F}\u{116B6}\u{116B7}" \
    "\u{16AF0}-\u{16AF4}\u{16B30}-\u{16B36}\u{1BC9E}\u{1D165}-\u{1D169}\u{1D16D}-\u{1D172}\u{1D17B}-\u{1D182}\u{1D185}-\u{1D18B}\u{1D1AA}-\u{1D1AD}" \
    "\u{1D242}-\u{1D244}\u{1E8D0}-\u{1E8D6}" \
    "]" \
  "".freeze
  ACCENTS = accents
  REGEXP_D_STRING = "#{''  # composition starters and composition exclusions
    }" \
    "[\u00C0-\u00C5\u00C7-\u00CF\u00D1-\u00D6\u00D9-\u00DD\u00E0-\u00E5\u00E7-\u00EF\u00F1-\u00F6\u00F9-\u00FD" \
    "\u00FF-\u010F\u0112-\u0125\u0128-\u0130\u0134-\u0137\u0139-\u013E\u0143-\u0148\u014C-\u0151\u0154-\u0165" \
    "\u0168-\u017E\u01A0\u01A1\u01AF\u01B0\u01CD-\u01DC\u01DE-\u01E3\u01E6-\u01F0\u01F4\u01F5\u01F8-\u021B" \
    "\u021E\u021F\u0226-\u0233\u0340\u0341\u0343\u0344\u0374\u037E\u0385-\u038A\u038C" \
    "\u038E-\u0390\u03AA-\u03B0\u03CA-\u03CE\u03D3\u03D4\u0400\u0401\u0403\u0407\u040C-\u040E" \
    "\u0419\u0439\u0450\u0451\u0453\u0457\u045C-\u045E\u0476\u0477\u04C1\u04C2" \
    "\u04D0-\u04D3\u04D6\u04D7\u04DA-\u04DF\u04E2-\u04E7\u04EA-\u04F5\u04F8\u04F9\u0622-\u0626\u06C0" \
    "\u06C2\u06D3\u0929\u0931\u0934\u0958-\u095F\u09CB\u09CC\u09DC\u09DD" \
    "\u09DF\u0A33\u0A36\u0A59-\u0A5B\u0A5E\u0B48\u0B4B\u0B4C\u0B5C\u0B5D" \
    "\u0B94\u0BCA-\u0BCC\u0C48\u0CC0\u0CC7\u0CC8\u0CCA\u0CCB\u0D4A-\u0D4C\u0DDA" \
    "\u0DDC-\u0DDE\u0F43\u0F4D\u0F52\u0F57\u0F5C\u0F69\u0F73" \
    "\u0F75\u0F76\u0F78\u0F81\u0F93\u0F9D\u0FA2\u0FA7\u0FAC" \
    "\u0FB9\u1026\u1B06\u1B08\u1B0A\u1B0C\u1B0E\u1B12" \
    "\u1B3B\u1B3D\u1B40\u1B41\u1B43\u1E00-\u1E99\u1E9B\u1EA0-\u1EF9\u1F00-\u1F15" \
    "\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D" \
    "\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC1-\u1FC4\u1FC6-\u1FD3\u1FD6-\u1FDB\u1FDD-\u1FEF\u1FF2-\u1FF4" \
    "\u1FF6-\u1FFD\u2000\u2001\u2126\u212A\u212B\u219A\u219B\u21AE\u21CD-\u21CF\u2204" \
    "\u2209\u220C\u2224\u2226\u2241\u2244\u2247\u2249" \
    "\u2260\u2262\u226D-\u2271\u2274\u2275\u2278\u2279\u2280\u2281\u2284\u2285\u2288\u2289" \
    "\u22AC-\u22AF\u22E0-\u22E3\u22EA-\u22ED\u2329\u232A\u2ADC\u304C\u304E\u3050" \
    "\u3052\u3054\u3056\u3058\u305A\u305C\u305E\u3060" \
    "\u3062\u3065\u3067\u3069\u3070\u3071\u3073\u3074\u3076\u3077\u3079\u307A" \
    "\u307C\u307D\u3094\u309E\u30AC\u30AE\u30B0\u30B2\u30B4" \
    "\u30B6\u30B8\u30BA\u30BC\u30BE\u30C0\u30C2\u30C5" \
    "\u30C7\u30C9\u30D0\u30D1\u30D3\u30D4\u30D6\u30D7\u30D9\u30DA\u30DC\u30DD\u30F4" \
    "\u30F7-\u30FA\u30FE\uF900-\uFA0D\uFA10\uFA12\uFA15-\uFA1E\uFA20\uFA22" \
    "\uFA25\uFA26\uFA2A-\uFA6D\uFA70-\uFAD9\uFB1D\uFB1F\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E" \
    "\uFB40\uFB41\uFB43\uFB44\uFB46-\uFB4E\u{1109A}\u{1109C}\u{110AB}\u{1112E}\u{1112F}\u{1134B}\u{1134C}" \
    "\u{114BB}\u{114BC}\u{114BE}\u{115BA}\u{115BB}\u{1D15E}-\u{1D164}\u{1D1BB}-\u{1D1C0}\u{2F800}-\u{2FA1D}" \
    "]#{accents}*" \
    "|#{''  # characters that can be the result of a composition, except composition starters
    }" \
    "[<->A-PR-Za-pr-z\u00A8\u00C6\u00D8" \
    "\u00E6\u00F8\u017F\u01B7\u0292\u0391\u0395\u0397" \
    "\u0399\u039F\u03A1\u03A5\u03A9\u03B1\u03B5\u03B7" \
    "\u03B9\u03BF\u03C1\u03C5\u03C9\u03D2\u0406\u0410" \
    "\u0413\u0415-\u0418\u041A\u041E\u0423\u0427\u042B\u042D" \
    "\u0430\u0433\u0435-\u0438\u043A\u043E\u0443\u0447\u044B" \
    "\u044D\u0456\u0474\u0475\u04D8\u04D9\u04E8\u04E9\u0627\u0648\u064A" \
    "\u06C1\u06D2\u06D5\u0928\u0930\u0933\u09C7\u0B47" \
    "\u0B92\u0BC6\u0BC7\u0C46\u0CBF\u0CC6\u0D46\u0D47\u0DD9\u1025" \
    "\u1B05\u1B07\u1B09\u1B0B\u1B0D\u1B11\u1B3A\u1B3C" \
    "\u1B3E\u1B3F\u1B42\u1FBF\u1FFE\u2190\u2192\u2194\u21D0" \
    "\u21D2\u21D4\u2203\u2208\u220B\u2223\u2225\u223C" \
    "\u2243\u2245\u2248\u224D\u2261\u2264\u2265\u2272\u2273\u2276\u2277" \
    "\u227A-\u227D\u2282\u2283\u2286\u2287\u2291\u2292\u22A2\u22A8\u22A9\u22AB\u22B2-\u22B5" \
    "\u3046\u304B\u304D\u304F\u3051\u3053\u3055\u3057" \
    "\u3059\u305B\u305D\u305F\u3061\u3064\u3066\u3068" \
    "\u306F\u3072\u3075\u3078\u307B\u309D\u30A6\u30AB" \
    "\u30AD\u30AF\u30B1\u30B3\u30B5\u30B7\u30B9\u30BB" \
    "\u30BD\u30BF\u30C1\u30C4\u30C6\u30C8\u30CF\u30D2" \
    "\u30D5\u30D8\u30DB\u30EF-\u30F2\u30FD\u{11099}\u{1109B}\u{110A5}" \
    "\u{11131}\u{11132}\u{11347}\u{114B9}\u{115B8}\u{115B9}" \
    "]?#{accents}+" \
    "|#{''  # precomposed Hangul syllables
    }" \
    "[\u{AC00}-\u{D7A4}]" \
  "".freeze
  REGEXP_C_STRING = "#{''  # composition exclusions
    }" \
    "[\u0340\u0341\u0343\u0344\u0374\u037E\u0387\u0958-\u095F\u09DC\u09DD\u09DF" \
    "\u0A33\u0A36\u0A59-\u0A5B\u0A5E\u0B5C\u0B5D\u0F43\u0F4D\u0F52" \
    "\u0F57\u0F5C\u0F69\u0F73\u0F75\u0F76\u0F78\u0F81\u0F93" \
    "\u0F9D\u0FA2\u0FA7\u0FAC\u0FB9\u1F71\u1F73\u1F75" \
    "\u1F77\u1F79\u1F7B\u1F7D\u1FBB\u1FBE\u1FC9\u1FCB" \
    "\u1FD3\u1FDB\u1FE3\u1FEB\u1FEE\u1FEF\u1FF9\u1FFB\u1FFD" \
    "\u2000\u2001\u2126\u212A\u212B\u2329\u232A\u2ADC\uF900-\uFA0D\uFA10\uFA12" \
    "\uFA15-\uFA1E\uFA20\uFA22\uFA25\uFA26\uFA2A-\uFA6D\uFA70-\uFAD9\uFB1D\uFB1F" \
    "\uFB2A-\uFB36\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFB4E\u{1D15E}-\u{1D164}\u{1D1BB}-\u{1D1C0}" \
    "\u{2F800}-\u{2FA1D}" \
    "]#{accents}*" \
    "|#{''  # composition starters and characters that can be the result of a composition
    }" \
    "[<->A-PR-Za-pr-z\u00A8\u00C0-\u00CF\u00D1-\u00D6" \
    "\u00D8-\u00DD\u00E0-\u00EF\u00F1-\u00F6\u00F8-\u00FD\u00FF-\u010F\u0112-\u0125\u0128-\u0130\u0134-\u0137" \
    "\u0139-\u013E\u0143-\u0148\u014C-\u0151\u0154-\u0165\u0168-\u017F\u01A0\u01A1\u01AF\u01B0\u01B7" \
    "\u01CD-\u01DC\u01DE-\u01E3\u01E6-\u01F0\u01F4\u01F5\u01F8-\u021B\u021E\u021F\u0226-\u0233\u0292" \
    "\u0385\u0386\u0388-\u038A\u038C\u038E-\u0391\u0395\u0397\u0399\u039F" \
    "\u03A1\u03A5\u03A9-\u03B1\u03B5\u03B7\u03B9\u03BF\u03C1" \
    "\u03C5\u03C9-\u03CE\u03D2-\u03D4\u0400\u0401\u0403\u0406\u0407\u040C-\u040E\u0410" \
    "\u0413\u0415-\u041A\u041E\u0423\u0427\u042B\u042D\u0430" \
    "\u0433\u0435-\u043A\u043E\u0443\u0447\u044B\u044D\u0450\u0451" \
    "\u0453\u0456\u0457\u045C-\u045E\u0474-\u0477\u04C1\u04C2\u04D0-\u04D3\u04D6-\u04DF\u04E2-\u04F5" \
    "\u04F8\u04F9\u0622-\u0627\u0648\u064A\u06C0-\u06C2\u06D2\u06D3\u06D5\u0928\u0929" \
    "\u0930\u0931\u0933\u0934\u09C7\u09CB\u09CC\u0B47\u0B48\u0B4B\u0B4C\u0B92\u0B94" \
    "\u0BC6\u0BC7\u0BCA-\u0BCC\u0C46\u0C48\u0CBF\u0CC0\u0CC6-\u0CC8\u0CCA\u0CCB\u0D46\u0D47" \
    "\u0D4A-\u0D4C\u0DD9\u0DDA\u0DDC-\u0DDE\u1025\u1026\u1B05-\u1B0E\u1B11\u1B12\u1B3A-\u1B43\u1E00-\u1E99" \
    "\u1E9B\u1EA0-\u1EF9\u1F00-\u1F15\u1F18-\u1F1D\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59" \
    "\u1F5B\u1F5D\u1F5F-\u1F70\u1F72\u1F74\u1F76\u1F78\u1F7A" \
    "\u1F7C\u1F80-\u1FB4\u1FB6-\u1FBA\u1FBC\u1FBF\u1FC1-\u1FC4\u1FC6-\u1FC8\u1FCA" \
    "\u1FCC-\u1FD2\u1FD6-\u1FDA\u1FDD-\u1FE2\u1FE4-\u1FEA\u1FEC\u1FED\u1FF2-\u1FF4\u1FF6-\u1FF8\u1FFA" \
    "\u1FFC\u1FFE\u2190\u2192\u2194\u219A\u219B\u21AE\u21CD-\u21D0" \
    "\u21D2\u21D4\u2203\u2204\u2208\u2209\u220B\u220C\u2223-\u2226\u223C\u2241" \
    "\u2243-\u2245\u2247-\u2249\u224D\u2260-\u2262\u2264\u2265\u226D-\u227D\u2280-\u2289\u2291\u2292" \
    "\u22A2\u22A8\u22A9\u22AB-\u22AF\u22B2-\u22B5\u22E0-\u22E3\u22EA-\u22ED\u3046\u304B-\u3062" \
    "\u3064-\u3069\u306F-\u307D\u3094\u309D\u309E\u30A6\u30AB-\u30C2\u30C4-\u30C9\u30CF-\u30DD" \
    "\u30EF-\u30F2\u30F4\u30F7-\u30FA\u30FD\u30FE\u{11099}-\u{1109C}\u{110A5}\u{110AB}\u{1112E}\u{1112F}" \
    "\u{11131}\u{11132}\u{11347}\u{1134B}\u{1134C}\u{114B9}\u{114BB}\u{114BC}\u{114BE}\u{115B8}-\u{115BB}" \
    "]?#{accents}+" \
    "|#{''  # Hangul syllables with separate trailer
    }" \
    "[\uAC00\uAC1C\uAC38\uAC54\uAC70\uAC8C\uACA8\uACC4" \
    "\uACE0\uACFC\uAD18\uAD34\uAD50\uAD6C\uAD88\uADA4" \
    "\uADC0\uADDC\uADF8\uAE14\uAE30\uAE4C\uAE68\uAE84" \
    "\uAEA0\uAEBC\uAED8\uAEF4\uAF10\uAF2C\uAF48\uAF64" \
    "\uAF80\uAF9C\uAFB8\uAFD4\uAFF0\uB00C\uB028\uB044" \
    "\uB060\uB07C\uB098\uB0B4\uB0D0\uB0EC\uB108\uB124" \
    "\uB140\uB15C\uB178\uB194\uB1B0\uB1CC\uB1E8\uB204" \
    "\uB220\uB23C\uB258\uB274\uB290\uB2AC\uB2C8\uB2E4" \
    "\uB300\uB31C\uB338\uB354\uB370\uB38C\uB3A8\uB3C4" \
    "\uB3E0\uB3FC\uB418\uB434\uB450\uB46C\uB488\uB4A4" \
    "\uB4C0\uB4DC\uB4F8\uB514\uB530\uB54C\uB568\uB584" \
    "\uB5A0\uB5BC\uB5D8\uB5F4\uB610\uB62C\uB648\uB664" \
    "\uB680\uB69C\uB6B8\uB6D4\uB6F0\uB70C\uB728\uB744" \
    "\uB760\uB77C\uB798\uB7B4\uB7D0\uB7EC\uB808\uB824" \
    "\uB840\uB85C\uB878\uB894\uB8B0\uB8CC\uB8E8\uB904" \
    "\uB920\uB93C\uB958\uB974\uB990\uB9AC\uB9C8\uB9E4" \
    "\uBA00\uBA1C\uBA38\uBA54\uBA70\uBA8C\uBAA8\uBAC4" \
    "\uBAE0\uBAFC\uBB18\uBB34\uBB50\uBB6C\uBB88\uBBA4" \
    "\uBBC0\uBBDC\uBBF8\uBC14\uBC30\uBC4C\uBC68\uBC84" \
    "\uBCA0\uBCBC\uBCD8\uBCF4\uBD10\uBD2C\uBD48\uBD64" \
    "\uBD80\uBD9C\uBDB8\uBDD4\uBDF0\uBE0C\uBE28\uBE44" \
    "\uBE60\uBE7C\uBE98\uBEB4\uBED0\uBEEC\uBF08\uBF24" \
    "\uBF40\uBF5C\uBF78\uBF94\uBFB0\uBFCC\uBFE8\uC004" \
    "\uC020\uC03C\uC058\uC074\uC090\uC0AC\uC0C8\uC0E4" \
    "\uC100\uC11C\uC138\uC154\uC170\uC18C\uC1A8\uC1C4" \
    "\uC1E0\uC1FC\uC218\uC234\uC250\uC26C\uC288\uC2A4" \
    "\uC2C0\uC2DC\uC2F8\uC314\uC330\uC34C\uC368\uC384" \
    "\uC3A0\uC3BC\uC3D8\uC3F4\uC410\uC42C\uC448\uC464" \
    "\uC480\uC49C\uC4B8\uC4D4\uC4F0\uC50C\uC528\uC544" \
    "\uC560\uC57C\uC598\uC5B4\uC5D0\uC5EC\uC608\uC624" \
    "\uC640\uC65C\uC678\uC694\uC6B0\uC6CC\uC6E8\uC704" \
    "\uC720\uC73C\uC758\uC774\uC790\uC7AC\uC7C8\uC7E4" \
    "\uC800\uC81C\uC838\uC854\uC870\uC88C\uC8A8\uC8C4" \
    "\uC8E0\uC8FC\uC918\uC934\uC950\uC96C\uC988\uC9A4" \
    "\uC9C0\uC9DC\uC9F8\uCA14\uCA30\uCA4C\uCA68\uCA84" \
    "\uCAA0\uCABC\uCAD8\uCAF4\uCB10\uCB2C\uCB48\uCB64" \
    "\uCB80\uCB9C\uCBB8\uCBD4\uCBF0\uCC0C\uCC28\uCC44" \
    "\uCC60\uCC7C\uCC98\uCCB4\uCCD0\uCCEC\uCD08\uCD24" \
    "\uCD40\uCD5C\uCD78\uCD94\uCDB0\uCDCC\uCDE8\uCE04" \
    "\uCE20\uCE3C\uCE58\uCE74\uCE90\uCEAC\uCEC8\uCEE4" \
    "\uCF00\uCF1C\uCF38\uCF54\uCF70\uCF8C\uCFA8\uCFC4" \
    "\uCFE0\uCFFC\uD018\uD034\uD050\uD06C\uD088\uD0A4" \
    "\uD0C0\uD0DC\uD0F8\uD114\uD130\uD14C\uD168\uD184" \
    "\uD1A0\uD1BC\uD1D8\uD1F4\uD210\uD22C\uD248\uD264" \
    "\uD280\uD29C\uD2B8\uD2D4\uD2F0\uD30C\uD328\uD344" \
    "\uD360\uD37C\uD398\uD3B4\uD3D0\uD3EC\uD408\uD424" \
    "\uD440\uD45C\uD478\uD494\uD4B0\uD4CC\uD4E8\uD504" \
    "\uD520\uD53C\uD558\uD574\uD590\uD5AC\uD5C8\uD5E4" \
    "\uD600\uD61C\uD638\uD654\uD670\uD68C\uD6A8\uD6C4" \
    "\uD6E0\uD6FC\uD718\uD734\uD750\uD76C\uD788" \
    "][\u11A8-\u11C2]" \
    "|#{''  # decomposed Hangul syllables
    }" \
    "[\u1100-\u1112][\u1161-\u1175][\u11A8-\u11C2]?" \
  "".freeze
  REGEXP_K_STRING = "" \
    "[\u00A0\u00A8\u00AA\u00AF\u00B2-\u00B5\u00B8-\u00BA\u00BC-\u00BE\u0132\u0133" \
    "\u013F\u0140\u0149\u017F\u01C4-\u01CC\u01F1-\u01F3\u02B0-\u02B8\u02D8-\u02DD\u02E0-\u02E4" \
    "\u037A\u0384\u0385\u03D0-\u03D6\u03F0-\u03F2\u03F4\u03F5\u03F9\u0587\u0675-\u0678" \
    "\u0E33\u0EB3\u0EDC\u0EDD\u0F0C\u0F77\u0F79\u10FC\u1D2C-\u1D2E" \
    "\u1D30-\u1D3A\u1D3C-\u1D4D\u1D4F-\u1D6A\u1D78\u1D9B-\u1DBF\u1E9A\u1E9B\u1FBD\u1FBF-\u1FC1" \
    "\u1FCD-\u1FCF\u1FDD-\u1FDF\u1FED\u1FEE\u1FFD\u1FFE\u2000-\u200A\u2011\u2017\u2024-\u2026" \
    "\u202F\u2033\u2034\u2036\u2037\u203C\u203E\u2047-\u2049\u2057\u205F" \
    "\u2070\u2071\u2074-\u208E\u2090-\u209C\u20A8\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115\u2116" \
    "\u2119-\u211D\u2120-\u2122\u2124\u2128\u212C\u212D\u212F-\u2131\u2133-\u2139\u213B-\u2140" \
    "\u2145-\u2149\u2150-\u217F\u2189\u222C\u222D\u222F\u2230\u2460-\u24EA\u2A0C\u2A74-\u2A76" \
    "\u2C7C\u2C7D\u2D6F\u2E9F\u2EF3\u2F00-\u2FD5\u3000\u3036\u3038-\u303A" \
    "\u309B\u309C\u309F\u30FF\u3131-\u318E\u3192-\u319F\u3200-\u321E\u3220-\u3247\u3250-\u327E" \
    "\u3280-\u32FE\u3300-\u33FF\uA69C\uA69D\uA770\uA7F8\uA7F9\uAB5C-\uAB5F\uFB00-\uFB06\uFB13-\uFB17" \
    "\uFB20-\uFB29\uFB4F-\uFBB1\uFBD3-\uFD3D\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFC\uFE10-\uFE19\uFE30-\uFE44" \
    "\uFE47-\uFE52\uFE54-\uFE66\uFE68-\uFE6B\uFE70-\uFE72\uFE74\uFE76-\uFEFC\uFF01-\uFFBE\uFFC2-\uFFC7" \
    "\uFFCA-\uFFCF\uFFD2-\uFFD7\uFFDA-\uFFDC\uFFE0-\uFFE6\uFFE8-\uFFEE\u{1D400}-\u{1D454}\u{1D456}-\u{1D49C}\u{1D49E}\u{1D49F}" \
    "\u{1D4A2}\u{1D4A5}\u{1D4A6}\u{1D4A9}-\u{1D4AC}\u{1D4AE}-\u{1D4B9}\u{1D4BB}\u{1D4BD}-\u{1D4C3}\u{1D4C5}-\u{1D505}\u{1D507}-\u{1D50A}" \
    "\u{1D50D}-\u{1D514}\u{1D516}-\u{1D51C}\u{1D51E}-\u{1D539}\u{1D53B}-\u{1D53E}\u{1D540}-\u{1D544}\u{1D546}\u{1D54A}-\u{1D550}\u{1D552}-\u{1D6A5}" \
    "\u{1D6A8}-\u{1D7CB}\u{1D7CE}-\u{1D7FF}\u{1EE00}-\u{1EE03}\u{1EE05}-\u{1EE1F}\u{1EE21}\u{1EE22}\u{1EE24}\u{1EE27}\u{1EE29}-\u{1EE32}" \
    "\u{1EE34}-\u{1EE37}\u{1EE39}\u{1EE3B}\u{1EE42}\u{1EE47}\u{1EE49}\u{1EE4B}\u{1EE4D}-\u{1EE4F}" \
    "\u{1EE51}\u{1EE52}\u{1EE54}\u{1EE57}\u{1EE59}\u{1EE5B}\u{1EE5D}\u{1EE5F}\u{1EE61}\u{1EE62}" \
    "\u{1EE64}\u{1EE67}-\u{1EE6A}\u{1EE6C}-\u{1EE72}\u{1EE74}-\u{1EE77}\u{1EE79}-\u{1EE7C}\u{1EE7E}\u{1EE80}-\u{1EE89}\u{1EE8B}-\u{1EE9B}" \
    "\u{1EEA1}-\u{1EEA3}\u{1EEA5}-\u{1EEA9}\u{1EEAB}-\u{1EEBB}\u{1F100}-\u{1F10A}\u{1F110}-\u{1F12E}\u{1F130}-\u{1F14F}\u{1F16A}\u{1F16B}\u{1F190}" \
    "\u{1F200}-\u{1F202}\u{1F210}-\u{1F23A}\u{1F240}-\u{1F248}\u{1F250}\u{1F251}" \
    "]" \
  "".freeze

  class_table = {
    "\u0300"=>230, "\u0301"=>230, "\u0302"=>230, "\u0303"=>230, "\u0304"=>230, "\u0305"=>230, "\u0306"=>230, "\u0307"=>230,
    "\u0308"=>230, "\u0309"=>230, "\u030A"=>230, "\u030B"=>230, "\u030C"=>230, "\u030D"=>230, "\u030E"=>230, "\u030F"=>230,
    "\u0310"=>230, "\u0311"=>230, "\u0312"=>230, "\u0313"=>230, "\u0314"=>230, "\u0315"=>232, "\u0316"=>220, "\u0317"=>220,
    "\u0318"=>220, "\u0319"=>220, "\u031A"=>232, "\u031B"=>216, "\u031C"=>220, "\u031D"=>220, "\u031E"=>220, "\u031F"=>220,
    "\u0320"=>220, "\u0321"=>202, "\u0322"=>202, "\u0323"=>220, "\u0324"=>220, "\u0325"=>220, "\u0326"=>220, "\u0327"=>202,
    "\u0328"=>202, "\u0329"=>220, "\u032A"=>220, "\u032B"=>220, "\u032C"=>220, "\u032D"=>220, "\u032E"=>220, "\u032F"=>220,
    "\u0330"=>220, "\u0331"=>220, "\u0332"=>220, "\u0333"=>220, "\u0334"=>1, "\u0335"=>1, "\u0336"=>1, "\u0337"=>1,
    "\u0338"=>1, "\u0339"=>220, "\u033A"=>220, "\u033B"=>220, "\u033C"=>220, "\u033D"=>230, "\u033E"=>230, "\u033F"=>230,
    "\u0340"=>230, "\u0341"=>230, "\u0342"=>230, "\u0343"=>230, "\u0344"=>230, "\u0345"=>240, "\u0346"=>230, "\u0347"=>220,
    "\u0348"=>220, "\u0349"=>220, "\u034A"=>230, "\u034B"=>230, "\u034C"=>230, "\u034D"=>220, "\u034E"=>220, "\u0350"=>230,
    "\u0351"=>230, "\u0352"=>230, "\u0353"=>220, "\u0354"=>220, "\u0355"=>220, "\u0356"=>220, "\u0357"=>230, "\u0358"=>232,
    "\u0359"=>220, "\u035A"=>220, "\u035B"=>230, "\u035C"=>233, "\u035D"=>234, "\u035E"=>234, "\u035F"=>233, "\u0360"=>234,
    "\u0361"=>234, "\u0362"=>233, "\u0363"=>230, "\u0364"=>230, "\u0365"=>230, "\u0366"=>230, "\u0367"=>230, "\u0368"=>230,
    "\u0369"=>230, "\u036A"=>230, "\u036B"=>230, "\u036C"=>230, "\u036D"=>230, "\u036E"=>230, "\u036F"=>230, "\u0483"=>230,
    "\u0484"=>230, "\u0485"=>230, "\u0486"=>230, "\u0487"=>230, "\u0591"=>220, "\u0592"=>230, "\u0593"=>230, "\u0594"=>230,
    "\u0595"=>230, "\u0596"=>220, "\u0597"=>230, "\u0598"=>230, "\u0599"=>230, "\u059A"=>222, "\u059B"=>220, "\u059C"=>230,
    "\u059D"=>230, "\u059E"=>230, "\u059F"=>230, "\u05A0"=>230, "\u05A1"=>230, "\u05A2"=>220, "\u05A3"=>220, "\u05A4"=>220,
    "\u05A5"=>220, "\u05A6"=>220, "\u05A7"=>220, "\u05A8"=>230, "\u05A9"=>230, "\u05AA"=>220, "\u05AB"=>230, "\u05AC"=>230,
    "\u05AD"=>222, "\u05AE"=>228, "\u05AF"=>230, "\u05B0"=>10, "\u05B1"=>11, "\u05B2"=>12, "\u05B3"=>13, "\u05B4"=>14,
    "\u05B5"=>15, "\u05B6"=>16, "\u05B7"=>17, "\u05B8"=>18, "\u05B9"=>19, "\u05BA"=>19, "\u05BB"=>20, "\u05BC"=>21,
    "\u05BD"=>22, "\u05BF"=>23, "\u05C1"=>24, "\u05C2"=>25, "\u05C4"=>230, "\u05C5"=>220, "\u05C7"=>18, "\u0610"=>230,
    "\u0611"=>230, "\u0612"=>230, "\u0613"=>230, "\u0614"=>230, "\u0615"=>230, "\u0616"=>230, "\u0617"=>230, "\u0618"=>30,
    "\u0619"=>31, "\u061A"=>32, "\u064B"=>27, "\u064C"=>28, "\u064D"=>29, "\u064E"=>30, "\u064F"=>31, "\u0650"=>32,
    "\u0651"=>33, "\u0652"=>34, "\u0653"=>230, "\u0654"=>230, "\u0655"=>220, "\u0656"=>220, "\u0657"=>230, "\u0658"=>230,
    "\u0659"=>230, "\u065A"=>230, "\u065B"=>230, "\u065C"=>220, "\u065D"=>230, "\u065E"=>230, "\u065F"=>220, "\u0670"=>35,
    "\u06D6"=>230, "\u06D7"=>230, "\u06D8"=>230, "\u06D9"=>230, "\u06DA"=>230, "\u06DB"=>230, "\u06DC"=>230, "\u06DF"=>230,
    "\u06E0"=>230, "\u06E1"=>230, "\u06E2"=>230, "\u06E3"=>220, "\u06E4"=>230, "\u06E7"=>230, "\u06E8"=>230, "\u06EA"=>220,
    "\u06EB"=>230, "\u06EC"=>230, "\u06ED"=>220, "\u0711"=>36, "\u0730"=>230, "\u0731"=>220, "\u0732"=>230, "\u0733"=>230,
    "\u0734"=>220, "\u0735"=>230, "\u0736"=>230, "\u0737"=>220, "\u0738"=>220, "\u0739"=>220, "\u073A"=>230, "\u073B"=>220,
    "\u073C"=>220, "\u073D"=>230, "\u073E"=>220, "\u073F"=>230, "\u0740"=>230, "\u0741"=>230, "\u0742"=>220, "\u0743"=>230,
    "\u0744"=>220, "\u0745"=>230, "\u0746"=>220, "\u0747"=>230, "\u0748"=>220, "\u0749"=>230, "\u074A"=>230, "\u07EB"=>230,
    "\u07EC"=>230, "\u07ED"=>230, "\u07EE"=>230, "\u07EF"=>230, "\u07F0"=>230, "\u07F1"=>230, "\u07F2"=>220, "\u07F3"=>230,
    "\u0816"=>230, "\u0817"=>230, "\u0818"=>230, "\u0819"=>230, "\u081B"=>230, "\u081C"=>230, "\u081D"=>230, "\u081E"=>230,
    "\u081F"=>230, "\u0820"=>230, "\u0821"=>230, "\u0822"=>230, "\u0823"=>230, "\u0825"=>230, "\u0826"=>230, "\u0827"=>230,
    "\u0829"=>230, "\u082A"=>230, "\u082B"=>230, "\u082C"=>230, "\u082D"=>230, "\u0859"=>220, "\u085A"=>220, "\u085B"=>220,
    "\u08E4"=>230, "\u08E5"=>230, "\u08E6"=>220, "\u08E7"=>230, "\u08E8"=>230, "\u08E9"=>220, "\u08EA"=>230, "\u08EB"=>230,
    "\u08EC"=>230, "\u08ED"=>220, "\u08EE"=>220, "\u08EF"=>220, "\u08F0"=>27, "\u08F1"=>28, "\u08F2"=>29, "\u08F3"=>230,
    "\u08F4"=>230, "\u08F5"=>230, "\u08F6"=>220, "\u08F7"=>230, "\u08F8"=>230, "\u08F9"=>220, "\u08FA"=>220, "\u08FB"=>230,
    "\u08FC"=>230, "\u08FD"=>230, "\u08FE"=>230, "\u08FF"=>230, "\u093C"=>7, "\u094D"=>9, "\u0951"=>230, "\u0952"=>220,
    "\u0953"=>230, "\u0954"=>230, "\u09BC"=>7, "\u09CD"=>9, "\u0A3C"=>7, "\u0A4D"=>9, "\u0ABC"=>7, "\u0ACD"=>9,
    "\u0B3C"=>7, "\u0B4D"=>9, "\u0BCD"=>9, "\u0C4D"=>9, "\u0C55"=>84, "\u0C56"=>91, "\u0CBC"=>7, "\u0CCD"=>9,
    "\u0D4D"=>9, "\u0DCA"=>9, "\u0E38"=>103, "\u0E39"=>103, "\u0E3A"=>9, "\u0E48"=>107, "\u0E49"=>107, "\u0E4A"=>107,
    "\u0E4B"=>107, "\u0EB8"=>118, "\u0EB9"=>118, "\u0EC8"=>122, "\u0EC9"=>122, "\u0ECA"=>122, "\u0ECB"=>122, "\u0F18"=>220,
    "\u0F19"=>220, "\u0F35"=>220, "\u0F37"=>220, "\u0F39"=>216, "\u0F71"=>129, "\u0F72"=>130, "\u0F74"=>132, "\u0F7A"=>130,
    "\u0F7B"=>130, "\u0F7C"=>130, "\u0F7D"=>130, "\u0F80"=>130, "\u0F82"=>230, "\u0F83"=>230, "\u0F84"=>9, "\u0F86"=>230,
    "\u0F87"=>230, "\u0FC6"=>220, "\u1037"=>7, "\u1039"=>9, "\u103A"=>9, "\u108D"=>220, "\u135D"=>230, "\u135E"=>230,
    "\u135F"=>230, "\u1714"=>9, "\u1734"=>9, "\u17D2"=>9, "\u17DD"=>230, "\u18A9"=>228, "\u1939"=>222, "\u193A"=>230,
    "\u193B"=>220, "\u1A17"=>230, "\u1A18"=>220, "\u1A60"=>9, "\u1A75"=>230, "\u1A76"=>230, "\u1A77"=>230, "\u1A78"=>230,
    "\u1A79"=>230, "\u1A7A"=>230, "\u1A7B"=>230, "\u1A7C"=>230, "\u1A7F"=>220, "\u1AB0"=>230, "\u1AB1"=>230, "\u1AB2"=>230,
    "\u1AB3"=>230, "\u1AB4"=>230, "\u1AB5"=>220, "\u1AB6"=>220, "\u1AB7"=>220, "\u1AB8"=>220, "\u1AB9"=>220, "\u1ABA"=>220,
    "\u1ABB"=>230, "\u1ABC"=>230, "\u1ABD"=>220, "\u1B34"=>7, "\u1B44"=>9, "\u1B6B"=>230, "\u1B6C"=>220, "\u1B6D"=>230,
    "\u1B6E"=>230, "\u1B6F"=>230, "\u1B70"=>230, "\u1B71"=>230, "\u1B72"=>230, "\u1B73"=>230, "\u1BAA"=>9, "\u1BAB"=>9,
    "\u1BE6"=>7, "\u1BF2"=>9, "\u1BF3"=>9, "\u1C37"=>7, "\u1CD0"=>230, "\u1CD1"=>230, "\u1CD2"=>230, "\u1CD4"=>1,
    "\u1CD5"=>220, "\u1CD6"=>220, "\u1CD7"=>220, "\u1CD8"=>220, "\u1CD9"=>220, "\u1CDA"=>230, "\u1CDB"=>230, "\u1CDC"=>220,
    "\u1CDD"=>220, "\u1CDE"=>220, "\u1CDF"=>220, "\u1CE0"=>230, "\u1CE2"=>1, "\u1CE3"=>1, "\u1CE4"=>1, "\u1CE5"=>1,
    "\u1CE6"=>1, "\u1CE7"=>1, "\u1CE8"=>1, "\u1CED"=>220, "\u1CF4"=>230, "\u1CF8"=>230, "\u1CF9"=>230, "\u1DC0"=>230,
    "\u1DC1"=>230, "\u1DC2"=>220, "\u1DC3"=>230, "\u1DC4"=>230, "\u1DC5"=>230, "\u1DC6"=>230, "\u1DC7"=>230, "\u1DC8"=>230,
    "\u1DC9"=>230, "\u1DCA"=>220, "\u1DCB"=>230, "\u1DCC"=>230, "\u1DCD"=>234, "\u1DCE"=>214, "\u1DCF"=>220, "\u1DD0"=>202,
    "\u1DD1"=>230, "\u1DD2"=>230, "\u1DD3"=>230, "\u1DD4"=>230, "\u1DD5"=>230, "\u1DD6"=>230, "\u1DD7"=>230, "\u1DD8"=>230,
    "\u1DD9"=>230, "\u1DDA"=>230, "\u1DDB"=>230, "\u1DDC"=>230, "\u1DDD"=>230, "\u1DDE"=>230, "\u1DDF"=>230, "\u1DE0"=>230,
    "\u1DE1"=>230, "\u1DE2"=>230, "\u1DE3"=>230, "\u1DE4"=>230, "\u1DE5"=>230, "\u1DE6"=>230, "\u1DE7"=>230, "\u1DE8"=>230,
    "\u1DE9"=>230, "\u1DEA"=>230, "\u1DEB"=>230, "\u1DEC"=>230, "\u1DED"=>230, "\u1DEE"=>230, "\u1DEF"=>230, "\u1DF0"=>230,
    "\u1DF1"=>230, "\u1DF2"=>230, "\u1DF3"=>230, "\u1DF4"=>230, "\u1DF5"=>230, "\u1DFC"=>233, "\u1DFD"=>220, "\u1DFE"=>230,
    "\u1DFF"=>220, "\u20D0"=>230, "\u20D1"=>230, "\u20D2"=>1, "\u20D3"=>1, "\u20D4"=>230, "\u20D5"=>230, "\u20D6"=>230,
    "\u20D7"=>230, "\u20D8"=>1, "\u20D9"=>1, "\u20DA"=>1, "\u20DB"=>230, "\u20DC"=>230, "\u20E1"=>230, "\u20E5"=>1,
    "\u20E6"=>1, "\u20E7"=>230, "\u20E8"=>220, "\u20E9"=>230, "\u20EA"=>1, "\u20EB"=>1, "\u20EC"=>220, "\u20ED"=>220,
    "\u20EE"=>220, "\u20EF"=>220, "\u20F0"=>230, "\u2CEF"=>230, "\u2CF0"=>230, "\u2CF1"=>230, "\u2D7F"=>9, "\u2DE0"=>230,
    "\u2DE1"=>230, "\u2DE2"=>230, "\u2DE3"=>230, "\u2DE4"=>230, "\u2DE5"=>230, "\u2DE6"=>230, "\u2DE7"=>230, "\u2DE8"=>230,
    "\u2DE9"=>230, "\u2DEA"=>230, "\u2DEB"=>230, "\u2DEC"=>230, "\u2DED"=>230, "\u2DEE"=>230, "\u2DEF"=>230, "\u2DF0"=>230,
    "\u2DF1"=>230, "\u2DF2"=>230, "\u2DF3"=>230, "\u2DF4"=>230, "\u2DF5"=>230, "\u2DF6"=>230, "\u2DF7"=>230, "\u2DF8"=>230,
    "\u2DF9"=>230, "\u2DFA"=>230, "\u2DFB"=>230, "\u2DFC"=>230, "\u2DFD"=>230, "\u2DFE"=>230, "\u2DFF"=>230, "\u302A"=>218,
    "\u302B"=>228, "\u302C"=>232, "\u302D"=>222, "\u302E"=>224, "\u302F"=>224, "\u3099"=>8, "\u309A"=>8, "\uA66F"=>230,
    "\uA674"=>230, "\uA675"=>230, "\uA676"=>230, "\uA677"=>230, "\uA678"=>230, "\uA679"=>230, "\uA67A"=>230, "\uA67B"=>230,
    "\uA67C"=>230, "\uA67D"=>230, "\uA69F"=>230, "\uA6F0"=>230, "\uA6F1"=>230, "\uA806"=>9, "\uA8C4"=>9, "\uA8E0"=>230,
    "\uA8E1"=>230, "\uA8E2"=>230, "\uA8E3"=>230, "\uA8E4"=>230, "\uA8E5"=>230, "\uA8E6"=>230, "\uA8E7"=>230, "\uA8E8"=>230,
    "\uA8E9"=>230, "\uA8EA"=>230, "\uA8EB"=>230, "\uA8EC"=>230, "\uA8ED"=>230, "\uA8EE"=>230, "\uA8EF"=>230, "\uA8F0"=>230,
    "\uA8F1"=>230, "\uA92B"=>220, "\uA92C"=>220, "\uA92D"=>220, "\uA953"=>9, "\uA9B3"=>7, "\uA9C0"=>9, "\uAAB0"=>230,
    "\uAAB2"=>230, "\uAAB3"=>230, "\uAAB4"=>220, "\uAAB7"=>230, "\uAAB8"=>230, "\uAABE"=>230, "\uAABF"=>230, "\uAAC1"=>230,
    "\uAAF6"=>9, "\uABED"=>9, "\uFB1E"=>26, "\uFE20"=>230, "\uFE21"=>230, "\uFE22"=>230, "\uFE23"=>230, "\uFE24"=>230,
    "\uFE25"=>230, "\uFE26"=>230, "\uFE27"=>220, "\uFE28"=>220, "\uFE29"=>220, "\uFE2A"=>220, "\uFE2B"=>220, "\uFE2C"=>220,
    "\uFE2D"=>220, "\u{101FD}"=>220, "\u{102E0}"=>220, "\u{10376}"=>230, "\u{10377}"=>230, "\u{10378}"=>230, "\u{10379}"=>230, "\u{1037A}"=>230,
    "\u{10A0D}"=>220, "\u{10A0F}"=>230, "\u{10A38}"=>230, "\u{10A39}"=>1, "\u{10A3A}"=>220, "\u{10A3F}"=>9, "\u{10AE5}"=>230, "\u{10AE6}"=>220,
    "\u{11046}"=>9, "\u{1107F}"=>9, "\u{110B9}"=>9, "\u{110BA}"=>7, "\u{11100}"=>230, "\u{11101}"=>230, "\u{11102}"=>230, "\u{11133}"=>9,
    "\u{11134}"=>9, "\u{11173}"=>7, "\u{111C0}"=>9, "\u{11235}"=>9, "\u{11236}"=>7, "\u{112E9}"=>7, "\u{112EA}"=>9, "\u{1133C}"=>7,
    "\u{1134D}"=>9, "\u{11366}"=>230, "\u{11367}"=>230, "\u{11368}"=>230, "\u{11369}"=>230, "\u{1136A}"=>230, "\u{1136B}"=>230, "\u{1136C}"=>230,
    "\u{11370}"=>230, "\u{11371}"=>230, "\u{11372}"=>230, "\u{11373}"=>230, "\u{11374}"=>230, "\u{114C2}"=>9, "\u{114C3}"=>7, "\u{115BF}"=>9,
    "\u{115C0}"=>7, "\u{1163F}"=>9, "\u{116B6}"=>9, "\u{116B7}"=>7, "\u{16AF0}"=>1, "\u{16AF1}"=>1, "\u{16AF2}"=>1, "\u{16AF3}"=>1,
    "\u{16AF4}"=>1, "\u{16B30}"=>230, "\u{16B31}"=>230, "\u{16B32}"=>230, "\u{16B33}"=>230, "\u{16B34}"=>230, "\u{16B35}"=>230, "\u{16B36}"=>230,
    "\u{1BC9E}"=>1, "\u{1D165}"=>216, "\u{1D166}"=>216, "\u{1D167}"=>1, "\u{1D168}"=>1, "\u{1D169}"=>1, "\u{1D16D}"=>226, "\u{1D16E}"=>216,
    "\u{1D16F}"=>216, "\u{1D170}"=>216, "\u{1D171}"=>216, "\u{1D172}"=>216, "\u{1D17B}"=>220, "\u{1D17C}"=>220, "\u{1D17D}"=>220, "\u{1D17E}"=>220,
    "\u{1D17F}"=>220, "\u{1D180}"=>220, "\u{1D181}"=>220, "\u{1D182}"=>220, "\u{1D185}"=>230, "\u{1D186}"=>230, "\u{1D187}"=>230, "\u{1D188}"=>230,
    "\u{1D189}"=>230, "\u{1D18A}"=>220, "\u{1D18B}"=>220, "\u{1D1AA}"=>230, "\u{1D1AB}"=>230, "\u{1D1AC}"=>230, "\u{1D1AD}"=>230, "\u{1D242}"=>230,
    "\u{1D243}"=>230, "\u{1D244}"=>230, "\u{1E8D0}"=>220, "\u{1E8D1}"=>220, "\u{1E8D2}"=>220, "\u{1E8D3}"=>220, "\u{1E8D4}"=>220, "\u{1E8D5}"=>220,
    "\u{1E8D6}"=>220,
  }
  class_table.default = 0
  CLASS_TABLE = class_table.freeze

  DECOMPOSITION_TABLE = {
    "\u00C0"=>"A\u0300".freeze, "\u00C1"=>"A\u0301".freeze, "\u00C2"=>"A\u0302".freeze, "\u00C3"=>"A\u0303".freeze, "\u00C4"=>"A\u0308".freeze, "\u00C5"=>"A\u030A".freeze, "\u00C7"=>"C\u0327".freeze, "\u00C8"=>"E\u0300".freeze,
    "\u00C9"=>"E\u0301".freeze, "\u00CA"=>"E\u0302".freeze, "\u00CB"=>"E\u0308".freeze, "\u00CC"=>"I\u0300".freeze, "\u00CD"=>"I\u0301".freeze, "\u00CE"=>"I\u0302".freeze, "\u00CF"=>"I\u0308".freeze, "\u00D1"=>"N\u0303".freeze,
    "\u00D2"=>"O\u0300".freeze, "\u00D3"=>"O\u0301".freeze, "\u00D4"=>"O\u0302".freeze, "\u00D5"=>"O\u0303".freeze, "\u00D6"=>"O\u0308".freeze, "\u00D9"=>"U\u0300".freeze, "\u00DA"=>"U\u0301".freeze, "\u00DB"=>"U\u0302".freeze,
    "\u00DC"=>"U\u0308".freeze, "\u00DD"=>"Y\u0301".freeze, "\u00E0"=>"a\u0300".freeze, "\u00E1"=>"a\u0301".freeze, "\u00E2"=>"a\u0302".freeze, "\u00E3"=>"a\u0303".freeze, "\u00E4"=>"a\u0308".freeze, "\u00E5"=>"a\u030A".freeze,
    "\u00E7"=>"c\u0327".freeze, "\u00E8"=>"e\u0300".freeze, "\u00E9"=>"e\u0301".freeze, "\u00EA"=>"e\u0302".freeze, "\u00EB"=>"e\u0308".freeze, "\u00EC"=>"i\u0300".freeze, "\u00ED"=>"i\u0301".freeze, "\u00EE"=>"i\u0302".freeze,
    "\u00EF"=>"i\u0308".freeze, "\u00F1"=>"n\u0303".freeze, "\u00F2"=>"o\u0300".freeze, "\u00F3"=>"o\u0301".freeze, "\u00F4"=>"o\u0302".freeze, "\u00F5"=>"o\u0303".freeze, "\u00F6"=>"o\u0308".freeze, "\u00F9"=>"u\u0300".freeze,
    "\u00FA"=>"u\u0301".freeze, "\u00FB"=>"u\u0302".freeze, "\u00FC"=>"u\u0308".freeze, "\u00FD"=>"y\u0301".freeze, "\u00FF"=>"y\u0308".freeze, "\u0100"=>"A\u0304".freeze, "\u0101"=>"a\u0304".freeze, "\u0102"=>"A\u0306".freeze,
    "\u0103"=>"a\u0306".freeze, "\u0104"=>"A\u0328".freeze, "\u0105"=>"a\u0328".freeze, "\u0106"=>"C\u0301".freeze, "\u0107"=>"c\u0301".freeze, "\u0108"=>"C\u0302".freeze, "\u0109"=>"c\u0302".freeze, "\u010A"=>"C\u0307".freeze,
    "\u010B"=>"c\u0307".freeze, "\u010C"=>"C\u030C".freeze, "\u010D"=>"c\u030C".freeze, "\u010E"=>"D\u030C".freeze, "\u010F"=>"d\u030C".freeze, "\u0112"=>"E\u0304".freeze, "\u0113"=>"e\u0304".freeze, "\u0114"=>"E\u0306".freeze,
    "\u0115"=>"e\u0306".freeze, "\u0116"=>"E\u0307".freeze, "\u0117"=>"e\u0307".freeze, "\u0118"=>"E\u0328".freeze, "\u0119"=>"e\u0328".freeze, "\u011A"=>"E\u030C".freeze, "\u011B"=>"e\u030C".freeze, "\u011C"=>"G\u0302".freeze,
    "\u011D"=>"g\u0302".freeze, "\u011E"=>"G\u0306".freeze, "\u011F"=>"g\u0306".freeze, "\u0120"=>"G\u0307".freeze, "\u0121"=>"g\u0307".freeze, "\u0122"=>"G\u0327".freeze, "\u0123"=>"g\u0327".freeze, "\u0124"=>"H\u0302".freeze,
    "\u0125"=>"h\u0302".freeze, "\u0128"=>"I\u0303".freeze, "\u0129"=>"i\u0303".freeze, "\u012A"=>"I\u0304".freeze, "\u012B"=>"i\u0304".freeze, "\u012C"=>"I\u0306".freeze, "\u012D"=>"i\u0306".freeze, "\u012E"=>"I\u0328".freeze,
    "\u012F"=>"i\u0328".freeze, "\u0130"=>"I\u0307".freeze, "\u0134"=>"J\u0302".freeze, "\u0135"=>"j\u0302".freeze, "\u0136"=>"K\u0327".freeze, "\u0137"=>"k\u0327".freeze, "\u0139"=>"L\u0301".freeze, "\u013A"=>"l\u0301".freeze,
    "\u013B"=>"L\u0327".freeze, "\u013C"=>"l\u0327".freeze, "\u013D"=>"L\u030C".freeze, "\u013E"=>"l\u030C".freeze, "\u0143"=>"N\u0301".freeze, "\u0144"=>"n\u0301".freeze, "\u0145"=>"N\u0327".freeze, "\u0146"=>"n\u0327".freeze,
    "\u0147"=>"N\u030C".freeze, "\u0148"=>"n\u030C".freeze, "\u014C"=>"O\u0304".freeze, "\u014D"=>"o\u0304".freeze, "\u014E"=>"O\u0306".freeze, "\u014F"=>"o\u0306".freeze, "\u0150"=>"O\u030B".freeze, "\u0151"=>"o\u030B".freeze,
    "\u0154"=>"R\u0301".freeze, "\u0155"=>"r\u0301".freeze, "\u0156"=>"R\u0327".freeze, "\u0157"=>"r\u0327".freeze, "\u0158"=>"R\u030C".freeze, "\u0159"=>"r\u030C".freeze, "\u015A"=>"S\u0301".freeze, "\u015B"=>"s\u0301".freeze,
    "\u015C"=>"S\u0302".freeze, "\u015D"=>"s\u0302".freeze, "\u015E"=>"S\u0327".freeze, "\u015F"=>"s\u0327".freeze, "\u0160"=>"S\u030C".freeze, "\u0161"=>"s\u030C".freeze, "\u0162"=>"T\u0327".freeze, "\u0163"=>"t\u0327".freeze,
    "\u0164"=>"T\u030C".freeze, "\u0165"=>"t\u030C".freeze, "\u0168"=>"U\u0303".freeze, "\u0169"=>"u\u0303".freeze, "\u016A"=>"U\u0304".freeze, "\u016B"=>"u\u0304".freeze, "\u016C"=>"U\u0306".freeze, "\u016D"=>"u\u0306".freeze,
    "\u016E"=>"U\u030A".freeze, "\u016F"=>"u\u030A".freeze, "\u0170"=>"U\u030B".freeze, "\u0171"=>"u\u030B".freeze, "\u0172"=>"U\u0328".freeze, "\u0173"=>"u\u0328".freeze, "\u0174"=>"W\u0302".freeze, "\u0175"=>"w\u0302".freeze,
    "\u0176"=>"Y\u0302".freeze, "\u0177"=>"y\u0302".freeze, "\u0178"=>"Y\u0308".freeze, "\u0179"=>"Z\u0301".freeze, "\u017A"=>"z\u0301".freeze, "\u017B"=>"Z\u0307".freeze, "\u017C"=>"z\u0307".freeze, "\u017D"=>"Z\u030C".freeze,
    "\u017E"=>"z\u030C".freeze, "\u01A0"=>"O\u031B".freeze, "\u01A1"=>"o\u031B".freeze, "\u01AF"=>"U\u031B".freeze, "\u01B0"=>"u\u031B".freeze, "\u01CD"=>"A\u030C".freeze, "\u01CE"=>"a\u030C".freeze, "\u01CF"=>"I\u030C".freeze,
    "\u01D0"=>"i\u030C".freeze, "\u01D1"=>"O\u030C".freeze, "\u01D2"=>"o\u030C".freeze, "\u01D3"=>"U\u030C".freeze, "\u01D4"=>"u\u030C".freeze, "\u01D5"=>"U\u0308\u0304".freeze, "\u01D6"=>"u\u0308\u0304".freeze, "\u01D7"=>"U\u0308\u0301".freeze,
    "\u01D8"=>"u\u0308\u0301".freeze, "\u01D9"=>"U\u0308\u030C".freeze, "\u01DA"=>"u\u0308\u030C".freeze, "\u01DB"=>"U\u0308\u0300".freeze, "\u01DC"=>"u\u0308\u0300".freeze, "\u01DE"=>"A\u0308\u0304".freeze, "\u01DF"=>"a\u0308\u0304".freeze, "\u01E0"=>"A\u0307\u0304".freeze,
    "\u01E1"=>"a\u0307\u0304".freeze, "\u01E2"=>"\u00C6\u0304".freeze, "\u01E3"=>"\u00E6\u0304".freeze, "\u01E6"=>"G\u030C".freeze, "\u01E7"=>"g\u030C".freeze, "\u01E8"=>"K\u030C".freeze, "\u01E9"=>"k\u030C".freeze, "\u01EA"=>"O\u0328".freeze,
    "\u01EB"=>"o\u0328".freeze, "\u01EC"=>"O\u0328\u0304".freeze, "\u01ED"=>"o\u0328\u0304".freeze, "\u01EE"=>"\u01B7\u030C".freeze, "\u01EF"=>"\u0292\u030C".freeze, "\u01F0"=>"j\u030C".freeze, "\u01F4"=>"G\u0301".freeze, "\u01F5"=>"g\u0301".freeze,
    "\u01F8"=>"N\u0300".freeze, "\u01F9"=>"n\u0300".freeze, "\u01FA"=>"A\u030A\u0301".freeze, "\u01FB"=>"a\u030A\u0301".freeze, "\u01FC"=>"\u00C6\u0301".freeze, "\u01FD"=>"\u00E6\u0301".freeze, "\u01FE"=>"\u00D8\u0301".freeze, "\u01FF"=>"\u00F8\u0301".freeze,
    "\u0200"=>"A\u030F".freeze, "\u0201"=>"a\u030F".freeze, "\u0202"=>"A\u0311".freeze, "\u0203"=>"a\u0311".freeze, "\u0204"=>"E\u030F".freeze, "\u0205"=>"e\u030F".freeze, "\u0206"=>"E\u0311".freeze, "\u0207"=>"e\u0311".freeze,
    "\u0208"=>"I\u030F".freeze, "\u0209"=>"i\u030F".freeze, "\u020A"=>"I\u0311".freeze, "\u020B"=>"i\u0311".freeze, "\u020C"=>"O\u030F".freeze, "\u020D"=>"o\u030F".freeze, "\u020E"=>"O\u0311".freeze, "\u020F"=>"o\u0311".freeze,
    "\u0210"=>"R\u030F".freeze, "\u0211"=>"r\u030F".freeze, "\u0212"=>"R\u0311".freeze, "\u0213"=>"r\u0311".freeze, "\u0214"=>"U\u030F".freeze, "\u0215"=>"u\u030F".freeze, "\u0216"=>"U\u0311".freeze, "\u0217"=>"u\u0311".freeze,
    "\u0218"=>"S\u0326".freeze, "\u0219"=>"s\u0326".freeze, "\u021A"=>"T\u0326".freeze, "\u021B"=>"t\u0326".freeze, "\u021E"=>"H\u030C".freeze, "\u021F"=>"h\u030C".freeze, "\u0226"=>"A\u0307".freeze, "\u0227"=>"a\u0307".freeze,
    "\u0228"=>"E\u0327".freeze, "\u0229"=>"e\u0327".freeze, "\u022A"=>"O\u0308\u0304".freeze, "\u022B"=>"o\u0308\u0304".freeze, "\u022C"=>"O\u0303\u0304".freeze, "\u022D"=>"o\u0303\u0304".freeze, "\u022E"=>"O\u0307".freeze, "\u022F"=>"o\u0307".freeze,
    "\u0230"=>"O\u0307\u0304".freeze, "\u0231"=>"o\u0307\u0304".freeze, "\u0232"=>"Y\u0304".freeze, "\u0233"=>"y\u0304".freeze, "\u0340"=>"\u0300".freeze, "\u0341"=>"\u0301".freeze, "\u0343"=>"\u0313".freeze, "\u0344"=>"\u0308\u0301".freeze,
    "\u0374"=>"\u02B9".freeze, "\u037E"=>";".freeze, "\u0385"=>"\u00A8\u0301".freeze, "\u0386"=>"\u0391\u0301".freeze, "\u0387"=>"\u00B7".freeze, "\u0388"=>"\u0395\u0301".freeze, "\u0389"=>"\u0397\u0301".freeze, "\u038A"=>"\u0399\u0301".freeze,
    "\u038C"=>"\u039F\u0301".freeze, "\u038E"=>"\u03A5\u0301".freeze, "\u038F"=>"\u03A9\u0301".freeze, "\u0390"=>"\u03B9\u0308\u0301".freeze, "\u03AA"=>"\u0399\u0308".freeze, "\u03AB"=>"\u03A5\u0308".freeze, "\u03AC"=>"\u03B1\u0301".freeze, "\u03AD"=>"\u03B5\u0301".freeze,
    "\u03AE"=>"\u03B7\u0301".freeze, "\u03AF"=>"\u03B9\u0301".freeze, "\u03B0"=>"\u03C5\u0308\u0301".freeze, "\u03CA"=>"\u03B9\u0308".freeze, "\u03CB"=>"\u03C5\u0308".freeze, "\u03CC"=>"\u03BF\u0301".freeze, "\u03CD"=>"\u03C5\u0301".freeze, "\u03CE"=>"\u03C9\u0301".freeze,
    "\u03D3"=>"\u03D2\u0301".freeze, "\u03D4"=>"\u03D2\u0308".freeze, "\u0400"=>"\u0415\u0300".freeze, "\u0401"=>"\u0415\u0308".freeze, "\u0403"=>"\u0413\u0301".freeze, "\u0407"=>"\u0406\u0308".freeze, "\u040C"=>"\u041A\u0301".freeze, "\u040D"=>"\u0418\u0300".freeze,
    "\u040E"=>"\u0423\u0306".freeze, "\u0419"=>"\u0418\u0306".freeze, "\u0439"=>"\u0438\u0306".freeze, "\u0450"=>"\u0435\u0300".freeze, "\u0451"=>"\u0435\u0308".freeze, "\u0453"=>"\u0433\u0301".freeze, "\u0457"=>"\u0456\u0308".freeze, "\u045C"=>"\u043A\u0301".freeze,
    "\u045D"=>"\u0438\u0300".freeze, "\u045E"=>"\u0443\u0306".freeze, "\u0476"=>"\u0474\u030F".freeze, "\u0477"=>"\u0475\u030F".freeze, "\u04C1"=>"\u0416\u0306".freeze, "\u04C2"=>"\u0436\u0306".freeze, "\u04D0"=>"\u0410\u0306".freeze, "\u04D1"=>"\u0430\u0306".freeze,
    "\u04D2"=>"\u0410\u0308".freeze, "\u04D3"=>"\u0430\u0308".freeze, "\u04D6"=>"\u0415\u0306".freeze, "\u04D7"=>"\u0435\u0306".freeze, "\u04DA"=>"\u04D8\u0308".freeze, "\u04DB"=>"\u04D9\u0308".freeze, "\u04DC"=>"\u0416\u0308".freeze, "\u04DD"=>"\u0436\u0308".freeze,
    "\u04DE"=>"\u0417\u0308".freeze, "\u04DF"=>"\u0437\u0308".freeze, "\u04E2"=>"\u0418\u0304".freeze, "\u04E3"=>"\u0438\u0304".freeze, "\u04E4"=>"\u0418\u0308".freeze, "\u04E5"=>"\u0438\u0308".freeze, "\u04E6"=>"\u041E\u0308".freeze, "\u04E7"=>"\u043E\u0308".freeze,
    "\u04EA"=>"\u04E8\u0308".freeze, "\u04EB"=>"\u04E9\u0308".freeze, "\u04EC"=>"\u042D\u0308".freeze, "\u04ED"=>"\u044D\u0308".freeze, "\u04EE"=>"\u0423\u0304".freeze, "\u04EF"=>"\u0443\u0304".freeze, "\u04F0"=>"\u0423\u0308".freeze, "\u04F1"=>"\u0443\u0308".freeze,
    "\u04F2"=>"\u0423\u030B".freeze, "\u04F3"=>"\u0443\u030B".freeze, "\u04F4"=>"\u0427\u0308".freeze, "\u04F5"=>"\u0447\u0308".freeze, "\u04F8"=>"\u042B\u0308".freeze, "\u04F9"=>"\u044B\u0308".freeze, "\u0622"=>"\u0627\u0653".freeze, "\u0623"=>"\u0627\u0654".freeze,
    "\u0624"=>"\u0648\u0654".freeze, "\u0625"=>"\u0627\u0655".freeze, "\u0626"=>"\u064A\u0654".freeze, "\u06C0"=>"\u06D5\u0654".freeze, "\u06C2"=>"\u06C1\u0654".freeze, "\u06D3"=>"\u06D2\u0654".freeze, "\u0929"=>"\u0928\u093C".freeze, "\u0931"=>"\u0930\u093C".freeze,
    "\u0934"=>"\u0933\u093C".freeze, "\u0958"=>"\u0915\u093C".freeze, "\u0959"=>"\u0916\u093C".freeze, "\u095A"=>"\u0917\u093C".freeze, "\u095B"=>"\u091C\u093C".freeze, "\u095C"=>"\u0921\u093C".freeze, "\u095D"=>"\u0922\u093C".freeze, "\u095E"=>"\u092B\u093C".freeze,
    "\u095F"=>"\u092F\u093C".freeze, "\u09CB"=>"\u09C7\u09BE".freeze, "\u09CC"=>"\u09C7\u09D7".freeze, "\u09DC"=>"\u09A1\u09BC".freeze, "\u09DD"=>"\u09A2\u09BC".freeze, "\u09DF"=>"\u09AF\u09BC".freeze, "\u0A33"=>"\u0A32\u0A3C".freeze, "\u0A36"=>"\u0A38\u0A3C".freeze,
    "\u0A59"=>"\u0A16\u0A3C".freeze, "\u0A5A"=>"\u0A17\u0A3C".freeze, "\u0A5B"=>"\u0A1C\u0A3C".freeze, "\u0A5E"=>"\u0A2B\u0A3C".freeze, "\u0B48"=>"\u0B47\u0B56".freeze, "\u0B4B"=>"\u0B47\u0B3E".freeze, "\u0B4C"=>"\u0B47\u0B57".freeze, "\u0B5C"=>"\u0B21\u0B3C".freeze,
    "\u0B5D"=>"\u0B22\u0B3C".freeze, "\u0B94"=>"\u0B92\u0BD7".freeze, "\u0BCA"=>"\u0BC6\u0BBE".freeze, "\u0BCB"=>"\u0BC7\u0BBE".freeze, "\u0BCC"=>"\u0BC6\u0BD7".freeze, "\u0C48"=>"\u0C46\u0C56".freeze, "\u0CC0"=>"\u0CBF\u0CD5".freeze, "\u0CC7"=>"\u0CC6\u0CD5".freeze,
    "\u0CC8"=>"\u0CC6\u0CD6".freeze, "\u0CCA"=>"\u0CC6\u0CC2".freeze, "\u0CCB"=>"\u0CC6\u0CC2\u0CD5".freeze, "\u0D4A"=>"\u0D46\u0D3E".freeze, "\u0D4B"=>"\u0D47\u0D3E".freeze, "\u0D4C"=>"\u0D46\u0D57".freeze, "\u0DDA"=>"\u0DD9\u0DCA".freeze, "\u0DDC"=>"\u0DD9\u0DCF".freeze,
    "\u0DDD"=>"\u0DD9\u0DCF\u0DCA".freeze, "\u0DDE"=>"\u0DD9\u0DDF".freeze, "\u0F43"=>"\u0F42\u0FB7".freeze, "\u0F4D"=>"\u0F4C\u0FB7".freeze, "\u0F52"=>"\u0F51\u0FB7".freeze, "\u0F57"=>"\u0F56\u0FB7".freeze, "\u0F5C"=>"\u0F5B\u0FB7".freeze, "\u0F69"=>"\u0F40\u0FB5".freeze,
    "\u0F73"=>"\u0F71\u0F72".freeze, "\u0F75"=>"\u0F71\u0F74".freeze, "\u0F76"=>"\u0FB2\u0F80".freeze, "\u0F78"=>"\u0FB3\u0F80".freeze, "\u0F81"=>"\u0F71\u0F80".freeze, "\u0F93"=>"\u0F92\u0FB7".freeze, "\u0F9D"=>"\u0F9C\u0FB7".freeze, "\u0FA2"=>"\u0FA1\u0FB7".freeze,
    "\u0FA7"=>"\u0FA6\u0FB7".freeze, "\u0FAC"=>"\u0FAB\u0FB7".freeze, "\u0FB9"=>"\u0F90\u0FB5".freeze, "\u1026"=>"\u1025\u102E".freeze, "\u1B06"=>"\u1B05\u1B35".freeze, "\u1B08"=>"\u1B07\u1B35".freeze, "\u1B0A"=>"\u1B09\u1B35".freeze, "\u1B0C"=>"\u1B0B\u1B35".freeze,
    "\u1B0E"=>"\u1B0D\u1B35".freeze, "\u1B12"=>"\u1B11\u1B35".freeze, "\u1B3B"=>"\u1B3A\u1B35".freeze, "\u1B3D"=>"\u1B3C\u1B35".freeze, "\u1B40"=>"\u1B3E\u1B35".freeze, "\u1B41"=>"\u1B3F\u1B35".freeze, "\u1B43"=>"\u1B42\u1B35".freeze, "\u1E00"=>"A\u0325".freeze,
    "\u1E01"=>"a\u0325".freeze, "\u1E02"=>"B\u0307".freeze, "\u1E03"=>"b\u0307".freeze, "\u1E04"=>"B\u0323".freeze, "\u1E05"=>"b\u0323".freeze, "\u1E06"=>"B\u0331".freeze, "\u1E07"=>"b\u0331".freeze, "\u1E08"=>"C\u0327\u0301".freeze,
    "\u1E09"=>"c\u0327\u0301".freeze, "\u1E0A"=>"D\u0307".freeze, "\u1E0B"=>"d\u0307".freeze, "\u1E0C"=>"D\u0323".freeze, "\u1E0D"=>"d\u0323".freeze, "\u1E0E"=>"D\u0331".freeze, "\u1E0F"=>"d\u0331".freeze, "\u1E10"=>"D\u0327".freeze,
    "\u1E11"=>"d\u0327".freeze, "\u1E12"=>"D\u032D".freeze, "\u1E13"=>"d\u032D".freeze, "\u1E14"=>"E\u0304\u0300".freeze, "\u1E15"=>"e\u0304\u0300".freeze, "\u1E16"=>"E\u0304\u0301".freeze, "\u1E17"=>"e\u0304\u0301".freeze, "\u1E18"=>"E\u032D".freeze,
    "\u1E19"=>"e\u032D".freeze, "\u1E1A"=>"E\u0330".freeze, "\u1E1B"=>"e\u0330".freeze, "\u1E1C"=>"E\u0327\u0306".freeze, "\u1E1D"=>"e\u0327\u0306".freeze, "\u1E1E"=>"F\u0307".freeze, "\u1E1F"=>"f\u0307".freeze, "\u1E20"=>"G\u0304".freeze,
    "\u1E21"=>"g\u0304".freeze, "\u1E22"=>"H\u0307".freeze, "\u1E23"=>"h\u0307".freeze, "\u1E24"=>"H\u0323".freeze, "\u1E25"=>"h\u0323".freeze, "\u1E26"=>"H\u0308".freeze, "\u1E27"=>"h\u0308".freeze, "\u1E28"=>"H\u0327".freeze,
    "\u1E29"=>"h\u0327".freeze, "\u1E2A"=>"H\u032E".freeze, "\u1E2B"=>"h\u032E".freeze, "\u1E2C"=>"I\u0330".freeze, "\u1E2D"=>"i\u0330".freeze, "\u1E2E"=>"I\u0308\u0301".freeze, "\u1E2F"=>"i\u0308\u0301".freeze, "\u1E30"=>"K\u0301".freeze,
    "\u1E31"=>"k\u0301".freeze, "\u1E32"=>"K\u0323".freeze, "\u1E33"=>"k\u0323".freeze, "\u1E34"=>"K\u0331".freeze, "\u1E35"=>"k\u0331".freeze, "\u1E36"=>"L\u0323".freeze, "\u1E37"=>"l\u0323".freeze, "\u1E38"=>"L\u0323\u0304".freeze,
    "\u1E39"=>"l\u0323\u0304".freeze, "\u1E3A"=>"L\u0331".freeze, "\u1E3B"=>"l\u0331".freeze, "\u1E3C"=>"L\u032D".freeze, "\u1E3D"=>"l\u032D".freeze, "\u1E3E"=>"M\u0301".freeze, "\u1E3F"=>"m\u0301".freeze, "\u1E40"=>"M\u0307".freeze,
    "\u1E41"=>"m\u0307".freeze, "\u1E42"=>"M\u0323".freeze, "\u1E43"=>"m\u0323".freeze, "\u1E44"=>"N\u0307".freeze, "\u1E45"=>"n\u0307".freeze, "\u1E46"=>"N\u0323".freeze, "\u1E47"=>"n\u0323".freeze, "\u1E48"=>"N\u0331".freeze,
    "\u1E49"=>"n\u0331".freeze, "\u1E4A"=>"N\u032D".freeze, "\u1E4B"=>"n\u032D".freeze, "\u1E4C"=>"O\u0303\u0301".freeze, "\u1E4D"=>"o\u0303\u0301".freeze, "\u1E4E"=>"O\u0303\u0308".freeze, "\u1E4F"=>"o\u0303\u0308".freeze, "\u1E50"=>"O\u0304\u0300".freeze,
    "\u1E51"=>"o\u0304\u0300".freeze, "\u1E52"=>"O\u0304\u0301".freeze, "\u1E53"=>"o\u0304\u0301".freeze, "\u1E54"=>"P\u0301".freeze, "\u1E55"=>"p\u0301".freeze, "\u1E56"=>"P\u0307".freeze, "\u1E57"=>"p\u0307".freeze, "\u1E58"=>"R\u0307".freeze,
    "\u1E59"=>"r\u0307".freeze, "\u1E5A"=>"R\u0323".freeze, "\u1E5B"=>"r\u0323".freeze, "\u1E5C"=>"R\u0323\u0304".freeze, "\u1E5D"=>"r\u0323\u0304".freeze, "\u1E5E"=>"R\u0331".freeze, "\u1E5F"=>"r\u0331".freeze, "\u1E60"=>"S\u0307".freeze,
    "\u1E61"=>"s\u0307".freeze, "\u1E62"=>"S\u0323".freeze, "\u1E63"=>"s\u0323".freeze, "\u1E64"=>"S\u0301\u0307".freeze, "\u1E65"=>"s\u0301\u0307".freeze, "\u1E66"=>"S\u030C\u0307".freeze, "\u1E67"=>"s\u030C\u0307".freeze, "\u1E68"=>"S\u0323\u0307".freeze,
    "\u1E69"=>"s\u0323\u0307".freeze, "\u1E6A"=>"T\u0307".freeze, "\u1E6B"=>"t\u0307".freeze, "\u1E6C"=>"T\u0323".freeze, "\u1E6D"=>"t\u0323".freeze, "\u1E6E"=>"T\u0331".freeze, "\u1E6F"=>"t\u0331".freeze, "\u1E70"=>"T\u032D".freeze,
    "\u1E71"=>"t\u032D".freeze, "\u1E72"=>"U\u0324".freeze, "\u1E73"=>"u\u0324".freeze, "\u1E74"=>"U\u0330".freeze, "\u1E75"=>"u\u0330".freeze, "\u1E76"=>"U\u032D".freeze, "\u1E77"=>"u\u032D".freeze, "\u1E78"=>"U\u0303\u0301".freeze,
    "\u1E79"=>"u\u0303\u0301".freeze, "\u1E7A"=>"U\u0304\u0308".freeze, "\u1E7B"=>"u\u0304\u0308".freeze, "\u1E7C"=>"V\u0303".freeze, "\u1E7D"=>"v\u0303".freeze, "\u1E7E"=>"V\u0323".freeze, "\u1E7F"=>"v\u0323".freeze, "\u1E80"=>"W\u0300".freeze,
    "\u1E81"=>"w\u0300".freeze, "\u1E82"=>"W\u0301".freeze, "\u1E83"=>"w\u0301".freeze, "\u1E84"=>"W\u0308".freeze, "\u1E85"=>"w\u0308".freeze, "\u1E86"=>"W\u0307".freeze, "\u1E87"=>"w\u0307".freeze, "\u1E88"=>"W\u0323".freeze,
    "\u1E89"=>"w\u0323".freeze, "\u1E8A"=>"X\u0307".freeze, "\u1E8B"=>"x\u0307".freeze, "\u1E8C"=>"X\u0308".freeze, "\u1E8D"=>"x\u0308".freeze, "\u1E8E"=>"Y\u0307".freeze, "\u1E8F"=>"y\u0307".freeze, "\u1E90"=>"Z\u0302".freeze,
    "\u1E91"=>"z\u0302".freeze, "\u1E92"=>"Z\u0323".freeze, "\u1E93"=>"z\u0323".freeze, "\u1E94"=>"Z\u0331".freeze, "\u1E95"=>"z\u0331".freeze, "\u1E96"=>"h\u0331".freeze, "\u1E97"=>"t\u0308".freeze, "\u1E98"=>"w\u030A".freeze,
    "\u1E99"=>"y\u030A".freeze, "\u1E9B"=>"\u017F\u0307".freeze, "\u1EA0"=>"A\u0323".freeze, "\u1EA1"=>"a\u0323".freeze, "\u1EA2"=>"A\u0309".freeze, "\u1EA3"=>"a\u0309".freeze, "\u1EA4"=>"A\u0302\u0301".freeze, "\u1EA5"=>"a\u0302\u0301".freeze,
    "\u1EA6"=>"A\u0302\u0300".freeze, "\u1EA7"=>"a\u0302\u0300".freeze, "\u1EA8"=>"A\u0302\u0309".freeze, "\u1EA9"=>"a\u0302\u0309".freeze, "\u1EAA"=>"A\u0302\u0303".freeze, "\u1EAB"=>"a\u0302\u0303".freeze, "\u1EAC"=>"A\u0323\u0302".freeze, "\u1EAD"=>"a\u0323\u0302".freeze,
    "\u1EAE"=>"A\u0306\u0301".freeze, "\u1EAF"=>"a\u0306\u0301".freeze, "\u1EB0"=>"A\u0306\u0300".freeze, "\u1EB1"=>"a\u0306\u0300".freeze, "\u1EB2"=>"A\u0306\u0309".freeze, "\u1EB3"=>"a\u0306\u0309".freeze, "\u1EB4"=>"A\u0306\u0303".freeze, "\u1EB5"=>"a\u0306\u0303".freeze,
    "\u1EB6"=>"A\u0323\u0306".freeze, "\u1EB7"=>"a\u0323\u0306".freeze, "\u1EB8"=>"E\u0323".freeze, "\u1EB9"=>"e\u0323".freeze, "\u1EBA"=>"E\u0309".freeze, "\u1EBB"=>"e\u0309".freeze, "\u1EBC"=>"E\u0303".freeze, "\u1EBD"=>"e\u0303".freeze,
    "\u1EBE"=>"E\u0302\u0301".freeze, "\u1EBF"=>"e\u0302\u0301".freeze, "\u1EC0"=>"E\u0302\u0300".freeze, "\u1EC1"=>"e\u0302\u0300".freeze, "\u1EC2"=>"E\u0302\u0309".freeze, "\u1EC3"=>"e\u0302\u0309".freeze, "\u1EC4"=>"E\u0302\u0303".freeze, "\u1EC5"=>"e\u0302\u0303".freeze,
    "\u1EC6"=>"E\u0323\u0302".freeze, "\u1EC7"=>"e\u0323\u0302".freeze, "\u1EC8"=>"I\u0309".freeze, "\u1EC9"=>"i\u0309".freeze, "\u1ECA"=>"I\u0323".freeze, "\u1ECB"=>"i\u0323".freeze, "\u1ECC"=>"O\u0323".freeze, "\u1ECD"=>"o\u0323".freeze,
    "\u1ECE"=>"O\u0309".freeze, "\u1ECF"=>"o\u0309".freeze, "\u1ED0"=>"O\u0302\u0301".freeze, "\u1ED1"=>"o\u0302\u0301".freeze, "\u1ED2"=>"O\u0302\u0300".freeze, "\u1ED3"=>"o\u0302\u0300".freeze, "\u1ED4"=>"O\u0302\u0309".freeze, "\u1ED5"=>"o\u0302\u0309".freeze,
    "\u1ED6"=>"O\u0302\u0303".freeze, "\u1ED7"=>"o\u0302\u0303".freeze, "\u1ED8"=>"O\u0323\u0302".freeze, "\u1ED9"=>"o\u0323\u0302".freeze, "\u1EDA"=>"O\u031B\u0301".freeze, "\u1EDB"=>"o\u031B\u0301".freeze, "\u1EDC"=>"O\u031B\u0300".freeze, "\u1EDD"=>"o\u031B\u0300".freeze,
    "\u1EDE"=>"O\u031B\u0309".freeze, "\u1EDF"=>"o\u031B\u0309".freeze, "\u1EE0"=>"O\u031B\u0303".freeze, "\u1EE1"=>"o\u031B\u0303".freeze, "\u1EE2"=>"O\u031B\u0323".freeze, "\u1EE3"=>"o\u031B\u0323".freeze, "\u1EE4"=>"U\u0323".freeze, "\u1EE5"=>"u\u0323".freeze,
    "\u1EE6"=>"U\u0309".freeze, "\u1EE7"=>"u\u0309".freeze, "\u1EE8"=>"U\u031B\u0301".freeze, "\u1EE9"=>"u\u031B\u0301".freeze, "\u1EEA"=>"U\u031B\u0300".freeze, "\u1EEB"=>"u\u031B\u0300".freeze, "\u1EEC"=>"U\u031B\u0309".freeze, "\u1EED"=>"u\u031B\u0309".freeze,
    "\u1EEE"=>"U\u031B\u0303".freeze, "\u1EEF"=>"u\u031B\u0303".freeze, "\u1EF0"=>"U\u031B\u0323".freeze, "\u1EF1"=>"u\u031B\u0323".freeze, "\u1EF2"=>"Y\u0300".freeze, "\u1EF3"=>"y\u0300".freeze, "\u1EF4"=>"Y\u0323".freeze, "\u1EF5"=>"y\u0323".freeze,
    "\u1EF6"=>"Y\u0309".freeze, "\u1EF7"=>"y\u0309".freeze, "\u1EF8"=>"Y\u0303".freeze, "\u1EF9"=>"y\u0303".freeze, "\u1F00"=>"\u03B1\u0313".freeze, "\u1F01"=>"\u03B1\u0314".freeze, "\u1F02"=>"\u03B1\u0313\u0300".freeze, "\u1F03"=>"\u03B1\u0314\u0300".freeze,
    "\u1F04"=>"\u03B1\u0313\u0301".freeze, "\u1F05"=>"\u03B1\u0314\u0301".freeze, "\u1F06"=>"\u03B1\u0313\u0342".freeze, "\u1F07"=>"\u03B1\u0314\u0342".freeze, "\u1F08"=>"\u0391\u0313".freeze, "\u1F09"=>"\u0391\u0314".freeze, "\u1F0A"=>"\u0391\u0313\u0300".freeze, "\u1F0B"=>"\u0391\u0314\u0300".freeze,
    "\u1F0C"=>"\u0391\u0313\u0301".freeze, "\u1F0D"=>"\u0391\u0314\u0301".freeze, "\u1F0E"=>"\u0391\u0313\u0342".freeze, "\u1F0F"=>"\u0391\u0314\u0342".freeze, "\u1F10"=>"\u03B5\u0313".freeze, "\u1F11"=>"\u03B5\u0314".freeze, "\u1F12"=>"\u03B5\u0313\u0300".freeze, "\u1F13"=>"\u03B5\u0314\u0300".freeze,
    "\u1F14"=>"\u03B5\u0313\u0301".freeze, "\u1F15"=>"\u03B5\u0314\u0301".freeze, "\u1F18"=>"\u0395\u0313".freeze, "\u1F19"=>"\u0395\u0314".freeze, "\u1F1A"=>"\u0395\u0313\u0300".freeze, "\u1F1B"=>"\u0395\u0314\u0300".freeze, "\u1F1C"=>"\u0395\u0313\u0301".freeze, "\u1F1D"=>"\u0395\u0314\u0301".freeze,
    "\u1F20"=>"\u03B7\u0313".freeze, "\u1F21"=>"\u03B7\u0314".freeze, "\u1F22"=>"\u03B7\u0313\u0300".freeze, "\u1F23"=>"\u03B7\u0314\u0300".freeze, "\u1F24"=>"\u03B7\u0313\u0301".freeze, "\u1F25"=>"\u03B7\u0314\u0301".freeze, "\u1F26"=>"\u03B7\u0313\u0342".freeze, "\u1F27"=>"\u03B7\u0314\u0342".freeze,
    "\u1F28"=>"\u0397\u0313".freeze, "\u1F29"=>"\u0397\u0314".freeze, "\u1F2A"=>"\u0397\u0313\u0300".freeze, "\u1F2B"=>"\u0397\u0314\u0300".freeze, "\u1F2C"=>"\u0397\u0313\u0301".freeze, "\u1F2D"=>"\u0397\u0314\u0301".freeze, "\u1F2E"=>"\u0397\u0313\u0342".freeze, "\u1F2F"=>"\u0397\u0314\u0342".freeze,
    "\u1F30"=>"\u03B9\u0313".freeze, "\u1F31"=>"\u03B9\u0314".freeze, "\u1F32"=>"\u03B9\u0313\u0300".freeze, "\u1F33"=>"\u03B9\u0314\u0300".freeze, "\u1F34"=>"\u03B9\u0313\u0301".freeze, "\u1F35"=>"\u03B9\u0314\u0301".freeze, "\u1F36"=>"\u03B9\u0313\u0342".freeze, "\u1F37"=>"\u03B9\u0314\u0342".freeze,
    "\u1F38"=>"\u0399\u0313".freeze, "\u1F39"=>"\u0399\u0314".freeze, "\u1F3A"=>"\u0399\u0313\u0300".freeze, "\u1F3B"=>"\u0399\u0314\u0300".freeze, "\u1F3C"=>"\u0399\u0313\u0301".freeze, "\u1F3D"=>"\u0399\u0314\u0301".freeze, "\u1F3E"=>"\u0399\u0313\u0342".freeze, "\u1F3F"=>"\u0399\u0314\u0342".freeze,
    "\u1F40"=>"\u03BF\u0313".freeze, "\u1F41"=>"\u03BF\u0314".freeze, "\u1F42"=>"\u03BF\u0313\u0300".freeze, "\u1F43"=>"\u03BF\u0314\u0300".freeze, "\u1F44"=>"\u03BF\u0313\u0301".freeze, "\u1F45"=>"\u03BF\u0314\u0301".freeze, "\u1F48"=>"\u039F\u0313".freeze, "\u1F49"=>"\u039F\u0314".freeze,
    "\u1F4A"=>"\u039F\u0313\u0300".freeze, "\u1F4B"=>"\u039F\u0314\u0300".freeze, "\u1F4C"=>"\u039F\u0313\u0301".freeze, "\u1F4D"=>"\u039F\u0314\u0301".freeze, "\u1F50"=>"\u03C5\u0313".freeze, "\u1F51"=>"\u03C5\u0314".freeze, "\u1F52"=>"\u03C5\u0313\u0300".freeze, "\u1F53"=>"\u03C5\u0314\u0300".freeze,
    "\u1F54"=>"\u03C5\u0313\u0301".freeze, "\u1F55"=>"\u03C5\u0314\u0301".freeze, "\u1F56"=>"\u03C5\u0313\u0342".freeze, "\u1F57"=>"\u03C5\u0314\u0342".freeze, "\u1F59"=>"\u03A5\u0314".freeze, "\u1F5B"=>"\u03A5\u0314\u0300".freeze, "\u1F5D"=>"\u03A5\u0314\u0301".freeze, "\u1F5F"=>"\u03A5\u0314\u0342".freeze,
    "\u1F60"=>"\u03C9\u0313".freeze, "\u1F61"=>"\u03C9\u0314".freeze, "\u1F62"=>"\u03C9\u0313\u0300".freeze, "\u1F63"=>"\u03C9\u0314\u0300".freeze, "\u1F64"=>"\u03C9\u0313\u0301".freeze, "\u1F65"=>"\u03C9\u0314\u0301".freeze, "\u1F66"=>"\u03C9\u0313\u0342".freeze, "\u1F67"=>"\u03C9\u0314\u0342".freeze,
    "\u1F68"=>"\u03A9\u0313".freeze, "\u1F69"=>"\u03A9\u0314".freeze, "\u1F6A"=>"\u03A9\u0313\u0300".freeze, "\u1F6B"=>"\u03A9\u0314\u0300".freeze, "\u1F6C"=>"\u03A9\u0313\u0301".freeze, "\u1F6D"=>"\u03A9\u0314\u0301".freeze, "\u1F6E"=>"\u03A9\u0313\u0342".freeze, "\u1F6F"=>"\u03A9\u0314\u0342".freeze,
    "\u1F70"=>"\u03B1\u0300".freeze, "\u1F71"=>"\u03B1\u0301".freeze, "\u1F72"=>"\u03B5\u0300".freeze, "\u1F73"=>"\u03B5\u0301".freeze, "\u1F74"=>"\u03B7\u0300".freeze, "\u1F75"=>"\u03B7\u0301".freeze, "\u1F76"=>"\u03B9\u0300".freeze, "\u1F77"=>"\u03B9\u0301".freeze,
    "\u1F78"=>"\u03BF\u0300".freeze, "\u1F79"=>"\u03BF\u0301".freeze, "\u1F7A"=>"\u03C5\u0300".freeze, "\u1F7B"=>"\u03C5\u0301".freeze, "\u1F7C"=>"\u03C9\u0300".freeze, "\u1F7D"=>"\u03C9\u0301".freeze, "\u1F80"=>"\u03B1\u0313\u0345".freeze, "\u1F81"=>"\u03B1\u0314\u0345".freeze,
    "\u1F82"=>"\u03B1\u0313\u0300\u0345".freeze, "\u1F83"=>"\u03B1\u0314\u0300\u0345".freeze, "\u1F84"=>"\u03B1\u0313\u0301\u0345".freeze, "\u1F85"=>"\u03B1\u0314\u0301\u0345".freeze, "\u1F86"=>"\u03B1\u0313\u0342\u0345".freeze, "\u1F87"=>"\u03B1\u0314\u0342\u0345".freeze, "\u1F88"=>"\u0391\u0313\u0345".freeze, "\u1F89"=>"\u0391\u0314\u0345".freeze,
    "\u1F8A"=>"\u0391\u0313\u0300\u0345".freeze, "\u1F8B"=>"\u0391\u0314\u0300\u0345".freeze, "\u1F8C"=>"\u0391\u0313\u0301\u0345".freeze, "\u1F8D"=>"\u0391\u0314\u0301\u0345".freeze, "\u1F8E"=>"\u0391\u0313\u0342\u0345".freeze, "\u1F8F"=>"\u0391\u0314\u0342\u0345".freeze, "\u1F90"=>"\u03B7\u0313\u0345".freeze, "\u1F91"=>"\u03B7\u0314\u0345".freeze,
    "\u1F92"=>"\u03B7\u0313\u0300\u0345".freeze, "\u1F93"=>"\u03B7\u0314\u0300\u0345".freeze, "\u1F94"=>"\u03B7\u0313\u0301\u0345".freeze, "\u1F95"=>"\u03B7\u0314\u0301\u0345".freeze, "\u1F96"=>"\u03B7\u0313\u0342\u0345".freeze, "\u1F97"=>"\u03B7\u0314\u0342\u0345".freeze, "\u1F98"=>"\u0397\u0313\u0345".freeze, "\u1F99"=>"\u0397\u0314\u0345".freeze,
    "\u1F9A"=>"\u0397\u0313\u0300\u0345".freeze, "\u1F9B"=>"\u0397\u0314\u0300\u0345".freeze, "\u1F9C"=>"\u0397\u0313\u0301\u0345".freeze, "\u1F9D"=>"\u0397\u0314\u0301\u0345".freeze, "\u1F9E"=>"\u0397\u0313\u0342\u0345".freeze, "\u1F9F"=>"\u0397\u0314\u0342\u0345".freeze, "\u1FA0"=>"\u03C9\u0313\u0345".freeze, "\u1FA1"=>"\u03C9\u0314\u0345".freeze,
    "\u1FA2"=>"\u03C9\u0313\u0300\u0345".freeze, "\u1FA3"=>"\u03C9\u0314\u0300\u0345".freeze, "\u1FA4"=>"\u03C9\u0313\u0301\u0345".freeze, "\u1FA5"=>"\u03C9\u0314\u0301\u0345".freeze, "\u1FA6"=>"\u03C9\u0313\u0342\u0345".freeze, "\u1FA7"=>"\u03C9\u0314\u0342\u0345".freeze, "\u1FA8"=>"\u03A9\u0313\u0345".freeze, "\u1FA9"=>"\u03A9\u0314\u0345".freeze,
    "\u1FAA"=>"\u03A9\u0313\u0300\u0345".freeze, "\u1FAB"=>"\u03A9\u0314\u0300\u0345".freeze, "\u1FAC"=>"\u03A9\u0313\u0301\u0345".freeze, "\u1FAD"=>"\u03A9\u0314\u0301\u0345".freeze, "\u1FAE"=>"\u03A9\u0313\u0342\u0345".freeze, "\u1FAF"=>"\u03A9\u0314\u0342\u0345".freeze, "\u1FB0"=>"\u03B1\u0306".freeze, "\u1FB1"=>"\u03B1\u0304".freeze,
    "\u1FB2"=>"\u03B1\u0300\u0345".freeze, "\u1FB3"=>"\u03B1\u0345".freeze, "\u1FB4"=>"\u03B1\u0301\u0345".freeze, "\u1FB6"=>"\u03B1\u0342".freeze, "\u1FB7"=>"\u03B1\u0342\u0345".freeze, "\u1FB8"=>"\u0391\u0306".freeze, "\u1FB9"=>"\u0391\u0304".freeze, "\u1FBA"=>"\u0391\u0300".freeze,
    "\u1FBB"=>"\u0391\u0301".freeze, "\u1FBC"=>"\u0391\u0345".freeze, "\u1FBE"=>"\u03B9".freeze, "\u1FC1"=>"\u00A8\u0342".freeze, "\u1FC2"=>"\u03B7\u0300\u0345".freeze, "\u1FC3"=>"\u03B7\u0345".freeze, "\u1FC4"=>"\u03B7\u0301\u0345".freeze, "\u1FC6"=>"\u03B7\u0342".freeze,
    "\u1FC7"=>"\u03B7\u0342\u0345".freeze, "\u1FC8"=>"\u0395\u0300".freeze, "\u1FC9"=>"\u0395\u0301".freeze, "\u1FCA"=>"\u0397\u0300".freeze, "\u1FCB"=>"\u0397\u0301".freeze, "\u1FCC"=>"\u0397\u0345".freeze, "\u1FCD"=>"\u1FBF\u0300".freeze, "\u1FCE"=>"\u1FBF\u0301".freeze,
    "\u1FCF"=>"\u1FBF\u0342".freeze, "\u1FD0"=>"\u03B9\u0306".freeze, "\u1FD1"=>"\u03B9\u0304".freeze, "\u1FD2"=>"\u03B9\u0308\u0300".freeze, "\u1FD3"=>"\u03B9\u0308\u0301".freeze, "\u1FD6"=>"\u03B9\u0342".freeze, "\u1FD7"=>"\u03B9\u0308\u0342".freeze, "\u1FD8"=>"\u0399\u0306".freeze,
    "\u1FD9"=>"\u0399\u0304".freeze, "\u1FDA"=>"\u0399\u0300".freeze, "\u1FDB"=>"\u0399\u0301".freeze, "\u1FDD"=>"\u1FFE\u0300".freeze, "\u1FDE"=>"\u1FFE\u0301".freeze, "\u1FDF"=>"\u1FFE\u0342".freeze, "\u1FE0"=>"\u03C5\u0306".freeze, "\u1FE1"=>"\u03C5\u0304".freeze,
    "\u1FE2"=>"\u03C5\u0308\u0300".freeze, "\u1FE3"=>"\u03C5\u0308\u0301".freeze, "\u1FE4"=>"\u03C1\u0313".freeze, "\u1FE5"=>"\u03C1\u0314".freeze, "\u1FE6"=>"\u03C5\u0342".freeze, "\u1FE7"=>"\u03C5\u0308\u0342".freeze, "\u1FE8"=>"\u03A5\u0306".freeze, "\u1FE9"=>"\u03A5\u0304".freeze,
    "\u1FEA"=>"\u03A5\u0300".freeze, "\u1FEB"=>"\u03A5\u0301".freeze, "\u1FEC"=>"\u03A1\u0314".freeze, "\u1FED"=>"\u00A8\u0300".freeze, "\u1FEE"=>"\u00A8\u0301".freeze, "\u1FEF"=>"`".freeze, "\u1FF2"=>"\u03C9\u0300\u0345".freeze, "\u1FF3"=>"\u03C9\u0345".freeze,
    "\u1FF4"=>"\u03C9\u0301\u0345".freeze, "\u1FF6"=>"\u03C9\u0342".freeze, "\u1FF7"=>"\u03C9\u0342\u0345".freeze, "\u1FF8"=>"\u039F\u0300".freeze, "\u1FF9"=>"\u039F\u0301".freeze, "\u1FFA"=>"\u03A9\u0300".freeze, "\u1FFB"=>"\u03A9\u0301".freeze, "\u1FFC"=>"\u03A9\u0345".freeze,
    "\u1FFD"=>"\u00B4".freeze, "\u2000"=>"\u2002".freeze, "\u2001"=>"\u2003".freeze, "\u2126"=>"\u03A9".freeze, "\u212A"=>"K".freeze, "\u212B"=>"A\u030A".freeze, "\u219A"=>"\u2190\u0338".freeze, "\u219B"=>"\u2192\u0338".freeze,
    "\u21AE"=>"\u2194\u0338".freeze, "\u21CD"=>"\u21D0\u0338".freeze, "\u21CE"=>"\u21D4\u0338".freeze, "\u21CF"=>"\u21D2\u0338".freeze, "\u2204"=>"\u2203\u0338".freeze, "\u2209"=>"\u2208\u0338".freeze, "\u220C"=>"\u220B\u0338".freeze, "\u2224"=>"\u2223\u0338".freeze,
    "\u2226"=>"\u2225\u0338".freeze, "\u2241"=>"\u223C\u0338".freeze, "\u2244"=>"\u2243\u0338".freeze, "\u2247"=>"\u2245\u0338".freeze, "\u2249"=>"\u2248\u0338".freeze, "\u2260"=>"=\u0338".freeze, "\u2262"=>"\u2261\u0338".freeze, "\u226D"=>"\u224D\u0338".freeze,
    "\u226E"=>"<\u0338".freeze, "\u226F"=>">\u0338".freeze, "\u2270"=>"\u2264\u0338".freeze, "\u2271"=>"\u2265\u0338".freeze, "\u2274"=>"\u2272\u0338".freeze, "\u2275"=>"\u2273\u0338".freeze, "\u2278"=>"\u2276\u0338".freeze, "\u2279"=>"\u2277\u0338".freeze,
    "\u2280"=>"\u227A\u0338".freeze, "\u2281"=>"\u227B\u0338".freeze, "\u2284"=>"\u2282\u0338".freeze, "\u2285"=>"\u2283\u0338".freeze, "\u2288"=>"\u2286\u0338".freeze, "\u2289"=>"\u2287\u0338".freeze, "\u22AC"=>"\u22A2\u0338".freeze, "\u22AD"=>"\u22A8\u0338".freeze,
    "\u22AE"=>"\u22A9\u0338".freeze, "\u22AF"=>"\u22AB\u0338".freeze, "\u22E0"=>"\u227C\u0338".freeze, "\u22E1"=>"\u227D\u0338".freeze, "\u22E2"=>"\u2291\u0338".freeze, "\u22E3"=>"\u2292\u0338".freeze, "\u22EA"=>"\u22B2\u0338".freeze, "\u22EB"=>"\u22B3\u0338".freeze,
    "\u22EC"=>"\u22B4\u0338".freeze, "\u22ED"=>"\u22B5\u0338".freeze, "\u2329"=>"\u3008".freeze, "\u232A"=>"\u3009".freeze, "\u2ADC"=>"\u2ADD\u0338".freeze, "\u304C"=>"\u304B\u3099".freeze, "\u304E"=>"\u304D\u3099".freeze, "\u3050"=>"\u304F\u3099".freeze,
    "\u3052"=>"\u3051\u3099".freeze, "\u3054"=>"\u3053\u3099".freeze, "\u3056"=>"\u3055\u3099".freeze, "\u3058"=>"\u3057\u3099".freeze, "\u305A"=>"\u3059\u3099".freeze, "\u305C"=>"\u305B\u3099".freeze, "\u305E"=>"\u305D\u3099".freeze, "\u3060"=>"\u305F\u3099".freeze,
    "\u3062"=>"\u3061\u3099".freeze, "\u3065"=>"\u3064\u3099".freeze, "\u3067"=>"\u3066\u3099".freeze, "\u3069"=>"\u3068\u3099".freeze, "\u3070"=>"\u306F\u3099".freeze, "\u3071"=>"\u306F\u309A".freeze, "\u3073"=>"\u3072\u3099".freeze, "\u3074"=>"\u3072\u309A".freeze,
    "\u3076"=>"\u3075\u3099".freeze, "\u3077"=>"\u3075\u309A".freeze, "\u3079"=>"\u3078\u3099".freeze, "\u307A"=>"\u3078\u309A".freeze, "\u307C"=>"\u307B\u3099".freeze, "\u307D"=>"\u307B\u309A".freeze, "\u3094"=>"\u3046\u3099".freeze, "\u309E"=>"\u309D\u3099".freeze,
    "\u30AC"=>"\u30AB\u3099".freeze, "\u30AE"=>"\u30AD\u3099".freeze, "\u30B0"=>"\u30AF\u3099".freeze, "\u30B2"=>"\u30B1\u3099".freeze, "\u30B4"=>"\u30B3\u3099".freeze, "\u30B6"=>"\u30B5\u3099".freeze, "\u30B8"=>"\u30B7\u3099".freeze, "\u30BA"=>"\u30B9\u3099".freeze,
    "\u30BC"=>"\u30BB\u3099".freeze, "\u30BE"=>"\u30BD\u3099".freeze, "\u30C0"=>"\u30BF\u3099".freeze, "\u30C2"=>"\u30C1\u3099".freeze, "\u30C5"=>"\u30C4\u3099".freeze, "\u30C7"=>"\u30C6\u3099".freeze, "\u30C9"=>"\u30C8\u3099".freeze, "\u30D0"=>"\u30CF\u3099".freeze,
    "\u30D1"=>"\u30CF\u309A".freeze, "\u30D3"=>"\u30D2\u3099".freeze, "\u30D4"=>"\u30D2\u309A".freeze, "\u30D6"=>"\u30D5\u3099".freeze, "\u30D7"=>"\u30D5\u309A".freeze, "\u30D9"=>"\u30D8\u3099".freeze, "\u30DA"=>"\u30D8\u309A".freeze, "\u30DC"=>"\u30DB\u3099".freeze,
    "\u30DD"=>"\u30DB\u309A".freeze, "\u30F4"=>"\u30A6\u3099".freeze, "\u30F7"=>"\u30EF\u3099".freeze, "\u30F8"=>"\u30F0\u3099".freeze, "\u30F9"=>"\u30F1\u3099".freeze, "\u30FA"=>"\u30F2\u3099".freeze, "\u30FE"=>"\u30FD\u3099".freeze, "\uF900"=>"\u8C48".freeze,
    "\uF901"=>"\u66F4".freeze, "\uF902"=>"\u8ECA".freeze, "\uF903"=>"\u8CC8".freeze, "\uF904"=>"\u6ED1".freeze, "\uF905"=>"\u4E32".freeze, "\uF906"=>"\u53E5".freeze, "\uF907"=>"\u9F9C".freeze, "\uF908"=>"\u9F9C".freeze,
    "\uF909"=>"\u5951".freeze, "\uF90A"=>"\u91D1".freeze, "\uF90B"=>"\u5587".freeze, "\uF90C"=>"\u5948".freeze, "\uF90D"=>"\u61F6".freeze, "\uF90E"=>"\u7669".freeze, "\uF90F"=>"\u7F85".freeze, "\uF910"=>"\u863F".freeze,
    "\uF911"=>"\u87BA".freeze, "\uF912"=>"\u88F8".freeze, "\uF913"=>"\u908F".freeze, "\uF914"=>"\u6A02".freeze, "\uF915"=>"\u6D1B".freeze, "\uF916"=>"\u70D9".freeze, "\uF917"=>"\u73DE".freeze, "\uF918"=>"\u843D".freeze,
    "\uF919"=>"\u916A".freeze, "\uF91A"=>"\u99F1".freeze, "\uF91B"=>"\u4E82".freeze, "\uF91C"=>"\u5375".freeze, "\uF91D"=>"\u6B04".freeze, "\uF91E"=>"\u721B".freeze, "\uF91F"=>"\u862D".freeze, "\uF920"=>"\u9E1E".freeze,
    "\uF921"=>"\u5D50".freeze, "\uF922"=>"\u6FEB".freeze, "\uF923"=>"\u85CD".freeze, "\uF924"=>"\u8964".freeze, "\uF925"=>"\u62C9".freeze, "\uF926"=>"\u81D8".freeze, "\uF927"=>"\u881F".freeze, "\uF928"=>"\u5ECA".freeze,
    "\uF929"=>"\u6717".freeze, "\uF92A"=>"\u6D6A".freeze, "\uF92B"=>"\u72FC".freeze, "\uF92C"=>"\u90CE".freeze, "\uF92D"=>"\u4F86".freeze, "\uF92E"=>"\u51B7".freeze, "\uF92F"=>"\u52DE".freeze, "\uF930"=>"\u64C4".freeze,
    "\uF931"=>"\u6AD3".freeze, "\uF932"=>"\u7210".freeze, "\uF933"=>"\u76E7".freeze, "\uF934"=>"\u8001".freeze, "\uF935"=>"\u8606".freeze, "\uF936"=>"\u865C".freeze, "\uF937"=>"\u8DEF".freeze, "\uF938"=>"\u9732".freeze,
    "\uF939"=>"\u9B6F".freeze, "\uF93A"=>"\u9DFA".freeze, "\uF93B"=>"\u788C".freeze, "\uF93C"=>"\u797F".freeze, "\uF93D"=>"\u7DA0".freeze, "\uF93E"=>"\u83C9".freeze, "\uF93F"=>"\u9304".freeze, "\uF940"=>"\u9E7F".freeze,
    "\uF941"=>"\u8AD6".freeze, "\uF942"=>"\u58DF".freeze, "\uF943"=>"\u5F04".freeze, "\uF944"=>"\u7C60".freeze, "\uF945"=>"\u807E".freeze, "\uF946"=>"\u7262".freeze, "\uF947"=>"\u78CA".freeze, "\uF948"=>"\u8CC2".freeze,
    "\uF949"=>"\u96F7".freeze, "\uF94A"=>"\u58D8".freeze, "\uF94B"=>"\u5C62".freeze, "\uF94C"=>"\u6A13".freeze, "\uF94D"=>"\u6DDA".freeze, "\uF94E"=>"\u6F0F".freeze, "\uF94F"=>"\u7D2F".freeze, "\uF950"=>"\u7E37".freeze,
    "\uF951"=>"\u964B".freeze, "\uF952"=>"\u52D2".freeze, "\uF953"=>"\u808B".freeze, "\uF954"=>"\u51DC".freeze, "\uF955"=>"\u51CC".freeze, "\uF956"=>"\u7A1C".freeze, "\uF957"=>"\u7DBE".freeze, "\uF958"=>"\u83F1".freeze,
    "\uF959"=>"\u9675".freeze, "\uF95A"=>"\u8B80".freeze, "\uF95B"=>"\u62CF".freeze, "\uF95C"=>"\u6A02".freeze, "\uF95D"=>"\u8AFE".freeze, "\uF95E"=>"\u4E39".freeze, "\uF95F"=>"\u5BE7".freeze, "\uF960"=>"\u6012".freeze,
    "\uF961"=>"\u7387".freeze, "\uF962"=>"\u7570".freeze, "\uF963"=>"\u5317".freeze, "\uF964"=>"\u78FB".freeze, "\uF965"=>"\u4FBF".freeze, "\uF966"=>"\u5FA9".freeze, "\uF967"=>"\u4E0D".freeze, "\uF968"=>"\u6CCC".freeze,
    "\uF969"=>"\u6578".freeze, "\uF96A"=>"\u7D22".freeze, "\uF96B"=>"\u53C3".freeze, "\uF96C"=>"\u585E".freeze, "\uF96D"=>"\u7701".freeze, "\uF96E"=>"\u8449".freeze, "\uF96F"=>"\u8AAA".freeze, "\uF970"=>"\u6BBA".freeze,
    "\uF971"=>"\u8FB0".freeze, "\uF972"=>"\u6C88".freeze, "\uF973"=>"\u62FE".freeze, "\uF974"=>"\u82E5".freeze, "\uF975"=>"\u63A0".freeze, "\uF976"=>"\u7565".freeze, "\uF977"=>"\u4EAE".freeze, "\uF978"=>"\u5169".freeze,
    "\uF979"=>"\u51C9".freeze, "\uF97A"=>"\u6881".freeze, "\uF97B"=>"\u7CE7".freeze, "\uF97C"=>"\u826F".freeze, "\uF97D"=>"\u8AD2".freeze, "\uF97E"=>"\u91CF".freeze, "\uF97F"=>"\u52F5".freeze, "\uF980"=>"\u5442".freeze,
    "\uF981"=>"\u5973".freeze, "\uF982"=>"\u5EEC".freeze, "\uF983"=>"\u65C5".freeze, "\uF984"=>"\u6FFE".freeze, "\uF985"=>"\u792A".freeze, "\uF986"=>"\u95AD".freeze, "\uF987"=>"\u9A6A".freeze, "\uF988"=>"\u9E97".freeze,
    "\uF989"=>"\u9ECE".freeze, "\uF98A"=>"\u529B".freeze, "\uF98B"=>"\u66C6".freeze, "\uF98C"=>"\u6B77".freeze, "\uF98D"=>"\u8F62".freeze, "\uF98E"=>"\u5E74".freeze, "\uF98F"=>"\u6190".freeze, "\uF990"=>"\u6200".freeze,
    "\uF991"=>"\u649A".freeze, "\uF992"=>"\u6F23".freeze, "\uF993"=>"\u7149".freeze, "\uF994"=>"\u7489".freeze, "\uF995"=>"\u79CA".freeze, "\uF996"=>"\u7DF4".freeze, "\uF997"=>"\u806F".freeze, "\uF998"=>"\u8F26".freeze,
    "\uF999"=>"\u84EE".freeze, "\uF99A"=>"\u9023".freeze, "\uF99B"=>"\u934A".freeze, "\uF99C"=>"\u5217".freeze, "\uF99D"=>"\u52A3".freeze, "\uF99E"=>"\u54BD".freeze, "\uF99F"=>"\u70C8".freeze, "\uF9A0"=>"\u88C2".freeze,
    "\uF9A1"=>"\u8AAA".freeze, "\uF9A2"=>"\u5EC9".freeze, "\uF9A3"=>"\u5FF5".freeze, "\uF9A4"=>"\u637B".freeze, "\uF9A5"=>"\u6BAE".freeze, "\uF9A6"=>"\u7C3E".freeze, "\uF9A7"=>"\u7375".freeze, "\uF9A8"=>"\u4EE4".freeze,
    "\uF9A9"=>"\u56F9".freeze, "\uF9AA"=>"\u5BE7".freeze, "\uF9AB"=>"\u5DBA".freeze, "\uF9AC"=>"\u601C".freeze, "\uF9AD"=>"\u73B2".freeze, "\uF9AE"=>"\u7469".freeze, "\uF9AF"=>"\u7F9A".freeze, "\uF9B0"=>"\u8046".freeze,
    "\uF9B1"=>"\u9234".freeze, "\uF9B2"=>"\u96F6".freeze, "\uF9B3"=>"\u9748".freeze, "\uF9B4"=>"\u9818".freeze, "\uF9B5"=>"\u4F8B".freeze, "\uF9B6"=>"\u79AE".freeze, "\uF9B7"=>"\u91B4".freeze, "\uF9B8"=>"\u96B8".freeze,
    "\uF9B9"=>"\u60E1".freeze, "\uF9BA"=>"\u4E86".freeze, "\uF9BB"=>"\u50DA".freeze, "\uF9BC"=>"\u5BEE".freeze, "\uF9BD"=>"\u5C3F".freeze, "\uF9BE"=>"\u6599".freeze, "\uF9BF"=>"\u6A02".freeze, "\uF9C0"=>"\u71CE".freeze,
    "\uF9C1"=>"\u7642".freeze, "\uF9C2"=>"\u84FC".freeze, "\uF9C3"=>"\u907C".freeze, "\uF9C4"=>"\u9F8D".freeze, "\uF9C5"=>"\u6688".freeze, "\uF9C6"=>"\u962E".freeze, "\uF9C7"=>"\u5289".freeze, "\uF9C8"=>"\u677B".freeze,
    "\uF9C9"=>"\u67F3".freeze, "\uF9CA"=>"\u6D41".freeze, "\uF9CB"=>"\u6E9C".freeze, "\uF9CC"=>"\u7409".freeze, "\uF9CD"=>"\u7559".freeze, "\uF9CE"=>"\u786B".freeze, "\uF9CF"=>"\u7D10".freeze, "\uF9D0"=>"\u985E".freeze,
    "\uF9D1"=>"\u516D".freeze, "\uF9D2"=>"\u622E".freeze, "\uF9D3"=>"\u9678".freeze, "\uF9D4"=>"\u502B".freeze, "\uF9D5"=>"\u5D19".freeze, "\uF9D6"=>"\u6DEA".freeze, "\uF9D7"=>"\u8F2A".freeze, "\uF9D8"=>"\u5F8B".freeze,
    "\uF9D9"=>"\u6144".freeze, "\uF9DA"=>"\u6817".freeze, "\uF9DB"=>"\u7387".freeze, "\uF9DC"=>"\u9686".freeze, "\uF9DD"=>"\u5229".freeze, "\uF9DE"=>"\u540F".freeze, "\uF9DF"=>"\u5C65".freeze, "\uF9E0"=>"\u6613".freeze,
    "\uF9E1"=>"\u674E".freeze, "\uF9E2"=>"\u68A8".freeze, "\uF9E3"=>"\u6CE5".freeze, "\uF9E4"=>"\u7406".freeze, "\uF9E5"=>"\u75E2".freeze, "\uF9E6"=>"\u7F79".freeze, "\uF9E7"=>"\u88CF".freeze, "\uF9E8"=>"\u88E1".freeze,
    "\uF9E9"=>"\u91CC".freeze, "\uF9EA"=>"\u96E2".freeze, "\uF9EB"=>"\u533F".freeze, "\uF9EC"=>"\u6EBA".freeze, "\uF9ED"=>"\u541D".freeze, "\uF9EE"=>"\u71D0".freeze, "\uF9EF"=>"\u7498".freeze, "\uF9F0"=>"\u85FA".freeze,
    "\uF9F1"=>"\u96A3".freeze, "\uF9F2"=>"\u9C57".freeze, "\uF9F3"=>"\u9E9F".freeze, "\uF9F4"=>"\u6797".freeze, "\uF9F5"=>"\u6DCB".freeze, "\uF9F6"=>"\u81E8".freeze, "\uF9F7"=>"\u7ACB".freeze, "\uF9F8"=>"\u7B20".freeze,
    "\uF9F9"=>"\u7C92".freeze, "\uF9FA"=>"\u72C0".freeze, "\uF9FB"=>"\u7099".freeze, "\uF9FC"=>"\u8B58".freeze, "\uF9FD"=>"\u4EC0".freeze, "\uF9FE"=>"\u8336".freeze, "\uF9FF"=>"\u523A".freeze, "\uFA00"=>"\u5207".freeze,
    "\uFA01"=>"\u5EA6".freeze, "\uFA02"=>"\u62D3".freeze, "\uFA03"=>"\u7CD6".freeze, "\uFA04"=>"\u5B85".freeze, "\uFA05"=>"\u6D1E".freeze, "\uFA06"=>"\u66B4".freeze, "\uFA07"=>"\u8F3B".freeze, "\uFA08"=>"\u884C".freeze,
    "\uFA09"=>"\u964D".freeze, "\uFA0A"=>"\u898B".freeze, "\uFA0B"=>"\u5ED3".freeze, "\uFA0C"=>"\u5140".freeze, "\uFA0D"=>"\u55C0".freeze, "\uFA10"=>"\u585A".freeze, "\uFA12"=>"\u6674".freeze, "\uFA15"=>"\u51DE".freeze,
    "\uFA16"=>"\u732A".freeze, "\uFA17"=>"\u76CA".freeze, "\uFA18"=>"\u793C".freeze, "\uFA19"=>"\u795E".freeze, "\uFA1A"=>"\u7965".freeze, "\uFA1B"=>"\u798F".freeze, "\uFA1C"=>"\u9756".freeze, "\uFA1D"=>"\u7CBE".freeze,
    "\uFA1E"=>"\u7FBD".freeze, "\uFA20"=>"\u8612".freeze, "\uFA22"=>"\u8AF8".freeze, "\uFA25"=>"\u9038".freeze, "\uFA26"=>"\u90FD".freeze, "\uFA2A"=>"\u98EF".freeze, "\uFA2B"=>"\u98FC".freeze, "\uFA2C"=>"\u9928".freeze,
    "\uFA2D"=>"\u9DB4".freeze, "\uFA2E"=>"\u90DE".freeze, "\uFA2F"=>"\u96B7".freeze, "\uFA30"=>"\u4FAE".freeze, "\uFA31"=>"\u50E7".freeze, "\uFA32"=>"\u514D".freeze, "\uFA33"=>"\u52C9".freeze, "\uFA34"=>"\u52E4".freeze,
    "\uFA35"=>"\u5351".freeze, "\uFA36"=>"\u559D".freeze, "\uFA37"=>"\u5606".freeze, "\uFA38"=>"\u5668".freeze, "\uFA39"=>"\u5840".freeze, "\uFA3A"=>"\u58A8".freeze, "\uFA3B"=>"\u5C64".freeze, "\uFA3C"=>"\u5C6E".freeze,
    "\uFA3D"=>"\u6094".freeze, "\uFA3E"=>"\u6168".freeze, "\uFA3F"=>"\u618E".freeze, "\uFA40"=>"\u61F2".freeze, "\uFA41"=>"\u654F".freeze, "\uFA42"=>"\u65E2".freeze, "\uFA43"=>"\u6691".freeze, "\uFA44"=>"\u6885".freeze,
    "\uFA45"=>"\u6D77".freeze, "\uFA46"=>"\u6E1A".freeze, "\uFA47"=>"\u6F22".freeze, "\uFA48"=>"\u716E".freeze, "\uFA49"=>"\u722B".freeze, "\uFA4A"=>"\u7422".freeze, "\uFA4B"=>"\u7891".freeze, "\uFA4C"=>"\u793E".freeze,
    "\uFA4D"=>"\u7949".freeze, "\uFA4E"=>"\u7948".freeze, "\uFA4F"=>"\u7950".freeze, "\uFA50"=>"\u7956".freeze, "\uFA51"=>"\u795D".freeze, "\uFA52"=>"\u798D".freeze, "\uFA53"=>"\u798E".freeze, "\uFA54"=>"\u7A40".freeze,
    "\uFA55"=>"\u7A81".freeze, "\uFA56"=>"\u7BC0".freeze, "\uFA57"=>"\u7DF4".freeze, "\uFA58"=>"\u7E09".freeze, "\uFA59"=>"\u7E41".freeze, "\uFA5A"=>"\u7F72".freeze, "\uFA5B"=>"\u8005".freeze, "\uFA5C"=>"\u81ED".freeze,
    "\uFA5D"=>"\u8279".freeze, "\uFA5E"=>"\u8279".freeze, "\uFA5F"=>"\u8457".freeze, "\uFA60"=>"\u8910".freeze, "\uFA61"=>"\u8996".freeze, "\uFA62"=>"\u8B01".freeze, "\uFA63"=>"\u8B39".freeze, "\uFA64"=>"\u8CD3".freeze,
    "\uFA65"=>"\u8D08".freeze, "\uFA66"=>"\u8FB6".freeze, "\uFA67"=>"\u9038".freeze, "\uFA68"=>"\u96E3".freeze, "\uFA69"=>"\u97FF".freeze, "\uFA6A"=>"\u983B".freeze, "\uFA6B"=>"\u6075".freeze, "\uFA6C"=>"\u{242EE}".freeze,
    "\uFA6D"=>"\u8218".freeze, "\uFA70"=>"\u4E26".freeze, "\uFA71"=>"\u51B5".freeze, "\uFA72"=>"\u5168".freeze, "\uFA73"=>"\u4F80".freeze, "\uFA74"=>"\u5145".freeze, "\uFA75"=>"\u5180".freeze, "\uFA76"=>"\u52C7".freeze,
    "\uFA77"=>"\u52FA".freeze, "\uFA78"=>"\u559D".freeze, "\uFA79"=>"\u5555".freeze, "\uFA7A"=>"\u5599".freeze, "\uFA7B"=>"\u55E2".freeze, "\uFA7C"=>"\u585A".freeze, "\uFA7D"=>"\u58B3".freeze, "\uFA7E"=>"\u5944".freeze,
    "\uFA7F"=>"\u5954".freeze, "\uFA80"=>"\u5A62".freeze, "\uFA81"=>"\u5B28".freeze, "\uFA82"=>"\u5ED2".freeze, "\uFA83"=>"\u5ED9".freeze, "\uFA84"=>"\u5F69".freeze, "\uFA85"=>"\u5FAD".freeze, "\uFA86"=>"\u60D8".freeze,
    "\uFA87"=>"\u614E".freeze, "\uFA88"=>"\u6108".freeze, "\uFA89"=>"\u618E".freeze, "\uFA8A"=>"\u6160".freeze, "\uFA8B"=>"\u61F2".freeze, "\uFA8C"=>"\u6234".freeze, "\uFA8D"=>"\u63C4".freeze, "\uFA8E"=>"\u641C".freeze,
    "\uFA8F"=>"\u6452".freeze, "\uFA90"=>"\u6556".freeze, "\uFA91"=>"\u6674".freeze, "\uFA92"=>"\u6717".freeze, "\uFA93"=>"\u671B".freeze, "\uFA94"=>"\u6756".freeze, "\uFA95"=>"\u6B79".freeze, "\uFA96"=>"\u6BBA".freeze,
    "\uFA97"=>"\u6D41".freeze, "\uFA98"=>"\u6EDB".freeze, "\uFA99"=>"\u6ECB".freeze, "\uFA9A"=>"\u6F22".freeze, "\uFA9B"=>"\u701E".freeze, "\uFA9C"=>"\u716E".freeze, "\uFA9D"=>"\u77A7".freeze, "\uFA9E"=>"\u7235".freeze,
    "\uFA9F"=>"\u72AF".freeze, "\uFAA0"=>"\u732A".freeze, "\uFAA1"=>"\u7471".freeze, "\uFAA2"=>"\u7506".freeze, "\uFAA3"=>"\u753B".freeze, "\uFAA4"=>"\u761D".freeze, "\uFAA5"=>"\u761F".freeze, "\uFAA6"=>"\u76CA".freeze,
    "\uFAA7"=>"\u76DB".freeze, "\uFAA8"=>"\u76F4".freeze, "\uFAA9"=>"\u774A".freeze, "\uFAAA"=>"\u7740".freeze, "\uFAAB"=>"\u78CC".freeze, "\uFAAC"=>"\u7AB1".freeze, "\uFAAD"=>"\u7BC0".freeze, "\uFAAE"=>"\u7C7B".freeze,
    "\uFAAF"=>"\u7D5B".freeze, "\uFAB0"=>"\u7DF4".freeze, "\uFAB1"=>"\u7F3E".freeze, "\uFAB2"=>"\u8005".freeze, "\uFAB3"=>"\u8352".freeze, "\uFAB4"=>"\u83EF".freeze, "\uFAB5"=>"\u8779".freeze, "\uFAB6"=>"\u8941".freeze,
    "\uFAB7"=>"\u8986".freeze, "\uFAB8"=>"\u8996".freeze, "\uFAB9"=>"\u8ABF".freeze, "\uFABA"=>"\u8AF8".freeze, "\uFABB"=>"\u8ACB".freeze, "\uFABC"=>"\u8B01".freeze, "\uFABD"=>"\u8AFE".freeze, "\uFABE"=>"\u8AED".freeze,
    "\uFABF"=>"\u8B39".freeze, "\uFAC0"=>"\u8B8A".freeze, "\uFAC1"=>"\u8D08".freeze, "\uFAC2"=>"\u8F38".freeze, "\uFAC3"=>"\u9072".freeze, "\uFAC4"=>"\u9199".freeze, "\uFAC5"=>"\u9276".freeze, "\uFAC6"=>"\u967C".freeze,
    "\uFAC7"=>"\u96E3".freeze, "\uFAC8"=>"\u9756".freeze, "\uFAC9"=>"\u97DB".freeze, "\uFACA"=>"\u97FF".freeze, "\uFACB"=>"\u980B".freeze, "\uFACC"=>"\u983B".freeze, "\uFACD"=>"\u9B12".freeze, "\uFACE"=>"\u9F9C".freeze,
    "\uFACF"=>"\u{2284A}".freeze, "\uFAD0"=>"\u{22844}".freeze, "\uFAD1"=>"\u{233D5}".freeze, "\uFAD2"=>"\u3B9D".freeze, "\uFAD3"=>"\u4018".freeze, "\uFAD4"=>"\u4039".freeze, "\uFAD5"=>"\u{25249}".freeze, "\uFAD6"=>"\u{25CD0}".freeze,
    "\uFAD7"=>"\u{27ED3}".freeze, "\uFAD8"=>"\u9F43".freeze, "\uFAD9"=>"\u9F8E".freeze, "\uFB1D"=>"\u05D9\u05B4".freeze, "\uFB1F"=>"\u05F2\u05B7".freeze, "\uFB2A"=>"\u05E9\u05C1".freeze, "\uFB2B"=>"\u05E9\u05C2".freeze, "\uFB2C"=>"\u05E9\u05BC\u05C1".freeze,
    "\uFB2D"=>"\u05E9\u05BC\u05C2".freeze, "\uFB2E"=>"\u05D0\u05B7".freeze, "\uFB2F"=>"\u05D0\u05B8".freeze, "\uFB30"=>"\u05D0\u05BC".freeze, "\uFB31"=>"\u05D1\u05BC".freeze, "\uFB32"=>"\u05D2\u05BC".freeze, "\uFB33"=>"\u05D3\u05BC".freeze, "\uFB34"=>"\u05D4\u05BC".freeze,
    "\uFB35"=>"\u05D5\u05BC".freeze, "\uFB36"=>"\u05D6\u05BC".freeze, "\uFB38"=>"\u05D8\u05BC".freeze, "\uFB39"=>"\u05D9\u05BC".freeze, "\uFB3A"=>"\u05DA\u05BC".freeze, "\uFB3B"=>"\u05DB\u05BC".freeze, "\uFB3C"=>"\u05DC\u05BC".freeze, "\uFB3E"=>"\u05DE\u05BC".freeze,
    "\uFB40"=>"\u05E0\u05BC".freeze, "\uFB41"=>"\u05E1\u05BC".freeze, "\uFB43"=>"\u05E3\u05BC".freeze, "\uFB44"=>"\u05E4\u05BC".freeze, "\uFB46"=>"\u05E6\u05BC".freeze, "\uFB47"=>"\u05E7\u05BC".freeze, "\uFB48"=>"\u05E8\u05BC".freeze, "\uFB49"=>"\u05E9\u05BC".freeze,
    "\uFB4A"=>"\u05EA\u05BC".freeze, "\uFB4B"=>"\u05D5\u05B9".freeze, "\uFB4C"=>"\u05D1\u05BF".freeze, "\uFB4D"=>"\u05DB\u05BF".freeze, "\uFB4E"=>"\u05E4\u05BF".freeze, "\u{1109A}"=>"\u{11099}\u{110BA}".freeze, "\u{1109C}"=>"\u{1109B}\u{110BA}".freeze, "\u{110AB}"=>"\u{110A5}\u{110BA}".freeze,
    "\u{1112E}"=>"\u{11131}\u{11127}".freeze, "\u{1112F}"=>"\u{11132}\u{11127}".freeze, "\u{1134B}"=>"\u{11347}\u{1133E}".freeze, "\u{1134C}"=>"\u{11347}\u{11357}".freeze, "\u{114BB}"=>"\u{114B9}\u{114BA}".freeze, "\u{114BC}"=>"\u{114B9}\u{114B0}".freeze, "\u{114BE}"=>"\u{114B9}\u{114BD}".freeze, "\u{115BA}"=>"\u{115B8}\u{115AF}".freeze,
    "\u{115BB}"=>"\u{115B9}\u{115AF}".freeze, "\u{1D15E}"=>"\u{1D157}\u{1D165}".freeze, "\u{1D15F}"=>"\u{1D158}\u{1D165}".freeze, "\u{1D160}"=>"\u{1D158}\u{1D165}\u{1D16E}".freeze, "\u{1D161}"=>"\u{1D158}\u{1D165}\u{1D16F}".freeze, "\u{1D162}"=>"\u{1D158}\u{1D165}\u{1D170}".freeze, "\u{1D163}"=>"\u{1D158}\u{1D165}\u{1D171}".freeze, "\u{1D164}"=>"\u{1D158}\u{1D165}\u{1D172}".freeze,
    "\u{1D1BB}"=>"\u{1D1B9}\u{1D165}".freeze, "\u{1D1BC}"=>"\u{1D1BA}\u{1D165}".freeze, "\u{1D1BD}"=>"\u{1D1B9}\u{1D165}\u{1D16E}".freeze, "\u{1D1BE}"=>"\u{1D1BA}\u{1D165}\u{1D16E}".freeze, "\u{1D1BF}"=>"\u{1D1B9}\u{1D165}\u{1D16F}".freeze, "\u{1D1C0}"=>"\u{1D1BA}\u{1D165}\u{1D16F}".freeze, "\u{2F800}"=>"\u4E3D".freeze, "\u{2F801}"=>"\u4E38".freeze,
    "\u{2F802}"=>"\u4E41".freeze, "\u{2F803}"=>"\u{20122}".freeze, "\u{2F804}"=>"\u4F60".freeze, "\u{2F805}"=>"\u4FAE".freeze, "\u{2F806}"=>"\u4FBB".freeze, "\u{2F807}"=>"\u5002".freeze, "\u{2F808}"=>"\u507A".freeze, "\u{2F809}"=>"\u5099".freeze,
    "\u{2F80A}"=>"\u50E7".freeze, "\u{2F80B}"=>"\u50CF".freeze, "\u{2F80C}"=>"\u349E".freeze, "\u{2F80D}"=>"\u{2063A}".freeze, "\u{2F80E}"=>"\u514D".freeze, "\u{2F80F}"=>"\u5154".freeze, "\u{2F810}"=>"\u5164".freeze, "\u{2F811}"=>"\u5177".freeze,
    "\u{2F812}"=>"\u{2051C}".freeze, "\u{2F813}"=>"\u34B9".freeze, "\u{2F814}"=>"\u5167".freeze, "\u{2F815}"=>"\u518D".freeze, "\u{2F816}"=>"\u{2054B}".freeze, "\u{2F817}"=>"\u5197".freeze, "\u{2F818}"=>"\u51A4".freeze, "\u{2F819}"=>"\u4ECC".freeze,
    "\u{2F81A}"=>"\u51AC".freeze, "\u{2F81B}"=>"\u51B5".freeze, "\u{2F81C}"=>"\u{291DF}".freeze, "\u{2F81D}"=>"\u51F5".freeze, "\u{2F81E}"=>"\u5203".freeze, "\u{2F81F}"=>"\u34DF".freeze, "\u{2F820}"=>"\u523B".freeze, "\u{2F821}"=>"\u5246".freeze,
    "\u{2F822}"=>"\u5272".freeze, "\u{2F823}"=>"\u5277".freeze, "\u{2F824}"=>"\u3515".freeze, "\u{2F825}"=>"\u52C7".freeze, "\u{2F826}"=>"\u52C9".freeze, "\u{2F827}"=>"\u52E4".freeze, "\u{2F828}"=>"\u52FA".freeze, "\u{2F829}"=>"\u5305".freeze,
    "\u{2F82A}"=>"\u5306".freeze, "\u{2F82B}"=>"\u5317".freeze, "\u{2F82C}"=>"\u5349".freeze, "\u{2F82D}"=>"\u5351".freeze, "\u{2F82E}"=>"\u535A".freeze, "\u{2F82F}"=>"\u5373".freeze, "\u{2F830}"=>"\u537D".freeze, "\u{2F831}"=>"\u537F".freeze,
    "\u{2F832}"=>"\u537F".freeze, "\u{2F833}"=>"\u537F".freeze, "\u{2F834}"=>"\u{20A2C}".freeze, "\u{2F835}"=>"\u7070".freeze, "\u{2F836}"=>"\u53CA".freeze, "\u{2F837}"=>"\u53DF".freeze, "\u{2F838}"=>"\u{20B63}".freeze, "\u{2F839}"=>"\u53EB".freeze,
    "\u{2F83A}"=>"\u53F1".freeze, "\u{2F83B}"=>"\u5406".freeze, "\u{2F83C}"=>"\u549E".freeze, "\u{2F83D}"=>"\u5438".freeze, "\u{2F83E}"=>"\u5448".freeze, "\u{2F83F}"=>"\u5468".freeze, "\u{2F840}"=>"\u54A2".freeze, "\u{2F841}"=>"\u54F6".freeze,
    "\u{2F842}"=>"\u5510".freeze, "\u{2F843}"=>"\u5553".freeze, "\u{2F844}"=>"\u5563".freeze, "\u{2F845}"=>"\u5584".freeze, "\u{2F846}"=>"\u5584".freeze, "\u{2F847}"=>"\u5599".freeze, "\u{2F848}"=>"\u55AB".freeze, "\u{2F849}"=>"\u55B3".freeze,
    "\u{2F84A}"=>"\u55C2".freeze, "\u{2F84B}"=>"\u5716".freeze, "\u{2F84C}"=>"\u5606".freeze, "\u{2F84D}"=>"\u5717".freeze, "\u{2F84E}"=>"\u5651".freeze, "\u{2F84F}"=>"\u5674".freeze, "\u{2F850}"=>"\u5207".freeze, "\u{2F851}"=>"\u58EE".freeze,
    "\u{2F852}"=>"\u57CE".freeze, "\u{2F853}"=>"\u57F4".freeze, "\u{2F854}"=>"\u580D".freeze, "\u{2F855}"=>"\u578B".freeze, "\u{2F856}"=>"\u5832".freeze, "\u{2F857}"=>"\u5831".freeze, "\u{2F858}"=>"\u58AC".freeze, "\u{2F859}"=>"\u{214E4}".freeze,
    "\u{2F85A}"=>"\u58F2".freeze, "\u{2F85B}"=>"\u58F7".freeze, "\u{2F85C}"=>"\u5906".freeze, "\u{2F85D}"=>"\u591A".freeze, "\u{2F85E}"=>"\u5922".freeze, "\u{2F85F}"=>"\u5962".freeze, "\u{2F860}"=>"\u{216A8}".freeze, "\u{2F861}"=>"\u{216EA}".freeze,
    "\u{2F862}"=>"\u59EC".freeze, "\u{2F863}"=>"\u5A1B".freeze, "\u{2F864}"=>"\u5A27".freeze, "\u{2F865}"=>"\u59D8".freeze, "\u{2F866}"=>"\u5A66".freeze, "\u{2F867}"=>"\u36EE".freeze, "\u{2F868}"=>"\u36FC".freeze, "\u{2F869}"=>"\u5B08".freeze,
    "\u{2F86A}"=>"\u5B3E".freeze, "\u{2F86B}"=>"\u5B3E".freeze, "\u{2F86C}"=>"\u{219C8}".freeze, "\u{2F86D}"=>"\u5BC3".freeze, "\u{2F86E}"=>"\u5BD8".freeze, "\u{2F86F}"=>"\u5BE7".freeze, "\u{2F870}"=>"\u5BF3".freeze, "\u{2F871}"=>"\u{21B18}".freeze,
    "\u{2F872}"=>"\u5BFF".freeze, "\u{2F873}"=>"\u5C06".freeze, "\u{2F874}"=>"\u5F53".freeze, "\u{2F875}"=>"\u5C22".freeze, "\u{2F876}"=>"\u3781".freeze, "\u{2F877}"=>"\u5C60".freeze, "\u{2F878}"=>"\u5C6E".freeze, "\u{2F879}"=>"\u5CC0".freeze,
    "\u{2F87A}"=>"\u5C8D".freeze, "\u{2F87B}"=>"\u{21DE4}".freeze, "\u{2F87C}"=>"\u5D43".freeze, "\u{2F87D}"=>"\u{21DE6}".freeze, "\u{2F87E}"=>"\u5D6E".freeze, "\u{2F87F}"=>"\u5D6B".freeze, "\u{2F880}"=>"\u5D7C".freeze, "\u{2F881}"=>"\u5DE1".freeze,
    "\u{2F882}"=>"\u5DE2".freeze, "\u{2F883}"=>"\u382F".freeze, "\u{2F884}"=>"\u5DFD".freeze, "\u{2F885}"=>"\u5E28".freeze, "\u{2F886}"=>"\u5E3D".freeze, "\u{2F887}"=>"\u5E69".freeze, "\u{2F888}"=>"\u3862".freeze, "\u{2F889}"=>"\u{22183}".freeze,
    "\u{2F88A}"=>"\u387C".freeze, "\u{2F88B}"=>"\u5EB0".freeze, "\u{2F88C}"=>"\u5EB3".freeze, "\u{2F88D}"=>"\u5EB6".freeze, "\u{2F88E}"=>"\u5ECA".freeze, "\u{2F88F}"=>"\u{2A392}".freeze, "\u{2F890}"=>"\u5EFE".freeze, "\u{2F891}"=>"\u{22331}".freeze,
    "\u{2F892}"=>"\u{22331}".freeze, "\u{2F893}"=>"\u8201".freeze, "\u{2F894}"=>"\u5F22".freeze, "\u{2F895}"=>"\u5F22".freeze, "\u{2F896}"=>"\u38C7".freeze, "\u{2F897}"=>"\u{232B8}".freeze, "\u{2F898}"=>"\u{261DA}".freeze, "\u{2F899}"=>"\u5F62".freeze,
    "\u{2F89A}"=>"\u5F6B".freeze, "\u{2F89B}"=>"\u38E3".freeze, "\u{2F89C}"=>"\u5F9A".freeze, "\u{2F89D}"=>"\u5FCD".freeze, "\u{2F89E}"=>"\u5FD7".freeze, "\u{2F89F}"=>"\u5FF9".freeze, "\u{2F8A0}"=>"\u6081".freeze, "\u{2F8A1}"=>"\u393A".freeze,
    "\u{2F8A2}"=>"\u391C".freeze, "\u{2F8A3}"=>"\u6094".freeze, "\u{2F8A4}"=>"\u{226D4}".freeze, "\u{2F8A5}"=>"\u60C7".freeze, "\u{2F8A6}"=>"\u6148".freeze, "\u{2F8A7}"=>"\u614C".freeze, "\u{2F8A8}"=>"\u614E".freeze, "\u{2F8A9}"=>"\u614C".freeze,
    "\u{2F8AA}"=>"\u617A".freeze, "\u{2F8AB}"=>"\u618E".freeze, "\u{2F8AC}"=>"\u61B2".freeze, "\u{2F8AD}"=>"\u61A4".freeze, "\u{2F8AE}"=>"\u61AF".freeze, "\u{2F8AF}"=>"\u61DE".freeze, "\u{2F8B0}"=>"\u61F2".freeze, "\u{2F8B1}"=>"\u61F6".freeze,
    "\u{2F8B2}"=>"\u6210".freeze, "\u{2F8B3}"=>"\u621B".freeze, "\u{2F8B4}"=>"\u625D".freeze, "\u{2F8B5}"=>"\u62B1".freeze, "\u{2F8B6}"=>"\u62D4".freeze, "\u{2F8B7}"=>"\u6350".freeze, "\u{2F8B8}"=>"\u{22B0C}".freeze, "\u{2F8B9}"=>"\u633D".freeze,
    "\u{2F8BA}"=>"\u62FC".freeze, "\u{2F8BB}"=>"\u6368".freeze, "\u{2F8BC}"=>"\u6383".freeze, "\u{2F8BD}"=>"\u63E4".freeze, "\u{2F8BE}"=>"\u{22BF1}".freeze, "\u{2F8BF}"=>"\u6422".freeze, "\u{2F8C0}"=>"\u63C5".freeze, "\u{2F8C1}"=>"\u63A9".freeze,
    "\u{2F8C2}"=>"\u3A2E".freeze, "\u{2F8C3}"=>"\u6469".freeze, "\u{2F8C4}"=>"\u647E".freeze, "\u{2F8C5}"=>"\u649D".freeze, "\u{2F8C6}"=>"\u6477".freeze, "\u{2F8C7}"=>"\u3A6C".freeze, "\u{2F8C8}"=>"\u654F".freeze, "\u{2F8C9}"=>"\u656C".freeze,
    "\u{2F8CA}"=>"\u{2300A}".freeze, "\u{2F8CB}"=>"\u65E3".freeze, "\u{2F8CC}"=>"\u66F8".freeze, "\u{2F8CD}"=>"\u6649".freeze, "\u{2F8CE}"=>"\u3B19".freeze, "\u{2F8CF}"=>"\u6691".freeze, "\u{2F8D0}"=>"\u3B08".freeze, "\u{2F8D1}"=>"\u3AE4".freeze,
    "\u{2F8D2}"=>"\u5192".freeze, "\u{2F8D3}"=>"\u5195".freeze, "\u{2F8D4}"=>"\u6700".freeze, "\u{2F8D5}"=>"\u669C".freeze, "\u{2F8D6}"=>"\u80AD".freeze, "\u{2F8D7}"=>"\u43D9".freeze, "\u{2F8D8}"=>"\u6717".freeze, "\u{2F8D9}"=>"\u671B".freeze,
    "\u{2F8DA}"=>"\u6721".freeze, "\u{2F8DB}"=>"\u675E".freeze, "\u{2F8DC}"=>"\u6753".freeze, "\u{2F8DD}"=>"\u{233C3}".freeze, "\u{2F8DE}"=>"\u3B49".freeze, "\u{2F8DF}"=>"\u67FA".freeze, "\u{2F8E0}"=>"\u6785".freeze, "\u{2F8E1}"=>"\u6852".freeze,
    "\u{2F8E2}"=>"\u6885".freeze, "\u{2F8E3}"=>"\u{2346D}".freeze, "\u{2F8E4}"=>"\u688E".freeze, "\u{2F8E5}"=>"\u681F".freeze, "\u{2F8E6}"=>"\u6914".freeze, "\u{2F8E7}"=>"\u3B9D".freeze, "\u{2F8E8}"=>"\u6942".freeze, "\u{2F8E9}"=>"\u69A3".freeze,
    "\u{2F8EA}"=>"\u69EA".freeze, "\u{2F8EB}"=>"\u6AA8".freeze, "\u{2F8EC}"=>"\u{236A3}".freeze, "\u{2F8ED}"=>"\u6ADB".freeze, "\u{2F8EE}"=>"\u3C18".freeze, "\u{2F8EF}"=>"\u6B21".freeze, "\u{2F8F0}"=>"\u{238A7}".freeze, "\u{2F8F1}"=>"\u6B54".freeze,
    "\u{2F8F2}"=>"\u3C4E".freeze, "\u{2F8F3}"=>"\u6B72".freeze, "\u{2F8F4}"=>"\u6B9F".freeze, "\u{2F8F5}"=>"\u6BBA".freeze, "\u{2F8F6}"=>"\u6BBB".freeze, "\u{2F8F7}"=>"\u{23A8D}".freeze, "\u{2F8F8}"=>"\u{21D0B}".freeze, "\u{2F8F9}"=>"\u{23AFA}".freeze,
    "\u{2F8FA}"=>"\u6C4E".freeze, "\u{2F8FB}"=>"\u{23CBC}".freeze, "\u{2F8FC}"=>"\u6CBF".freeze, "\u{2F8FD}"=>"\u6CCD".freeze, "\u{2F8FE}"=>"\u6C67".freeze, "\u{2F8FF}"=>"\u6D16".freeze, "\u{2F900}"=>"\u6D3E".freeze, "\u{2F901}"=>"\u6D77".freeze,
    "\u{2F902}"=>"\u6D41".freeze, "\u{2F903}"=>"\u6D69".freeze, "\u{2F904}"=>"\u6D78".freeze, "\u{2F905}"=>"\u6D85".freeze, "\u{2F906}"=>"\u{23D1E}".freeze, "\u{2F907}"=>"\u6D34".freeze, "\u{2F908}"=>"\u6E2F".freeze, "\u{2F909}"=>"\u6E6E".freeze,
    "\u{2F90A}"=>"\u3D33".freeze, "\u{2F90B}"=>"\u6ECB".freeze, "\u{2F90C}"=>"\u6EC7".freeze, "\u{2F90D}"=>"\u{23ED1}".freeze, "\u{2F90E}"=>"\u6DF9".freeze, "\u{2F90F}"=>"\u6F6E".freeze, "\u{2F910}"=>"\u{23F5E}".freeze, "\u{2F911}"=>"\u{23F8E}".freeze,
    "\u{2F912}"=>"\u6FC6".freeze, "\u{2F913}"=>"\u7039".freeze, "\u{2F914}"=>"\u701E".freeze, "\u{2F915}"=>"\u701B".freeze, "\u{2F916}"=>"\u3D96".freeze, "\u{2F917}"=>"\u704A".freeze, "\u{2F918}"=>"\u707D".freeze, "\u{2F919}"=>"\u7077".freeze,
    "\u{2F91A}"=>"\u70AD".freeze, "\u{2F91B}"=>"\u{20525}".freeze, "\u{2F91C}"=>"\u7145".freeze, "\u{2F91D}"=>"\u{24263}".freeze, "\u{2F91E}"=>"\u719C".freeze, "\u{2F91F}"=>"\u{243AB}".freeze, "\u{2F920}"=>"\u7228".freeze, "\u{2F921}"=>"\u7235".freeze,
    "\u{2F922}"=>"\u7250".freeze, "\u{2F923}"=>"\u{24608}".freeze, "\u{2F924}"=>"\u7280".freeze, "\u{2F925}"=>"\u7295".freeze, "\u{2F926}"=>"\u{24735}".freeze, "\u{2F927}"=>"\u{24814}".freeze, "\u{2F928}"=>"\u737A".freeze, "\u{2F929}"=>"\u738B".freeze,
    "\u{2F92A}"=>"\u3EAC".freeze, "\u{2F92B}"=>"\u73A5".freeze, "\u{2F92C}"=>"\u3EB8".freeze, "\u{2F92D}"=>"\u3EB8".freeze, "\u{2F92E}"=>"\u7447".freeze, "\u{2F92F}"=>"\u745C".freeze, "\u{2F930}"=>"\u7471".freeze, "\u{2F931}"=>"\u7485".freeze,
    "\u{2F932}"=>"\u74CA".freeze, "\u{2F933}"=>"\u3F1B".freeze, "\u{2F934}"=>"\u7524".freeze, "\u{2F935}"=>"\u{24C36}".freeze, "\u{2F936}"=>"\u753E".freeze, "\u{2F937}"=>"\u{24C92}".freeze, "\u{2F938}"=>"\u7570".freeze, "\u{2F939}"=>"\u{2219F}".freeze,
    "\u{2F93A}"=>"\u7610".freeze, "\u{2F93B}"=>"\u{24FA1}".freeze, "\u{2F93C}"=>"\u{24FB8}".freeze, "\u{2F93D}"=>"\u{25044}".freeze, "\u{2F93E}"=>"\u3FFC".freeze, "\u{2F93F}"=>"\u4008".freeze, "\u{2F940}"=>"\u76F4".freeze, "\u{2F941}"=>"\u{250F3}".freeze,
    "\u{2F942}"=>"\u{250F2}".freeze, "\u{2F943}"=>"\u{25119}".freeze, "\u{2F944}"=>"\u{25133}".freeze, "\u{2F945}"=>"\u771E".freeze, "\u{2F946}"=>"\u771F".freeze, "\u{2F947}"=>"\u771F".freeze, "\u{2F948}"=>"\u774A".freeze, "\u{2F949}"=>"\u4039".freeze,
    "\u{2F94A}"=>"\u778B".freeze, "\u{2F94B}"=>"\u4046".freeze, "\u{2F94C}"=>"\u4096".freeze, "\u{2F94D}"=>"\u{2541D}".freeze, "\u{2F94E}"=>"\u784E".freeze, "\u{2F94F}"=>"\u788C".freeze, "\u{2F950}"=>"\u78CC".freeze, "\u{2F951}"=>"\u40E3".freeze,
    "\u{2F952}"=>"\u{25626}".freeze, "\u{2F953}"=>"\u7956".freeze, "\u{2F954}"=>"\u{2569A}".freeze, "\u{2F955}"=>"\u{256C5}".freeze, "\u{2F956}"=>"\u798F".freeze, "\u{2F957}"=>"\u79EB".freeze, "\u{2F958}"=>"\u412F".freeze, "\u{2F959}"=>"\u7A40".freeze,
    "\u{2F95A}"=>"\u7A4A".freeze, "\u{2F95B}"=>"\u7A4F".freeze, "\u{2F95C}"=>"\u{2597C}".freeze, "\u{2F95D}"=>"\u{25AA7}".freeze, "\u{2F95E}"=>"\u{25AA7}".freeze, "\u{2F95F}"=>"\u7AEE".freeze, "\u{2F960}"=>"\u4202".freeze, "\u{2F961}"=>"\u{25BAB}".freeze,
    "\u{2F962}"=>"\u7BC6".freeze, "\u{2F963}"=>"\u7BC9".freeze, "\u{2F964}"=>"\u4227".freeze, "\u{2F965}"=>"\u{25C80}".freeze, "\u{2F966}"=>"\u7CD2".freeze, "\u{2F967}"=>"\u42A0".freeze, "\u{2F968}"=>"\u7CE8".freeze, "\u{2F969}"=>"\u7CE3".freeze,
    "\u{2F96A}"=>"\u7D00".freeze, "\u{2F96B}"=>"\u{25F86}".freeze, "\u{2F96C}"=>"\u7D63".freeze, "\u{2F96D}"=>"\u4301".freeze, "\u{2F96E}"=>"\u7DC7".freeze, "\u{2F96F}"=>"\u7E02".freeze, "\u{2F970}"=>"\u7E45".freeze, "\u{2F971}"=>"\u4334".freeze,
    "\u{2F972}"=>"\u{26228}".freeze, "\u{2F973}"=>"\u{26247}".freeze, "\u{2F974}"=>"\u4359".freeze, "\u{2F975}"=>"\u{262D9}".freeze, "\u{2F976}"=>"\u7F7A".freeze, "\u{2F977}"=>"\u{2633E}".freeze, "\u{2F978}"=>"\u7F95".freeze, "\u{2F979}"=>"\u7FFA".freeze,
    "\u{2F97A}"=>"\u8005".freeze, "\u{2F97B}"=>"\u{264DA}".freeze, "\u{2F97C}"=>"\u{26523}".freeze, "\u{2F97D}"=>"\u8060".freeze, "\u{2F97E}"=>"\u{265A8}".freeze, "\u{2F97F}"=>"\u8070".freeze, "\u{2F980}"=>"\u{2335F}".freeze, "\u{2F981}"=>"\u43D5".freeze,
    "\u{2F982}"=>"\u80B2".freeze, "\u{2F983}"=>"\u8103".freeze, "\u{2F984}"=>"\u440B".freeze, "\u{2F985}"=>"\u813E".freeze, "\u{2F986}"=>"\u5AB5".freeze, "\u{2F987}"=>"\u{267A7}".freeze, "\u{2F988}"=>"\u{267B5}".freeze, "\u{2F989}"=>"\u{23393}".freeze,
    "\u{2F98A}"=>"\u{2339C}".freeze, "\u{2F98B}"=>"\u8201".freeze, "\u{2F98C}"=>"\u8204".freeze, "\u{2F98D}"=>"\u8F9E".freeze, "\u{2F98E}"=>"\u446B".freeze, "\u{2F98F}"=>"\u8291".freeze, "\u{2F990}"=>"\u828B".freeze, "\u{2F991}"=>"\u829D".freeze,
    "\u{2F992}"=>"\u52B3".freeze, "\u{2F993}"=>"\u82B1".freeze, "\u{2F994}"=>"\u82B3".freeze, "\u{2F995}"=>"\u82BD".freeze, "\u{2F996}"=>"\u82E6".freeze, "\u{2F997}"=>"\u{26B3C}".freeze, "\u{2F998}"=>"\u82E5".freeze, "\u{2F999}"=>"\u831D".freeze,
    "\u{2F99A}"=>"\u8363".freeze, "\u{2F99B}"=>"\u83AD".freeze, "\u{2F99C}"=>"\u8323".freeze, "\u{2F99D}"=>"\u83BD".freeze, "\u{2F99E}"=>"\u83E7".freeze, "\u{2F99F}"=>"\u8457".freeze, "\u{2F9A0}"=>"\u8353".freeze, "\u{2F9A1}"=>"\u83CA".freeze,
    "\u{2F9A2}"=>"\u83CC".freeze, "\u{2F9A3}"=>"\u83DC".freeze, "\u{2F9A4}"=>"\u{26C36}".freeze, "\u{2F9A5}"=>"\u{26D6B}".freeze, "\u{2F9A6}"=>"\u{26CD5}".freeze, "\u{2F9A7}"=>"\u452B".freeze, "\u{2F9A8}"=>"\u84F1".freeze, "\u{2F9A9}"=>"\u84F3".freeze,
    "\u{2F9AA}"=>"\u8516".freeze, "\u{2F9AB}"=>"\u{273CA}".freeze, "\u{2F9AC}"=>"\u8564".freeze, "\u{2F9AD}"=>"\u{26F2C}".freeze, "\u{2F9AE}"=>"\u455D".freeze, "\u{2F9AF}"=>"\u4561".freeze, "\u{2F9B0}"=>"\u{26FB1}".freeze, "\u{2F9B1}"=>"\u{270D2}".freeze,
    "\u{2F9B2}"=>"\u456B".freeze, "\u{2F9B3}"=>"\u8650".freeze, "\u{2F9B4}"=>"\u865C".freeze, "\u{2F9B5}"=>"\u8667".freeze, "\u{2F9B6}"=>"\u8669".freeze, "\u{2F9B7}"=>"\u86A9".freeze, "\u{2F9B8}"=>"\u8688".freeze, "\u{2F9B9}"=>"\u870E".freeze,
    "\u{2F9BA}"=>"\u86E2".freeze, "\u{2F9BB}"=>"\u8779".freeze, "\u{2F9BC}"=>"\u8728".freeze, "\u{2F9BD}"=>"\u876B".freeze, "\u{2F9BE}"=>"\u8786".freeze, "\u{2F9BF}"=>"\u45D7".freeze, "\u{2F9C0}"=>"\u87E1".freeze, "\u{2F9C1}"=>"\u8801".freeze,
    "\u{2F9C2}"=>"\u45F9".freeze, "\u{2F9C3}"=>"\u8860".freeze, "\u{2F9C4}"=>"\u8863".freeze, "\u{2F9C5}"=>"\u{27667}".freeze, "\u{2F9C6}"=>"\u88D7".freeze, "\u{2F9C7}"=>"\u88DE".freeze, "\u{2F9C8}"=>"\u4635".freeze, "\u{2F9C9}"=>"\u88FA".freeze,
    "\u{2F9CA}"=>"\u34BB".freeze, "\u{2F9CB}"=>"\u{278AE}".freeze, "\u{2F9CC}"=>"\u{27966}".freeze, "\u{2F9CD}"=>"\u46BE".freeze, "\u{2F9CE}"=>"\u46C7".freeze, "\u{2F9CF}"=>"\u8AA0".freeze, "\u{2F9D0}"=>"\u8AED".freeze, "\u{2F9D1}"=>"\u8B8A".freeze,
    "\u{2F9D2}"=>"\u8C55".freeze, "\u{2F9D3}"=>"\u{27CA8}".freeze, "\u{2F9D4}"=>"\u8CAB".freeze, "\u{2F9D5}"=>"\u8CC1".freeze, "\u{2F9D6}"=>"\u8D1B".freeze, "\u{2F9D7}"=>"\u8D77".freeze, "\u{2F9D8}"=>"\u{27F2F}".freeze, "\u{2F9D9}"=>"\u{20804}".freeze,
    "\u{2F9DA}"=>"\u8DCB".freeze, "\u{2F9DB}"=>"\u8DBC".freeze, "\u{2F9DC}"=>"\u8DF0".freeze, "\u{2F9DD}"=>"\u{208DE}".freeze, "\u{2F9DE}"=>"\u8ED4".freeze, "\u{2F9DF}"=>"\u8F38".freeze, "\u{2F9E0}"=>"\u{285D2}".freeze, "\u{2F9E1}"=>"\u{285ED}".freeze,
    "\u{2F9E2}"=>"\u9094".freeze, "\u{2F9E3}"=>"\u90F1".freeze, "\u{2F9E4}"=>"\u9111".freeze, "\u{2F9E5}"=>"\u{2872E}".freeze, "\u{2F9E6}"=>"\u911B".freeze, "\u{2F9E7}"=>"\u9238".freeze, "\u{2F9E8}"=>"\u92D7".freeze, "\u{2F9E9}"=>"\u92D8".freeze,
    "\u{2F9EA}"=>"\u927C".freeze, "\u{2F9EB}"=>"\u93F9".freeze, "\u{2F9EC}"=>"\u9415".freeze, "\u{2F9ED}"=>"\u{28BFA}".freeze, "\u{2F9EE}"=>"\u958B".freeze, "\u{2F9EF}"=>"\u4995".freeze, "\u{2F9F0}"=>"\u95B7".freeze, "\u{2F9F1}"=>"\u{28D77}".freeze,
    "\u{2F9F2}"=>"\u49E6".freeze, "\u{2F9F3}"=>"\u96C3".freeze, "\u{2F9F4}"=>"\u5DB2".freeze, "\u{2F9F5}"=>"\u9723".freeze, "\u{2F9F6}"=>"\u{29145}".freeze, "\u{2F9F7}"=>"\u{2921A}".freeze, "\u{2F9F8}"=>"\u4A6E".freeze, "\u{2F9F9}"=>"\u4A76".freeze,
    "\u{2F9FA}"=>"\u97E0".freeze, "\u{2F9FB}"=>"\u{2940A}".freeze, "\u{2F9FC}"=>"\u4AB2".freeze, "\u{2F9FD}"=>"\u{29496}".freeze, "\u{2F9FE}"=>"\u980B".freeze, "\u{2F9FF}"=>"\u980B".freeze, "\u{2FA00}"=>"\u9829".freeze, "\u{2FA01}"=>"\u{295B6}".freeze,
    "\u{2FA02}"=>"\u98E2".freeze, "\u{2FA03}"=>"\u4B33".freeze, "\u{2FA04}"=>"\u9929".freeze, "\u{2FA05}"=>"\u99A7".freeze, "\u{2FA06}"=>"\u99C2".freeze, "\u{2FA07}"=>"\u99FE".freeze, "\u{2FA08}"=>"\u4BCE".freeze, "\u{2FA09}"=>"\u{29B30}".freeze,
    "\u{2FA0A}"=>"\u9B12".freeze, "\u{2FA0B}"=>"\u9C40".freeze, "\u{2FA0C}"=>"\u9CFD".freeze, "\u{2FA0D}"=>"\u4CCE".freeze, "\u{2FA0E}"=>"\u4CED".freeze, "\u{2FA0F}"=>"\u9D67".freeze, "\u{2FA10}"=>"\u{2A0CE}".freeze, "\u{2FA11}"=>"\u4CF8".freeze,
    "\u{2FA12}"=>"\u{2A105}".freeze, "\u{2FA13}"=>"\u{2A20E}".freeze, "\u{2FA14}"=>"\u{2A291}".freeze, "\u{2FA15}"=>"\u9EBB".freeze, "\u{2FA16}"=>"\u4D56".freeze, "\u{2FA17}"=>"\u9EF9".freeze, "\u{2FA18}"=>"\u9EFE".freeze, "\u{2FA19}"=>"\u9F05".freeze,
    "\u{2FA1A}"=>"\u9F0F".freeze, "\u{2FA1B}"=>"\u9F16".freeze, "\u{2FA1C}"=>"\u9F3B".freeze, "\u{2FA1D}"=>"\u{2A600}".freeze,
  }.freeze

  KOMPATIBLE_TABLE = {
    "\u00A0"=>" ".freeze, "\u00A8"=>" \u0308".freeze, "\u00AA"=>"a".freeze, "\u00AF"=>" \u0304".freeze, "\u00B2"=>"2".freeze, "\u00B3"=>"3".freeze, "\u00B4"=>" \u0301".freeze, "\u00B5"=>"\u03BC".freeze,
    "\u00B8"=>" \u0327".freeze, "\u00B9"=>"1".freeze, "\u00BA"=>"o".freeze, "\u00BC"=>"1\u20444".freeze, "\u00BD"=>"1\u20442".freeze, "\u00BE"=>"3\u20444".freeze, "\u0132"=>"IJ".freeze, "\u0133"=>"ij".freeze,
    "\u013F"=>"L\u00B7".freeze, "\u0140"=>"l\u00B7".freeze, "\u0149"=>"\u02BCn".freeze, "\u017F"=>"s".freeze, "\u01C4"=>"D\u017D".freeze, "\u01C5"=>"D\u017E".freeze, "\u01C6"=>"d\u017E".freeze, "\u01C7"=>"LJ".freeze,
    "\u01C8"=>"Lj".freeze, "\u01C9"=>"lj".freeze, "\u01CA"=>"NJ".freeze, "\u01CB"=>"Nj".freeze, "\u01CC"=>"nj".freeze, "\u01F1"=>"DZ".freeze, "\u01F2"=>"Dz".freeze, "\u01F3"=>"dz".freeze,
    "\u02B0"=>"h".freeze, "\u02B1"=>"\u0266".freeze, "\u02B2"=>"j".freeze, "\u02B3"=>"r".freeze, "\u02B4"=>"\u0279".freeze, "\u02B5"=>"\u027B".freeze, "\u02B6"=>"\u0281".freeze, "\u02B7"=>"w".freeze,
    "\u02B8"=>"y".freeze, "\u02D8"=>" \u0306".freeze, "\u02D9"=>" \u0307".freeze, "\u02DA"=>" \u030A".freeze, "\u02DB"=>" \u0328".freeze, "\u02DC"=>" \u0303".freeze, "\u02DD"=>" \u030B".freeze, "\u02E0"=>"\u0263".freeze,
    "\u02E1"=>"l".freeze, "\u02E2"=>"s".freeze, "\u02E3"=>"x".freeze, "\u02E4"=>"\u0295".freeze, "\u037A"=>" \u0345".freeze, "\u0384"=>" \u0301".freeze, "\u03D0"=>"\u03B2".freeze, "\u03D1"=>"\u03B8".freeze,
    "\u03D2"=>"\u03A5".freeze, "\u03D5"=>"\u03C6".freeze, "\u03D6"=>"\u03C0".freeze, "\u03F0"=>"\u03BA".freeze, "\u03F1"=>"\u03C1".freeze, "\u03F2"=>"\u03C2".freeze, "\u03F4"=>"\u0398".freeze, "\u03F5"=>"\u03B5".freeze,
    "\u03F9"=>"\u03A3".freeze, "\u0587"=>"\u0565\u0582".freeze, "\u0675"=>"\u0627\u0674".freeze, "\u0676"=>"\u0648\u0674".freeze, "\u0677"=>"\u06C7\u0674".freeze, "\u0678"=>"\u064A\u0674".freeze, "\u0E33"=>"\u0E4D\u0E32".freeze, "\u0EB3"=>"\u0ECD\u0EB2".freeze,
    "\u0EDC"=>"\u0EAB\u0E99".freeze, "\u0EDD"=>"\u0EAB\u0EA1".freeze, "\u0F0C"=>"\u0F0B".freeze, "\u0F77"=>"\u0FB2\u0F81".freeze, "\u0F79"=>"\u0FB3\u0F81".freeze, "\u10FC"=>"\u10DC".freeze, "\u1D2C"=>"A".freeze, "\u1D2D"=>"\u00C6".freeze,
    "\u1D2E"=>"B".freeze, "\u1D30"=>"D".freeze, "\u1D31"=>"E".freeze, "\u1D32"=>"\u018E".freeze, "\u1D33"=>"G".freeze, "\u1D34"=>"H".freeze, "\u1D35"=>"I".freeze, "\u1D36"=>"J".freeze,
    "\u1D37"=>"K".freeze, "\u1D38"=>"L".freeze, "\u1D39"=>"M".freeze, "\u1D3A"=>"N".freeze, "\u1D3C"=>"O".freeze, "\u1D3D"=>"\u0222".freeze, "\u1D3E"=>"P".freeze, "\u1D3F"=>"R".freeze,
    "\u1D40"=>"T".freeze, "\u1D41"=>"U".freeze, "\u1D42"=>"W".freeze, "\u1D43"=>"a".freeze, "\u1D44"=>"\u0250".freeze, "\u1D45"=>"\u0251".freeze, "\u1D46"=>"\u1D02".freeze, "\u1D47"=>"b".freeze,
    "\u1D48"=>"d".freeze, "\u1D49"=>"e".freeze, "\u1D4A"=>"\u0259".freeze, "\u1D4B"=>"\u025B".freeze, "\u1D4C"=>"\u025C".freeze, "\u1D4D"=>"g".freeze, "\u1D4F"=>"k".freeze, "\u1D50"=>"m".freeze,
    "\u1D51"=>"\u014B".freeze, "\u1D52"=>"o".freeze, "\u1D53"=>"\u0254".freeze, "\u1D54"=>"\u1D16".freeze, "\u1D55"=>"\u1D17".freeze, "\u1D56"=>"p".freeze, "\u1D57"=>"t".freeze, "\u1D58"=>"u".freeze,
    "\u1D59"=>"\u1D1D".freeze, "\u1D5A"=>"\u026F".freeze, "\u1D5B"=>"v".freeze, "\u1D5C"=>"\u1D25".freeze, "\u1D5D"=>"\u03B2".freeze, "\u1D5E"=>"\u03B3".freeze, "\u1D5F"=>"\u03B4".freeze, "\u1D60"=>"\u03C6".freeze,
    "\u1D61"=>"\u03C7".freeze, "\u1D62"=>"i".freeze, "\u1D63"=>"r".freeze, "\u1D64"=>"u".freeze, "\u1D65"=>"v".freeze, "\u1D66"=>"\u03B2".freeze, "\u1D67"=>"\u03B3".freeze, "\u1D68"=>"\u03C1".freeze,
    "\u1D69"=>"\u03C6".freeze, "\u1D6A"=>"\u03C7".freeze, "\u1D78"=>"\u043D".freeze, "\u1D9B"=>"\u0252".freeze, "\u1D9C"=>"c".freeze, "\u1D9D"=>"\u0255".freeze, "\u1D9E"=>"\u00F0".freeze, "\u1D9F"=>"\u025C".freeze,
    "\u1DA0"=>"f".freeze, "\u1DA1"=>"\u025F".freeze, "\u1DA2"=>"\u0261".freeze, "\u1DA3"=>"\u0265".freeze, "\u1DA4"=>"\u0268".freeze, "\u1DA5"=>"\u0269".freeze, "\u1DA6"=>"\u026A".freeze, "\u1DA7"=>"\u1D7B".freeze,
    "\u1DA8"=>"\u029D".freeze, "\u1DA9"=>"\u026D".freeze, "\u1DAA"=>"\u1D85".freeze, "\u1DAB"=>"\u029F".freeze, "\u1DAC"=>"\u0271".freeze, "\u1DAD"=>"\u0270".freeze, "\u1DAE"=>"\u0272".freeze, "\u1DAF"=>"\u0273".freeze,
    "\u1DB0"=>"\u0274".freeze, "\u1DB1"=>"\u0275".freeze, "\u1DB2"=>"\u0278".freeze, "\u1DB3"=>"\u0282".freeze, "\u1DB4"=>"\u0283".freeze, "\u1DB5"=>"\u01AB".freeze, "\u1DB6"=>"\u0289".freeze, "\u1DB7"=>"\u028A".freeze,
    "\u1DB8"=>"\u1D1C".freeze, "\u1DB9"=>"\u028B".freeze, "\u1DBA"=>"\u028C".freeze, "\u1DBB"=>"z".freeze, "\u1DBC"=>"\u0290".freeze, "\u1DBD"=>"\u0291".freeze, "\u1DBE"=>"\u0292".freeze, "\u1DBF"=>"\u03B8".freeze,
    "\u1E9A"=>"a\u02BE".freeze, "\u1FBD"=>" \u0313".freeze, "\u1FBF"=>" \u0313".freeze, "\u1FC0"=>" \u0342".freeze, "\u1FFE"=>" \u0314".freeze, "\u2002"=>" ".freeze, "\u2003"=>" ".freeze, "\u2004"=>" ".freeze,
    "\u2005"=>" ".freeze, "\u2006"=>" ".freeze, "\u2007"=>" ".freeze, "\u2008"=>" ".freeze, "\u2009"=>" ".freeze, "\u200A"=>" ".freeze, "\u2011"=>"\u2010".freeze, "\u2017"=>" \u0333".freeze,
    "\u2024"=>".".freeze, "\u2025"=>"..".freeze, "\u2026"=>"...".freeze, "\u202F"=>" ".freeze, "\u2033"=>"\u2032\u2032".freeze, "\u2034"=>"\u2032\u2032\u2032".freeze, "\u2036"=>"\u2035\u2035".freeze, "\u2037"=>"\u2035\u2035\u2035".freeze,
    "\u203C"=>"!!".freeze, "\u203E"=>" \u0305".freeze, "\u2047"=>"??".freeze, "\u2048"=>"?!".freeze, "\u2049"=>"!?".freeze, "\u2057"=>"\u2032\u2032\u2032\u2032".freeze, "\u205F"=>" ".freeze, "\u2070"=>"0".freeze,
    "\u2071"=>"i".freeze, "\u2074"=>"4".freeze, "\u2075"=>"5".freeze, "\u2076"=>"6".freeze, "\u2077"=>"7".freeze, "\u2078"=>"8".freeze, "\u2079"=>"9".freeze, "\u207A"=>"+".freeze,
    "\u207B"=>"\u2212".freeze, "\u207C"=>"=".freeze, "\u207D"=>"(".freeze, "\u207E"=>")".freeze, "\u207F"=>"n".freeze, "\u2080"=>"0".freeze, "\u2081"=>"1".freeze, "\u2082"=>"2".freeze,
    "\u2083"=>"3".freeze, "\u2084"=>"4".freeze, "\u2085"=>"5".freeze, "\u2086"=>"6".freeze, "\u2087"=>"7".freeze, "\u2088"=>"8".freeze, "\u2089"=>"9".freeze, "\u208A"=>"+".freeze,
    "\u208B"=>"\u2212".freeze, "\u208C"=>"=".freeze, "\u208D"=>"(".freeze, "\u208E"=>")".freeze, "\u2090"=>"a".freeze, "\u2091"=>"e".freeze, "\u2092"=>"o".freeze, "\u2093"=>"x".freeze,
    "\u2094"=>"\u0259".freeze, "\u2095"=>"h".freeze, "\u2096"=>"k".freeze, "\u2097"=>"l".freeze, "\u2098"=>"m".freeze, "\u2099"=>"n".freeze, "\u209A"=>"p".freeze, "\u209B"=>"s".freeze,
    "\u209C"=>"t".freeze, "\u20A8"=>"Rs".freeze, "\u2100"=>"a/c".freeze, "\u2101"=>"a/s".freeze, "\u2102"=>"C".freeze, "\u2103"=>"\u00B0C".freeze, "\u2105"=>"c/o".freeze, "\u2106"=>"c/u".freeze,
    "\u2107"=>"\u0190".freeze, "\u2109"=>"\u00B0F".freeze, "\u210A"=>"g".freeze, "\u210B"=>"H".freeze, "\u210C"=>"H".freeze, "\u210D"=>"H".freeze, "\u210E"=>"h".freeze, "\u210F"=>"\u0127".freeze,
    "\u2110"=>"I".freeze, "\u2111"=>"I".freeze, "\u2112"=>"L".freeze, "\u2113"=>"l".freeze, "\u2115"=>"N".freeze, "\u2116"=>"No".freeze, "\u2119"=>"P".freeze, "\u211A"=>"Q".freeze,
    "\u211B"=>"R".freeze, "\u211C"=>"R".freeze, "\u211D"=>"R".freeze, "\u2120"=>"SM".freeze, "\u2121"=>"TEL".freeze, "\u2122"=>"TM".freeze, "\u2124"=>"Z".freeze, "\u2128"=>"Z".freeze,
    "\u212C"=>"B".freeze, "\u212D"=>"C".freeze, "\u212F"=>"e".freeze, "\u2130"=>"E".freeze, "\u2131"=>"F".freeze, "\u2133"=>"M".freeze, "\u2134"=>"o".freeze, "\u2135"=>"\u05D0".freeze,
    "\u2136"=>"\u05D1".freeze, "\u2137"=>"\u05D2".freeze, "\u2138"=>"\u05D3".freeze, "\u2139"=>"i".freeze, "\u213B"=>"FAX".freeze, "\u213C"=>"\u03C0".freeze, "\u213D"=>"\u03B3".freeze, "\u213E"=>"\u0393".freeze,
    "\u213F"=>"\u03A0".freeze, "\u2140"=>"\u2211".freeze, "\u2145"=>"D".freeze, "\u2146"=>"d".freeze, "\u2147"=>"e".freeze, "\u2148"=>"i".freeze, "\u2149"=>"j".freeze, "\u2150"=>"1\u20447".freeze,
    "\u2151"=>"1\u20449".freeze, "\u2152"=>"1\u204410".freeze, "\u2153"=>"1\u20443".freeze, "\u2154"=>"2\u20443".freeze, "\u2155"=>"1\u20445".freeze, "\u2156"=>"2\u20445".freeze, "\u2157"=>"3\u20445".freeze, "\u2158"=>"4\u20445".freeze,
    "\u2159"=>"1\u20446".freeze, "\u215A"=>"5\u20446".freeze, "\u215B"=>"1\u20448".freeze, "\u215C"=>"3\u20448".freeze, "\u215D"=>"5\u20448".freeze, "\u215E"=>"7\u20448".freeze, "\u215F"=>"1\u2044".freeze, "\u2160"=>"I".freeze,
    "\u2161"=>"II".freeze, "\u2162"=>"III".freeze, "\u2163"=>"IV".freeze, "\u2164"=>"V".freeze, "\u2165"=>"VI".freeze, "\u2166"=>"VII".freeze, "\u2167"=>"VIII".freeze, "\u2168"=>"IX".freeze,
    "\u2169"=>"X".freeze, "\u216A"=>"XI".freeze, "\u216B"=>"XII".freeze, "\u216C"=>"L".freeze, "\u216D"=>"C".freeze, "\u216E"=>"D".freeze, "\u216F"=>"M".freeze, "\u2170"=>"i".freeze,
    "\u2171"=>"ii".freeze, "\u2172"=>"iii".freeze, "\u2173"=>"iv".freeze, "\u2174"=>"v".freeze, "\u2175"=>"vi".freeze, "\u2176"=>"vii".freeze, "\u2177"=>"viii".freeze, "\u2178"=>"ix".freeze,
    "\u2179"=>"x".freeze, "\u217A"=>"xi".freeze, "\u217B"=>"xii".freeze, "\u217C"=>"l".freeze, "\u217D"=>"c".freeze, "\u217E"=>"d".freeze, "\u217F"=>"m".freeze, "\u2189"=>"0\u20443".freeze,
    "\u222C"=>"\u222B\u222B".freeze, "\u222D"=>"\u222B\u222B\u222B".freeze, "\u222F"=>"\u222E\u222E".freeze, "\u2230"=>"\u222E\u222E\u222E".freeze, "\u2460"=>"1".freeze, "\u2461"=>"2".freeze, "\u2462"=>"3".freeze, "\u2463"=>"4".freeze,
    "\u2464"=>"5".freeze, "\u2465"=>"6".freeze, "\u2466"=>"7".freeze, "\u2467"=>"8".freeze, "\u2468"=>"9".freeze, "\u2469"=>"10".freeze, "\u246A"=>"11".freeze, "\u246B"=>"12".freeze,
    "\u246C"=>"13".freeze, "\u246D"=>"14".freeze, "\u246E"=>"15".freeze, "\u246F"=>"16".freeze, "\u2470"=>"17".freeze, "\u2471"=>"18".freeze, "\u2472"=>"19".freeze, "\u2473"=>"20".freeze,
    "\u2474"=>"(1)".freeze, "\u2475"=>"(2)".freeze, "\u2476"=>"(3)".freeze, "\u2477"=>"(4)".freeze, "\u2478"=>"(5)".freeze, "\u2479"=>"(6)".freeze, "\u247A"=>"(7)".freeze, "\u247B"=>"(8)".freeze,
    "\u247C"=>"(9)".freeze, "\u247D"=>"(10)".freeze, "\u247E"=>"(11)".freeze, "\u247F"=>"(12)".freeze, "\u2480"=>"(13)".freeze, "\u2481"=>"(14)".freeze, "\u2482"=>"(15)".freeze, "\u2483"=>"(16)".freeze,
    "\u2484"=>"(17)".freeze, "\u2485"=>"(18)".freeze, "\u2486"=>"(19)".freeze, "\u2487"=>"(20)".freeze, "\u2488"=>"1.".freeze, "\u2489"=>"2.".freeze, "\u248A"=>"3.".freeze, "\u248B"=>"4.".freeze,
    "\u248C"=>"5.".freeze, "\u248D"=>"6.".freeze, "\u248E"=>"7.".freeze, "\u248F"=>"8.".freeze, "\u2490"=>"9.".freeze, "\u2491"=>"10.".freeze, "\u2492"=>"11.".freeze, "\u2493"=>"12.".freeze,
    "\u2494"=>"13.".freeze, "\u2495"=>"14.".freeze, "\u2496"=>"15.".freeze, "\u2497"=>"16.".freeze, "\u2498"=>"17.".freeze, "\u2499"=>"18.".freeze, "\u249A"=>"19.".freeze, "\u249B"=>"20.".freeze,
    "\u249C"=>"(a)".freeze, "\u249D"=>"(b)".freeze, "\u249E"=>"(c)".freeze, "\u249F"=>"(d)".freeze, "\u24A0"=>"(e)".freeze, "\u24A1"=>"(f)".freeze, "\u24A2"=>"(g)".freeze, "\u24A3"=>"(h)".freeze,
    "\u24A4"=>"(i)".freeze, "\u24A5"=>"(j)".freeze, "\u24A6"=>"(k)".freeze, "\u24A7"=>"(l)".freeze, "\u24A8"=>"(m)".freeze, "\u24A9"=>"(n)".freeze, "\u24AA"=>"(o)".freeze, "\u24AB"=>"(p)".freeze,
    "\u24AC"=>"(q)".freeze, "\u24AD"=>"(r)".freeze, "\u24AE"=>"(s)".freeze, "\u24AF"=>"(t)".freeze, "\u24B0"=>"(u)".freeze, "\u24B1"=>"(v)".freeze, "\u24B2"=>"(w)".freeze, "\u24B3"=>"(x)".freeze,
    "\u24B4"=>"(y)".freeze, "\u24B5"=>"(z)".freeze, "\u24B6"=>"A".freeze, "\u24B7"=>"B".freeze, "\u24B8"=>"C".freeze, "\u24B9"=>"D".freeze, "\u24BA"=>"E".freeze, "\u24BB"=>"F".freeze,
    "\u24BC"=>"G".freeze, "\u24BD"=>"H".freeze, "\u24BE"=>"I".freeze, "\u24BF"=>"J".freeze, "\u24C0"=>"K".freeze, "\u24C1"=>"L".freeze, "\u24C2"=>"M".freeze, "\u24C3"=>"N".freeze,
    "\u24C4"=>"O".freeze, "\u24C5"=>"P".freeze, "\u24C6"=>"Q".freeze, "\u24C7"=>"R".freeze, "\u24C8"=>"S".freeze, "\u24C9"=>"T".freeze, "\u24CA"=>"U".freeze, "\u24CB"=>"V".freeze,
    "\u24CC"=>"W".freeze, "\u24CD"=>"X".freeze, "\u24CE"=>"Y".freeze, "\u24CF"=>"Z".freeze, "\u24D0"=>"a".freeze, "\u24D1"=>"b".freeze, "\u24D2"=>"c".freeze, "\u24D3"=>"d".freeze,
    "\u24D4"=>"e".freeze, "\u24D5"=>"f".freeze, "\u24D6"=>"g".freeze, "\u24D7"=>"h".freeze, "\u24D8"=>"i".freeze, "\u24D9"=>"j".freeze, "\u24DA"=>"k".freeze, "\u24DB"=>"l".freeze,
    "\u24DC"=>"m".freeze, "\u24DD"=>"n".freeze, "\u24DE"=>"o".freeze, "\u24DF"=>"p".freeze, "\u24E0"=>"q".freeze, "\u24E1"=>"r".freeze, "\u24E2"=>"s".freeze, "\u24E3"=>"t".freeze,
    "\u24E4"=>"u".freeze, "\u24E5"=>"v".freeze, "\u24E6"=>"w".freeze, "\u24E7"=>"x".freeze, "\u24E8"=>"y".freeze, "\u24E9"=>"z".freeze, "\u24EA"=>"0".freeze, "\u2A0C"=>"\u222B\u222B\u222B\u222B".freeze,
    "\u2A74"=>"::=".freeze, "\u2A75"=>"==".freeze, "\u2A76"=>"===".freeze, "\u2C7C"=>"j".freeze, "\u2C7D"=>"V".freeze, "\u2D6F"=>"\u2D61".freeze, "\u2E9F"=>"\u6BCD".freeze, "\u2EF3"=>"\u9F9F".freeze,
    "\u2F00"=>"\u4E00".freeze, "\u2F01"=>"\u4E28".freeze, "\u2F02"=>"\u4E36".freeze, "\u2F03"=>"\u4E3F".freeze, "\u2F04"=>"\u4E59".freeze, "\u2F05"=>"\u4E85".freeze, "\u2F06"=>"\u4E8C".freeze, "\u2F07"=>"\u4EA0".freeze,
    "\u2F08"=>"\u4EBA".freeze, "\u2F09"=>"\u513F".freeze, "\u2F0A"=>"\u5165".freeze, "\u2F0B"=>"\u516B".freeze, "\u2F0C"=>"\u5182".freeze, "\u2F0D"=>"\u5196".freeze, "\u2F0E"=>"\u51AB".freeze, "\u2F0F"=>"\u51E0".freeze,
    "\u2F10"=>"\u51F5".freeze, "\u2F11"=>"\u5200".freeze, "\u2F12"=>"\u529B".freeze, "\u2F13"=>"\u52F9".freeze, "\u2F14"=>"\u5315".freeze, "\u2F15"=>"\u531A".freeze, "\u2F16"=>"\u5338".freeze, "\u2F17"=>"\u5341".freeze,
    "\u2F18"=>"\u535C".freeze, "\u2F19"=>"\u5369".freeze, "\u2F1A"=>"\u5382".freeze, "\u2F1B"=>"\u53B6".freeze, "\u2F1C"=>"\u53C8".freeze, "\u2F1D"=>"\u53E3".freeze, "\u2F1E"=>"\u56D7".freeze, "\u2F1F"=>"\u571F".freeze,
    "\u2F20"=>"\u58EB".freeze, "\u2F21"=>"\u5902".freeze, "\u2F22"=>"\u590A".freeze, "\u2F23"=>"\u5915".freeze, "\u2F24"=>"\u5927".freeze, "\u2F25"=>"\u5973".freeze, "\u2F26"=>"\u5B50".freeze, "\u2F27"=>"\u5B80".freeze,
    "\u2F28"=>"\u5BF8".freeze, "\u2F29"=>"\u5C0F".freeze, "\u2F2A"=>"\u5C22".freeze, "\u2F2B"=>"\u5C38".freeze, "\u2F2C"=>"\u5C6E".freeze, "\u2F2D"=>"\u5C71".freeze, "\u2F2E"=>"\u5DDB".freeze, "\u2F2F"=>"\u5DE5".freeze,
    "\u2F30"=>"\u5DF1".freeze, "\u2F31"=>"\u5DFE".freeze, "\u2F32"=>"\u5E72".freeze, "\u2F33"=>"\u5E7A".freeze, "\u2F34"=>"\u5E7F".freeze, "\u2F35"=>"\u5EF4".freeze, "\u2F36"=>"\u5EFE".freeze, "\u2F37"=>"\u5F0B".freeze,
    "\u2F38"=>"\u5F13".freeze, "\u2F39"=>"\u5F50".freeze, "\u2F3A"=>"\u5F61".freeze, "\u2F3B"=>"\u5F73".freeze, "\u2F3C"=>"\u5FC3".freeze, "\u2F3D"=>"\u6208".freeze, "\u2F3E"=>"\u6236".freeze, "\u2F3F"=>"\u624B".freeze,
    "\u2F40"=>"\u652F".freeze, "\u2F41"=>"\u6534".freeze, "\u2F42"=>"\u6587".freeze, "\u2F43"=>"\u6597".freeze, "\u2F44"=>"\u65A4".freeze, "\u2F45"=>"\u65B9".freeze, "\u2F46"=>"\u65E0".freeze, "\u2F47"=>"\u65E5".freeze,
    "\u2F48"=>"\u66F0".freeze, "\u2F49"=>"\u6708".freeze, "\u2F4A"=>"\u6728".freeze, "\u2F4B"=>"\u6B20".freeze, "\u2F4C"=>"\u6B62".freeze, "\u2F4D"=>"\u6B79".freeze, "\u2F4E"=>"\u6BB3".freeze, "\u2F4F"=>"\u6BCB".freeze,
    "\u2F50"=>"\u6BD4".freeze, "\u2F51"=>"\u6BDB".freeze, "\u2F52"=>"\u6C0F".freeze, "\u2F53"=>"\u6C14".freeze, "\u2F54"=>"\u6C34".freeze, "\u2F55"=>"\u706B".freeze, "\u2F56"=>"\u722A".freeze, "\u2F57"=>"\u7236".freeze,
    "\u2F58"=>"\u723B".freeze, "\u2F59"=>"\u723F".freeze, "\u2F5A"=>"\u7247".freeze, "\u2F5B"=>"\u7259".freeze, "\u2F5C"=>"\u725B".freeze, "\u2F5D"=>"\u72AC".freeze, "\u2F5E"=>"\u7384".freeze, "\u2F5F"=>"\u7389".freeze,
    "\u2F60"=>"\u74DC".freeze, "\u2F61"=>"\u74E6".freeze, "\u2F62"=>"\u7518".freeze, "\u2F63"=>"\u751F".freeze, "\u2F64"=>"\u7528".freeze, "\u2F65"=>"\u7530".freeze, "\u2F66"=>"\u758B".freeze, "\u2F67"=>"\u7592".freeze,
    "\u2F68"=>"\u7676".freeze, "\u2F69"=>"\u767D".freeze, "\u2F6A"=>"\u76AE".freeze, "\u2F6B"=>"\u76BF".freeze, "\u2F6C"=>"\u76EE".freeze, "\u2F6D"=>"\u77DB".freeze, "\u2F6E"=>"\u77E2".freeze, "\u2F6F"=>"\u77F3".freeze,
    "\u2F70"=>"\u793A".freeze, "\u2F71"=>"\u79B8".freeze, "\u2F72"=>"\u79BE".freeze, "\u2F73"=>"\u7A74".freeze, "\u2F74"=>"\u7ACB".freeze, "\u2F75"=>"\u7AF9".freeze, "\u2F76"=>"\u7C73".freeze, "\u2F77"=>"\u7CF8".freeze,
    "\u2F78"=>"\u7F36".freeze, "\u2F79"=>"\u7F51".freeze, "\u2F7A"=>"\u7F8A".freeze, "\u2F7B"=>"\u7FBD".freeze, "\u2F7C"=>"\u8001".freeze, "\u2F7D"=>"\u800C".freeze, "\u2F7E"=>"\u8012".freeze, "\u2F7F"=>"\u8033".freeze,
    "\u2F80"=>"\u807F".freeze, "\u2F81"=>"\u8089".freeze, "\u2F82"=>"\u81E3".freeze, "\u2F83"=>"\u81EA".freeze, "\u2F84"=>"\u81F3".freeze, "\u2F85"=>"\u81FC".freeze, "\u2F86"=>"\u820C".freeze, "\u2F87"=>"\u821B".freeze,
    "\u2F88"=>"\u821F".freeze, "\u2F89"=>"\u826E".freeze, "\u2F8A"=>"\u8272".freeze, "\u2F8B"=>"\u8278".freeze, "\u2F8C"=>"\u864D".freeze, "\u2F8D"=>"\u866B".freeze, "\u2F8E"=>"\u8840".freeze, "\u2F8F"=>"\u884C".freeze,
    "\u2F90"=>"\u8863".freeze, "\u2F91"=>"\u897E".freeze, "\u2F92"=>"\u898B".freeze, "\u2F93"=>"\u89D2".freeze, "\u2F94"=>"\u8A00".freeze, "\u2F95"=>"\u8C37".freeze, "\u2F96"=>"\u8C46".freeze, "\u2F97"=>"\u8C55".freeze,
    "\u2F98"=>"\u8C78".freeze, "\u2F99"=>"\u8C9D".freeze, "\u2F9A"=>"\u8D64".freeze, "\u2F9B"=>"\u8D70".freeze, "\u2F9C"=>"\u8DB3".freeze, "\u2F9D"=>"\u8EAB".freeze, "\u2F9E"=>"\u8ECA".freeze, "\u2F9F"=>"\u8F9B".freeze,
    "\u2FA0"=>"\u8FB0".freeze, "\u2FA1"=>"\u8FB5".freeze, "\u2FA2"=>"\u9091".freeze, "\u2FA3"=>"\u9149".freeze, "\u2FA4"=>"\u91C6".freeze, "\u2FA5"=>"\u91CC".freeze, "\u2FA6"=>"\u91D1".freeze, "\u2FA7"=>"\u9577".freeze,
    "\u2FA8"=>"\u9580".freeze, "\u2FA9"=>"\u961C".freeze, "\u2FAA"=>"\u96B6".freeze, "\u2FAB"=>"\u96B9".freeze, "\u2FAC"=>"\u96E8".freeze, "\u2FAD"=>"\u9751".freeze, "\u2FAE"=>"\u975E".freeze, "\u2FAF"=>"\u9762".freeze,
    "\u2FB0"=>"\u9769".freeze, "\u2FB1"=>"\u97CB".freeze, "\u2FB2"=>"\u97ED".freeze, "\u2FB3"=>"\u97F3".freeze, "\u2FB4"=>"\u9801".freeze, "\u2FB5"=>"\u98A8".freeze, "\u2FB6"=>"\u98DB".freeze, "\u2FB7"=>"\u98DF".freeze,
    "\u2FB8"=>"\u9996".freeze, "\u2FB9"=>"\u9999".freeze, "\u2FBA"=>"\u99AC".freeze, "\u2FBB"=>"\u9AA8".freeze, "\u2FBC"=>"\u9AD8".freeze, "\u2FBD"=>"\u9ADF".freeze, "\u2FBE"=>"\u9B25".freeze, "\u2FBF"=>"\u9B2F".freeze,
    "\u2FC0"=>"\u9B32".freeze, "\u2FC1"=>"\u9B3C".freeze, "\u2FC2"=>"\u9B5A".freeze, "\u2FC3"=>"\u9CE5".freeze, "\u2FC4"=>"\u9E75".freeze, "\u2FC5"=>"\u9E7F".freeze, "\u2FC6"=>"\u9EA5".freeze, "\u2FC7"=>"\u9EBB".freeze,
    "\u2FC8"=>"\u9EC3".freeze, "\u2FC9"=>"\u9ECD".freeze, "\u2FCA"=>"\u9ED1".freeze, "\u2FCB"=>"\u9EF9".freeze, "\u2FCC"=>"\u9EFD".freeze, "\u2FCD"=>"\u9F0E".freeze, "\u2FCE"=>"\u9F13".freeze, "\u2FCF"=>"\u9F20".freeze,
    "\u2FD0"=>"\u9F3B".freeze, "\u2FD1"=>"\u9F4A".freeze, "\u2FD2"=>"\u9F52".freeze, "\u2FD3"=>"\u9F8D".freeze, "\u2FD4"=>"\u9F9C".freeze, "\u2FD5"=>"\u9FA0".freeze, "\u3000"=>" ".freeze, "\u3036"=>"\u3012".freeze,
    "\u3038"=>"\u5341".freeze, "\u3039"=>"\u5344".freeze, "\u303A"=>"\u5345".freeze, "\u309B"=>" \u3099".freeze, "\u309C"=>" \u309A".freeze, "\u309F"=>"\u3088\u308A".freeze, "\u30FF"=>"\u30B3\u30C8".freeze, "\u3131"=>"\u1100".freeze,
    "\u3132"=>"\u1101".freeze, "\u3133"=>"\u11AA".freeze, "\u3134"=>"\u1102".freeze, "\u3135"=>"\u11AC".freeze, "\u3136"=>"\u11AD".freeze, "\u3137"=>"\u1103".freeze, "\u3138"=>"\u1104".freeze, "\u3139"=>"\u1105".freeze,
    "\u313A"=>"\u11B0".freeze, "\u313B"=>"\u11B1".freeze, "\u313C"=>"\u11B2".freeze, "\u313D"=>"\u11B3".freeze, "\u313E"=>"\u11B4".freeze, "\u313F"=>"\u11B5".freeze, "\u3140"=>"\u111A".freeze, "\u3141"=>"\u1106".freeze,
    "\u3142"=>"\u1107".freeze, "\u3143"=>"\u1108".freeze, "\u3144"=>"\u1121".freeze, "\u3145"=>"\u1109".freeze, "\u3146"=>"\u110A".freeze, "\u3147"=>"\u110B".freeze, "\u3148"=>"\u110C".freeze, "\u3149"=>"\u110D".freeze,
    "\u314A"=>"\u110E".freeze, "\u314B"=>"\u110F".freeze, "\u314C"=>"\u1110".freeze, "\u314D"=>"\u1111".freeze, "\u314E"=>"\u1112".freeze, "\u314F"=>"\u1161".freeze, "\u3150"=>"\u1162".freeze, "\u3151"=>"\u1163".freeze,
    "\u3152"=>"\u1164".freeze, "\u3153"=>"\u1165".freeze, "\u3154"=>"\u1166".freeze, "\u3155"=>"\u1167".freeze, "\u3156"=>"\u1168".freeze, "\u3157"=>"\u1169".freeze, "\u3158"=>"\u116A".freeze, "\u3159"=>"\u116B".freeze,
    "\u315A"=>"\u116C".freeze, "\u315B"=>"\u116D".freeze, "\u315C"=>"\u116E".freeze, "\u315D"=>"\u116F".freeze, "\u315E"=>"\u1170".freeze, "\u315F"=>"\u1171".freeze, "\u3160"=>"\u1172".freeze, "\u3161"=>"\u1173".freeze,
    "\u3162"=>"\u1174".freeze, "\u3163"=>"\u1175".freeze, "\u3164"=>"\u1160".freeze, "\u3165"=>"\u1114".freeze, "\u3166"=>"\u1115".freeze, "\u3167"=>"\u11C7".freeze, "\u3168"=>"\u11C8".freeze, "\u3169"=>"\u11CC".freeze,
    "\u316A"=>"\u11CE".freeze, "\u316B"=>"\u11D3".freeze, "\u316C"=>"\u11D7".freeze, "\u316D"=>"\u11D9".freeze, "\u316E"=>"\u111C".freeze, "\u316F"=>"\u11DD".freeze, "\u3170"=>"\u11DF".freeze, "\u3171"=>"\u111D".freeze,
    "\u3172"=>"\u111E".freeze, "\u3173"=>"\u1120".freeze, "\u3174"=>"\u1122".freeze, "\u3175"=>"\u1123".freeze, "\u3176"=>"\u1127".freeze, "\u3177"=>"\u1129".freeze, "\u3178"=>"\u112B".freeze, "\u3179"=>"\u112C".freeze,
    "\u317A"=>"\u112D".freeze, "\u317B"=>"\u112E".freeze, "\u317C"=>"\u112F".freeze, "\u317D"=>"\u1132".freeze, "\u317E"=>"\u1136".freeze, "\u317F"=>"\u1140".freeze, "\u3180"=>"\u1147".freeze, "\u3181"=>"\u114C".freeze,
    "\u3182"=>"\u11F1".freeze, "\u3183"=>"\u11F2".freeze, "\u3184"=>"\u1157".freeze, "\u3185"=>"\u1158".freeze, "\u3186"=>"\u1159".freeze, "\u3187"=>"\u1184".freeze, "\u3188"=>"\u1185".freeze, "\u3189"=>"\u1188".freeze,
    "\u318A"=>"\u1191".freeze, "\u318B"=>"\u1192".freeze, "\u318C"=>"\u1194".freeze, "\u318D"=>"\u119E".freeze, "\u318E"=>"\u11A1".freeze, "\u3192"=>"\u4E00".freeze, "\u3193"=>"\u4E8C".freeze, "\u3194"=>"\u4E09".freeze,
    "\u3195"=>"\u56DB".freeze, "\u3196"=>"\u4E0A".freeze, "\u3197"=>"\u4E2D".freeze, "\u3198"=>"\u4E0B".freeze, "\u3199"=>"\u7532".freeze, "\u319A"=>"\u4E59".freeze, "\u319B"=>"\u4E19".freeze, "\u319C"=>"\u4E01".freeze,
    "\u319D"=>"\u5929".freeze, "\u319E"=>"\u5730".freeze, "\u319F"=>"\u4EBA".freeze, "\u3200"=>"(\u1100)".freeze, "\u3201"=>"(\u1102)".freeze, "\u3202"=>"(\u1103)".freeze, "\u3203"=>"(\u1105)".freeze, "\u3204"=>"(\u1106)".freeze,
    "\u3205"=>"(\u1107)".freeze, "\u3206"=>"(\u1109)".freeze, "\u3207"=>"(\u110B)".freeze, "\u3208"=>"(\u110C)".freeze, "\u3209"=>"(\u110E)".freeze, "\u320A"=>"(\u110F)".freeze, "\u320B"=>"(\u1110)".freeze, "\u320C"=>"(\u1111)".freeze,
    "\u320D"=>"(\u1112)".freeze, "\u320E"=>"(\u1100\u1161)".freeze, "\u320F"=>"(\u1102\u1161)".freeze, "\u3210"=>"(\u1103\u1161)".freeze, "\u3211"=>"(\u1105\u1161)".freeze, "\u3212"=>"(\u1106\u1161)".freeze, "\u3213"=>"(\u1107\u1161)".freeze, "\u3214"=>"(\u1109\u1161)".freeze,
    "\u3215"=>"(\u110B\u1161)".freeze, "\u3216"=>"(\u110C\u1161)".freeze, "\u3217"=>"(\u110E\u1161)".freeze, "\u3218"=>"(\u110F\u1161)".freeze, "\u3219"=>"(\u1110\u1161)".freeze, "\u321A"=>"(\u1111\u1161)".freeze, "\u321B"=>"(\u1112\u1161)".freeze, "\u321C"=>"(\u110C\u116E)".freeze,
    "\u321D"=>"(\u110B\u1169\u110C\u1165\u11AB)".freeze, "\u321E"=>"(\u110B\u1169\u1112\u116E)".freeze, "\u3220"=>"(\u4E00)".freeze, "\u3221"=>"(\u4E8C)".freeze, "\u3222"=>"(\u4E09)".freeze, "\u3223"=>"(\u56DB)".freeze, "\u3224"=>"(\u4E94)".freeze, "\u3225"=>"(\u516D)".freeze,
    "\u3226"=>"(\u4E03)".freeze, "\u3227"=>"(\u516B)".freeze, "\u3228"=>"(\u4E5D)".freeze, "\u3229"=>"(\u5341)".freeze, "\u322A"=>"(\u6708)".freeze, "\u322B"=>"(\u706B)".freeze, "\u322C"=>"(\u6C34)".freeze, "\u322D"=>"(\u6728)".freeze,
    "\u322E"=>"(\u91D1)".freeze, "\u322F"=>"(\u571F)".freeze, "\u3230"=>"(\u65E5)".freeze, "\u3231"=>"(\u682A)".freeze, "\u3232"=>"(\u6709)".freeze, "\u3233"=>"(\u793E)".freeze, "\u3234"=>"(\u540D)".freeze, "\u3235"=>"(\u7279)".freeze,
    "\u3236"=>"(\u8CA1)".freeze, "\u3237"=>"(\u795D)".freeze, "\u3238"=>"(\u52B4)".freeze, "\u3239"=>"(\u4EE3)".freeze, "\u323A"=>"(\u547C)".freeze, "\u323B"=>"(\u5B66)".freeze, "\u323C"=>"(\u76E3)".freeze, "\u323D"=>"(\u4F01)".freeze,
    "\u323E"=>"(\u8CC7)".freeze, "\u323F"=>"(\u5354)".freeze, "\u3240"=>"(\u796D)".freeze, "\u3241"=>"(\u4F11)".freeze, "\u3242"=>"(\u81EA)".freeze, "\u3243"=>"(\u81F3)".freeze, "\u3244"=>"\u554F".freeze, "\u3245"=>"\u5E7C".freeze,
    "\u3246"=>"\u6587".freeze, "\u3247"=>"\u7B8F".freeze, "\u3250"=>"PTE".freeze, "\u3251"=>"21".freeze, "\u3252"=>"22".freeze, "\u3253"=>"23".freeze, "\u3254"=>"24".freeze, "\u3255"=>"25".freeze,
    "\u3256"=>"26".freeze, "\u3257"=>"27".freeze, "\u3258"=>"28".freeze, "\u3259"=>"29".freeze, "\u325A"=>"30".freeze, "\u325B"=>"31".freeze, "\u325C"=>"32".freeze, "\u325D"=>"33".freeze,
    "\u325E"=>"34".freeze, "\u325F"=>"35".freeze, "\u3260"=>"\u1100".freeze, "\u3261"=>"\u1102".freeze, "\u3262"=>"\u1103".freeze, "\u3263"=>"\u1105".freeze, "\u3264"=>"\u1106".freeze, "\u3265"=>"\u1107".freeze,
    "\u3266"=>"\u1109".freeze, "\u3267"=>"\u110B".freeze, "\u3268"=>"\u110C".freeze, "\u3269"=>"\u110E".freeze, "\u326A"=>"\u110F".freeze, "\u326B"=>"\u1110".freeze, "\u326C"=>"\u1111".freeze, "\u326D"=>"\u1112".freeze,
    "\u326E"=>"\u1100\u1161".freeze, "\u326F"=>"\u1102\u1161".freeze, "\u3270"=>"\u1103\u1161".freeze, "\u3271"=>"\u1105\u1161".freeze, "\u3272"=>"\u1106\u1161".freeze, "\u3273"=>"\u1107\u1161".freeze, "\u3274"=>"\u1109\u1161".freeze, "\u3275"=>"\u110B\u1161".freeze,
    "\u3276"=>"\u110C\u1161".freeze, "\u3277"=>"\u110E\u1161".freeze, "\u3278"=>"\u110F\u1161".freeze, "\u3279"=>"\u1110\u1161".freeze, "\u327A"=>"\u1111\u1161".freeze, "\u327B"=>"\u1112\u1161".freeze, "\u327C"=>"\u110E\u1161\u11B7\u1100\u1169".freeze, "\u327D"=>"\u110C\u116E\u110B\u1174".freeze,
    "\u327E"=>"\u110B\u116E".freeze, "\u3280"=>"\u4E00".freeze, "\u3281"=>"\u4E8C".freeze, "\u3282"=>"\u4E09".freeze, "\u3283"=>"\u56DB".freeze, "\u3284"=>"\u4E94".freeze, "\u3285"=>"\u516D".freeze, "\u3286"=>"\u4E03".freeze,
    "\u3287"=>"\u516B".freeze, "\u3288"=>"\u4E5D".freeze, "\u3289"=>"\u5341".freeze, "\u328A"=>"\u6708".freeze, "\u328B"=>"\u706B".freeze, "\u328C"=>"\u6C34".freeze, "\u328D"=>"\u6728".freeze, "\u328E"=>"\u91D1".freeze,
    "\u328F"=>"\u571F".freeze, "\u3290"=>"\u65E5".freeze, "\u3291"=>"\u682A".freeze, "\u3292"=>"\u6709".freeze, "\u3293"=>"\u793E".freeze, "\u3294"=>"\u540D".freeze, "\u3295"=>"\u7279".freeze, "\u3296"=>"\u8CA1".freeze,
    "\u3297"=>"\u795D".freeze, "\u3298"=>"\u52B4".freeze, "\u3299"=>"\u79D8".freeze, "\u329A"=>"\u7537".freeze, "\u329B"=>"\u5973".freeze, "\u329C"=>"\u9069".freeze, "\u329D"=>"\u512A".freeze, "\u329E"=>"\u5370".freeze,
    "\u329F"=>"\u6CE8".freeze, "\u32A0"=>"\u9805".freeze, "\u32A1"=>"\u4F11".freeze, "\u32A2"=>"\u5199".freeze, "\u32A3"=>"\u6B63".freeze, "\u32A4"=>"\u4E0A".freeze, "\u32A5"=>"\u4E2D".freeze, "\u32A6"=>"\u4E0B".freeze,
    "\u32A7"=>"\u5DE6".freeze, "\u32A8"=>"\u53F3".freeze, "\u32A9"=>"\u533B".freeze, "\u32AA"=>"\u5B97".freeze, "\u32AB"=>"\u5B66".freeze, "\u32AC"=>"\u76E3".freeze, "\u32AD"=>"\u4F01".freeze, "\u32AE"=>"\u8CC7".freeze,
    "\u32AF"=>"\u5354".freeze, "\u32B0"=>"\u591C".freeze, "\u32B1"=>"36".freeze, "\u32B2"=>"37".freeze, "\u32B3"=>"38".freeze, "\u32B4"=>"39".freeze, "\u32B5"=>"40".freeze, "\u32B6"=>"41".freeze,
    "\u32B7"=>"42".freeze, "\u32B8"=>"43".freeze, "\u32B9"=>"44".freeze, "\u32BA"=>"45".freeze, "\u32BB"=>"46".freeze, "\u32BC"=>"47".freeze, "\u32BD"=>"48".freeze, "\u32BE"=>"49".freeze,
    "\u32BF"=>"50".freeze, "\u32C0"=>"1\u6708".freeze, "\u32C1"=>"2\u6708".freeze, "\u32C2"=>"3\u6708".freeze, "\u32C3"=>"4\u6708".freeze, "\u32C4"=>"5\u6708".freeze, "\u32C5"=>"6\u6708".freeze, "\u32C6"=>"7\u6708".freeze,
    "\u32C7"=>"8\u6708".freeze, "\u32C8"=>"9\u6708".freeze, "\u32C9"=>"10\u6708".freeze, "\u32CA"=>"11\u6708".freeze, "\u32CB"=>"12\u6708".freeze, "\u32CC"=>"Hg".freeze, "\u32CD"=>"erg".freeze, "\u32CE"=>"eV".freeze,
    "\u32CF"=>"LTD".freeze, "\u32D0"=>"\u30A2".freeze, "\u32D1"=>"\u30A4".freeze, "\u32D2"=>"\u30A6".freeze, "\u32D3"=>"\u30A8".freeze, "\u32D4"=>"\u30AA".freeze, "\u32D5"=>"\u30AB".freeze, "\u32D6"=>"\u30AD".freeze,
    "\u32D7"=>"\u30AF".freeze, "\u32D8"=>"\u30B1".freeze, "\u32D9"=>"\u30B3".freeze, "\u32DA"=>"\u30B5".freeze, "\u32DB"=>"\u30B7".freeze, "\u32DC"=>"\u30B9".freeze, "\u32DD"=>"\u30BB".freeze, "\u32DE"=>"\u30BD".freeze,
    "\u32DF"=>"\u30BF".freeze, "\u32E0"=>"\u30C1".freeze, "\u32E1"=>"\u30C4".freeze, "\u32E2"=>"\u30C6".freeze, "\u32E3"=>"\u30C8".freeze, "\u32E4"=>"\u30CA".freeze, "\u32E5"=>"\u30CB".freeze, "\u32E6"=>"\u30CC".freeze,
    "\u32E7"=>"\u30CD".freeze, "\u32E8"=>"\u30CE".freeze, "\u32E9"=>"\u30CF".freeze, "\u32EA"=>"\u30D2".freeze, "\u32EB"=>"\u30D5".freeze, "\u32EC"=>"\u30D8".freeze, "\u32ED"=>"\u30DB".freeze, "\u32EE"=>"\u30DE".freeze,
    "\u32EF"=>"\u30DF".freeze, "\u32F0"=>"\u30E0".freeze, "\u32F1"=>"\u30E1".freeze, "\u32F2"=>"\u30E2".freeze, "\u32F3"=>"\u30E4".freeze, "\u32F4"=>"\u30E6".freeze, "\u32F5"=>"\u30E8".freeze, "\u32F6"=>"\u30E9".freeze,
    "\u32F7"=>"\u30EA".freeze, "\u32F8"=>"\u30EB".freeze, "\u32F9"=>"\u30EC".freeze, "\u32FA"=>"\u30ED".freeze, "\u32FB"=>"\u30EF".freeze, "\u32FC"=>"\u30F0".freeze, "\u32FD"=>"\u30F1".freeze, "\u32FE"=>"\u30F2".freeze,
    "\u3300"=>"\u30A2\u30D1\u30FC\u30C8".freeze, "\u3301"=>"\u30A2\u30EB\u30D5\u30A1".freeze, "\u3302"=>"\u30A2\u30F3\u30DA\u30A2".freeze, "\u3303"=>"\u30A2\u30FC\u30EB".freeze, "\u3304"=>"\u30A4\u30CB\u30F3\u30B0".freeze, "\u3305"=>"\u30A4\u30F3\u30C1".freeze, "\u3306"=>"\u30A6\u30A9\u30F3".freeze, "\u3307"=>"\u30A8\u30B9\u30AF\u30FC\u30C9".freeze,
    "\u3308"=>"\u30A8\u30FC\u30AB\u30FC".freeze, "\u3309"=>"\u30AA\u30F3\u30B9".freeze, "\u330A"=>"\u30AA\u30FC\u30E0".freeze, "\u330B"=>"\u30AB\u30A4\u30EA".freeze, "\u330C"=>"\u30AB\u30E9\u30C3\u30C8".freeze, "\u330D"=>"\u30AB\u30ED\u30EA\u30FC".freeze, "\u330E"=>"\u30AC\u30ED\u30F3".freeze, "\u330F"=>"\u30AC\u30F3\u30DE".freeze,
    "\u3310"=>"\u30AE\u30AC".freeze, "\u3311"=>"\u30AE\u30CB\u30FC".freeze, "\u3312"=>"\u30AD\u30E5\u30EA\u30FC".freeze, "\u3313"=>"\u30AE\u30EB\u30C0\u30FC".freeze, "\u3314"=>"\u30AD\u30ED".freeze, "\u3315"=>"\u30AD\u30ED\u30B0\u30E9\u30E0".freeze, "\u3316"=>"\u30AD\u30ED\u30E1\u30FC\u30C8\u30EB".freeze, "\u3317"=>"\u30AD\u30ED\u30EF\u30C3\u30C8".freeze,
    "\u3318"=>"\u30B0\u30E9\u30E0".freeze, "\u3319"=>"\u30B0\u30E9\u30E0\u30C8\u30F3".freeze, "\u331A"=>"\u30AF\u30EB\u30BC\u30A4\u30ED".freeze, "\u331B"=>"\u30AF\u30ED\u30FC\u30CD".freeze, "\u331C"=>"\u30B1\u30FC\u30B9".freeze, "\u331D"=>"\u30B3\u30EB\u30CA".freeze, "\u331E"=>"\u30B3\u30FC\u30DD".freeze, "\u331F"=>"\u30B5\u30A4\u30AF\u30EB".freeze,
    "\u3320"=>"\u30B5\u30F3\u30C1\u30FC\u30E0".freeze, "\u3321"=>"\u30B7\u30EA\u30F3\u30B0".freeze, "\u3322"=>"\u30BB\u30F3\u30C1".freeze, "\u3323"=>"\u30BB\u30F3\u30C8".freeze, "\u3324"=>"\u30C0\u30FC\u30B9".freeze, "\u3325"=>"\u30C7\u30B7".freeze, "\u3326"=>"\u30C9\u30EB".freeze, "\u3327"=>"\u30C8\u30F3".freeze,
    "\u3328"=>"\u30CA\u30CE".freeze, "\u3329"=>"\u30CE\u30C3\u30C8".freeze, "\u332A"=>"\u30CF\u30A4\u30C4".freeze, "\u332B"=>"\u30D1\u30FC\u30BB\u30F3\u30C8".freeze, "\u332C"=>"\u30D1\u30FC\u30C4".freeze, "\u332D"=>"\u30D0\u30FC\u30EC\u30EB".freeze, "\u332E"=>"\u30D4\u30A2\u30B9\u30C8\u30EB".freeze, "\u332F"=>"\u30D4\u30AF\u30EB".freeze,
    "\u3330"=>"\u30D4\u30B3".freeze, "\u3331"=>"\u30D3\u30EB".freeze, "\u3332"=>"\u30D5\u30A1\u30E9\u30C3\u30C9".freeze, "\u3333"=>"\u30D5\u30A3\u30FC\u30C8".freeze, "\u3334"=>"\u30D6\u30C3\u30B7\u30A7\u30EB".freeze, "\u3335"=>"\u30D5\u30E9\u30F3".freeze, "\u3336"=>"\u30D8\u30AF\u30BF\u30FC\u30EB".freeze, "\u3337"=>"\u30DA\u30BD".freeze,
    "\u3338"=>"\u30DA\u30CB\u30D2".freeze, "\u3339"=>"\u30D8\u30EB\u30C4".freeze, "\u333A"=>"\u30DA\u30F3\u30B9".freeze, "\u333B"=>"\u30DA\u30FC\u30B8".freeze, "\u333C"=>"\u30D9\u30FC\u30BF".freeze, "\u333D"=>"\u30DD\u30A4\u30F3\u30C8".freeze, "\u333E"=>"\u30DC\u30EB\u30C8".freeze, "\u333F"=>"\u30DB\u30F3".freeze,
    "\u3340"=>"\u30DD\u30F3\u30C9".freeze, "\u3341"=>"\u30DB\u30FC\u30EB".freeze, "\u3342"=>"\u30DB\u30FC\u30F3".freeze, "\u3343"=>"\u30DE\u30A4\u30AF\u30ED".freeze, "\u3344"=>"\u30DE\u30A4\u30EB".freeze, "\u3345"=>"\u30DE\u30C3\u30CF".freeze, "\u3346"=>"\u30DE\u30EB\u30AF".freeze, "\u3347"=>"\u30DE\u30F3\u30B7\u30E7\u30F3".freeze,
    "\u3348"=>"\u30DF\u30AF\u30ED\u30F3".freeze, "\u3349"=>"\u30DF\u30EA".freeze, "\u334A"=>"\u30DF\u30EA\u30D0\u30FC\u30EB".freeze, "\u334B"=>"\u30E1\u30AC".freeze, "\u334C"=>"\u30E1\u30AC\u30C8\u30F3".freeze, "\u334D"=>"\u30E1\u30FC\u30C8\u30EB".freeze, "\u334E"=>"\u30E4\u30FC\u30C9".freeze, "\u334F"=>"\u30E4\u30FC\u30EB".freeze,
    "\u3350"=>"\u30E6\u30A2\u30F3".freeze, "\u3351"=>"\u30EA\u30C3\u30C8\u30EB".freeze, "\u3352"=>"\u30EA\u30E9".freeze, "\u3353"=>"\u30EB\u30D4\u30FC".freeze, "\u3354"=>"\u30EB\u30FC\u30D6\u30EB".freeze, "\u3355"=>"\u30EC\u30E0".freeze, "\u3356"=>"\u30EC\u30F3\u30C8\u30B2\u30F3".freeze, "\u3357"=>"\u30EF\u30C3\u30C8".freeze,
    "\u3358"=>"0\u70B9".freeze, "\u3359"=>"1\u70B9".freeze, "\u335A"=>"2\u70B9".freeze, "\u335B"=>"3\u70B9".freeze, "\u335C"=>"4\u70B9".freeze, "\u335D"=>"5\u70B9".freeze, "\u335E"=>"6\u70B9".freeze, "\u335F"=>"7\u70B9".freeze,
    "\u3360"=>"8\u70B9".freeze, "\u3361"=>"9\u70B9".freeze, "\u3362"=>"10\u70B9".freeze, "\u3363"=>"11\u70B9".freeze, "\u3364"=>"12\u70B9".freeze, "\u3365"=>"13\u70B9".freeze, "\u3366"=>"14\u70B9".freeze, "\u3367"=>"15\u70B9".freeze,
    "\u3368"=>"16\u70B9".freeze, "\u3369"=>"17\u70B9".freeze, "\u336A"=>"18\u70B9".freeze, "\u336B"=>"19\u70B9".freeze, "\u336C"=>"20\u70B9".freeze, "\u336D"=>"21\u70B9".freeze, "\u336E"=>"22\u70B9".freeze, "\u336F"=>"23\u70B9".freeze,
    "\u3370"=>"24\u70B9".freeze, "\u3371"=>"hPa".freeze, "\u3372"=>"da".freeze, "\u3373"=>"AU".freeze, "\u3374"=>"bar".freeze, "\u3375"=>"oV".freeze, "\u3376"=>"pc".freeze, "\u3377"=>"dm".freeze,
    "\u3378"=>"dm2".freeze, "\u3379"=>"dm3".freeze, "\u337A"=>"IU".freeze, "\u337B"=>"\u5E73\u6210".freeze, "\u337C"=>"\u662D\u548C".freeze, "\u337D"=>"\u5927\u6B63".freeze, "\u337E"=>"\u660E\u6CBB".freeze, "\u337F"=>"\u682A\u5F0F\u4F1A\u793E".freeze,
    "\u3380"=>"pA".freeze, "\u3381"=>"nA".freeze, "\u3382"=>"\u03BCA".freeze, "\u3383"=>"mA".freeze, "\u3384"=>"kA".freeze, "\u3385"=>"KB".freeze, "\u3386"=>"MB".freeze, "\u3387"=>"GB".freeze,
    "\u3388"=>"cal".freeze, "\u3389"=>"kcal".freeze, "\u338A"=>"pF".freeze, "\u338B"=>"nF".freeze, "\u338C"=>"\u03BCF".freeze, "\u338D"=>"\u03BCg".freeze, "\u338E"=>"mg".freeze, "\u338F"=>"kg".freeze,
    "\u3390"=>"Hz".freeze, "\u3391"=>"kHz".freeze, "\u3392"=>"MHz".freeze, "\u3393"=>"GHz".freeze, "\u3394"=>"THz".freeze, "\u3395"=>"\u03BCl".freeze, "\u3396"=>"ml".freeze, "\u3397"=>"dl".freeze,
    "\u3398"=>"kl".freeze, "\u3399"=>"fm".freeze, "\u339A"=>"nm".freeze, "\u339B"=>"\u03BCm".freeze, "\u339C"=>"mm".freeze, "\u339D"=>"cm".freeze, "\u339E"=>"km".freeze, "\u339F"=>"mm2".freeze,
    "\u33A0"=>"cm2".freeze, "\u33A1"=>"m2".freeze, "\u33A2"=>"km2".freeze, "\u33A3"=>"mm3".freeze, "\u33A4"=>"cm3".freeze, "\u33A5"=>"m3".freeze, "\u33A6"=>"km3".freeze, "\u33A7"=>"m\u2215s".freeze,
    "\u33A8"=>"m\u2215s2".freeze, "\u33A9"=>"Pa".freeze, "\u33AA"=>"kPa".freeze, "\u33AB"=>"MPa".freeze, "\u33AC"=>"GPa".freeze, "\u33AD"=>"rad".freeze, "\u33AE"=>"rad\u2215s".freeze, "\u33AF"=>"rad\u2215s2".freeze,
    "\u33B0"=>"ps".freeze, "\u33B1"=>"ns".freeze, "\u33B2"=>"\u03BCs".freeze, "\u33B3"=>"ms".freeze, "\u33B4"=>"pV".freeze, "\u33B5"=>"nV".freeze, "\u33B6"=>"\u03BCV".freeze, "\u33B7"=>"mV".freeze,
    "\u33B8"=>"kV".freeze, "\u33B9"=>"MV".freeze, "\u33BA"=>"pW".freeze, "\u33BB"=>"nW".freeze, "\u33BC"=>"\u03BCW".freeze, "\u33BD"=>"mW".freeze, "\u33BE"=>"kW".freeze, "\u33BF"=>"MW".freeze,
    "\u33C0"=>"k\u03A9".freeze, "\u33C1"=>"M\u03A9".freeze, "\u33C2"=>"a.m.".freeze, "\u33C3"=>"Bq".freeze, "\u33C4"=>"cc".freeze, "\u33C5"=>"cd".freeze, "\u33C6"=>"C\u2215kg".freeze, "\u33C7"=>"Co.".freeze,
    "\u33C8"=>"dB".freeze, "\u33C9"=>"Gy".freeze, "\u33CA"=>"ha".freeze, "\u33CB"=>"HP".freeze, "\u33CC"=>"in".freeze, "\u33CD"=>"KK".freeze, "\u33CE"=>"KM".freeze, "\u33CF"=>"kt".freeze,
    "\u33D0"=>"lm".freeze, "\u33D1"=>"ln".freeze, "\u33D2"=>"log".freeze, "\u33D3"=>"lx".freeze, "\u33D4"=>"mb".freeze, "\u33D5"=>"mil".freeze, "\u33D6"=>"mol".freeze, "\u33D7"=>"PH".freeze,
    "\u33D8"=>"p.m.".freeze, "\u33D9"=>"PPM".freeze, "\u33DA"=>"PR".freeze, "\u33DB"=>"sr".freeze, "\u33DC"=>"Sv".freeze, "\u33DD"=>"Wb".freeze, "\u33DE"=>"V\u2215m".freeze, "\u33DF"=>"A\u2215m".freeze,
    "\u33E0"=>"1\u65E5".freeze, "\u33E1"=>"2\u65E5".freeze, "\u33E2"=>"3\u65E5".freeze, "\u33E3"=>"4\u65E5".freeze, "\u33E4"=>"5\u65E5".freeze, "\u33E5"=>"6\u65E5".freeze, "\u33E6"=>"7\u65E5".freeze, "\u33E7"=>"8\u65E5".freeze,
    "\u33E8"=>"9\u65E5".freeze, "\u33E9"=>"10\u65E5".freeze, "\u33EA"=>"11\u65E5".freeze, "\u33EB"=>"12\u65E5".freeze, "\u33EC"=>"13\u65E5".freeze, "\u33ED"=>"14\u65E5".freeze, "\u33EE"=>"15\u65E5".freeze, "\u33EF"=>"16\u65E5".freeze,
    "\u33F0"=>"17\u65E5".freeze, "\u33F1"=>"18\u65E5".freeze, "\u33F2"=>"19\u65E5".freeze, "\u33F3"=>"20\u65E5".freeze, "\u33F4"=>"21\u65E5".freeze, "\u33F5"=>"22\u65E5".freeze, "\u33F6"=>"23\u65E5".freeze, "\u33F7"=>"24\u65E5".freeze,
    "\u33F8"=>"25\u65E5".freeze, "\u33F9"=>"26\u65E5".freeze, "\u33FA"=>"27\u65E5".freeze, "\u33FB"=>"28\u65E5".freeze, "\u33FC"=>"29\u65E5".freeze, "\u33FD"=>"30\u65E5".freeze, "\u33FE"=>"31\u65E5".freeze, "\u33FF"=>"gal".freeze,
    "\uA69C"=>"\u044A".freeze, "\uA69D"=>"\u044C".freeze, "\uA770"=>"\uA76F".freeze, "\uA7F8"=>"\u0126".freeze, "\uA7F9"=>"\u0153".freeze, "\uAB5C"=>"\uA727".freeze, "\uAB5D"=>"\uAB37".freeze, "\uAB5E"=>"\u026B".freeze,
    "\uAB5F"=>"\uAB52".freeze, "\uFB00"=>"ff".freeze, "\uFB01"=>"fi".freeze, "\uFB02"=>"fl".freeze, "\uFB03"=>"ffi".freeze, "\uFB04"=>"ffl".freeze, "\uFB05"=>"st".freeze, "\uFB06"=>"st".freeze,
    "\uFB13"=>"\u0574\u0576".freeze, "\uFB14"=>"\u0574\u0565".freeze, "\uFB15"=>"\u0574\u056B".freeze, "\uFB16"=>"\u057E\u0576".freeze, "\uFB17"=>"\u0574\u056D".freeze, "\uFB20"=>"\u05E2".freeze, "\uFB21"=>"\u05D0".freeze, "\uFB22"=>"\u05D3".freeze,
    "\uFB23"=>"\u05D4".freeze, "\uFB24"=>"\u05DB".freeze, "\uFB25"=>"\u05DC".freeze, "\uFB26"=>"\u05DD".freeze, "\uFB27"=>"\u05E8".freeze, "\uFB28"=>"\u05EA".freeze, "\uFB29"=>"+".freeze, "\uFB4F"=>"\u05D0\u05DC".freeze,
    "\uFB50"=>"\u0671".freeze, "\uFB51"=>"\u0671".freeze, "\uFB52"=>"\u067B".freeze, "\uFB53"=>"\u067B".freeze, "\uFB54"=>"\u067B".freeze, "\uFB55"=>"\u067B".freeze, "\uFB56"=>"\u067E".freeze, "\uFB57"=>"\u067E".freeze,
    "\uFB58"=>"\u067E".freeze, "\uFB59"=>"\u067E".freeze, "\uFB5A"=>"\u0680".freeze, "\uFB5B"=>"\u0680".freeze, "\uFB5C"=>"\u0680".freeze, "\uFB5D"=>"\u0680".freeze, "\uFB5E"=>"\u067A".freeze, "\uFB5F"=>"\u067A".freeze,
    "\uFB60"=>"\u067A".freeze, "\uFB61"=>"\u067A".freeze, "\uFB62"=>"\u067F".freeze, "\uFB63"=>"\u067F".freeze, "\uFB64"=>"\u067F".freeze, "\uFB65"=>"\u067F".freeze, "\uFB66"=>"\u0679".freeze, "\uFB67"=>"\u0679".freeze,
    "\uFB68"=>"\u0679".freeze, "\uFB69"=>"\u0679".freeze, "\uFB6A"=>"\u06A4".freeze, "\uFB6B"=>"\u06A4".freeze, "\uFB6C"=>"\u06A4".freeze, "\uFB6D"=>"\u06A4".freeze, "\uFB6E"=>"\u06A6".freeze, "\uFB6F"=>"\u06A6".freeze,
    "\uFB70"=>"\u06A6".freeze, "\uFB71"=>"\u06A6".freeze, "\uFB72"=>"\u0684".freeze, "\uFB73"=>"\u0684".freeze, "\uFB74"=>"\u0684".freeze, "\uFB75"=>"\u0684".freeze, "\uFB76"=>"\u0683".freeze, "\uFB77"=>"\u0683".freeze,
    "\uFB78"=>"\u0683".freeze, "\uFB79"=>"\u0683".freeze, "\uFB7A"=>"\u0686".freeze, "\uFB7B"=>"\u0686".freeze, "\uFB7C"=>"\u0686".freeze, "\uFB7D"=>"\u0686".freeze, "\uFB7E"=>"\u0687".freeze, "\uFB7F"=>"\u0687".freeze,
    "\uFB80"=>"\u0687".freeze, "\uFB81"=>"\u0687".freeze, "\uFB82"=>"\u068D".freeze, "\uFB83"=>"\u068D".freeze, "\uFB84"=>"\u068C".freeze, "\uFB85"=>"\u068C".freeze, "\uFB86"=>"\u068E".freeze, "\uFB87"=>"\u068E".freeze,
    "\uFB88"=>"\u0688".freeze, "\uFB89"=>"\u0688".freeze, "\uFB8A"=>"\u0698".freeze, "\uFB8B"=>"\u0698".freeze, "\uFB8C"=>"\u0691".freeze, "\uFB8D"=>"\u0691".freeze, "\uFB8E"=>"\u06A9".freeze, "\uFB8F"=>"\u06A9".freeze,
    "\uFB90"=>"\u06A9".freeze, "\uFB91"=>"\u06A9".freeze, "\uFB92"=>"\u06AF".freeze, "\uFB93"=>"\u06AF".freeze, "\uFB94"=>"\u06AF".freeze, "\uFB95"=>"\u06AF".freeze, "\uFB96"=>"\u06B3".freeze, "\uFB97"=>"\u06B3".freeze,
    "\uFB98"=>"\u06B3".freeze, "\uFB99"=>"\u06B3".freeze, "\uFB9A"=>"\u06B1".freeze, "\uFB9B"=>"\u06B1".freeze, "\uFB9C"=>"\u06B1".freeze, "\uFB9D"=>"\u06B1".freeze, "\uFB9E"=>"\u06BA".freeze, "\uFB9F"=>"\u06BA".freeze,
    "\uFBA0"=>"\u06BB".freeze, "\uFBA1"=>"\u06BB".freeze, "\uFBA2"=>"\u06BB".freeze, "\uFBA3"=>"\u06BB".freeze, "\uFBA4"=>"\u06C0".freeze, "\uFBA5"=>"\u06C0".freeze, "\uFBA6"=>"\u06C1".freeze, "\uFBA7"=>"\u06C1".freeze,
    "\uFBA8"=>"\u06C1".freeze, "\uFBA9"=>"\u06C1".freeze, "\uFBAA"=>"\u06BE".freeze, "\uFBAB"=>"\u06BE".freeze, "\uFBAC"=>"\u06BE".freeze, "\uFBAD"=>"\u06BE".freeze, "\uFBAE"=>"\u06D2".freeze, "\uFBAF"=>"\u06D2".freeze,
    "\uFBB0"=>"\u06D3".freeze, "\uFBB1"=>"\u06D3".freeze, "\uFBD3"=>"\u06AD".freeze, "\uFBD4"=>"\u06AD".freeze, "\uFBD5"=>"\u06AD".freeze, "\uFBD6"=>"\u06AD".freeze, "\uFBD7"=>"\u06C7".freeze, "\uFBD8"=>"\u06C7".freeze,
    "\uFBD9"=>"\u06C6".freeze, "\uFBDA"=>"\u06C6".freeze, "\uFBDB"=>"\u06C8".freeze, "\uFBDC"=>"\u06C8".freeze, "\uFBDD"=>"\u06C7\u0674".freeze, "\uFBDE"=>"\u06CB".freeze, "\uFBDF"=>"\u06CB".freeze, "\uFBE0"=>"\u06C5".freeze,
    "\uFBE1"=>"\u06C5".freeze, "\uFBE2"=>"\u06C9".freeze, "\uFBE3"=>"\u06C9".freeze, "\uFBE4"=>"\u06D0".freeze, "\uFBE5"=>"\u06D0".freeze, "\uFBE6"=>"\u06D0".freeze, "\uFBE7"=>"\u06D0".freeze, "\uFBE8"=>"\u0649".freeze,
    "\uFBE9"=>"\u0649".freeze, "\uFBEA"=>"\u0626\u0627".freeze, "\uFBEB"=>"\u0626\u0627".freeze, "\uFBEC"=>"\u0626\u06D5".freeze, "\uFBED"=>"\u0626\u06D5".freeze, "\uFBEE"=>"\u0626\u0648".freeze, "\uFBEF"=>"\u0626\u0648".freeze, "\uFBF0"=>"\u0626\u06C7".freeze,
    "\uFBF1"=>"\u0626\u06C7".freeze, "\uFBF2"=>"\u0626\u06C6".freeze, "\uFBF3"=>"\u0626\u06C6".freeze, "\uFBF4"=>"\u0626\u06C8".freeze, "\uFBF5"=>"\u0626\u06C8".freeze, "\uFBF6"=>"\u0626\u06D0".freeze, "\uFBF7"=>"\u0626\u06D0".freeze, "\uFBF8"=>"\u0626\u06D0".freeze,
    "\uFBF9"=>"\u0626\u0649".freeze, "\uFBFA"=>"\u0626\u0649".freeze, "\uFBFB"=>"\u0626\u0649".freeze, "\uFBFC"=>"\u06CC".freeze, "\uFBFD"=>"\u06CC".freeze, "\uFBFE"=>"\u06CC".freeze, "\uFBFF"=>"\u06CC".freeze, "\uFC00"=>"\u0626\u062C".freeze,
    "\uFC01"=>"\u0626\u062D".freeze, "\uFC02"=>"\u0626\u0645".freeze, "\uFC03"=>"\u0626\u0649".freeze, "\uFC04"=>"\u0626\u064A".freeze, "\uFC05"=>"\u0628\u062C".freeze, "\uFC06"=>"\u0628\u062D".freeze, "\uFC07"=>"\u0628\u062E".freeze, "\uFC08"=>"\u0628\u0645".freeze,
    "\uFC09"=>"\u0628\u0649".freeze, "\uFC0A"=>"\u0628\u064A".freeze, "\uFC0B"=>"\u062A\u062C".freeze, "\uFC0C"=>"\u062A\u062D".freeze, "\uFC0D"=>"\u062A\u062E".freeze, "\uFC0E"=>"\u062A\u0645".freeze, "\uFC0F"=>"\u062A\u0649".freeze, "\uFC10"=>"\u062A\u064A".freeze,
    "\uFC11"=>"\u062B\u062C".freeze, "\uFC12"=>"\u062B\u0645".freeze, "\uFC13"=>"\u062B\u0649".freeze, "\uFC14"=>"\u062B\u064A".freeze, "\uFC15"=>"\u062C\u062D".freeze, "\uFC16"=>"\u062C\u0645".freeze, "\uFC17"=>"\u062D\u062C".freeze, "\uFC18"=>"\u062D\u0645".freeze,
    "\uFC19"=>"\u062E\u062C".freeze, "\uFC1A"=>"\u062E\u062D".freeze, "\uFC1B"=>"\u062E\u0645".freeze, "\uFC1C"=>"\u0633\u062C".freeze, "\uFC1D"=>"\u0633\u062D".freeze, "\uFC1E"=>"\u0633\u062E".freeze, "\uFC1F"=>"\u0633\u0645".freeze, "\uFC20"=>"\u0635\u062D".freeze,
    "\uFC21"=>"\u0635\u0645".freeze, "\uFC22"=>"\u0636\u062C".freeze, "\uFC23"=>"\u0636\u062D".freeze, "\uFC24"=>"\u0636\u062E".freeze, "\uFC25"=>"\u0636\u0645".freeze, "\uFC26"=>"\u0637\u062D".freeze, "\uFC27"=>"\u0637\u0645".freeze, "\uFC28"=>"\u0638\u0645".freeze,
    "\uFC29"=>"\u0639\u062C".freeze, "\uFC2A"=>"\u0639\u0645".freeze, "\uFC2B"=>"\u063A\u062C".freeze, "\uFC2C"=>"\u063A\u0645".freeze, "\uFC2D"=>"\u0641\u062C".freeze, "\uFC2E"=>"\u0641\u062D".freeze, "\uFC2F"=>"\u0641\u062E".freeze, "\uFC30"=>"\u0641\u0645".freeze,
    "\uFC31"=>"\u0641\u0649".freeze, "\uFC32"=>"\u0641\u064A".freeze, "\uFC33"=>"\u0642\u062D".freeze, "\uFC34"=>"\u0642\u0645".freeze, "\uFC35"=>"\u0642\u0649".freeze, "\uFC36"=>"\u0642\u064A".freeze, "\uFC37"=>"\u0643\u0627".freeze, "\uFC38"=>"\u0643\u062C".freeze,
    "\uFC39"=>"\u0643\u062D".freeze, "\uFC3A"=>"\u0643\u062E".freeze, "\uFC3B"=>"\u0643\u0644".freeze, "\uFC3C"=>"\u0643\u0645".freeze, "\uFC3D"=>"\u0643\u0649".freeze, "\uFC3E"=>"\u0643\u064A".freeze, "\uFC3F"=>"\u0644\u062C".freeze, "\uFC40"=>"\u0644\u062D".freeze,
    "\uFC41"=>"\u0644\u062E".freeze, "\uFC42"=>"\u0644\u0645".freeze, "\uFC43"=>"\u0644\u0649".freeze, "\uFC44"=>"\u0644\u064A".freeze, "\uFC45"=>"\u0645\u062C".freeze, "\uFC46"=>"\u0645\u062D".freeze, "\uFC47"=>"\u0645\u062E".freeze, "\uFC48"=>"\u0645\u0645".freeze,
    "\uFC49"=>"\u0645\u0649".freeze, "\uFC4A"=>"\u0645\u064A".freeze, "\uFC4B"=>"\u0646\u062C".freeze, "\uFC4C"=>"\u0646\u062D".freeze, "\uFC4D"=>"\u0646\u062E".freeze, "\uFC4E"=>"\u0646\u0645".freeze, "\uFC4F"=>"\u0646\u0649".freeze, "\uFC50"=>"\u0646\u064A".freeze,
    "\uFC51"=>"\u0647\u062C".freeze, "\uFC52"=>"\u0647\u0645".freeze, "\uFC53"=>"\u0647\u0649".freeze, "\uFC54"=>"\u0647\u064A".freeze, "\uFC55"=>"\u064A\u062C".freeze, "\uFC56"=>"\u064A\u062D".freeze, "\uFC57"=>"\u064A\u062E".freeze, "\uFC58"=>"\u064A\u0645".freeze,
    "\uFC59"=>"\u064A\u0649".freeze, "\uFC5A"=>"\u064A\u064A".freeze, "\uFC5B"=>"\u0630\u0670".freeze, "\uFC5C"=>"\u0631\u0670".freeze, "\uFC5D"=>"\u0649\u0670".freeze, "\uFC5E"=>" \u064C\u0651".freeze, "\uFC5F"=>" \u064D\u0651".freeze, "\uFC60"=>" \u064E\u0651".freeze,
    "\uFC61"=>" \u064F\u0651".freeze, "\uFC62"=>" \u0650\u0651".freeze, "\uFC63"=>" \u0651\u0670".freeze, "\uFC64"=>"\u0626\u0631".freeze, "\uFC65"=>"\u0626\u0632".freeze, "\uFC66"=>"\u0626\u0645".freeze, "\uFC67"=>"\u0626\u0646".freeze, "\uFC68"=>"\u0626\u0649".freeze,
    "\uFC69"=>"\u0626\u064A".freeze, "\uFC6A"=>"\u0628\u0631".freeze, "\uFC6B"=>"\u0628\u0632".freeze, "\uFC6C"=>"\u0628\u0645".freeze, "\uFC6D"=>"\u0628\u0646".freeze, "\uFC6E"=>"\u0628\u0649".freeze, "\uFC6F"=>"\u0628\u064A".freeze, "\uFC70"=>"\u062A\u0631".freeze,
    "\uFC71"=>"\u062A\u0632".freeze, "\uFC72"=>"\u062A\u0645".freeze, "\uFC73"=>"\u062A\u0646".freeze, "\uFC74"=>"\u062A\u0649".freeze, "\uFC75"=>"\u062A\u064A".freeze, "\uFC76"=>"\u062B\u0631".freeze, "\uFC77"=>"\u062B\u0632".freeze, "\uFC78"=>"\u062B\u0645".freeze,
    "\uFC79"=>"\u062B\u0646".freeze, "\uFC7A"=>"\u062B\u0649".freeze, "\uFC7B"=>"\u062B\u064A".freeze, "\uFC7C"=>"\u0641\u0649".freeze, "\uFC7D"=>"\u0641\u064A".freeze, "\uFC7E"=>"\u0642\u0649".freeze, "\uFC7F"=>"\u0642\u064A".freeze, "\uFC80"=>"\u0643\u0627".freeze,
    "\uFC81"=>"\u0643\u0644".freeze, "\uFC82"=>"\u0643\u0645".freeze, "\uFC83"=>"\u0643\u0649".freeze, "\uFC84"=>"\u0643\u064A".freeze, "\uFC85"=>"\u0644\u0645".freeze, "\uFC86"=>"\u0644\u0649".freeze, "\uFC87"=>"\u0644\u064A".freeze, "\uFC88"=>"\u0645\u0627".freeze,
    "\uFC89"=>"\u0645\u0645".freeze, "\uFC8A"=>"\u0646\u0631".freeze, "\uFC8B"=>"\u0646\u0632".freeze, "\uFC8C"=>"\u0646\u0645".freeze, "\uFC8D"=>"\u0646\u0646".freeze, "\uFC8E"=>"\u0646\u0649".freeze, "\uFC8F"=>"\u0646\u064A".freeze, "\uFC90"=>"\u0649\u0670".freeze,
    "\uFC91"=>"\u064A\u0631".freeze, "\uFC92"=>"\u064A\u0632".freeze, "\uFC93"=>"\u064A\u0645".freeze, "\uFC94"=>"\u064A\u0646".freeze, "\uFC95"=>"\u064A\u0649".freeze, "\uFC96"=>"\u064A\u064A".freeze, "\uFC97"=>"\u0626\u062C".freeze, "\uFC98"=>"\u0626\u062D".freeze,
    "\uFC99"=>"\u0626\u062E".freeze, "\uFC9A"=>"\u0626\u0645".freeze, "\uFC9B"=>"\u0626\u0647".freeze, "\uFC9C"=>"\u0628\u062C".freeze, "\uFC9D"=>"\u0628\u062D".freeze, "\uFC9E"=>"\u0628\u062E".freeze, "\uFC9F"=>"\u0628\u0645".freeze, "\uFCA0"=>"\u0628\u0647".freeze,
    "\uFCA1"=>"\u062A\u062C".freeze, "\uFCA2"=>"\u062A\u062D".freeze, "\uFCA3"=>"\u062A\u062E".freeze, "\uFCA4"=>"\u062A\u0645".freeze, "\uFCA5"=>"\u062A\u0647".freeze, "\uFCA6"=>"\u062B\u0645".freeze, "\uFCA7"=>"\u062C\u062D".freeze, "\uFCA8"=>"\u062C\u0645".freeze,
    "\uFCA9"=>"\u062D\u062C".freeze, "\uFCAA"=>"\u062D\u0645".freeze, "\uFCAB"=>"\u062E\u062C".freeze, "\uFCAC"=>"\u062E\u0645".freeze, "\uFCAD"=>"\u0633\u062C".freeze, "\uFCAE"=>"\u0633\u062D".freeze, "\uFCAF"=>"\u0633\u062E".freeze, "\uFCB0"=>"\u0633\u0645".freeze,
    "\uFCB1"=>"\u0635\u062D".freeze, "\uFCB2"=>"\u0635\u062E".freeze, "\uFCB3"=>"\u0635\u0645".freeze, "\uFCB4"=>"\u0636\u062C".freeze, "\uFCB5"=>"\u0636\u062D".freeze, "\uFCB6"=>"\u0636\u062E".freeze, "\uFCB7"=>"\u0636\u0645".freeze, "\uFCB8"=>"\u0637\u062D".freeze,
    "\uFCB9"=>"\u0638\u0645".freeze, "\uFCBA"=>"\u0639\u062C".freeze, "\uFCBB"=>"\u0639\u0645".freeze, "\uFCBC"=>"\u063A\u062C".freeze, "\uFCBD"=>"\u063A\u0645".freeze, "\uFCBE"=>"\u0641\u062C".freeze, "\uFCBF"=>"\u0641\u062D".freeze, "\uFCC0"=>"\u0641\u062E".freeze,
    "\uFCC1"=>"\u0641\u0645".freeze, "\uFCC2"=>"\u0642\u062D".freeze, "\uFCC3"=>"\u0642\u0645".freeze, "\uFCC4"=>"\u0643\u062C".freeze, "\uFCC5"=>"\u0643\u062D".freeze, "\uFCC6"=>"\u0643\u062E".freeze, "\uFCC7"=>"\u0643\u0644".freeze, "\uFCC8"=>"\u0643\u0645".freeze,
    "\uFCC9"=>"\u0644\u062C".freeze, "\uFCCA"=>"\u0644\u062D".freeze, "\uFCCB"=>"\u0644\u062E".freeze, "\uFCCC"=>"\u0644\u0645".freeze, "\uFCCD"=>"\u0644\u0647".freeze, "\uFCCE"=>"\u0645\u062C".freeze, "\uFCCF"=>"\u0645\u062D".freeze, "\uFCD0"=>"\u0645\u062E".freeze,
    "\uFCD1"=>"\u0645\u0645".freeze, "\uFCD2"=>"\u0646\u062C".freeze, "\uFCD3"=>"\u0646\u062D".freeze, "\uFCD4"=>"\u0646\u062E".freeze, "\uFCD5"=>"\u0646\u0645".freeze, "\uFCD6"=>"\u0646\u0647".freeze, "\uFCD7"=>"\u0647\u062C".freeze, "\uFCD8"=>"\u0647\u0645".freeze,
    "\uFCD9"=>"\u0647\u0670".freeze, "\uFCDA"=>"\u064A\u062C".freeze, "\uFCDB"=>"\u064A\u062D".freeze, "\uFCDC"=>"\u064A\u062E".freeze, "\uFCDD"=>"\u064A\u0645".freeze, "\uFCDE"=>"\u064A\u0647".freeze, "\uFCDF"=>"\u0626\u0645".freeze, "\uFCE0"=>"\u0626\u0647".freeze,
    "\uFCE1"=>"\u0628\u0645".freeze, "\uFCE2"=>"\u0628\u0647".freeze, "\uFCE3"=>"\u062A\u0645".freeze, "\uFCE4"=>"\u062A\u0647".freeze, "\uFCE5"=>"\u062B\u0645".freeze, "\uFCE6"=>"\u062B\u0647".freeze, "\uFCE7"=>"\u0633\u0645".freeze, "\uFCE8"=>"\u0633\u0647".freeze,
    "\uFCE9"=>"\u0634\u0645".freeze, "\uFCEA"=>"\u0634\u0647".freeze, "\uFCEB"=>"\u0643\u0644".freeze, "\uFCEC"=>"\u0643\u0645".freeze, "\uFCED"=>"\u0644\u0645".freeze, "\uFCEE"=>"\u0646\u0645".freeze, "\uFCEF"=>"\u0646\u0647".freeze, "\uFCF0"=>"\u064A\u0645".freeze,
    "\uFCF1"=>"\u064A\u0647".freeze, "\uFCF2"=>"\u0640\u064E\u0651".freeze, "\uFCF3"=>"\u0640\u064F\u0651".freeze, "\uFCF4"=>"\u0640\u0650\u0651".freeze, "\uFCF5"=>"\u0637\u0649".freeze, "\uFCF6"=>"\u0637\u064A".freeze, "\uFCF7"=>"\u0639\u0649".freeze, "\uFCF8"=>"\u0639\u064A".freeze,
    "\uFCF9"=>"\u063A\u0649".freeze, "\uFCFA"=>"\u063A\u064A".freeze, "\uFCFB"=>"\u0633\u0649".freeze, "\uFCFC"=>"\u0633\u064A".freeze, "\uFCFD"=>"\u0634\u0649".freeze, "\uFCFE"=>"\u0634\u064A".freeze, "\uFCFF"=>"\u062D\u0649".freeze, "\uFD00"=>"\u062D\u064A".freeze,
    "\uFD01"=>"\u062C\u0649".freeze, "\uFD02"=>"\u062C\u064A".freeze, "\uFD03"=>"\u062E\u0649".freeze, "\uFD04"=>"\u062E\u064A".freeze, "\uFD05"=>"\u0635\u0649".freeze, "\uFD06"=>"\u0635\u064A".freeze, "\uFD07"=>"\u0636\u0649".freeze, "\uFD08"=>"\u0636\u064A".freeze,
    "\uFD09"=>"\u0634\u062C".freeze, "\uFD0A"=>"\u0634\u062D".freeze, "\uFD0B"=>"\u0634\u062E".freeze, "\uFD0C"=>"\u0634\u0645".freeze, "\uFD0D"=>"\u0634\u0631".freeze, "\uFD0E"=>"\u0633\u0631".freeze, "\uFD0F"=>"\u0635\u0631".freeze, "\uFD10"=>"\u0636\u0631".freeze,
    "\uFD11"=>"\u0637\u0649".freeze, "\uFD12"=>"\u0637\u064A".freeze, "\uFD13"=>"\u0639\u0649".freeze, "\uFD14"=>"\u0639\u064A".freeze, "\uFD15"=>"\u063A\u0649".freeze, "\uFD16"=>"\u063A\u064A".freeze, "\uFD17"=>"\u0633\u0649".freeze, "\uFD18"=>"\u0633\u064A".freeze,
    "\uFD19"=>"\u0634\u0649".freeze, "\uFD1A"=>"\u0634\u064A".freeze, "\uFD1B"=>"\u062D\u0649".freeze, "\uFD1C"=>"\u062D\u064A".freeze, "\uFD1D"=>"\u062C\u0649".freeze, "\uFD1E"=>"\u062C\u064A".freeze, "\uFD1F"=>"\u062E\u0649".freeze, "\uFD20"=>"\u062E\u064A".freeze,
    "\uFD21"=>"\u0635\u0649".freeze, "\uFD22"=>"\u0635\u064A".freeze, "\uFD23"=>"\u0636\u0649".freeze, "\uFD24"=>"\u0636\u064A".freeze, "\uFD25"=>"\u0634\u062C".freeze, "\uFD26"=>"\u0634\u062D".freeze, "\uFD27"=>"\u0634\u062E".freeze, "\uFD28"=>"\u0634\u0645".freeze,
    "\uFD29"=>"\u0634\u0631".freeze, "\uFD2A"=>"\u0633\u0631".freeze, "\uFD2B"=>"\u0635\u0631".freeze, "\uFD2C"=>"\u0636\u0631".freeze, "\uFD2D"=>"\u0634\u062C".freeze, "\uFD2E"=>"\u0634\u062D".freeze, "\uFD2F"=>"\u0634\u062E".freeze, "\uFD30"=>"\u0634\u0645".freeze,
    "\uFD31"=>"\u0633\u0647".freeze, "\uFD32"=>"\u0634\u0647".freeze, "\uFD33"=>"\u0637\u0645".freeze, "\uFD34"=>"\u0633\u062C".freeze, "\uFD35"=>"\u0633\u062D".freeze, "\uFD36"=>"\u0633\u062E".freeze, "\uFD37"=>"\u0634\u062C".freeze, "\uFD38"=>"\u0634\u062D".freeze,
    "\uFD39"=>"\u0634\u062E".freeze, "\uFD3A"=>"\u0637\u0645".freeze, "\uFD3B"=>"\u0638\u0645".freeze, "\uFD3C"=>"\u0627\u064B".freeze, "\uFD3D"=>"\u0627\u064B".freeze, "\uFD50"=>"\u062A\u062C\u0645".freeze, "\uFD51"=>"\u062A\u062D\u062C".freeze, "\uFD52"=>"\u062A\u062D\u062C".freeze,
    "\uFD53"=>"\u062A\u062D\u0645".freeze, "\uFD54"=>"\u062A\u062E\u0645".freeze, "\uFD55"=>"\u062A\u0645\u062C".freeze, "\uFD56"=>"\u062A\u0645\u062D".freeze, "\uFD57"=>"\u062A\u0645\u062E".freeze, "\uFD58"=>"\u062C\u0645\u062D".freeze, "\uFD59"=>"\u062C\u0645\u062D".freeze, "\uFD5A"=>"\u062D\u0645\u064A".freeze,
    "\uFD5B"=>"\u062D\u0645\u0649".freeze, "\uFD5C"=>"\u0633\u062D\u062C".freeze, "\uFD5D"=>"\u0633\u062C\u062D".freeze, "\uFD5E"=>"\u0633\u062C\u0649".freeze, "\uFD5F"=>"\u0633\u0645\u062D".freeze, "\uFD60"=>"\u0633\u0645\u062D".freeze, "\uFD61"=>"\u0633\u0645\u062C".freeze, "\uFD62"=>"\u0633\u0645\u0645".freeze,
    "\uFD63"=>"\u0633\u0645\u0645".freeze, "\uFD64"=>"\u0635\u062D\u062D".freeze, "\uFD65"=>"\u0635\u062D\u062D".freeze, "\uFD66"=>"\u0635\u0645\u0645".freeze, "\uFD67"=>"\u0634\u062D\u0645".freeze, "\uFD68"=>"\u0634\u062D\u0645".freeze, "\uFD69"=>"\u0634\u062C\u064A".freeze, "\uFD6A"=>"\u0634\u0645\u062E".freeze,
    "\uFD6B"=>"\u0634\u0645\u062E".freeze, "\uFD6C"=>"\u0634\u0645\u0645".freeze, "\uFD6D"=>"\u0634\u0645\u0645".freeze, "\uFD6E"=>"\u0636\u062D\u0649".freeze, "\uFD6F"=>"\u0636\u062E\u0645".freeze, "\uFD70"=>"\u0636\u062E\u0645".freeze, "\uFD71"=>"\u0637\u0645\u062D".freeze, "\uFD72"=>"\u0637\u0645\u062D".freeze,
    "\uFD73"=>"\u0637\u0645\u0645".freeze, "\uFD74"=>"\u0637\u0645\u064A".freeze, "\uFD75"=>"\u0639\u062C\u0645".freeze, "\uFD76"=>"\u0639\u0645\u0645".freeze, "\uFD77"=>"\u0639\u0645\u0645".freeze, "\uFD78"=>"\u0639\u0645\u0649".freeze, "\uFD79"=>"\u063A\u0645\u0645".freeze, "\uFD7A"=>"\u063A\u0645\u064A".freeze,
    "\uFD7B"=>"\u063A\u0645\u0649".freeze, "\uFD7C"=>"\u0641\u062E\u0645".freeze, "\uFD7D"=>"\u0641\u062E\u0645".freeze, "\uFD7E"=>"\u0642\u0645\u062D".freeze, "\uFD7F"=>"\u0642\u0645\u0645".freeze, "\uFD80"=>"\u0644\u062D\u0645".freeze, "\uFD81"=>"\u0644\u062D\u064A".freeze, "\uFD82"=>"\u0644\u062D\u0649".freeze,
    "\uFD83"=>"\u0644\u062C\u062C".freeze, "\uFD84"=>"\u0644\u062C\u062C".freeze, "\uFD85"=>"\u0644\u062E\u0645".freeze, "\uFD86"=>"\u0644\u062E\u0645".freeze, "\uFD87"=>"\u0644\u0645\u062D".freeze, "\uFD88"=>"\u0644\u0645\u062D".freeze, "\uFD89"=>"\u0645\u062D\u062C".freeze, "\uFD8A"=>"\u0645\u062D\u0645".freeze,
    "\uFD8B"=>"\u0645\u062D\u064A".freeze, "\uFD8C"=>"\u0645\u062C\u062D".freeze, "\uFD8D"=>"\u0645\u062C\u0645".freeze, "\uFD8E"=>"\u0645\u062E\u062C".freeze, "\uFD8F"=>"\u0645\u062E\u0645".freeze, "\uFD92"=>"\u0645\u062C\u062E".freeze, "\uFD93"=>"\u0647\u0645\u062C".freeze, "\uFD94"=>"\u0647\u0645\u0645".freeze,
    "\uFD95"=>"\u0646\u062D\u0645".freeze, "\uFD96"=>"\u0646\u062D\u0649".freeze, "\uFD97"=>"\u0646\u062C\u0645".freeze, "\uFD98"=>"\u0646\u062C\u0645".freeze, "\uFD99"=>"\u0646\u062C\u0649".freeze, "\uFD9A"=>"\u0646\u0645\u064A".freeze, "\uFD9B"=>"\u0646\u0645\u0649".freeze, "\uFD9C"=>"\u064A\u0645\u0645".freeze,
    "\uFD9D"=>"\u064A\u0645\u0645".freeze, "\uFD9E"=>"\u0628\u062E\u064A".freeze, "\uFD9F"=>"\u062A\u062C\u064A".freeze, "\uFDA0"=>"\u062A\u062C\u0649".freeze, "\uFDA1"=>"\u062A\u062E\u064A".freeze, "\uFDA2"=>"\u062A\u062E\u0649".freeze, "\uFDA3"=>"\u062A\u0645\u064A".freeze, "\uFDA4"=>"\u062A\u0645\u0649".freeze,
    "\uFDA5"=>"\u062C\u0645\u064A".freeze, "\uFDA6"=>"\u062C\u062D\u0649".freeze, "\uFDA7"=>"\u062C\u0645\u0649".freeze, "\uFDA8"=>"\u0633\u062E\u0649".freeze, "\uFDA9"=>"\u0635\u062D\u064A".freeze, "\uFDAA"=>"\u0634\u062D\u064A".freeze, "\uFDAB"=>"\u0636\u062D\u064A".freeze, "\uFDAC"=>"\u0644\u062C\u064A".freeze,
    "\uFDAD"=>"\u0644\u0645\u064A".freeze, "\uFDAE"=>"\u064A\u062D\u064A".freeze, "\uFDAF"=>"\u064A\u062C\u064A".freeze, "\uFDB0"=>"\u064A\u0645\u064A".freeze, "\uFDB1"=>"\u0645\u0645\u064A".freeze, "\uFDB2"=>"\u0642\u0645\u064A".freeze, "\uFDB3"=>"\u0646\u062D\u064A".freeze, "\uFDB4"=>"\u0642\u0645\u062D".freeze,
    "\uFDB5"=>"\u0644\u062D\u0645".freeze, "\uFDB6"=>"\u0639\u0645\u064A".freeze, "\uFDB7"=>"\u0643\u0645\u064A".freeze, "\uFDB8"=>"\u0646\u062C\u062D".freeze, "\uFDB9"=>"\u0645\u062E\u064A".freeze, "\uFDBA"=>"\u0644\u062C\u0645".freeze, "\uFDBB"=>"\u0643\u0645\u0645".freeze, "\uFDBC"=>"\u0644\u062C\u0645".freeze,
    "\uFDBD"=>"\u0646\u062C\u062D".freeze, "\uFDBE"=>"\u062C\u062D\u064A".freeze, "\uFDBF"=>"\u062D\u062C\u064A".freeze, "\uFDC0"=>"\u0645\u062C\u064A".freeze, "\uFDC1"=>"\u0641\u0645\u064A".freeze, "\uFDC2"=>"\u0628\u062D\u064A".freeze, "\uFDC3"=>"\u0643\u0645\u0645".freeze, "\uFDC4"=>"\u0639\u062C\u0645".freeze,
    "\uFDC5"=>"\u0635\u0645\u0645".freeze, "\uFDC6"=>"\u0633\u062E\u064A".freeze, "\uFDC7"=>"\u0646\u062C\u064A".freeze, "\uFDF0"=>"\u0635\u0644\u06D2".freeze, "\uFDF1"=>"\u0642\u0644\u06D2".freeze, "\uFDF2"=>"\u0627\u0644\u0644\u0647".freeze, "\uFDF3"=>"\u0627\u0643\u0628\u0631".freeze, "\uFDF4"=>"\u0645\u062D\u0645\u062F".freeze,
    "\uFDF5"=>"\u0635\u0644\u0639\u0645".freeze, "\uFDF6"=>"\u0631\u0633\u0648\u0644".freeze, "\uFDF7"=>"\u0639\u0644\u064A\u0647".freeze, "\uFDF8"=>"\u0648\u0633\u0644\u0645".freeze, "\uFDF9"=>"\u0635\u0644\u0649".freeze, "\uFDFA"=>"\u0635\u0644\u0649 \u0627\u0644\u0644\u0647 \u0639\u0644\u064A\u0647 \u0648\u0633\u0644\u0645".freeze, "\uFDFB"=>"\u062C\u0644 \u062C\u0644\u0627\u0644\u0647".freeze, "\uFDFC"=>"\u0631\u06CC\u0627\u0644".freeze,
    "\uFE10"=>",".freeze, "\uFE11"=>"\u3001".freeze, "\uFE12"=>"\u3002".freeze, "\uFE13"=>":".freeze, "\uFE14"=>";".freeze, "\uFE15"=>"!".freeze, "\uFE16"=>"?".freeze, "\uFE17"=>"\u3016".freeze,
    "\uFE18"=>"\u3017".freeze, "\uFE19"=>"...".freeze, "\uFE30"=>"..".freeze, "\uFE31"=>"\u2014".freeze, "\uFE32"=>"\u2013".freeze, "\uFE33"=>"_".freeze, "\uFE34"=>"_".freeze, "\uFE35"=>"(".freeze,
    "\uFE36"=>")".freeze, "\uFE37"=>"{".freeze, "\uFE38"=>"}".freeze, "\uFE39"=>"\u3014".freeze, "\uFE3A"=>"\u3015".freeze, "\uFE3B"=>"\u3010".freeze, "\uFE3C"=>"\u3011".freeze, "\uFE3D"=>"\u300A".freeze,
    "\uFE3E"=>"\u300B".freeze, "\uFE3F"=>"\u3008".freeze, "\uFE40"=>"\u3009".freeze, "\uFE41"=>"\u300C".freeze, "\uFE42"=>"\u300D".freeze, "\uFE43"=>"\u300E".freeze, "\uFE44"=>"\u300F".freeze, "\uFE47"=>"[".freeze,
    "\uFE48"=>"]".freeze, "\uFE49"=>" \u0305".freeze, "\uFE4A"=>" \u0305".freeze, "\uFE4B"=>" \u0305".freeze, "\uFE4C"=>" \u0305".freeze, "\uFE4D"=>"_".freeze, "\uFE4E"=>"_".freeze, "\uFE4F"=>"_".freeze,
    "\uFE50"=>",".freeze, "\uFE51"=>"\u3001".freeze, "\uFE52"=>".".freeze, "\uFE54"=>";".freeze, "\uFE55"=>":".freeze, "\uFE56"=>"?".freeze, "\uFE57"=>"!".freeze, "\uFE58"=>"\u2014".freeze,
    "\uFE59"=>"(".freeze, "\uFE5A"=>")".freeze, "\uFE5B"=>"{".freeze, "\uFE5C"=>"}".freeze, "\uFE5D"=>"\u3014".freeze, "\uFE5E"=>"\u3015".freeze, "\uFE5F"=>"#".freeze, "\uFE60"=>"&".freeze,
    "\uFE61"=>"*".freeze, "\uFE62"=>"+".freeze, "\uFE63"=>"-".freeze, "\uFE64"=>"<".freeze, "\uFE65"=>">".freeze, "\uFE66"=>"=".freeze, "\uFE68"=>"\\".freeze, "\uFE69"=>"$".freeze,
    "\uFE6A"=>"%".freeze, "\uFE6B"=>"@".freeze, "\uFE70"=>" \u064B".freeze, "\uFE71"=>"\u0640\u064B".freeze, "\uFE72"=>" \u064C".freeze, "\uFE74"=>" \u064D".freeze, "\uFE76"=>" \u064E".freeze, "\uFE77"=>"\u0640\u064E".freeze,
    "\uFE78"=>" \u064F".freeze, "\uFE79"=>"\u0640\u064F".freeze, "\uFE7A"=>" \u0650".freeze, "\uFE7B"=>"\u0640\u0650".freeze, "\uFE7C"=>" \u0651".freeze, "\uFE7D"=>"\u0640\u0651".freeze, "\uFE7E"=>" \u0652".freeze, "\uFE7F"=>"\u0640\u0652".freeze,
    "\uFE80"=>"\u0621".freeze, "\uFE81"=>"\u0622".freeze, "\uFE82"=>"\u0622".freeze, "\uFE83"=>"\u0623".freeze, "\uFE84"=>"\u0623".freeze, "\uFE85"=>"\u0624".freeze, "\uFE86"=>"\u0624".freeze, "\uFE87"=>"\u0625".freeze,
    "\uFE88"=>"\u0625".freeze, "\uFE89"=>"\u0626".freeze, "\uFE8A"=>"\u0626".freeze, "\uFE8B"=>"\u0626".freeze, "\uFE8C"=>"\u0626".freeze, "\uFE8D"=>"\u0627".freeze, "\uFE8E"=>"\u0627".freeze, "\uFE8F"=>"\u0628".freeze,
    "\uFE90"=>"\u0628".freeze, "\uFE91"=>"\u0628".freeze, "\uFE92"=>"\u0628".freeze, "\uFE93"=>"\u0629".freeze, "\uFE94"=>"\u0629".freeze, "\uFE95"=>"\u062A".freeze, "\uFE96"=>"\u062A".freeze, "\uFE97"=>"\u062A".freeze,
    "\uFE98"=>"\u062A".freeze, "\uFE99"=>"\u062B".freeze, "\uFE9A"=>"\u062B".freeze, "\uFE9B"=>"\u062B".freeze, "\uFE9C"=>"\u062B".freeze, "\uFE9D"=>"\u062C".freeze, "\uFE9E"=>"\u062C".freeze, "\uFE9F"=>"\u062C".freeze,
    "\uFEA0"=>"\u062C".freeze, "\uFEA1"=>"\u062D".freeze, "\uFEA2"=>"\u062D".freeze, "\uFEA3"=>"\u062D".freeze, "\uFEA4"=>"\u062D".freeze, "\uFEA5"=>"\u062E".freeze, "\uFEA6"=>"\u062E".freeze, "\uFEA7"=>"\u062E".freeze,
    "\uFEA8"=>"\u062E".freeze, "\uFEA9"=>"\u062F".freeze, "\uFEAA"=>"\u062F".freeze, "\uFEAB"=>"\u0630".freeze, "\uFEAC"=>"\u0630".freeze, "\uFEAD"=>"\u0631".freeze, "\uFEAE"=>"\u0631".freeze, "\uFEAF"=>"\u0632".freeze,
    "\uFEB0"=>"\u0632".freeze, "\uFEB1"=>"\u0633".freeze, "\uFEB2"=>"\u0633".freeze, "\uFEB3"=>"\u0633".freeze, "\uFEB4"=>"\u0633".freeze, "\uFEB5"=>"\u0634".freeze, "\uFEB6"=>"\u0634".freeze, "\uFEB7"=>"\u0634".freeze,
    "\uFEB8"=>"\u0634".freeze, "\uFEB9"=>"\u0635".freeze, "\uFEBA"=>"\u0635".freeze, "\uFEBB"=>"\u0635".freeze, "\uFEBC"=>"\u0635".freeze, "\uFEBD"=>"\u0636".freeze, "\uFEBE"=>"\u0636".freeze, "\uFEBF"=>"\u0636".freeze,
    "\uFEC0"=>"\u0636".freeze, "\uFEC1"=>"\u0637".freeze, "\uFEC2"=>"\u0637".freeze, "\uFEC3"=>"\u0637".freeze, "\uFEC4"=>"\u0637".freeze, "\uFEC5"=>"\u0638".freeze, "\uFEC6"=>"\u0638".freeze, "\uFEC7"=>"\u0638".freeze,
    "\uFEC8"=>"\u0638".freeze, "\uFEC9"=>"\u0639".freeze, "\uFECA"=>"\u0639".freeze, "\uFECB"=>"\u0639".freeze, "\uFECC"=>"\u0639".freeze, "\uFECD"=>"\u063A".freeze, "\uFECE"=>"\u063A".freeze, "\uFECF"=>"\u063A".freeze,
    "\uFED0"=>"\u063A".freeze, "\uFED1"=>"\u0641".freeze, "\uFED2"=>"\u0641".freeze, "\uFED3"=>"\u0641".freeze, "\uFED4"=>"\u0641".freeze, "\uFED5"=>"\u0642".freeze, "\uFED6"=>"\u0642".freeze, "\uFED7"=>"\u0642".freeze,
    "\uFED8"=>"\u0642".freeze, "\uFED9"=>"\u0643".freeze, "\uFEDA"=>"\u0643".freeze, "\uFEDB"=>"\u0643".freeze, "\uFEDC"=>"\u0643".freeze, "\uFEDD"=>"\u0644".freeze, "\uFEDE"=>"\u0644".freeze, "\uFEDF"=>"\u0644".freeze,
    "\uFEE0"=>"\u0644".freeze, "\uFEE1"=>"\u0645".freeze, "\uFEE2"=>"\u0645".freeze, "\uFEE3"=>"\u0645".freeze, "\uFEE4"=>"\u0645".freeze, "\uFEE5"=>"\u0646".freeze, "\uFEE6"=>"\u0646".freeze, "\uFEE7"=>"\u0646".freeze,
    "\uFEE8"=>"\u0646".freeze, "\uFEE9"=>"\u0647".freeze, "\uFEEA"=>"\u0647".freeze, "\uFEEB"=>"\u0647".freeze, "\uFEEC"=>"\u0647".freeze, "\uFEED"=>"\u0648".freeze, "\uFEEE"=>"\u0648".freeze, "\uFEEF"=>"\u0649".freeze,
    "\uFEF0"=>"\u0649".freeze, "\uFEF1"=>"\u064A".freeze, "\uFEF2"=>"\u064A".freeze, "\uFEF3"=>"\u064A".freeze, "\uFEF4"=>"\u064A".freeze, "\uFEF5"=>"\u0644\u0622".freeze, "\uFEF6"=>"\u0644\u0622".freeze, "\uFEF7"=>"\u0644\u0623".freeze,
    "\uFEF8"=>"\u0644\u0623".freeze, "\uFEF9"=>"\u0644\u0625".freeze, "\uFEFA"=>"\u0644\u0625".freeze, "\uFEFB"=>"\u0644\u0627".freeze, "\uFEFC"=>"\u0644\u0627".freeze, "\uFF01"=>"!".freeze, "\uFF02"=>"\"".freeze, "\uFF03"=>"#".freeze,
    "\uFF04"=>"$".freeze, "\uFF05"=>"%".freeze, "\uFF06"=>"&".freeze, "\uFF07"=>"'".freeze, "\uFF08"=>"(".freeze, "\uFF09"=>")".freeze, "\uFF0A"=>"*".freeze, "\uFF0B"=>"+".freeze,
    "\uFF0C"=>",".freeze, "\uFF0D"=>"-".freeze, "\uFF0E"=>".".freeze, "\uFF0F"=>"/".freeze, "\uFF10"=>"0".freeze, "\uFF11"=>"1".freeze, "\uFF12"=>"2".freeze, "\uFF13"=>"3".freeze,
    "\uFF14"=>"4".freeze, "\uFF15"=>"5".freeze, "\uFF16"=>"6".freeze, "\uFF17"=>"7".freeze, "\uFF18"=>"8".freeze, "\uFF19"=>"9".freeze, "\uFF1A"=>":".freeze, "\uFF1B"=>";".freeze,
    "\uFF1C"=>"<".freeze, "\uFF1D"=>"=".freeze, "\uFF1E"=>">".freeze, "\uFF1F"=>"?".freeze, "\uFF20"=>"@".freeze, "\uFF21"=>"A".freeze, "\uFF22"=>"B".freeze, "\uFF23"=>"C".freeze,
    "\uFF24"=>"D".freeze, "\uFF25"=>"E".freeze, "\uFF26"=>"F".freeze, "\uFF27"=>"G".freeze, "\uFF28"=>"H".freeze, "\uFF29"=>"I".freeze, "\uFF2A"=>"J".freeze, "\uFF2B"=>"K".freeze,
    "\uFF2C"=>"L".freeze, "\uFF2D"=>"M".freeze, "\uFF2E"=>"N".freeze, "\uFF2F"=>"O".freeze, "\uFF30"=>"P".freeze, "\uFF31"=>"Q".freeze, "\uFF32"=>"R".freeze, "\uFF33"=>"S".freeze,
    "\uFF34"=>"T".freeze, "\uFF35"=>"U".freeze, "\uFF36"=>"V".freeze, "\uFF37"=>"W".freeze, "\uFF38"=>"X".freeze, "\uFF39"=>"Y".freeze, "\uFF3A"=>"Z".freeze, "\uFF3B"=>"[".freeze,
    "\uFF3C"=>"\\".freeze, "\uFF3D"=>"]".freeze, "\uFF3E"=>"^".freeze, "\uFF3F"=>"_".freeze, "\uFF40"=>"`".freeze, "\uFF41"=>"a".freeze, "\uFF42"=>"b".freeze, "\uFF43"=>"c".freeze,
    "\uFF44"=>"d".freeze, "\uFF45"=>"e".freeze, "\uFF46"=>"f".freeze, "\uFF47"=>"g".freeze, "\uFF48"=>"h".freeze, "\uFF49"=>"i".freeze, "\uFF4A"=>"j".freeze, "\uFF4B"=>"k".freeze,
    "\uFF4C"=>"l".freeze, "\uFF4D"=>"m".freeze, "\uFF4E"=>"n".freeze, "\uFF4F"=>"o".freeze, "\uFF50"=>"p".freeze, "\uFF51"=>"q".freeze, "\uFF52"=>"r".freeze, "\uFF53"=>"s".freeze,
    "\uFF54"=>"t".freeze, "\uFF55"=>"u".freeze, "\uFF56"=>"v".freeze, "\uFF57"=>"w".freeze, "\uFF58"=>"x".freeze, "\uFF59"=>"y".freeze, "\uFF5A"=>"z".freeze, "\uFF5B"=>"{".freeze,
    "\uFF5C"=>"|".freeze, "\uFF5D"=>"}".freeze, "\uFF5E"=>"~".freeze, "\uFF5F"=>"\u2985".freeze, "\uFF60"=>"\u2986".freeze, "\uFF61"=>"\u3002".freeze, "\uFF62"=>"\u300C".freeze, "\uFF63"=>"\u300D".freeze,
    "\uFF64"=>"\u3001".freeze, "\uFF65"=>"\u30FB".freeze, "\uFF66"=>"\u30F2".freeze, "\uFF67"=>"\u30A1".freeze, "\uFF68"=>"\u30A3".freeze, "\uFF69"=>"\u30A5".freeze, "\uFF6A"=>"\u30A7".freeze, "\uFF6B"=>"\u30A9".freeze,
    "\uFF6C"=>"\u30E3".freeze, "\uFF6D"=>"\u30E5".freeze, "\uFF6E"=>"\u30E7".freeze, "\uFF6F"=>"\u30C3".freeze, "\uFF70"=>"\u30FC".freeze, "\uFF71"=>"\u30A2".freeze, "\uFF72"=>"\u30A4".freeze, "\uFF73"=>"\u30A6".freeze,
    "\uFF74"=>"\u30A8".freeze, "\uFF75"=>"\u30AA".freeze, "\uFF76"=>"\u30AB".freeze, "\uFF77"=>"\u30AD".freeze, "\uFF78"=>"\u30AF".freeze, "\uFF79"=>"\u30B1".freeze, "\uFF7A"=>"\u30B3".freeze, "\uFF7B"=>"\u30B5".freeze,
    "\uFF7C"=>"\u30B7".freeze, "\uFF7D"=>"\u30B9".freeze, "\uFF7E"=>"\u30BB".freeze, "\uFF7F"=>"\u30BD".freeze, "\uFF80"=>"\u30BF".freeze, "\uFF81"=>"\u30C1".freeze, "\uFF82"=>"\u30C4".freeze, "\uFF83"=>"\u30C6".freeze,
    "\uFF84"=>"\u30C8".freeze, "\uFF85"=>"\u30CA".freeze, "\uFF86"=>"\u30CB".freeze, "\uFF87"=>"\u30CC".freeze, "\uFF88"=>"\u30CD".freeze, "\uFF89"=>"\u30CE".freeze, "\uFF8A"=>"\u30CF".freeze, "\uFF8B"=>"\u30D2".freeze,
    "\uFF8C"=>"\u30D5".freeze, "\uFF8D"=>"\u30D8".freeze, "\uFF8E"=>"\u30DB".freeze, "\uFF8F"=>"\u30DE".freeze, "\uFF90"=>"\u30DF".freeze, "\uFF91"=>"\u30E0".freeze, "\uFF92"=>"\u30E1".freeze, "\uFF93"=>"\u30E2".freeze,
    "\uFF94"=>"\u30E4".freeze, "\uFF95"=>"\u30E6".freeze, "\uFF96"=>"\u30E8".freeze, "\uFF97"=>"\u30E9".freeze, "\uFF98"=>"\u30EA".freeze, "\uFF99"=>"\u30EB".freeze, "\uFF9A"=>"\u30EC".freeze, "\uFF9B"=>"\u30ED".freeze,
    "\uFF9C"=>"\u30EF".freeze, "\uFF9D"=>"\u30F3".freeze, "\uFF9E"=>"\u3099".freeze, "\uFF9F"=>"\u309A".freeze, "\uFFA0"=>"\u1160".freeze, "\uFFA1"=>"\u1100".freeze, "\uFFA2"=>"\u1101".freeze, "\uFFA3"=>"\u11AA".freeze,
    "\uFFA4"=>"\u1102".freeze, "\uFFA5"=>"\u11AC".freeze, "\uFFA6"=>"\u11AD".freeze, "\uFFA7"=>"\u1103".freeze, "\uFFA8"=>"\u1104".freeze, "\uFFA9"=>"\u1105".freeze, "\uFFAA"=>"\u11B0".freeze, "\uFFAB"=>"\u11B1".freeze,
    "\uFFAC"=>"\u11B2".freeze, "\uFFAD"=>"\u11B3".freeze, "\uFFAE"=>"\u11B4".freeze, "\uFFAF"=>"\u11B5".freeze, "\uFFB0"=>"\u111A".freeze, "\uFFB1"=>"\u1106".freeze, "\uFFB2"=>"\u1107".freeze, "\uFFB3"=>"\u1108".freeze,
    "\uFFB4"=>"\u1121".freeze, "\uFFB5"=>"\u1109".freeze, "\uFFB6"=>"\u110A".freeze, "\uFFB7"=>"\u110B".freeze, "\uFFB8"=>"\u110C".freeze, "\uFFB9"=>"\u110D".freeze, "\uFFBA"=>"\u110E".freeze, "\uFFBB"=>"\u110F".freeze,
    "\uFFBC"=>"\u1110".freeze, "\uFFBD"=>"\u1111".freeze, "\uFFBE"=>"\u1112".freeze, "\uFFC2"=>"\u1161".freeze, "\uFFC3"=>"\u1162".freeze, "\uFFC4"=>"\u1163".freeze, "\uFFC5"=>"\u1164".freeze, "\uFFC6"=>"\u1165".freeze,
    "\uFFC7"=>"\u1166".freeze, "\uFFCA"=>"\u1167".freeze, "\uFFCB"=>"\u1168".freeze, "\uFFCC"=>"\u1169".freeze, "\uFFCD"=>"\u116A".freeze, "\uFFCE"=>"\u116B".freeze, "\uFFCF"=>"\u116C".freeze, "\uFFD2"=>"\u116D".freeze,
    "\uFFD3"=>"\u116E".freeze, "\uFFD4"=>"\u116F".freeze, "\uFFD5"=>"\u1170".freeze, "\uFFD6"=>"\u1171".freeze, "\uFFD7"=>"\u1172".freeze, "\uFFDA"=>"\u1173".freeze, "\uFFDB"=>"\u1174".freeze, "\uFFDC"=>"\u1175".freeze,
    "\uFFE0"=>"\u00A2".freeze, "\uFFE1"=>"\u00A3".freeze, "\uFFE2"=>"\u00AC".freeze, "\uFFE3"=>" \u0304".freeze, "\uFFE4"=>"\u00A6".freeze, "\uFFE5"=>"\u00A5".freeze, "\uFFE6"=>"\u20A9".freeze, "\uFFE8"=>"\u2502".freeze,
    "\uFFE9"=>"\u2190".freeze, "\uFFEA"=>"\u2191".freeze, "\uFFEB"=>"\u2192".freeze, "\uFFEC"=>"\u2193".freeze, "\uFFED"=>"\u25A0".freeze, "\uFFEE"=>"\u25CB".freeze, "\u{1D400}"=>"A".freeze, "\u{1D401}"=>"B".freeze,
    "\u{1D402}"=>"C".freeze, "\u{1D403}"=>"D".freeze, "\u{1D404}"=>"E".freeze, "\u{1D405}"=>"F".freeze, "\u{1D406}"=>"G".freeze, "\u{1D407}"=>"H".freeze, "\u{1D408}"=>"I".freeze, "\u{1D409}"=>"J".freeze,
    "\u{1D40A}"=>"K".freeze, "\u{1D40B}"=>"L".freeze, "\u{1D40C}"=>"M".freeze, "\u{1D40D}"=>"N".freeze, "\u{1D40E}"=>"O".freeze, "\u{1D40F}"=>"P".freeze, "\u{1D410}"=>"Q".freeze, "\u{1D411}"=>"R".freeze,
    "\u{1D412}"=>"S".freeze, "\u{1D413}"=>"T".freeze, "\u{1D414}"=>"U".freeze, "\u{1D415}"=>"V".freeze, "\u{1D416}"=>"W".freeze, "\u{1D417}"=>"X".freeze, "\u{1D418}"=>"Y".freeze, "\u{1D419}"=>"Z".freeze,
    "\u{1D41A}"=>"a".freeze, "\u{1D41B}"=>"b".freeze, "\u{1D41C}"=>"c".freeze, "\u{1D41D}"=>"d".freeze, "\u{1D41E}"=>"e".freeze, "\u{1D41F}"=>"f".freeze, "\u{1D420}"=>"g".freeze, "\u{1D421}"=>"h".freeze,
    "\u{1D422}"=>"i".freeze, "\u{1D423}"=>"j".freeze, "\u{1D424}"=>"k".freeze, "\u{1D425}"=>"l".freeze, "\u{1D426}"=>"m".freeze, "\u{1D427}"=>"n".freeze, "\u{1D428}"=>"o".freeze, "\u{1D429}"=>"p".freeze,
    "\u{1D42A}"=>"q".freeze, "\u{1D42B}"=>"r".freeze, "\u{1D42C}"=>"s".freeze, "\u{1D42D}"=>"t".freeze, "\u{1D42E}"=>"u".freeze, "\u{1D42F}"=>"v".freeze, "\u{1D430}"=>"w".freeze, "\u{1D431}"=>"x".freeze,
    "\u{1D432}"=>"y".freeze, "\u{1D433}"=>"z".freeze, "\u{1D434}"=>"A".freeze, "\u{1D435}"=>"B".freeze, "\u{1D436}"=>"C".freeze, "\u{1D437}"=>"D".freeze, "\u{1D438}"=>"E".freeze, "\u{1D439}"=>"F".freeze,
    "\u{1D43A}"=>"G".freeze, "\u{1D43B}"=>"H".freeze, "\u{1D43C}"=>"I".freeze, "\u{1D43D}"=>"J".freeze, "\u{1D43E}"=>"K".freeze, "\u{1D43F}"=>"L".freeze, "\u{1D440}"=>"M".freeze, "\u{1D441}"=>"N".freeze,
    "\u{1D442}"=>"O".freeze, "\u{1D443}"=>"P".freeze, "\u{1D444}"=>"Q".freeze, "\u{1D445}"=>"R".freeze, "\u{1D446}"=>"S".freeze, "\u{1D447}"=>"T".freeze, "\u{1D448}"=>"U".freeze, "\u{1D449}"=>"V".freeze,
    "\u{1D44A}"=>"W".freeze, "\u{1D44B}"=>"X".freeze, "\u{1D44C}"=>"Y".freeze, "\u{1D44D}"=>"Z".freeze, "\u{1D44E}"=>"a".freeze, "\u{1D44F}"=>"b".freeze, "\u{1D450}"=>"c".freeze, "\u{1D451}"=>"d".freeze,
    "\u{1D452}"=>"e".freeze, "\u{1D453}"=>"f".freeze, "\u{1D454}"=>"g".freeze, "\u{1D456}"=>"i".freeze, "\u{1D457}"=>"j".freeze, "\u{1D458}"=>"k".freeze, "\u{1D459}"=>"l".freeze, "\u{1D45A}"=>"m".freeze,
    "\u{1D45B}"=>"n".freeze, "\u{1D45C}"=>"o".freeze, "\u{1D45D}"=>"p".freeze, "\u{1D45E}"=>"q".freeze, "\u{1D45F}"=>"r".freeze, "\u{1D460}"=>"s".freeze, "\u{1D461}"=>"t".freeze, "\u{1D462}"=>"u".freeze,
    "\u{1D463}"=>"v".freeze, "\u{1D464}"=>"w".freeze, "\u{1D465}"=>"x".freeze, "\u{1D466}"=>"y".freeze, "\u{1D467}"=>"z".freeze, "\u{1D468}"=>"A".freeze, "\u{1D469}"=>"B".freeze, "\u{1D46A}"=>"C".freeze,
    "\u{1D46B}"=>"D".freeze, "\u{1D46C}"=>"E".freeze, "\u{1D46D}"=>"F".freeze, "\u{1D46E}"=>"G".freeze, "\u{1D46F}"=>"H".freeze, "\u{1D470}"=>"I".freeze, "\u{1D471}"=>"J".freeze, "\u{1D472}"=>"K".freeze,
    "\u{1D473}"=>"L".freeze, "\u{1D474}"=>"M".freeze, "\u{1D475}"=>"N".freeze, "\u{1D476}"=>"O".freeze, "\u{1D477}"=>"P".freeze, "\u{1D478}"=>"Q".freeze, "\u{1D479}"=>"R".freeze, "\u{1D47A}"=>"S".freeze,
    "\u{1D47B}"=>"T".freeze, "\u{1D47C}"=>"U".freeze, "\u{1D47D}"=>"V".freeze, "\u{1D47E}"=>"W".freeze, "\u{1D47F}"=>"X".freeze, "\u{1D480}"=>"Y".freeze, "\u{1D481}"=>"Z".freeze, "\u{1D482}"=>"a".freeze,
    "\u{1D483}"=>"b".freeze, "\u{1D484}"=>"c".freeze, "\u{1D485}"=>"d".freeze, "\u{1D486}"=>"e".freeze, "\u{1D487}"=>"f".freeze, "\u{1D488}"=>"g".freeze, "\u{1D489}"=>"h".freeze, "\u{1D48A}"=>"i".freeze,
    "\u{1D48B}"=>"j".freeze, "\u{1D48C}"=>"k".freeze, "\u{1D48D}"=>"l".freeze, "\u{1D48E}"=>"m".freeze, "\u{1D48F}"=>"n".freeze, "\u{1D490}"=>"o".freeze, "\u{1D491}"=>"p".freeze, "\u{1D492}"=>"q".freeze,
    "\u{1D493}"=>"r".freeze, "\u{1D494}"=>"s".freeze, "\u{1D495}"=>"t".freeze, "\u{1D496}"=>"u".freeze, "\u{1D497}"=>"v".freeze, "\u{1D498}"=>"w".freeze, "\u{1D499}"=>"x".freeze, "\u{1D49A}"=>"y".freeze,
    "\u{1D49B}"=>"z".freeze, "\u{1D49C}"=>"A".freeze, "\u{1D49E}"=>"C".freeze, "\u{1D49F}"=>"D".freeze, "\u{1D4A2}"=>"G".freeze, "\u{1D4A5}"=>"J".freeze, "\u{1D4A6}"=>"K".freeze, "\u{1D4A9}"=>"N".freeze,
    "\u{1D4AA}"=>"O".freeze, "\u{1D4AB}"=>"P".freeze, "\u{1D4AC}"=>"Q".freeze, "\u{1D4AE}"=>"S".freeze, "\u{1D4AF}"=>"T".freeze, "\u{1D4B0}"=>"U".freeze, "\u{1D4B1}"=>"V".freeze, "\u{1D4B2}"=>"W".freeze,
    "\u{1D4B3}"=>"X".freeze, "\u{1D4B4}"=>"Y".freeze, "\u{1D4B5}"=>"Z".freeze, "\u{1D4B6}"=>"a".freeze, "\u{1D4B7}"=>"b".freeze, "\u{1D4B8}"=>"c".freeze, "\u{1D4B9}"=>"d".freeze, "\u{1D4BB}"=>"f".freeze,
    "\u{1D4BD}"=>"h".freeze, "\u{1D4BE}"=>"i".freeze, "\u{1D4BF}"=>"j".freeze, "\u{1D4C0}"=>"k".freeze, "\u{1D4C1}"=>"l".freeze, "\u{1D4C2}"=>"m".freeze, "\u{1D4C3}"=>"n".freeze, "\u{1D4C5}"=>"p".freeze,
    "\u{1D4C6}"=>"q".freeze, "\u{1D4C7}"=>"r".freeze, "\u{1D4C8}"=>"s".freeze, "\u{1D4C9}"=>"t".freeze, "\u{1D4CA}"=>"u".freeze, "\u{1D4CB}"=>"v".freeze, "\u{1D4CC}"=>"w".freeze, "\u{1D4CD}"=>"x".freeze,
    "\u{1D4CE}"=>"y".freeze, "\u{1D4CF}"=>"z".freeze, "\u{1D4D0}"=>"A".freeze, "\u{1D4D1}"=>"B".freeze, "\u{1D4D2}"=>"C".freeze, "\u{1D4D3}"=>"D".freeze, "\u{1D4D4}"=>"E".freeze, "\u{1D4D5}"=>"F".freeze,
    "\u{1D4D6}"=>"G".freeze, "\u{1D4D7}"=>"H".freeze, "\u{1D4D8}"=>"I".freeze, "\u{1D4D9}"=>"J".freeze, "\u{1D4DA}"=>"K".freeze, "\u{1D4DB}"=>"L".freeze, "\u{1D4DC}"=>"M".freeze, "\u{1D4DD}"=>"N".freeze,
    "\u{1D4DE}"=>"O".freeze, "\u{1D4DF}"=>"P".freeze, "\u{1D4E0}"=>"Q".freeze, "\u{1D4E1}"=>"R".freeze, "\u{1D4E2}"=>"S".freeze, "\u{1D4E3}"=>"T".freeze, "\u{1D4E4}"=>"U".freeze, "\u{1D4E5}"=>"V".freeze,
    "\u{1D4E6}"=>"W".freeze, "\u{1D4E7}"=>"X".freeze, "\u{1D4E8}"=>"Y".freeze, "\u{1D4E9}"=>"Z".freeze, "\u{1D4EA}"=>"a".freeze, "\u{1D4EB}"=>"b".freeze, "\u{1D4EC}"=>"c".freeze, "\u{1D4ED}"=>"d".freeze,
    "\u{1D4EE}"=>"e".freeze, "\u{1D4EF}"=>"f".freeze, "\u{1D4F0}"=>"g".freeze, "\u{1D4F1}"=>"h".freeze, "\u{1D4F2}"=>"i".freeze, "\u{1D4F3}"=>"j".freeze, "\u{1D4F4}"=>"k".freeze, "\u{1D4F5}"=>"l".freeze,
    "\u{1D4F6}"=>"m".freeze, "\u{1D4F7}"=>"n".freeze, "\u{1D4F8}"=>"o".freeze, "\u{1D4F9}"=>"p".freeze, "\u{1D4FA}"=>"q".freeze, "\u{1D4FB}"=>"r".freeze, "\u{1D4FC}"=>"s".freeze, "\u{1D4FD}"=>"t".freeze,
    "\u{1D4FE}"=>"u".freeze, "\u{1D4FF}"=>"v".freeze, "\u{1D500}"=>"w".freeze, "\u{1D501}"=>"x".freeze, "\u{1D502}"=>"y".freeze, "\u{1D503}"=>"z".freeze, "\u{1D504}"=>"A".freeze, "\u{1D505}"=>"B".freeze,
    "\u{1D507}"=>"D".freeze, "\u{1D508}"=>"E".freeze, "\u{1D509}"=>"F".freeze, "\u{1D50A}"=>"G".freeze, "\u{1D50D}"=>"J".freeze, "\u{1D50E}"=>"K".freeze, "\u{1D50F}"=>"L".freeze, "\u{1D510}"=>"M".freeze,
    "\u{1D511}"=>"N".freeze, "\u{1D512}"=>"O".freeze, "\u{1D513}"=>"P".freeze, "\u{1D514}"=>"Q".freeze, "\u{1D516}"=>"S".freeze, "\u{1D517}"=>"T".freeze, "\u{1D518}"=>"U".freeze, "\u{1D519}"=>"V".freeze,
    "\u{1D51A}"=>"W".freeze, "\u{1D51B}"=>"X".freeze, "\u{1D51C}"=>"Y".freeze, "\u{1D51E}"=>"a".freeze, "\u{1D51F}"=>"b".freeze, "\u{1D520}"=>"c".freeze, "\u{1D521}"=>"d".freeze, "\u{1D522}"=>"e".freeze,
    "\u{1D523}"=>"f".freeze, "\u{1D524}"=>"g".freeze, "\u{1D525}"=>"h".freeze, "\u{1D526}"=>"i".freeze, "\u{1D527}"=>"j".freeze, "\u{1D528}"=>"k".freeze, "\u{1D529}"=>"l".freeze, "\u{1D52A}"=>"m".freeze,
    "\u{1D52B}"=>"n".freeze, "\u{1D52C}"=>"o".freeze, "\u{1D52D}"=>"p".freeze, "\u{1D52E}"=>"q".freeze, "\u{1D52F}"=>"r".freeze, "\u{1D530}"=>"s".freeze, "\u{1D531}"=>"t".freeze, "\u{1D532}"=>"u".freeze,
    "\u{1D533}"=>"v".freeze, "\u{1D534}"=>"w".freeze, "\u{1D535}"=>"x".freeze, "\u{1D536}"=>"y".freeze, "\u{1D537}"=>"z".freeze, "\u{1D538}"=>"A".freeze, "\u{1D539}"=>"B".freeze, "\u{1D53B}"=>"D".freeze,
    "\u{1D53C}"=>"E".freeze, "\u{1D53D}"=>"F".freeze, "\u{1D53E}"=>"G".freeze, "\u{1D540}"=>"I".freeze, "\u{1D541}"=>"J".freeze, "\u{1D542}"=>"K".freeze, "\u{1D543}"=>"L".freeze, "\u{1D544}"=>"M".freeze,
    "\u{1D546}"=>"O".freeze, "\u{1D54A}"=>"S".freeze, "\u{1D54B}"=>"T".freeze, "\u{1D54C}"=>"U".freeze, "\u{1D54D}"=>"V".freeze, "\u{1D54E}"=>"W".freeze, "\u{1D54F}"=>"X".freeze, "\u{1D550}"=>"Y".freeze,
    "\u{1D552}"=>"a".freeze, "\u{1D553}"=>"b".freeze, "\u{1D554}"=>"c".freeze, "\u{1D555}"=>"d".freeze, "\u{1D556}"=>"e".freeze, "\u{1D557}"=>"f".freeze, "\u{1D558}"=>"g".freeze, "\u{1D559}"=>"h".freeze,
    "\u{1D55A}"=>"i".freeze, "\u{1D55B}"=>"j".freeze, "\u{1D55C}"=>"k".freeze, "\u{1D55D}"=>"l".freeze, "\u{1D55E}"=>"m".freeze, "\u{1D55F}"=>"n".freeze, "\u{1D560}"=>"o".freeze, "\u{1D561}"=>"p".freeze,
    "\u{1D562}"=>"q".freeze, "\u{1D563}"=>"r".freeze, "\u{1D564}"=>"s".freeze, "\u{1D565}"=>"t".freeze, "\u{1D566}"=>"u".freeze, "\u{1D567}"=>"v".freeze, "\u{1D568}"=>"w".freeze, "\u{1D569}"=>"x".freeze,
    "\u{1D56A}"=>"y".freeze, "\u{1D56B}"=>"z".freeze, "\u{1D56C}"=>"A".freeze, "\u{1D56D}"=>"B".freeze, "\u{1D56E}"=>"C".freeze, "\u{1D56F}"=>"D".freeze, "\u{1D570}"=>"E".freeze, "\u{1D571}"=>"F".freeze,
    "\u{1D572}"=>"G".freeze, "\u{1D573}"=>"H".freeze, "\u{1D574}"=>"I".freeze, "\u{1D575}"=>"J".freeze, "\u{1D576}"=>"K".freeze, "\u{1D577}"=>"L".freeze, "\u{1D578}"=>"M".freeze, "\u{1D579}"=>"N".freeze,
    "\u{1D57A}"=>"O".freeze, "\u{1D57B}"=>"P".freeze, "\u{1D57C}"=>"Q".freeze, "\u{1D57D}"=>"R".freeze, "\u{1D57E}"=>"S".freeze, "\u{1D57F}"=>"T".freeze, "\u{1D580}"=>"U".freeze, "\u{1D581}"=>"V".freeze,
    "\u{1D582}"=>"W".freeze, "\u{1D583}"=>"X".freeze, "\u{1D584}"=>"Y".freeze, "\u{1D585}"=>"Z".freeze, "\u{1D586}"=>"a".freeze, "\u{1D587}"=>"b".freeze, "\u{1D588}"=>"c".freeze, "\u{1D589}"=>"d".freeze,
    "\u{1D58A}"=>"e".freeze, "\u{1D58B}"=>"f".freeze, "\u{1D58C}"=>"g".freeze, "\u{1D58D}"=>"h".freeze, "\u{1D58E}"=>"i".freeze, "\u{1D58F}"=>"j".freeze, "\u{1D590}"=>"k".freeze, "\u{1D591}"=>"l".freeze,
    "\u{1D592}"=>"m".freeze, "\u{1D593}"=>"n".freeze, "\u{1D594}"=>"o".freeze, "\u{1D595}"=>"p".freeze, "\u{1D596}"=>"q".freeze, "\u{1D597}"=>"r".freeze, "\u{1D598}"=>"s".freeze, "\u{1D599}"=>"t".freeze,
    "\u{1D59A}"=>"u".freeze, "\u{1D59B}"=>"v".freeze, "\u{1D59C}"=>"w".freeze, "\u{1D59D}"=>"x".freeze, "\u{1D59E}"=>"y".freeze, "\u{1D59F}"=>"z".freeze, "\u{1D5A0}"=>"A".freeze, "\u{1D5A1}"=>"B".freeze,
    "\u{1D5A2}"=>"C".freeze, "\u{1D5A3}"=>"D".freeze, "\u{1D5A4}"=>"E".freeze, "\u{1D5A5}"=>"F".freeze, "\u{1D5A6}"=>"G".freeze, "\u{1D5A7}"=>"H".freeze, "\u{1D5A8}"=>"I".freeze, "\u{1D5A9}"=>"J".freeze,
    "\u{1D5AA}"=>"K".freeze, "\u{1D5AB}"=>"L".freeze, "\u{1D5AC}"=>"M".freeze, "\u{1D5AD}"=>"N".freeze, "\u{1D5AE}"=>"O".freeze, "\u{1D5AF}"=>"P".freeze, "\u{1D5B0}"=>"Q".freeze, "\u{1D5B1}"=>"R".freeze,
    "\u{1D5B2}"=>"S".freeze, "\u{1D5B3}"=>"T".freeze, "\u{1D5B4}"=>"U".freeze, "\u{1D5B5}"=>"V".freeze, "\u{1D5B6}"=>"W".freeze, "\u{1D5B7}"=>"X".freeze, "\u{1D5B8}"=>"Y".freeze, "\u{1D5B9}"=>"Z".freeze,
    "\u{1D5BA}"=>"a".freeze, "\u{1D5BB}"=>"b".freeze, "\u{1D5BC}"=>"c".freeze, "\u{1D5BD}"=>"d".freeze, "\u{1D5BE}"=>"e".freeze, "\u{1D5BF}"=>"f".freeze, "\u{1D5C0}"=>"g".freeze, "\u{1D5C1}"=>"h".freeze,
    "\u{1D5C2}"=>"i".freeze, "\u{1D5C3}"=>"j".freeze, "\u{1D5C4}"=>"k".freeze, "\u{1D5C5}"=>"l".freeze, "\u{1D5C6}"=>"m".freeze, "\u{1D5C7}"=>"n".freeze, "\u{1D5C8}"=>"o".freeze, "\u{1D5C9}"=>"p".freeze,
    "\u{1D5CA}"=>"q".freeze, "\u{1D5CB}"=>"r".freeze, "\u{1D5CC}"=>"s".freeze, "\u{1D5CD}"=>"t".freeze, "\u{1D5CE}"=>"u".freeze, "\u{1D5CF}"=>"v".freeze, "\u{1D5D0}"=>"w".freeze, "\u{1D5D1}"=>"x".freeze,
    "\u{1D5D2}"=>"y".freeze, "\u{1D5D3}"=>"z".freeze, "\u{1D5D4}"=>"A".freeze, "\u{1D5D5}"=>"B".freeze, "\u{1D5D6}"=>"C".freeze, "\u{1D5D7}"=>"D".freeze, "\u{1D5D8}"=>"E".freeze, "\u{1D5D9}"=>"F".freeze,
    "\u{1D5DA}"=>"G".freeze, "\u{1D5DB}"=>"H".freeze, "\u{1D5DC}"=>"I".freeze, "\u{1D5DD}"=>"J".freeze, "\u{1D5DE}"=>"K".freeze, "\u{1D5DF}"=>"L".freeze, "\u{1D5E0}"=>"M".freeze, "\u{1D5E1}"=>"N".freeze,
    "\u{1D5E2}"=>"O".freeze, "\u{1D5E3}"=>"P".freeze, "\u{1D5E4}"=>"Q".freeze, "\u{1D5E5}"=>"R".freeze, "\u{1D5E6}"=>"S".freeze, "\u{1D5E7}"=>"T".freeze, "\u{1D5E8}"=>"U".freeze, "\u{1D5E9}"=>"V".freeze,
    "\u{1D5EA}"=>"W".freeze, "\u{1D5EB}"=>"X".freeze, "\u{1D5EC}"=>"Y".freeze, "\u{1D5ED}"=>"Z".freeze, "\u{1D5EE}"=>"a".freeze, "\u{1D5EF}"=>"b".freeze, "\u{1D5F0}"=>"c".freeze, "\u{1D5F1}"=>"d".freeze,
    "\u{1D5F2}"=>"e".freeze, "\u{1D5F3}"=>"f".freeze, "\u{1D5F4}"=>"g".freeze, "\u{1D5F5}"=>"h".freeze, "\u{1D5F6}"=>"i".freeze, "\u{1D5F7}"=>"j".freeze, "\u{1D5F8}"=>"k".freeze, "\u{1D5F9}"=>"l".freeze,
    "\u{1D5FA}"=>"m".freeze, "\u{1D5FB}"=>"n".freeze, "\u{1D5FC}"=>"o".freeze, "\u{1D5FD}"=>"p".freeze, "\u{1D5FE}"=>"q".freeze, "\u{1D5FF}"=>"r".freeze, "\u{1D600}"=>"s".freeze, "\u{1D601}"=>"t".freeze,
    "\u{1D602}"=>"u".freeze, "\u{1D603}"=>"v".freeze, "\u{1D604}"=>"w".freeze, "\u{1D605}"=>"x".freeze, "\u{1D606}"=>"y".freeze, "\u{1D607}"=>"z".freeze, "\u{1D608}"=>"A".freeze, "\u{1D609}"=>"B".freeze,
    "\u{1D60A}"=>"C".freeze, "\u{1D60B}"=>"D".freeze, "\u{1D60C}"=>"E".freeze, "\u{1D60D}"=>"F".freeze, "\u{1D60E}"=>"G".freeze, "\u{1D60F}"=>"H".freeze, "\u{1D610}"=>"I".freeze, "\u{1D611}"=>"J".freeze,
    "\u{1D612}"=>"K".freeze, "\u{1D613}"=>"L".freeze, "\u{1D614}"=>"M".freeze, "\u{1D615}"=>"N".freeze, "\u{1D616}"=>"O".freeze, "\u{1D617}"=>"P".freeze, "\u{1D618}"=>"Q".freeze, "\u{1D619}"=>"R".freeze,
    "\u{1D61A}"=>"S".freeze, "\u{1D61B}"=>"T".freeze, "\u{1D61C}"=>"U".freeze, "\u{1D61D}"=>"V".freeze, "\u{1D61E}"=>"W".freeze, "\u{1D61F}"=>"X".freeze, "\u{1D620}"=>"Y".freeze, "\u{1D621}"=>"Z".freeze,
    "\u{1D622}"=>"a".freeze, "\u{1D623}"=>"b".freeze, "\u{1D624}"=>"c".freeze, "\u{1D625}"=>"d".freeze, "\u{1D626}"=>"e".freeze, "\u{1D627}"=>"f".freeze, "\u{1D628}"=>"g".freeze, "\u{1D629}"=>"h".freeze,
    "\u{1D62A}"=>"i".freeze, "\u{1D62B}"=>"j".freeze, "\u{1D62C}"=>"k".freeze, "\u{1D62D}"=>"l".freeze, "\u{1D62E}"=>"m".freeze, "\u{1D62F}"=>"n".freeze, "\u{1D630}"=>"o".freeze, "\u{1D631}"=>"p".freeze,
    "\u{1D632}"=>"q".freeze, "\u{1D633}"=>"r".freeze, "\u{1D634}"=>"s".freeze, "\u{1D635}"=>"t".freeze, "\u{1D636}"=>"u".freeze, "\u{1D637}"=>"v".freeze, "\u{1D638}"=>"w".freeze, "\u{1D639}"=>"x".freeze,
    "\u{1D63A}"=>"y".freeze, "\u{1D63B}"=>"z".freeze, "\u{1D63C}"=>"A".freeze, "\u{1D63D}"=>"B".freeze, "\u{1D63E}"=>"C".freeze, "\u{1D63F}"=>"D".freeze, "\u{1D640}"=>"E".freeze, "\u{1D641}"=>"F".freeze,
    "\u{1D642}"=>"G".freeze, "\u{1D643}"=>"H".freeze, "\u{1D644}"=>"I".freeze, "\u{1D645}"=>"J".freeze, "\u{1D646}"=>"K".freeze, "\u{1D647}"=>"L".freeze, "\u{1D648}"=>"M".freeze, "\u{1D649}"=>"N".freeze,
    "\u{1D64A}"=>"O".freeze, "\u{1D64B}"=>"P".freeze, "\u{1D64C}"=>"Q".freeze, "\u{1D64D}"=>"R".freeze, "\u{1D64E}"=>"S".freeze, "\u{1D64F}"=>"T".freeze, "\u{1D650}"=>"U".freeze, "\u{1D651}"=>"V".freeze,
    "\u{1D652}"=>"W".freeze, "\u{1D653}"=>"X".freeze, "\u{1D654}"=>"Y".freeze, "\u{1D655}"=>"Z".freeze, "\u{1D656}"=>"a".freeze, "\u{1D657}"=>"b".freeze, "\u{1D658}"=>"c".freeze, "\u{1D659}"=>"d".freeze,
    "\u{1D65A}"=>"e".freeze, "\u{1D65B}"=>"f".freeze, "\u{1D65C}"=>"g".freeze, "\u{1D65D}"=>"h".freeze, "\u{1D65E}"=>"i".freeze, "\u{1D65F}"=>"j".freeze, "\u{1D660}"=>"k".freeze, "\u{1D661}"=>"l".freeze,
    "\u{1D662}"=>"m".freeze, "\u{1D663}"=>"n".freeze, "\u{1D664}"=>"o".freeze, "\u{1D665}"=>"p".freeze, "\u{1D666}"=>"q".freeze, "\u{1D667}"=>"r".freeze, "\u{1D668}"=>"s".freeze, "\u{1D669}"=>"t".freeze,
    "\u{1D66A}"=>"u".freeze, "\u{1D66B}"=>"v".freeze, "\u{1D66C}"=>"w".freeze, "\u{1D66D}"=>"x".freeze, "\u{1D66E}"=>"y".freeze, "\u{1D66F}"=>"z".freeze, "\u{1D670}"=>"A".freeze, "\u{1D671}"=>"B".freeze,
    "\u{1D672}"=>"C".freeze, "\u{1D673}"=>"D".freeze, "\u{1D674}"=>"E".freeze, "\u{1D675}"=>"F".freeze, "\u{1D676}"=>"G".freeze, "\u{1D677}"=>"H".freeze, "\u{1D678}"=>"I".freeze, "\u{1D679}"=>"J".freeze,
    "\u{1D67A}"=>"K".freeze, "\u{1D67B}"=>"L".freeze, "\u{1D67C}"=>"M".freeze, "\u{1D67D}"=>"N".freeze, "\u{1D67E}"=>"O".freeze, "\u{1D67F}"=>"P".freeze, "\u{1D680}"=>"Q".freeze, "\u{1D681}"=>"R".freeze,
    "\u{1D682}"=>"S".freeze, "\u{1D683}"=>"T".freeze, "\u{1D684}"=>"U".freeze, "\u{1D685}"=>"V".freeze, "\u{1D686}"=>"W".freeze, "\u{1D687}"=>"X".freeze, "\u{1D688}"=>"Y".freeze, "\u{1D689}"=>"Z".freeze,
    "\u{1D68A}"=>"a".freeze, "\u{1D68B}"=>"b".freeze, "\u{1D68C}"=>"c".freeze, "\u{1D68D}"=>"d".freeze, "\u{1D68E}"=>"e".freeze, "\u{1D68F}"=>"f".freeze, "\u{1D690}"=>"g".freeze, "\u{1D691}"=>"h".freeze,
    "\u{1D692}"=>"i".freeze, "\u{1D693}"=>"j".freeze, "\u{1D694}"=>"k".freeze, "\u{1D695}"=>"l".freeze, "\u{1D696}"=>"m".freeze, "\u{1D697}"=>"n".freeze, "\u{1D698}"=>"o".freeze, "\u{1D699}"=>"p".freeze,
    "\u{1D69A}"=>"q".freeze, "\u{1D69B}"=>"r".freeze, "\u{1D69C}"=>"s".freeze, "\u{1D69D}"=>"t".freeze, "\u{1D69E}"=>"u".freeze, "\u{1D69F}"=>"v".freeze, "\u{1D6A0}"=>"w".freeze, "\u{1D6A1}"=>"x".freeze,
    "\u{1D6A2}"=>"y".freeze, "\u{1D6A3}"=>"z".freeze, "\u{1D6A4}"=>"\u0131".freeze, "\u{1D6A5}"=>"\u0237".freeze, "\u{1D6A8}"=>"\u0391".freeze, "\u{1D6A9}"=>"\u0392".freeze, "\u{1D6AA}"=>"\u0393".freeze, "\u{1D6AB}"=>"\u0394".freeze,
    "\u{1D6AC}"=>"\u0395".freeze, "\u{1D6AD}"=>"\u0396".freeze, "\u{1D6AE}"=>"\u0397".freeze, "\u{1D6AF}"=>"\u0398".freeze, "\u{1D6B0}"=>"\u0399".freeze, "\u{1D6B1}"=>"\u039A".freeze, "\u{1D6B2}"=>"\u039B".freeze, "\u{1D6B3}"=>"\u039C".freeze,
    "\u{1D6B4}"=>"\u039D".freeze, "\u{1D6B5}"=>"\u039E".freeze, "\u{1D6B6}"=>"\u039F".freeze, "\u{1D6B7}"=>"\u03A0".freeze, "\u{1D6B8}"=>"\u03A1".freeze, "\u{1D6B9}"=>"\u0398".freeze, "\u{1D6BA}"=>"\u03A3".freeze, "\u{1D6BB}"=>"\u03A4".freeze,
    "\u{1D6BC}"=>"\u03A5".freeze, "\u{1D6BD}"=>"\u03A6".freeze, "\u{1D6BE}"=>"\u03A7".freeze, "\u{1D6BF}"=>"\u03A8".freeze, "\u{1D6C0}"=>"\u03A9".freeze, "\u{1D6C1}"=>"\u2207".freeze, "\u{1D6C2}"=>"\u03B1".freeze, "\u{1D6C3}"=>"\u03B2".freeze,
    "\u{1D6C4}"=>"\u03B3".freeze, "\u{1D6C5}"=>"\u03B4".freeze, "\u{1D6C6}"=>"\u03B5".freeze, "\u{1D6C7}"=>"\u03B6".freeze, "\u{1D6C8}"=>"\u03B7".freeze, "\u{1D6C9}"=>"\u03B8".freeze, "\u{1D6CA}"=>"\u03B9".freeze, "\u{1D6CB}"=>"\u03BA".freeze,
    "\u{1D6CC}"=>"\u03BB".freeze, "\u{1D6CD}"=>"\u03BC".freeze, "\u{1D6CE}"=>"\u03BD".freeze, "\u{1D6CF}"=>"\u03BE".freeze, "\u{1D6D0}"=>"\u03BF".freeze, "\u{1D6D1}"=>"\u03C0".freeze, "\u{1D6D2}"=>"\u03C1".freeze, "\u{1D6D3}"=>"\u03C2".freeze,
    "\u{1D6D4}"=>"\u03C3".freeze, "\u{1D6D5}"=>"\u03C4".freeze, "\u{1D6D6}"=>"\u03C5".freeze, "\u{1D6D7}"=>"\u03C6".freeze, "\u{1D6D8}"=>"\u03C7".freeze, "\u{1D6D9}"=>"\u03C8".freeze, "\u{1D6DA}"=>"\u03C9".freeze, "\u{1D6DB}"=>"\u2202".freeze,
    "\u{1D6DC}"=>"\u03B5".freeze, "\u{1D6DD}"=>"\u03B8".freeze, "\u{1D6DE}"=>"\u03BA".freeze, "\u{1D6DF}"=>"\u03C6".freeze, "\u{1D6E0}"=>"\u03C1".freeze, "\u{1D6E1}"=>"\u03C0".freeze, "\u{1D6E2}"=>"\u0391".freeze, "\u{1D6E3}"=>"\u0392".freeze,
    "\u{1D6E4}"=>"\u0393".freeze, "\u{1D6E5}"=>"\u0394".freeze, "\u{1D6E6}"=>"\u0395".freeze, "\u{1D6E7}"=>"\u0396".freeze, "\u{1D6E8}"=>"\u0397".freeze, "\u{1D6E9}"=>"\u0398".freeze, "\u{1D6EA}"=>"\u0399".freeze, "\u{1D6EB}"=>"\u039A".freeze,
    "\u{1D6EC}"=>"\u039B".freeze, "\u{1D6ED}"=>"\u039C".freeze, "\u{1D6EE}"=>"\u039D".freeze, "\u{1D6EF}"=>"\u039E".freeze, "\u{1D6F0}"=>"\u039F".freeze, "\u{1D6F1}"=>"\u03A0".freeze, "\u{1D6F2}"=>"\u03A1".freeze, "\u{1D6F3}"=>"\u0398".freeze,
    "\u{1D6F4}"=>"\u03A3".freeze, "\u{1D6F5}"=>"\u03A4".freeze, "\u{1D6F6}"=>"\u03A5".freeze, "\u{1D6F7}"=>"\u03A6".freeze, "\u{1D6F8}"=>"\u03A7".freeze, "\u{1D6F9}"=>"\u03A8".freeze, "\u{1D6FA}"=>"\u03A9".freeze, "\u{1D6FB}"=>"\u2207".freeze,
    "\u{1D6FC}"=>"\u03B1".freeze, "\u{1D6FD}"=>"\u03B2".freeze, "\u{1D6FE}"=>"\u03B3".freeze, "\u{1D6FF}"=>"\u03B4".freeze, "\u{1D700}"=>"\u03B5".freeze, "\u{1D701}"=>"\u03B6".freeze, "\u{1D702}"=>"\u03B7".freeze, "\u{1D703}"=>"\u03B8".freeze,
    "\u{1D704}"=>"\u03B9".freeze, "\u{1D705}"=>"\u03BA".freeze, "\u{1D706}"=>"\u03BB".freeze, "\u{1D707}"=>"\u03BC".freeze, "\u{1D708}"=>"\u03BD".freeze, "\u{1D709}"=>"\u03BE".freeze, "\u{1D70A}"=>"\u03BF".freeze, "\u{1D70B}"=>"\u03C0".freeze,
    "\u{1D70C}"=>"\u03C1".freeze, "\u{1D70D}"=>"\u03C2".freeze, "\u{1D70E}"=>"\u03C3".freeze, "\u{1D70F}"=>"\u03C4".freeze, "\u{1D710}"=>"\u03C5".freeze, "\u{1D711}"=>"\u03C6".freeze, "\u{1D712}"=>"\u03C7".freeze, "\u{1D713}"=>"\u03C8".freeze,
    "\u{1D714}"=>"\u03C9".freeze, "\u{1D715}"=>"\u2202".freeze, "\u{1D716}"=>"\u03B5".freeze, "\u{1D717}"=>"\u03B8".freeze, "\u{1D718}"=>"\u03BA".freeze, "\u{1D719}"=>"\u03C6".freeze, "\u{1D71A}"=>"\u03C1".freeze, "\u{1D71B}"=>"\u03C0".freeze,
    "\u{1D71C}"=>"\u0391".freeze, "\u{1D71D}"=>"\u0392".freeze, "\u{1D71E}"=>"\u0393".freeze, "\u{1D71F}"=>"\u0394".freeze, "\u{1D720}"=>"\u0395".freeze, "\u{1D721}"=>"\u0396".freeze, "\u{1D722}"=>"\u0397".freeze, "\u{1D723}"=>"\u0398".freeze,
    "\u{1D724}"=>"\u0399".freeze, "\u{1D725}"=>"\u039A".freeze, "\u{1D726}"=>"\u039B".freeze, "\u{1D727}"=>"\u039C".freeze, "\u{1D728}"=>"\u039D".freeze, "\u{1D729}"=>"\u039E".freeze, "\u{1D72A}"=>"\u039F".freeze, "\u{1D72B}"=>"\u03A0".freeze,
    "\u{1D72C}"=>"\u03A1".freeze, "\u{1D72D}"=>"\u0398".freeze, "\u{1D72E}"=>"\u03A3".freeze, "\u{1D72F}"=>"\u03A4".freeze, "\u{1D730}"=>"\u03A5".freeze, "\u{1D731}"=>"\u03A6".freeze, "\u{1D732}"=>"\u03A7".freeze, "\u{1D733}"=>"\u03A8".freeze,
    "\u{1D734}"=>"\u03A9".freeze, "\u{1D735}"=>"\u2207".freeze, "\u{1D736}"=>"\u03B1".freeze, "\u{1D737}"=>"\u03B2".freeze, "\u{1D738}"=>"\u03B3".freeze, "\u{1D739}"=>"\u03B4".freeze, "\u{1D73A}"=>"\u03B5".freeze, "\u{1D73B}"=>"\u03B6".freeze,
    "\u{1D73C}"=>"\u03B7".freeze, "\u{1D73D}"=>"\u03B8".freeze, "\u{1D73E}"=>"\u03B9".freeze, "\u{1D73F}"=>"\u03BA".freeze, "\u{1D740}"=>"\u03BB".freeze, "\u{1D741}"=>"\u03BC".freeze, "\u{1D742}"=>"\u03BD".freeze, "\u{1D743}"=>"\u03BE".freeze,
    "\u{1D744}"=>"\u03BF".freeze, "\u{1D745}"=>"\u03C0".freeze, "\u{1D746}"=>"\u03C1".freeze, "\u{1D747}"=>"\u03C2".freeze, "\u{1D748}"=>"\u03C3".freeze, "\u{1D749}"=>"\u03C4".freeze, "\u{1D74A}"=>"\u03C5".freeze, "\u{1D74B}"=>"\u03C6".freeze,
    "\u{1D74C}"=>"\u03C7".freeze, "\u{1D74D}"=>"\u03C8".freeze, "\u{1D74E}"=>"\u03C9".freeze, "\u{1D74F}"=>"\u2202".freeze, "\u{1D750}"=>"\u03B5".freeze, "\u{1D751}"=>"\u03B8".freeze, "\u{1D752}"=>"\u03BA".freeze, "\u{1D753}"=>"\u03C6".freeze,
    "\u{1D754}"=>"\u03C1".freeze, "\u{1D755}"=>"\u03C0".freeze, "\u{1D756}"=>"\u0391".freeze, "\u{1D757}"=>"\u0392".freeze, "\u{1D758}"=>"\u0393".freeze, "\u{1D759}"=>"\u0394".freeze, "\u{1D75A}"=>"\u0395".freeze, "\u{1D75B}"=>"\u0396".freeze,
    "\u{1D75C}"=>"\u0397".freeze, "\u{1D75D}"=>"\u0398".freeze, "\u{1D75E}"=>"\u0399".freeze, "\u{1D75F}"=>"\u039A".freeze, "\u{1D760}"=>"\u039B".freeze, "\u{1D761}"=>"\u039C".freeze, "\u{1D762}"=>"\u039D".freeze, "\u{1D763}"=>"\u039E".freeze,
    "\u{1D764}"=>"\u039F".freeze, "\u{1D765}"=>"\u03A0".freeze, "\u{1D766}"=>"\u03A1".freeze, "\u{1D767}"=>"\u0398".freeze, "\u{1D768}"=>"\u03A3".freeze, "\u{1D769}"=>"\u03A4".freeze, "\u{1D76A}"=>"\u03A5".freeze, "\u{1D76B}"=>"\u03A6".freeze,
    "\u{1D76C}"=>"\u03A7".freeze, "\u{1D76D}"=>"\u03A8".freeze, "\u{1D76E}"=>"\u03A9".freeze, "\u{1D76F}"=>"\u2207".freeze, "\u{1D770}"=>"\u03B1".freeze, "\u{1D771}"=>"\u03B2".freeze, "\u{1D772}"=>"\u03B3".freeze, "\u{1D773}"=>"\u03B4".freeze,
    "\u{1D774}"=>"\u03B5".freeze, "\u{1D775}"=>"\u03B6".freeze, "\u{1D776}"=>"\u03B7".freeze, "\u{1D777}"=>"\u03B8".freeze, "\u{1D778}"=>"\u03B9".freeze, "\u{1D779}"=>"\u03BA".freeze, "\u{1D77A}"=>"\u03BB".freeze, "\u{1D77B}"=>"\u03BC".freeze,
    "\u{1D77C}"=>"\u03BD".freeze, "\u{1D77D}"=>"\u03BE".freeze, "\u{1D77E}"=>"\u03BF".freeze, "\u{1D77F}"=>"\u03C0".freeze, "\u{1D780}"=>"\u03C1".freeze, "\u{1D781}"=>"\u03C2".freeze, "\u{1D782}"=>"\u03C3".freeze, "\u{1D783}"=>"\u03C4".freeze,
    "\u{1D784}"=>"\u03C5".freeze, "\u{1D785}"=>"\u03C6".freeze, "\u{1D786}"=>"\u03C7".freeze, "\u{1D787}"=>"\u03C8".freeze, "\u{1D788}"=>"\u03C9".freeze, "\u{1D789}"=>"\u2202".freeze, "\u{1D78A}"=>"\u03B5".freeze, "\u{1D78B}"=>"\u03B8".freeze,
    "\u{1D78C}"=>"\u03BA".freeze, "\u{1D78D}"=>"\u03C6".freeze, "\u{1D78E}"=>"\u03C1".freeze, "\u{1D78F}"=>"\u03C0".freeze, "\u{1D790}"=>"\u0391".freeze, "\u{1D791}"=>"\u0392".freeze, "\u{1D792}"=>"\u0393".freeze, "\u{1D793}"=>"\u0394".freeze,
    "\u{1D794}"=>"\u0395".freeze, "\u{1D795}"=>"\u0396".freeze, "\u{1D796}"=>"\u0397".freeze, "\u{1D797}"=>"\u0398".freeze, "\u{1D798}"=>"\u0399".freeze, "\u{1D799}"=>"\u039A".freeze, "\u{1D79A}"=>"\u039B".freeze, "\u{1D79B}"=>"\u039C".freeze,
    "\u{1D79C}"=>"\u039D".freeze, "\u{1D79D}"=>"\u039E".freeze, "\u{1D79E}"=>"\u039F".freeze, "\u{1D79F}"=>"\u03A0".freeze, "\u{1D7A0}"=>"\u03A1".freeze, "\u{1D7A1}"=>"\u0398".freeze, "\u{1D7A2}"=>"\u03A3".freeze, "\u{1D7A3}"=>"\u03A4".freeze,
    "\u{1D7A4}"=>"\u03A5".freeze, "\u{1D7A5}"=>"\u03A6".freeze, "\u{1D7A6}"=>"\u03A7".freeze, "\u{1D7A7}"=>"\u03A8".freeze, "\u{1D7A8}"=>"\u03A9".freeze, "\u{1D7A9}"=>"\u2207".freeze, "\u{1D7AA}"=>"\u03B1".freeze, "\u{1D7AB}"=>"\u03B2".freeze,
    "\u{1D7AC}"=>"\u03B3".freeze, "\u{1D7AD}"=>"\u03B4".freeze, "\u{1D7AE}"=>"\u03B5".freeze, "\u{1D7AF}"=>"\u03B6".freeze, "\u{1D7B0}"=>"\u03B7".freeze, "\u{1D7B1}"=>"\u03B8".freeze, "\u{1D7B2}"=>"\u03B9".freeze, "\u{1D7B3}"=>"\u03BA".freeze,
    "\u{1D7B4}"=>"\u03BB".freeze, "\u{1D7B5}"=>"\u03BC".freeze, "\u{1D7B6}"=>"\u03BD".freeze, "\u{1D7B7}"=>"\u03BE".freeze, "\u{1D7B8}"=>"\u03BF".freeze, "\u{1D7B9}"=>"\u03C0".freeze, "\u{1D7BA}"=>"\u03C1".freeze, "\u{1D7BB}"=>"\u03C2".freeze,
    "\u{1D7BC}"=>"\u03C3".freeze, "\u{1D7BD}"=>"\u03C4".freeze, "\u{1D7BE}"=>"\u03C5".freeze, "\u{1D7BF}"=>"\u03C6".freeze, "\u{1D7C0}"=>"\u03C7".freeze, "\u{1D7C1}"=>"\u03C8".freeze, "\u{1D7C2}"=>"\u03C9".freeze, "\u{1D7C3}"=>"\u2202".freeze,
    "\u{1D7C4}"=>"\u03B5".freeze, "\u{1D7C5}"=>"\u03B8".freeze, "\u{1D7C6}"=>"\u03BA".freeze, "\u{1D7C7}"=>"\u03C6".freeze, "\u{1D7C8}"=>"\u03C1".freeze, "\u{1D7C9}"=>"\u03C0".freeze, "\u{1D7CA}"=>"\u03DC".freeze, "\u{1D7CB}"=>"\u03DD".freeze,
    "\u{1D7CE}"=>"0".freeze, "\u{1D7CF}"=>"1".freeze, "\u{1D7D0}"=>"2".freeze, "\u{1D7D1}"=>"3".freeze, "\u{1D7D2}"=>"4".freeze, "\u{1D7D3}"=>"5".freeze, "\u{1D7D4}"=>"6".freeze, "\u{1D7D5}"=>"7".freeze,
    "\u{1D7D6}"=>"8".freeze, "\u{1D7D7}"=>"9".freeze, "\u{1D7D8}"=>"0".freeze, "\u{1D7D9}"=>"1".freeze, "\u{1D7DA}"=>"2".freeze, "\u{1D7DB}"=>"3".freeze, "\u{1D7DC}"=>"4".freeze, "\u{1D7DD}"=>"5".freeze,
    "\u{1D7DE}"=>"6".freeze, "\u{1D7DF}"=>"7".freeze, "\u{1D7E0}"=>"8".freeze, "\u{1D7E1}"=>"9".freeze, "\u{1D7E2}"=>"0".freeze, "\u{1D7E3}"=>"1".freeze, "\u{1D7E4}"=>"2".freeze, "\u{1D7E5}"=>"3".freeze,
    "\u{1D7E6}"=>"4".freeze, "\u{1D7E7}"=>"5".freeze, "\u{1D7E8}"=>"6".freeze, "\u{1D7E9}"=>"7".freeze, "\u{1D7EA}"=>"8".freeze, "\u{1D7EB}"=>"9".freeze, "\u{1D7EC}"=>"0".freeze, "\u{1D7ED}"=>"1".freeze,
    "\u{1D7EE}"=>"2".freeze, "\u{1D7EF}"=>"3".freeze, "\u{1D7F0}"=>"4".freeze, "\u{1D7F1}"=>"5".freeze, "\u{1D7F2}"=>"6".freeze, "\u{1D7F3}"=>"7".freeze, "\u{1D7F4}"=>"8".freeze, "\u{1D7F5}"=>"9".freeze,
    "\u{1D7F6}"=>"0".freeze, "\u{1D7F7}"=>"1".freeze, "\u{1D7F8}"=>"2".freeze, "\u{1D7F9}"=>"3".freeze, "\u{1D7FA}"=>"4".freeze, "\u{1D7FB}"=>"5".freeze, "\u{1D7FC}"=>"6".freeze, "\u{1D7FD}"=>"7".freeze,
    "\u{1D7FE}"=>"8".freeze, "\u{1D7FF}"=>"9".freeze, "\u{1EE00}"=>"\u0627".freeze, "\u{1EE01}"=>"\u0628".freeze, "\u{1EE02}"=>"\u062C".freeze, "\u{1EE03}"=>"\u062F".freeze, "\u{1EE05}"=>"\u0648".freeze, "\u{1EE06}"=>"\u0632".freeze,
    "\u{1EE07}"=>"\u062D".freeze, "\u{1EE08}"=>"\u0637".freeze, "\u{1EE09}"=>"\u064A".freeze, "\u{1EE0A}"=>"\u0643".freeze, "\u{1EE0B}"=>"\u0644".freeze, "\u{1EE0C}"=>"\u0645".freeze, "\u{1EE0D}"=>"\u0646".freeze, "\u{1EE0E}"=>"\u0633".freeze,
    "\u{1EE0F}"=>"\u0639".freeze, "\u{1EE10}"=>"\u0641".freeze, "\u{1EE11}"=>"\u0635".freeze, "\u{1EE12}"=>"\u0642".freeze, "\u{1EE13}"=>"\u0631".freeze, "\u{1EE14}"=>"\u0634".freeze, "\u{1EE15}"=>"\u062A".freeze, "\u{1EE16}"=>"\u062B".freeze,
    "\u{1EE17}"=>"\u062E".freeze, "\u{1EE18}"=>"\u0630".freeze, "\u{1EE19}"=>"\u0636".freeze, "\u{1EE1A}"=>"\u0638".freeze, "\u{1EE1B}"=>"\u063A".freeze, "\u{1EE1C}"=>"\u066E".freeze, "\u{1EE1D}"=>"\u06BA".freeze, "\u{1EE1E}"=>"\u06A1".freeze,
    "\u{1EE1F}"=>"\u066F".freeze, "\u{1EE21}"=>"\u0628".freeze, "\u{1EE22}"=>"\u062C".freeze, "\u{1EE24}"=>"\u0647".freeze, "\u{1EE27}"=>"\u062D".freeze, "\u{1EE29}"=>"\u064A".freeze, "\u{1EE2A}"=>"\u0643".freeze, "\u{1EE2B}"=>"\u0644".freeze,
    "\u{1EE2C}"=>"\u0645".freeze, "\u{1EE2D}"=>"\u0646".freeze, "\u{1EE2E}"=>"\u0633".freeze, "\u{1EE2F}"=>"\u0639".freeze, "\u{1EE30}"=>"\u0641".freeze, "\u{1EE31}"=>"\u0635".freeze, "\u{1EE32}"=>"\u0642".freeze, "\u{1EE34}"=>"\u0634".freeze,
    "\u{1EE35}"=>"\u062A".freeze, "\u{1EE36}"=>"\u062B".freeze, "\u{1EE37}"=>"\u062E".freeze, "\u{1EE39}"=>"\u0636".freeze, "\u{1EE3B}"=>"\u063A".freeze, "\u{1EE42}"=>"\u062C".freeze, "\u{1EE47}"=>"\u062D".freeze, "\u{1EE49}"=>"\u064A".freeze,
    "\u{1EE4B}"=>"\u0644".freeze, "\u{1EE4D}"=>"\u0646".freeze, "\u{1EE4E}"=>"\u0633".freeze, "\u{1EE4F}"=>"\u0639".freeze, "\u{1EE51}"=>"\u0635".freeze, "\u{1EE52}"=>"\u0642".freeze, "\u{1EE54}"=>"\u0634".freeze, "\u{1EE57}"=>"\u062E".freeze,
    "\u{1EE59}"=>"\u0636".freeze, "\u{1EE5B}"=>"\u063A".freeze, "\u{1EE5D}"=>"\u06BA".freeze, "\u{1EE5F}"=>"\u066F".freeze, "\u{1EE61}"=>"\u0628".freeze, "\u{1EE62}"=>"\u062C".freeze, "\u{1EE64}"=>"\u0647".freeze, "\u{1EE67}"=>"\u062D".freeze,
    "\u{1EE68}"=>"\u0637".freeze, "\u{1EE69}"=>"\u064A".freeze, "\u{1EE6A}"=>"\u0643".freeze, "\u{1EE6C}"=>"\u0645".freeze, "\u{1EE6D}"=>"\u0646".freeze, "\u{1EE6E}"=>"\u0633".freeze, "\u{1EE6F}"=>"\u0639".freeze, "\u{1EE70}"=>"\u0641".freeze,
    "\u{1EE71}"=>"\u0635".freeze, "\u{1EE72}"=>"\u0642".freeze, "\u{1EE74}"=>"\u0634".freeze, "\u{1EE75}"=>"\u062A".freeze, "\u{1EE76}"=>"\u062B".freeze, "\u{1EE77}"=>"\u062E".freeze, "\u{1EE79}"=>"\u0636".freeze, "\u{1EE7A}"=>"\u0638".freeze,
    "\u{1EE7B}"=>"\u063A".freeze, "\u{1EE7C}"=>"\u066E".freeze, "\u{1EE7E}"=>"\u06A1".freeze, "\u{1EE80}"=>"\u0627".freeze, "\u{1EE81}"=>"\u0628".freeze, "\u{1EE82}"=>"\u062C".freeze, "\u{1EE83}"=>"\u062F".freeze, "\u{1EE84}"=>"\u0647".freeze,
    "\u{1EE85}"=>"\u0648".freeze, "\u{1EE86}"=>"\u0632".freeze, "\u{1EE87}"=>"\u062D".freeze, "\u{1EE88}"=>"\u0637".freeze, "\u{1EE89}"=>"\u064A".freeze, "\u{1EE8B}"=>"\u0644".freeze, "\u{1EE8C}"=>"\u0645".freeze, "\u{1EE8D}"=>"\u0646".freeze,
    "\u{1EE8E}"=>"\u0633".freeze, "\u{1EE8F}"=>"\u0639".freeze, "\u{1EE90}"=>"\u0641".freeze, "\u{1EE91}"=>"\u0635".freeze, "\u{1EE92}"=>"\u0642".freeze, "\u{1EE93}"=>"\u0631".freeze, "\u{1EE94}"=>"\u0634".freeze, "\u{1EE95}"=>"\u062A".freeze,
    "\u{1EE96}"=>"\u062B".freeze, "\u{1EE97}"=>"\u062E".freeze, "\u{1EE98}"=>"\u0630".freeze, "\u{1EE99}"=>"\u0636".freeze, "\u{1EE9A}"=>"\u0638".freeze, "\u{1EE9B}"=>"\u063A".freeze, "\u{1EEA1}"=>"\u0628".freeze, "\u{1EEA2}"=>"\u062C".freeze,
    "\u{1EEA3}"=>"\u062F".freeze, "\u{1EEA5}"=>"\u0648".freeze, "\u{1EEA6}"=>"\u0632".freeze, "\u{1EEA7}"=>"\u062D".freeze, "\u{1EEA8}"=>"\u0637".freeze, "\u{1EEA9}"=>"\u064A".freeze, "\u{1EEAB}"=>"\u0644".freeze, "\u{1EEAC}"=>"\u0645".freeze,
    "\u{1EEAD}"=>"\u0646".freeze, "\u{1EEAE}"=>"\u0633".freeze, "\u{1EEAF}"=>"\u0639".freeze, "\u{1EEB0}"=>"\u0641".freeze, "\u{1EEB1}"=>"\u0635".freeze, "\u{1EEB2}"=>"\u0642".freeze, "\u{1EEB3}"=>"\u0631".freeze, "\u{1EEB4}"=>"\u0634".freeze,
    "\u{1EEB5}"=>"\u062A".freeze, "\u{1EEB6}"=>"\u062B".freeze, "\u{1EEB7}"=>"\u062E".freeze, "\u{1EEB8}"=>"\u0630".freeze, "\u{1EEB9}"=>"\u0636".freeze, "\u{1EEBA}"=>"\u0638".freeze, "\u{1EEBB}"=>"\u063A".freeze, "\u{1F100}"=>"0.".freeze,
    "\u{1F101}"=>"0,".freeze, "\u{1F102}"=>"1,".freeze, "\u{1F103}"=>"2,".freeze, "\u{1F104}"=>"3,".freeze, "\u{1F105}"=>"4,".freeze, "\u{1F106}"=>"5,".freeze, "\u{1F107}"=>"6,".freeze, "\u{1F108}"=>"7,".freeze,
    "\u{1F109}"=>"8,".freeze, "\u{1F10A}"=>"9,".freeze, "\u{1F110}"=>"(A)".freeze, "\u{1F111}"=>"(B)".freeze, "\u{1F112}"=>"(C)".freeze, "\u{1F113}"=>"(D)".freeze, "\u{1F114}"=>"(E)".freeze, "\u{1F115}"=>"(F)".freeze,
    "\u{1F116}"=>"(G)".freeze, "\u{1F117}"=>"(H)".freeze, "\u{1F118}"=>"(I)".freeze, "\u{1F119}"=>"(J)".freeze, "\u{1F11A}"=>"(K)".freeze, "\u{1F11B}"=>"(L)".freeze, "\u{1F11C}"=>"(M)".freeze, "\u{1F11D}"=>"(N)".freeze,
    "\u{1F11E}"=>"(O)".freeze, "\u{1F11F}"=>"(P)".freeze, "\u{1F120}"=>"(Q)".freeze, "\u{1F121}"=>"(R)".freeze, "\u{1F122}"=>"(S)".freeze, "\u{1F123}"=>"(T)".freeze, "\u{1F124}"=>"(U)".freeze, "\u{1F125}"=>"(V)".freeze,
    "\u{1F126}"=>"(W)".freeze, "\u{1F127}"=>"(X)".freeze, "\u{1F128}"=>"(Y)".freeze, "\u{1F129}"=>"(Z)".freeze, "\u{1F12A}"=>"\u3014S\u3015".freeze, "\u{1F12B}"=>"C".freeze, "\u{1F12C}"=>"R".freeze, "\u{1F12D}"=>"CD".freeze,
    "\u{1F12E}"=>"WZ".freeze, "\u{1F130}"=>"A".freeze, "\u{1F131}"=>"B".freeze, "\u{1F132}"=>"C".freeze, "\u{1F133}"=>"D".freeze, "\u{1F134}"=>"E".freeze, "\u{1F135}"=>"F".freeze, "\u{1F136}"=>"G".freeze,
    "\u{1F137}"=>"H".freeze, "\u{1F138}"=>"I".freeze, "\u{1F139}"=>"J".freeze, "\u{1F13A}"=>"K".freeze, "\u{1F13B}"=>"L".freeze, "\u{1F13C}"=>"M".freeze, "\u{1F13D}"=>"N".freeze, "\u{1F13E}"=>"O".freeze,
    "\u{1F13F}"=>"P".freeze, "\u{1F140}"=>"Q".freeze, "\u{1F141}"=>"R".freeze, "\u{1F142}"=>"S".freeze, "\u{1F143}"=>"T".freeze, "\u{1F144}"=>"U".freeze, "\u{1F145}"=>"V".freeze, "\u{1F146}"=>"W".freeze,
    "\u{1F147}"=>"X".freeze, "\u{1F148}"=>"Y".freeze, "\u{1F149}"=>"Z".freeze, "\u{1F14A}"=>"HV".freeze, "\u{1F14B}"=>"MV".freeze, "\u{1F14C}"=>"SD".freeze, "\u{1F14D}"=>"SS".freeze, "\u{1F14E}"=>"PPV".freeze,
    "\u{1F14F}"=>"WC".freeze, "\u{1F16A}"=>"MC".freeze, "\u{1F16B}"=>"MD".freeze, "\u{1F190}"=>"DJ".freeze, "\u{1F200}"=>"\u307B\u304B".freeze, "\u{1F201}"=>"\u30B3\u30B3".freeze, "\u{1F202}"=>"\u30B5".freeze, "\u{1F210}"=>"\u624B".freeze,
    "\u{1F211}"=>"\u5B57".freeze, "\u{1F212}"=>"\u53CC".freeze, "\u{1F213}"=>"\u30C7".freeze, "\u{1F214}"=>"\u4E8C".freeze, "\u{1F215}"=>"\u591A".freeze, "\u{1F216}"=>"\u89E3".freeze, "\u{1F217}"=>"\u5929".freeze, "\u{1F218}"=>"\u4EA4".freeze,
    "\u{1F219}"=>"\u6620".freeze, "\u{1F21A}"=>"\u7121".freeze, "\u{1F21B}"=>"\u6599".freeze, "\u{1F21C}"=>"\u524D".freeze, "\u{1F21D}"=>"\u5F8C".freeze, "\u{1F21E}"=>"\u518D".freeze, "\u{1F21F}"=>"\u65B0".freeze, "\u{1F220}"=>"\u521D".freeze,
    "\u{1F221}"=>"\u7D42".freeze, "\u{1F222}"=>"\u751F".freeze, "\u{1F223}"=>"\u8CA9".freeze, "\u{1F224}"=>"\u58F0".freeze, "\u{1F225}"=>"\u5439".freeze, "\u{1F226}"=>"\u6F14".freeze, "\u{1F227}"=>"\u6295".freeze, "\u{1F228}"=>"\u6355".freeze,
    "\u{1F229}"=>"\u4E00".freeze, "\u{1F22A}"=>"\u4E09".freeze, "\u{1F22B}"=>"\u904A".freeze, "\u{1F22C}"=>"\u5DE6".freeze, "\u{1F22D}"=>"\u4E2D".freeze, "\u{1F22E}"=>"\u53F3".freeze, "\u{1F22F}"=>"\u6307".freeze, "\u{1F230}"=>"\u8D70".freeze,
    "\u{1F231}"=>"\u6253".freeze, "\u{1F232}"=>"\u7981".freeze, "\u{1F233}"=>"\u7A7A".freeze, "\u{1F234}"=>"\u5408".freeze, "\u{1F235}"=>"\u6E80".freeze, "\u{1F236}"=>"\u6709".freeze, "\u{1F237}"=>"\u6708".freeze, "\u{1F238}"=>"\u7533".freeze,
    "\u{1F239}"=>"\u5272".freeze, "\u{1F23A}"=>"\u55B6".freeze, "\u{1F240}"=>"\u3014\u672C\u3015".freeze, "\u{1F241}"=>"\u3014\u4E09\u3015".freeze, "\u{1F242}"=>"\u3014\u4E8C\u3015".freeze, "\u{1F243}"=>"\u3014\u5B89\u3015".freeze, "\u{1F244}"=>"\u3014\u70B9\u3015".freeze, "\u{1F245}"=>"\u3014\u6253\u3015".freeze,
    "\u{1F246}"=>"\u3014\u76D7\u3015".freeze, "\u{1F247}"=>"\u3014\u52DD\u3015".freeze, "\u{1F248}"=>"\u3014\u6557\u3015".freeze, "\u{1F250}"=>"\u5F97".freeze, "\u{1F251}"=>"\u53EF".freeze, "\u0385"=>" \u0308\u0301".freeze, "\u03D3"=>"\u03A5\u0301".freeze, "\u03D4"=>"\u03A5\u0308".freeze,
    "\u1E9B"=>"s\u0307".freeze, "\u1FC1"=>" \u0308\u0342".freeze, "\u1FCD"=>" \u0313\u0300".freeze, "\u1FCE"=>" \u0313\u0301".freeze, "\u1FCF"=>" \u0313\u0342".freeze, "\u1FDD"=>" \u0314\u0300".freeze, "\u1FDE"=>" \u0314\u0301".freeze, "\u1FDF"=>" \u0314\u0342".freeze,
    "\u1FED"=>" \u0308\u0300".freeze, "\u1FEE"=>" \u0308\u0301".freeze, "\u1FFD"=>" \u0301".freeze, "\u2000"=>" ".freeze, "\u2001"=>" ".freeze,
  }.freeze

  COMPOSITION_TABLE = {
    "A\u0300"=>"\u00C0".freeze, "A\u0301"=>"\u00C1".freeze, "A\u0302"=>"\u00C2".freeze, "A\u0303"=>"\u00C3".freeze, "A\u0308"=>"\u00C4".freeze, "A\u030A"=>"\u00C5".freeze, "C\u0327"=>"\u00C7".freeze, "E\u0300"=>"\u00C8".freeze,
    "E\u0301"=>"\u00C9".freeze, "E\u0302"=>"\u00CA".freeze, "E\u0308"=>"\u00CB".freeze, "I\u0300"=>"\u00CC".freeze, "I\u0301"=>"\u00CD".freeze, "I\u0302"=>"\u00CE".freeze, "I\u0308"=>"\u00CF".freeze, "N\u0303"=>"\u00D1".freeze,
    "O\u0300"=>"\u00D2".freeze, "O\u0301"=>"\u00D3".freeze, "O\u0302"=>"\u00D4".freeze, "O\u0303"=>"\u00D5".freeze, "O\u0308"=>"\u00D6".freeze, "U\u0300"=>"\u00D9".freeze, "U\u0301"=>"\u00DA".freeze, "U\u0302"=>"\u00DB".freeze,
    "U\u0308"=>"\u00DC".freeze, "Y\u0301"=>"\u00DD".freeze, "a\u0300"=>"\u00E0".freeze, "a\u0301"=>"\u00E1".freeze, "a\u0302"=>"\u00E2".freeze, "a\u0303"=>"\u00E3".freeze, "a\u0308"=>"\u00E4".freeze, "a\u030A"=>"\u00E5".freeze,
    "c\u0327"=>"\u00E7".freeze, "e\u0300"=>"\u00E8".freeze, "e\u0301"=>"\u00E9".freeze, "e\u0302"=>"\u00EA".freeze, "e\u0308"=>"\u00EB".freeze, "i\u0300"=>"\u00EC".freeze, "i\u0301"=>"\u00ED".freeze, "i\u0302"=>"\u00EE".freeze,
    "i\u0308"=>"\u00EF".freeze, "n\u0303"=>"\u00F1".freeze, "o\u0300"=>"\u00F2".freeze, "o\u0301"=>"\u00F3".freeze, "o\u0302"=>"\u00F4".freeze, "o\u0303"=>"\u00F5".freeze, "o\u0308"=>"\u00F6".freeze, "u\u0300"=>"\u00F9".freeze,
    "u\u0301"=>"\u00FA".freeze, "u\u0302"=>"\u00FB".freeze, "u\u0308"=>"\u00FC".freeze, "y\u0301"=>"\u00FD".freeze, "y\u0308"=>"\u00FF".freeze, "A\u0304"=>"\u0100".freeze, "a\u0304"=>"\u0101".freeze, "A\u0306"=>"\u0102".freeze,
    "a\u0306"=>"\u0103".freeze, "A\u0328"=>"\u0104".freeze, "a\u0328"=>"\u0105".freeze, "C\u0301"=>"\u0106".freeze, "c\u0301"=>"\u0107".freeze, "C\u0302"=>"\u0108".freeze, "c\u0302"=>"\u0109".freeze, "C\u0307"=>"\u010A".freeze,
    "c\u0307"=>"\u010B".freeze, "C\u030C"=>"\u010C".freeze, "c\u030C"=>"\u010D".freeze, "D\u030C"=>"\u010E".freeze, "d\u030C"=>"\u010F".freeze, "E\u0304"=>"\u0112".freeze, "e\u0304"=>"\u0113".freeze, "E\u0306"=>"\u0114".freeze,
    "e\u0306"=>"\u0115".freeze, "E\u0307"=>"\u0116".freeze, "e\u0307"=>"\u0117".freeze, "E\u0328"=>"\u0118".freeze, "e\u0328"=>"\u0119".freeze, "E\u030C"=>"\u011A".freeze, "e\u030C"=>"\u011B".freeze, "G\u0302"=>"\u011C".freeze,
    "g\u0302"=>"\u011D".freeze, "G\u0306"=>"\u011E".freeze, "g\u0306"=>"\u011F".freeze, "G\u0307"=>"\u0120".freeze, "g\u0307"=>"\u0121".freeze, "G\u0327"=>"\u0122".freeze, "g\u0327"=>"\u0123".freeze, "H\u0302"=>"\u0124".freeze,
    "h\u0302"=>"\u0125".freeze, "I\u0303"=>"\u0128".freeze, "i\u0303"=>"\u0129".freeze, "I\u0304"=>"\u012A".freeze, "i\u0304"=>"\u012B".freeze, "I\u0306"=>"\u012C".freeze, "i\u0306"=>"\u012D".freeze, "I\u0328"=>"\u012E".freeze,
    "i\u0328"=>"\u012F".freeze, "I\u0307"=>"\u0130".freeze, "J\u0302"=>"\u0134".freeze, "j\u0302"=>"\u0135".freeze, "K\u0327"=>"\u0136".freeze, "k\u0327"=>"\u0137".freeze, "L\u0301"=>"\u0139".freeze, "l\u0301"=>"\u013A".freeze,
    "L\u0327"=>"\u013B".freeze, "l\u0327"=>"\u013C".freeze, "L\u030C"=>"\u013D".freeze, "l\u030C"=>"\u013E".freeze, "N\u0301"=>"\u0143".freeze, "n\u0301"=>"\u0144".freeze, "N\u0327"=>"\u0145".freeze, "n\u0327"=>"\u0146".freeze,
    "N\u030C"=>"\u0147".freeze, "n\u030C"=>"\u0148".freeze, "O\u0304"=>"\u014C".freeze, "o\u0304"=>"\u014D".freeze, "O\u0306"=>"\u014E".freeze, "o\u0306"=>"\u014F".freeze, "O\u030B"=>"\u0150".freeze, "o\u030B"=>"\u0151".freeze,
    "R\u0301"=>"\u0154".freeze, "r\u0301"=>"\u0155".freeze, "R\u0327"=>"\u0156".freeze, "r\u0327"=>"\u0157".freeze, "R\u030C"=>"\u0158".freeze, "r\u030C"=>"\u0159".freeze, "S\u0301"=>"\u015A".freeze, "s\u0301"=>"\u015B".freeze,
    "S\u0302"=>"\u015C".freeze, "s\u0302"=>"\u015D".freeze, "S\u0327"=>"\u015E".freeze, "s\u0327"=>"\u015F".freeze, "S\u030C"=>"\u0160".freeze, "s\u030C"=>"\u0161".freeze, "T\u0327"=>"\u0162".freeze, "t\u0327"=>"\u0163".freeze,
    "T\u030C"=>"\u0164".freeze, "t\u030C"=>"\u0165".freeze, "U\u0303"=>"\u0168".freeze, "u\u0303"=>"\u0169".freeze, "U\u0304"=>"\u016A".freeze, "u\u0304"=>"\u016B".freeze, "U\u0306"=>"\u016C".freeze, "u\u0306"=>"\u016D".freeze,
    "U\u030A"=>"\u016E".freeze, "u\u030A"=>"\u016F".freeze, "U\u030B"=>"\u0170".freeze, "u\u030B"=>"\u0171".freeze, "U\u0328"=>"\u0172".freeze, "u\u0328"=>"\u0173".freeze, "W\u0302"=>"\u0174".freeze, "w\u0302"=>"\u0175".freeze,
    "Y\u0302"=>"\u0176".freeze, "y\u0302"=>"\u0177".freeze, "Y\u0308"=>"\u0178".freeze, "Z\u0301"=>"\u0179".freeze, "z\u0301"=>"\u017A".freeze, "Z\u0307"=>"\u017B".freeze, "z\u0307"=>"\u017C".freeze, "Z\u030C"=>"\u017D".freeze,
    "z\u030C"=>"\u017E".freeze, "O\u031B"=>"\u01A0".freeze, "o\u031B"=>"\u01A1".freeze, "U\u031B"=>"\u01AF".freeze, "u\u031B"=>"\u01B0".freeze, "A\u030C"=>"\u01CD".freeze, "a\u030C"=>"\u01CE".freeze, "I\u030C"=>"\u01CF".freeze,
    "i\u030C"=>"\u01D0".freeze, "O\u030C"=>"\u01D1".freeze, "o\u030C"=>"\u01D2".freeze, "U\u030C"=>"\u01D3".freeze, "u\u030C"=>"\u01D4".freeze, "\u00DC\u0304"=>"\u01D5".freeze, "\u00FC\u0304"=>"\u01D6".freeze, "\u00DC\u0301"=>"\u01D7".freeze,
    "\u00FC\u0301"=>"\u01D8".freeze, "\u00DC\u030C"=>"\u01D9".freeze, "\u00FC\u030C"=>"\u01DA".freeze, "\u00DC\u0300"=>"\u01DB".freeze, "\u00FC\u0300"=>"\u01DC".freeze, "\u00C4\u0304"=>"\u01DE".freeze, "\u00E4\u0304"=>"\u01DF".freeze, "\u0226\u0304"=>"\u01E0".freeze,
    "\u0227\u0304"=>"\u01E1".freeze, "\u00C6\u0304"=>"\u01E2".freeze, "\u00E6\u0304"=>"\u01E3".freeze, "G\u030C"=>"\u01E6".freeze, "g\u030C"=>"\u01E7".freeze, "K\u030C"=>"\u01E8".freeze, "k\u030C"=>"\u01E9".freeze, "O\u0328"=>"\u01EA".freeze,
    "o\u0328"=>"\u01EB".freeze, "\u01EA\u0304"=>"\u01EC".freeze, "\u01EB\u0304"=>"\u01ED".freeze, "\u01B7\u030C"=>"\u01EE".freeze, "\u0292\u030C"=>"\u01EF".freeze, "j\u030C"=>"\u01F0".freeze, "G\u0301"=>"\u01F4".freeze, "g\u0301"=>"\u01F5".freeze,
    "N\u0300"=>"\u01F8".freeze, "n\u0300"=>"\u01F9".freeze, "\u00C5\u0301"=>"\u01FA".freeze, "\u00E5\u0301"=>"\u01FB".freeze, "\u00C6\u0301"=>"\u01FC".freeze, "\u00E6\u0301"=>"\u01FD".freeze, "\u00D8\u0301"=>"\u01FE".freeze, "\u00F8\u0301"=>"\u01FF".freeze,
    "A\u030F"=>"\u0200".freeze, "a\u030F"=>"\u0201".freeze, "A\u0311"=>"\u0202".freeze, "a\u0311"=>"\u0203".freeze, "E\u030F"=>"\u0204".freeze, "e\u030F"=>"\u0205".freeze, "E\u0311"=>"\u0206".freeze, "e\u0311"=>"\u0207".freeze,
    "I\u030F"=>"\u0208".freeze, "i\u030F"=>"\u0209".freeze, "I\u0311"=>"\u020A".freeze, "i\u0311"=>"\u020B".freeze, "O\u030F"=>"\u020C".freeze, "o\u030F"=>"\u020D".freeze, "O\u0311"=>"\u020E".freeze, "o\u0311"=>"\u020F".freeze,
    "R\u030F"=>"\u0210".freeze, "r\u030F"=>"\u0211".freeze, "R\u0311"=>"\u0212".freeze, "r\u0311"=>"\u0213".freeze, "U\u030F"=>"\u0214".freeze, "u\u030F"=>"\u0215".freeze, "U\u0311"=>"\u0216".freeze, "u\u0311"=>"\u0217".freeze,
    "S\u0326"=>"\u0218".freeze, "s\u0326"=>"\u0219".freeze, "T\u0326"=>"\u021A".freeze, "t\u0326"=>"\u021B".freeze, "H\u030C"=>"\u021E".freeze, "h\u030C"=>"\u021F".freeze, "A\u0307"=>"\u0226".freeze, "a\u0307"=>"\u0227".freeze,
    "E\u0327"=>"\u0228".freeze, "e\u0327"=>"\u0229".freeze, "\u00D6\u0304"=>"\u022A".freeze, "\u00F6\u0304"=>"\u022B".freeze, "\u00D5\u0304"=>"\u022C".freeze, "\u00F5\u0304"=>"\u022D".freeze, "O\u0307"=>"\u022E".freeze, "o\u0307"=>"\u022F".freeze,
    "\u022E\u0304"=>"\u0230".freeze, "\u022F\u0304"=>"\u0231".freeze, "Y\u0304"=>"\u0232".freeze, "y\u0304"=>"\u0233".freeze, "\u00A8\u0301"=>"\u0385".freeze, "\u0391\u0301"=>"\u0386".freeze, "\u0395\u0301"=>"\u0388".freeze, "\u0397\u0301"=>"\u0389".freeze,
    "\u0399\u0301"=>"\u038A".freeze, "\u039F\u0301"=>"\u038C".freeze, "\u03A5\u0301"=>"\u038E".freeze, "\u03A9\u0301"=>"\u038F".freeze, "\u03CA\u0301"=>"\u0390".freeze, "\u0399\u0308"=>"\u03AA".freeze, "\u03A5\u0308"=>"\u03AB".freeze, "\u03B1\u0301"=>"\u03AC".freeze,
    "\u03B5\u0301"=>"\u03AD".freeze, "\u03B7\u0301"=>"\u03AE".freeze, "\u03B9\u0301"=>"\u03AF".freeze, "\u03CB\u0301"=>"\u03B0".freeze, "\u03B9\u0308"=>"\u03CA".freeze, "\u03C5\u0308"=>"\u03CB".freeze, "\u03BF\u0301"=>"\u03CC".freeze, "\u03C5\u0301"=>"\u03CD".freeze,
    "\u03C9\u0301"=>"\u03CE".freeze, "\u03D2\u0301"=>"\u03D3".freeze, "\u03D2\u0308"=>"\u03D4".freeze, "\u0415\u0300"=>"\u0400".freeze, "\u0415\u0308"=>"\u0401".freeze, "\u0413\u0301"=>"\u0403".freeze, "\u0406\u0308"=>"\u0407".freeze, "\u041A\u0301"=>"\u040C".freeze,
    "\u0418\u0300"=>"\u040D".freeze, "\u0423\u0306"=>"\u040E".freeze, "\u0418\u0306"=>"\u0419".freeze, "\u0438\u0306"=>"\u0439".freeze, "\u0435\u0300"=>"\u0450".freeze, "\u0435\u0308"=>"\u0451".freeze, "\u0433\u0301"=>"\u0453".freeze, "\u0456\u0308"=>"\u0457".freeze,
    "\u043A\u0301"=>"\u045C".freeze, "\u0438\u0300"=>"\u045D".freeze, "\u0443\u0306"=>"\u045E".freeze, "\u0474\u030F"=>"\u0476".freeze, "\u0475\u030F"=>"\u0477".freeze, "\u0416\u0306"=>"\u04C1".freeze, "\u0436\u0306"=>"\u04C2".freeze, "\u0410\u0306"=>"\u04D0".freeze,
    "\u0430\u0306"=>"\u04D1".freeze, "\u0410\u0308"=>"\u04D2".freeze, "\u0430\u0308"=>"\u04D3".freeze, "\u0415\u0306"=>"\u04D6".freeze, "\u0435\u0306"=>"\u04D7".freeze, "\u04D8\u0308"=>"\u04DA".freeze, "\u04D9\u0308"=>"\u04DB".freeze, "\u0416\u0308"=>"\u04DC".freeze,
    "\u0436\u0308"=>"\u04DD".freeze, "\u0417\u0308"=>"\u04DE".freeze, "\u0437\u0308"=>"\u04DF".freeze, "\u0418\u0304"=>"\u04E2".freeze, "\u0438\u0304"=>"\u04E3".freeze, "\u0418\u0308"=>"\u04E4".freeze, "\u0438\u0308"=>"\u04E5".freeze, "\u041E\u0308"=>"\u04E6".freeze,
    "\u043E\u0308"=>"\u04E7".freeze, "\u04E8\u0308"=>"\u04EA".freeze, "\u04E9\u0308"=>"\u04EB".freeze, "\u042D\u0308"=>"\u04EC".freeze, "\u044D\u0308"=>"\u04ED".freeze, "\u0423\u0304"=>"\u04EE".freeze, "\u0443\u0304"=>"\u04EF".freeze, "\u0423\u0308"=>"\u04F0".freeze,
    "\u0443\u0308"=>"\u04F1".freeze, "\u0423\u030B"=>"\u04F2".freeze, "\u0443\u030B"=>"\u04F3".freeze, "\u0427\u0308"=>"\u04F4".freeze, "\u0447\u0308"=>"\u04F5".freeze, "\u042B\u0308"=>"\u04F8".freeze, "\u044B\u0308"=>"\u04F9".freeze, "\u0627\u0653"=>"\u0622".freeze,
    "\u0627\u0654"=>"\u0623".freeze, "\u0648\u0654"=>"\u0624".freeze, "\u0627\u0655"=>"\u0625".freeze, "\u064A\u0654"=>"\u0626".freeze, "\u06D5\u0654"=>"\u06C0".freeze, "\u06C1\u0654"=>"\u06C2".freeze, "\u06D2\u0654"=>"\u06D3".freeze, "\u0928\u093C"=>"\u0929".freeze,
    "\u0930\u093C"=>"\u0931".freeze, "\u0933\u093C"=>"\u0934".freeze, "\u09C7\u09BE"=>"\u09CB".freeze, "\u09C7\u09D7"=>"\u09CC".freeze, "\u0B47\u0B56"=>"\u0B48".freeze, "\u0B47\u0B3E"=>"\u0B4B".freeze, "\u0B47\u0B57"=>"\u0B4C".freeze, "\u0B92\u0BD7"=>"\u0B94".freeze,
    "\u0BC6\u0BBE"=>"\u0BCA".freeze, "\u0BC7\u0BBE"=>"\u0BCB".freeze, "\u0BC6\u0BD7"=>"\u0BCC".freeze, "\u0C46\u0C56"=>"\u0C48".freeze, "\u0CBF\u0CD5"=>"\u0CC0".freeze, "\u0CC6\u0CD5"=>"\u0CC7".freeze, "\u0CC6\u0CD6"=>"\u0CC8".freeze, "\u0CC6\u0CC2"=>"\u0CCA".freeze,
    "\u0CCA\u0CD5"=>"\u0CCB".freeze, "\u0D46\u0D3E"=>"\u0D4A".freeze, "\u0D47\u0D3E"=>"\u0D4B".freeze, "\u0D46\u0D57"=>"\u0D4C".freeze, "\u0DD9\u0DCA"=>"\u0DDA".freeze, "\u0DD9\u0DCF"=>"\u0DDC".freeze, "\u0DDC\u0DCA"=>"\u0DDD".freeze, "\u0DD9\u0DDF"=>"\u0DDE".freeze,
    "\u1025\u102E"=>"\u1026".freeze, "\u1B05\u1B35"=>"\u1B06".freeze, "\u1B07\u1B35"=>"\u1B08".freeze, "\u1B09\u1B35"=>"\u1B0A".freeze, "\u1B0B\u1B35"=>"\u1B0C".freeze, "\u1B0D\u1B35"=>"\u1B0E".freeze, "\u1B11\u1B35"=>"\u1B12".freeze, "\u1B3A\u1B35"=>"\u1B3B".freeze,
    "\u1B3C\u1B35"=>"\u1B3D".freeze, "\u1B3E\u1B35"=>"\u1B40".freeze, "\u1B3F\u1B35"=>"\u1B41".freeze, "\u1B42\u1B35"=>"\u1B43".freeze, "A\u0325"=>"\u1E00".freeze, "a\u0325"=>"\u1E01".freeze, "B\u0307"=>"\u1E02".freeze, "b\u0307"=>"\u1E03".freeze,
    "B\u0323"=>"\u1E04".freeze, "b\u0323"=>"\u1E05".freeze, "B\u0331"=>"\u1E06".freeze, "b\u0331"=>"\u1E07".freeze, "\u00C7\u0301"=>"\u1E08".freeze, "\u00E7\u0301"=>"\u1E09".freeze, "D\u0307"=>"\u1E0A".freeze, "d\u0307"=>"\u1E0B".freeze,
    "D\u0323"=>"\u1E0C".freeze, "d\u0323"=>"\u1E0D".freeze, "D\u0331"=>"\u1E0E".freeze, "d\u0331"=>"\u1E0F".freeze, "D\u0327"=>"\u1E10".freeze, "d\u0327"=>"\u1E11".freeze, "D\u032D"=>"\u1E12".freeze, "d\u032D"=>"\u1E13".freeze,
    "\u0112\u0300"=>"\u1E14".freeze, "\u0113\u0300"=>"\u1E15".freeze, "\u0112\u0301"=>"\u1E16".freeze, "\u0113\u0301"=>"\u1E17".freeze, "E\u032D"=>"\u1E18".freeze, "e\u032D"=>"\u1E19".freeze, "E\u0330"=>"\u1E1A".freeze, "e\u0330"=>"\u1E1B".freeze,
    "\u0228\u0306"=>"\u1E1C".freeze, "\u0229\u0306"=>"\u1E1D".freeze, "F\u0307"=>"\u1E1E".freeze, "f\u0307"=>"\u1E1F".freeze, "G\u0304"=>"\u1E20".freeze, "g\u0304"=>"\u1E21".freeze, "H\u0307"=>"\u1E22".freeze, "h\u0307"=>"\u1E23".freeze,
    "H\u0323"=>"\u1E24".freeze, "h\u0323"=>"\u1E25".freeze, "H\u0308"=>"\u1E26".freeze, "h\u0308"=>"\u1E27".freeze, "H\u0327"=>"\u1E28".freeze, "h\u0327"=>"\u1E29".freeze, "H\u032E"=>"\u1E2A".freeze, "h\u032E"=>"\u1E2B".freeze,
    "I\u0330"=>"\u1E2C".freeze, "i\u0330"=>"\u1E2D".freeze, "\u00CF\u0301"=>"\u1E2E".freeze, "\u00EF\u0301"=>"\u1E2F".freeze, "K\u0301"=>"\u1E30".freeze, "k\u0301"=>"\u1E31".freeze, "K\u0323"=>"\u1E32".freeze, "k\u0323"=>"\u1E33".freeze,
    "K\u0331"=>"\u1E34".freeze, "k\u0331"=>"\u1E35".freeze, "L\u0323"=>"\u1E36".freeze, "l\u0323"=>"\u1E37".freeze, "\u1E36\u0304"=>"\u1E38".freeze, "\u1E37\u0304"=>"\u1E39".freeze, "L\u0331"=>"\u1E3A".freeze, "l\u0331"=>"\u1E3B".freeze,
    "L\u032D"=>"\u1E3C".freeze, "l\u032D"=>"\u1E3D".freeze, "M\u0301"=>"\u1E3E".freeze, "m\u0301"=>"\u1E3F".freeze, "M\u0307"=>"\u1E40".freeze, "m\u0307"=>"\u1E41".freeze, "M\u0323"=>"\u1E42".freeze, "m\u0323"=>"\u1E43".freeze,
    "N\u0307"=>"\u1E44".freeze, "n\u0307"=>"\u1E45".freeze, "N\u0323"=>"\u1E46".freeze, "n\u0323"=>"\u1E47".freeze, "N\u0331"=>"\u1E48".freeze, "n\u0331"=>"\u1E49".freeze, "N\u032D"=>"\u1E4A".freeze, "n\u032D"=>"\u1E4B".freeze,
    "\u00D5\u0301"=>"\u1E4C".freeze, "\u00F5\u0301"=>"\u1E4D".freeze, "\u00D5\u0308"=>"\u1E4E".freeze, "\u00F5\u0308"=>"\u1E4F".freeze, "\u014C\u0300"=>"\u1E50".freeze, "\u014D\u0300"=>"\u1E51".freeze, "\u014C\u0301"=>"\u1E52".freeze, "\u014D\u0301"=>"\u1E53".freeze,
    "P\u0301"=>"\u1E54".freeze, "p\u0301"=>"\u1E55".freeze, "P\u0307"=>"\u1E56".freeze, "p\u0307"=>"\u1E57".freeze, "R\u0307"=>"\u1E58".freeze, "r\u0307"=>"\u1E59".freeze, "R\u0323"=>"\u1E5A".freeze, "r\u0323"=>"\u1E5B".freeze,
    "\u1E5A\u0304"=>"\u1E5C".freeze, "\u1E5B\u0304"=>"\u1E5D".freeze, "R\u0331"=>"\u1E5E".freeze, "r\u0331"=>"\u1E5F".freeze, "S\u0307"=>"\u1E60".freeze, "s\u0307"=>"\u1E61".freeze, "S\u0323"=>"\u1E62".freeze, "s\u0323"=>"\u1E63".freeze,
    "\u015A\u0307"=>"\u1E64".freeze, "\u015B\u0307"=>"\u1E65".freeze, "\u0160\u0307"=>"\u1E66".freeze, "\u0161\u0307"=>"\u1E67".freeze, "\u1E62\u0307"=>"\u1E68".freeze, "\u1E63\u0307"=>"\u1E69".freeze, "T\u0307"=>"\u1E6A".freeze, "t\u0307"=>"\u1E6B".freeze,
    "T\u0323"=>"\u1E6C".freeze, "t\u0323"=>"\u1E6D".freeze, "T\u0331"=>"\u1E6E".freeze, "t\u0331"=>"\u1E6F".freeze, "T\u032D"=>"\u1E70".freeze, "t\u032D"=>"\u1E71".freeze, "U\u0324"=>"\u1E72".freeze, "u\u0324"=>"\u1E73".freeze,
    "U\u0330"=>"\u1E74".freeze, "u\u0330"=>"\u1E75".freeze, "U\u032D"=>"\u1E76".freeze, "u\u032D"=>"\u1E77".freeze, "\u0168\u0301"=>"\u1E78".freeze, "\u0169\u0301"=>"\u1E79".freeze, "\u016A\u0308"=>"\u1E7A".freeze, "\u016B\u0308"=>"\u1E7B".freeze,
    "V\u0303"=>"\u1E7C".freeze, "v\u0303"=>"\u1E7D".freeze, "V\u0323"=>"\u1E7E".freeze, "v\u0323"=>"\u1E7F".freeze, "W\u0300"=>"\u1E80".freeze, "w\u0300"=>"\u1E81".freeze, "W\u0301"=>"\u1E82".freeze, "w\u0301"=>"\u1E83".freeze,
    "W\u0308"=>"\u1E84".freeze, "w\u0308"=>"\u1E85".freeze, "W\u0307"=>"\u1E86".freeze, "w\u0307"=>"\u1E87".freeze, "W\u0323"=>"\u1E88".freeze, "w\u0323"=>"\u1E89".freeze, "X\u0307"=>"\u1E8A".freeze, "x\u0307"=>"\u1E8B".freeze,
    "X\u0308"=>"\u1E8C".freeze, "x\u0308"=>"\u1E8D".freeze, "Y\u0307"=>"\u1E8E".freeze, "y\u0307"=>"\u1E8F".freeze, "Z\u0302"=>"\u1E90".freeze, "z\u0302"=>"\u1E91".freeze, "Z\u0323"=>"\u1E92".freeze, "z\u0323"=>"\u1E93".freeze,
    "Z\u0331"=>"\u1E94".freeze, "z\u0331"=>"\u1E95".freeze, "h\u0331"=>"\u1E96".freeze, "t\u0308"=>"\u1E97".freeze, "w\u030A"=>"\u1E98".freeze, "y\u030A"=>"\u1E99".freeze, "\u017F\u0307"=>"\u1E9B".freeze, "A\u0323"=>"\u1EA0".freeze,
    "a\u0323"=>"\u1EA1".freeze, "A\u0309"=>"\u1EA2".freeze, "a\u0309"=>"\u1EA3".freeze, "\u00C2\u0301"=>"\u1EA4".freeze, "\u00E2\u0301"=>"\u1EA5".freeze, "\u00C2\u0300"=>"\u1EA6".freeze, "\u00E2\u0300"=>"\u1EA7".freeze, "\u00C2\u0309"=>"\u1EA8".freeze,
    "\u00E2\u0309"=>"\u1EA9".freeze, "\u00C2\u0303"=>"\u1EAA".freeze, "\u00E2\u0303"=>"\u1EAB".freeze, "\u1EA0\u0302"=>"\u1EAC".freeze, "\u1EA1\u0302"=>"\u1EAD".freeze, "\u0102\u0301"=>"\u1EAE".freeze, "\u0103\u0301"=>"\u1EAF".freeze, "\u0102\u0300"=>"\u1EB0".freeze,
    "\u0103\u0300"=>"\u1EB1".freeze, "\u0102\u0309"=>"\u1EB2".freeze, "\u0103\u0309"=>"\u1EB3".freeze, "\u0102\u0303"=>"\u1EB4".freeze, "\u0103\u0303"=>"\u1EB5".freeze, "\u1EA0\u0306"=>"\u1EB6".freeze, "\u1EA1\u0306"=>"\u1EB7".freeze, "E\u0323"=>"\u1EB8".freeze,
    "e\u0323"=>"\u1EB9".freeze, "E\u0309"=>"\u1EBA".freeze, "e\u0309"=>"\u1EBB".freeze, "E\u0303"=>"\u1EBC".freeze, "e\u0303"=>"\u1EBD".freeze, "\u00CA\u0301"=>"\u1EBE".freeze, "\u00EA\u0301"=>"\u1EBF".freeze, "\u00CA\u0300"=>"\u1EC0".freeze,
    "\u00EA\u0300"=>"\u1EC1".freeze, "\u00CA\u0309"=>"\u1EC2".freeze, "\u00EA\u0309"=>"\u1EC3".freeze, "\u00CA\u0303"=>"\u1EC4".freeze, "\u00EA\u0303"=>"\u1EC5".freeze, "\u1EB8\u0302"=>"\u1EC6".freeze, "\u1EB9\u0302"=>"\u1EC7".freeze, "I\u0309"=>"\u1EC8".freeze,
    "i\u0309"=>"\u1EC9".freeze, "I\u0323"=>"\u1ECA".freeze, "i\u0323"=>"\u1ECB".freeze, "O\u0323"=>"\u1ECC".freeze, "o\u0323"=>"\u1ECD".freeze, "O\u0309"=>"\u1ECE".freeze, "o\u0309"=>"\u1ECF".freeze, "\u00D4\u0301"=>"\u1ED0".freeze,
    "\u00F4\u0301"=>"\u1ED1".freeze, "\u00D4\u0300"=>"\u1ED2".freeze, "\u00F4\u0300"=>"\u1ED3".freeze, "\u00D4\u0309"=>"\u1ED4".freeze, "\u00F4\u0309"=>"\u1ED5".freeze, "\u00D4\u0303"=>"\u1ED6".freeze, "\u00F4\u0303"=>"\u1ED7".freeze, "\u1ECC\u0302"=>"\u1ED8".freeze,
    "\u1ECD\u0302"=>"\u1ED9".freeze, "\u01A0\u0301"=>"\u1EDA".freeze, "\u01A1\u0301"=>"\u1EDB".freeze, "\u01A0\u0300"=>"\u1EDC".freeze, "\u01A1\u0300"=>"\u1EDD".freeze, "\u01A0\u0309"=>"\u1EDE".freeze, "\u01A1\u0309"=>"\u1EDF".freeze, "\u01A0\u0303"=>"\u1EE0".freeze,
    "\u01A1\u0303"=>"\u1EE1".freeze, "\u01A0\u0323"=>"\u1EE2".freeze, "\u01A1\u0323"=>"\u1EE3".freeze, "U\u0323"=>"\u1EE4".freeze, "u\u0323"=>"\u1EE5".freeze, "U\u0309"=>"\u1EE6".freeze, "u\u0309"=>"\u1EE7".freeze, "\u01AF\u0301"=>"\u1EE8".freeze,
    "\u01B0\u0301"=>"\u1EE9".freeze, "\u01AF\u0300"=>"\u1EEA".freeze, "\u01B0\u0300"=>"\u1EEB".freeze, "\u01AF\u0309"=>"\u1EEC".freeze, "\u01B0\u0309"=>"\u1EED".freeze, "\u01AF\u0303"=>"\u1EEE".freeze, "\u01B0\u0303"=>"\u1EEF".freeze, "\u01AF\u0323"=>"\u1EF0".freeze,
    "\u01B0\u0323"=>"\u1EF1".freeze, "Y\u0300"=>"\u1EF2".freeze, "y\u0300"=>"\u1EF3".freeze, "Y\u0323"=>"\u1EF4".freeze, "y\u0323"=>"\u1EF5".freeze, "Y\u0309"=>"\u1EF6".freeze, "y\u0309"=>"\u1EF7".freeze, "Y\u0303"=>"\u1EF8".freeze,
    "y\u0303"=>"\u1EF9".freeze, "\u03B1\u0313"=>"\u1F00".freeze, "\u03B1\u0314"=>"\u1F01".freeze, "\u1F00\u0300"=>"\u1F02".freeze, "\u1F01\u0300"=>"\u1F03".freeze, "\u1F00\u0301"=>"\u1F04".freeze, "\u1F01\u0301"=>"\u1F05".freeze, "\u1F00\u0342"=>"\u1F06".freeze,
    "\u1F01\u0342"=>"\u1F07".freeze, "\u0391\u0313"=>"\u1F08".freeze, "\u0391\u0314"=>"\u1F09".freeze, "\u1F08\u0300"=>"\u1F0A".freeze, "\u1F09\u0300"=>"\u1F0B".freeze, "\u1F08\u0301"=>"\u1F0C".freeze, "\u1F09\u0301"=>"\u1F0D".freeze, "\u1F08\u0342"=>"\u1F0E".freeze,
    "\u1F09\u0342"=>"\u1F0F".freeze, "\u03B5\u0313"=>"\u1F10".freeze, "\u03B5\u0314"=>"\u1F11".freeze, "\u1F10\u0300"=>"\u1F12".freeze, "\u1F11\u0300"=>"\u1F13".freeze, "\u1F10\u0301"=>"\u1F14".freeze, "\u1F11\u0301"=>"\u1F15".freeze, "\u0395\u0313"=>"\u1F18".freeze,
    "\u0395\u0314"=>"\u1F19".freeze, "\u1F18\u0300"=>"\u1F1A".freeze, "\u1F19\u0300"=>"\u1F1B".freeze, "\u1F18\u0301"=>"\u1F1C".freeze, "\u1F19\u0301"=>"\u1F1D".freeze, "\u03B7\u0313"=>"\u1F20".freeze, "\u03B7\u0314"=>"\u1F21".freeze, "\u1F20\u0300"=>"\u1F22".freeze,
    "\u1F21\u0300"=>"\u1F23".freeze, "\u1F20\u0301"=>"\u1F24".freeze, "\u1F21\u0301"=>"\u1F25".freeze, "\u1F20\u0342"=>"\u1F26".freeze, "\u1F21\u0342"=>"\u1F27".freeze, "\u0397\u0313"=>"\u1F28".freeze, "\u0397\u0314"=>"\u1F29".freeze, "\u1F28\u0300"=>"\u1F2A".freeze,
    "\u1F29\u0300"=>"\u1F2B".freeze, "\u1F28\u0301"=>"\u1F2C".freeze, "\u1F29\u0301"=>"\u1F2D".freeze, "\u1F28\u0342"=>"\u1F2E".freeze, "\u1F29\u0342"=>"\u1F2F".freeze, "\u03B9\u0313"=>"\u1F30".freeze, "\u03B9\u0314"=>"\u1F31".freeze, "\u1F30\u0300"=>"\u1F32".freeze,
    "\u1F31\u0300"=>"\u1F33".freeze, "\u1F30\u0301"=>"\u1F34".freeze, "\u1F31\u0301"=>"\u1F35".freeze, "\u1F30\u0342"=>"\u1F36".freeze, "\u1F31\u0342"=>"\u1F37".freeze, "\u0399\u0313"=>"\u1F38".freeze, "\u0399\u0314"=>"\u1F39".freeze, "\u1F38\u0300"=>"\u1F3A".freeze,
    "\u1F39\u0300"=>"\u1F3B".freeze, "\u1F38\u0301"=>"\u1F3C".freeze, "\u1F39\u0301"=>"\u1F3D".freeze, "\u1F38\u0342"=>"\u1F3E".freeze, "\u1F39\u0342"=>"\u1F3F".freeze, "\u03BF\u0313"=>"\u1F40".freeze, "\u03BF\u0314"=>"\u1F41".freeze, "\u1F40\u0300"=>"\u1F42".freeze,
    "\u1F41\u0300"=>"\u1F43".freeze, "\u1F40\u0301"=>"\u1F44".freeze, "\u1F41\u0301"=>"\u1F45".freeze, "\u039F\u0313"=>"\u1F48".freeze, "\u039F\u0314"=>"\u1F49".freeze, "\u1F48\u0300"=>"\u1F4A".freeze, "\u1F49\u0300"=>"\u1F4B".freeze, "\u1F48\u0301"=>"\u1F4C".freeze,
    "\u1F49\u0301"=>"\u1F4D".freeze, "\u03C5\u0313"=>"\u1F50".freeze, "\u03C5\u0314"=>"\u1F51".freeze, "\u1F50\u0300"=>"\u1F52".freeze, "\u1F51\u0300"=>"\u1F53".freeze, "\u1F50\u0301"=>"\u1F54".freeze, "\u1F51\u0301"=>"\u1F55".freeze, "\u1F50\u0342"=>"\u1F56".freeze,
    "\u1F51\u0342"=>"\u1F57".freeze, "\u03A5\u0314"=>"\u1F59".freeze, "\u1F59\u0300"=>"\u1F5B".freeze, "\u1F59\u0301"=>"\u1F5D".freeze, "\u1F59\u0342"=>"\u1F5F".freeze, "\u03C9\u0313"=>"\u1F60".freeze, "\u03C9\u0314"=>"\u1F61".freeze, "\u1F60\u0300"=>"\u1F62".freeze,
    "\u1F61\u0300"=>"\u1F63".freeze, "\u1F60\u0301"=>"\u1F64".freeze, "\u1F61\u0301"=>"\u1F65".freeze, "\u1F60\u0342"=>"\u1F66".freeze, "\u1F61\u0342"=>"\u1F67".freeze, "\u03A9\u0313"=>"\u1F68".freeze, "\u03A9\u0314"=>"\u1F69".freeze, "\u1F68\u0300"=>"\u1F6A".freeze,
    "\u1F69\u0300"=>"\u1F6B".freeze, "\u1F68\u0301"=>"\u1F6C".freeze, "\u1F69\u0301"=>"\u1F6D".freeze, "\u1F68\u0342"=>"\u1F6E".freeze, "\u1F69\u0342"=>"\u1F6F".freeze, "\u03B1\u0300"=>"\u1F70".freeze, "\u03B5\u0300"=>"\u1F72".freeze, "\u03B7\u0300"=>"\u1F74".freeze,
    "\u03B9\u0300"=>"\u1F76".freeze, "\u03BF\u0300"=>"\u1F78".freeze, "\u03C5\u0300"=>"\u1F7A".freeze, "\u03C9\u0300"=>"\u1F7C".freeze, "\u1F00\u0345"=>"\u1F80".freeze, "\u1F01\u0345"=>"\u1F81".freeze, "\u1F02\u0345"=>"\u1F82".freeze, "\u1F03\u0345"=>"\u1F83".freeze,
    "\u1F04\u0345"=>"\u1F84".freeze, "\u1F05\u0345"=>"\u1F85".freeze, "\u1F06\u0345"=>"\u1F86".freeze, "\u1F07\u0345"=>"\u1F87".freeze, "\u1F08\u0345"=>"\u1F88".freeze, "\u1F09\u0345"=>"\u1F89".freeze, "\u1F0A\u0345"=>"\u1F8A".freeze, "\u1F0B\u0345"=>"\u1F8B".freeze,
    "\u1F0C\u0345"=>"\u1F8C".freeze, "\u1F0D\u0345"=>"\u1F8D".freeze, "\u1F0E\u0345"=>"\u1F8E".freeze, "\u1F0F\u0345"=>"\u1F8F".freeze, "\u1F20\u0345"=>"\u1F90".freeze, "\u1F21\u0345"=>"\u1F91".freeze, "\u1F22\u0345"=>"\u1F92".freeze, "\u1F23\u0345"=>"\u1F93".freeze,
    "\u1F24\u0345"=>"\u1F94".freeze, "\u1F25\u0345"=>"\u1F95".freeze, "\u1F26\u0345"=>"\u1F96".freeze, "\u1F27\u0345"=>"\u1F97".freeze, "\u1F28\u0345"=>"\u1F98".freeze, "\u1F29\u0345"=>"\u1F99".freeze, "\u1F2A\u0345"=>"\u1F9A".freeze, "\u1F2B\u0345"=>"\u1F9B".freeze,
    "\u1F2C\u0345"=>"\u1F9C".freeze, "\u1F2D\u0345"=>"\u1F9D".freeze, "\u1F2E\u0345"=>"\u1F9E".freeze, "\u1F2F\u0345"=>"\u1F9F".freeze, "\u1F60\u0345"=>"\u1FA0".freeze, "\u1F61\u0345"=>"\u1FA1".freeze, "\u1F62\u0345"=>"\u1FA2".freeze, "\u1F63\u0345"=>"\u1FA3".freeze,
    "\u1F64\u0345"=>"\u1FA4".freeze, "\u1F65\u0345"=>"\u1FA5".freeze, "\u1F66\u0345"=>"\u1FA6".freeze, "\u1F67\u0345"=>"\u1FA7".freeze, "\u1F68\u0345"=>"\u1FA8".freeze, "\u1F69\u0345"=>"\u1FA9".freeze, "\u1F6A\u0345"=>"\u1FAA".freeze, "\u1F6B\u0345"=>"\u1FAB".freeze,
    "\u1F6C\u0345"=>"\u1FAC".freeze, "\u1F6D\u0345"=>"\u1FAD".freeze, "\u1F6E\u0345"=>"\u1FAE".freeze, "\u1F6F\u0345"=>"\u1FAF".freeze, "\u03B1\u0306"=>"\u1FB0".freeze, "\u03B1\u0304"=>"\u1FB1".freeze, "\u1F70\u0345"=>"\u1FB2".freeze, "\u03B1\u0345"=>"\u1FB3".freeze,
    "\u03AC\u0345"=>"\u1FB4".freeze, "\u03B1\u0342"=>"\u1FB6".freeze, "\u1FB6\u0345"=>"\u1FB7".freeze, "\u0391\u0306"=>"\u1FB8".freeze, "\u0391\u0304"=>"\u1FB9".freeze, "\u0391\u0300"=>"\u1FBA".freeze, "\u0391\u0345"=>"\u1FBC".freeze, "\u00A8\u0342"=>"\u1FC1".freeze,
    "\u1F74\u0345"=>"\u1FC2".freeze, "\u03B7\u0345"=>"\u1FC3".freeze, "\u03AE\u0345"=>"\u1FC4".freeze, "\u03B7\u0342"=>"\u1FC6".freeze, "\u1FC6\u0345"=>"\u1FC7".freeze, "\u0395\u0300"=>"\u1FC8".freeze, "\u0397\u0300"=>"\u1FCA".freeze, "\u0397\u0345"=>"\u1FCC".freeze,
    "\u1FBF\u0300"=>"\u1FCD".freeze, "\u1FBF\u0301"=>"\u1FCE".freeze, "\u1FBF\u0342"=>"\u1FCF".freeze, "\u03B9\u0306"=>"\u1FD0".freeze, "\u03B9\u0304"=>"\u1FD1".freeze, "\u03CA\u0300"=>"\u1FD2".freeze, "\u03B9\u0342"=>"\u1FD6".freeze, "\u03CA\u0342"=>"\u1FD7".freeze,
    "\u0399\u0306"=>"\u1FD8".freeze, "\u0399\u0304"=>"\u1FD9".freeze, "\u0399\u0300"=>"\u1FDA".freeze, "\u1FFE\u0300"=>"\u1FDD".freeze, "\u1FFE\u0301"=>"\u1FDE".freeze, "\u1FFE\u0342"=>"\u1FDF".freeze, "\u03C5\u0306"=>"\u1FE0".freeze, "\u03C5\u0304"=>"\u1FE1".freeze,
    "\u03CB\u0300"=>"\u1FE2".freeze, "\u03C1\u0313"=>"\u1FE4".freeze, "\u03C1\u0314"=>"\u1FE5".freeze, "\u03C5\u0342"=>"\u1FE6".freeze, "\u03CB\u0342"=>"\u1FE7".freeze, "\u03A5\u0306"=>"\u1FE8".freeze, "\u03A5\u0304"=>"\u1FE9".freeze, "\u03A5\u0300"=>"\u1FEA".freeze,
    "\u03A1\u0314"=>"\u1FEC".freeze, "\u00A8\u0300"=>"\u1FED".freeze, "\u1F7C\u0345"=>"\u1FF2".freeze, "\u03C9\u0345"=>"\u1FF3".freeze, "\u03CE\u0345"=>"\u1FF4".freeze, "\u03C9\u0342"=>"\u1FF6".freeze, "\u1FF6\u0345"=>"\u1FF7".freeze, "\u039F\u0300"=>"\u1FF8".freeze,
    "\u03A9\u0300"=>"\u1FFA".freeze, "\u03A9\u0345"=>"\u1FFC".freeze, "\u2190\u0338"=>"\u219A".freeze, "\u2192\u0338"=>"\u219B".freeze, "\u2194\u0338"=>"\u21AE".freeze, "\u21D0\u0338"=>"\u21CD".freeze, "\u21D4\u0338"=>"\u21CE".freeze, "\u21D2\u0338"=>"\u21CF".freeze,
    "\u2203\u0338"=>"\u2204".freeze, "\u2208\u0338"=>"\u2209".freeze, "\u220B\u0338"=>"\u220C".freeze, "\u2223\u0338"=>"\u2224".freeze, "\u2225\u0338"=>"\u2226".freeze, "\u223C\u0338"=>"\u2241".freeze, "\u2243\u0338"=>"\u2244".freeze, "\u2245\u0338"=>"\u2247".freeze,
    "\u2248\u0338"=>"\u2249".freeze, "=\u0338"=>"\u2260".freeze, "\u2261\u0338"=>"\u2262".freeze, "\u224D\u0338"=>"\u226D".freeze, "<\u0338"=>"\u226E".freeze, ">\u0338"=>"\u226F".freeze, "\u2264\u0338"=>"\u2270".freeze, "\u2265\u0338"=>"\u2271".freeze,
    "\u2272\u0338"=>"\u2274".freeze, "\u2273\u0338"=>"\u2275".freeze, "\u2276\u0338"=>"\u2278".freeze, "\u2277\u0338"=>"\u2279".freeze, "\u227A\u0338"=>"\u2280".freeze, "\u227B\u0338"=>"\u2281".freeze, "\u2282\u0338"=>"\u2284".freeze, "\u2283\u0338"=>"\u2285".freeze,
    "\u2286\u0338"=>"\u2288".freeze, "\u2287\u0338"=>"\u2289".freeze, "\u22A2\u0338"=>"\u22AC".freeze, "\u22A8\u0338"=>"\u22AD".freeze, "\u22A9\u0338"=>"\u22AE".freeze, "\u22AB\u0338"=>"\u22AF".freeze, "\u227C\u0338"=>"\u22E0".freeze, "\u227D\u0338"=>"\u22E1".freeze,
    "\u2291\u0338"=>"\u22E2".freeze, "\u2292\u0338"=>"\u22E3".freeze, "\u22B2\u0338"=>"\u22EA".freeze, "\u22B3\u0338"=>"\u22EB".freeze, "\u22B4\u0338"=>"\u22EC".freeze, "\u22B5\u0338"=>"\u22ED".freeze, "\u304B\u3099"=>"\u304C".freeze, "\u304D\u3099"=>"\u304E".freeze,
    "\u304F\u3099"=>"\u3050".freeze, "\u3051\u3099"=>"\u3052".freeze, "\u3053\u3099"=>"\u3054".freeze, "\u3055\u3099"=>"\u3056".freeze, "\u3057\u3099"=>"\u3058".freeze, "\u3059\u3099"=>"\u305A".freeze, "\u305B\u3099"=>"\u305C".freeze, "\u305D\u3099"=>"\u305E".freeze,
    "\u305F\u3099"=>"\u3060".freeze, "\u3061\u3099"=>"\u3062".freeze, "\u3064\u3099"=>"\u3065".freeze, "\u3066\u3099"=>"\u3067".freeze, "\u3068\u3099"=>"\u3069".freeze, "\u306F\u3099"=>"\u3070".freeze, "\u306F\u309A"=>"\u3071".freeze, "\u3072\u3099"=>"\u3073".freeze,
    "\u3072\u309A"=>"\u3074".freeze, "\u3075\u3099"=>"\u3076".freeze, "\u3075\u309A"=>"\u3077".freeze, "\u3078\u3099"=>"\u3079".freeze, "\u3078\u309A"=>"\u307A".freeze, "\u307B\u3099"=>"\u307C".freeze, "\u307B\u309A"=>"\u307D".freeze, "\u3046\u3099"=>"\u3094".freeze,
    "\u309D\u3099"=>"\u309E".freeze, "\u30AB\u3099"=>"\u30AC".freeze, "\u30AD\u3099"=>"\u30AE".freeze, "\u30AF\u3099"=>"\u30B0".freeze, "\u30B1\u3099"=>"\u30B2".freeze, "\u30B3\u3099"=>"\u30B4".freeze, "\u30B5\u3099"=>"\u30B6".freeze, "\u30B7\u3099"=>"\u30B8".freeze,
    "\u30B9\u3099"=>"\u30BA".freeze, "\u30BB\u3099"=>"\u30BC".freeze, "\u30BD\u3099"=>"\u30BE".freeze, "\u30BF\u3099"=>"\u30C0".freeze, "\u30C1\u3099"=>"\u30C2".freeze, "\u30C4\u3099"=>"\u30C5".freeze, "\u30C6\u3099"=>"\u30C7".freeze, "\u30C8\u3099"=>"\u30C9".freeze,
    "\u30CF\u3099"=>"\u30D0".freeze, "\u30CF\u309A"=>"\u30D1".freeze, "\u30D2\u3099"=>"\u30D3".freeze, "\u30D2\u309A"=>"\u30D4".freeze, "\u30D5\u3099"=>"\u30D6".freeze, "\u30D5\u309A"=>"\u30D7".freeze, "\u30D8\u3099"=>"\u30D9".freeze, "\u30D8\u309A"=>"\u30DA".freeze,
    "\u30DB\u3099"=>"\u30DC".freeze, "\u30DB\u309A"=>"\u30DD".freeze, "\u30A6\u3099"=>"\u30F4".freeze, "\u30EF\u3099"=>"\u30F7".freeze, "\u30F0\u3099"=>"\u30F8".freeze, "\u30F1\u3099"=>"\u30F9".freeze, "\u30F2\u3099"=>"\u30FA".freeze, "\u30FD\u3099"=>"\u30FE".freeze,
    "\u{11099}\u{110BA}"=>"\u{1109A}".freeze, "\u{1109B}\u{110BA}"=>"\u{1109C}".freeze, "\u{110A5}\u{110BA}"=>"\u{110AB}".freeze, "\u{11131}\u{11127}"=>"\u{1112E}".freeze, "\u{11132}\u{11127}"=>"\u{1112F}".freeze, "\u{11347}\u{1133E}"=>"\u{1134B}".freeze, "\u{11347}\u{11357}"=>"\u{1134C}".freeze, "\u{114B9}\u{114BA}"=>"\u{114BB}".freeze,
    "\u{114B9}\u{114B0}"=>"\u{114BC}".freeze, "\u{114B9}\u{114BD}"=>"\u{114BE}".freeze, "\u{115B8}\u{115AF}"=>"\u{115BA}".freeze, "\u{115B9}\u{115AF}"=>"\u{115BB}".freeze,
  }.freeze
end
