

/* this file was generated by volk_gnsssdr template utils, do not edit! */

/*
 * GNSS-SDR is a Global Navigation Satellite System software-defined receiver.
 * This file is part of GNSS-SDR.
 *
 * Copyright (C) 2010-2019 (see AUTHORS file for a list of contributors)
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

#ifndef INCLUDED_VOLK_GNSSSDR_RUNTIME
#define INCLUDED_VOLK_GNSSSDR_RUNTIME

#include <volk_gnsssdr/volk_gnsssdr_common.h>
#include <volk_gnsssdr/volk_gnsssdr_complex.h>
#include <volk_gnsssdr/volk_gnsssdr_config_fixed.h>
#include <volk_gnsssdr/volk_gnsssdr_malloc.h>
#include <volk_gnsssdr/volk_gnsssdr_typedefs.h>
#include <stdbool.h>
#include <stdlib.h>

__VOLK_DECL_BEGIN

typedef struct volk_gnsssdr_func_desc
{
    const char **impl_names;
    const int *impl_deps;
    const bool *impl_alignment;
    size_t n_impls;
} volk_gnsssdr_func_desc_t;

//! Prints a list of machines available
VOLK_API void volk_gnsssdr_list_machines(void);

//! Returns the name of the machine this instance will use
VOLK_API const char *volk_gnsssdr_get_machine(void);

//! Get the machine alignment in bytes
VOLK_API size_t volk_gnsssdr_get_alignment(void);

/*!
 * The VOLK_OR_PTR macro is a convenience macro
 * for checking the alignment of a set of pointers.
 * Example usage:
 * volk_gnsssdr_is_aligned(VOLK_OR_PTR((VOLK_OR_PTR(p0, p1), p2)))
 */
#define VOLK_OR_PTR(ptr0, ptr1)     (const void *)(((intptr_t)(ptr0)) | ((intptr_t)(ptr1)))

/*!
 * Is the pointer on a machine alignment boundary?
 *
 * Note: for performance reasons, this function
 * is not usable until another volk_gnsssdr API call is made
 * which will perform certain initialization tasks.
 *
 * \param ptr the pointer to some memory buffer
 * \return 1 for alignment boundary, else 0
 */
VOLK_API bool volk_gnsssdr_is_aligned(const void *ptr);

// clang-format off

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_resamplerxnpuppet_16i volk_gnsssdr_16i_resamplerxnpuppet_16i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_resamplerxnpuppet_16i volk_gnsssdr_16i_resamplerxnpuppet_16i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_resamplerxnpuppet_16i volk_gnsssdr_16i_resamplerxnpuppet_16i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16i_resamplerxnpuppet_16i_manual(int16_t*  result, const int16_t*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16i_resamplerxnpuppet_16i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16i_xn_resampler_16i_xn volk_gnsssdr_16i_xn_resampler_16i_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16i_xn_resampler_16i_xn volk_gnsssdr_16i_xn_resampler_16i_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16i_xn_resampler_16i_xn volk_gnsssdr_16i_xn_resampler_16i_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16i_xn_resampler_16i_xn_manual(int16_t**  result, const int16_t*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, float*  shifts_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16i_xn_resampler_16i_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_16i_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_16i_rotator_dot_prod_16ic_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_16i_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_16i_rotator_dot_prod_16ic_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_16i_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_16i_rotator_dot_prod_16ic_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_16i_rotator_dot_prod_16ic_xn_manual(lv_16sc_t*  result, const lv_16sc_t*  in_common, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, const int16_t**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_16i_rotator_dot_prod_16ic_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_16i_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_16i_rotator_dotprodxnpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_16i_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_16i_rotator_dotprodxnpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_16i_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_16i_rotator_dotprodxnpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_16i_rotator_dotprodxnpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, const lv_16sc_t*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_16i_rotator_dotprodxnpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_conjugate_16ic volk_gnsssdr_16ic_conjugate_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_conjugate_16ic volk_gnsssdr_16ic_conjugate_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_conjugate_16ic volk_gnsssdr_16ic_conjugate_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_conjugate_16ic_manual(lv_16sc_t*  cVector, const lv_16sc_t*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_conjugate_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_convert_32fc volk_gnsssdr_16ic_convert_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_convert_32fc volk_gnsssdr_16ic_convert_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_convert_32fc volk_gnsssdr_16ic_convert_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_convert_32fc_manual(lv_32fc_t*  outputVector, const lv_16sc_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_convert_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_resampler_fast_16ic volk_gnsssdr_16ic_resampler_fast_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_resampler_fast_16ic volk_gnsssdr_16ic_resampler_fast_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_resampler_fast_16ic volk_gnsssdr_16ic_resampler_fast_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_resampler_fast_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, int  code_length_chips, unsigned int  num_output_samples, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_resampler_fast_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_resamplerfastpuppet_16ic volk_gnsssdr_16ic_resamplerfastpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_resamplerfastpuppet_16ic volk_gnsssdr_16ic_resamplerfastpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_resamplerfastpuppet_16ic volk_gnsssdr_16ic_resamplerfastpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_resamplerfastpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_resamplerfastpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_resamplerfastxnpuppet_16ic volk_gnsssdr_16ic_resamplerfastxnpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_resamplerfastxnpuppet_16ic volk_gnsssdr_16ic_resamplerfastxnpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_resamplerfastxnpuppet_16ic volk_gnsssdr_16ic_resamplerfastxnpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_resamplerfastxnpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_resamplerfastxnpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_resamplerxnpuppet_16ic volk_gnsssdr_16ic_resamplerxnpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_resamplerxnpuppet_16ic volk_gnsssdr_16ic_resamplerxnpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_resamplerxnpuppet_16ic volk_gnsssdr_16ic_resamplerxnpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_resamplerxnpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_resamplerxnpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_rotatorpuppet_16ic volk_gnsssdr_16ic_rotatorpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_rotatorpuppet_16ic volk_gnsssdr_16ic_rotatorpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_rotatorpuppet_16ic volk_gnsssdr_16ic_rotatorpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_rotatorpuppet_16ic_manual(lv_16sc_t*  outVector, const lv_16sc_t*  inVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_rotatorpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_s32fc_x2_rotator_16ic volk_gnsssdr_16ic_s32fc_x2_rotator_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_s32fc_x2_rotator_16ic volk_gnsssdr_16ic_s32fc_x2_rotator_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_s32fc_x2_rotator_16ic volk_gnsssdr_16ic_s32fc_x2_rotator_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_s32fc_x2_rotator_16ic_manual(lv_16sc_t*  outVector, const lv_16sc_t*  inVector, const lv_32fc_t*  phase_inc, lv_32fc_t*  phase, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_s32fc_x2_rotator_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_gnsssdr_16ic_x2_dot_prod_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_gnsssdr_16ic_x2_dot_prod_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic volk_gnsssdr_16ic_x2_dot_prod_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_dot_prod_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_dot_prod_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_dot_prod_16ic_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_dot_prod_16ic_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_dot_prod_16ic_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_dot_prod_16ic_xn_manual(lv_16sc_t*  result, const lv_16sc_t*  in_common, const lv_16sc_t**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_dot_prod_16ic_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_dotprodxnpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_dotprodxnpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_dotprodxnpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_dotprodxnpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, const lv_16sc_t*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_dotprodxnpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_gnsssdr_16ic_x2_multiply_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_gnsssdr_16ic_x2_multiply_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_multiply_16ic volk_gnsssdr_16ic_x2_multiply_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_multiply_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  in_a, const lv_16sc_t*  in_b, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_multiply_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_rotator_dot_prod_16ic_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_rotator_dot_prod_16ic_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_rotator_dot_prod_16ic_xn volk_gnsssdr_16ic_x2_rotator_dot_prod_16ic_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_rotator_dot_prod_16ic_xn_manual(lv_16sc_t*  result, const lv_16sc_t*  in_common, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, const lv_16sc_t**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_rotator_dot_prod_16ic_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_x2_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_rotator_dotprodxnpuppet_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_x2_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_rotator_dotprodxnpuppet_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_x2_rotator_dotprodxnpuppet_16ic volk_gnsssdr_16ic_x2_rotator_dotprodxnpuppet_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_x2_rotator_dotprodxnpuppet_16ic_manual(lv_16sc_t*  result, const lv_16sc_t*  local_code, const lv_16sc_t*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_x2_rotator_dotprodxnpuppet_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_xn_resampler_16ic_xn volk_gnsssdr_16ic_xn_resampler_16ic_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_xn_resampler_16ic_xn volk_gnsssdr_16ic_xn_resampler_16ic_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_xn_resampler_16ic_xn volk_gnsssdr_16ic_xn_resampler_16ic_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_xn_resampler_16ic_xn_manual(lv_16sc_t**  result, const lv_16sc_t*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, float*  shifts_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_xn_resampler_16ic_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_16ic_xn_resampler_fast_16ic_xn volk_gnsssdr_16ic_xn_resampler_fast_16ic_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_16ic_xn_resampler_fast_16ic_xn volk_gnsssdr_16ic_xn_resampler_fast_16ic_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_16ic_xn_resampler_fast_16ic_xn volk_gnsssdr_16ic_xn_resampler_fast_16ic_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_16ic_xn_resampler_fast_16ic_xn_manual(lv_16sc_t**  result, const lv_16sc_t*  local_code, float*  rem_code_phase_chips, float  code_phase_step_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_output_samples, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_16ic_xn_resampler_fast_16ic_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_high_dynamics_resamplerxnpuppet_32f volk_gnsssdr_32f_high_dynamics_resamplerxnpuppet_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_high_dynamics_resamplerxnpuppet_32f volk_gnsssdr_32f_high_dynamics_resamplerxnpuppet_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_high_dynamics_resamplerxnpuppet_32f volk_gnsssdr_32f_high_dynamics_resamplerxnpuppet_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_high_dynamics_resamplerxnpuppet_32f_manual(float*  result, const float*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_high_dynamics_resamplerxnpuppet_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_index_max_32u volk_gnsssdr_32f_index_max_32u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_index_max_32u volk_gnsssdr_32f_index_max_32u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_index_max_32u volk_gnsssdr_32f_index_max_32u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_index_max_32u_manual(uint32_t*  target, const float*  src0, uint32_t  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_index_max_32u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_resamplerxnpuppet_32f volk_gnsssdr_32f_resamplerxnpuppet_32f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_resamplerxnpuppet_32f volk_gnsssdr_32f_resamplerxnpuppet_32f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_resamplerxnpuppet_32f volk_gnsssdr_32f_resamplerxnpuppet_32f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_resamplerxnpuppet_32f_manual(float*  result, const float*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_resamplerxnpuppet_32f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_sincos_32fc volk_gnsssdr_32f_sincos_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_sincos_32fc volk_gnsssdr_32f_sincos_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_sincos_32fc volk_gnsssdr_32f_sincos_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_sincos_32fc_manual(lv_32fc_t*  out, const float*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_sincos_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_xn_high_dynamics_resampler_32f_xn volk_gnsssdr_32f_xn_high_dynamics_resampler_32f_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_xn_high_dynamics_resampler_32f_xn volk_gnsssdr_32f_xn_high_dynamics_resampler_32f_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_xn_high_dynamics_resampler_32f_xn volk_gnsssdr_32f_xn_high_dynamics_resampler_32f_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_xn_high_dynamics_resampler_32f_xn_manual(float**  result, const float*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, float  code_phase_rate_step_chips, float*  shifts_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_xn_high_dynamics_resampler_32f_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32f_xn_resampler_32f_xn volk_gnsssdr_32f_xn_resampler_32f_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32f_xn_resampler_32f_xn volk_gnsssdr_32f_xn_resampler_32f_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32f_xn_resampler_32f_xn volk_gnsssdr_32f_xn_resampler_32f_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32f_xn_resampler_32f_xn_manual(float**  result, const float*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, float*  shifts_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32f_xn_resampler_32f_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn_manual(lv_32fc_t*  result, const lv_32fc_t*  in_common, const lv_32fc_t  phase_inc, const lv_32fc_t  phase_inc_rate, lv_32fc_t*  phase, const float**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_32f_high_dynamic_rotator_dot_prod_32fc_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  local_code, const float*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_32f_high_dynamic_rotator_dotprodxnpuppet_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_rotator_dot_prod_32fc_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_rotator_dot_prod_32fc_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_32f_rotator_dot_prod_32fc_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_32f_rotator_dot_prod_32fc_xn_manual(lv_32fc_t*  result, const lv_32fc_t*  in_common, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, const float**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_32f_rotator_dot_prod_32fc_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_32f_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_rotator_dotprodxnpuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_32f_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_rotator_dotprodxnpuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_32f_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_32f_rotator_dotprodxnpuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_32f_rotator_dotprodxnpuppet_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  local_code, const float*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_32f_rotator_dotprodxnpuppet_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_convert_16ic volk_gnsssdr_32fc_convert_16ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_convert_16ic volk_gnsssdr_32fc_convert_16ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_convert_16ic volk_gnsssdr_32fc_convert_16ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_convert_16ic_manual(lv_16sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_convert_16ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_convert_8ic volk_gnsssdr_32fc_convert_8ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_convert_8ic volk_gnsssdr_32fc_convert_8ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_convert_8ic volk_gnsssdr_32fc_convert_8ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_convert_8ic_manual(lv_8sc_t*  outputVector, const lv_32fc_t*  inputVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_convert_8ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_resamplerxnpuppet_32fc volk_gnsssdr_32fc_resamplerxnpuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_resamplerxnpuppet_32fc volk_gnsssdr_32fc_resamplerxnpuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_resamplerxnpuppet_32fc volk_gnsssdr_32fc_resamplerxnpuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_resamplerxnpuppet_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  local_code, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_resamplerxnpuppet_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_x2_rotator_dot_prod_32fc_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_x2_rotator_dot_prod_32fc_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_rotator_dot_prod_32fc_xn volk_gnsssdr_32fc_x2_rotator_dot_prod_32fc_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_x2_rotator_dot_prod_32fc_xn_manual(lv_32fc_t*  result, const lv_32fc_t*  in_common, const lv_32fc_t  phase_inc, lv_32fc_t*  phase, const lv_32fc_t**  in_a, int  num_a_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_x2_rotator_dot_prod_32fc_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_x2_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_x2_rotator_dotprodxnpuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_x2_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_x2_rotator_dotprodxnpuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_x2_rotator_dotprodxnpuppet_32fc volk_gnsssdr_32fc_x2_rotator_dotprodxnpuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_x2_rotator_dotprodxnpuppet_32fc_manual(lv_32fc_t*  result, const lv_32fc_t*  local_code, const lv_32fc_t*  in, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_x2_rotator_dotprodxnpuppet_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_32fc_xn_resampler_32fc_xn volk_gnsssdr_32fc_xn_resampler_32fc_xn;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_32fc_xn_resampler_32fc_xn volk_gnsssdr_32fc_xn_resampler_32fc_xn_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_32fc_xn_resampler_32fc_xn volk_gnsssdr_32fc_xn_resampler_32fc_xn_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_32fc_xn_resampler_32fc_xn_manual(lv_32fc_t**  result, const lv_32fc_t*  local_code, float  rem_code_phase_chips, float  code_phase_step_chips, float*  shifts_chips, unsigned int  code_length_chips, int  num_out_vectors, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_32fc_xn_resampler_32fc_xn_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_64f_accumulator_64f volk_gnsssdr_64f_accumulator_64f;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_64f_accumulator_64f volk_gnsssdr_64f_accumulator_64f_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_64f_accumulator_64f volk_gnsssdr_64f_accumulator_64f_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_64f_accumulator_64f_manual(double*  result, const double*  inputBuffer, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_64f_accumulator_64f_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_accumulator_s8i volk_gnsssdr_8i_accumulator_s8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_accumulator_s8i volk_gnsssdr_8i_accumulator_s8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_accumulator_s8i volk_gnsssdr_8i_accumulator_s8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8i_accumulator_s8i_manual(char*  result, const char*  inputBuffer, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8i_accumulator_s8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_index_max_16u volk_gnsssdr_8i_index_max_16u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_index_max_16u volk_gnsssdr_8i_index_max_16u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_index_max_16u volk_gnsssdr_8i_index_max_16u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8i_index_max_16u_manual(unsigned int*  target, const char*  src0, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8i_index_max_16u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_max_s8i volk_gnsssdr_8i_max_s8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_max_s8i volk_gnsssdr_8i_max_s8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_max_s8i volk_gnsssdr_8i_max_s8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8i_max_s8i_manual(char*  target, const char*  src0, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8i_max_s8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8i_x2_add_8i volk_gnsssdr_8i_x2_add_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8i_x2_add_8i volk_gnsssdr_8i_x2_add_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8i_x2_add_8i volk_gnsssdr_8i_x2_add_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8i_x2_add_8i_manual(char*  cVector, const char*  aVector, const char*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8i_x2_add_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_conjugate_8ic volk_gnsssdr_8ic_conjugate_8ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_conjugate_8ic volk_gnsssdr_8ic_conjugate_8ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_conjugate_8ic volk_gnsssdr_8ic_conjugate_8ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8ic_conjugate_8ic_manual(lv_8sc_t*  cVector, const lv_8sc_t*  aVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8ic_conjugate_8ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_magnitude_squared_8i volk_gnsssdr_8ic_magnitude_squared_8i;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_magnitude_squared_8i volk_gnsssdr_8ic_magnitude_squared_8i_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_magnitude_squared_8i volk_gnsssdr_8ic_magnitude_squared_8i_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8ic_magnitude_squared_8i_manual(char*  magnitudeVector, const lv_8sc_t*  complexVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8ic_magnitude_squared_8i_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_x2_dot_prod_8ic volk_gnsssdr_8ic_x2_dot_prod_8ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_x2_dot_prod_8ic volk_gnsssdr_8ic_x2_dot_prod_8ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_x2_dot_prod_8ic volk_gnsssdr_8ic_x2_dot_prod_8ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8ic_x2_dot_prod_8ic_manual(lv_8sc_t*  result, const lv_8sc_t*  in_a, const lv_8sc_t*  in_b, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8ic_x2_dot_prod_8ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8ic_x2_multiply_8ic volk_gnsssdr_8ic_x2_multiply_8ic;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8ic_x2_multiply_8ic volk_gnsssdr_8ic_x2_multiply_8ic_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8ic_x2_multiply_8ic volk_gnsssdr_8ic_x2_multiply_8ic_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8ic_x2_multiply_8ic_manual(lv_8sc_t*  cVector, const lv_8sc_t*  aVector, const lv_8sc_t*  bVector, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8ic_x2_multiply_8ic_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_8u_x2_multiply_8u volk_gnsssdr_8u_x2_multiply_8u;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_8u_x2_multiply_8u volk_gnsssdr_8u_x2_multiply_8u_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_8u_x2_multiply_8u volk_gnsssdr_8u_x2_multiply_8u_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_8u_x2_multiply_8u_manual(unsigned char*  cChar, const unsigned char*  aChar, const unsigned char*  bChar, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_8u_x2_multiply_8u_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_s32f_sincos_32fc volk_gnsssdr_s32f_sincos_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_s32f_sincos_32fc volk_gnsssdr_s32f_sincos_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_s32f_sincos_32fc volk_gnsssdr_s32f_sincos_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_s32f_sincos_32fc_manual(lv_32fc_t * out, const float  phase_inc, float * phase, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_s32f_sincos_32fc_get_func_desc(void);

//! A function pointer to the dispatcher implementation
extern VOLK_API p_s32f_sincospuppet_32fc volk_gnsssdr_s32f_sincospuppet_32fc;

//! A function pointer to the fastest aligned implementation
extern VOLK_API p_s32f_sincospuppet_32fc volk_gnsssdr_s32f_sincospuppet_32fc_a;

//! A function pointer to the fastest unaligned implementation
extern VOLK_API p_s32f_sincospuppet_32fc volk_gnsssdr_s32f_sincospuppet_32fc_u;

//! Call into a specific implementation given by name
extern VOLK_API void volk_gnsssdr_s32f_sincospuppet_32fc_manual(lv_32fc_t*  out, const float  phase_inc, unsigned int  num_points, const char* impl_name);

//! Get description parameters for this kernel
extern VOLK_API volk_gnsssdr_func_desc_t volk_gnsssdr_s32f_sincospuppet_32fc_get_func_desc(void);
__VOLK_DECL_END
// clang-format on

#endif /* INCLUDED_VOLK_GNSSSDR_RUNTIME */
