# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_vrc_get_global_optspecs
	string join \n h/help V/version
end

function __fish_vrc_get_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_vrc_get_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_vrc_get_using_subcommand
	set -l cmd (__fish_vrc_get_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c vrc-get -n "__fish_vrc_get_needs_command" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "install" -d 'Adds package to unity project'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "resolve" -d '(re)installs all locked packages'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "remove" -d 'Remove package from Unity project'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "reinstall" -d 'Reinstall specified packages'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "update" -d 'Update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "outdated" -d 'Show list of outdated packages'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "upgrade" -d 'Upgrade specified package or all packages to latest or specified version'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "downgrade" -d 'Downgrade the specified package specified version'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "search" -d 'Search package by the query'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "repo" -d 'Commands around repositories'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "user-package" -d 'Commands around user packages'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "info" -d 'Shows information for other program'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "migrate" -d 'Migrate Unity Project'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "cache" -d 'Commands about cache control'
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "vcc"
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "completion"
complete -c vrc-get -n "__fish_vrc_get_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -l prerelease -d 'Include prerelease'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -s n -l name -d 'Install package by display name instead of name'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand install" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand resolve" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand resolve" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand resolve" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand resolve" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand resolve" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand remove" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand reinstall" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand update" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand update" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -l json-format -d 'With this option, output is printed in json format' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -l prerelease -d 'Include prerelease'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand outdated" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -l prerelease -d 'Include prerelease'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand upgrade" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -l prerelease -d 'Include prerelease'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand downgrade" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand search" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand search" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand search" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand search" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "list" -d 'List all repositories'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "add" -d 'Add remote or local repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "remove" -d 'Remove repository with specified url, path or name'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "cleanup" -d 'Cleanup repositories in Repos directory'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "packages" -d 'List packages in specified repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "import" -d 'Import repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "export" -d 'Export user repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and not __fish_seen_subcommand_from list add remove cleanup packages import export help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from list" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from list" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from list" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from add" -s H -l header -d 'Headers' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from add" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from add" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from add" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l id -d 'Find repository to remove by id'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l url -d 'Find repository to remove by url'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l name -d 'Find repository to remove by name'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l path -d 'Find repository to remove by local path'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from remove" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from cleanup" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from cleanup" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from cleanup" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from cleanup" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from packages" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from packages" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from packages" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from packages" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from import" -s y -l yes -d 'skip confirm'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from import" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from import" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from import" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from export" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from export" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from export" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from export" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all repositories'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add remote or local repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove repository with specified url, path or name'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "cleanup" -d 'Cleanup repositories in Repos directory'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "packages" -d 'List packages in specified repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "import" -d 'Import repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "export" -d 'Export user repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand repo; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -f -a "list" -d 'List all user packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -f -a "add" -d 'Add user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -f -a "remove" -d 'Remove user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and not __fish_seen_subcommand_from list add remove help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from list" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from add" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from remove" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from help" -f -a "list" -d 'List all user packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand user-package; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and not __fish_seen_subcommand_from project package help" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and not __fish_seen_subcommand_from project package help" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and not __fish_seen_subcommand_from project package help" -f -a "project" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and not __fish_seen_subcommand_from project package help" -f -a "package" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and not __fish_seen_subcommand_from project package help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from project" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from project" -l json-format -d 'Output json format' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from project" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from project" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from package" -l json-format -d 'Output json format' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from package" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from package" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from package" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from package" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from help" -f -a "project" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from help" -f -a "package" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand info; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and not __fish_seen_subcommand_from unity2022 vpm help" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and not __fish_seen_subcommand_from unity2022 vpm help" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and not __fish_seen_subcommand_from unity2022 vpm help" -f -a "unity2022" -d 'Migrate your project to Unity 2022'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and not __fish_seen_subcommand_from unity2022 vpm help" -f -a "vpm" -d 'Migrate your legacy (unitypackage) VRCSDK project to VPM project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and not __fish_seen_subcommand_from unity2022 vpm help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from unity2022" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from unity2022" -l unity -d 'Path to unity 2022 executable' -r -F
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from unity2022" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from unity2022" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from unity2022" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from vpm" -s p -l project -d 'Path to project dir. by default CWD or parents of CWD will be used' -r
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from vpm" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from vpm" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from vpm" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from help" -f -a "unity2022" -d 'Migrate your project to Unity 2022'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from help" -f -a "vpm" -d 'Migrate your legacy (unitypackage) VRCSDK project to VPM project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand migrate; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and not __fish_seen_subcommand_from clear help" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and not __fish_seen_subcommand_from clear help" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and not __fish_seen_subcommand_from clear help" -f -a "clear" -d 'Cleanup package cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and not __fish_seen_subcommand_from clear help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from clear" -l offline -d 'do not connect to remote servers, use local caches only. implicitly --no-update'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from clear" -l no-update -d 'do not update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from clear" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from clear" -s V -l version -d 'Print version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from help" -f -a "clear" -d 'Cleanup package cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand cache; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand vcc" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand completion" -s h -l help -d 'Print help'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "install" -d 'Adds package to unity project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "resolve" -d '(re)installs all locked packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "remove" -d 'Remove package from Unity project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "reinstall" -d 'Reinstall specified packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "update" -d 'Update local repository cache'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "outdated" -d 'Show list of outdated packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "upgrade" -d 'Upgrade specified package or all packages to latest or specified version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "downgrade" -d 'Downgrade the specified package specified version'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "search" -d 'Search package by the query'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "repo" -d 'Commands around repositories'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "user-package" -d 'Commands around user packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "info" -d 'Shows information for other program'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "migrate" -d 'Migrate Unity Project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "cache" -d 'Commands about cache control'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "vcc"
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "completion"
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and not __fish_seen_subcommand_from install resolve remove reinstall update outdated upgrade downgrade search repo user-package info migrate cache vcc completion help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "list" -d 'List all repositories'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "add" -d 'Add remote or local repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "remove" -d 'Remove repository with specified url, path or name'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "cleanup" -d 'Cleanup repositories in Repos directory'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "packages" -d 'List packages in specified repository'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "import" -d 'Import repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from repo" -f -a "export" -d 'Export user repository list file'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from user-package" -f -a "list" -d 'List all user packages'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from user-package" -f -a "add" -d 'Add user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from user-package" -f -a "remove" -d 'Remove user package'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from info" -f -a "project" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from info" -f -a "package" -d 'Show project information'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from migrate" -f -a "unity2022" -d 'Migrate your project to Unity 2022'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from migrate" -f -a "vpm" -d 'Migrate your legacy (unitypackage) VRCSDK project to VPM project'
complete -c vrc-get -n "__fish_vrc_get_using_subcommand help; and __fish_seen_subcommand_from cache" -f -a "clear" -d 'Cleanup package cache'
