/*
 * Decompiled with CFR 0.152.
 */
package vrpn;

import java.util.Date;
import vrpn.VRPN;
import vrpn.VRPNDevice;

public abstract class VRPNDevice
extends VRPN
implements Runnable {
    public static final int vrpn_TEXT_NORMAL = 0;
    public static final int vrpn_TEXT_WARNING = 1;
    public static final int vrpn_TEXT_ERROR = 2;
    public static final Date vrpn_TEXT_NOW = new Date(0L);
    protected long native_device = -1L;
    protected boolean keepRunning = true;
    Thread deviceThread = null;
    protected long mainloopPeriod = 100L;
    protected String connectionName = null;
    protected String localInLogfileName = null;
    protected String localOutLogfileName = null;
    protected String remoteInLogfileName = null;
    protected String remoteOutLogfileName = null;
    protected boolean liveReplayValid = false;
    protected boolean replay = false;
    protected boolean earliestTimeValid = false;
    protected Date earliestTime = new Date();
    protected boolean latestTimeValid = false;
    protected Date latestTime = new Date();

    public static String getTextSeverityString(int n) {
        switch (n) {
            case 0: {
                return "vrpn_TEXT_NORMAL";
            }
            case 1: {
                return "vrpn_TEXT_WARNING";
            }
            case 2: {
                return "vrpn_TEXT_ERROR";
            }
        }
        return "(unknown severity)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VRPNDevice(String string, String string2, String string3, String string4, String string5) throws InstantiationException {
        this.connectionName = string;
        this.localInLogfileName = string2;
        this.localOutLogfileName = string3;
        this.remoteInLogfileName = string4;
        this.remoteOutLogfileName = string5;
        try {
            Object object = downInVrpnLock;
            synchronized (object) {
                this.init(string, string2, string3, string4, string5);
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.out.println("Error initializing remote device " + string + ".");
            System.out.println(" -- Unable to find the right functions.  This may be a version problem.");
            throw new InstantiationException(unsatisfiedLinkError.getMessage());
        }
        this.deviceThread = new Thread((Runnable)this, "vrpn " + this.getClass().getName());
        this.deviceThread.start();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getLocalInLogfileName() {
        return this.localInLogfileName;
    }

    public String getLocalOutLogfileName() {
        return this.localOutLogfileName;
    }

    public String getRemoteInLogfileName() {
        return this.remoteInLogfileName;
    }

    public String getRemoteOutLogfileName() {
        return this.remoteOutLogfileName;
    }

    public final synchronized void setTimerPeriod(long l) {
        this.mainloopPeriod = l;
    }

    public final synchronized long getTimerPeriod() {
        return this.mainloopPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean doingOkay() {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.doingOkay_native();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isConnected() {
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.isConnected_native();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLive() {
        if (this.liveReplayValid) {
            return !this.replay;
        }
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.isLive_native();
        }
        this.replay = !bl;
        return bl;
    }

    public final boolean isReplay() {
        return !this.isLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getElapsedTimeSecs() {
        long l = 0L;
        Object object = downInVrpnLock;
        synchronized (object) {
            l = this.getElapsedTimeSecs_native();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getTime() {
        Date date = new Date(0L);
        Object object = downInVrpnLock;
        synchronized (object) {
            this.getTime_native(date);
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReplayRate(float f) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        Object object = downInVrpnLock;
        synchronized (object) {
            this.setReplayRate_native(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean reset() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.reset_native();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean eof() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.eof_native();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean playToElapsedTime(long l) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.playToElapsedTime_native(l);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean playToWallTime(Date date) throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        boolean bl = false;
        Object object = downInVrpnLock;
        synchronized (object) {
            bl = this.playToWallTime_native(date);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double getLengthSecs() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        double d = -1.0;
        Object object = downInVrpnLock;
        synchronized (object) {
            d = this.getLengthSecs_native();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final float getReplayRate() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        float f = -1.0f;
        Object object = downInVrpnLock;
        synchronized (object) {
            f = this.getReplayRate_native();
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getEarliestTime() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        if (!this.earliestTimeValid) {
            Object object = downInVrpnLock;
            synchronized (object) {
                boolean bl = this.getEarliestTime_native(this.earliestTime);
                if (!bl) {
                    this.earliestTime.setTime(0L);
                } else {
                    this.earliestTimeValid = true;
                }
            }
        }
        return this.earliestTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Date getLatestTime() throws NotReplayError {
        if (this.isLive()) {
            throw new NotReplayError(this, "a live device");
        }
        if (!this.latestTimeValid) {
            Object object = downInVrpnLock;
            synchronized (object) {
                boolean bl = this.getLatestTime_native(this.latestTime);
                if (!bl) {
                    this.latestTime.setTime(0L);
                } else {
                    this.latestTimeValid = true;
                }
            }
        }
        return this.latestTime;
    }

    public final void stopRunning() {
        this.keepRunning = false;
        while (this.deviceThread.isAlive()) {
            try {
                this.deviceThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stoppedRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (this.keepRunning) {
            Object object = downInVrpnLock;
            synchronized (object) {
                this.mainloop();
            }
            try {
                Thread.sleep(this.mainloopPeriod);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void finalize() throws Throwable {
        this.stopRunning();
    }

    protected native boolean isLive_native();

    protected native boolean doingOkay_native();

    protected native boolean isConnected_native();

    protected native long getElapsedTimeSecs_native();

    protected native void setReplayRate_native(float var1);

    protected native float getReplayRate_native();

    protected native boolean reset_native();

    protected native boolean eof_native();

    protected native boolean playToElapsedTime_native(long var1);

    protected native boolean playToWallTime_native(Date var1);

    protected native double getLengthSecs_native();

    protected native boolean getEarliestTime_native(Date var1);

    protected native boolean getLatestTime_native(Date var1);

    protected native boolean getTime_native(Date var1);

    protected abstract void mainloop();

    protected abstract boolean init(String var1, String var2, String var3, String var4, String var5);

    protected abstract void stoppedRunning();

    private VRPNDevice() {
    }
}

