/*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#pragma once

#include <folly/Range.h>
#include <folly/container/Array.h>

constexpr folly::StringPiece validTicketData =
    R"JSON({
    "new": [
      "0000111122223333444455556666777788889999aaaabbbbccccddddeeeeffff",
      "111122223333444455556666777788889999aaaabbbbccccddddeeeeffff0000"
    ],
    "current": [
      "0000111122223333444455556666777788889999aaaabbbbccccddddeeeeffff"
    ]
  })JSON";

// Has invalid strict json structure.
constexpr folly::StringPiece invalidTicketData =
    R"JSON({
    'new': [
      "0000111122223333444455556666777788889999aaaabbbbccccddddeeeeffff',
      "111122223333444455556666777788889999aaaabbbbccccddddeeeeffff0000"
    ],
    "current": [
      "0000111122223333444455556666777788889999aaaabbbbccccddddeeeeffff"
    ],
  })JSON";

// clang-format off
/* Generated using
 * $ openssl enc -e -md sha256 -aes-256-cbc -pass file:<passwordfile>
 * on the validTicketData JSON
 */
auto encryptedTicketData = folly::make_array<unsigned char>(
  0x53, 0x61, 0x6c, 0x74, 0x65, 0x64, 0x5f, 0x5f, 0x10, 0xa1, 0x39, 0x3f, 0xdc,
  0xc0, 0xce, 0xcd, 0x31, 0xeb, 0x7e, 0x4a, 0xab, 0xd2, 0x94, 0xa1, 0xbc, 0x04,
  0x93, 0xb2, 0xb3, 0x86, 0xf9, 0xd2, 0x54, 0x64, 0x66, 0x8a, 0x83, 0x56, 0x3d,
  0x5c, 0xd8, 0xbc, 0xde, 0x1b, 0x5c, 0xfb, 0x05, 0xbe, 0x1a, 0x84, 0x10, 0x68,
  0xf4, 0x73, 0xce, 0x09, 0xa1, 0x09, 0x94, 0x72, 0xab, 0xdc, 0xb5, 0xa0, 0x45,
  0x99, 0xbb, 0x68, 0x63, 0xde, 0x6f, 0x0c, 0x73, 0x22, 0x46, 0xb7, 0x70, 0xe9,
  0xc4, 0x04, 0xe3, 0x37, 0xce, 0x3e, 0x95, 0x38, 0x39, 0xf8, 0x64, 0x8e, 0x52,
  0x52, 0x87, 0x88, 0xf7, 0x88, 0xa6, 0x9b, 0x47, 0xe2, 0x81, 0xf9, 0x41, 0x06,
  0xac, 0x62, 0x62, 0xfb, 0x5f, 0x37, 0x80, 0xbf, 0xda, 0x36, 0x4a, 0xef, 0xee,
  0x8a, 0x49, 0x48, 0x96, 0xb3, 0x84, 0x20, 0x9f, 0x53, 0x54, 0x7b, 0xd4, 0x68,
  0x81, 0x13, 0x81, 0x45, 0x9b, 0x0a, 0x50, 0x08, 0x88, 0x96, 0xac, 0x4e, 0xf1,
  0x70, 0x64, 0x74, 0x16, 0x78, 0x66, 0x9f, 0x6a, 0x4f, 0x03, 0xba, 0x08, 0xad,
  0x7b, 0x51, 0xcd, 0x32, 0x86, 0x92, 0x74, 0x6e, 0x34, 0x48, 0x18, 0xd7, 0x8e,
  0xa8, 0xed, 0xcd, 0xd0, 0x77, 0x28, 0x69, 0x40, 0xe9, 0x14, 0x0c, 0xc2, 0x6e,
  0xc2, 0xc1, 0xb2, 0xef, 0xcf, 0x60, 0x7e, 0x0c, 0xbc, 0x9f, 0xd5, 0x1e, 0x7a,
  0xa6, 0x37, 0x60, 0xa1, 0xc4, 0xba, 0x84, 0x33, 0xfb, 0x96, 0xa3, 0x53, 0x93,
  0x6c, 0x94, 0x08, 0x45, 0x8f, 0x0f, 0x5c, 0x6e, 0x58, 0x3e, 0xd5, 0x0d, 0xc5,
  0xdb, 0xab, 0xcc, 0x83, 0x9d, 0x98, 0xb8, 0x19, 0xda, 0xf7, 0x10, 0x5d, 0x55,
  0x9a, 0xa3, 0xba, 0xd7, 0x38, 0xc0, 0xb7, 0x08, 0xaa, 0xba, 0x46, 0x94, 0xe8,
  0xfa, 0xc7, 0x4b, 0x9e, 0x58, 0x87, 0x47, 0x2b, 0x01, 0x7c, 0x1e, 0x8a, 0x94,
  0x64, 0xa9, 0x7d, 0x3e, 0xc6, 0x2a, 0xa6, 0x7c, 0x71, 0xf5, 0x8e, 0xdb
);

// Randomly generated password
auto ticketPasswordData = folly::make_array<unsigned char>(
  0xb3, 0x81, 0x0c, 0x8c, 0x37, 0x25, 0x17, 0x3e, 0xea, 0x4f, 0xa1, 0xcc, 0xb0,
  0x96, 0x06, 0x3e, 0x05, 0x3f, 0x8f, 0x75, 0x23, 0xcb, 0xbf, 0x1a, 0xe7, 0xc3,
  0xd6, 0x80, 0x81, 0x99, 0xfb, 0xdb
);
// clang-format on

// String versions of arrays above
const std::string encryptedTicketString = std::string(
    reinterpret_cast<char*>(encryptedTicketData.data()),
    encryptedTicketData.size());

const std::string ticketPasswordString = std::string(
    reinterpret_cast<char*>(ticketPasswordData.data()),
    ticketPasswordData.size());
