############################################################################
# Copyright (c) 2018, Martin Renou, Johan Mabille, Sylvain Corlay and      #
# Wolf Vollprecht, Mariana Meireles                                        #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xeus-sqlite cmake module
# This module sets the following variables in your project::
#
#   xeus-sqlite_FOUND - true if xeus-sqlite found on the system
#   xeus-sqlite_INCLUDE_DIRS - the directory containing xeus-sqlite headers
#   xeus-sqlite_LIBRARY - the library for dynamic linking
#   xeus-sqlite_STATIC_LIBRARY - the library for static linking


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xeus-sqliteConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")



include(CMakeFindDependencyMacro)
find_dependency(xeus )
find_dependency(cppzmq )
find_dependency(SQLite3 )
find_dependency(xvega )
find_dependency(SQLiteCpp )
find_dependency(tabulate 1.5)
find_dependency(Threads )

if (NOT TARGET xeus-sqlite)
    include("${CMAKE_CURRENT_LIST_DIR}/xeus-sqliteTargets.cmake")

    get_target_property(xeus-sqlite_INCLUDE_DIR xeus-sqlite INTERFACE_INCLUDE_DIRECTORIES)
    get_target_property(xeus-sqlite_LIBRARY xeus-sqlite LOCATION)

    if (TARGET xeus-sqlite-static)
        get_target_property(xeus-sqlite_STATIC_LIBRARY xeus-sqlite-static LOCATION)
    endif ()
endif ()
